/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;

public class TreeShapedStack<T> {
    final T data;
    final int size;
    final TreeShapedStack<T> previous;

    public TreeShapedStack() {
        this(null, null, 0);
    }

    private TreeShapedStack(TreeShapedStack<T> previous, T data, int size) {
        this.previous = previous;
        this.data = data;
        this.size = size;
    }

    public TreeShapedStack<T> pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.previous;
    }

    public TreeShapedStack<T> push(T data) {
        return new TreeShapedStack<T>(this, data, this.size + 1);
    }

    public T peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data;
    }

    public int size() {
        return this.size;
    }

    public List<T> asList() {
        ArrayList<T> result = Generics.newArrayList(this.size);
        TreeShapedStack<T> current = this;
        for (int index = 0; index < this.size; ++index) {
            result.add(current.data);
            current = current.pop();
        }
        Collections.reverse(result);
        return result;
    }

    public String toString() {
        return "[" + this.internalToString(" ") + "]";
    }

    public String toString(String delimiter) {
        return "[" + this.internalToString(delimiter) + "]";
    }

    private String internalToString(String delimiter) {
        if (this.size() == 0) {
            return " ";
        }
        if (this.size() == 1) {
            return this.data.toString();
        }
        return super.internalToString(delimiter) + "," + delimiter + this.data.toString();
    }

    public int hashCode() {
        int hash = this.size();
        if (this.size() > 0 && this.peek() != null) {
            hash ^= this.peek().hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeShapedStack)) {
            return false;
        }
        TreeShapedStack<T> other = (TreeShapedStack<T>)o;
        TreeShapedStack<T> current = this;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            T otherObject;
            T currentObject = current.peek();
            if (!(currentObject == (otherObject = other.peek()) || currentObject != null && currentObject.equals(otherObject))) {
                return false;
            }
            other = other.pop();
            current = current.pop();
        }
        return true;
    }
}

