/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.RecursiveTreeTransformer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Function;

public class BasicCategoryTreeTransformer
extends RecursiveTreeTransformer
implements Function<Tree, Tree> {
    final TreebankLanguagePack tlp;

    public BasicCategoryTreeTransformer(TreebankLanguagePack tlp) {
        this.tlp = tlp;
    }

    @Override
    public Label transformNonterminalLabel(Tree tree) {
        if (tree.label() == null) {
            return null;
        }
        return tree.label().labelFactory().newLabel(this.tlp.basicCategory(tree.label().value()));
    }

    @Override
    public Tree apply(Tree tree) {
        return this.transformTree(tree);
    }
}

