/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.shiftreduce.FeatureFactory;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.tagger.maxent.Distsim;
import java.util.List;

public class DistsimFeatureFactory
extends FeatureFactory {
    private final Distsim distsim;
    private static final long serialVersionUID = -396152777907151063L;

    DistsimFeatureFactory() {
        throw new UnsupportedOperationException("Illegal construction of DistsimFeatureFactory.  It must be created with a path to a cluster file");
    }

    DistsimFeatureFactory(String path) {
        this.distsim = Distsim.initLexicon(path);
    }

    public void addDistsimFeatures(List<String> features, CoreLabel label, String featureName) {
        if (label == null) {
            return;
        }
        String word = DistsimFeatureFactory.getFeatureFromCoreLabel(label, FeatureFactory.FeatureComponent.HEADWORD);
        String tag = DistsimFeatureFactory.getFeatureFromCoreLabel(label, FeatureFactory.FeatureComponent.HEADTAG);
        String cluster = this.distsim.getMapping(word);
        features.add(featureName + "dis-" + cluster);
        features.add(featureName + "disT-" + cluster + "-" + tag);
    }

    @Override
    public List<String> featurize(State state, List<String> features) {
        CoreLabel s0Label = DistsimFeatureFactory.getStackLabel(state.stack, 0, new FeatureFactory.Transition[0]);
        CoreLabel s1Label = DistsimFeatureFactory.getStackLabel(state.stack, 1, new FeatureFactory.Transition[0]);
        CoreLabel q0Label = DistsimFeatureFactory.getQueueLabel(state.sentence, state.tokenPosition, 0);
        this.addDistsimFeatures(features, s0Label, "S0");
        this.addDistsimFeatures(features, s1Label, "S1");
        this.addDistsimFeatures(features, q0Label, "Q0");
        return features;
    }
}

