/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.parser.lexparser.TrainOptions;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import java.util.Set;

public class LinearGrammarSmoother
implements Function<Pair<UnaryGrammar, BinaryGrammar>, Pair<UnaryGrammar, BinaryGrammar>> {
    private static final boolean DEBUG = false;
    private double ALPHA = 0.01;
    private final String[] annotationIntroducingChars = new String[]{"-", "=", "|", "#", "^", "~", "_"};
    private final Set<String> annoteChars = Generics.newHashSet(Arrays.asList(this.annotationIntroducingChars));
    private final TrainOptions trainOptions;
    private final Index<String> stateIndex;
    private final Index<String> tagIndex;

    public LinearGrammarSmoother(TrainOptions trainOptions, Index<String> stateIndex, Index<String> tagIndex) {
        this.trainOptions = trainOptions;
        this.stateIndex = stateIndex;
        this.tagIndex = tagIndex;
    }

    @Override
    public Pair<UnaryGrammar, BinaryGrammar> apply(Pair<UnaryGrammar, BinaryGrammar> bgug) {
        this.ALPHA = this.trainOptions.ruleSmoothingAlpha;
        ClassicCounter<String> symWeights = new ClassicCounter<String>();
        ClassicCounter<String> symCounts = new ClassicCounter<String>();
        for (Comparable<UnaryRule> rule : bgug.first()) {
            if (this.tagIndex.contains(rule.parent)) continue;
            this.updateCounters((Rule)((Object)rule), (Counter<String>)symWeights, (Counter<String>)symCounts);
        }
        for (Comparable<UnaryRule> rule : bgug.second()) {
            this.updateCounters((Rule)((Object)rule), (Counter<String>)symWeights, (Counter<String>)symCounts);
        }
        for (Comparable<UnaryRule> rule : bgug.first()) {
            if (this.tagIndex.contains(rule.parent)) continue;
            rule.score = this.smoothRuleWeight((Rule)((Object)rule), (Counter<String>)symWeights, (Counter<String>)symCounts);
        }
        for (Comparable<UnaryRule> rule : bgug.second()) {
            ((BinaryRule)rule).score = this.smoothRuleWeight((Rule)((Object)rule), (Counter<String>)symWeights, (Counter<String>)symCounts);
        }
        return bgug;
    }

    private void updateCounters(Rule rule, Counter<String> symWeights, Counter<String> symCounts) {
        String label = this.stateIndex.get(rule.parent());
        String basicCat = this.basicCategory(label);
        symWeights.incrementCount(basicCat, Math.exp(rule.score()));
        symCounts.incrementCount(basicCat);
    }

    private float smoothRuleWeight(Rule rule, Counter<String> symWeights, Counter<String> symCounts) {
        String label = this.stateIndex.get(rule.parent());
        String basicCat = this.basicCategory(label);
        double pSum = symWeights.getCount(basicCat);
        double n = symCounts.getCount(basicCat);
        double pRule = Math.exp(rule.score());
        double pSmooth = (1.0 - this.ALPHA) * pRule;
        pSmooth += this.ALPHA * (pSum / n);
        pSmooth = Math.log(pSmooth);
        return (float)pSmooth;
    }

    private int postBasicCategoryIndex(String category) {
        int i;
        boolean sawAtZero = false;
        String seenAtZero = "\u0000";
        for (i = 0; i < category.length(); ++i) {
            String ch = category.substring(i, i + 1);
            if (!this.annoteChars.contains(ch)) continue;
            if (i == 0) {
                sawAtZero = true;
                seenAtZero = ch;
                continue;
            }
            if (!sawAtZero || ch != seenAtZero) break;
            sawAtZero = false;
        }
        return i;
    }

    public String basicCategory(String category) {
        if (category == null) {
            return null;
        }
        String basicCat = category.substring(0, this.postBasicCategoryIndex(category));
        return basicCat;
    }
}

