/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.maxent.Features;

public class Problem {
    public int exSize;
    public int fSize;
    public Experiments data;
    public Features functions;

    public Problem(Experiments d, Features f) {
        this.data = d;
        this.functions = f;
        this.exSize = d.size();
        this.fSize = f.size();
    }

    public Problem() {
    }

    public void add(Feature f) {
        this.functions.add(f);
        ++this.fSize;
    }

    public void removeLast() {
        this.functions.removeLast();
        --this.fSize;
    }

    public void print() {
        System.out.println(" Problem printing ");
        this.data.print();
        System.out.println(" Function printing ");
        for (int i = 0; i < this.fSize; ++i) {
            this.functions.get(i).print();
        }
    }

    public void print(String filename) {
        try {
            PrintFile pf = new PrintFile(filename);
            pf.println(" Problem printing ");
            this.data.print(pf);
            pf.println(" Function printing ");
            for (int i = 0; i < this.fSize; ++i) {
                this.functions.get(i).print(pf);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in Problem.print()");
        }
    }
}

