/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import java.util.Collection;
import java.util.Collections;

public class RVFDatum<L, F>
implements Datum<L, F> {
    private static final long serialVersionUID = -255312811814660438L;
    private final Counter<F> features;
    private L label;
    private String id = null;

    public RVFDatum(Counter<F> features, L label) {
        this.features = features;
        this.setLabel(label);
    }

    public RVFDatum(Datum<L, F> m) {
        this.features = new ClassicCounter<F>();
        for (Object key : m.asFeatures()) {
            this.features.incrementCount(key, 1.0);
        }
        this.setLabel(m.label());
    }

    public RVFDatum(Counter<F> features) {
        this.features = features;
    }

    public RVFDatum() {
        this((ClassicCounter)null);
    }

    public Counter<F> asFeaturesCounter() {
        return this.features;
    }

    @Override
    public Collection<F> asFeatures() {
        return this.features.keySet();
    }

    public void setLabel(L label) {
        this.label = label;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String toString() {
        return "RVFDatum[features=" + this.asFeaturesCounter() + ",label=" + this.label() + "]";
    }

    @Override
    public L label() {
        return this.label;
    }

    @Override
    public Collection<L> labels() {
        return Collections.singletonList(this.label);
    }

    public double getFeatureCount(F feature) {
        return this.features.getCount(feature);
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RVFDatum)) {
            return false;
        }
        RVFDatum d = (RVFDatum)o;
        return this.features.equals(d.asFeaturesCounter());
    }

    public int hashCode() {
        return this.features.hashCode();
    }
}

