/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.process;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.Characters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PaddedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class ArabicSegmenterFeatureFactory<IN extends CoreLabel>
extends FeatureFactory<IN> {
    private static final long serialVersionUID = -4560226365250020067L;
    private static final String DOMAIN_MARKER = "@";
    private static final int MAX_BEFORE = 5;
    private static final int MAX_AFTER = 9;
    private static final int MAX_LENGTH = 10;

    @Override
    public void init(SeqClassifierFlags flags) {
        super.init(flags);
    }

    @Override
    public Collection<String> getCliqueFeatures(PaddedList<IN> cInfo, int loc, Clique clique) {
        Set<String> features = Generics.newHashSet();
        if (clique == cliqueC) {
            this.addAllInterningAndSuffixing(features, this.featuresC(cInfo, loc), "C");
        } else if (clique == cliqueCpC) {
            this.addAllInterningAndSuffixing(features, this.featuresCpC(cInfo, loc), "CpC");
        } else if (clique == cliqueCp2C) {
            this.addAllInterningAndSuffixing(features, this.featuresCp2C(cInfo, loc), "Cp2C");
        } else if (clique == cliqueCp3C) {
            this.addAllInterningAndSuffixing(features, this.featuresCp3C(cInfo, loc), "Cp3C");
        }
        String domain = (String)((CoreLabel)cInfo.get(loc)).get(CoreAnnotations.DomainAnnotation.class);
        if (domain != null) {
            Set<String> domainFeatures = Generics.newHashSet();
            for (String feature : features) {
                domainFeatures.add(feature + DOMAIN_MARKER + domain);
            }
            features.addAll(domainFeatures);
        }
        return features;
    }

    protected Collection<String> featuresC(PaddedList<IN> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel n = (CoreLabel)cInfo.get(loc + 1);
        CoreLabel n2 = (CoreLabel)cInfo.get(loc + 2);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        String charc = (String)c.get(CoreAnnotations.CharAnnotation.class);
        String charn = (String)n.get(CoreAnnotations.CharAnnotation.class);
        String charn2 = (String)n2.get(CoreAnnotations.CharAnnotation.class);
        String charp = (String)p.get(CoreAnnotations.CharAnnotation.class);
        String charp2 = (String)p2.get(CoreAnnotations.CharAnnotation.class);
        features.add(charc + "-c");
        features.add(charn + "-n1");
        features.add(charn2 + "-n2");
        features.add(charp + "-p");
        features.add(charp2 + "-p2");
        if (charc.length() > 1) {
            features.add("length");
        }
        boolean seenPunc = false;
        boolean seenDigit = false;
        int limit = charc.length();
        for (int i = 0; i < limit; ++i) {
            char charcC = charc.charAt(i);
            seenPunc = seenPunc || Characters.isPunctuation(charcC);
            seenDigit = seenDigit || Character.isDigit(charcC);
            String cuBlock = Characters.unicodeBlockStringOf(charcC);
            features.add(cuBlock + "-uBlock");
            String cuType = String.valueOf(Character.getType(charcC));
            features.add(cuType + "-uType");
        }
        if (seenPunc) {
            features.add("haspunc");
        }
        if (seenDigit) {
            features.add("hasdigit");
        }
        String word = c.word();
        int index = c.index();
        features.add(Math.min(5, index) + "-before");
        features.add(Math.min(9, word.length() - charc.length() - index) + "-after");
        features.add(Math.min(10, word.length()) + "-length");
        features.add("cliqueC");
        return features;
    }

    protected Collection<String> featuresCpC(PaddedList<IN> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        String charc = (String)c.get(CoreAnnotations.CharAnnotation.class);
        String charp = (String)p.get(CoreAnnotations.CharAnnotation.class);
        features.add(charc + charp + "-cngram");
        features.add("cliqueCpC");
        return features;
    }

    protected Collection<String> featuresCp2C(PaddedList<IN> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        String charc = (String)c.get(CoreAnnotations.CharAnnotation.class);
        String charp = (String)p.get(CoreAnnotations.CharAnnotation.class);
        String charp2 = (String)p2.get(CoreAnnotations.CharAnnotation.class);
        features.add(charc + charp + charp2 + "-cngram");
        features.add("cliqueCp2C");
        return features;
    }

    protected Collection<String> featuresCp3C(PaddedList<IN> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        CoreLabel p = (CoreLabel)cInfo.get(loc - 1);
        CoreLabel p2 = (CoreLabel)cInfo.get(loc - 2);
        CoreLabel p3 = (CoreLabel)cInfo.get(loc - 3);
        String charc = (String)c.get(CoreAnnotations.CharAnnotation.class);
        String charp = (String)p.get(CoreAnnotations.CharAnnotation.class);
        String charp2 = (String)p2.get(CoreAnnotations.CharAnnotation.class);
        String charp3 = (String)p3.get(CoreAnnotations.CharAnnotation.class);
        features.add(charc + charp + charp2 + charp3 + "-cngram");
        features.add("cliqueCp3C");
        return features;
    }
}

