/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import java.io.FileNotFoundException;
import java.io.PrintStream;

public class GenerateInverseFromMinor {
    String className = "UnrolledInverseFromMinor";
    PrintStream stream = new PrintStream(this.className + ".java");
    int N;

    public void createClass(int N) {
        this.printTop(N);
        this.printCalls(N);
        for (int i = 2; i <= N; ++i) {
            this.printFunction(i);
        }
        this.stream.print("}\n");
    }

    private void printTop(int N) {
        String foo = "/*\n * Copyright (c) 2009-2010, Peter Abeles. All Rights Reserved.\n *\n * This file is part of Efficient Java Matrix Library (EJML).\n *\n * EJML is free software: you can redistribute it and/or modify\n * it under the terms of the GNU Lesser General Public License as\n * published by the Free Software Foundation, either version 3\n * of the License, or (at your option) any later version.\n *\n * EJML is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with EJML.  If not, see <http://www.gnu.org/licenses/>.\n */\n\npackage org.ejml.alg.dense.misc;\n\nimport org.ejml.data.DenseMatrix64F;\n\n\n/**\n * This code was auto generated by  {@link GenerateInverseFromMinor} and should not be modified\n * directly.  The input matrix is scaled make it much less prone to overflow and underflow issues.\n * \n * @author Peter Abeles\n */\npublic class " + this.className + " {\n" + "    \n" + "    public static final int MAX = " + N + ";\n";
        this.stream.print(foo);
    }

    private void printCalls(int N) {
        this.stream.print("    \n    public static void inv( DenseMatrix64F mat , DenseMatrix64F inv ) {\n");
        this.stream.print("        double max = Math.abs(mat.data[0]);\n        int N = mat.getNumElements();\n        \n        for( int i = 1; i < N; i++ ) {\n            double a = Math.abs(mat.data[i]);\n            if( a > max ) max = a;\n        }\n\n");
        this.stream.print("        if( mat.numRows == 2 ) {\n            inv2(mat,inv,1.0/max);\n");
        for (int i = 3; i <= N; ++i) {
            this.stream.print("        } else if( mat.numRows == " + i + " ) {\n" + "            inv" + i + "(mat,inv,1.0/max);            \n");
        }
        this.stream.print("        } else {\n            throw new IllegalArgumentException(\"Not supported\");\n        }\n    }\n\n");
    }

    private void printFunction(int N) {
        int j;
        int i;
        this.stream.print("    public static void inv" + N + "( DenseMatrix64F mat , DenseMatrix64F inv , double scale )\n" + "    {\n" + "        double []data = mat.data;\n" + "\n");
        this.N = N;
        int[] matrix = new int[N * N];
        int index = 0;
        for (i = 1; i <= N; ++i) {
            j = 1;
            while (j <= N) {
                matrix[index] = index;
                this.stream.print("        double " + this.a(index) + " = data[ " + index + " ]*scale;\n");
                ++j;
                ++index;
            }
        }
        this.stream.println();
        index = 0;
        for (i = 1; i <= N; ++i) {
            j = 1;
            while (j <= N) {
                this.stream.print("        double m" + i + "" + j + " = ");
                if ((i + j) % 2 == 1) {
                    this.stream.print("-( ");
                }
                this.printTopMinor(matrix, i - 1, j - 1, N);
                if ((i + j) % 2 == 1) {
                    this.stream.print(")");
                }
                this.stream.print(";\n");
                ++j;
                ++index;
            }
        }
        this.stream.println();
        this.stream.print("        double det = (a11*m11");
        for (i = 2; i <= N; ++i) {
            this.stream.print(" + " + this.a(i - 1) + "*m" + 1 + "" + i);
        }
        this.stream.println(")/scale;");
        this.stream.println();
        this.stream.print("        data = inv.data;\n");
        index = 0;
        for (i = 1; i <= N; ++i) {
            j = 1;
            while (j <= N) {
                this.stream.print("        data[" + index + "] = m" + j + "" + i + " / det;\n");
                ++j;
                ++index;
            }
        }
        this.stream.println();
        this.stream.print("    }\n");
        this.stream.print("\n");
    }

    private void printTopMinor(int[] m, int row, int col, int N) {
        int[] d = this.createMinor(m, row, col, N);
        this.det(d, 0, N - 1);
    }

    private int[] createMinor(int[] m, int row, int col, int N) {
        int M = N - 1;
        int[] ret = new int[M * M];
        int index = 0;
        for (int i = 0; i < N; ++i) {
            if (i == row) continue;
            for (int j = 0; j < N; ++j) {
                if (j == col) continue;
                ret[index++] = m[i * N + j];
            }
        }
        return ret;
    }

    private void det(int[] m, int row, int N) {
        if (N == 1) {
            this.stream.print(this.a(m[0]));
        } else if (N == 2) {
            this.stream.print(this.a(m[0]) + "*" + this.a(m[3]) + " - " + this.a(m[1]) + "*" + this.a(m[2]));
        } else {
            int M = N - 1;
            for (int i = 0; i < N; ++i) {
                int[] d = this.createMinor(m, 0, i, N);
                int pow = i;
                if (pow % 2 == 0) {
                    this.stream.print(" + " + this.a(m[i]) + "*(");
                } else {
                    this.stream.print(" - " + this.a(m[i]) + "*(");
                }
                this.det(d, row + 1, M);
                this.stream.print(")");
            }
        }
    }

    private String a(int index) {
        int i = index / this.N + 1;
        int j = index % this.N + 1;
        return "a" + i + "" + j;
    }

    public static void main(String[] args) throws FileNotFoundException {
        GenerateInverseFromMinor gen = new GenerateInverseFromMinor();
        gen.createClass(5);
    }
}

