/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.meteor.aligner;

import edu.cmu.meteor.aligner.Alignment;
import edu.cmu.meteor.aligner.ExactMatcher;
import edu.cmu.meteor.aligner.Match;
import edu.cmu.meteor.aligner.ParaphraseMatcher;
import edu.cmu.meteor.aligner.ParaphraseTransducer;
import edu.cmu.meteor.aligner.PartialAlignment;
import edu.cmu.meteor.aligner.Stage;
import edu.cmu.meteor.aligner.StemMatcher;
import edu.cmu.meteor.aligner.Stemmer;
import edu.cmu.meteor.aligner.SynonymDictionary;
import edu.cmu.meteor.aligner.SynonymMatcher;
import edu.cmu.meteor.util.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aligner {
    private String language;
    private int moduleCount;
    private ArrayList<Integer> modules;
    private ArrayList<Double> moduleWeights;
    private int beamSize;
    private Stemmer stemmer;
    private SynonymDictionary synonyms;
    private ParaphraseTransducer paraphrase;
    private HashSet<String> functionWords;
    private Comparator<PartialAlignment> partialComparator;

    public Aligner(String string, ArrayList<Integer> arrayList) {
        this.beamSize = 40;
        this.partialComparator = Constants.PARTIAL_COMPARE_TOTAL;
        this.setupModules(string, arrayList, Constants.DEFAULT_WORD_DIR_URL, Constants.DEFAULT_SYN_DIR_URL, Constants.getDefaultParaFileURL(Constants.getLanguageID(Constants.normLanguageName(string))));
    }

    public Aligner(String string, ArrayList<Integer> arrayList, ArrayList<Double> arrayList2) {
        this.beamSize = 40;
        this.partialComparator = Constants.PARTIAL_COMPARE_TOTAL;
        this.setupModules(string, arrayList, Constants.DEFAULT_WORD_DIR_URL, Constants.DEFAULT_SYN_DIR_URL, Constants.getDefaultParaFileURL(Constants.getLanguageID(Constants.normLanguageName(string))));
        this.moduleWeights = arrayList2;
    }

    public Aligner(String string, ArrayList<Integer> arrayList, ArrayList<Double> arrayList2, int n) {
        this.beamSize = n;
        this.partialComparator = Constants.PARTIAL_COMPARE_TOTAL;
        this.setupModules(string, arrayList, Constants.DEFAULT_WORD_DIR_URL, Constants.DEFAULT_SYN_DIR_URL, Constants.getDefaultParaFileURL(Constants.getLanguageID(Constants.normLanguageName(string))));
        this.moduleWeights = arrayList2;
    }

    public Aligner(String string, ArrayList<Integer> arrayList, ArrayList<Double> arrayList2, int n, URL uRL) {
        this.beamSize = n;
        this.partialComparator = Constants.PARTIAL_COMPARE_TOTAL;
        this.setupModules(string, arrayList, uRL, Constants.DEFAULT_SYN_DIR_URL, Constants.getDefaultParaFileURL(Constants.getLanguageID(Constants.normLanguageName(string))));
        this.moduleWeights = arrayList2;
    }

    public Aligner(String string, ArrayList<Integer> arrayList, ArrayList<Double> arrayList2, int n, URL uRL, URL uRL2) {
        this.beamSize = n;
        this.partialComparator = Constants.PARTIAL_COMPARE_TOTAL;
        this.setupModules(string, arrayList, uRL, uRL2, Constants.getDefaultParaFileURL(Constants.getLanguageID(Constants.normLanguageName(string))));
        this.moduleWeights = arrayList2;
    }

    public Aligner(String string, ArrayList<Integer> arrayList, ArrayList<Double> arrayList2, int n, URL uRL, URL uRL2, URL uRL3) {
        this.beamSize = n;
        this.partialComparator = Constants.PARTIAL_COMPARE_TOTAL;
        this.setupModules(string, arrayList, uRL, uRL2, uRL3);
        this.moduleWeights = arrayList2;
    }

    public Aligner(String string, ArrayList<Integer> arrayList, ArrayList<Double> arrayList2, int n, URL uRL, URL uRL2, URL uRL3, Comparator<PartialAlignment> comparator) {
        this.beamSize = n;
        this.partialComparator = comparator;
        this.setupModules(string, arrayList, uRL, uRL2, uRL3);
        this.moduleWeights = arrayList2;
    }

    public Aligner(Aligner aligner) {
        this.beamSize = aligner.beamSize;
        this.moduleCount = aligner.moduleCount;
        this.language = aligner.language;
        this.modules = new ArrayList<Integer>(aligner.modules);
        this.moduleWeights = new ArrayList<Double>(aligner.moduleWeights);
        this.partialComparator = aligner.partialComparator;
        for (int n : this.modules) {
            if (n == 1) {
                this.stemmer = Constants.newStemmer(this.language);
                continue;
            }
            if (n == 2) {
                this.synonyms = aligner.synonyms;
                continue;
            }
            if (n != 3) continue;
            this.paraphrase = aligner.paraphrase;
        }
        this.functionWords = aligner.functionWords;
    }

    private void setupModules(String string, ArrayList<Integer> arrayList, URL uRL, URL uRL2, URL uRL3) {
        this.language = Constants.normLanguageName(string);
        this.moduleCount = arrayList.size();
        this.modules = arrayList;
        this.moduleWeights = new ArrayList();
        for (int i = 0; i < this.modules.size(); ++i) {
            int n = this.modules.get(i);
            if (n == 0) {
                this.moduleWeights.add(1.0);
                continue;
            }
            if (n == 1) {
                this.moduleWeights.add(1.0);
                this.stemmer = Constants.newStemmer(this.language);
                continue;
            }
            if (n == 2) {
                this.moduleWeights.add(1.0);
                try {
                    URL uRL4 = new URL(uRL2.toString() + "/" + this.language + ".exceptions");
                    URL uRL5 = new URL(uRL2.toString() + "/" + this.language + ".synsets");
                    URL uRL6 = new URL(uRL2.toString() + "/" + this.language + ".relations");
                    this.synonyms = new SynonymDictionary(uRL4, uRL5, uRL6);
                    continue;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Error: Synonym dictionary could not be loaded (" + uRL2.toString() + ")");
                }
            }
            if (n != 3) continue;
            this.moduleWeights.add(1.0);
            this.paraphrase = new ParaphraseTransducer(uRL3);
        }
        this.functionWords = new HashSet();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.functionWords.add(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("No function word list (" + uRL.toString() + ")");
        }
    }

    public void updateModuleWeights(ArrayList<Double> arrayList) {
        this.moduleWeights = new ArrayList<Double>(arrayList);
    }

    public Alignment align(String string, String string2) {
        Alignment alignment = new Alignment(string, string2);
        this.align(alignment);
        return alignment;
    }

    public Alignment align(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        Alignment alignment = new Alignment(arrayList, arrayList2);
        this.align(alignment);
        return alignment;
    }

    private void align(Alignment alignment) {
        int n;
        Object object;
        Stage stage = new Stage(alignment.words1, alignment.words2);
        int n2 = this.moduleCount;
        if (alignment.words1.size() == alignment.words2.size() && Arrays.equals(stage.words1, stage.words2)) {
            n2 = 1;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.modules.get(i);
            if (n3 == 0) {
                ExactMatcher.match(i, alignment, stage);
                continue;
            }
            if (n3 == 1) {
                StemMatcher.match(i, alignment, stage, this.stemmer);
                continue;
            }
            if (n3 == 2) {
                SynonymMatcher.match(i, alignment, stage, this.synonyms);
                continue;
            }
            if (n3 == 3) {
                ParaphraseMatcher.match(i, alignment, stage, this.paraphrase);
                continue;
            }
            throw new RuntimeException("Matcher not recognized: " + n3);
        }
        boolean[] blArray = new boolean[alignment.words1.size()];
        Arrays.fill(blArray, false);
        boolean[] blArray2 = new boolean[alignment.words2.size()];
        Arrays.fill(blArray2, false);
        PartialAlignment partialAlignment = new PartialAlignment(new Match[alignment.words2.size()], blArray, blArray2);
        for (int i = 0; i < stage.matches.size(); ++i) {
            int n4;
            if (stage.matches.get(i).size() != 1) continue;
            object = stage.matches.get(i).get(0);
            boolean bl = false;
            for (n4 = 0; n4 < object.length; ++n4) {
                if (stage.line2Coverage[i + n4] == 1) continue;
                bl = true;
            }
            for (n4 = 0; n4 < object.matchLength; ++n4) {
                if (stage.line1Coverage[object.matchStart + n4] == 1) continue;
                bl = true;
            }
            if (bl) continue;
            partialAlignment.matches[i] = object;
            for (n4 = 0; n4 < object.length; ++n4) {
                partialAlignment.line2UsedWords[i + n4] = true;
            }
            for (n4 = 0; n4 < object.matchLength; ++n4) {
                partialAlignment.line1UsedWords[object.matchStart + n4] = true;
            }
        }
        PartialAlignment partialAlignment2 = this.resolve(stage, partialAlignment);
        object = new int[this.moduleCount];
        int[] nArray = new int[this.moduleCount];
        Arrays.fill(object, 0);
        Arrays.fill(nArray, 0);
        int[] nArray2 = new int[this.moduleCount];
        int[] nArray3 = new int[this.moduleCount];
        Arrays.fill(nArray2, 0);
        Arrays.fill(nArray3, 0);
        boolean[] blArray3 = new boolean[alignment.words1.size()];
        boolean[] blArray4 = new boolean[alignment.words2.size()];
        for (n = 0; n < alignment.words1.size(); ++n) {
            if (!this.functionWords.contains(alignment.words1.get(n).toLowerCase())) continue;
            blArray3[n] = true;
            alignment.line1FunctionWords.add(n);
        }
        for (n = 0; n < alignment.words2.size(); ++n) {
            if (!this.functionWords.contains(alignment.words2.get(n).toLowerCase())) continue;
            blArray4[n] = true;
            alignment.line2FunctionWords.add(n);
        }
        for (n = 0; n < partialAlignment2.matches.length; ++n) {
            int n5;
            Match match = partialAlignment2.matches[n];
            if (match == null) continue;
            for (n5 = 0; n5 < match.matchLength; ++n5) {
                if (blArray3[match.matchStart + n5]) {
                    int n6 = match.module;
                    nArray2[n6] = nArray2[n6] + 1;
                    continue;
                }
                int n7 = match.module;
                object[n7] = object[n7] + 1;
            }
            for (n5 = 0; n5 < match.length; ++n5) {
                if (blArray4[match.start + n5]) {
                    int n8 = match.module;
                    nArray3[n8] = nArray3[n8] + 1;
                    continue;
                }
                int n9 = match.module;
                nArray[n9] = nArray[n9] + 1;
            }
        }
        for (n = 0; n < this.moduleCount; ++n) {
            alignment.moduleContentMatches1.add(object[n]);
            alignment.moduleContentMatches2.add(nArray[n]);
            alignment.moduleFunctionMatches1.add(nArray2[n]);
            alignment.moduleFunctionMatches2.add(nArray3[n]);
        }
        alignment.matches = Arrays.copyOf(partialAlignment2.matches, partialAlignment2.matches.length);
        int[] nArray4 = this.getCountAndChunks(alignment.matches);
        alignment.line1Matches = nArray4[0];
        alignment.line2Matches = nArray4[1];
        alignment.numChunks = nArray4[2];
        double d = (double)(alignment.line1Matches + alignment.line2Matches) / 2.0;
        alignment.avgChunkLength = alignment.numChunks > 0 ? d / (double)alignment.numChunks : 0.0;
    }

    private PartialAlignment resolve(Stage stage, PartialAlignment partialAlignment) {
        ArrayList<PartialAlignment> arrayList = null;
        ArrayList<PartialAlignment> arrayList2 = new ArrayList<PartialAlignment>();
        arrayList2.add(partialAlignment);
        for (int i = 0; i <= stage.matches.size(); ++i) {
            arrayList = arrayList2;
            arrayList2 = new ArrayList();
            Collections.sort(arrayList, this.partialComparator);
            for (int j = 0; j < this.beamSize && j < arrayList.size(); ++j) {
                Object object;
                PartialAlignment partialAlignment2 = (PartialAlignment)arrayList.get(j);
                if (i == stage.matches.size()) {
                    if (partialAlignment2.lastMatchEnd != -1) {
                        ++partialAlignment2.chunks;
                    }
                    arrayList2.add(partialAlignment2);
                    continue;
                }
                if (partialAlignment2.line2UsedWords[i]) {
                    if (i < partialAlignment2.idx) {
                        arrayList2.add(partialAlignment2);
                        continue;
                    }
                    if (partialAlignment2.matches[partialAlignment2.idx] == null) continue;
                    object = partialAlignment2.matches[partialAlignment2.idx];
                    ++partialAlignment2.matchCount;
                    partialAlignment2.matches1 = (int)((double)partialAlignment2.matches1 + (double)((Match)object).matchLength * this.moduleWeights.get(((Match)object).module));
                    partialAlignment2.matches2 = (int)((double)partialAlignment2.matches2 + (double)((Match)object).length * this.moduleWeights.get(((Match)object).module));
                    partialAlignment2.allMatches1 += ((Match)object).matchLength;
                    partialAlignment2.allMatches2 += ((Match)object).length;
                    if (partialAlignment2.lastMatchEnd != -1 && ((Match)object).matchStart != partialAlignment2.lastMatchEnd) {
                        ++partialAlignment2.chunks;
                    }
                    partialAlignment2.idx = ((Match)object).start + ((Match)object).length;
                    partialAlignment2.lastMatchEnd = ((Match)object).matchStart + ((Match)object).matchLength;
                    partialAlignment2.distance += Math.abs(((Match)object).start - ((Match)object).matchStart);
                    arrayList2.add(partialAlignment2);
                    continue;
                }
                object = stage.matches.get(i);
                for (int k = 0; k < ((ArrayList)object).size(); ++k) {
                    Match match = ((ArrayList)object).get(k);
                    if (partialAlignment2.isUsed(match)) continue;
                    PartialAlignment partialAlignment3 = new PartialAlignment(partialAlignment2);
                    partialAlignment3.setUsed(match, true);
                    partialAlignment3.matches[i] = match;
                    ++partialAlignment3.matchCount;
                    partialAlignment3.matches1 = (int)((double)partialAlignment3.matches1 + (double)match.matchLength * this.moduleWeights.get(match.module));
                    partialAlignment3.matches2 = (int)((double)partialAlignment3.matches2 + (double)match.length * this.moduleWeights.get(match.module));
                    partialAlignment3.allMatches1 += match.matchLength;
                    partialAlignment3.allMatches2 += match.length;
                    if (partialAlignment3.lastMatchEnd != -1 && match.matchStart != partialAlignment3.lastMatchEnd) {
                        ++partialAlignment3.chunks;
                    }
                    partialAlignment3.idx = match.start + match.length;
                    partialAlignment3.lastMatchEnd = match.matchStart + match.matchLength;
                    partialAlignment2.distance += Math.abs(match.start - match.matchStart);
                    arrayList2.add(partialAlignment3);
                }
                if (partialAlignment2.lastMatchEnd != -1) {
                    ++partialAlignment2.chunks;
                    partialAlignment2.lastMatchEnd = -1;
                }
                ++partialAlignment2.idx;
                arrayList2.add(partialAlignment2);
            }
            if (arrayList2.size() != 0) continue;
            System.err.println("Warning: unexpected conditions - skipping matches until possible to continue");
            arrayList2.add((PartialAlignment)arrayList.get(0));
        }
        Collections.sort(arrayList2, this.partialComparator);
        return (PartialAlignment)arrayList2.get(0);
    }

    private int[] getCountAndChunks(Match[] matchArray) {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        while (n4 < matchArray.length) {
            object = matchArray[n4];
            if (object == null) {
                if (n5 != -1) {
                    ++n3;
                    n5 = -1;
                }
                ++n4;
                continue;
            }
            n += ((Match)object).matchLength;
            n2 += ((Match)object).length;
            if (n5 != -1 && ((Match)object).matchStart != n5) {
                ++n3;
            }
            n4 = ((Match)object).start + ((Match)object).length;
            n5 = ((Match)object).matchStart + ((Match)object).matchLength;
        }
        if (n5 != -1) {
            // empty if block
        }
        object = new int[]{n, n2, ++n3};
        return object;
    }
}

