# 食材分类小程序介绍
[Read in English](./Food_Ingredient_Classification.md)
## 界面展示
<div style="text-align: center;">
<img src=".\cover.png" alt="Classification Cover"  width="80%" height="80%">
</div>

## 功能

该小程序的主要作用是将数据集中的食材标签归入食材树的对应类别节点下。

## 待分类食材标签

从全部食材标签数据（位于.\输入输出\全部数据\all_in.csv）中选取至少出现在5张图片中的标签，得到517个食材标签。

一共2个人对食材标签进行分类，每个人约260个标签，分别位于“.\输入输出\全部数据\in_person0.json”和“.\输入输出\全部数据\in_person1.json”文件中，可以在gui.py文件中修改输入文件的路径IN_FILE。

## 输入输出

- 所有的食材数据：位于“.\输入输出\全部数据\in_min5.json”
- 所有的食材特征：位于“.\输入输出\全部数据\in_feature.npy”
- 待处理的未标记：位于“.\输入输出\全部数据\in_person0.json”或者“.\输入输出\全部数据\in_person1.json”文件
- 已经标记的食材树：位于“.\输入输出\全部数据\tree.json”

## 运行方式
```
python gui.py
```

## 环境要求

1. sklearn  用于文本聚类
2. tkinter 用于gui可视化：[ParthJadhav/Tkinter-Designer: An easy and fast way to create a Python GUI 🐍 (github.com)](https://github.com/ParthJadhav/Tkinter-Designer)

## 功能展示

| 功能名称             | 功能作用             |
| ------------------- | --------------------|
| 首页           | 返回未标记食材的可视化首页，展示前64个标签          |
| 上一页         | 返回上一页的食材标签，如果当前页为首页，则返回警告   |
| 下一页         | 返回下一页的食材标签，如果当前页为尾页，则返回警告   |
| 根节点         | 返回已标注食材树的根节点  |
| 下一级         | 返回食材树当前级别的下一级节点       |
| 上一级         | 返回食材树当前级别的上一级节点       |
| 点击“未标记食材”   | 将未标记食材存入“标记食材缓存区” |
| 点击“食材树叶子节点” | 进入该食材树节点的下一级节点    |
| 删除节点缓存区       | 将当前节点的父节点加入“删除节点缓存区”，再次点击删除节点即可删除该节点以及子树。$\textcolor{red}{注意，尽可能不要删除非叶子节点，否则很麻烦，无法撤销操作。删除节点最好仅删除叶子节点}$              |
| 标记节点        | 将“标记食材缓存区”的食材存入食材树当前级别，并在未标记食材区中删除对应食材。$\textcolor{red}{切记，添加多个节点时，必须为食材树同一父节点下，函数会自动调用食材树可视化区域当前节点，作为插入的父节点}$ |
| 删除节点        | 将“删除节点缓存区”中的叶子节点删除，并放入未标记食材区。$\textcolor{red}{删除对应节点后，食材树会默认返回当前节点的上一节点进行可视化}$                             |
| 添加新节点      | 一些食材所属类别可能并不在规定类别中，或者认为一些食材应该具有更细致的分类，可以通过添加新节点按钮，在$\textcolor{red}{食材树当前节点下}$新建一个节点        |
| 保存数据        | 实时保存数据                      |
| PS             | 不能直接停止程序，只能通过关掉UI界面来结束程序运行。如果直接停止，则未保存的已经标注部分数据的食材树则不会保存，只有正常关闭，最后程序会自动保存标注好的食材树            |

## 其它

- 每一页有64个食材，即一个batch。每一个batch的标注大概在2小时左右，主要原因是有大量的食材是标注人员不认识的。
- 标注最终的结果有2个文件，一个是标注好的食材树，另一个是未标注的食材（对于食材名称模糊，存在歧义，无法判断的食材可以将其放入到**其他**类别中）
- 注意：每个人主观程度不一样，所以需要对于食材进行二次标注。
- 花费时间：大约1天
