export function getL10n(text) {
    const keys = Object.keys(l10n[text]);
    const lang = navigator.language;
    if (keys.includes(lang)) {
        return l10n[text][lang];
    }
    // A language variant
    const key = keys.find(candidate => candidate.startsWith(lang));
    if (key !== undefined) {
        return l10n[text][key];
    }
    return l10n[text]['en-US'];
}
const enableSyncTeX = {
    'ach': 'Tye kan SyncTeX',
    'af': 'Skakel SyncTeX aan',
    'an': 'Activar SyncTeX',
    'ar': 'تمكين SyncTeX',
    'ast': 'Activar SyncTeX',
    'az': 'SyncTeX-i aktiv et',
    'be': 'Уключыць SyncTeX',
    'bg': 'Активиране на SyncTeX',
    'bn': 'SyncTeX সক্রিয় করুন',
    'bo': 'SyncTeX ལྕོགས་སྒྲིག་འབད',
    'br': 'Gweredekaat SyncTeX',
    'brx': 'SyncTeX सिंगथानाय',
    'bs': 'Omogući SyncTeX',
    'ca': 'Habilitar SyncTeX',
    'cak': 'Xyaloj SyncTeX',
    'ckb': 'چالاککردنی SyncTeX',
    'cs': 'Povolit SyncTeX',
    'cy': 'Galluogi SyncTeX',
    'da': 'Aktivér SyncTeX',
    'de': 'SyncTeX aktivieren',
    'dsb': 'SyncTeX zmóžniś',
    'el': 'Ενεργοποίηση SyncTeX',
    'en-CA': 'Enable SyncTeX',
    'en-GB': 'Enable SyncTeX',
    'en-US': 'Enable SyncTeX',
    'eo': 'Ebligi SyncTeX',
    'es-AR': 'Habilitar SyncTeX',
    'es-CL': 'Habilitar SyncTeX',
    'es-ES': 'Habilitar SyncTeX',
    'es-MX': 'Habilitar SyncTeX',
    'et': 'Luba SyncTeX',
    'eu': 'Gaitu SyncTeX',
    'fa': 'فعال‌سازی SyncTeX',
    'ff': 'Danndinore SyncTeX',
    'fi': 'Ota SyncTeX käyttöön',
    'fr': 'Activer SyncTeX',
    'fur': 'Abilitâ SyncTeX',
    'fy-NL': 'SyncTeX ynskeakelje',
    'ga-IE': 'Cumasaigh SyncTeX',
    'gd': 'Cuir an comas SyncTeX',
    'gl': 'Habilitar SyncTeX',
    'gn': 'Eñepyrũ SyncTeX',
    'gu-IN': 'SyncTeX સક્રિય કરો',
    'he': 'הפעל SyncTeX',
    'hi-IN': 'SyncTeX सक्षम करें',
    'hr': 'Omogući SyncTeX',
    'hsb': 'SyncTeX zmóžnić',
    'hu': 'SyncTeX engedélyezése',
    'hy-AM': 'Միացնել SyncTeX',
    'hye': 'Միացնել SyncTeX',
    'ia': 'Activar SyncTeX',
    'id': 'Aktifkan SyncTeX',
    'is': 'Virkja SyncTeX',
    'it': 'Abilita SyncTeX',
    'ja': 'SyncTeX を有効にする',
    'ka': 'გააქტიურეთ SyncTeX',
    'kab': 'Ssexsemeɣ SyncTeX',
    'kk': 'SyncTeX іске қосу',
    'km': 'អនុញ្ញាត SyncTeX',
    'kn': 'SyncTeX ಸಕ್ರಿಯಗೊಳಿಸಿ',
    'ko': 'SyncTeX 활성화',
    'lij': 'Abilîta SyncTeX',
    'lo': 'ເປີດໃຊ້ SyncTeX',
    'lt': 'Įgalinti SyncTeX',
    'ltg': 'Ītuorot SyncTeX',
    'lv': 'Iespējot SyncTeX',
    'meh': 'Activar SyncTeX',
    'mk': 'Овозможи SyncTeX',
    'mr': 'SyncTeX सक्षम करा',
    'ms': 'Dayakan SyncTeX',
    'my': 'SyncTeX ကိုဖွင့်ပါ',
    'nb-NO': 'Aktiver SyncTeX',
    'ne-NP': 'SyncTeX सक्षम गर्नुहोस्',
    'nl': 'SyncTeX inschakelen',
    'nn-NO': 'Aktiver SyncTeX',
    'oc': 'Activar SyncTeX',
    'pa-IN': 'SyncTeX ਸਕ੍ਰਿਯ ਕਰੋ',
    'pl': 'Włącz SyncTeX',
    'pt-BR': 'Habilitar SyncTeX',
    'pt-PT': 'Ativar SyncTeX',
    'rm': 'Activar SyncTeX',
    'ro': 'Activează SyncTeX',
    'ru': 'Включить SyncTeX',
    'sat': 'SyncTeX ᱤᱠᱤᱭ ᱛᱟᱱᱚᱢ',
    'sc': 'Abilita SyncTeX',
    'scn': 'Abilitari SyncTeX',
    'sco': 'Enable SyncTeX',
    'si': 'SyncTeX සක්‍රීය කරන්න',
    'sk': 'Povoliť SyncTeX',
    'skr': 'SyncTeX کو چالو کریں',
    'sl': 'Omogoči SyncTeX',
    'son': 'SyncTeX dandih',
    'sq': 'Aktivizo SyncTeX',
    'sr': 'Омогући SyncTeX',
    'sv-SE': 'Aktivera SyncTeX',
    'szl': 'Aktywować SyncTeX',
    'ta': 'SyncTeX ஐ இயக்கவும்',
    'te': 'SyncTeX ను ప్రారంభించు',
    'tg': 'Фаъол кардани SyncTeX',
    'th': 'เปิดใช้ SyncTeX',
    'tl': 'Paganahin ang SyncTeX',
    'tr': 'SyncTeX\'i etkinleştir',
    'trs': 'SyncTeX\'i etkinleştir',
    'uk': 'Увімкнути SyncTeX',
    'ur': 'SyncTeX کو فعال کریں',
    'uz': 'SyncTeX-ni yoqing',
    'vi': 'Bật SyncTeX',
    'wo': 'Suqali SyncTeX',
    'xh': 'Vula i-SyncTeX',
    'zh-CN': '启用SyncTeX',
    'zh-TW': '啟用SyncTeX'
};
const enableRefresh = {
    'ach': 'Yaki alokute kerom kwede rot meka',
    'af': 'Aktiveer outo-verfris',
    'an': 'Activar auto-refrés',
    'ar': 'تمكين التحديث التلقائي',
    'ast': 'Activar autoactualización',
    'az': 'Avto-yeniləməni aktiv edin',
    'be': 'Уключыць аўтаматычнае абнаўленне',
    'bg': 'Разрешаване на автоматично опресняване',
    'bn': 'স্বয়ংক্রিয় রিফ্রেশ সক্রিয় করুন',
    'bo': 'རང་འགྱུར་བདེན་འབེབས་འབད།',
    'br': 'Gweredekaat adneveziñ emgefre',
    'brx': 'आथोरिफ्रेश संगोनाय फुंगाव',
    'bs': 'Omogući automatsko osvježavanje',
    'ca': 'Activa l\'autoactualització',
    'cak': 'Xuwan naj b’echb’äl k’ak’itz’oji’ik',
    'ckb': 'چالاککردنی نوێکردنەوەی خۆکار',
    'cs': 'Povolit automatické obnovení',
    'cy': 'Galluogi ail-adnewyddu awtomatig',
    'da': 'Aktivér automatisk opdatering',
    'de': 'Automatische Aktualisierung aktivieren',
    'dsb': 'Awtomatiski wótnowišk wótmožńiś',
    'el': 'Ενεργοποίηση αυτόματης ανανέωσης',
    'en-CA': 'Enable auto-refresh',
    'en-GB': 'Enable auto-refresh',
    'en-US': 'Enable auto-refresh',
    'eo': 'Ebligi aŭtomatan refreŝigon',
    'es-AR': 'Habilitar actualización automática',
    'es-CL': 'Habilitar actualización automática',
    'es-ES': 'Habilitar actualización automática',
    'es-MX': 'Habilitar actualización automática',
    'et': 'Luba automaatne värskendus',
    'eu': 'Gaitu autoeguneratzea',
    'fa': 'فعال کردن تازه‌سازی خودکار',
    'ff': 'Ñiwtii laabi e sokkude',
    'fi': 'Ota automaattinen päivitys käyttöön',
    'fr': 'Activer l\'actualisation automatique',
    'fur': 'Active l\'aggiornamînt automatic',
    'fy-NL': 'Automatysk fernije ynskeakelje',
    'ga-IE': 'Cumasaigh an t-athnuachan uathoibríoch',
    'gd': 'Cuir an comas ùrachadh fèin-ghluasadach',
    'gl': 'Activar actualización automática',
    'gn': 'Moinge ñepyrũmby jepoka guive',
    'gu-IN': 'આટોમેટિક રિફ્રેશ સક્રિય કરો',
    'he': 'הפעל רענון אוטומטי',
    'hi-IN': 'स्वचालित ताज़ा करें सक्षम करें',
    'hr': 'Omogući automatsko osvježavanje',
    'hsb': 'Awtomatiski wobnowić',
    'hu': 'Automatikus frissítés engedélyezése',
    'hy-AM': 'Ակտիվացնել ավտոմատ թարմացումը',
    'hye': 'Ակտիվացնել ավտոմատ թարմացումը',
    'ia': 'Activar auto-refrescar',
    'id': 'Aktifkan penyegaran otomatis',
    'is': 'Virkja sjálfvirka endurnýjun',
    'it': 'Abilita aggiornamento automatico',
    'ja': '自動リフレッシュを有効にする',
    'ka': 'ავტომატური განახლების ჩართვა',
    'kab': 'Seldek asebsed ameslayen',
    'kk': 'Автоматты жаңартуды қосу',
    'km': 'បើកការបន្តផ្សាយដោយស្វ័យប្រវត្តិ',
    'kn': 'ಸ್ವಯಂ-ರಿಫ್ರೆಶ್ ಅನ್ನು ಸಕ್ರಿಯ ಮಾಡಿ',
    'ko': '자동 새로 고침 활성화',
    'lij': 'Abilita aggiornamento automatico',
    'lo': 'ເປີດໃຊ້ການຟື້ນຟູອັດຕະໂນມັດ',
    'lt': 'Įjungti automatinį atnaujinimą',
    'ltg': 'Īstot auzašgruodišonu',
    'lv': 'Iespējot automātisko atsvaidzināšanu',
    'meh': 'Habilitar actualización automática',
    'mk': 'Овозможи автоматско освежување',
    'mr': 'स्वयं-रिफ्रेश सक्षम करा',
    'ms': 'Dayakan penyegaran automatik',
    'my': 'အလိုအလျောက်ပြန်လည်ဖြစ်စေခြင်းကိုဖွင့်ပါ',
    'nb-NO': 'Aktiver automatisk oppdatering',
    'ne-NP': 'स्वत: रिफ्रेश सक्षम गर्नुहोस्',
    'nl': 'Automatisch vernieuwen inschakelen',
    'nn-NO': 'Aktiver automatisk oppdatering',
    'oc': 'Activar l\'actualizacion automatica',
    'pa-IN': 'ਸਵੈ-ਤਾਜ਼ਗੀ ਨੂੰ ਯੋਗ ਕਰੋ',
    'pl': 'Włącz automatyczne odświeżanie',
    'pt-BR': 'Ativar atualização automática',
    'pt-PT': 'Ativar atualização automática',
    'rm': 'Activar refresch automat',
    'ro': 'Permite reîmprospătarea automată',
    'ru': 'Включить автообновление',
    'sat': 'ᱟᱝᱞᱟ ᱯᱟᱹᱲᱷᱮᱥ ᱥᱤᱥᱟᱨᱣᱟ ᱠᱚᱱᱚᱜᱟ',
    'sc': 'Abilita s’aggiornamentu automàticu',
    'scn': 'Abilita aggiornamentu automaticu',
    'sco': 'Enable auto-refresh',
    'si': 'ස්වයංක්‍රීය නවීකරණය සක්‍රිය කරන්න',
    'sk': 'Povoliť automatické obnovenie',
    'skr': 'خودکار تازہ کاری فعال کریں',
    'sl': 'Omogoči samodežno osveževanje',
    'son': 'Enable auto-refresh',
    'sq': 'Aktivizo rifreskimin automatik',
    'sr': 'Омогући аутоматско освежавање',
    'sv-SE': 'Aktivera automatisk uppdatering',
    'szl': 'Włącz auto-odświeżanie',
    'ta': 'தானியங்கும் புதுப்பிப்பை இயக்கவும்',
    'te': 'ఆటో-రిఫ్రెష్‌ను ప్రారంభించండి',
    'tg': 'Фаъол кардани навсозии худкор',
    'th': 'เปิดใช้งานการรีเฟรชอัตโนมัติ',
    'tl': 'Paganahin ang auto-refresh',
    'tr': 'Otomatik yenilemeyi etkinleştir',
    'trs': 'Enable auto-refresh',
    'uk': 'Увімкнути автоматичне оновлення',
    'ur': 'آٹو ریفریش کو فعال کریں',
    'uz': 'Avto yangilashni yoqing',
    'vi': 'Bật tự động làm mới',
    'wo': 'Suqali sëfëlu autogeen',
    'xh': 'Yenza uhlaziyo oluzenzekelayo',
    'zh-CN': '启用自动刷新',
    'zh-TW': '啟用自動重新整理'
};
const trimMargin = {
    'ach': 'Myero mar margine ki',
    'af': 'Trim marge met',
    'an': 'Recortar margen por',
    'ar': 'قلل الهامش بنسبة',
    'ast': 'Recortar marxe por',
    'az': 'Kənar payını X% qədər azaldın',
    'be': 'Паменшыць маржу на',
    'bg': 'Намалете маржа с',
    'bn': 'প্রান্ত কাটা হবে',
    'bo': 'སྲེས་དཔག་གཅིག་',
    'br': 'Berradur an treuzoù gant',
    'brx': 'फायाँग दारिदो ओन्गा',
    'bs': 'Smanjite maržu za',
    'ca': 'Redueix el marge en',
    'cak': 'Xna´an eb´en jun',
    'ckb': 'ئاژمۆنی بە',
    'cs': 'Oříznout okraj o',
    'cy': 'Torrwch y ymyl gan',
    'da': 'Trim margen med',
    'de': 'Rand um',
    'dsb': 'Sćisny margina za',
    'el': 'Περικοπή περιθωρίου κατά',
    'en-CA': 'Trim margin by',
    'en-GB': 'Trim margin by',
    'en-US': 'Trim margin by',
    'eo': 'Tondi la marĝenon je',
    'es-AR': 'Recortar margen en',
    'es-CL': 'Recortar margen en',
    'es-ES': 'Recortar margen en',
    'es-MX': 'Recortar margen en',
    'et': 'Kärbi marginaal',
    'eu': 'Moz margena',
    'fa': 'حاشیه را به',
    'ff': 'Murmin adrim',
    'fi': 'Leikkaa marginaalia',
    'fr': 'Réduire la marge de',
    'fur': 'Scuartje il percjel cun',
    'fy-NL': 'Trim râne mei',
    'ga-IE': 'Bearr imeall le',
    'gd': 'Lùghdaich an iomall le',
    'gl': 'Recortar marxe en',
    'gn': 'Ombue ko margen',
    'gu-IN': 'માર્જિનને તોડી નાખો',
    'he': 'קיצוץ שוליים ב',
    'hi-IN': 'किनारा काटें',
    'hr': 'Smanjite marginu za',
    'hsb': 'Sćisny margina za',
    'hu': 'Vágja le a margót',
    'hy-AM': 'Կտրել եզրագիծը',
    'hye': 'Կտրել եզրագիծը',
    'ia': 'Trimmar margine per',
    'id': 'Pangkas margin sebesar',
    'is': 'Klippa jaðar um',
    'it': 'Taglia il margine del',
    'ja': 'マージンを',
    'ka': 'მარცხის შემცირება',
    'kab': 'Aṛuγ margint s',
    'kk': 'Жиекті қысқарту',
    'km': 'កាត់បន្ថយកំផ្លេ',
    'kn': 'ಅಂಚನ್ನು ಕಡಿತಮಾಡಿ',
    'ko': '여백을',
    'lij': 'Taglia margine per',
    'lo': 'ຕັດຂອບໂດຍ',
    'lt': 'Apkarpykite paraštes',
    'ltg': 'Apgrīzt māržõ',
    'lv': 'Apgrieziet malu',
    'meh': 'Cortar margen en',
    'mk': 'Намалете маржата за',
    'mr': 'काठ काढा',
    'ms': 'Potong margin sebanyak',
    'my': 'အနားအာရုံကို ဖြတ်ပါ',
    'nb-NO': 'Trim marginen med',
    'ne-NP': 'मार्जिन काट्नुहोस्',
    'nl': 'Snijd marge bij',
    'nn-NO': 'Kutt margen med',
    'oc': 'Reduzir lo margue per',
    'pa-IN': 'ਮਾਰਜਿਨ ਨੂੰ ਛਾਂਟੋ',
    'pl': 'Przytnij margines o',
    'pt-BR': 'Cortar margem em',
    'pt-PT': 'Cortar margem em',
    'rm': 'Taglia il margin per',
    'ro': 'Tăiați marginea cu',
    'ru': 'Обрезать край на',
    'sat': 'ᱥᱮᱸᱜ ᱫᱤᱭᱤᱥ ᱟᱹᱜᱤ ᱫᱟ',
    'sc': 'Ritzu margine cun',
    'scn': 'Tagghia margini per',
    'sco': 'Trim margin bi',
    'si': 'කැපීමේ අභියස',
    'sk': 'Orezať okraj o',
    'skr': 'مارجن کو ٹرم کریں',
    'sl': 'Obrežite rob za',
    'son': 'Ri sî',
    'sq': 'Prerje margjine për',
    'sr': 'Скратите маргину за',
    'sv-SE': 'Trimma marginal med',
    'szl': 'Prziciń margines ô',
    'ta': 'எல்லையைக் குறைக்க',
    'te': 'అంచున తగ్గించు',
    'tg': 'Коҳиш додани ҳошия бо',
    'th': 'ตัดขอบโดย',
    'tl': 'Gupitin ang margin sa pamamagitan ng',
    'tr': 'Kenarı',
    'trs': 'Trim margin by',
    'uk': 'Обрізати край на',
    'ur': 'مارجن کو کم کریں',
    'uz': 'Marginni kesish',
    'vi': 'Cắt bớt lề',
    'wo': 'Duuban margën bi ak',
    'xh': 'Sika umda nge',
    'zh-CN': '修剪边距',
    'zh-TW': '修剪邊距'
};
const navBack = {
    'ach': 'Lapwongere',
    'af': 'Terug',
    'an': 'Tornar',
    'ar': 'رجوع',
    'ast': 'Retroceder',
    'az': 'Geri',
    'be': 'Вярнуцца',
    'bg': 'Назад',
    'bn': 'পূর্ববর্তী',
    'bo': 'ཆུང་པ',
    'br': 'Distreiñ',
    'brx': 'अस्तु',
    'bs': 'Nazad',
    'ca': 'Enrere',
    'cak': 'Wan sãl',
    'ckb': 'گەڕانەوە',
    'cs': 'Zpět',
    'cy': 'Yn ôl',
    'da': 'Tilbage',
    'de': 'Zurück',
    'dsb': 'Zowróć',
    'el': 'Πίσω',
    'en-CA': 'Back',
    'en-GB': 'Back',
    'en-US': 'Back',
    'eo': 'Reen',
    'es-AR': 'Atrás',
    'es-CL': 'Retroceder',
    'es-ES': 'Atrás',
    'es-MX': 'Atrás',
    'et': 'Tagasi',
    'eu': 'Atzera',
    'fa': 'بازگشت',
    'ff': 'Ruppito',
    'fi': 'Takaisin',
    'fr': 'Retour',
    'fur': 'Indaûr',
    'fy-NL': 'Werom',
    'ga-IE': 'Ar ais',
    'gd': 'Air ais',
    'gl': 'Volver',
    'gn': 'Peteĩ',
    'gu-IN': 'પાછું',
    'he': 'אחורה',
    'hi-IN': 'पीछे',
    'hr': 'Natrag',
    'hsb': 'Zowróćiś',
    'hu': 'Vissza',
    'hy-AM': 'Հետ',
    'hye': 'Հետ',
    'ia': 'Retro',
    'id': 'Kembali',
    'is': 'Aftur',
    'it': 'Indietro',
    'ja': '戻る',
    'ka': 'უკან',
    'kab': 'Nura',
    'kk': 'Артқа',
    'km': 'ត្រឡប់មកវិញ',
    'kn': 'ಹಿಂದಕ್ಕೆ',
    'ko': '뒤로',
    'lij': 'Indrîo',
    'lo': 'ກັບຄືນ',
    'lt': 'Atgal',
    'ltg': 'Ataig',
    'lv': 'Atpakaļ',
    'meh': 'Je\'wa',
    'mk': 'Назад',
    'mr': 'मागे',
    'ms': 'Undur',
    'my': 'နောက်သို့',
    'nb-NO': 'Tilbake',
    'ne-NP': 'पछाडि',
    'nl': 'Terug',
    'nn-NO': 'Tilbake',
    'oc': 'Arrièr',
    'pa-IN': 'ਪਿੱਛੇ',
    'pl': 'Wstecz',
    'pt-BR': 'Voltar',
    'pt-PT': 'Voltar',
    'rm': 'Enavos',
    'ro': 'Înapoi',
    'ru': 'Назад',
    'sat': 'ᱫᱚᱨᱩ',
    'sc': 'Tornare',
    'scn': 'Riturnari',
    'sco': 'Back',
    'si': 'ආපසු',
    'sk': 'Späť',
    'skr': 'وپس',
    'sl': 'Nazaj',
    'son': 'Fito',
    'sq': 'Mbrapa',
    'sr': 'Назад',
    'sv-SE': 'Bakåt',
    'szl': 'Wórt',
    'ta': 'பின்செல்',
    'te': 'వెనక్కి',
    'tg': 'Бозгашт',
    'th': 'ย้อนกลับ',
    'tl': 'Bumalik',
    'tr': 'Geri',
    'trs': 'رویا',
    'uk': 'Назад',
    'ur': 'پیچھے',
    'uz': 'Orqaga',
    'vi': 'Quay lại',
    'wo': 'Jot',
    'xh': 'Emva',
    'zh-CN': '后退',
    'zh-TW': '後退'
};
const navForward = {
    'ach': 'Dwong kadi',
    'af': 'Stap vorentoe',
    'an': 'Avantazar',
    'ar': 'الامام',
    'ast': 'Pa alantre',
    'az': 'İrəli',
    'be': 'Перайсці наперад',
    'bg': 'Напред',
    'bn': 'অগ্রবর্তী',
    'bo': 'ཡར་དོན།',
    'br': 'Kentañ war-raok',
    'brx': 'আগমন কৰক',
    'bs': 'Idi naprijed',
    'ca': 'Avança',
    'cak': 'Ajak',
    'ckb': 'پێشوو',
    'cs': 'Dopředu',
    'cy': 'Symud ymlaen',
    'da': 'Frem',
    'de': 'Vorwärts',
    'dsb': 'Dopřeju',
    'el': 'Προς τα εμπρός',
    'en-CA': 'Forward',
    'en-GB': 'Forward',
    'en-US': 'Forward',
    'eo': 'Iri antaŭen',
    'es-AR': 'Avanzar',
    'es-CL': 'Avanzar',
    'es-ES': 'Avanzar',
    'es-MX': 'Avanzar',
    'et': 'Liigu edasi',
    'eu': 'Aurrera',
    'fa': 'به جلو',
    'ff': 'Soogo',
    'fi': 'Siirry eteenpäin',
    'fr': 'Avancer',
    'fur': 'Va aîn',
    'fy-NL': 'Foarút',
    'ga-IE': 'Lean ar aghaidh',
    'gd': 'Rach air adhart',
    'gl': 'Adiantar',
    'gn': 'Mboguapy',
    'gu-IN': 'આગળ વધો',
    'he': 'לקדימה',
    'hi-IN': 'आगे बढ़ें',
    'hr': 'Naprijed',
    'hsb': 'Dopřeju',
    'hu': 'Előre',
    'hy-AM': 'առաջ',
    'hye': 'առաջ',
    'ia': 'Avantiar',
    'id': 'Maju',
    'is': 'Fara fram',
    'it': 'Avanti',
    'ja': '進む',
    'ka': 'წინ',
    'kab': 'Addu',
    'kk': 'Алдыңғы',
    'km': 'ទៅមុខ',
    'kn': 'ಮುನ್ನಡೆ',
    'ko': '앞으로',
    'lij': 'Avânti',
    'lo': 'ມອບລົງ',
    'lt': 'Pirmyn',
    'ltg': 'Uz priekšu',
    'lv': 'Uz priekšu',
    'meh': 'Rey taal',
    'mk': 'Напред',
    'mr': 'आगामी',
    'ms': 'Ke hadapan',
    'my': 'အဆင့်သင့်သွားရန်',
    'nb-NO': 'Gå fremover',
    'ne-NP': 'अघि बढ्नुहोस्',
    'nl': 'Vooruit',
    'nn-NO': 'Gå framover',
    'oc': 'Avançar',
    'pa-IN': 'ਅੱਗੇ ਵਧੋ',
    'pl': 'Idź do przodu',
    'pt-BR': 'Avançar',
    'pt-PT': 'Avançar',
    'rm': 'Avantgar',
    'ro': 'Înainte',
    'ru': 'Вперёд',
    'sat': 'ᱵᱟᱢᱮ',
    'sc': 'Avàntzare',
    'scn': 'Avanzari',
    'sco': 'Forrit',
    'si': 'ඉදිරියට',
    'sk': 'Ďalej',
    'skr': 'پيچھي جاؤ',
    'sl': 'Naprej',
    'son': 'Ŋwii',
    'sq': 'Para përpara',
    'sr': 'Напред',
    'sv-SE': 'Gå framåt',
    'szl': 'Dowidz przod',
    'ta': 'முன்னேறு',
    'te': 'ముందుకు వెళ్ళండి',
    'tg': 'Пеш',
    'th': 'ไปข้างหน้า',
    'tl': 'Tumuloy',
    'tr': 'İleri',
    'trs': 'Jedlèn',
    'uk': 'Вперед',
    'ur': 'آگے بڑھو',
    'uz': 'Oldinga',
    'vi': 'Tiến lên',
    'wo': 'Wuñ a demm',
    'xh': 'Hamba phambili',
    'zh-CN': '前进',
    'zh-TW': '前進'
};
const l10n = {
    enableSyncTeX,
    enableRefresh,
    trimMargin,
    navBack,
    navForward
};
//# sourceMappingURL=l10n.js.map