"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.findTeX = findTeX;
exports.findEndPair = findEndPair;
exports.findMath = findMath;
const vscode = __importStar(require("vscode"));
const utils_1 = require("../utils/utils");
const ENV_NAMES = [
    'align', 'align\\*', 'alignat', 'alignat\\*', 'aligned', 'alignedat', 'array', 'Bmatrix', 'bmatrix', 'cases', 'CD', 'eqnarray', 'eqnarray\\*', 'equation', 'equation\\*', 'flalign', 'flalign\\*', 'gather', 'gather\\*', 'gathered', 'matrix', 'multline', 'multline\\*', 'pmatrix', 'smallmatrix', 'split', 'subarray', 'Vmatrix', 'vmatrix'
];
function findTeX(document, position) {
    const envBeginPat = new RegExp(`\\\\begin\\{(${ENV_NAMES.join('|')})\\}`);
    let r = document.getWordRangeAtPosition(position, envBeginPat);
    if (r) {
        const envname = getFirstRememberedSubstring(document.getText(r), envBeginPat);
        return findHoverOnEnv(document, envname, r.start);
    }
    const parenBeginPat = /(\\\[|\\\(|\$\$)/;
    r = document.getWordRangeAtPosition(position, parenBeginPat);
    if (r) {
        const paren = getFirstRememberedSubstring(document.getText(r), parenBeginPat);
        return findHoverOnParen(document, paren, r.start);
    }
    return findHoverOnInline(document, position);
}
//  \begin{...}                \end{...}
//  ^
//  startPos
function findHoverOnEnv(document, envname, startPos) {
    const pattern = new RegExp('\\\\end\\{' + (0, utils_1.escapeRegExp)(envname) + '\\}');
    const startPos1 = new vscode.Position(startPos.line, startPos.character + envname.length + '\\begin{}'.length);
    const endPos = findEndPair(document, pattern, startPos1);
    if (endPos) {
        const range = new vscode.Range(startPos, endPos);
        return { texString: document.getText(range), range, envname };
    }
    return;
}
//  \[                \]
//  ^
//  startPos
function findHoverOnParen(document, envname, startPos) {
    const pattern = envname === '\\[' ? /\\\]/ : envname === '\\(' ? /\\\)/ : /\$\$/;
    const startPos1 = new vscode.Position(startPos.line, startPos.character + envname.length);
    const endPos = findEndPair(document, pattern, startPos1);
    if (endPos) {
        const range = new vscode.Range(startPos, endPos);
        return { texString: document.getText(range), range, envname };
    }
    return;
}
function findHoverOnInline(document, position) {
    const currentLine = document.lineAt(position.line).text;
    const regex = /(?<!\$|\\)\$(?!\$)(?:\\.|[^\\])+?\$|\\\(.+?\\\)/;
    let s = currentLine;
    let base = 0;
    let m = s.match(regex);
    while (m) {
        if (m.index !== undefined) {
            const matchStart = base + m.index;
            const matchEnd = base + m.index + m[0].length;
            if (matchStart <= position.character && position.character <= matchEnd) {
                const range = new vscode.Range(position.line, matchStart, position.line, matchEnd);
                return { texString: document.getText(range), range, envname: '$' };
            }
            else {
                base = matchEnd;
                s = currentLine.substring(base);
            }
        }
        else {
            break;
        }
        m = s.match(regex);
    }
    return;
}
//  \begin{...}                \end{...}
//             ^
//             startPos1
function findEndPair(document, endPat, startPos1) {
    const currentLine = document.lineAt(startPos1).text.substring(startPos1.character);
    const l = (0, utils_1.stripCommentsAndVerbatim)(currentLine);
    let m = l.match(endPat);
    if (m && m.index !== undefined) {
        return new vscode.Position(startPos1.line, startPos1.character + m.index + m[0].length);
    }
    let lineNum = startPos1.line + 1;
    while (lineNum <= document.lineCount) {
        m = (0, utils_1.stripCommentsAndVerbatim)(document.lineAt(lineNum).text).match(endPat);
        if (m && m.index !== undefined) {
            return new vscode.Position(lineNum, m.index + m[0].length);
        }
        lineNum += 1;
    }
    return;
}
function getFirstRememberedSubstring(s, pat) {
    const m = s.match(pat);
    if (m && m[1]) {
        return m[1];
    }
    return 'never return here';
}
const MATH_ENV_NAMES = [
    'align', 'align\\*', 'alignat', 'alignat\\*', 'eqnarray', 'eqnarray\\*', 'equation', 'equation\\*', 'flalign', 'flalign\\*', 'gather', 'gather\\*', 'multline', 'multline\\*'
];
function findMath(document, position) {
    const limit = vscode.workspace.getConfiguration('latex-workshop').get('hover.preview.maxLines');
    const envNamePatMathMode = new RegExp(`(${MATH_ENV_NAMES.join('|')})`);
    const envBeginPatMathMode = new RegExp(`\\\\\\[|\\\\\\(|\\\\begin\\{(${MATH_ENV_NAMES.join('|')})\\}`);
    //: /\\\[|\\\(|\\begin\{(align|align\*|alignat|alignat\*|eqnarray|eqnarray\*|equation|equation\*|flalign|flalign\*|gather|gather\*)\}/
    let texMath = findTeX(document, position);
    if (texMath && (texMath.envname === '$' || texMath.envname.match(envNamePatMathMode))) {
        return texMath;
    }
    const beginPos = findBeginPair(document, envBeginPatMathMode, position, limit);
    if (beginPos) {
        texMath = findTeX(document, beginPos);
        if (texMath) {
            const beginEndRange = texMath.range;
            if (beginEndRange.contains(position)) {
                return texMath;
            }
        }
    }
    return;
}
//  \begin{...}                \end{...}
//  ^                          ^
//  return pos                 endPos1
function findBeginPair(document, beginPat, endPos1, limit) {
    const currentLine = document.lineAt(endPos1).text.substring(0, endPos1.character);
    let l = (0, utils_1.stripCommentsAndVerbatim)(currentLine);
    let m = l.match(beginPat);
    if (m && m.index !== undefined) {
        return new vscode.Position(endPos1.line, m.index);
    }
    let lineNum = endPos1.line - 1;
    let i = 0;
    while (lineNum >= 0 && i < limit) {
        l = document.lineAt(lineNum).text;
        l = (0, utils_1.stripCommentsAndVerbatim)(l);
        m = l.match(beginPat);
        if (m && m.index !== undefined) {
            return new vscode.Position(lineNum, m.index);
        }
        lineNum -= 1;
        i += 1;
    }
    return;
}
//# sourceMappingURL=find.js.map