//----------------------
// <auto-generated>
//     Generated using the NSwag toolchain v9.10.19.0 (Newtonsoft.Json v9.0.0.0) (http://NJsonSchema.org)
// </auto-generated>
//----------------------


/* tslint:disable:member-access jsdoc-format */

/** Alias for when a string is actually a base64 representation of a byte array. */
type stringBase64 = string;

/** Describes the kind of data to be formatted. */
/** Describes the kind of data to be formatted. */
export enum DataFormat {
    Default = 'default' as any,
    Email = 'email' as any,
    Token = 'token' as any,
    Path = 'path' as any,
    Text = 'text' as any,
    Uri = 'uri' as any,
    Omit = 'omit' as any,
    OmitDefault = 'omitDefault' as any,
    Hide = 'hide' as any,
    SingleMember = 'singleMember' as any,
}

/** Creates a decorator that saves the property format in a map attached to the class constructor. */
export function dataFormat(...format: any[]) {
    return (target: any, propertyKey: string) => {
        if (!target.constructor.dataFormat) {
            target.constructor.dataFormat = {};
        }
        target.constructor.dataFormat[propertyKey] = format;
    };
}
/**
 * Metadata required to generate proxies for the service interfaces
 * (because TypeScript interfaces cannot be reflected at runtime).
 */
export interface ServiceInfo<T> {
    readonly name?: string;
    readonly methods: string[];
    readonly voidMethods?: string[];
    readonly events: string[];
}


export class EventArgs {
}

/** Notification class for contact service */
export class NotifyContactServiceEventArgs extends EventArgs {
    type!: string;
    body?: any;
}

/** The presence status default options */
export enum PresenceStatus {
    Unknown = <any>'unknown', 
    Available = <any>'available', 
    Busy = <any>'busy', 
    DoNotDisturb = <any>'doNotDisturb', 
    Away = <any>'away', 
    Invisible = <any>'invisible', 
    Offline = <any>'offline', 
}

/** Contact property types */
export enum ContactProperty {
    DisplayName = <any>'displayName', 
    Email = <any>'email', 
    AvatarUri = <any>'avatarUri', 
    Status = <any>'status', 
}

/** Contact entity */
export class Contact {
    id!: string;
    displayName?: string;
    email?: string;
    status?: PresenceStatus;
    avatarUri?: string;
}

/** Empty parameters */
export class EmptyRequest {
}

/** Empty result */
export class EmptyResponse {
}

export class PublishPresenceRequest {
    status!: PresenceStatus;
    properties?: { [key: string]: any; };
}

/** Parameters passed during Initialize method */
export class InitializeRequest {
    clientID!: string;
    workspaceFolders?: WorkspaceFolder[];
    enablePublish?: boolean;
    @dataFormat(PublishPresenceRequest)
    publishPresence?: PublishPresenceRequest;
}

/** Definition of a workspace folder */
export class WorkspaceFolder {
    uri?: WorkspaceUri;
    name?: string;
    index?: number;
}

/** A workspace Uri from vscode */
export class WorkspaceUri {
    scheme?: string;
    path?: string;
    query?: string;
}

/** Capabilities that a service would offer */
export class Capabilities {
    supportsDispose?: boolean;
    supportsPresence?: boolean;
    supportsPublishPresence?: boolean;
    supportsInviteLink?: boolean;
    supportsContactPresenceRequest?: boolean;
    supportsAvailableContacts?: boolean;
    supportsSelfContact?: boolean;
    supportsSearchContacts?: boolean;
    supportsMessageRequest?: boolean;
    supportedPresenceStatus?: PresenceStatus[];
    supportsSignedStateRequest?: boolean;
}

/** Returned on the Initialized method */
export class InitializeResponse {
    /** Description name to display when refering to this provider */
    description!: string;
    /** Supported capabilities */
    @dataFormat(Capabilities)
    capabilities!: Capabilities;
    /** Priority of this provider */
    providerPriority?: number;
    /** The self contact currently being used */
    @dataFormat(Contact)
    selfContact?: Contact;
    signedState?: SignedStatus;
}

/** The signed state option */
export enum SignedStatus {
    None = <any>'none', 
    SignedOut = <any>'signedOut', 
    SigningIn = <any>'signingIn', 
    SignedIn = <any>'signedIn', 
}

/** A presence status changed for a contact entity */
export class ContactPresenceUpdate {
    contactId!: string;
    status!: PresenceStatus;
}

/** Batch of presence changed for multiple contacts */
export class PresenceChangedNotification {
    @dataFormat(ContactPresenceUpdate)
    changes!: ContactPresenceUpdate[];
}

export class ContactPropertyValueChanged {
    property!: ContactProperty;
    value?: any;
}

export class ContactChangedNotification {
    changes!: { [key: string]: ContactPropertyValueChanged[]; };
}

export class ContactPropertiesChangedNotification {
    contactId!: string;
    changes!: { [key: string]: any; };
}

export class InviteRequest {
    targetContactId!: string;
    link!: string;
}

export class InviteReceivedNotification {
    fromContactId!: string;
    link!: string;
    @dataFormat(Contact)
    fromContact?: Contact;
}

export class SelfContactNotification {
    @dataFormat(Contact)
    contact!: Contact;
}

export class ContactsNotification {
    @dataFormat(Contact)
    contacts!: Contact[];
}

export class SuggestedContactsNotification extends ContactsNotification {
    exclusive?: boolean;
}

export class ContactPresenceRequest {
    @dataFormat(Contact)
    contacts!: Contact[];
}

export class ContactResponse {
    contactId!: string;
    @dataFormat(Contact)
    contact!: Contact;
    properties?: { [key: string]: any; };
}

export class ContactPresenceResponse {
    @dataFormat(ContactResponse)
    contacts!: ContactResponse[];
}

export class ContactPresenceDisposeRequest {
    contactIds!: string[];
}

export class SearchContactProperty {
    property!: ContactProperty;
    expression!: string;
    options?: number;
}

export class SearchContactsRequest {
    @dataFormat(SearchContactProperty)
    queryOptions!: SearchContactProperty[];
    maxCount?: number;
}

export class SearchContactsResponse {
    @dataFormat(Contact)
    results!: Contact[];
}

export class MessagePayload {
    type!: string;
    body?: any;
}

export class SendMessageRequest extends MessagePayload {
    targetContactId!: string;
}

export class MessageReceivedNotification extends MessagePayload {
    fromContactId!: string;
}

export class SignInRequest {
}

export class SignedStateChangedNotification {
    state!: SignedStatus;
}

export class AuthenticationRequiredNotification {
}

export enum Methods {
    RequestInitializeName = 'initialize', 
    RequestDisposeName = 'dispose', 
    RequestInviteName = 'inviteLink', 
    RequestPublishPresenceName = 'publishPresence', 
    RequestContactPresenceName = 'contactPresenceRequest', 
    RequestContactPresenceDisposeName = 'contactPresenceDispose', 
    RequestSearchContactsName = 'searchContacts', 
    RequestSendMessageName = 'sendMessageRequest', 
    RequestSignInName = 'signIn', 
    RequestSignOutName = 'signOut', 
    NotifyPresenceChangedName = 'presenceChanged', 
    NotifySelfContactName = 'selfContact', 
    NotifyAvailableUsersName = 'availableUsers', 
    NotifyAvailableUsersAddedName = 'availableUsersAdded', 
    NotifyAvailableUsersRemovedName = 'availableUsersRemoved', 
    NotifyInviteReceivedName = 'inviteLinkReceived', 
    NotifyContactChangedName = 'contactChanged', 
    NotifyContactPropertiesChangedName = 'contactPropertiesChanged', 
    NotifySuggestedUsersName = 'suggestedUsers', 
    NotifyCapabilitiesUpdateName = 'capabilitiesUpdate', 
    NotifyMessageReceivedName = 'messageReceived', 
    NotifySignedStateChangedName = 'signedStateChanged', 
    NotifyAuthenticationRequiredName = 'authenticationRequired', 
}


import { CancellationToken, Event, Progress } from 'vscode';

/**
 * Interface to implement a contact service provider
 */
export interface ContactServiceProvider {
    requestAsync(
        type: string,
        parameters: Object,
        cancellationToken?: CancellationToken)
        : Promise<Object>;

    readonly onNotified: Event<NotifyContactServiceEventArgs>;
}

export const ContactServiceProvider: ServiceInfo<ContactServiceProvider> = {
    methods: [ 'request' ],
    events: [ 'notified' ],
};
