"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeKeeper = exports.TimeoutError = void 0;
class TimeoutError extends Error {
    constructor(s) {
        super(s);
    }
}
exports.TimeoutError = TimeoutError;
class TimeKeeper {
    constructor(timeout) {
        this.timeout = timeout;
        this._start = Date.now();
    }
    check() {
        const now = Date.now();
        if ((now - this._start) > this.timeout) {
            throw new TimeoutError('could not complete parsing within the given time.');
        }
    }
}
exports.TimeKeeper = TimeKeeper;
//# sourceMappingURL=timeout.js.map