"use strict";
/**
 * Defines node types of LaTeX AST.
 *
 * Users don't have to import this module directly.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAstPreamble = exports.isAstRoot = exports.isElement = exports.hasArgsArray = exports.hasContentArray = exports.hasContent = exports.isMathDelimiters = exports.isMatchingDelimiters = exports.isMathCharacter = exports.isDisplayMath = exports.isInlineMath = exports.isLstlisting = exports.isMinted = exports.isVerbatim = exports.isVerb = exports.isIgnore = exports.isActiveCharacter = exports.isCommandParameter = exports.isAlignmentTab = exports.isSubscript = exports.isSuperscript = exports.isLinebreak = exports.isSoftbreak = exports.isSpace = exports.isParbreak = exports.isOptionalArg = exports.isGroup = exports.isMathEnvAligned = exports.isMathEnv = exports.isEnvironment = exports.isLabelCommand = exports.isHrefCommand = exports.isUrlCommand = exports.isDefCommand = exports.isAmsMathTextCommand = exports.isCommand = exports.isTextString = void 0;
function isTextString(node) {
    return !!node && node.kind === 'text.string';
}
exports.isTextString = isTextString;
function isCommand(node) {
    return !!node && node.kind === 'command';
}
exports.isCommand = isCommand;
function isAmsMathTextCommand(node) {
    return !!node && node.kind === 'command.text';
}
exports.isAmsMathTextCommand = isAmsMathTextCommand;
function isDefCommand(node) {
    return !!node && node.kind === 'command.def';
}
exports.isDefCommand = isDefCommand;
function isUrlCommand(node) {
    return !!node && node.kind === 'command.url';
}
exports.isUrlCommand = isUrlCommand;
function isHrefCommand(node) {
    return !!node && node.kind === 'command.href';
}
exports.isHrefCommand = isHrefCommand;
function isLabelCommand(node) {
    return !!node && node.kind === 'command.label';
}
exports.isLabelCommand = isLabelCommand;
function isEnvironment(node) {
    return !!node && node.kind === 'env';
}
exports.isEnvironment = isEnvironment;
function isMathEnv(node) {
    return !!node && node.kind === 'env.math.align';
}
exports.isMathEnv = isMathEnv;
function isMathEnvAligned(node) {
    return !!node && node.kind === 'env.math.aligned';
}
exports.isMathEnvAligned = isMathEnvAligned;
function isGroup(node) {
    return !!node && node.kind === 'arg.group';
}
exports.isGroup = isGroup;
function isOptionalArg(node) {
    return !!node && node.kind === 'arg.optional';
}
exports.isOptionalArg = isOptionalArg;
function isParbreak(node) {
    return !!node && node.kind === 'parbreak';
}
exports.isParbreak = isParbreak;
function isSpace(node) {
    return !!node && node.kind === 'space';
}
exports.isSpace = isSpace;
function isSoftbreak(node) {
    return !!node && node.kind === 'softbreak';
}
exports.isSoftbreak = isSoftbreak;
function isLinebreak(node) {
    return !!node && node.kind === 'linebreak';
}
exports.isLinebreak = isLinebreak;
function isSuperscript(node) {
    return !!node && node.kind === 'superscript';
}
exports.isSuperscript = isSuperscript;
function isSubscript(node) {
    return !!node && node.kind === 'subscript';
}
exports.isSubscript = isSubscript;
function isAlignmentTab(node) {
    return !!node && node.kind === 'alignmentTab';
}
exports.isAlignmentTab = isAlignmentTab;
function isCommandParameter(node) {
    return !!node && node.kind === 'commandParameter';
}
exports.isCommandParameter = isCommandParameter;
function isActiveCharacter(node) {
    return !!node && node.kind === 'activeCharacter';
}
exports.isActiveCharacter = isActiveCharacter;
function isIgnore(node) {
    return !!node && node.kind === 'ignore';
}
exports.isIgnore = isIgnore;
function isVerb(node) {
    return !!node && node.kind === 'verb';
}
exports.isVerb = isVerb;
function isVerbatim(node) {
    return !!node && node.kind === 'env.verbatim';
}
exports.isVerbatim = isVerbatim;
function isMinted(node) {
    return !!node && node.kind === 'env.minted';
}
exports.isMinted = isMinted;
function isLstlisting(node) {
    return !!node && node.kind === 'env.lstlisting';
}
exports.isLstlisting = isLstlisting;
function isInlineMath(node) {
    return !!node && node.kind === 'inlineMath';
}
exports.isInlineMath = isInlineMath;
function isDisplayMath(node) {
    return !!node && node.kind === 'displayMath';
}
exports.isDisplayMath = isDisplayMath;
function isMathCharacter(node) {
    return !!node && node.kind === 'math.character';
}
exports.isMathCharacter = isMathCharacter;
function isMatchingDelimiters(node) {
    return !!node && node.kind === 'math.matching_delimiters';
}
exports.isMatchingDelimiters = isMatchingDelimiters;
function isMathDelimiters(node) {
    return !!node && node.kind === 'math.math_delimiters';
}
exports.isMathDelimiters = isMathDelimiters;
function hasContent(node) {
    return !!node && node.hasOwnProperty('content');
}
exports.hasContent = hasContent;
function hasContentArray(node) {
    return !!node && node.hasOwnProperty('content') && Array.isArray(node['content']);
}
exports.hasContentArray = hasContentArray;
function hasArgsArray(node) {
    return !!node && node.hasOwnProperty('args') && Array.isArray(node['args']);
}
exports.hasArgsArray = hasArgsArray;
function isElement(node) {
    return !!node && !isSpace(node) && !isSoftbreak(node);
}
exports.isElement = isElement;
function isAstRoot(ast) {
    return ast.kind === 'ast.root';
}
exports.isAstRoot = isAstRoot;
function isAstPreamble(ast) {
    return ast.kind === 'ast.preamble';
}
exports.isAstPreamble = isAstPreamble;
//# sourceMappingURL=latex_parser_types.js.map