"use strict";
/**
 * LaTeX parser.
 *
 * @example
 * ```ts
 * import {latexParser as lp} from 'latex-utensils'
 *
 * const ast = lp.parse('a $b+c$ d')
 * const pat = lp.pattern(lp.isInlineMath)
 *               .child(lp.isMathCharacter)
 * const ret0 = pat.matchAll(ast.content)
 * const ret1 = lp.find(ast.content, lp.isInlineMath)
 * ```
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parsePreamble = exports.parse = exports.isSyntaxError = exports.stringify = exports.pattern = exports.findNodeAt = exports.findAllSequences = exports.findAll = exports.find = void 0;
const lpSimple = require("./latex_parser_simple");
const lpWithTrace = require("./latex_parser_trace");
const timeout_1 = require("../pegjs/timeout");
var find_all_1 = require("./find_all");
Object.defineProperty(exports, "find", { enumerable: true, get: function () { return find_all_1.find; } });
Object.defineProperty(exports, "findAll", { enumerable: true, get: function () { return find_all_1.findAll; } });
Object.defineProperty(exports, "findAllSequences", { enumerable: true, get: function () { return find_all_1.findAllSequences; } });
Object.defineProperty(exports, "findNodeAt", { enumerable: true, get: function () { return find_all_1.findNodeAt; } });
var matcher_1 = require("./matcher");
Object.defineProperty(exports, "pattern", { enumerable: true, get: function () { return matcher_1.pattern; } });
var stringify_1 = require("./stringify");
Object.defineProperty(exports, "stringify", { enumerable: true, get: function () { return stringify_1.stringify; } });
__exportStar(require("./latex_parser_types"), exports);
var pegjs_types_1 = require("../pegjs/pegjs_types");
Object.defineProperty(exports, "isSyntaxError", { enumerable: true, get: function () { return pegjs_types_1.isSyntaxError; } });
/**
 * Parses a LaTeX document and returns a LaTeX AST.
 * @param texString LaTeX document to be parsed.
 * @param optArg Options.
 *
 * @example
 * ```ts
 * import {latexParser} from 'latex-utensils'
 *
 * const ast = latexParser.parse('a $b+c$ d')
 * ```
 */
function parse(texString, optArg) {
    const option = optArg ? Object.assign({}, optArg) : undefined;
    if (option && option.timeout) {
        if (typeof option.timeout !== 'object') {
            option.timeout = new timeout_1.TimeKeeper(option.timeout);
        }
    }
    if (option && option.tracer) {
        return lpWithTrace.parse(texString, option);
    }
    else {
        return lpSimple.parse(texString, option);
    }
}
exports.parse = parse;
/**
 *
 * @param texString
 * @param optArg
 */
function parsePreamble(texString, optArg) {
    const timeout = optArg && optArg.timeout;
    return parse(texString, { startRule: 'Preamble', timeout });
}
exports.parsePreamble = parsePreamble;
//# sourceMappingURL=latex_parser.js.map