"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isConcatValue = exports.isAbbreviationValue = exports.isNumberValue = exports.isTextStringValue = exports.isPreambleEntry = exports.isStringEntry = exports.isEntry = void 0;
function isEntry(e) {
    return !isStringEntry(e) && !isPreambleEntry(e);
}
exports.isEntry = isEntry;
function isStringEntry(e) {
    return e.entryType === 'string';
}
exports.isStringEntry = isStringEntry;
function isPreambleEntry(e) {
    return e.entryType === 'preamble';
}
exports.isPreambleEntry = isPreambleEntry;
function isTextStringValue(e) {
    return e.kind === 'text_string';
}
exports.isTextStringValue = isTextStringValue;
function isNumberValue(e) {
    return e.kind === 'number';
}
exports.isNumberValue = isNumberValue;
function isAbbreviationValue(e) {
    return e.kind === 'abbreviation';
}
exports.isAbbreviationValue = isAbbreviationValue;
function isConcatValue(e) {
    return e.kind === 'concat';
}
exports.isConcatValue = isConcatValue;
//# sourceMappingURL=bibtex_parser_types.js.map