"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsReadWriteStream = exports.constructMessageConnection = void 0;
const assert = require("assert");
/**
 * Constructs a message connection to a given pipe
 * @param pipe The channel or duplex to use for communicating
 */
function constructMessageConnection(pipe, connectionFactory) {
    assert(pipe);
    let rpc;
    if (IsReadWriteStream(pipe)) {
        rpc = connectionFactory(pipe);
        pipe.on('close', () => {
            rpc === null || rpc === void 0 ? void 0 : rpc.dispose();
        });
        rpc.onDispose(() => pipe.end());
        rpc.onClose(() => pipe.end());
    }
    else {
        rpc = connectionFactory(pipe.stream);
        pipe.completion.then(() => {
            rpc === null || rpc === void 0 ? void 0 : rpc.dispose();
        });
        rpc.onDispose(() => pipe.dispose());
        rpc.onClose(() => pipe.dispose());
    }
    return rpc;
}
exports.constructMessageConnection = constructMessageConnection;
function IsReadWriteStream(object) {
    return 'unshift' in object;
}
exports.IsReadWriteStream = IsReadWriteStream;

// SIG // Begin signature block
// SIG // MIIhgQYJKoZIhvcNAQcCoIIhcjCCIW4CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // wrM9NfLatnBp5MvvLbEWGk3rgyf6p9x39V1mkoh08uCg
// SIG // ggtyMIIE+jCCA+KgAwIBAgITMwAAAyVIsp0Of8X0HwAA
// SIG // AAADJTANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTIwMDMwNDE4MjkyOVoX
// SIG // DTIxMDMwMzE4MjkyOVowdDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEeMBwGA1UEAxMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // o6USNjR5nReBPqM/t9oEDRVn4lgP4FtusaT6n9JeO7ff
// SIG // aeyCCneQrkwDHjzWFlx0k/KRX2/MmkzVs+pxAmm4UEwi
// SIG // MQKrQM1aQjVl4rkA3tfHhFKFBTdrIKDIaVO4G9IGYoG4
// SIG // b855k9JqKu6KwRADHK1ugvPPvScqlgYAytDAW6cYyMAb
// SIG // 9Lj4I90eNCLTC0MPS29EgZ64jhD0ChgwjtgCOjEovvsX
// SIG // uWFzpEGaywg3Ok5f3/30859QoviUe2CTHXavH9jXuNqI
// SIG // LFFSFuiR/Eimy0F2/cTlZ+HzIhvW+j4EboAKUtCCgFCP
// SIG // DkENpEq9mtQbChGPQezDVHhQVwe+Dq7rWQIDAQABo4IB
// SIG // eTCCAXUwHwYDVR0lBBgwFgYKKwYBBAGCNz0GAQYIKwYB
// SIG // BQUHAwMwHQYDVR0OBBYEFC3CjwCdK+IVK01UmJqWuUQP
// SIG // rh58MFAGA1UdEQRJMEekRTBDMSkwJwYDVQQLEyBNaWNy
// SIG // b3NvZnQgT3BlcmF0aW9ucyBQdWVydG8gUmljbzEWMBQG
// SIG // A1UEBRMNMjMwODY1KzQ1ODQ5MzAfBgNVHSMEGDAWgBTm
// SIG // /F97uyIAWORyTrX0IXQjMubvrDBWBgNVHR8ETzBNMEug
// SIG // SaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0FfMjAxMC0w
// SIG // Ny0wNi5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUF
// SIG // BzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NlcnRzL01pY0NvZFNpZ1BDQV8yMDEwLTA3LTA2LmNy
// SIG // dDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4IB
// SIG // AQBcc+DvnFngaPOnuRCJolHiV6CeYbicB+pd2FAS4Qbf
// SIG // rfrhOsw7QapsoHgKvqjLN6LWrnE5julRMi0QAmu2MfMc
// SIG // QyyuzAHJ8cAGOkmI3IhKzbA39bQKXmZAiCDRVv/EtkCj
// SIG // EkF3+DiaJY1h6NU5J4i/SEZs74jfZeNjWDSQfYu9Xs8T
// SIG // /umTeDw1ovEFXu9HRgi5fTtkcT0BYRHJd41nQruQtRQ0
// SIG // YOqjKXMd6rHkEdkBePneBBP1ENYd2HkoW7bs8X9JLGwZ
// SIG // 0KlVNmSfRPxiVE1lErGMbCZxvMYNxuOic97bX1RN3KDC
// SIG // yodXx6rCN11yJVc09wSMdzfZy4NfIcDjbbuZMIIGcDCC
// SIG // BFigAwIBAgIKYQxSTAAAAAAAAzANBgkqhkiG9w0BAQsF
// SIG // ADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAGA1UEAxMp
// SIG // TWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
// SIG // aXR5IDIwMTAwHhcNMTAwNzA2MjA0MDE3WhcNMjUwNzA2
// SIG // MjA1MDE3WjB+MQswCQYDVQQGEwJVUzETMBEGA1UECBMK
// SIG // V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwG
// SIG // A1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSgwJgYD
// SIG // VQQDEx9NaWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQSAy
// SIG // MDEwMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEA6Q5kUHlntcTj/QkATJ6UrPdWaOpE2M/FWE+ppXZ8
// SIG // bUW60zmStKQe+fllguQX0o/9RJwI6GWTzixVhL99COMu
// SIG // K6hBKxi3oktuSUxrFQfe0dLCiR5xlM21f0u0rwjYzIjW
// SIG // axeUOpPOJj/s5v40mFfVHV1J9rIqLtWFu1k/+JC0K4N0
// SIG // yiuzO0bj8EZJwRdmVMkcvR3EVWJXcvhnuSUgNN5dpqWV
// SIG // XqsogM3Vsp7lA7Vj07IUyMHIiiYKWX8H7P8O7YASNUwS
// SIG // pr5SW/Wm2uCLC0h31oVH1RC5xuiq7otqLQVcYMa0Kluc
// SIG // IxxfReMaFB5vN8sZM4BqiU2jamZjeJPVMM+VHwIDAQAB
// SIG // o4IB4zCCAd8wEAYJKwYBBAGCNxUBBAMCAQAwHQYDVR0O
// SIG // BBYEFOb8X3u7IgBY5HJOtfQhdCMy5u+sMBkGCSsGAQQB
// SIG // gjcUAgQMHgoAUwB1AGIAQwBBMAsGA1UdDwQEAwIBhjAP
// SIG // BgNVHRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFNX2VsuP
// SIG // 6KJcYmjRPZSQW9fOmhjEMFYGA1UdHwRPME0wS6BJoEeG
// SIG // RWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3Js
// SIG // L3Byb2R1Y3RzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIz
// SIG // LmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKG
// SIG // Pmh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2Vy
// SIG // dHMvTWljUm9vQ2VyQXV0XzIwMTAtMDYtMjMuY3J0MIGd
// SIG // BgNVHSAEgZUwgZIwgY8GCSsGAQQBgjcuAzCBgTA9Bggr
// SIG // BgEFBQcCARYxaHR0cDovL3d3dy5taWNyb3NvZnQuY29t
// SIG // L1BLSS9kb2NzL0NQUy9kZWZhdWx0Lmh0bTBABggrBgEF
// SIG // BQcCAjA0HjIgHQBMAGUAZwBhAGwAXwBQAG8AbABpAGMA
// SIG // eQBfAFMAdABhAHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG
// SIG // 9w0BAQsFAAOCAgEAGnTvV08pe8QWhXi4UNMi/AmdrIKX
// SIG // +DT/KiyXlRLl5L/Pv5PI4zSp24G43B4AvtI1b6/lf3mV
// SIG // d+UC1PHr2M1OHhthosJaIxrwjKhiUUVnCOM/PB6T+DCF
// SIG // F8g5QKbXDrMhKeWloWmMIpPMdJjnoUdD8lOswA8waX/+
// SIG // 0iUgbW9h098H1dlyACxphnY9UdumOUjJN2FtB91TGcun
// SIG // 1mHCv+KDqw/ga5uV1n0oUbCJSlGkmmzItx9KGg5pqdfc
// SIG // wX7RSXCqtq27ckdjF/qm1qKmhuyoEESbY7ayaYkGx0aG
// SIG // ehg/6MUdIdV7+QIjLcVBy78dTMgW77Gcf/wiS0mKbhXj
// SIG // pn92W9FTeZGFndXS2z1zNfM8rlSyUkdqwKoTldKOEdqZ
// SIG // Z14yjPs3hdHcdYWch8ZaV4XCv90Nj4ybLeu07s8n07Ve
// SIG // afqkFgQBpyRnc89NT7beBVaXevfpUk30dwVPhcbYC/GO
// SIG // 7UIJ0Q124yNWeCImNr7KsYxuqh3khdpHM2KPpMmRM19x
// SIG // HkCvmGXJIuhCISWKHC1g2TeJQYkqFg/XYTyUaGBS79ZH
// SIG // maCAQO4VgXc+nOBTGBpQHTiVmx5mMxMnORd4hzbOTsNf
// SIG // svU9R1O24OXbC2E9KteSLM43Wj5AQjGkHxAIwlacvyRd
// SIG // UQKdannSF9PawZSOB3slcUSrBmrm1MbfI5qWdcUxghVn
// SIG // MIIVYwIBATCBlTB+MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSgw
// SIG // JgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBTaWduaW5nIFBD
// SIG // QSAyMDEwAhMzAAADJUiynQ5/xfQfAAAAAAMlMA0GCWCG
// SIG // SAFlAwQCAQUAoIGuMBkGCSqGSIb3DQEJAzEMBgorBgEE
// SIG // AYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3
// SIG // AgEVMC8GCSqGSIb3DQEJBDEiBCC8mDANcoi1RDKkrqkq
// SIG // oRuLQQvb6QbySXfgIjGeAqg2rjBCBgorBgEEAYI3AgEM
// SIG // MTQwMqAUgBIATQBpAGMAcgBvAHMAbwBmAHShGoAYaHR0
// SIG // cDovL3d3dy5taWNyb3NvZnQuY29tMA0GCSqGSIb3DQEB
// SIG // AQUABIIBAGwoGmIkT7SZ90ibvjzvDpoi7EpbIGzDgmqZ
// SIG // L7bhMJPdAH7uS27syQ+B7Nz5zx8z0/QdFLJX67b2tsqw
// SIG // R84WqVKJVfJ/sJPFPlK4mljgJc0Xuiw5gpAsaRHFeGp5
// SIG // C8QcOVxGl5xZsAgalngLeD7QT/kmr8luLijMkpbif0/P
// SIG // 7Z1axsRt3uDXly2wV1yPxBbB5G4/O3LpIlviTFI/wZX9
// SIG // BSm+ADwdWCSZLWIRX9Nfrf6Q6GFt1K77SUsCkS77MOy6
// SIG // V9kk6hJKoD02bjnDLhcMj1ou5vCkYFh3XOwUu98jr4qB
// SIG // YZrb5lkcX6XxqSQ3GaDmdumIaLouZYtFf7QcP1UGKs+h
// SIG // ghLxMIIS7QYKKwYBBAGCNwMDATGCEt0wghLZBgkqhkiG
// SIG // 9w0BBwKgghLKMIISxgIBAzEPMA0GCWCGSAFlAwQCAQUA
// SIG // MIIBVQYLKoZIhvcNAQkQAQSgggFEBIIBQDCCATwCAQEG
// SIG // CisGAQQBhFkKAwEwMTANBglghkgBZQMEAgEFAAQgRAzR
// SIG // zg7rUMZMB7SNhI0GW7cLaKMTAl/B09dQ8l3F67kCBl7V
// SIG // A8yCDhgTMjAyMDA2MTExODQ1MjYuNTg2WjAEgAIB9KCB
// SIG // 1KSB0TCBzjELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEpMCcGA1UE
// SIG // CxMgTWljcm9zb2Z0IE9wZXJhdGlvbnMgUHVlcnRvIFJp
// SIG // Y28xJjAkBgNVBAsTHVRoYWxlcyBUU1MgRVNOOjIxNjQt
// SIG // RTM1Qy0yMDQ0MSUwIwYDVQQDExxNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBTZXJ2aWNloIIORDCCBPUwggPdoAMCAQIC
// SIG // EzMAAAEpsFdWC6/1l/sAAAAAASkwDQYJKoZIhvcNAQEL
// SIG // BQAwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMd
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwHhcN
// SIG // MTkxMjE5MDExNTAxWhcNMjEwMzE3MDExNTAxWjCBzjEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEpMCcGA1UECxMgTWljcm9z
// SIG // b2Z0IE9wZXJhdGlvbnMgUHVlcnRvIFJpY28xJjAkBgNV
// SIG // BAsTHVRoYWxlcyBUU1MgRVNOOjIxNjQtRTM1Qy0yMDQ0
// SIG // MSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBT
// SIG // ZXJ2aWNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
// SIG // CgKCAQEA2oMenbKtSkDyvHLxUDGYfZDDflDzzx2yB5jl
// SIG // LAvPvg5ajo6MmS1pz1jR9TEdhq0uelmbbwZi2XLthkaE
// SIG // u9ywk09VY7H82qw3ZFJW5092bENTqiEwjRPOcXQ5gYhY
// SIG // zAamaVBHc9cc4FBckXrEWLdzTaJpY8UKbjNH04Phu7dx
// SIG // NIWGoOslY1cC3DOKrZIOsR6xy2ulKKqZF+Z3+yvOPnYG
// SIG // NT7AhT4NzTWLWGEalkwXBteWB4u/IuwCErXZX2MsTPc1
// SIG // U+AiTkOwVXAE2FTRjKBVTMdtB53bNFv+EdZVYmbBGt70
// SIG // Lvmcap0MTRGdcJMvECtjWeeZjOLzRUxKzy96agXNHQID
// SIG // AQABo4IBGzCCARcwHQYDVR0OBBYEFI1UPz3Vl+3GHwgN
// SIG // nc+ix9eLYkKPMB8GA1UdIwQYMBaAFNVjOlyKMZDzQ3t8
// SIG // RhvFM2hahW1VMFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6
// SIG // Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1
// SIG // Y3RzL01pY1RpbVN0YVBDQV8yMDEwLTA3LTAxLmNybDBa
// SIG // BggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6
// SIG // Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWlj
// SIG // VGltU3RhUENBXzIwMTAtMDctMDEuY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDQYJKoZI
// SIG // hvcNAQELBQADggEBAAio7rLQHNf87ep+FQMxrMGsrDbJ
// SIG // /s3LcV7iCRqvl+wp5J41vNIrgCLhlfxS8fHAPqBl/Qzv
// SIG // AkdiF5bSNAzkFWo/lPayM4dXfkTtaaeyuBRUSIndmIoZ
// SIG // oSLo8zM5/vxjl+qFAq1b0d1F67bQFxQvbx7p65GWKjdA
// SIG // qg53tcS6ezBqUDudveEwZFzZzDUS/eRurMTeWwchOXIU
// SIG // 1YkyGNhCIsoTad4U/IVhQ4ERZNUmS+mgBxi77QSOxW2t
// SIG // bMt5w6HMFXnjPIaKZMQLspQP6y4Ttyy8qlbwQCjzOL0f
// SIG // OAlr9f7jE4drVen5iHBBdVyAiB7IGWAvpY8UmAisTSTk
// SIG // cBbxhLkwggZxMIIEWaADAgECAgphCYEqAAAAAAACMA0G
// SIG // CSqGSIb3DQEBCwUAMIGIMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MTIwMAYDVQQDEylNaWNyb3NvZnQgUm9vdCBDZXJ0aWZp
// SIG // Y2F0ZSBBdXRob3JpdHkgMjAxMDAeFw0xMDA3MDEyMTM2
// SIG // NTVaFw0yNTA3MDEyMTQ2NTVaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0
// SIG // YW1wIFBDQSAyMDEwMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAqR0NvHcRijog7PwTl/X6f2mUa3RU
// SIG // ENWlCgCChfvtfGhLLF/Fw+Vhwna3PmYrW/AVUycEMR9B
// SIG // GxqVHc4JE458YTBZsTBED/FgiIRUQwzXTbg4CLNC3ZOs
// SIG // 1nMwVyaCo0UN0Or1R4HNvyRgMlhgRvJYR4YyhB50YWeR
// SIG // X4FUsc+TTJLBxKZd0WETbijGGvmGgLvfYfxGwScdJGcS
// SIG // chohiq9LZIlQYrFd/XcfPfBXday9ikJNQFHRD5wGPmd/
// SIG // 9WbAA5ZEfu/QS/1u5ZrKsajyeioKMfDaTgaRtogINeh4
// SIG // HLDpmc085y9Euqf03GS9pAHBIAmTeM38vMDJRF1eFpwB
// SIG // BU8iTQIDAQABo4IB5jCCAeIwEAYJKwYBBAGCNxUBBAMC
// SIG // AQAwHQYDVR0OBBYEFNVjOlyKMZDzQ3t8RhvFM2hahW1V
// SIG // MBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIAQwBBMAsGA1Ud
// SIG // DwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQY
// SIG // MBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjEMFYGA1UdHwRP
// SIG // ME0wS6BJoEeGRWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNv
// SIG // bS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jvb0NlckF1dF8y
// SIG // MDEwLTA2LTIzLmNybDBaBggrBgEFBQcBAQROMEwwSgYI
// SIG // KwYBBQUHMAKGPmh0dHA6Ly93d3cubWljcm9zb2Z0LmNv
// SIG // bS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0XzIwMTAtMDYt
// SIG // MjMuY3J0MIGgBgNVHSABAf8EgZUwgZIwgY8GCSsGAQQB
// SIG // gjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9kZWZhdWx0
// SIG // Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUAZwBhAGwA
// SIG // XwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBtAGUAbgB0
// SIG // AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAB+aIUQ3ixuCY
// SIG // P4FxAz2do6Ehb7Prpsz1Mb7PBeKp/vpXbRkws8LFZslq
// SIG // 3/Xn8Hi9x6ieJeP5vO1rVFcIK1GCRBL7uVOMzPRgEop2
// SIG // zEBAQZvcXBf/XPleFzWYJFZLdO9CEMivv3/Gf/I3fVo/
// SIG // HPKZeUqRUgCvOA8X9S95gWXZqbVr5MfO9sp6AG9LMEQk
// SIG // IjzP7QOllo9ZKby2/QThcJ8ySif9Va8v/rbljjO7Yl+a
// SIG // 21dA6fHOmWaQjP9qYn/dxUoLkSbiOewZSnFjnXshbcOc
// SIG // o6I8+n99lmqQeKZt0uGc+R38ONiU9MalCpaGpL2eGq4E
// SIG // QoO4tYCbIjggtSXlZOz39L9+Y1klD3ouOVd2onGqBooP
// SIG // iRa6YacRy5rYDkeagMXQzafQ732D8OE7cQnfXXSYIghh
// SIG // 2rBQHm+98eEA3+cxB6STOvdlR3jo+KhIq/fecn5ha293
// SIG // qYHLpwmsObvsxsvYgrRyzR30uIUBHoD7G4kqVDmyW9rI
// SIG // DVWZeodzOwjmmC3qjeAzLhIp9cAvVCch98isTtoouLGp
// SIG // 25ayp0Kiyc8ZQU3ghvkqmqMRZjDTu3QyS99je/WZii8b
// SIG // xyGvWbWu3EQ8l1Bx16HSxVXjad5XwdHeMMD9zOZN+w2/
// SIG // XU/pnR4ZOC+8z1gFLu8NoFA12u8JJxzVs341Hgi62jbb
// SIG // 01+P3nSISRKhggLSMIICOwIBATCB/KGB1KSB0TCBzjEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEpMCcGA1UECxMgTWljcm9z
// SIG // b2Z0IE9wZXJhdGlvbnMgUHVlcnRvIFJpY28xJjAkBgNV
// SIG // BAsTHVRoYWxlcyBUU1MgRVNOOjIxNjQtRTM1Qy0yMDQ0
// SIG // MSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBT
// SIG // ZXJ2aWNloiMKAQEwBwYFKw4DAhoDFQCzMmyz9EI68V7m
// SIG // dpLdUoBXjSIsl6CBgzCBgKR+MHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0
// SIG // YW1wIFBDQSAyMDEwMA0GCSqGSIb3DQEBBQUAAgUA4oyw
// SIG // yDAiGA8yMDIwMDYxMTE3MzE1MloYDzIwMjAwNjEyMTcz
// SIG // MTUyWjB3MD0GCisGAQQBhFkKBAExLzAtMAoCBQDijLDI
// SIG // AgEAMAoCAQACAho2AgH/MAcCAQACAhGjMAoCBQDijgJI
// SIG // AgEAMDYGCisGAQQBhFkKBAIxKDAmMAwGCisGAQQBhFkK
// SIG // AwKgCjAIAgEAAgMHoSChCjAIAgEAAgMBhqAwDQYJKoZI
// SIG // hvcNAQEFBQADgYEAJjuJPSgXV3UckAkI6MmyMQ0jXTyW
// SIG // YdSHVtLTwYRNx/eUnPVyL7l2o0pW2C9k/01PLSQhijed
// SIG // vgWN+pG0wo0qo1asJT13ezr89jdCpk44rrkBG3lLd+Xj
// SIG // lQJfU1+Z1PsFlgF42wIc/+7twa+V0qpxqPHsxqPQBFID
// SIG // Cf4xPQn/DB4xggMNMIIDCQIBATCBkzB8MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0EgMjAxMAITMwAAASmwV1YLr/WX+wAA
// SIG // AAABKTANBglghkgBZQMEAgEFAKCCAUowGgYJKoZIhvcN
// SIG // AQkDMQ0GCyqGSIb3DQEJEAEEMC8GCSqGSIb3DQEJBDEi
// SIG // BCDDZ6U8EZWr/nU8NyEWYOtvJl+whJEdpcyIODrKiayo
// SIG // YDCB+gYLKoZIhvcNAQkQAi8xgeowgecwgeQwgb0EIL7+
// SIG // YD7nnRArSn/79rEM4pnofjLW0i2lq/49NVH93yUGMIGY
// SIG // MIGApH4wfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UE
// SIG // AxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAC
// SIG // EzMAAAEpsFdWC6/1l/sAAAAAASkwIgQgPda4G5cahbR7
// SIG // T89UWhFq+p+O77ezEctwvicMS9dMCakwDQYJKoZIhvcN
// SIG // AQELBQAEggEAY3spT/UFI/4XDxbi3SF3RToFUzTTzMWl
// SIG // soOaHt+dVBT2BLul1PK/Ng4iyo7SIbf3a2YwjJ5zbYUq
// SIG // BFUZJYTmINucw+6GBvXrkZqOHy6MFXlh9S+kC+Af5MSa
// SIG // WxteiXs40sQAszPNKF29rS5XyLq5b4MpRcAgA1DbRTzq
// SIG // AUHb03//gusWoufHf86iH7Z8S79AYXtwlqBwJeP2nhYd
// SIG // MhtBusxiowQfyftwQt5/2+AvEu1Yb9CbtKjTMqa9Y3sm
// SIG // Q1VTcsLerOdJLE2FWt+f0cTfHYIAOUQmajFvAnfsebUp
// SIG // zC7zg2Pa1IeZL99na+nCpmOtM4Z+RwBGgKe2NP2Dtum92g==
// SIG // End signature block
