"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxyForIRemoteServiceBroker = void 0;
const assert = require("assert");
const cancellationtoken_1 = require("cancellationtoken");
const events_1 = require("events");
const constants_1 = require("./constants");
/**
 * A wrapper for the [IRemoteServiceBroker](#IRemoteServiceBroker) interface around an RPC connection
 * TODO: remove this when/if we determine the dynamic proxy creator can handle it.
 */
class ProxyForIRemoteServiceBroker extends events_1.EventEmitter {
    /**
     * Initializes a new instance of the [RemoteRpcServiceBroker](#RemoteRpcServiceBroker) class
     * @param rpc The RPC message connection to use in sending requests
     */
    constructor(rpc) {
        super();
        this.rpc = rpc;
        this.isDisposedRpc = false;
        assert(rpc);
        this.rpc.onDispose(() => {
            this.isDisposedRpc = true;
            this.dispose();
        });
        this.rpc.onNotification(constants_1.availabilityChangedEvent, (args) => {
            this.emit('availabilityChanged', args);
        });
        rpc.listen();
    }
    async handshake(clientMetadata, cancellationToken = cancellationtoken_1.default.CONTINUE) {
        if (!this.isDisposedRpc) {
            return await this.rpc.sendRequest('handshake', [clientMetadata]);
        }
    }
    async requestServiceChannel(moniker, options, cancellationToken = cancellationtoken_1.default.CONTINUE) {
        if (!this.isDisposedRpc) {
            const response = await this.rpc.sendRequest('requestServiceChannel', [moniker, options]);
            return response;
        }
        // In .NET this is a struct, so `null` is never returned over RPC. We emulate that.
        return {};
    }
    async cancelServiceRequest(serviceRequestId, cancellationToken = cancellationtoken_1.default.CONTINUE) {
        if (!this.isDisposedRpc) {
            await this.rpc.sendRequest('cancelServiceRequest', [serviceRequestId]);
        }
    }
    dispose() {
        if (!this.isDisposedRpc) {
            this.rpc.dispose();
            this.isDisposedRpc = true;
        }
    }
}
exports.ProxyForIRemoteServiceBroker = ProxyForIRemoteServiceBroker;

// SIG // Begin signature block
// SIG // MIIheQYJKoZIhvcNAQcCoIIhajCCIWYCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // uugZe6lsa+RZh6aQQ34Ygsmf6LhkvPMipLWLOqXFAAqg
// SIG // ggt2MIIE/jCCA+agAwIBAgITMwAAAyauzu35vOR7kgAA
// SIG // AAADJjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTIwMDMwNDE4MjkyOVoX
// SIG // DTIxMDMwMzE4MjkyOVowdDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEeMBwGA1UEAxMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // nZc0xLte0Zp4PVs0bsm9sbjvgdQcrPi/jo5HMBqVz3i/
// SIG // v58maYsTXTnKfo5YVLnOEdTQzdMajP+5bGM0UaIFyUWO
// SIG // t9e0afja/7xLEMQRr/B7aYO5HkhHCTmdhZfGGUI6tk21
// SIG // xW4y/3lnK336zimaOVrPFlXcdUGrqyy8UoBvPbAkOutq
// SIG // HQ17LE7N3G0Xj62tBLgulvRiJGyu3SHrlQ6iUDNcrsi/
// SIG // U2BkvrpZWGHZtEbO0+vXPrryzcJvvu+9InEYRdnLdC3S
// SIG // Fi580IVdmpeUP8RxhDO8jbPKI/B8MZwt6/PlamNT5RDS
// SIG // aQdRbeDBU1p75SOn+/bHlMQpNvl3KxUZzQIDAQABo4IB
// SIG // fTCCAXkwHwYDVR0lBBgwFgYKKwYBBAGCNz0GAQYIKwYB
// SIG // BQUHAwMwHQYDVR0OBBYEFF1zu5HCevZdHtlOyC0v4AOr
// SIG // ptwSMFQGA1UdEQRNMEukSTBHMS0wKwYDVQQLEyRNaWNy
// SIG // b3NvZnQgSXJlbGFuZCBPcGVyYXRpb25zIExpbWl0ZWQx
// SIG // FjAUBgNVBAUTDTIzMDg2NSs0NTg0OTQwHwYDVR0jBBgw
// SIG // FoAU5vxfe7siAFjkck619CF0IzLm76wwVgYDVR0fBE8w
// SIG // TTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29t
// SIG // L3BraS9jcmwvcHJvZHVjdHMvTWljQ29kU2lnUENBXzIw
// SIG // MTAtMDctMDYuY3JsMFoGCCsGAQUFBwEBBE4wTDBKBggr
// SIG // BgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29t
// SIG // L3BraS9jZXJ0cy9NaWNDb2RTaWdQQ0FfMjAxMC0wNy0w
// SIG // Ni5jcnQwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsF
// SIG // AAOCAQEAGebsrQzcccEshd0dcqPjhJA8+0XYpGaevZjO
// SIG // fQpgJWyL4IN6ZVOziQ8iF6TPdfVjYQEVv7dgMnk9/DbP
// SIG // 2nV9kfU0pCSQLpZRAEcGyvi2te6YyrWvET0oEUOHiJkj
// SIG // HbExyhv+sVmWiyP7W2nfM3NQCaXvsqY3Nkl19cr7j9N1
// SIG // 5FMhGpNLgGj2BBbfKO1gkiH6m2/mt9Habf/nO+vKMbyI
// SIG // 1leZaX1g6f2BNoMZaQsTxqVPgZyWcdnkAPZwpDaPDhOu
// SIG // i837rVdRlFtYaqnYmGjJjV9trXpU/GOg9m4zThgOH6AS
// SIG // 65iOjlab05DLZFh7H2dCppHvePf1Lv6y/RUoF12zLTCC
// SIG // BnAwggRYoAMCAQICCmEMUkwAAAAAAAMwDQYJKoZIhvcN
// SIG // AQELBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xMjAwBgNV
// SIG // BAMTKU1pY3Jvc29mdCBSb290IENlcnRpZmljYXRlIEF1
// SIG // dGhvcml0eSAyMDEwMB4XDTEwMDcwNjIwNDAxN1oXDTI1
// SIG // MDcwNjIwNTAxN1owfjELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEo
// SIG // MCYGA1UEAxMfTWljcm9zb2Z0IENvZGUgU2lnbmluZyBQ
// SIG // Q0EgMjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
// SIG // AQoCggEBAOkOZFB5Z7XE4/0JAEyelKz3VmjqRNjPxVhP
// SIG // qaV2fG1FutM5krSkHvn5ZYLkF9KP/UScCOhlk84sVYS/
// SIG // fQjjLiuoQSsYt6JLbklMaxUH3tHSwokecZTNtX9LtK8I
// SIG // 2MyI1msXlDqTziY/7Ob+NJhX1R1dSfayKi7VhbtZP/iQ
// SIG // tCuDdMorsztG4/BGScEXZlTJHL0dxFViV3L4Z7klIDTe
// SIG // XaallV6rKIDN1bKe5QO1Y9OyFMjByIomCll/B+z/Du2A
// SIG // EjVMEqa+Ulv1ptrgiwtId9aFR9UQucboqu6Lai0FXGDG
// SIG // tCpbnCMcX0XjGhQebzfLGTOAaolNo2pmY3iT1TDPlR8C
// SIG // AwEAAaOCAeMwggHfMBAGCSsGAQQBgjcVAQQDAgEAMB0G
// SIG // A1UdDgQWBBTm/F97uyIAWORyTrX0IXQjMubvrDAZBgkr
// SIG // BgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMC
// SIG // AYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV
// SIG // 9lbLj+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEug
// SIG // SaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAxMC0w
// SIG // Ni0yMy5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUF
// SIG // BzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtp
// SIG // L2NlcnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNy
// SIG // dDCBnQYDVR0gBIGVMIGSMIGPBgkrBgEEAYI3LgMwgYEw
// SIG // PQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWljcm9zb2Z0
// SIG // LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5odG0wQAYI
// SIG // KwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8AUABvAGwA
// SIG // aQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJ
// SIG // KoZIhvcNAQELBQADggIBABp071dPKXvEFoV4uFDTIvwJ
// SIG // nayCl/g0/yosl5US5eS/z7+TyOM0qduBuNweAL7SNW+v
// SIG // 5X95lXflAtTx69jNTh4bYaLCWiMa8IyoYlFFZwjjPzwe
// SIG // k/gwhRfIOUCm1w6zISnlpaFpjCKTzHSY56FHQ/JTrMAP
// SIG // MGl//tIlIG1vYdPfB9XZcgAsaYZ2PVHbpjlIyTdhbQfd
// SIG // UxnLp9Zhwr/ig6sP4GubldZ9KFGwiUpRpJpsyLcfShoO
// SIG // aanX3MF+0Ulwqratu3JHYxf6ptaipobsqBBEm2O2smmJ
// SIG // BsdGhnoYP+jFHSHVe/kCIy3FQcu/HUzIFu+xnH/8IktJ
// SIG // im4V46Z/dlvRU3mRhZ3V0ts9czXzPK5UslJHasCqE5XS
// SIG // jhHamWdeMoz7N4XR3HWFnIfGWleFwr/dDY+Mmy3rtO7P
// SIG // J9O1Xmn6pBYEAackZ3PPTU+23gVWl3r36VJN9HcFT4XG
// SIG // 2Avxju1CCdENduMjVngiJja+yrGMbqod5IXaRzNij6TJ
// SIG // kTNfcR5Ar5hlySLoQiElihwtYNk3iUGJKhYP12E8lGhg
// SIG // Uu/WR5mggEDuFYF3PpzgUxgaUB04lZseZjMTJzkXeIc2
// SIG // zk7DX7L1PUdTtuDl2wthPSrXkizON1o+QEIxpB8QCMJW
// SIG // nL8kXVECnWp50hfT2sGUjgd7JXFEqwZq5tTG3yOalnXF
// SIG // MYIVWzCCFVcCAQEwgZUwfjELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEoMCYGA1UEAxMfTWljcm9zb2Z0IENvZGUgU2lnbmlu
// SIG // ZyBQQ0EgMjAxMAITMwAAAyauzu35vOR7kgAAAAADJjAN
// SIG // BglghkgBZQMEAgEFAKCBrjAZBgkqhkiG9w0BCQMxDAYK
// SIG // KwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYKKwYB
// SIG // BAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgSJUVQ2ZOTptm
// SIG // JggxL4jCtkXFMcEk68dyJ7XbeKOBr6IwQgYKKwYBBAGC
// SIG // NwIBDDE0MDKgFIASAE0AaQBjAHIAbwBzAG8AZgB0oRqA
// SIG // GGh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbTANBgkqhkiG
// SIG // 9w0BAQEFAASCAQASDG8AVjXJ49dvFckxaj8fQ2P2lSJi
// SIG // 0w82Kbxs9qYI4q4y6sYHzTUzEtuYMQhf/GRB338rBZql
// SIG // 1uP+pnHVciefg0/hcXmuH8bkjPYLh5lT87p/FxbCr/7A
// SIG // V976gG6DdXrjGVpKRMxGKHYX711DTxPrb6salsm6w9K5
// SIG // BmHpPTFquS3Tjo8jq+plpUP504nMfqvhnVIwRKuDjdOe
// SIG // btDUDcQIiX/qZFBdNuXNcW6O0jxd/OlfHJPjZvuJbiru
// SIG // sTMuKslhj9sPU8ykib0mU2Fah4UuDPtys2hCruWgZrF5
// SIG // cscS8vIZgwyT1k4457zMXYjFqREkx8PVElPlftuZN9jw
// SIG // CGC5oYIS5TCCEuEGCisGAQQBgjcDAwExghLRMIISzQYJ
// SIG // KoZIhvcNAQcCoIISvjCCEroCAQMxDzANBglghkgBZQME
// SIG // AgEFADCCAVEGCyqGSIb3DQEJEAEEoIIBQASCATwwggE4
// SIG // AgEBBgorBgEEAYRZCgMBMDEwDQYJYIZIAWUDBAIBBQAE
// SIG // IC/9ubu4WJd6QyM4koa/kqQ5NChBFJxsf8J4CUM9gMRU
// SIG // AgZe19zBoNQYEzIwMjAwNjExMTg0NTI0Ljg2NlowBIAC
// SIG // AfSggdCkgc0wgcoxCzAJBgNVBAYTAlVTMQswCQYDVQQI
// SIG // EwJXQTEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMS0wKwYDVQQLEyRN
// SIG // aWNyb3NvZnQgSXJlbGFuZCBPcGVyYXRpb25zIExpbWl0
// SIG // ZWQxJjAkBgNVBAsTHVRoYWxlcyBUU1MgRVNOOjJBRDQt
// SIG // NEI5Mi1GQTAxMSUwIwYDVQQDExxNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBTZXJ2aWNloIIOPDCCBPEwggPZoAMCAQIC
// SIG // EzMAAAEIff9FWXBF+oQAAAAAAQgwDQYJKoZIhvcNAQEL
// SIG // BQAwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMd
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwHhcN
// SIG // MTkxMDIzMjMxOTEzWhcNMjEwMTIxMjMxOTEzWjCByjEL
// SIG // MAkGA1UEBhMCVVMxCzAJBgNVBAgTAldBMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xLTArBgNVBAsTJE1pY3Jvc29mdCBJcmVs
// SIG // YW5kIE9wZXJhdGlvbnMgTGltaXRlZDEmMCQGA1UECxMd
// SIG // VGhhbGVzIFRTUyBFU046MkFENC00QjkyLUZBMDExJTAj
// SIG // BgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZp
// SIG // Y2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQC5E4jLyHDxZk05wGziyso3t6RNRL6/vG1sZeC01Kl5
// SIG // BnaWNXfUAyhr8CuThyyjwQ7YfYiZ+F+zEHh3wM2KHmwP
// SIG // yl4CPCUgZLIXmy02+xusq9mMmh3R5N5yup6NrvDftP4H
// SIG // gRLOXTAy8LbrP1A573a2Jinpfa8UsO2iEmHBTivFrFHY
// SIG // N4UAdbrMI6ls9ZyMHnph6oMw5QJSDfh99u4yGDNYFa5N
// SIG // 89kF4mrcMFF3lvDmb95hn4BLi+mUa/hj7ok7gyscK+GI
// SIG // 5J3n8XNLCNKbszHyvuIrHfVJl+lqW8aRydJfrn1Pi5/l
// SIG // h/5GcBpeoBQAjYrPLxocpTlf1VS1/8TocGgLAgMBAAGj
// SIG // ggEbMIIBFzAdBgNVHQ4EFgQU85RiSQuUCJR0KryRPfMV
// SIG // Q8K+AFQwHwYDVR0jBBgwFoAU1WM6XIoxkPNDe3xGG8Uz
// SIG // aFqFbVUwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2Ny
// SIG // bC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMv
// SIG // TWljVGltU3RhUENBXzIwMTAtMDctMDEuY3JsMFoGCCsG
// SIG // AQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1T
// SIG // dGFQQ0FfMjAxMC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIw
// SIG // ADATBgNVHSUEDDAKBggrBgEFBQcDCDANBgkqhkiG9w0B
// SIG // AQsFAAOCAQEAeHkZLhdho+Jm0M2d2nfjwT/CBDO/PtS1
// SIG // 3eyvm722J4bqN1Kl26z+T65lxhPxBisJmSI39itM61F6
// SIG // U9FdmcxM9joxleIH7SeTpZMZOm+x4kyF2GdywALg93RY
// SIG // PcdYj/91/MFsdk8/YPI8cFUPwN7P0nucgy3SvVD462WM
// SIG // PI76T8+bQMb8XsuiGYObZ0xH1SqsJntKA0SO8gREuXiL
// SIG // m7BZuGFCHn5mcEjy54z4j+o29nk21sKPzqhdQTDIav8W
// SIG // ZtJTXVCkMMDfZVoUSP7ha8xzUTdfSMUAEmsgc4SJ2lN2
// SIG // bjWo1KQ1dLFB+D6PCWo+y3bcpVlfoot07xoeCNAk4Drd
// SIG // lTCCBnEwggRZoAMCAQICCmEJgSoAAAAAAAIwDQYJKoZI
// SIG // hvcNAQELBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYDVQQI
// SIG // EwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w
// SIG // HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xMjAw
// SIG // BgNVBAMTKU1pY3Jvc29mdCBSb290IENlcnRpZmljYXRl
// SIG // IEF1dGhvcml0eSAyMDEwMB4XDTEwMDcwMTIxMzY1NVoX
// SIG // DTI1MDcwMTIxNDY1NVowfDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAg
// SIG // UENBIDIwMTAwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCpHQ28dxGKOiDs/BOX9fp/aZRrdFQQ1aUK
// SIG // AIKF++18aEssX8XD5WHCdrc+Zitb8BVTJwQxH0EbGpUd
// SIG // zgkTjnxhMFmxMEQP8WCIhFRDDNdNuDgIs0Ldk6zWczBX
// SIG // JoKjRQ3Q6vVHgc2/JGAyWGBG8lhHhjKEHnRhZ5FfgVSx
// SIG // z5NMksHEpl3RYRNuKMYa+YaAu99h/EbBJx0kZxJyGiGK
// SIG // r0tkiVBisV39dx898Fd1rL2KQk1AUdEPnAY+Z3/1ZsAD
// SIG // lkR+79BL/W7lmsqxqPJ6Kgox8NpOBpG2iAg16HgcsOmZ
// SIG // zTznL0S6p/TcZL2kAcEgCZN4zfy8wMlEXV4WnAEFTyJN
// SIG // AgMBAAGjggHmMIIB4jAQBgkrBgEEAYI3FQEEAwIBADAd
// SIG // BgNVHQ4EFgQU1WM6XIoxkPNDe3xGG8UzaFqFbVUwGQYJ
// SIG // KwYBBAGCNxQCBAweCgBTAHUAYgBDAEEwCwYDVR0PBAQD
// SIG // AgGGMA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAU
// SIG // 1fZWy4/oolxiaNE9lJBb186aGMQwVgYDVR0fBE8wTTBL
// SIG // oEmgR4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29tL3Br
// SIG // aS9jcmwvcHJvZHVjdHMvTWljUm9vQ2VyQXV0XzIwMTAt
// SIG // MDYtMjMuY3JsMFoGCCsGAQUFBwEBBE4wTDBKBggrBgEF
// SIG // BQcwAoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3Br
// SIG // aS9jZXJ0cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0yMy5j
// SIG // cnQwgaAGA1UdIAEB/wSBlTCBkjCBjwYJKwYBBAGCNy4D
// SIG // MIGBMD0GCCsGAQUFBwIBFjFodHRwOi8vd3d3Lm1pY3Jv
// SIG // c29mdC5jb20vUEtJL2RvY3MvQ1BTL2RlZmF1bHQuaHRt
// SIG // MEAGCCsGAQUFBwICMDQeMiAdAEwAZQBnAGEAbABfAFAA
// SIG // bwBsAGkAYwB5AF8AUwB0AGEAdABlAG0AZQBuAHQALiAd
// SIG // MA0GCSqGSIb3DQEBCwUAA4ICAQAH5ohRDeLG4Jg/gXED
// SIG // PZ2joSFvs+umzPUxvs8F4qn++ldtGTCzwsVmyWrf9efw
// SIG // eL3HqJ4l4/m87WtUVwgrUYJEEvu5U4zM9GASinbMQEBB
// SIG // m9xcF/9c+V4XNZgkVkt070IQyK+/f8Z/8jd9Wj8c8pl5
// SIG // SpFSAK84Dxf1L3mBZdmptWvkx872ynoAb0swRCQiPM/t
// SIG // A6WWj1kpvLb9BOFwnzJKJ/1Vry/+tuWOM7tiX5rbV0Dp
// SIG // 8c6ZZpCM/2pif93FSguRJuI57BlKcWOdeyFtw5yjojz6
// SIG // f32WapB4pm3S4Zz5Hfw42JT0xqUKloakvZ4argRCg7i1
// SIG // gJsiOCC1JeVk7Pf0v35jWSUPei45V3aicaoGig+JFrph
// SIG // pxHLmtgOR5qAxdDNp9DvfYPw4TtxCd9ddJgiCGHasFAe
// SIG // b73x4QDf5zEHpJM692VHeOj4qEir995yfmFrb3epgcun
// SIG // Caw5u+zGy9iCtHLNHfS4hQEegPsbiSpUObJb2sgNVZl6
// SIG // h3M7COaYLeqN4DMuEin1wC9UJyH3yKxO2ii4sanblrKn
// SIG // QqLJzxlBTeCG+SqaoxFmMNO7dDJL32N79ZmKLxvHIa9Z
// SIG // ta7cRDyXUHHXodLFVeNp3lfB0d4wwP3M5k37Db9dT+md
// SIG // Hhk4L7zPWAUu7w2gUDXa7wknHNWzfjUeCLraNtvTX4/e
// SIG // dIhJEqGCAs4wggI3AgEBMIH4oYHQpIHNMIHKMQswCQYD
// SIG // VQQGEwJVUzELMAkGA1UECBMCV0ExEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEtMCsGA1UECxMkTWljcm9zb2Z0IElyZWxhbmQg
// SIG // T3BlcmF0aW9ucyBMaW1pdGVkMSYwJAYDVQQLEx1UaGFs
// SIG // ZXMgVFNTIEVTTjoyQUQ0LTRCOTItRkEwMTElMCMGA1UE
// SIG // AxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZaIj
// SIG // CgEBMAcGBSsOAwIaAxUAiOLRN/zGucSkQ6IL4N/BU+T2
// SIG // 0AyggYMwgYCkfjB8MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYw
// SIG // JAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Eg
// SIG // MjAxMDANBgkqhkiG9w0BAQUFAAIFAOKM5v8wIhgPMjAy
// SIG // MDA2MTIwMTIzMTFaGA8yMDIwMDYxMzAxMjMxMVowdzA9
// SIG // BgorBgEEAYRZCgQBMS8wLTAKAgUA4ozm/wIBADAKAgEA
// SIG // AgIPFQIB/zAHAgEAAgITnzAKAgUA4o44fwIBADA2Bgor
// SIG // BgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZCgMCoAowCAIB
// SIG // AAIDB6EgoQowCAIBAAIDAYagMA0GCSqGSIb3DQEBBQUA
// SIG // A4GBADPVSTaYcvuoSP7RT8EcWCvxfrl8ntfUsa6kePWA
// SIG // wjzaLREHfi4AzlXTNjqCRVKy0H+7fZ9GE6DLB67DC7SC
// SIG // kFqKydt27E3COedb225FxbeNoWwfPrioRo1S+rnjwHXC
// SIG // fC2SM8pFGFD7KgTM13eQUnShkyvkb/lwmzkpRYu7Zc4D
// SIG // MYIDDTCCAwkCAQEwgZMwfDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAg
// SIG // UENBIDIwMTACEzMAAAEIff9FWXBF+oQAAAAAAQgwDQYJ
// SIG // YIZIAWUDBAIBBQCgggFKMBoGCSqGSIb3DQEJAzENBgsq
// SIG // hkiG9w0BCRABBDAvBgkqhkiG9w0BCQQxIgQg1y7vnWGd
// SIG // XHTFB8fpevW/MTe2Vu/jCG25tsfjTBWNjTMwgfoGCyqG
// SIG // SIb3DQEJEAIvMYHqMIHnMIHkMIG9BCDgAzZO4EXd9Uqi
// SIG // FVHP2IiCy0/tDAky9BuuDiapxVmDRzCBmDCBgKR+MHwx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAABCH3/
// SIG // RVlwRfqEAAAAAAEIMCIEIOYios9Te7V0WHGqDEYcovry
// SIG // E4O2tbQaA29MD+H/TRgGMA0GCSqGSIb3DQEBCwUABIIB
// SIG // AIfI4MfpXajx9NmYAVrkkUvWLUSLZ3fgPiSirgWC30qq
// SIG // FycUcQGs28727fLgPSm3arA7g8LwlKLff31xbqWO0YkU
// SIG // OR7NqFT5vhTNhfzHDiZTIzLQaY8wRjokkz08ztAjP7f+
// SIG // kaHR0BPmvcc0HDHAk5yu9glCl4CxwvGdID9a7jvOOQkh
// SIG // 9BP/59e/frP7IYX4GZy9R/hD76a7a+CGXONSqDyh0x5c
// SIG // 2/u1ZlrpEYDBOsvHIwkBUKymqGOAxoLEMz44oNviYEaq
// SIG // NvaQ4MHTh9ywL/LtqPMyXhJd4cKHp2Ohwhvz5a5IT7Xj
// SIG // 9NWomoJqvM8RVbc66NvjsR7Kxkb2QJR6rUU=
// SIG // End signature block
