# Data files for intellisense

We describe how the data files used for intellisense are generated.

## Unicode mathematical symbols

The file `unimathsymbols.json` is generated from the [`unimathsymbols.txt`](http://milde.users.sourceforge.net/LUCR/Math/data/unimathsymbols.txt) by Günter Milde using the [`unimathsymbols.py`](../dev/unimathsymbols.py) script.

## Default commands and environments

Default lists of commands and environments are defined in

- [`commands.json`](commands.json)
- [`environments.json`](environments.json)

## Bibtex

The file [`bibtex-entries.json`](]bibtex-entries.json) lists for every bibtex entry type the mandatory fields. The file [`bibtex-optional-entries.json`](]bibtex-optional-entries.json) lists for every bibtex entry type the optional fields.

## Files inside `packages/`

JSON files in this directory and in the subdirectories are generated from the [cwl files by the TeXStudio project](https://github.com/texstudio-org/texstudio/tree/master/completion) by the [`getcwl.sh`](../dev/getcwl.sh) and [`pkgcommand.py`](../dev/pkgcommand.py) scripts.

Completion files for classes are all prefixed by `class-`.

See [dev/README.md](../dev/README.md#pkgcommand.py) for the description of the file formats.

## Class names

Class names are stored in [`classnames.json`](classnames.json)

This file is generated by the [`ctanpkglist.py`](../dev/ctanpkglist.py) script.

**Note that this file depends on the local LaTeX installation.**

## Class and package names

Package names are stored in [`packagenames.json`](packagenames.json)

This file is based on the list provided by [CTAN](https://ctan.org/json/2.0/packages) and on the [`ctanpkglist.py`](../dev/ctanpkglist.py) script.

See [dev/README.md](../dev/README.md#ctanpkglist.py) for the description of how this file is computed.

## Misc

We have to use four backslashes `\\\\` in some snippet definitions. See  the [official document](https://code.visualstudio.com/docs/editor/userdefinedsnippets#_grammar), [microsoft/vscode/issues/32020](https://github.com/microsoft/vscode/issues/32020), and [microsoft/vscode/issues/33933](https://github.com/microsoft/vscode/issues/33933) for the details.

## Third-Party License Notices

### unimathsymbols.txt

- http://milde.users.sourceforge.net/LUCR/Math/
- http://milde.users.sourceforge.net/LUCR/Math/data/unimathsymbols.txt

Unicode symbols and corresponding LaTeX math mode commands

```
Date
    Last revised 2011-04-04
Copyright
    © 2011 Günter Milde <milde@users.sf.net>
Licence

    This work may be distributed and/or modified under the conditions of
    the LaTeX Project Public License, either version 1.3 of this license
    or (at your option) any later version.

    The latest version of this license is in
    http://www.latex-project.org/lppl.txt
```
