import sys
from pathlib import Path
sys.path.append(str(Path(__file__).parent.parent))

import imageio
import numpy as np
import glob
import os
import torch

from core.tokenizer.cogvideo import CogvideoTokenizer
from core.tokenizer.wan import WanTokenizer

max_frames = 81


model_path = 'pretrained/Wan2.1-I2V-14B-480P-Diffusers/vae'
tokenizer = WanTokenizer(model_path=model_path)

save_dir = 'results/tokenizer_composite_test'
input_rgb_latent = "/mnt/petrelfs/chenzhaoxi/project/PVGen/data/wan21/cache/video_latent/wan-i2v/81x480x720/6346513cb5b6c0c5ab9b0654b0e2fdc2cea1bb560219b97eb6992ac03885636d-00000003-00000475-0280-0352.safetensors"
os.makedirs(save_dir, exist_ok=True)

latent = torch.load(input_latent)
latent = latent.to(tokenizer.device)
latent = latent.to(tokenizer.dtype)

latent = latent[None]
rgb = tokenizer.decode(latent)
imageio.mimwrite(f'{save_dir}/rgb.mp4', (rgb*255).clip(0, 255).astype(np.uint8))
