import sys
from pathlib import Path
sys.path.append(str(Path(__file__).parent.parent))

import imageio
import numpy as np
import glob
import os
import torch
from safetensors.torch import load_file

from core.tokenizer.cogvideo import CogvideoTokenizer
from core.tokenizer.wan import WanTokenizer

max_frames = 81


model_path = 'pretrained/Wan2.1-I2V-14B-480P-Diffusers/vae'
tokenizer = WanTokenizer(model_path=model_path)

save_dir = 'results/tokenizer_composite_test'
input_rgb_latent = "/mnt/petrelfs/chenzhaoxi/project/PVGen/data/wan21/cache/video_latent/wan-i2v/81x480x720/6346513cb5b6c0c5ab9b0654b0e2fdc2cea1bb560219b97eb6992ac03885636d-00000003-00000475-0280-0352.safetensors"
input_pointmap_latent = "/mnt/petrelfs/chenzhaoxi/project/PVGen/data/wan21/pointmap_latents/6346513cb5b6c0c5ab9b0654b0e2fdc2cea1bb560219b97eb6992ac03885636d-00000003-00000475-0280-0352.pt"
os.makedirs(save_dir, exist_ok=True)

latent = load_file(input_rgb_latent)['encoded_video']
latent = latent.to(tokenizer.device)
latent = latent.to(tokenizer.dtype)
latent = latent[None]

pointmap_latent = torch.load(input_pointmap_latent)
pointmap_latent = pointmap_latent.to(tokenizer.device)
pointmap_latent = pointmap_latent.to(tokenizer.dtype)
pointmap_latent = pointmap_latent[None]

rgb = tokenizer.decode(latent)
imageio.mimwrite(f'{save_dir}/rgb.mp4', (rgb*255).clip(0, 255).astype(np.uint8))

pointmap = tokenizer.decode(pointmap_latent)
np.save(f'{save_dir}/pointmap.npy', pointmap)
imageio.mimwrite(f'{save_dir}/pointmap.mp4', (pointmap*255).clip(0, 255).astype(np.uint8))

W = latent.shape[-1] // 2
rgb_composite = tokenizer.decode(torch.cat([latent[..., :W], latent[..., :W]], dim=-1))
imageio.mimwrite(f'{save_dir}/rgb_composite.mp4', (rgb_composite*255).clip(0, 255).astype(np.uint8))

pointmap_composite = tokenizer.decode(torch.cat([pointmap_latent[..., :W], pointmap_latent[..., :W]], dim=-1))
imageio.mimwrite(f'{save_dir}/pointmap_composite.mp4', (pointmap_composite*255).clip(0, 255).astype(np.uint8))

rgb_pointmap_composite = tokenizer.decode(torch.cat([latent[..., :W], pointmap_latent[..., :W]], dim=-1))
imageio.mimwrite(f'{save_dir}/rgb_pointmap_composite.mp4', (rgb_pointmap_composite*255).clip(0, 255).astype(np.uint8))

pointmap_rgb_composite = tokenizer.decode(torch.cat([pointmap_latent[..., :W], latent[..., :W]], dim=-1))
imageio.mimwrite(f'{save_dir}/pointmap_rgb_composite.mp4', (pointmap_rgb_composite*255).clip(0, 255).astype(np.uint8))

temporal_composite = tokenizer.decode(torch.cat([pointmap_latent[..., :13, :, :], latent[..., :13, :, :]], dim=-2))
imageio.mimwrite(f'{save_dir}/temporal_composite.mp4', (temporal_composite*255).clip(0, 255).astype(np.uint8))