import sys
from pathlib import Path
sys.path.append(str(Path(__file__).parent.parent))

import imageio
import numpy as np
import glob
import os

from core.tokenizer.cogvideo import CogvideoTokenizer
from core.tokenizer.cosmos import CosmosTokenizer
from core.tokenizer.wan import WanTokenizer

max_frames = 81




model_path = 'pretrained/Wan2.1-I2V-14B-480P-Diffusers/vae'
tokenizer = WanTokenizer(model_path=model_path)

# model_path = 'pretrained/Cosmos-1.0-Tokenizer-CV8x8x8'
# tokenizer = CosmosTokenizer(model_path=model_path)

save_dir = 'results/tokenizer_test'
input_latent = "test_latent.pt"
os.makedirs(save_dir, exist_ok=True)

latent = torch.load(input_latent)
latent = latent.to(tokenizer.device)
latent = latent.to(tokenizer.dtype)

latent = latent[None].permute(0, 2, 1, 3, 4)
rgb = tokenizer.decode(latent)
rgb = rgb.reshape(81, 480, 720, 3)
rgb = rgb.permute(0, 3, 1, 2)
imageio.mimwrite(f'{save_dir}/rgb.mp4', (rgb*255).clip(0, 255).astype(np.uint8))
