import numpy as np
import imageio.v2 as imageio

def generate_uniform_depth_png(width, height, depth_value, out_path):
    # Clamp depth_value to [0, 1]
    depth_value = np.clip(depth_value, 0, 1)
    # Create a (H, W, 3) array with the same value in all channels
    img = np.full((height, width, 3), fill_value=int(depth_value * 255), dtype=np.uint8)
    imageio.imwrite(out_path, img)
    print(f"Saved uniform depth PNG to {out_path}")

if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument("--width", type=int, default=720)
    parser.add_argument("--height", type=int, default=480)
    parser.add_argument("--depth", type=float, default=1.0, help="Depth value in [0, 1]")
    parser.add_argument("--out", type=str, default="uniform_depth.png")
    args = parser.parse_args()
    generate_uniform_depth_png(args.width, args.height, args.depth, args.out)
