import os
import json
import hashlib
import shutil

I2V_ROOT = os.path.join(os.path.dirname(os.path.dirname(__file__)), 'data', 'I2V')
DEST_ROOT = os.path.join(I2V_ROOT, 'hashed_images')
IMAGES_TXT = os.path.join(I2V_ROOT, 'images.txt')
PROMPTS_TXT = os.path.join(I2V_ROOT, 'prompts.txt')

os.makedirs(DEST_ROOT, exist_ok=True)

image_paths = []
prompts = []

for entry in os.listdir(I2V_ROOT):
    entry_path = os.path.join(I2V_ROOT, entry)
    if not os.path.isdir(entry_path):
        continue
    # Find the first JSON file in the directory
    json_files = [f for f in os.listdir(entry_path) if f.endswith('.json')]
    if not json_files:
        continue
    json_path = os.path.join(entry_path, json_files[0])
    with open(json_path, 'r', encoding='utf-8') as f:
        data = json.load(f)
    if not data or 'text' not in data[0]:
        continue
    prompt = data[0]['text']
    # Generate a unique hash for the prompt
    hash_name = hashlib.sha256(prompt.encode('utf-8')).hexdigest()
    src_img = os.path.join(entry_path, 'i0.png')
    if not os.path.exists(src_img):
        continue
    dest_img = os.path.join(DEST_ROOT, f'{hash_name}.png')
    shutil.copyfile(src_img, dest_img)
    image_paths.append(dest_img)
    prompts.append(prompt)

# Write images.txt and prompts.txt
with open(IMAGES_TXT, 'w', encoding='utf-8') as f_img, open(PROMPTS_TXT, 'w', encoding='utf-8') as f_prompt:
    for img, prompt in zip(image_paths, prompts):
        f_img.write(img + '\n')
        f_prompt.write(prompt + '\n')
