## Easy4DGen

![Alt Text](assets/results.gif)

This code provides following features:
- [x] Loading monst3r annotations
- [x] Visualizing and tokenizing pointmap
- [x] Building dataset for Wan 2.1 finetuning
- [x] Finetuning Wan 2.1 for pointmap generation with multiple ways (sft, lora, lora with learnable embedding but same RoPE)
- [x] Visualization script based on rerun
---
### 0. Install (Environment has been set up on 10.140.0.31/32/33)
```sh
conda create -n "pvgen" python=3.10 -y
conda activate pvgen
pip3 install torch torchvision --index-url https://download.pytorch.org/whl/cu121
pip install requirements.txt

# git lfs and rerun
conda install -c conda-forge git-lfs
conda install -c conda-forge rerun-sdk
```

### 1. Inference

#### Single GPU Inference
Infer all samples use a single GPU given prompts and images, the model will load the checkpoint from LORA_PATH, the results will be saved in the OUTPUT_DIR folder:
```sh
srun -p 3dobject_aigc_scale --quotatype=reserved --gres=gpu:1 -n1 --ntasks-per-node=1 --job-name=test python infer_wan.py --prompt ./data/evaluation/prompts_short.txt --image ./data/evaluation/images_short.txt --out <OUTPUT_DIR> --sft_path ./pretrained/Wan2.1-I2V-14B-480P-Diffusers/transformer  --type i2vwbw-demb-samerope --mode xyzrgb --lora_path <TRAINED_LORA_PATH> --lora_rank 64
```
Typically for example, the prompts and images are saved in `data/evaluation/prompts_short.txt` and `data/evaluation/images_short.txt`, and the trained lora checkpoint is saved as `training/output_pointmap_wan21_xyzrgb_wan-i2v_lora64_demb_samerope_fullframewbw_ipcond_pmnorm_lr1e-4/converted-lite-5000`.

#### Batch Inference to speed up
Infer all samples in parallel use multiple GPUs through slurm jobarray, please modify the script first:
```sh
sbatch ./scripts/slurm/batch_infer_wan21.sh
```

#### Calibrate generated pointmap with PnP
You may need to calibrate the generated pointmap with PnP to align the pointmap better with canonical camera:
```sh
srun -p 3dobject_aigc_scale --quotatype=reserved --gres=gpu:1 -n1 --ntasks-per-node=1 --job-name=testjob python pnp_pm_registration.py --pkl_dir <OUTPUT_DIR>
```
It will load all the *.pkl files in the OUTPUT_DIR and calibrate each pointmap with PnP saved them in the same folder as *_pnp.pkl.

#### Available Pretrained Models
All models are trained upon Wan-2.1-I2V-14B-480P-Diffusers with LoRA. For RGB and XYZ domain, the model concat them along width, and assign learnable domain embedding to each domain but keep using the same RoPE.

| Iterations | Lora Path | Lora Rank |
|----------|----------|----------|
| 4000 | /mnt/petrelfs/chenzhaoxi/project/PVGen/training/output_pointmap_wan21_xyzrgb_wan-i2v_lora_demb_samerope_fullframewbw_ipcond_pmnorm_lr1e-4/converted-lite-4000 | 128 |
| 3000 | /mnt/petrelfs/chenzhaoxi/project/PVGen/training/output_pointmap_wan21_xyzrgb_wan-i2v_lora64_demb_samerope_fullframewbw_ipcond_pmnorm_lr1e-4/converted-lite-3000 | 64 |
| 5000 | /mnt/petrelfs/chenzhaoxi/project/PVGen/training/output_pointmap_wan21_xyzrgb_wan-i2v_lora64_demb_samerope_fullframewbw_ipcond_pmnorm_lr1e-4/converted-lite-5000 | 64 |

### 2. Visualization (Please use rerun for latest visualization)

#### Rerun visualization
Given the folder OUTPUT_DIR containing *.pkl files and the path to store the rerun recording RR_RECORDING_PATH, run:
```
python rerun_vis.py --rr_recording_dir <RR_RECORDING_PATH> --pkl_dir <OUTPUT_DIR>
```

Then, visualize the recording in the browser by running:
```
rerun <RR_RECORDING_PATH> --web-viewer
```

#### MP4 video from pkl files
You can visualize the pointmap and depth as MP4 video by:
```sh
python pkl2vid.py --pkl_dir <OUTPUT_DIR>
```

#### Existing results
Please check `/mnt/petrelfs/chenzhaoxi/project/PVGen/results/allresults_xxx` for existing results.

### 3. Wan2.1 SFT / LoRA Finetuning
XYZ+RGB generation concat along width:
```sh
sbatch ./scripts/slurm/finetune_wan21_xyzrgb.sh
```

### 4. Convert Finetuned Checkpoint before Inference

#### 4.1 Convert raw checkpoint to fp32
Convert the checkpoint from CHECKPOINT_DIR to CONVERTED_CHECKPOINT_DIR:
```sh
srun -p 3dobject_aigc_scale --quotatype=reserved --gres=gpu:1 -n1 --ntasks-per-node=1 --job-name=testjob python scripts/zero_to_fp32.py <CHECKPOINT_DIR> <CONVERTED_CHECKPOINT_DIR> --safe_serialization
```
For example: `srun -p 3dobject_aigc_scale --quotatype=reserved --gres=gpu:1 -n1 --ntasks-per-node=1 --job-name=testjob python scripts/zero_to_fp32.py ./training/output_pointmap_wan21_xyzrgb_wan-i2v_lora_demb_samerope_fullframewbw_ipcond_pmnorm_lr1e-4/checkpoint-7000  ./training/output_pointmap_wan21_xyzrgb_wan-i2v_lora_demb_samerope_fullframewbw_ipcond_pmnorm_lr1e-4/converted-7000 --safe_serialization`

#### 4.2 Get learned embedding and LoRA from converted checkpoint
The output `learnable_domain_embeddings.pt` and `pytorch_lora_weights.safetensors` will be saved under under the `converted-lite-iteration` folder, which will be used for inference.
```sh
python scripts/get_emb_from_ckpt.py <CONVERTED_CHECKPOINT_DIR>
```
For example: `python scripts/get_emb_from_ckpt.py ./training/output_pointmap_wan21_xyzrgb_wan-i2v_lora_demb_samerope_fullframewbw_ipcond_pmnorm_lr1e-4/converted-7000/`. Then you can find all parameters used for inference under `converted-lite-7000` folder.

#### 4.3 You can delete checkpoint-xxx and converted-xxx folders to save space after this conversion.

### 5. Experiment Plans
- Curate visual results by checking the RGB video and 4D pointmap in rerun visualization.
- [In collaboration with Zeng Tao] Design 3 camera trajectories and inference Trajcrafter on top of the generated RGB and pointmap in novel views.
- Run VBench on qualitative results.
- Run user study against image-to-4D baselines.
- [Optional, let me check with Koven] Run WorldScore on quantitative results.
- Ablation study on different finetuning strategies.
- Ablation study on different concatenating and conditioning strategies.
- Main figure for method.
- Teaser
- Project page
- Demo video