## PointmapDiffusion

![Alt Text](assets/results.gif)

This code provides following features:
- [x] Loading monst3r annotations
- [x] Visualizing and tokenizing pointmap
- [x] Building dataset for CogVideo finetuning
- [x] Finetuning CogVideo for pointmap generation
---
### 0. Install
```sh
conda create -n "pointdiff" python=3.10 -y
conda activate pointdiff
pip3 install torch torchvision --index-url https://download.pytorch.org/whl/cu121
pip install requirements.txt

# git lfs
conda install -c conda-forge git-lfs
conda install -c conda-forge rerun-sdk
```

### 1. Visualization
Monst3R annotation (on Ceph)
```
python vis.py [--use_mask] [--max_frames <MAX_FRAMES>]

# if datalist is missing
python scripts/make_datalist.py
```

Monst3R annotation (by original Monst3R code)
```
python vis.py --monst3r_dir <SAVE_DIR>
```

Local pickles
```
python vis.py --pkl_dir <SAVE_DIR>
```

Similar logic using rerun visualizer at [rerun_vis.py](./rerun_vis.py).

### 2. Tokenization
##### Install CogVideoX
```
# install dependencies
pip install requirements_cogvideo.txt
# Download CogVideoX-2b pretrain
cd pretrained
git clone https://hf-mirror.com/THUDM/CogVideoX-2b
git clone https://hf-mirror.com/THUDM/CogVideoX-5b-I2V
# Optionally, download CogVideoX1.5-5B pretrain
git clone https://hf-mirror.com/THUDM/CogVideoX1.5-5B-I2V
```

##### Install COSMOS (optional)
```
# install dependencies
git clone https://github.com/NVIDIA/Cosmos-Tokenizer
cd Cosmos-Tokenizer
pip3 install -e .
# Download COSMOS pretrain
python scripts/download_cosmos.py
```
##### Run Tokenizer test
```
python unit_tests/test_tokenizer.py
```

### 3. Dataset Preparation for CogVideo SFT
Run scripts to build a dataset for CogVideo finetuning. The dataset will be in the CogVideo format. We additionally save pointmap latents and video latents.
```
# get all monst3r annotations
python scripts/make_datalist.py

# run tokenization with slurm jobarray
sbatch scripts/slurm/build_dataset.sh
```
IMPORTANT!!! PJLab clusters does not allow distributed deletion! Need to change the cache removing code before running tokenization.

### 4. CogVideo SFT
For XYZ generation:
```
bash scripts/slurm/finetune_cogvideo.sh
```

XYZ+RGB generation (only left half of the image):
```
bash scripts/slurm/finetune_cogvideo_xyzrgb.sh
```

### 5. Infer Finetuned CogVideo checkpoint
Convert the checkpoint:
```
python scripts/zero_to_fp32.py CHECKPOINT_DIR NEW_CHECKPOINT_DIR --safe_serialization
```

For XYZ generation:
```
bash scripts/slurm/batch_infer_cogvideo.sh
```

XYZ+RGB generation (only left half of the image):
```
bash scripts/slurm/batch_infer_cogvideo_xyzrgb.sh
```

Replace model checkpoint path in the slurm scipt above.


### X. Other Notes
##### Monst3R annotation formats
- `4DGen-Dataset/pexelx_st/pexels/[uid]-[frameid]/clip_[clipid].mp4`
  - `dynamic_mask_0.png`  # dynamic mask
  - `enlarged_dynamic_mask_0.png`    # dynamic mask
  - `frame_0000.npy`  # depth map
  - `frame_0000.png`  # depth visualization
  - `pred_intrinsics.txt` # camera intrinsics
  - `pred_traj.txt` # camera poses

video path: `4DGen-Dataset/Human_Raw_Data/pexels/pexels/[uid]/[uid]-[frameid].mp4`
caption path: `caption/pexels/pexels/[uid]/[uid]-[frameid].txt`


##### S3 commands
To view s3 bucket
```sh
AWS_ACCESS_KEY_ID=WI3BQ2603T8FTMUBXS14 AWS_SECRET_ACCESS_KEY=veSRxTgSkODBVE7aYvm9iRiGLcvYY7oAOYg9DMyK  aws s3 ls s3://4DGen-Dataset/pexelx_st/pexels/0094271c826e2f4ed99ce2a50635aec00f84d8569be4bd5bcaf30d7ab9e95617-00000003-00000475/clip_000344-000471.mp4/ --endpoint-url=http://10.140.27.254:80

AWS_ACCESS_KEY_ID=WI3BQ2603T8FTMUBXS14 AWS_SECRET_ACCESS_KEY=veSRxTgSkODBVE7aYvm9iRiGLcvYY7oAOYg9DMyK  aws s3 cp s3://4DGen-Dataset/Human_Raw_Data/pexels/pexels/0094271c826e2f4ed99ce2a50635aec00f84d8569be4bd5bcaf30d7ab9e95617/0094271c826e2f4ed99ce2a50635aec00f84d8569be4bd5bcaf30d7ab9e95617-00000003-00000475.mp4 vid.mp4 --endpoint-url=http://10.140.27.254:80
```

Install Petrel: http://sdoc.pjlab.org.cn/doc/#/petrel-oss/sdk/SDK%E5%AE%89%E8%A3%85
```sh
python -m pip install pip==21
python -m pip install setuptools==65
cd /mnt/lustre/share
cd petrel-oss-python-sdk && cd ..
cp -r petrel-oss-python-sdk ~/
cd ~/petrel-oss-python-sdk
python setup.py sdist
pip install --user dist/*
cd ~/ && python -c 'from petrel_client.version import version; print(version)'
```

##### pip on cluster
```
pip3 install -i https://pkg.pjlab.org.cn/repository/pypi-proxy/simple/ --trusted-host pkg.pjlab.org.cn
```