#!/bin/bash
#SBATCH --job-name=test_multinode
#SBATCH --nodes=3
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=16
#SBATCH --ntasks=3
#SBATCH --gpus-per-task=1
#SBATCH --partition=3dobject_aigc_mmm
#SBATCH --quotatype=reserved
#SBATCH --output=./logs/%j_%x_out.log
#SBATCH --err=./logs/%j_%x_err.log

# configs
LOG_PATH="log_final.txt"
GPUS_PER_NODE=1

echo "START TIME: $(date)"

# NCCL & AWS
export NCCL_PROTO=simple
export RDMAV_FORK_SAFE=1
export FI_EFA_FORK_SAFE=1
export FI_EFA_USE_DEVICE_RDMA=1
export FI_PROVIDER=efa
export FI_LOG_LEVEL=1
export NCCL_IB_DISABLE=0
export NCCL_SOCKET_IFNAME=ib0

# network
unset http_proxy
unset https_proxy

MASTER_ADDR=$(scontrol show hostnames $SLURM_JOB_NODELIST | head -n 1)
MASTER_PORT=13547 # use 5 digits ports

NNODES=$SLURM_NNODES
NUM_PROCESSES=$(expr $NNODES \* $GPUS_PER_NODE)

# echo all variables
echo "MASTER_ADDR: $MASTER_ADDR"
echo "MASTER_PORT: $MASTER_PORT"
echo "NNODES: $NNODES"
echo "NUM_PROCESSES: $NUM_PROCESSES"
echo "GPUS_PER_NODE: $GPUS_PER_NODE"



echo "END TIME: $(date)"