import sys
from pathlib import Path
sys.path.append(str(Path(__file__).parent.parent))

import imageio
import numpy as np
import glob
import os
from safetensors.torch import load_file
from core.tokenizer.cogvideo import CogvideoTokenizer

max_frames = 81

model_path = 'pretrained/CogVideoX1.5-5B-I2V'
tokenizer = CogvideoTokenizer(model_path=model_path)

# model_path = 'pretrained/Cosmos-1.0-Tokenizer-CV8x8x8'
# tokenizer = CosmosTokenizer(model_path=model_path)

save_dir = 'results/tokenizer_test'
os.makedirs(save_dir, exist_ok=True)

    pointmap_recon = tokenizer.decode(latents, **aux)
    print(pointmap_recon.shape)

    pointmap_recon_vis = (np.clip(pointmap_recon, 0, 1) * 255).astype(np.uint8)
    imageio.mimwrite(f'{save_dir}/pointmap_comp.mp4', np.concatenate([pointmap_vis, pointmap_recon_vis], -2), fps=24)

    pointmap_recon = pointmap_recon.reshape(*pm.pcd.shape)
    pointmap_recon = tokenizer.denormalize_instance(pointmap_recon, center, scale, range_min=0)
    print('reconstructed range: ', pointmap_recon.min(), pointmap_recon.max())
    pm.pcd = pointmap_recon
    pickle.dump(pm, open(f'{save_dir}/pm_recon.pkl', 'wb'))
    break
