import sys
from pathlib import Path
sys.path.append(str(Path(__file__).parent.parent))

import imageio
import numpy as np
import glob
import os
from core.dataset import PointmapDataset
from core.annotation import Monst3RAnno
import pickle

from core.tokenizer.cogvideo import CogvideoTokenizer
from core.tokenizer.cosmos import CosmosTokenizer

# max_frames = 17
max_frames = 49

monst3r_list = glob.glob(f'../monst3r/demo_tmp2/*/')
def PointmapIterator():
    for scene_path in monst3r_list:
        yield Monst3RAnno(scene_path, max_frames=max_frames).pointmap

# dataset = PointmapDataset(datalist = 'data/pexelx_st.txt', s3_conf_path='~/petreloss.conf', debug=True, random_shuffle=False, max_frames=max_frames)
# def PointmapIterator():
#     for data in dataset:
#         yield data.pointmap

pointmap_iterator = PointmapIterator()

model_path = 'pretrained/CogVideoX-2b/vae/'
tokenizer = CogvideoTokenizer(model_path=model_path)

# model_path = 'pretrained/Cosmos-1.0-Tokenizer-CV8x8x8'
# tokenizer = CosmosTokenizer(model_path=model_path)

save_dir = 'results/tokenizer_test'
os.makedirs(save_dir, exist_ok=True)
for pm in pointmap_iterator:
    pickle.dump(pm, open(f'{save_dir}/pm.pkl', 'wb'))
    pointmap = pm.pcd
    print('pointmap range: ', pointmap.min(), pointmap.max())
    pointmap = np.clip(pointmap, np.percentile(pointmap, 2, axis=1, keepdims=True), np.percentile(pointmap, 98,  axis=1, keepdims=True))
    print('clipped range: ', pointmap.min(), pointmap.max())
    pointmap_in, center, scale = tokenizer.normalize_instance(pointmap, range_min=0)
    pointmap_in = pointmap_in.reshape(*pm.rgb.shape)
    pointmap_vis = (pointmap_in * 255).astype(np.uint8)

    latents, aux = tokenizer.encode(pointmap_in)
    pointmap_recon = tokenizer.decode(latents, **aux)
    print(pointmap_recon.shape)

    pointmap_recon_vis = (np.clip(pointmap_recon, 0, 1) * 255).astype(np.uint8)
    imageio.mimwrite(f'{save_dir}/pointmap_comp.mp4', np.concatenate([pointmap_vis, pointmap_recon_vis], -2), fps=24)

    pointmap_recon = pointmap_recon.reshape(*pm.pcd.shape)
    pointmap_recon = tokenizer.denormalize_instance(pointmap_recon, center, scale, range_min=0)
    print('reconstructed range: ', pointmap_recon.min(), pointmap_recon.max())
    pm.pcd = pointmap_recon
    pickle.dump(pm, open(f'{save_dir}/pm_recon.pkl', 'wb'))
    break
