        # # 1. Patch & position embedding
        # self.rope = WanRotaryPosEmbed(attention_head_dim, patch_size, rope_max_seq_len)
        # self.patch_embedding = nn.Conv3d(in_channels, inner_dim, kernel_size=patch_size, stride=patch_size)
        
        # batch_size, num_channels, num_frames, height, width = hidden_states.shape
        # p_t, p_h, p_w = self.config.patch_size
        # post_patch_num_frames = num_frames // p_t
        # post_patch_height = height // p_h
        # post_patch_width = width // p_w

        # rotary_emb = self.rope(hidden_states)

        # hidden_states = self.patch_embedding(hidden_states)
        # hidden_states = hidden_states.flatten(2).transpose(1, 2)

import torch
def test_patchify_token_order():
    batch_size = 1
    channels = 3
    frames = 16
    height = 32
    width = 32
    patch_size = (2, 4, 4)  # typical video patch size
    inner_dim = 768

    # Create two different tensors with distinct patterns
    tensor1 = torch.zeros(batch_size, channels, frames//2, height, width)
    tensor2 = torch.ones(batch_size, channels, frames//2, height, width)
    
    # Test frame dimension concatenation
    frame_concat = torch.cat([tensor1, tensor2], dim=2)
    patch_embed = nn.Conv3d(channels, inner_dim, kernel_size=patch_size, stride=patch_size)
    
    # Patchify
    patched = patch_embed(frame_concat)
    tokens = patched.flatten(2).transpose(1, 2)
    
    # Split sequence back
    seq_len = tokens.shape[1]
    first_half, second_half = tokens.split(seq_len//2, dim=1)
    
    # Verify shapes
    assert first_half.shape == second_half.shape
    assert torch.all(first_half.mean() < 0.1)  # Should contain mostly zeros
    assert torch.all(second_half.mean() > 0.9)  # Should contain mostly ones

    # Test height dimension
    tensor1 = torch.zeros(batch_size, channels, frames, height//2, width)
    tensor2 = torch.ones(batch_size, channels, frames, height//2, width)
    height_concat = torch.cat([tensor1, tensor2], dim=3)
    
    patched = patch_embed(height_concat)
    tokens = patched.flatten(2).transpose(1, 2)
    first_half, second_half = tokens.split(seq_len//2, dim=1)
    
    assert first_half.shape == second_half.shape
    assert torch.all(first_half.mean() < 0.1)
    assert torch.all(second_half.mean() > 0.9)

    # Test width dimension
    tensor1 = torch.zeros(batch_size, channels, frames, height, width//2)
    tensor2 = torch.ones(batch_size, channels, frames, height, width//2)
    width_concat = torch.cat([tensor1, tensor2], dim=4)
    
    patched = patch_embed(width_concat)
    tokens = patched.flatten(2).transpose(1, 2)
    first_half, second_half = tokens.split(seq_len//2, dim=1)
    
    assert first_half.shape == second_half.shape
    assert torch.all(first_half.mean() < 0.1)
    assert torch.all(second_half.mean() > 0.9)

