Object.defineProperty(exports, '__esModule', { value: true });

const instrumentationMysql2 = require('@opentelemetry/instrumentation-mysql2');
const core = require('@sentry/core');
const instrument = require('../../otel/instrument.js');
const addOriginToSpan = require('../../utils/addOriginToSpan.js');

const INTEGRATION_NAME = 'Mysql2';

const instrumentMysql2 = instrument.generateInstrumentOnce(
  INTEGRATION_NAME,
  () =>
    new instrumentationMysql2.MySQL2Instrumentation({
      responseHook(span) {
        addOriginToSpan.addOriginToSpan(span, 'auto.db.otel.mysql2');
      },
    }),
);

const _mysql2Integration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentMysql2();
    },
  };
}) ;

/**
 * MySQL2 integration
 *
 * Capture tracing data for mysql2
 */
const mysql2Integration = core.defineIntegration(_mysql2Integration);

exports.instrumentMysql2 = instrumentMysql2;
exports.mysql2Integration = mysql2Integration;
