# Generated by ariadne-codegen
# Source: tools/graphql_codegen/artifacts/

__all__ = [
    "ADD_ALIASES_GQL",
    "ARTIFACT_COLLECTION_MEMBERSHIP_FILES_GQL",
    "ARTIFACT_VERSION_FILES_GQL",
    "CREATE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL",
    "DELETE_ALIASES_GQL",
    "DELETE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL",
    "DELETE_ARTIFACT_PORTFOLIO_GQL",
    "DELETE_ARTIFACT_SEQUENCE_GQL",
    "FETCH_LINKED_ARTIFACTS_GQL",
    "LINK_ARTIFACT_GQL",
    "MOVE_ARTIFACT_COLLECTION_GQL",
    "PROJECT_ARTIFACTS_GQL",
    "PROJECT_ARTIFACT_COLLECTIONS_GQL",
    "PROJECT_ARTIFACT_COLLECTION_GQL",
    "PROJECT_ARTIFACT_TYPES_GQL",
    "PROJECT_ARTIFACT_TYPE_GQL",
    "RUN_INPUT_ARTIFACTS_GQL",
    "RUN_OUTPUT_ARTIFACTS_GQL",
    "UPDATE_ARTIFACT_GQL",
    "UPDATE_ARTIFACT_PORTFOLIO_GQL",
    "UPDATE_ARTIFACT_SEQUENCE_GQL",
]

DELETE_ARTIFACT_SEQUENCE_GQL = """
mutation DeleteArtifactSequence($id: ID!) {
  deleteArtifactSequence(input: {artifactSequenceID: $id}) {
    artifactCollection {
      __typename
      state
    }
  }
}
"""

DELETE_ARTIFACT_PORTFOLIO_GQL = """
mutation DeleteArtifactPortfolio($id: ID!) {
  deleteArtifactPortfolio(input: {artifactPortfolioID: $id}) {
    artifactCollection {
      __typename
      state
    }
  }
}
"""

UPDATE_ARTIFACT_SEQUENCE_GQL = """
mutation UpdateArtifactSequence($id: ID!, $name: String, $description: String) {
  updateArtifactSequence(
    input: {artifactSequenceID: $id, name: $name, description: $description}
  ) {
    artifactCollection {
      __typename
      id
      name
      description
    }
  }
}
"""

UPDATE_ARTIFACT_PORTFOLIO_GQL = """
mutation UpdateArtifactPortfolio($id: ID!, $name: String, $description: String) {
  updateArtifactPortfolio(
    input: {artifactPortfolioID: $id, name: $name, description: $description}
  ) {
    artifactCollection {
      __typename
      id
      name
      description
    }
  }
}
"""

MOVE_ARTIFACT_COLLECTION_GQL = """
mutation MoveArtifactCollection($artifactSequenceID: ID!, $destinationArtifactTypeName: String!) {
  moveArtifactSequence(
    input: {artifactSequenceID: $artifactSequenceID, destinationArtifactTypeName: $destinationArtifactTypeName}
  ) {
    artifactCollection {
      __typename
      id
      name
      description
    }
  }
}
"""

CREATE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL = """
mutation CreateArtifactCollectionTagAssignments($entityName: String!, $projectName: String!, $artifactCollectionName: String!, $tags: [TagInput!]!) {
  createArtifactCollectionTagAssignments(
    input: {entityName: $entityName, projectName: $projectName, artifactCollectionName: $artifactCollectionName, tags: $tags}
  ) {
    tags {
      id
      name
      tagCategoryName
    }
  }
}
"""

DELETE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL = """
mutation DeleteArtifactCollectionTagAssignments($entityName: String!, $projectName: String!, $artifactCollectionName: String!, $tags: [TagInput!]!) {
  deleteArtifactCollectionTagAssignments(
    input: {entityName: $entityName, projectName: $projectName, artifactCollectionName: $artifactCollectionName, tags: $tags}
  ) {
    success
  }
}
"""

PROJECT_ARTIFACT_COLLECTIONS_GQL = """
query ProjectArtifactCollections($entityName: String!, $projectName: String!, $artifactTypeName: String!, $cursor: String) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifactCollections: artifactCollections(after: $cursor) {
        ...ArtifactCollectionsFragment
      }
    }
  }
}

fragment ArtifactCollectionsFragment on ArtifactCollectionConnection {
  pageInfo {
    endCursor
    hasNextPage
  }
  totalCount
  edges {
    node {
      __typename
      id
      name
      description
      createdAt
    }
    cursor
  }
}
"""

PROJECT_ARTIFACT_COLLECTION_GQL = """
query ProjectArtifactCollection($entityName: String!, $projectName: String!, $artifactTypeName: String!, $artifactCollectionName: String!, $cursor: String, $perPage: Int = 1000) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifactCollection: artifactCollection(name: $artifactCollectionName) {
        __typename
        id
        name
        description
        createdAt
        tags {
          edges {
            node {
              id
              name
            }
          }
        }
        aliases(after: $cursor, first: $perPage) {
          edges {
            node {
              alias
            }
            cursor
          }
          pageInfo {
            endCursor
            hasNextPage
          }
        }
      }
      artifactSequence(name: $artifactCollectionName) {
        __typename
      }
    }
  }
}
"""

ARTIFACT_VERSION_FILES_GQL = """
query ArtifactVersionFiles($entityName: String!, $projectName: String!, $artifactTypeName: String!, $artifactName: String!, $fileNames: [String!], $fileCursor: String, $fileLimit: Int = 50) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifact(name: $artifactName) {
        files(names: $fileNames, after: $fileCursor, first: $fileLimit) {
          ...FilesFragment
        }
      }
    }
  }
}

fragment FilesFragment on FileConnection {
  edges {
    node {
      id
      name: displayName
      url
      sizeBytes
      storagePath @include(if: true)
      mimetype
      updatedAt
      digest
      md5
      directUrl
    }
    cursor
  }
  pageInfo {
    endCursor
    hasNextPage
  }
}
"""

ARTIFACT_COLLECTION_MEMBERSHIP_FILES_GQL = """
query ArtifactCollectionMembershipFiles($entityName: String!, $projectName: String!, $artifactName: String!, $artifactVersionIndex: String!, $fileNames: [String!], $fileCursor: String, $fileLimit: Int = 50) {
  project(name: $projectName, entityName: $entityName) {
    artifactCollection(name: $artifactName) {
      __typename
      artifactMembership(aliasName: $artifactVersionIndex) {
        files(names: $fileNames, after: $fileCursor, first: $fileLimit) {
          ...FilesFragment
        }
      }
    }
  }
}

fragment FilesFragment on FileConnection {
  edges {
    node {
      id
      name: displayName
      url
      sizeBytes
      storagePath @include(if: true)
      mimetype
      updatedAt
      digest
      md5
      directUrl
    }
    cursor
  }
  pageInfo {
    endCursor
    hasNextPage
  }
}
"""

PROJECT_ARTIFACT_TYPES_GQL = """
query ProjectArtifactTypes($entityName: String!, $projectName: String!, $cursor: String) {
  project(name: $projectName, entityName: $entityName) {
    artifactTypes(after: $cursor) {
      ...ArtifactTypesFragment
    }
  }
}

fragment ArtifactTypeFragment on ArtifactType {
  __typename
  id
  name
  description
  createdAt
}

fragment ArtifactTypesFragment on ArtifactTypeConnection {
  edges {
    node {
      ...ArtifactTypeFragment
    }
    cursor
  }
  pageInfo {
    endCursor
    hasNextPage
  }
}
"""

PROJECT_ARTIFACT_TYPE_GQL = """
query ProjectArtifactType($entityName: String!, $projectName: String!, $artifactTypeName: String!) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      ...ArtifactTypeFragment
    }
  }
}

fragment ArtifactTypeFragment on ArtifactType {
  __typename
  id
  name
  description
  createdAt
}
"""

PROJECT_ARTIFACTS_GQL = """
query ProjectArtifacts($project: String!, $entity: String!, $type: String!, $collection: String!, $cursor: String, $perPage: Int = 50, $order: String, $filters: JSONString) {
  project(name: $project, entityName: $entity) {
    artifactType(name: $type) {
      artifactCollection: artifactCollection(name: $collection) {
        __typename
        name
        artifacts(filters: $filters, after: $cursor, first: $perPage, order: $order) {
          ...ArtifactsFragment
        }
      }
    }
  }
}

fragment ArtifactFragment on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment ArtifactsFragment on VersionedArtifactConnection {
  totalCount
  edges {
    node {
      ...ArtifactFragment
    }
    version
    cursor
  }
  pageInfo {
    endCursor
    hasNextPage
  }
}
"""

RUN_OUTPUT_ARTIFACTS_GQL = """
query RunOutputArtifacts($entity: String!, $project: String!, $runName: String!, $cursor: String, $perPage: Int) {
  project(name: $project, entityName: $entity) {
    run(name: $runName) {
      outputArtifacts(after: $cursor, first: $perPage) {
        totalCount
        edges {
          node {
            ...ArtifactFragment
          }
          cursor
        }
        pageInfo {
          endCursor
          hasNextPage
        }
      }
    }
  }
}

fragment ArtifactFragment on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}
"""

RUN_INPUT_ARTIFACTS_GQL = """
query RunInputArtifacts($entity: String!, $project: String!, $runName: String!, $cursor: String, $perPage: Int) {
  project(name: $project, entityName: $entity) {
    run(name: $runName) {
      inputArtifacts(after: $cursor, first: $perPage) {
        totalCount
        edges {
          node {
            ...ArtifactFragment
          }
          cursor
        }
        pageInfo {
          endCursor
          hasNextPage
        }
      }
    }
  }
}

fragment ArtifactFragment on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}
"""

FETCH_LINKED_ARTIFACTS_GQL = """
query FetchLinkedArtifacts($artifactID: ID!) {
  artifact(id: $artifactID) {
    artifactMemberships {
      edges {
        node {
          aliases {
            alias
          }
          versionIndex
          artifactCollection {
            project {
              entityName
              name
            }
            name
            __typename
          }
        }
      }
    }
  }
}
"""

ADD_ALIASES_GQL = """
mutation AddAliases($artifactID: ID!, $aliases: [ArtifactCollectionAliasInput!]!) {
  addAliases(input: {artifactID: $artifactID, aliases: $aliases}) {
    success
  }
}
"""

DELETE_ALIASES_GQL = """
mutation DeleteAliases($artifactID: ID!, $aliases: [ArtifactCollectionAliasInput!]!) {
  deleteAliases(input: {artifactID: $artifactID, aliases: $aliases}) {
    success
  }
}
"""

UPDATE_ARTIFACT_GQL = """
mutation UpdateArtifact($artifactID: ID!, $description: String, $metadata: JSONString, $ttlDurationSeconds: Int64, $tagsToAdd: [TagInput!], $tagsToDelete: [TagInput!], $aliases: [ArtifactAliasInput!]) {
  updateArtifact(
    input: {artifactID: $artifactID, description: $description, metadata: $metadata, ttlDurationSeconds: $ttlDurationSeconds, tagsToAdd: $tagsToAdd, tagsToDelete: $tagsToDelete, aliases: $aliases}
  ) {
    artifact {
      ...ArtifactFragment
    }
  }
}

fragment ArtifactFragment on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}
"""

LINK_ARTIFACT_GQL = """
mutation LinkArtifact($input: LinkArtifactInput!) {
  linkArtifact(input: $input) {
    versionIndex
  }
}
"""
