import { r as noop, i as get_store_value, c as create_ssr_component, s as subscribe, g as getContext, e as escape$4, d as add_styles, b as add_attribute, f as each$1, a as createEventDispatcher, o as onDestroy, v as validate_component, m as missing_component, n as null_to_empty, E as compute_rest_props, k as spread, p as escape_object, l as escape_attribute_value, h as setContext, F as add_classes } from './ssr-ByKBC7Hy.js';
import { w as writable, d as derived, D as DEV, B as BROWSER } from './index-CxqVvn4_.js';
import require$$0 from 'tty';
import require$$2 from 'path';
import require$$1$1 from 'url';
import require$$1 from 'fs';
import { t as tick, b as binding_callbacks, a as bind } from './Component-CveiYa-n.js';

const is_client = typeof window !== 'undefined';

/** @type {() => number} */
let now = is_client ? () => window.performance.now() : () => Date.now();

let raf$2 = is_client ? (cb) => requestAnimationFrame(cb) : noop;

const tasks = new Set();

/**
 * @param {number} now
 * @returns {void}
 */
function run_tasks(now) {
	tasks.forEach((task) => {
		if (!task.c(now)) {
			tasks.delete(task);
			task.f();
		}
	});
	if (tasks.size !== 0) raf$2(run_tasks);
}

/**
 * Creates a new task that runs on each raf frame
 * until it returns a falsy value or is aborted
 * @param {import('./private.js').TaskCallback} callback
 * @returns {import('./private.js').Task}
 */
function loop(callback) {
	/** @type {import('./private.js').TaskEntry} */
	let task;
	if (tasks.size === 0) raf$2(run_tasks);
	return {
		promise: new Promise((fulfill) => {
			tasks.add((task = { c: callback, f: fulfill }));
		}),
		abort() {
			tasks.delete(task);
		}
	};
}

/** @type {typeof globalThis} */
const globals =
	typeof window !== 'undefined'
		? window
		: typeof globalThis !== 'undefined'
		? globalThis
		: // @ts-ignore Node typings have this
		  global;

/** regex of all html void element names */
const void_element_names =
	/^(?:area|base|br|col|command|embed|hr|img|input|keygen|link|meta|param|source|track|wbr)$/;

/**
 * @param {string} name
 * @returns {boolean}
 */
function is_void(name) {
	return void_element_names.test(name) || name.toLowerCase() === '!doctype';
}

/**
 * @param {any} obj
 * @returns {boolean}
 */
function is_date(obj) {
	return Object.prototype.toString.call(obj) === '[object Date]';
}

/**
 * @template T
 * @param {import('./private.js').TickContext<T>} ctx
 * @param {T} last_value
 * @param {T} current_value
 * @param {T} target_value
 * @returns {T}
 */
function tick_spring(ctx, last_value, current_value, target_value) {
	if (typeof current_value === 'number' || is_date(current_value)) {
		// @ts-ignore
		const delta = target_value - current_value;
		// @ts-ignore
		const velocity = (current_value - last_value) / (ctx.dt || 1 / 60); // guard div by 0
		const spring = ctx.opts.stiffness * delta;
		const damper = ctx.opts.damping * velocity;
		const acceleration = (spring - damper) * ctx.inv_mass;
		const d = (velocity + acceleration) * ctx.dt;
		if (Math.abs(d) < ctx.opts.precision && Math.abs(delta) < ctx.opts.precision) {
			return target_value; // settled
		} else {
			ctx.settled = false; // signal loop to keep ticking
			// @ts-ignore
			return is_date(current_value) ? new Date(current_value.getTime() + d) : current_value + d;
		}
	} else if (Array.isArray(current_value)) {
		// @ts-ignore
		return current_value.map((_, i) =>
			tick_spring(ctx, last_value[i], current_value[i], target_value[i])
		);
	} else if (typeof current_value === 'object') {
		const next_value = {};
		for (const k in current_value) {
			// @ts-ignore
			next_value[k] = tick_spring(ctx, last_value[k], current_value[k], target_value[k]);
		}
		// @ts-ignore
		return next_value;
	} else {
		throw new Error(`Cannot spring ${typeof current_value} values`);
	}
}

/**
 * The spring function in Svelte creates a store whose value is animated, with a motion that simulates the behavior of a spring. This means when the value changes, instead of transitioning at a steady rate, it "bounces" like a spring would, depending on the physics parameters provided. This adds a level of realism to the transitions and can enhance the user experience.
 *
 * https://svelte.dev/docs/svelte-motion#spring
 * @template [T=any]
 * @param {T} [value]
 * @param {import('./private.js').SpringOpts} [opts]
 * @returns {import('./public.js').Spring<T>}
 */
function spring(value, opts = {}) {
	const store = writable(value);
	const { stiffness = 0.15, damping = 0.8, precision = 0.01 } = opts;
	/** @type {number} */
	let last_time;
	/** @type {import('../internal/private.js').Task} */
	let task;
	/** @type {object} */
	let current_token;
	/** @type {T} */
	let last_value = value;
	/** @type {T} */
	let target_value = value;
	let inv_mass = 1;
	let inv_mass_recovery_rate = 0;
	let cancel_task = false;
	/**
	 * @param {T} new_value
	 * @param {import('./private.js').SpringUpdateOpts} opts
	 * @returns {Promise<void>}
	 */
	function set(new_value, opts = {}) {
		target_value = new_value;
		const token = (current_token = {});
		if (value == null || opts.hard || (spring.stiffness >= 1 && spring.damping >= 1)) {
			cancel_task = true; // cancel any running animation
			last_time = now();
			last_value = new_value;
			store.set((value = target_value));
			return Promise.resolve();
		} else if (opts.soft) {
			const rate = opts.soft === true ? 0.5 : +opts.soft;
			inv_mass_recovery_rate = 1 / (rate * 60);
			inv_mass = 0; // infinite mass, unaffected by spring forces
		}
		if (!task) {
			last_time = now();
			cancel_task = false;
			task = loop((now) => {
				if (cancel_task) {
					cancel_task = false;
					task = null;
					return false;
				}
				inv_mass = Math.min(inv_mass + inv_mass_recovery_rate, 1);
				const ctx = {
					inv_mass,
					opts: spring,
					settled: true,
					dt: ((now - last_time) * 60) / 1000
				};
				const next_value = tick_spring(ctx, last_value, value, target_value);
				last_time = now;
				last_value = value;
				store.set((value = next_value));
				if (ctx.settled) {
					task = null;
				}
				return !ctx.settled;
			});
		}
		return new Promise((fulfil) => {
			task.promise.then(() => {
				if (token === current_token) fulfil();
			});
		});
	}
	/** @type {import('./public.js').Spring<T>} */
	const spring = {
		set,
		update: (fn, opts) => set(fn(target_value, value), opts),
		subscribe: store.subscribe,
		stiffness,
		damping,
		precision
	};
	return spring;
}

function getDefaultExportFromCjs$1 (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

var picocolors = {exports: {}};

var hasRequiredPicocolors;

function requirePicocolors () {
	if (hasRequiredPicocolors) return picocolors.exports;
	hasRequiredPicocolors = 1;
	let tty = require$$0;

	let isColorSupported =
		!("NO_COLOR" in process.env || process.argv.includes("--no-color")) &&
		("FORCE_COLOR" in process.env ||
			process.argv.includes("--color") ||
			process.platform === "win32" ||
			(tty.isatty(1) && process.env.TERM !== "dumb") ||
			"CI" in process.env);

	let formatter =
		(open, close, replace = open) =>
		input => {
			let string = "" + input;
			let index = string.indexOf(close, open.length);
			return ~index
				? open + replaceClose(string, close, replace, index) + close
				: open + string + close
		};

	let replaceClose = (string, close, replace, index) => {
		let start = string.substring(0, index) + replace;
		let end = string.substring(index + close.length);
		let nextIndex = end.indexOf(close);
		return ~nextIndex ? start + replaceClose(end, close, replace, nextIndex) : start + end
	};

	let createColors = (enabled = isColorSupported) => ({
		isColorSupported: enabled,
		reset: enabled ? s => `\x1b[0m${s}\x1b[0m` : String,
		bold: enabled ? formatter("\x1b[1m", "\x1b[22m", "\x1b[22m\x1b[1m") : String,
		dim: enabled ? formatter("\x1b[2m", "\x1b[22m", "\x1b[22m\x1b[2m") : String,
		italic: enabled ? formatter("\x1b[3m", "\x1b[23m") : String,
		underline: enabled ? formatter("\x1b[4m", "\x1b[24m") : String,
		inverse: enabled ? formatter("\x1b[7m", "\x1b[27m") : String,
		hidden: enabled ? formatter("\x1b[8m", "\x1b[28m") : String,
		strikethrough: enabled ? formatter("\x1b[9m", "\x1b[29m") : String,
		black: enabled ? formatter("\x1b[30m", "\x1b[39m") : String,
		red: enabled ? formatter("\x1b[31m", "\x1b[39m") : String,
		green: enabled ? formatter("\x1b[32m", "\x1b[39m") : String,
		yellow: enabled ? formatter("\x1b[33m", "\x1b[39m") : String,
		blue: enabled ? formatter("\x1b[34m", "\x1b[39m") : String,
		magenta: enabled ? formatter("\x1b[35m", "\x1b[39m") : String,
		cyan: enabled ? formatter("\x1b[36m", "\x1b[39m") : String,
		white: enabled ? formatter("\x1b[37m", "\x1b[39m") : String,
		gray: enabled ? formatter("\x1b[90m", "\x1b[39m") : String,
		bgBlack: enabled ? formatter("\x1b[40m", "\x1b[49m") : String,
		bgRed: enabled ? formatter("\x1b[41m", "\x1b[49m") : String,
		bgGreen: enabled ? formatter("\x1b[42m", "\x1b[49m") : String,
		bgYellow: enabled ? formatter("\x1b[43m", "\x1b[49m") : String,
		bgBlue: enabled ? formatter("\x1b[44m", "\x1b[49m") : String,
		bgMagenta: enabled ? formatter("\x1b[45m", "\x1b[49m") : String,
		bgCyan: enabled ? formatter("\x1b[46m", "\x1b[49m") : String,
		bgWhite: enabled ? formatter("\x1b[47m", "\x1b[49m") : String,
	});

	picocolors.exports = createColors();
	picocolors.exports.createColors = createColors;
	return picocolors.exports;
}

var tokenize;
var hasRequiredTokenize;

function requireTokenize () {
	if (hasRequiredTokenize) return tokenize;
	hasRequiredTokenize = 1;

	const SINGLE_QUOTE = "'".charCodeAt(0);
	const DOUBLE_QUOTE = '"'.charCodeAt(0);
	const BACKSLASH = '\\'.charCodeAt(0);
	const SLASH = '/'.charCodeAt(0);
	const NEWLINE = '\n'.charCodeAt(0);
	const SPACE = ' '.charCodeAt(0);
	const FEED = '\f'.charCodeAt(0);
	const TAB = '\t'.charCodeAt(0);
	const CR = '\r'.charCodeAt(0);
	const OPEN_SQUARE = '['.charCodeAt(0);
	const CLOSE_SQUARE = ']'.charCodeAt(0);
	const OPEN_PARENTHESES = '('.charCodeAt(0);
	const CLOSE_PARENTHESES = ')'.charCodeAt(0);
	const OPEN_CURLY = '{'.charCodeAt(0);
	const CLOSE_CURLY = '}'.charCodeAt(0);
	const SEMICOLON = ';'.charCodeAt(0);
	const ASTERISK = '*'.charCodeAt(0);
	const COLON = ':'.charCodeAt(0);
	const AT = '@'.charCodeAt(0);

	const RE_AT_END = /[\t\n\f\r "#'()/;[\\\]{}]/g;
	const RE_WORD_END = /[\t\n\f\r !"#'():;@[\\\]{}]|\/(?=\*)/g;
	const RE_BAD_BRACKET = /.[\r\n"'(/\\]/;
	const RE_HEX_ESCAPE = /[\da-f]/i;

	tokenize = function tokenizer(input, options = {}) {
	  let css = input.css.valueOf();
	  let ignore = options.ignoreErrors;

	  let code, next, quote, content, escape;
	  let escaped, escapePos, prev, n, currentToken;

	  let length = css.length;
	  let pos = 0;
	  let buffer = [];
	  let returned = [];

	  function position() {
	    return pos
	  }

	  function unclosed(what) {
	    throw input.error('Unclosed ' + what, pos)
	  }

	  function endOfFile() {
	    return returned.length === 0 && pos >= length
	  }

	  function nextToken(opts) {
	    if (returned.length) return returned.pop()
	    if (pos >= length) return

	    let ignoreUnclosed = opts ? opts.ignoreUnclosed : false;

	    code = css.charCodeAt(pos);

	    switch (code) {
	      case NEWLINE:
	      case SPACE:
	      case TAB:
	      case CR:
	      case FEED: {
	        next = pos;
	        do {
	          next += 1;
	          code = css.charCodeAt(next);
	        } while (
	          code === SPACE ||
	          code === NEWLINE ||
	          code === TAB ||
	          code === CR ||
	          code === FEED
	        )

	        currentToken = ['space', css.slice(pos, next)];
	        pos = next - 1;
	        break
	      }

	      case OPEN_SQUARE:
	      case CLOSE_SQUARE:
	      case OPEN_CURLY:
	      case CLOSE_CURLY:
	      case COLON:
	      case SEMICOLON:
	      case CLOSE_PARENTHESES: {
	        let controlChar = String.fromCharCode(code);
	        currentToken = [controlChar, controlChar, pos];
	        break
	      }

	      case OPEN_PARENTHESES: {
	        prev = buffer.length ? buffer.pop()[1] : '';
	        n = css.charCodeAt(pos + 1);
	        if (
	          prev === 'url' &&
	          n !== SINGLE_QUOTE &&
	          n !== DOUBLE_QUOTE &&
	          n !== SPACE &&
	          n !== NEWLINE &&
	          n !== TAB &&
	          n !== FEED &&
	          n !== CR
	        ) {
	          next = pos;
	          do {
	            escaped = false;
	            next = css.indexOf(')', next + 1);
	            if (next === -1) {
	              if (ignore || ignoreUnclosed) {
	                next = pos;
	                break
	              } else {
	                unclosed('bracket');
	              }
	            }
	            escapePos = next;
	            while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
	              escapePos -= 1;
	              escaped = !escaped;
	            }
	          } while (escaped)

	          currentToken = ['brackets', css.slice(pos, next + 1), pos, next];

	          pos = next;
	        } else {
	          next = css.indexOf(')', pos + 1);
	          content = css.slice(pos, next + 1);

	          if (next === -1 || RE_BAD_BRACKET.test(content)) {
	            currentToken = ['(', '(', pos];
	          } else {
	            currentToken = ['brackets', content, pos, next];
	            pos = next;
	          }
	        }

	        break
	      }

	      case SINGLE_QUOTE:
	      case DOUBLE_QUOTE: {
	        quote = code === SINGLE_QUOTE ? "'" : '"';
	        next = pos;
	        do {
	          escaped = false;
	          next = css.indexOf(quote, next + 1);
	          if (next === -1) {
	            if (ignore || ignoreUnclosed) {
	              next = pos + 1;
	              break
	            } else {
	              unclosed('string');
	            }
	          }
	          escapePos = next;
	          while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
	            escapePos -= 1;
	            escaped = !escaped;
	          }
	        } while (escaped)

	        currentToken = ['string', css.slice(pos, next + 1), pos, next];
	        pos = next;
	        break
	      }

	      case AT: {
	        RE_AT_END.lastIndex = pos + 1;
	        RE_AT_END.test(css);
	        if (RE_AT_END.lastIndex === 0) {
	          next = css.length - 1;
	        } else {
	          next = RE_AT_END.lastIndex - 2;
	        }

	        currentToken = ['at-word', css.slice(pos, next + 1), pos, next];

	        pos = next;
	        break
	      }

	      case BACKSLASH: {
	        next = pos;
	        escape = true;
	        while (css.charCodeAt(next + 1) === BACKSLASH) {
	          next += 1;
	          escape = !escape;
	        }
	        code = css.charCodeAt(next + 1);
	        if (
	          escape &&
	          code !== SLASH &&
	          code !== SPACE &&
	          code !== NEWLINE &&
	          code !== TAB &&
	          code !== CR &&
	          code !== FEED
	        ) {
	          next += 1;
	          if (RE_HEX_ESCAPE.test(css.charAt(next))) {
	            while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
	              next += 1;
	            }
	            if (css.charCodeAt(next + 1) === SPACE) {
	              next += 1;
	            }
	          }
	        }

	        currentToken = ['word', css.slice(pos, next + 1), pos, next];

	        pos = next;
	        break
	      }

	      default: {
	        if (code === SLASH && css.charCodeAt(pos + 1) === ASTERISK) {
	          next = css.indexOf('*/', pos + 2) + 1;
	          if (next === 0) {
	            if (ignore || ignoreUnclosed) {
	              next = css.length;
	            } else {
	              unclosed('comment');
	            }
	          }

	          currentToken = ['comment', css.slice(pos, next + 1), pos, next];
	          pos = next;
	        } else {
	          RE_WORD_END.lastIndex = pos + 1;
	          RE_WORD_END.test(css);
	          if (RE_WORD_END.lastIndex === 0) {
	            next = css.length - 1;
	          } else {
	            next = RE_WORD_END.lastIndex - 2;
	          }

	          currentToken = ['word', css.slice(pos, next + 1), pos, next];
	          buffer.push(currentToken);
	          pos = next;
	        }

	        break
	      }
	    }

	    pos++;
	    return currentToken
	  }

	  function back(token) {
	    returned.push(token);
	  }

	  return {
	    back,
	    endOfFile,
	    nextToken,
	    position
	  }
	};
	return tokenize;
}

var terminalHighlight_1;
var hasRequiredTerminalHighlight;

function requireTerminalHighlight () {
	if (hasRequiredTerminalHighlight) return terminalHighlight_1;
	hasRequiredTerminalHighlight = 1;

	let pico = requirePicocolors();

	let tokenizer = requireTokenize();

	let Input;

	function registerInput(dependant) {
	  Input = dependant;
	}

	const HIGHLIGHT_THEME = {
	  ';': pico.yellow,
	  ':': pico.yellow,
	  '(': pico.cyan,
	  ')': pico.cyan,
	  '[': pico.yellow,
	  ']': pico.yellow,
	  '{': pico.yellow,
	  '}': pico.yellow,
	  'at-word': pico.cyan,
	  'brackets': pico.cyan,
	  'call': pico.cyan,
	  'class': pico.yellow,
	  'comment': pico.gray,
	  'hash': pico.magenta,
	  'string': pico.green
	};

	function getTokenType([type, value], processor) {
	  if (type === 'word') {
	    if (value[0] === '.') {
	      return 'class'
	    }
	    if (value[0] === '#') {
	      return 'hash'
	    }
	  }

	  if (!processor.endOfFile()) {
	    let next = processor.nextToken();
	    processor.back(next);
	    if (next[0] === 'brackets' || next[0] === '(') return 'call'
	  }

	  return type
	}

	function terminalHighlight(css) {
	  let processor = tokenizer(new Input(css), { ignoreErrors: true });
	  let result = '';
	  while (!processor.endOfFile()) {
	    let token = processor.nextToken();
	    let color = HIGHLIGHT_THEME[getTokenType(token, processor)];
	    if (color) {
	      result += token[1]
	        .split(/\r?\n/)
	        .map(i => color(i))
	        .join('\n');
	    } else {
	      result += token[1];
	    }
	  }
	  return result
	}

	terminalHighlight.registerInput = registerInput;

	terminalHighlight_1 = terminalHighlight;
	return terminalHighlight_1;
}

var cssSyntaxError;
var hasRequiredCssSyntaxError;

function requireCssSyntaxError () {
	if (hasRequiredCssSyntaxError) return cssSyntaxError;
	hasRequiredCssSyntaxError = 1;

	let pico = requirePicocolors();

	let terminalHighlight = requireTerminalHighlight();

	class CssSyntaxError extends Error {
	  constructor(message, line, column, source, file, plugin) {
	    super(message);
	    this.name = 'CssSyntaxError';
	    this.reason = message;

	    if (file) {
	      this.file = file;
	    }
	    if (source) {
	      this.source = source;
	    }
	    if (plugin) {
	      this.plugin = plugin;
	    }
	    if (typeof line !== 'undefined' && typeof column !== 'undefined') {
	      if (typeof line === 'number') {
	        this.line = line;
	        this.column = column;
	      } else {
	        this.line = line.line;
	        this.column = line.column;
	        this.endLine = column.line;
	        this.endColumn = column.column;
	      }
	    }

	    this.setMessage();

	    if (Error.captureStackTrace) {
	      Error.captureStackTrace(this, CssSyntaxError);
	    }
	  }

	  setMessage() {
	    this.message = this.plugin ? this.plugin + ': ' : '';
	    this.message += this.file ? this.file : '<css input>';
	    if (typeof this.line !== 'undefined') {
	      this.message += ':' + this.line + ':' + this.column;
	    }
	    this.message += ': ' + this.reason;
	  }

	  showSourceCode(color) {
	    if (!this.source) return ''

	    let css = this.source;
	    if (color == null) color = pico.isColorSupported;
	    if (terminalHighlight) {
	      if (color) css = terminalHighlight(css);
	    }

	    let lines = css.split(/\r?\n/);
	    let start = Math.max(this.line - 3, 0);
	    let end = Math.min(this.line + 2, lines.length);

	    let maxWidth = String(end).length;

	    let mark, aside;
	    if (color) {
	      let { bold, gray, red } = pico.createColors(true);
	      mark = text => bold(red(text));
	      aside = text => gray(text);
	    } else {
	      mark = aside = str => str;
	    }

	    return lines
	      .slice(start, end)
	      .map((line, index) => {
	        let number = start + 1 + index;
	        let gutter = ' ' + (' ' + number).slice(-maxWidth) + ' | ';
	        if (number === this.line) {
	          let spacing =
	            aside(gutter.replace(/\d/g, ' ')) +
	            line.slice(0, this.column - 1).replace(/[^\t]/g, ' ');
	          return mark('>') + aside(gutter) + line + '\n ' + spacing + mark('^')
	        }
	        return ' ' + aside(gutter) + line
	      })
	      .join('\n')
	  }

	  toString() {
	    let code = this.showSourceCode();
	    if (code) {
	      code = '\n\n' + code + '\n';
	    }
	    return this.name + ': ' + this.message + code
	  }
	}

	cssSyntaxError = CssSyntaxError;
	CssSyntaxError.default = CssSyntaxError;
	return cssSyntaxError;
}

var symbols$1 = {};

var hasRequiredSymbols;

function requireSymbols () {
	if (hasRequiredSymbols) return symbols$1;
	hasRequiredSymbols = 1;

	symbols$1.isClean = Symbol('isClean');

	symbols$1.my = Symbol('my');
	return symbols$1;
}

var stringifier;
var hasRequiredStringifier;

function requireStringifier () {
	if (hasRequiredStringifier) return stringifier;
	hasRequiredStringifier = 1;

	const DEFAULT_RAW = {
	  after: '\n',
	  beforeClose: '\n',
	  beforeComment: '\n',
	  beforeDecl: '\n',
	  beforeOpen: ' ',
	  beforeRule: '\n',
	  colon: ': ',
	  commentLeft: ' ',
	  commentRight: ' ',
	  emptyBody: '',
	  indent: '    ',
	  semicolon: false
	};

	function capitalize(str) {
	  return str[0].toUpperCase() + str.slice(1)
	}

	class Stringifier {
	  constructor(builder) {
	    this.builder = builder;
	  }

	  atrule(node, semicolon) {
	    let name = '@' + node.name;
	    let params = node.params ? this.rawValue(node, 'params') : '';

	    if (typeof node.raws.afterName !== 'undefined') {
	      name += node.raws.afterName;
	    } else if (params) {
	      name += ' ';
	    }

	    if (node.nodes) {
	      this.block(node, name + params);
	    } else {
	      let end = (node.raws.between || '') + (semicolon ? ';' : '');
	      this.builder(name + params + end, node);
	    }
	  }

	  beforeAfter(node, detect) {
	    let value;
	    if (node.type === 'decl') {
	      value = this.raw(node, null, 'beforeDecl');
	    } else if (node.type === 'comment') {
	      value = this.raw(node, null, 'beforeComment');
	    } else if (detect === 'before') {
	      value = this.raw(node, null, 'beforeRule');
	    } else {
	      value = this.raw(node, null, 'beforeClose');
	    }

	    let buf = node.parent;
	    let depth = 0;
	    while (buf && buf.type !== 'root') {
	      depth += 1;
	      buf = buf.parent;
	    }

	    if (value.includes('\n')) {
	      let indent = this.raw(node, null, 'indent');
	      if (indent.length) {
	        for (let step = 0; step < depth; step++) value += indent;
	      }
	    }

	    return value
	  }

	  block(node, start) {
	    let between = this.raw(node, 'between', 'beforeOpen');
	    this.builder(start + between + '{', node, 'start');

	    let after;
	    if (node.nodes && node.nodes.length) {
	      this.body(node);
	      after = this.raw(node, 'after');
	    } else {
	      after = this.raw(node, 'after', 'emptyBody');
	    }

	    if (after) this.builder(after);
	    this.builder('}', node, 'end');
	  }

	  body(node) {
	    let last = node.nodes.length - 1;
	    while (last > 0) {
	      if (node.nodes[last].type !== 'comment') break
	      last -= 1;
	    }

	    let semicolon = this.raw(node, 'semicolon');
	    for (let i = 0; i < node.nodes.length; i++) {
	      let child = node.nodes[i];
	      let before = this.raw(child, 'before');
	      if (before) this.builder(before);
	      this.stringify(child, last !== i || semicolon);
	    }
	  }

	  comment(node) {
	    let left = this.raw(node, 'left', 'commentLeft');
	    let right = this.raw(node, 'right', 'commentRight');
	    this.builder('/*' + left + node.text + right + '*/', node);
	  }

	  decl(node, semicolon) {
	    let between = this.raw(node, 'between', 'colon');
	    let string = node.prop + between + this.rawValue(node, 'value');

	    if (node.important) {
	      string += node.raws.important || ' !important';
	    }

	    if (semicolon) string += ';';
	    this.builder(string, node);
	  }

	  document(node) {
	    this.body(node);
	  }

	  raw(node, own, detect) {
	    let value;
	    if (!detect) detect = own;

	    // Already had
	    if (own) {
	      value = node.raws[own];
	      if (typeof value !== 'undefined') return value
	    }

	    let parent = node.parent;

	    if (detect === 'before') {
	      // Hack for first rule in CSS
	      if (!parent || (parent.type === 'root' && parent.first === node)) {
	        return ''
	      }

	      // `root` nodes in `document` should use only their own raws
	      if (parent && parent.type === 'document') {
	        return ''
	      }
	    }

	    // Floating child without parent
	    if (!parent) return DEFAULT_RAW[detect]

	    // Detect style by other nodes
	    let root = node.root();
	    if (!root.rawCache) root.rawCache = {};
	    if (typeof root.rawCache[detect] !== 'undefined') {
	      return root.rawCache[detect]
	    }

	    if (detect === 'before' || detect === 'after') {
	      return this.beforeAfter(node, detect)
	    } else {
	      let method = 'raw' + capitalize(detect);
	      if (this[method]) {
	        value = this[method](root, node);
	      } else {
	        root.walk(i => {
	          value = i.raws[own];
	          if (typeof value !== 'undefined') return false
	        });
	      }
	    }

	    if (typeof value === 'undefined') value = DEFAULT_RAW[detect];

	    root.rawCache[detect] = value;
	    return value
	  }

	  rawBeforeClose(root) {
	    let value;
	    root.walk(i => {
	      if (i.nodes && i.nodes.length > 0) {
	        if (typeof i.raws.after !== 'undefined') {
	          value = i.raws.after;
	          if (value.includes('\n')) {
	            value = value.replace(/[^\n]+$/, '');
	          }
	          return false
	        }
	      }
	    });
	    if (value) value = value.replace(/\S/g, '');
	    return value
	  }

	  rawBeforeComment(root, node) {
	    let value;
	    root.walkComments(i => {
	      if (typeof i.raws.before !== 'undefined') {
	        value = i.raws.before;
	        if (value.includes('\n')) {
	          value = value.replace(/[^\n]+$/, '');
	        }
	        return false
	      }
	    });
	    if (typeof value === 'undefined') {
	      value = this.raw(node, null, 'beforeDecl');
	    } else if (value) {
	      value = value.replace(/\S/g, '');
	    }
	    return value
	  }

	  rawBeforeDecl(root, node) {
	    let value;
	    root.walkDecls(i => {
	      if (typeof i.raws.before !== 'undefined') {
	        value = i.raws.before;
	        if (value.includes('\n')) {
	          value = value.replace(/[^\n]+$/, '');
	        }
	        return false
	      }
	    });
	    if (typeof value === 'undefined') {
	      value = this.raw(node, null, 'beforeRule');
	    } else if (value) {
	      value = value.replace(/\S/g, '');
	    }
	    return value
	  }

	  rawBeforeOpen(root) {
	    let value;
	    root.walk(i => {
	      if (i.type !== 'decl') {
	        value = i.raws.between;
	        if (typeof value !== 'undefined') return false
	      }
	    });
	    return value
	  }

	  rawBeforeRule(root) {
	    let value;
	    root.walk(i => {
	      if (i.nodes && (i.parent !== root || root.first !== i)) {
	        if (typeof i.raws.before !== 'undefined') {
	          value = i.raws.before;
	          if (value.includes('\n')) {
	            value = value.replace(/[^\n]+$/, '');
	          }
	          return false
	        }
	      }
	    });
	    if (value) value = value.replace(/\S/g, '');
	    return value
	  }

	  rawColon(root) {
	    let value;
	    root.walkDecls(i => {
	      if (typeof i.raws.between !== 'undefined') {
	        value = i.raws.between.replace(/[^\s:]/g, '');
	        return false
	      }
	    });
	    return value
	  }

	  rawEmptyBody(root) {
	    let value;
	    root.walk(i => {
	      if (i.nodes && i.nodes.length === 0) {
	        value = i.raws.after;
	        if (typeof value !== 'undefined') return false
	      }
	    });
	    return value
	  }

	  rawIndent(root) {
	    if (root.raws.indent) return root.raws.indent
	    let value;
	    root.walk(i => {
	      let p = i.parent;
	      if (p && p !== root && p.parent && p.parent === root) {
	        if (typeof i.raws.before !== 'undefined') {
	          let parts = i.raws.before.split('\n');
	          value = parts[parts.length - 1];
	          value = value.replace(/\S/g, '');
	          return false
	        }
	      }
	    });
	    return value
	  }

	  rawSemicolon(root) {
	    let value;
	    root.walk(i => {
	      if (i.nodes && i.nodes.length && i.last.type === 'decl') {
	        value = i.raws.semicolon;
	        if (typeof value !== 'undefined') return false
	      }
	    });
	    return value
	  }

	  rawValue(node, prop) {
	    let value = node[prop];
	    let raw = node.raws[prop];
	    if (raw && raw.value === value) {
	      return raw.raw
	    }

	    return value
	  }

	  root(node) {
	    this.body(node);
	    if (node.raws.after) this.builder(node.raws.after);
	  }

	  rule(node) {
	    this.block(node, this.rawValue(node, 'selector'));
	    if (node.raws.ownSemicolon) {
	      this.builder(node.raws.ownSemicolon, node, 'end');
	    }
	  }

	  stringify(node, semicolon) {
	    /* c8 ignore start */
	    if (!this[node.type]) {
	      throw new Error(
	        'Unknown AST node type ' +
	          node.type +
	          '. ' +
	          'Maybe you need to change PostCSS stringifier.'
	      )
	    }
	    /* c8 ignore stop */
	    this[node.type](node, semicolon);
	  }
	}

	stringifier = Stringifier;
	Stringifier.default = Stringifier;
	return stringifier;
}

var stringify_1;
var hasRequiredStringify;

function requireStringify () {
	if (hasRequiredStringify) return stringify_1;
	hasRequiredStringify = 1;

	let Stringifier = requireStringifier();

	function stringify(node, builder) {
	  let str = new Stringifier(builder);
	  str.stringify(node);
	}

	stringify_1 = stringify;
	stringify.default = stringify;
	return stringify_1;
}

var node$1;
var hasRequiredNode;

function requireNode () {
	if (hasRequiredNode) return node$1;
	hasRequiredNode = 1;

	let { isClean, my } = requireSymbols();
	let CssSyntaxError = requireCssSyntaxError();
	let Stringifier = requireStringifier();
	let stringify = requireStringify();

	function cloneNode(obj, parent) {
	  let cloned = new obj.constructor();

	  for (let i in obj) {
	    if (!Object.prototype.hasOwnProperty.call(obj, i)) {
	      /* c8 ignore next 2 */
	      continue
	    }
	    if (i === 'proxyCache') continue
	    let value = obj[i];
	    let type = typeof value;

	    if (i === 'parent' && type === 'object') {
	      if (parent) cloned[i] = parent;
	    } else if (i === 'source') {
	      cloned[i] = value;
	    } else if (Array.isArray(value)) {
	      cloned[i] = value.map(j => cloneNode(j, cloned));
	    } else {
	      if (type === 'object' && value !== null) value = cloneNode(value);
	      cloned[i] = value;
	    }
	  }

	  return cloned
	}

	class Node {
	  constructor(defaults = {}) {
	    this.raws = {};
	    this[isClean] = false;
	    this[my] = true;

	    for (let name in defaults) {
	      if (name === 'nodes') {
	        this.nodes = [];
	        for (let node of defaults[name]) {
	          if (typeof node.clone === 'function') {
	            this.append(node.clone());
	          } else {
	            this.append(node);
	          }
	        }
	      } else {
	        this[name] = defaults[name];
	      }
	    }
	  }

	  addToError(error) {
	    error.postcssNode = this;
	    if (error.stack && this.source && /\n\s{4}at /.test(error.stack)) {
	      let s = this.source;
	      error.stack = error.stack.replace(
	        /\n\s{4}at /,
	        `$&${s.input.from}:${s.start.line}:${s.start.column}$&`
	      );
	    }
	    return error
	  }

	  after(add) {
	    this.parent.insertAfter(this, add);
	    return this
	  }

	  assign(overrides = {}) {
	    for (let name in overrides) {
	      this[name] = overrides[name];
	    }
	    return this
	  }

	  before(add) {
	    this.parent.insertBefore(this, add);
	    return this
	  }

	  cleanRaws(keepBetween) {
	    delete this.raws.before;
	    delete this.raws.after;
	    if (!keepBetween) delete this.raws.between;
	  }

	  clone(overrides = {}) {
	    let cloned = cloneNode(this);
	    for (let name in overrides) {
	      cloned[name] = overrides[name];
	    }
	    return cloned
	  }

	  cloneAfter(overrides = {}) {
	    let cloned = this.clone(overrides);
	    this.parent.insertAfter(this, cloned);
	    return cloned
	  }

	  cloneBefore(overrides = {}) {
	    let cloned = this.clone(overrides);
	    this.parent.insertBefore(this, cloned);
	    return cloned
	  }

	  error(message, opts = {}) {
	    if (this.source) {
	      let { end, start } = this.rangeBy(opts);
	      return this.source.input.error(
	        message,
	        { column: start.column, line: start.line },
	        { column: end.column, line: end.line },
	        opts
	      )
	    }
	    return new CssSyntaxError(message)
	  }

	  getProxyProcessor() {
	    return {
	      get(node, prop) {
	        if (prop === 'proxyOf') {
	          return node
	        } else if (prop === 'root') {
	          return () => node.root().toProxy()
	        } else {
	          return node[prop]
	        }
	      },

	      set(node, prop, value) {
	        if (node[prop] === value) return true
	        node[prop] = value;
	        if (
	          prop === 'prop' ||
	          prop === 'value' ||
	          prop === 'name' ||
	          prop === 'params' ||
	          prop === 'important' ||
	          /* c8 ignore next */
	          prop === 'text'
	        ) {
	          node.markDirty();
	        }
	        return true
	      }
	    }
	  }

	  markDirty() {
	    if (this[isClean]) {
	      this[isClean] = false;
	      let next = this;
	      while ((next = next.parent)) {
	        next[isClean] = false;
	      }
	    }
	  }

	  next() {
	    if (!this.parent) return undefined
	    let index = this.parent.index(this);
	    return this.parent.nodes[index + 1]
	  }

	  positionBy(opts, stringRepresentation) {
	    let pos = this.source.start;
	    if (opts.index) {
	      pos = this.positionInside(opts.index, stringRepresentation);
	    } else if (opts.word) {
	      stringRepresentation = this.toString();
	      let index = stringRepresentation.indexOf(opts.word);
	      if (index !== -1) pos = this.positionInside(index, stringRepresentation);
	    }
	    return pos
	  }

	  positionInside(index, stringRepresentation) {
	    let string = stringRepresentation || this.toString();
	    let column = this.source.start.column;
	    let line = this.source.start.line;

	    for (let i = 0; i < index; i++) {
	      if (string[i] === '\n') {
	        column = 1;
	        line += 1;
	      } else {
	        column += 1;
	      }
	    }

	    return { column, line }
	  }

	  prev() {
	    if (!this.parent) return undefined
	    let index = this.parent.index(this);
	    return this.parent.nodes[index - 1]
	  }

	  rangeBy(opts) {
	    let start = {
	      column: this.source.start.column,
	      line: this.source.start.line
	    };
	    let end = this.source.end
	      ? {
	        column: this.source.end.column + 1,
	        line: this.source.end.line
	      }
	      : {
	        column: start.column + 1,
	        line: start.line
	      };

	    if (opts.word) {
	      let stringRepresentation = this.toString();
	      let index = stringRepresentation.indexOf(opts.word);
	      if (index !== -1) {
	        start = this.positionInside(index, stringRepresentation);
	        end = this.positionInside(index + opts.word.length, stringRepresentation);
	      }
	    } else {
	      if (opts.start) {
	        start = {
	          column: opts.start.column,
	          line: opts.start.line
	        };
	      } else if (opts.index) {
	        start = this.positionInside(opts.index);
	      }

	      if (opts.end) {
	        end = {
	          column: opts.end.column,
	          line: opts.end.line
	        };
	      } else if (typeof opts.endIndex === 'number') {
	        end = this.positionInside(opts.endIndex);
	      } else if (opts.index) {
	        end = this.positionInside(opts.index + 1);
	      }
	    }

	    if (
	      end.line < start.line ||
	      (end.line === start.line && end.column <= start.column)
	    ) {
	      end = { column: start.column + 1, line: start.line };
	    }

	    return { end, start }
	  }

	  raw(prop, defaultType) {
	    let str = new Stringifier();
	    return str.raw(this, prop, defaultType)
	  }

	  remove() {
	    if (this.parent) {
	      this.parent.removeChild(this);
	    }
	    this.parent = undefined;
	    return this
	  }

	  replaceWith(...nodes) {
	    if (this.parent) {
	      let bookmark = this;
	      let foundSelf = false;
	      for (let node of nodes) {
	        if (node === this) {
	          foundSelf = true;
	        } else if (foundSelf) {
	          this.parent.insertAfter(bookmark, node);
	          bookmark = node;
	        } else {
	          this.parent.insertBefore(bookmark, node);
	        }
	      }

	      if (!foundSelf) {
	        this.remove();
	      }
	    }

	    return this
	  }

	  root() {
	    let result = this;
	    while (result.parent && result.parent.type !== 'document') {
	      result = result.parent;
	    }
	    return result
	  }

	  toJSON(_, inputs) {
	    let fixed = {};
	    let emitInputs = inputs == null;
	    inputs = inputs || new Map();
	    let inputsNextIndex = 0;

	    for (let name in this) {
	      if (!Object.prototype.hasOwnProperty.call(this, name)) {
	        /* c8 ignore next 2 */
	        continue
	      }
	      if (name === 'parent' || name === 'proxyCache') continue
	      let value = this[name];

	      if (Array.isArray(value)) {
	        fixed[name] = value.map(i => {
	          if (typeof i === 'object' && i.toJSON) {
	            return i.toJSON(null, inputs)
	          } else {
	            return i
	          }
	        });
	      } else if (typeof value === 'object' && value.toJSON) {
	        fixed[name] = value.toJSON(null, inputs);
	      } else if (name === 'source') {
	        let inputId = inputs.get(value.input);
	        if (inputId == null) {
	          inputId = inputsNextIndex;
	          inputs.set(value.input, inputsNextIndex);
	          inputsNextIndex++;
	        }
	        fixed[name] = {
	          end: value.end,
	          inputId,
	          start: value.start
	        };
	      } else {
	        fixed[name] = value;
	      }
	    }

	    if (emitInputs) {
	      fixed.inputs = [...inputs.keys()].map(input => input.toJSON());
	    }

	    return fixed
	  }

	  toProxy() {
	    if (!this.proxyCache) {
	      this.proxyCache = new Proxy(this, this.getProxyProcessor());
	    }
	    return this.proxyCache
	  }

	  toString(stringifier = stringify) {
	    if (stringifier.stringify) stringifier = stringifier.stringify;
	    let result = '';
	    stringifier(this, i => {
	      result += i;
	    });
	    return result
	  }

	  warn(result, text, opts) {
	    let data = { node: this };
	    for (let i in opts) data[i] = opts[i];
	    return result.warn(text, data)
	  }

	  get proxyOf() {
	    return this
	  }
	}

	node$1 = Node;
	Node.default = Node;
	return node$1;
}

var declaration;
var hasRequiredDeclaration;

function requireDeclaration () {
	if (hasRequiredDeclaration) return declaration;
	hasRequiredDeclaration = 1;

	let Node = requireNode();

	class Declaration extends Node {
	  constructor(defaults) {
	    if (
	      defaults &&
	      typeof defaults.value !== 'undefined' &&
	      typeof defaults.value !== 'string'
	    ) {
	      defaults = { ...defaults, value: String(defaults.value) };
	    }
	    super(defaults);
	    this.type = 'decl';
	  }

	  get variable() {
	    return this.prop.startsWith('--') || this.prop[0] === '$'
	  }
	}

	declaration = Declaration;
	Declaration.default = Declaration;
	return declaration;
}

var sourceMap = {};

var sourceMapGenerator = {};

var base64Vlq = {};

var base64 = {};

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredBase64;

function requireBase64 () {
	if (hasRequiredBase64) return base64;
	hasRequiredBase64 = 1;
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var intToCharMap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');

	/**
	 * Encode an integer in the range of 0 to 63 to a single base 64 digit.
	 */
	base64.encode = function (number) {
	  if (0 <= number && number < intToCharMap.length) {
	    return intToCharMap[number];
	  }
	  throw new TypeError("Must be between 0 and 63: " + number);
	};

	/**
	 * Decode a single base 64 character code digit to an integer. Returns -1 on
	 * failure.
	 */
	base64.decode = function (charCode) {
	  var bigA = 65;     // 'A'
	  var bigZ = 90;     // 'Z'

	  var littleA = 97;  // 'a'
	  var littleZ = 122; // 'z'

	  var zero = 48;     // '0'
	  var nine = 57;     // '9'

	  var plus = 43;     // '+'
	  var slash = 47;    // '/'

	  var littleOffset = 26;
	  var numberOffset = 52;

	  // 0 - 25: ABCDEFGHIJKLMNOPQRSTUVWXYZ
	  if (bigA <= charCode && charCode <= bigZ) {
	    return (charCode - bigA);
	  }

	  // 26 - 51: abcdefghijklmnopqrstuvwxyz
	  if (littleA <= charCode && charCode <= littleZ) {
	    return (charCode - littleA + littleOffset);
	  }

	  // 52 - 61: 0123456789
	  if (zero <= charCode && charCode <= nine) {
	    return (charCode - zero + numberOffset);
	  }

	  // 62: +
	  if (charCode == plus) {
	    return 62;
	  }

	  // 63: /
	  if (charCode == slash) {
	    return 63;
	  }

	  // Invalid base64 digit.
	  return -1;
	};
	return base64;
}

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredBase64Vlq;

function requireBase64Vlq () {
	if (hasRequiredBase64Vlq) return base64Vlq;
	hasRequiredBase64Vlq = 1;
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 *
	 * Based on the Base 64 VLQ implementation in Closure Compiler:
	 * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
	 *
	 * Copyright 2011 The Closure Compiler Authors. All rights reserved.
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions are
	 * met:
	 *
	 *  * Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 *  * Redistributions in binary form must reproduce the above
	 *    copyright notice, this list of conditions and the following
	 *    disclaimer in the documentation and/or other materials provided
	 *    with the distribution.
	 *  * Neither the name of Google Inc. nor the names of its
	 *    contributors may be used to endorse or promote products derived
	 *    from this software without specific prior written permission.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
	 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
	 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
	 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
	 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
	 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	 */

	var base64 = requireBase64();

	// A single base 64 digit can contain 6 bits of data. For the base 64 variable
	// length quantities we use in the source map spec, the first bit is the sign,
	// the next four bits are the actual value, and the 6th bit is the
	// continuation bit. The continuation bit tells us whether there are more
	// digits in this value following this digit.
	//
	//   Continuation
	//   |    Sign
	//   |    |
	//   V    V
	//   101011

	var VLQ_BASE_SHIFT = 5;

	// binary: 100000
	var VLQ_BASE = 1 << VLQ_BASE_SHIFT;

	// binary: 011111
	var VLQ_BASE_MASK = VLQ_BASE - 1;

	// binary: 100000
	var VLQ_CONTINUATION_BIT = VLQ_BASE;

	/**
	 * Converts from a two-complement value to a value where the sign bit is
	 * placed in the least significant bit.  For example, as decimals:
	 *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
	 *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
	 */
	function toVLQSigned(aValue) {
	  return aValue < 0
	    ? ((-aValue) << 1) + 1
	    : (aValue << 1) + 0;
	}

	/**
	 * Converts to a two-complement value from a value where the sign bit is
	 * placed in the least significant bit.  For example, as decimals:
	 *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
	 *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
	 */
	function fromVLQSigned(aValue) {
	  var isNegative = (aValue & 1) === 1;
	  var shifted = aValue >> 1;
	  return isNegative
	    ? -shifted
	    : shifted;
	}

	/**
	 * Returns the base 64 VLQ encoded value.
	 */
	base64Vlq.encode = function base64VLQ_encode(aValue) {
	  var encoded = "";
	  var digit;

	  var vlq = toVLQSigned(aValue);

	  do {
	    digit = vlq & VLQ_BASE_MASK;
	    vlq >>>= VLQ_BASE_SHIFT;
	    if (vlq > 0) {
	      // There are still more digits in this value, so we must make sure the
	      // continuation bit is marked.
	      digit |= VLQ_CONTINUATION_BIT;
	    }
	    encoded += base64.encode(digit);
	  } while (vlq > 0);

	  return encoded;
	};

	/**
	 * Decodes the next base 64 VLQ value from the given string and returns the
	 * value and the rest of the string via the out parameter.
	 */
	base64Vlq.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
	  var strLen = aStr.length;
	  var result = 0;
	  var shift = 0;
	  var continuation, digit;

	  do {
	    if (aIndex >= strLen) {
	      throw new Error("Expected more digits in base 64 VLQ value.");
	    }

	    digit = base64.decode(aStr.charCodeAt(aIndex++));
	    if (digit === -1) {
	      throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
	    }

	    continuation = !!(digit & VLQ_CONTINUATION_BIT);
	    digit &= VLQ_BASE_MASK;
	    result = result + (digit << shift);
	    shift += VLQ_BASE_SHIFT;
	  } while (continuation);

	  aOutParam.value = fromVLQSigned(result);
	  aOutParam.rest = aIndex;
	};
	return base64Vlq;
}

var util = {};

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredUtil;

function requireUtil () {
	if (hasRequiredUtil) return util;
	hasRequiredUtil = 1;
	(function (exports) {
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		/**
		 * This is a helper function for getting values from parameter/options
		 * objects.
		 *
		 * @param args The object we are extracting values from
		 * @param name The name of the property we are getting.
		 * @param defaultValue An optional value to return if the property is missing
		 * from the object. If this is not specified and the property is missing, an
		 * error will be thrown.
		 */
		function getArg(aArgs, aName, aDefaultValue) {
		  if (aName in aArgs) {
		    return aArgs[aName];
		  } else if (arguments.length === 3) {
		    return aDefaultValue;
		  } else {
		    throw new Error('"' + aName + '" is a required argument.');
		  }
		}
		exports.getArg = getArg;

		var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
		var dataUrlRegexp = /^data:.+\,.+$/;

		function urlParse(aUrl) {
		  var match = aUrl.match(urlRegexp);
		  if (!match) {
		    return null;
		  }
		  return {
		    scheme: match[1],
		    auth: match[2],
		    host: match[3],
		    port: match[4],
		    path: match[5]
		  };
		}
		exports.urlParse = urlParse;

		function urlGenerate(aParsedUrl) {
		  var url = '';
		  if (aParsedUrl.scheme) {
		    url += aParsedUrl.scheme + ':';
		  }
		  url += '//';
		  if (aParsedUrl.auth) {
		    url += aParsedUrl.auth + '@';
		  }
		  if (aParsedUrl.host) {
		    url += aParsedUrl.host;
		  }
		  if (aParsedUrl.port) {
		    url += ":" + aParsedUrl.port;
		  }
		  if (aParsedUrl.path) {
		    url += aParsedUrl.path;
		  }
		  return url;
		}
		exports.urlGenerate = urlGenerate;

		var MAX_CACHED_INPUTS = 32;

		/**
		 * Takes some function `f(input) -> result` and returns a memoized version of
		 * `f`.
		 *
		 * We keep at most `MAX_CACHED_INPUTS` memoized results of `f` alive. The
		 * memoization is a dumb-simple, linear least-recently-used cache.
		 */
		function lruMemoize(f) {
		  var cache = [];

		  return function(input) {
		    for (var i = 0; i < cache.length; i++) {
		      if (cache[i].input === input) {
		        var temp = cache[0];
		        cache[0] = cache[i];
		        cache[i] = temp;
		        return cache[0].result;
		      }
		    }

		    var result = f(input);

		    cache.unshift({
		      input,
		      result,
		    });

		    if (cache.length > MAX_CACHED_INPUTS) {
		      cache.pop();
		    }

		    return result;
		  };
		}

		/**
		 * Normalizes a path, or the path portion of a URL:
		 *
		 * - Replaces consecutive slashes with one slash.
		 * - Removes unnecessary '.' parts.
		 * - Removes unnecessary '<dir>/..' parts.
		 *
		 * Based on code in the Node.js 'path' core module.
		 *
		 * @param aPath The path or url to normalize.
		 */
		var normalize = lruMemoize(function normalize(aPath) {
		  var path = aPath;
		  var url = urlParse(aPath);
		  if (url) {
		    if (!url.path) {
		      return aPath;
		    }
		    path = url.path;
		  }
		  var isAbsolute = exports.isAbsolute(path);
		  // Split the path into parts between `/` characters. This is much faster than
		  // using `.split(/\/+/g)`.
		  var parts = [];
		  var start = 0;
		  var i = 0;
		  while (true) {
		    start = i;
		    i = path.indexOf("/", start);
		    if (i === -1) {
		      parts.push(path.slice(start));
		      break;
		    } else {
		      parts.push(path.slice(start, i));
		      while (i < path.length && path[i] === "/") {
		        i++;
		      }
		    }
		  }

		  for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
		    part = parts[i];
		    if (part === '.') {
		      parts.splice(i, 1);
		    } else if (part === '..') {
		      up++;
		    } else if (up > 0) {
		      if (part === '') {
		        // The first part is blank if the path is absolute. Trying to go
		        // above the root is a no-op. Therefore we can remove all '..' parts
		        // directly after the root.
		        parts.splice(i + 1, up);
		        up = 0;
		      } else {
		        parts.splice(i, 2);
		        up--;
		      }
		    }
		  }
		  path = parts.join('/');

		  if (path === '') {
		    path = isAbsolute ? '/' : '.';
		  }

		  if (url) {
		    url.path = path;
		    return urlGenerate(url);
		  }
		  return path;
		});
		exports.normalize = normalize;

		/**
		 * Joins two paths/URLs.
		 *
		 * @param aRoot The root path or URL.
		 * @param aPath The path or URL to be joined with the root.
		 *
		 * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
		 *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
		 *   first.
		 * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
		 *   is updated with the result and aRoot is returned. Otherwise the result
		 *   is returned.
		 *   - If aPath is absolute, the result is aPath.
		 *   - Otherwise the two paths are joined with a slash.
		 * - Joining for example 'http://' and 'www.example.com' is also supported.
		 */
		function join(aRoot, aPath) {
		  if (aRoot === "") {
		    aRoot = ".";
		  }
		  if (aPath === "") {
		    aPath = ".";
		  }
		  var aPathUrl = urlParse(aPath);
		  var aRootUrl = urlParse(aRoot);
		  if (aRootUrl) {
		    aRoot = aRootUrl.path || '/';
		  }

		  // `join(foo, '//www.example.org')`
		  if (aPathUrl && !aPathUrl.scheme) {
		    if (aRootUrl) {
		      aPathUrl.scheme = aRootUrl.scheme;
		    }
		    return urlGenerate(aPathUrl);
		  }

		  if (aPathUrl || aPath.match(dataUrlRegexp)) {
		    return aPath;
		  }

		  // `join('http://', 'www.example.com')`
		  if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
		    aRootUrl.host = aPath;
		    return urlGenerate(aRootUrl);
		  }

		  var joined = aPath.charAt(0) === '/'
		    ? aPath
		    : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

		  if (aRootUrl) {
		    aRootUrl.path = joined;
		    return urlGenerate(aRootUrl);
		  }
		  return joined;
		}
		exports.join = join;

		exports.isAbsolute = function (aPath) {
		  return aPath.charAt(0) === '/' || urlRegexp.test(aPath);
		};

		/**
		 * Make a path relative to a URL or another path.
		 *
		 * @param aRoot The root path or URL.
		 * @param aPath The path or URL to be made relative to aRoot.
		 */
		function relative(aRoot, aPath) {
		  if (aRoot === "") {
		    aRoot = ".";
		  }

		  aRoot = aRoot.replace(/\/$/, '');

		  // It is possible for the path to be above the root. In this case, simply
		  // checking whether the root is a prefix of the path won't work. Instead, we
		  // need to remove components from the root one by one, until either we find
		  // a prefix that fits, or we run out of components to remove.
		  var level = 0;
		  while (aPath.indexOf(aRoot + '/') !== 0) {
		    var index = aRoot.lastIndexOf("/");
		    if (index < 0) {
		      return aPath;
		    }

		    // If the only part of the root that is left is the scheme (i.e. http://,
		    // file:///, etc.), one or more slashes (/), or simply nothing at all, we
		    // have exhausted all components, so the path is not relative to the root.
		    aRoot = aRoot.slice(0, index);
		    if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
		      return aPath;
		    }

		    ++level;
		  }

		  // Make sure we add a "../" for each component we removed from the root.
		  return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
		}
		exports.relative = relative;

		var supportsNullProto = (function () {
		  var obj = Object.create(null);
		  return !('__proto__' in obj);
		}());

		function identity (s) {
		  return s;
		}

		/**
		 * Because behavior goes wacky when you set `__proto__` on objects, we
		 * have to prefix all the strings in our set with an arbitrary character.
		 *
		 * See https://github.com/mozilla/source-map/pull/31 and
		 * https://github.com/mozilla/source-map/issues/30
		 *
		 * @param String aStr
		 */
		function toSetString(aStr) {
		  if (isProtoString(aStr)) {
		    return '$' + aStr;
		  }

		  return aStr;
		}
		exports.toSetString = supportsNullProto ? identity : toSetString;

		function fromSetString(aStr) {
		  if (isProtoString(aStr)) {
		    return aStr.slice(1);
		  }

		  return aStr;
		}
		exports.fromSetString = supportsNullProto ? identity : fromSetString;

		function isProtoString(s) {
		  if (!s) {
		    return false;
		  }

		  var length = s.length;

		  if (length < 9 /* "__proto__".length */) {
		    return false;
		  }

		  if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
		      s.charCodeAt(length - 2) !== 95  /* '_' */ ||
		      s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
		      s.charCodeAt(length - 4) !== 116 /* 't' */ ||
		      s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
		      s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
		      s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
		      s.charCodeAt(length - 8) !== 95  /* '_' */ ||
		      s.charCodeAt(length - 9) !== 95  /* '_' */) {
		    return false;
		  }

		  for (var i = length - 10; i >= 0; i--) {
		    if (s.charCodeAt(i) !== 36 /* '$' */) {
		      return false;
		    }
		  }

		  return true;
		}

		/**
		 * Comparator between two mappings where the original positions are compared.
		 *
		 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
		 * mappings with the same original source/line/column, but different generated
		 * line and column the same. Useful when searching for a mapping with a
		 * stubbed out mapping.
		 */
		function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
		  var cmp = strcmp(mappingA.source, mappingB.source);
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalLine - mappingB.originalLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalColumn - mappingB.originalColumn;
		  if (cmp !== 0 || onlyCompareOriginal) {
		    return cmp;
		  }

		  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.generatedLine - mappingB.generatedLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  return strcmp(mappingA.name, mappingB.name);
		}
		exports.compareByOriginalPositions = compareByOriginalPositions;

		function compareByOriginalPositionsNoSource(mappingA, mappingB, onlyCompareOriginal) {
		  var cmp;

		  cmp = mappingA.originalLine - mappingB.originalLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalColumn - mappingB.originalColumn;
		  if (cmp !== 0 || onlyCompareOriginal) {
		    return cmp;
		  }

		  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.generatedLine - mappingB.generatedLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  return strcmp(mappingA.name, mappingB.name);
		}
		exports.compareByOriginalPositionsNoSource = compareByOriginalPositionsNoSource;

		/**
		 * Comparator between two mappings with deflated source and name indices where
		 * the generated positions are compared.
		 *
		 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
		 * mappings with the same generated line and column, but different
		 * source/name/original line and column the same. Useful when searching for a
		 * mapping with a stubbed out mapping.
		 */
		function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
		  var cmp = mappingA.generatedLine - mappingB.generatedLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		  if (cmp !== 0 || onlyCompareGenerated) {
		    return cmp;
		  }

		  cmp = strcmp(mappingA.source, mappingB.source);
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalLine - mappingB.originalLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalColumn - mappingB.originalColumn;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  return strcmp(mappingA.name, mappingB.name);
		}
		exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

		function compareByGeneratedPositionsDeflatedNoLine(mappingA, mappingB, onlyCompareGenerated) {
		  var cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		  if (cmp !== 0 || onlyCompareGenerated) {
		    return cmp;
		  }

		  cmp = strcmp(mappingA.source, mappingB.source);
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalLine - mappingB.originalLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalColumn - mappingB.originalColumn;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  return strcmp(mappingA.name, mappingB.name);
		}
		exports.compareByGeneratedPositionsDeflatedNoLine = compareByGeneratedPositionsDeflatedNoLine;

		function strcmp(aStr1, aStr2) {
		  if (aStr1 === aStr2) {
		    return 0;
		  }

		  if (aStr1 === null) {
		    return 1; // aStr2 !== null
		  }

		  if (aStr2 === null) {
		    return -1; // aStr1 !== null
		  }

		  if (aStr1 > aStr2) {
		    return 1;
		  }

		  return -1;
		}

		/**
		 * Comparator between two mappings with inflated source and name strings where
		 * the generated positions are compared.
		 */
		function compareByGeneratedPositionsInflated(mappingA, mappingB) {
		  var cmp = mappingA.generatedLine - mappingB.generatedLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = strcmp(mappingA.source, mappingB.source);
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalLine - mappingB.originalLine;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  cmp = mappingA.originalColumn - mappingB.originalColumn;
		  if (cmp !== 0) {
		    return cmp;
		  }

		  return strcmp(mappingA.name, mappingB.name);
		}
		exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;

		/**
		 * Strip any JSON XSSI avoidance prefix from the string (as documented
		 * in the source maps specification), and then parse the string as
		 * JSON.
		 */
		function parseSourceMapInput(str) {
		  return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ''));
		}
		exports.parseSourceMapInput = parseSourceMapInput;

		/**
		 * Compute the URL of a source given the the source root, the source's
		 * URL, and the source map's URL.
		 */
		function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
		  sourceURL = sourceURL || '';

		  if (sourceRoot) {
		    // This follows what Chrome does.
		    if (sourceRoot[sourceRoot.length - 1] !== '/' && sourceURL[0] !== '/') {
		      sourceRoot += '/';
		    }
		    // The spec says:
		    //   Line 4: An optional source root, useful for relocating source
		    //   files on a server or removing repeated values in the
		    //   “sources” entry.  This value is prepended to the individual
		    //   entries in the “source” field.
		    sourceURL = sourceRoot + sourceURL;
		  }

		  // Historically, SourceMapConsumer did not take the sourceMapURL as
		  // a parameter.  This mode is still somewhat supported, which is why
		  // this code block is conditional.  However, it's preferable to pass
		  // the source map URL to SourceMapConsumer, so that this function
		  // can implement the source URL resolution algorithm as outlined in
		  // the spec.  This block is basically the equivalent of:
		  //    new URL(sourceURL, sourceMapURL).toString()
		  // ... except it avoids using URL, which wasn't available in the
		  // older releases of node still supported by this library.
		  //
		  // The spec says:
		  //   If the sources are not absolute URLs after prepending of the
		  //   “sourceRoot”, the sources are resolved relative to the
		  //   SourceMap (like resolving script src in a html document).
		  if (sourceMapURL) {
		    var parsed = urlParse(sourceMapURL);
		    if (!parsed) {
		      throw new Error("sourceMapURL could not be parsed");
		    }
		    if (parsed.path) {
		      // Strip the last path component, but keep the "/".
		      var index = parsed.path.lastIndexOf('/');
		      if (index >= 0) {
		        parsed.path = parsed.path.substring(0, index + 1);
		      }
		    }
		    sourceURL = join(urlGenerate(parsed), sourceURL);
		  }

		  return normalize(sourceURL);
		}
		exports.computeSourceURL = computeSourceURL; 
	} (util));
	return util;
}

var arraySet = {};

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredArraySet;

function requireArraySet () {
	if (hasRequiredArraySet) return arraySet;
	hasRequiredArraySet = 1;
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var util = requireUtil();
	var has = Object.prototype.hasOwnProperty;
	var hasNativeMap = typeof Map !== "undefined";

	/**
	 * A data structure which is a combination of an array and a set. Adding a new
	 * member is O(1), testing for membership is O(1), and finding the index of an
	 * element is O(1). Removing elements from the set is not supported. Only
	 * strings are supported for membership.
	 */
	function ArraySet() {
	  this._array = [];
	  this._set = hasNativeMap ? new Map() : Object.create(null);
	}

	/**
	 * Static method for creating ArraySet instances from an existing array.
	 */
	ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
	  var set = new ArraySet();
	  for (var i = 0, len = aArray.length; i < len; i++) {
	    set.add(aArray[i], aAllowDuplicates);
	  }
	  return set;
	};

	/**
	 * Return how many unique items are in this ArraySet. If duplicates have been
	 * added, than those do not count towards the size.
	 *
	 * @returns Number
	 */
	ArraySet.prototype.size = function ArraySet_size() {
	  return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
	};

	/**
	 * Add the given string to this set.
	 *
	 * @param String aStr
	 */
	ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
	  var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
	  var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
	  var idx = this._array.length;
	  if (!isDuplicate || aAllowDuplicates) {
	    this._array.push(aStr);
	  }
	  if (!isDuplicate) {
	    if (hasNativeMap) {
	      this._set.set(aStr, idx);
	    } else {
	      this._set[sStr] = idx;
	    }
	  }
	};

	/**
	 * Is the given string a member of this set?
	 *
	 * @param String aStr
	 */
	ArraySet.prototype.has = function ArraySet_has(aStr) {
	  if (hasNativeMap) {
	    return this._set.has(aStr);
	  } else {
	    var sStr = util.toSetString(aStr);
	    return has.call(this._set, sStr);
	  }
	};

	/**
	 * What is the index of the given string in the array?
	 *
	 * @param String aStr
	 */
	ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
	  if (hasNativeMap) {
	    var idx = this._set.get(aStr);
	    if (idx >= 0) {
	        return idx;
	    }
	  } else {
	    var sStr = util.toSetString(aStr);
	    if (has.call(this._set, sStr)) {
	      return this._set[sStr];
	    }
	  }

	  throw new Error('"' + aStr + '" is not in the set.');
	};

	/**
	 * What is the element at the given index?
	 *
	 * @param Number aIdx
	 */
	ArraySet.prototype.at = function ArraySet_at(aIdx) {
	  if (aIdx >= 0 && aIdx < this._array.length) {
	    return this._array[aIdx];
	  }
	  throw new Error('No element indexed by ' + aIdx);
	};

	/**
	 * Returns the array representation of this set (which has the proper indices
	 * indicated by indexOf). Note that this is a copy of the internal array used
	 * for storing the members so that no one can mess with internal state.
	 */
	ArraySet.prototype.toArray = function ArraySet_toArray() {
	  return this._array.slice();
	};

	arraySet.ArraySet = ArraySet;
	return arraySet;
}

var mappingList = {};

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredMappingList;

function requireMappingList () {
	if (hasRequiredMappingList) return mappingList;
	hasRequiredMappingList = 1;
	/*
	 * Copyright 2014 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var util = requireUtil();

	/**
	 * Determine whether mappingB is after mappingA with respect to generated
	 * position.
	 */
	function generatedPositionAfter(mappingA, mappingB) {
	  // Optimized for most common case
	  var lineA = mappingA.generatedLine;
	  var lineB = mappingB.generatedLine;
	  var columnA = mappingA.generatedColumn;
	  var columnB = mappingB.generatedColumn;
	  return lineB > lineA || lineB == lineA && columnB >= columnA ||
	         util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
	}

	/**
	 * A data structure to provide a sorted view of accumulated mappings in a
	 * performance conscious manner. It trades a neglibable overhead in general
	 * case for a large speedup in case of mappings being added in order.
	 */
	function MappingList() {
	  this._array = [];
	  this._sorted = true;
	  // Serves as infimum
	  this._last = {generatedLine: -1, generatedColumn: 0};
	}

	/**
	 * Iterate through internal items. This method takes the same arguments that
	 * `Array.prototype.forEach` takes.
	 *
	 * NOTE: The order of the mappings is NOT guaranteed.
	 */
	MappingList.prototype.unsortedForEach =
	  function MappingList_forEach(aCallback, aThisArg) {
	    this._array.forEach(aCallback, aThisArg);
	  };

	/**
	 * Add the given source mapping.
	 *
	 * @param Object aMapping
	 */
	MappingList.prototype.add = function MappingList_add(aMapping) {
	  if (generatedPositionAfter(this._last, aMapping)) {
	    this._last = aMapping;
	    this._array.push(aMapping);
	  } else {
	    this._sorted = false;
	    this._array.push(aMapping);
	  }
	};

	/**
	 * Returns the flat, sorted array of mappings. The mappings are sorted by
	 * generated position.
	 *
	 * WARNING: This method returns internal data without copying, for
	 * performance. The return value must NOT be mutated, and should be treated as
	 * an immutable borrow. If you want to take ownership, you must make your own
	 * copy.
	 */
	MappingList.prototype.toArray = function MappingList_toArray() {
	  if (!this._sorted) {
	    this._array.sort(util.compareByGeneratedPositionsInflated);
	    this._sorted = true;
	  }
	  return this._array;
	};

	mappingList.MappingList = MappingList;
	return mappingList;
}

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredSourceMapGenerator;

function requireSourceMapGenerator () {
	if (hasRequiredSourceMapGenerator) return sourceMapGenerator;
	hasRequiredSourceMapGenerator = 1;
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var base64VLQ = requireBase64Vlq();
	var util = requireUtil();
	var ArraySet = requireArraySet().ArraySet;
	var MappingList = requireMappingList().MappingList;

	/**
	 * An instance of the SourceMapGenerator represents a source map which is
	 * being built incrementally. You may pass an object with the following
	 * properties:
	 *
	 *   - file: The filename of the generated source.
	 *   - sourceRoot: A root for all relative URLs in this source map.
	 */
	function SourceMapGenerator(aArgs) {
	  if (!aArgs) {
	    aArgs = {};
	  }
	  this._file = util.getArg(aArgs, 'file', null);
	  this._sourceRoot = util.getArg(aArgs, 'sourceRoot', null);
	  this._skipValidation = util.getArg(aArgs, 'skipValidation', false);
	  this._ignoreInvalidMapping = util.getArg(aArgs, 'ignoreInvalidMapping', false);
	  this._sources = new ArraySet();
	  this._names = new ArraySet();
	  this._mappings = new MappingList();
	  this._sourcesContents = null;
	}

	SourceMapGenerator.prototype._version = 3;

	/**
	 * Creates a new SourceMapGenerator based on a SourceMapConsumer
	 *
	 * @param aSourceMapConsumer The SourceMap.
	 */
	SourceMapGenerator.fromSourceMap =
	  function SourceMapGenerator_fromSourceMap(aSourceMapConsumer, generatorOps) {
	    var sourceRoot = aSourceMapConsumer.sourceRoot;
	    var generator = new SourceMapGenerator(Object.assign(generatorOps || {}, {
	      file: aSourceMapConsumer.file,
	      sourceRoot: sourceRoot
	    }));
	    aSourceMapConsumer.eachMapping(function (mapping) {
	      var newMapping = {
	        generated: {
	          line: mapping.generatedLine,
	          column: mapping.generatedColumn
	        }
	      };

	      if (mapping.source != null) {
	        newMapping.source = mapping.source;
	        if (sourceRoot != null) {
	          newMapping.source = util.relative(sourceRoot, newMapping.source);
	        }

	        newMapping.original = {
	          line: mapping.originalLine,
	          column: mapping.originalColumn
	        };

	        if (mapping.name != null) {
	          newMapping.name = mapping.name;
	        }
	      }

	      generator.addMapping(newMapping);
	    });
	    aSourceMapConsumer.sources.forEach(function (sourceFile) {
	      var sourceRelative = sourceFile;
	      if (sourceRoot !== null) {
	        sourceRelative = util.relative(sourceRoot, sourceFile);
	      }

	      if (!generator._sources.has(sourceRelative)) {
	        generator._sources.add(sourceRelative);
	      }

	      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	      if (content != null) {
	        generator.setSourceContent(sourceFile, content);
	      }
	    });
	    return generator;
	  };

	/**
	 * Add a single mapping from original source line and column to the generated
	 * source's line and column for this source map being created. The mapping
	 * object should have the following properties:
	 *
	 *   - generated: An object with the generated line and column positions.
	 *   - original: An object with the original line and column positions.
	 *   - source: The original source file (relative to the sourceRoot).
	 *   - name: An optional original token name for this mapping.
	 */
	SourceMapGenerator.prototype.addMapping =
	  function SourceMapGenerator_addMapping(aArgs) {
	    var generated = util.getArg(aArgs, 'generated');
	    var original = util.getArg(aArgs, 'original', null);
	    var source = util.getArg(aArgs, 'source', null);
	    var name = util.getArg(aArgs, 'name', null);

	    if (!this._skipValidation) {
	      if (this._validateMapping(generated, original, source, name) === false) {
	        return;
	      }
	    }

	    if (source != null) {
	      source = String(source);
	      if (!this._sources.has(source)) {
	        this._sources.add(source);
	      }
	    }

	    if (name != null) {
	      name = String(name);
	      if (!this._names.has(name)) {
	        this._names.add(name);
	      }
	    }

	    this._mappings.add({
	      generatedLine: generated.line,
	      generatedColumn: generated.column,
	      originalLine: original != null && original.line,
	      originalColumn: original != null && original.column,
	      source: source,
	      name: name
	    });
	  };

	/**
	 * Set the source content for a source file.
	 */
	SourceMapGenerator.prototype.setSourceContent =
	  function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
	    var source = aSourceFile;
	    if (this._sourceRoot != null) {
	      source = util.relative(this._sourceRoot, source);
	    }

	    if (aSourceContent != null) {
	      // Add the source content to the _sourcesContents map.
	      // Create a new _sourcesContents map if the property is null.
	      if (!this._sourcesContents) {
	        this._sourcesContents = Object.create(null);
	      }
	      this._sourcesContents[util.toSetString(source)] = aSourceContent;
	    } else if (this._sourcesContents) {
	      // Remove the source file from the _sourcesContents map.
	      // If the _sourcesContents map is empty, set the property to null.
	      delete this._sourcesContents[util.toSetString(source)];
	      if (Object.keys(this._sourcesContents).length === 0) {
	        this._sourcesContents = null;
	      }
	    }
	  };

	/**
	 * Applies the mappings of a sub-source-map for a specific source file to the
	 * source map being generated. Each mapping to the supplied source file is
	 * rewritten using the supplied source map. Note: The resolution for the
	 * resulting mappings is the minimium of this map and the supplied map.
	 *
	 * @param aSourceMapConsumer The source map to be applied.
	 * @param aSourceFile Optional. The filename of the source file.
	 *        If omitted, SourceMapConsumer's file property will be used.
	 * @param aSourceMapPath Optional. The dirname of the path to the source map
	 *        to be applied. If relative, it is relative to the SourceMapConsumer.
	 *        This parameter is needed when the two source maps aren't in the same
	 *        directory, and the source map to be applied contains relative source
	 *        paths. If so, those relative source paths need to be rewritten
	 *        relative to the SourceMapGenerator.
	 */
	SourceMapGenerator.prototype.applySourceMap =
	  function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
	    var sourceFile = aSourceFile;
	    // If aSourceFile is omitted, we will use the file property of the SourceMap
	    if (aSourceFile == null) {
	      if (aSourceMapConsumer.file == null) {
	        throw new Error(
	          'SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' +
	          'or the source map\'s "file" property. Both were omitted.'
	        );
	      }
	      sourceFile = aSourceMapConsumer.file;
	    }
	    var sourceRoot = this._sourceRoot;
	    // Make "sourceFile" relative if an absolute Url is passed.
	    if (sourceRoot != null) {
	      sourceFile = util.relative(sourceRoot, sourceFile);
	    }
	    // Applying the SourceMap can add and remove items from the sources and
	    // the names array.
	    var newSources = new ArraySet();
	    var newNames = new ArraySet();

	    // Find mappings for the "sourceFile"
	    this._mappings.unsortedForEach(function (mapping) {
	      if (mapping.source === sourceFile && mapping.originalLine != null) {
	        // Check if it can be mapped by the source map, then update the mapping.
	        var original = aSourceMapConsumer.originalPositionFor({
	          line: mapping.originalLine,
	          column: mapping.originalColumn
	        });
	        if (original.source != null) {
	          // Copy mapping
	          mapping.source = original.source;
	          if (aSourceMapPath != null) {
	            mapping.source = util.join(aSourceMapPath, mapping.source);
	          }
	          if (sourceRoot != null) {
	            mapping.source = util.relative(sourceRoot, mapping.source);
	          }
	          mapping.originalLine = original.line;
	          mapping.originalColumn = original.column;
	          if (original.name != null) {
	            mapping.name = original.name;
	          }
	        }
	      }

	      var source = mapping.source;
	      if (source != null && !newSources.has(source)) {
	        newSources.add(source);
	      }

	      var name = mapping.name;
	      if (name != null && !newNames.has(name)) {
	        newNames.add(name);
	      }

	    }, this);
	    this._sources = newSources;
	    this._names = newNames;

	    // Copy sourcesContents of applied map.
	    aSourceMapConsumer.sources.forEach(function (sourceFile) {
	      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	      if (content != null) {
	        if (aSourceMapPath != null) {
	          sourceFile = util.join(aSourceMapPath, sourceFile);
	        }
	        if (sourceRoot != null) {
	          sourceFile = util.relative(sourceRoot, sourceFile);
	        }
	        this.setSourceContent(sourceFile, content);
	      }
	    }, this);
	  };

	/**
	 * A mapping can have one of the three levels of data:
	 *
	 *   1. Just the generated position.
	 *   2. The Generated position, original position, and original source.
	 *   3. Generated and original position, original source, as well as a name
	 *      token.
	 *
	 * To maintain consistency, we validate that any new mapping being added falls
	 * in to one of these categories.
	 */
	SourceMapGenerator.prototype._validateMapping =
	  function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource,
	                                              aName) {
	    // When aOriginal is truthy but has empty values for .line and .column,
	    // it is most likely a programmer error. In this case we throw a very
	    // specific error message to try to guide them the right way.
	    // For example: https://github.com/Polymer/polymer-bundler/pull/519
	    if (aOriginal && typeof aOriginal.line !== 'number' && typeof aOriginal.column !== 'number') {
	      var message = 'original.line and original.column are not numbers -- you probably meant to omit ' +
	      'the original mapping entirely and only map the generated position. If so, pass ' +
	      'null for the original mapping instead of an object with empty or null values.';

	      if (this._ignoreInvalidMapping) {
	        if (typeof console !== 'undefined' && console.warn) {
	          console.warn(message);
	        }
	        return false;
	      } else {
	        throw new Error(message);
	      }
	    }

	    if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
	        && aGenerated.line > 0 && aGenerated.column >= 0
	        && !aOriginal && !aSource && !aName) {
	      // Case 1.
	      return;
	    }
	    else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
	             && aOriginal && 'line' in aOriginal && 'column' in aOriginal
	             && aGenerated.line > 0 && aGenerated.column >= 0
	             && aOriginal.line > 0 && aOriginal.column >= 0
	             && aSource) {
	      // Cases 2 and 3.
	      return;
	    }
	    else {
	      var message = 'Invalid mapping: ' + JSON.stringify({
	        generated: aGenerated,
	        source: aSource,
	        original: aOriginal,
	        name: aName
	      });

	      if (this._ignoreInvalidMapping) {
	        if (typeof console !== 'undefined' && console.warn) {
	          console.warn(message);
	        }
	        return false;
	      } else {
	        throw new Error(message)
	      }
	    }
	  };

	/**
	 * Serialize the accumulated mappings in to the stream of base 64 VLQs
	 * specified by the source map format.
	 */
	SourceMapGenerator.prototype._serializeMappings =
	  function SourceMapGenerator_serializeMappings() {
	    var previousGeneratedColumn = 0;
	    var previousGeneratedLine = 1;
	    var previousOriginalColumn = 0;
	    var previousOriginalLine = 0;
	    var previousName = 0;
	    var previousSource = 0;
	    var result = '';
	    var next;
	    var mapping;
	    var nameIdx;
	    var sourceIdx;

	    var mappings = this._mappings.toArray();
	    for (var i = 0, len = mappings.length; i < len; i++) {
	      mapping = mappings[i];
	      next = '';

	      if (mapping.generatedLine !== previousGeneratedLine) {
	        previousGeneratedColumn = 0;
	        while (mapping.generatedLine !== previousGeneratedLine) {
	          next += ';';
	          previousGeneratedLine++;
	        }
	      }
	      else {
	        if (i > 0) {
	          if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
	            continue;
	          }
	          next += ',';
	        }
	      }

	      next += base64VLQ.encode(mapping.generatedColumn
	                                 - previousGeneratedColumn);
	      previousGeneratedColumn = mapping.generatedColumn;

	      if (mapping.source != null) {
	        sourceIdx = this._sources.indexOf(mapping.source);
	        next += base64VLQ.encode(sourceIdx - previousSource);
	        previousSource = sourceIdx;

	        // lines are stored 0-based in SourceMap spec version 3
	        next += base64VLQ.encode(mapping.originalLine - 1
	                                   - previousOriginalLine);
	        previousOriginalLine = mapping.originalLine - 1;

	        next += base64VLQ.encode(mapping.originalColumn
	                                   - previousOriginalColumn);
	        previousOriginalColumn = mapping.originalColumn;

	        if (mapping.name != null) {
	          nameIdx = this._names.indexOf(mapping.name);
	          next += base64VLQ.encode(nameIdx - previousName);
	          previousName = nameIdx;
	        }
	      }

	      result += next;
	    }

	    return result;
	  };

	SourceMapGenerator.prototype._generateSourcesContent =
	  function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
	    return aSources.map(function (source) {
	      if (!this._sourcesContents) {
	        return null;
	      }
	      if (aSourceRoot != null) {
	        source = util.relative(aSourceRoot, source);
	      }
	      var key = util.toSetString(source);
	      return Object.prototype.hasOwnProperty.call(this._sourcesContents, key)
	        ? this._sourcesContents[key]
	        : null;
	    }, this);
	  };

	/**
	 * Externalize the source map.
	 */
	SourceMapGenerator.prototype.toJSON =
	  function SourceMapGenerator_toJSON() {
	    var map = {
	      version: this._version,
	      sources: this._sources.toArray(),
	      names: this._names.toArray(),
	      mappings: this._serializeMappings()
	    };
	    if (this._file != null) {
	      map.file = this._file;
	    }
	    if (this._sourceRoot != null) {
	      map.sourceRoot = this._sourceRoot;
	    }
	    if (this._sourcesContents) {
	      map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
	    }

	    return map;
	  };

	/**
	 * Render the source map being generated to a string.
	 */
	SourceMapGenerator.prototype.toString =
	  function SourceMapGenerator_toString() {
	    return JSON.stringify(this.toJSON());
	  };

	sourceMapGenerator.SourceMapGenerator = SourceMapGenerator;
	return sourceMapGenerator;
}

var sourceMapConsumer = {};

var binarySearch = {};

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredBinarySearch;

function requireBinarySearch () {
	if (hasRequiredBinarySearch) return binarySearch;
	hasRequiredBinarySearch = 1;
	(function (exports) {
		/*
		 * Copyright 2011 Mozilla Foundation and contributors
		 * Licensed under the New BSD license. See LICENSE or:
		 * http://opensource.org/licenses/BSD-3-Clause
		 */

		exports.GREATEST_LOWER_BOUND = 1;
		exports.LEAST_UPPER_BOUND = 2;

		/**
		 * Recursive implementation of binary search.
		 *
		 * @param aLow Indices here and lower do not contain the needle.
		 * @param aHigh Indices here and higher do not contain the needle.
		 * @param aNeedle The element being searched for.
		 * @param aHaystack The non-empty array being searched.
		 * @param aCompare Function which takes two elements and returns -1, 0, or 1.
		 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
		 *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
		 *     closest element that is smaller than or greater than the one we are
		 *     searching for, respectively, if the exact element cannot be found.
		 */
		function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
		  // This function terminates when one of the following is true:
		  //
		  //   1. We find the exact element we are looking for.
		  //
		  //   2. We did not find the exact element, but we can return the index of
		  //      the next-closest element.
		  //
		  //   3. We did not find the exact element, and there is no next-closest
		  //      element than the one we are searching for, so we return -1.
		  var mid = Math.floor((aHigh - aLow) / 2) + aLow;
		  var cmp = aCompare(aNeedle, aHaystack[mid], true);
		  if (cmp === 0) {
		    // Found the element we are looking for.
		    return mid;
		  }
		  else if (cmp > 0) {
		    // Our needle is greater than aHaystack[mid].
		    if (aHigh - mid > 1) {
		      // The element is in the upper half.
		      return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
		    }

		    // The exact needle element was not found in this haystack. Determine if
		    // we are in termination case (3) or (2) and return the appropriate thing.
		    if (aBias == exports.LEAST_UPPER_BOUND) {
		      return aHigh < aHaystack.length ? aHigh : -1;
		    } else {
		      return mid;
		    }
		  }
		  else {
		    // Our needle is less than aHaystack[mid].
		    if (mid - aLow > 1) {
		      // The element is in the lower half.
		      return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
		    }

		    // we are in termination case (3) or (2) and return the appropriate thing.
		    if (aBias == exports.LEAST_UPPER_BOUND) {
		      return mid;
		    } else {
		      return aLow < 0 ? -1 : aLow;
		    }
		  }
		}

		/**
		 * This is an implementation of binary search which will always try and return
		 * the index of the closest element if there is no exact hit. This is because
		 * mappings between original and generated line/col pairs are single points,
		 * and there is an implicit region between each of them, so a miss just means
		 * that you aren't on the very start of a region.
		 *
		 * @param aNeedle The element you are looking for.
		 * @param aHaystack The array that is being searched.
		 * @param aCompare A function which takes the needle and an element in the
		 *     array and returns -1, 0, or 1 depending on whether the needle is less
		 *     than, equal to, or greater than the element, respectively.
		 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
		 *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
		 *     closest element that is smaller than or greater than the one we are
		 *     searching for, respectively, if the exact element cannot be found.
		 *     Defaults to 'binarySearch.GREATEST_LOWER_BOUND'.
		 */
		exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
		  if (aHaystack.length === 0) {
		    return -1;
		  }

		  var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack,
		                              aCompare, aBias || exports.GREATEST_LOWER_BOUND);
		  if (index < 0) {
		    return -1;
		  }

		  // We have found either the exact element, or the next-closest element than
		  // the one we are searching for. However, there may be more than one such
		  // element. Make sure we always return the smallest of these.
		  while (index - 1 >= 0) {
		    if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
		      break;
		    }
		    --index;
		  }

		  return index;
		}; 
	} (binarySearch));
	return binarySearch;
}

var quickSort = {};

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredQuickSort;

function requireQuickSort () {
	if (hasRequiredQuickSort) return quickSort;
	hasRequiredQuickSort = 1;
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	// It turns out that some (most?) JavaScript engines don't self-host
	// `Array.prototype.sort`. This makes sense because C++ will likely remain
	// faster than JS when doing raw CPU-intensive sorting. However, when using a
	// custom comparator function, calling back and forth between the VM's C++ and
	// JIT'd JS is rather slow *and* loses JIT type information, resulting in
	// worse generated code for the comparator function than would be optimal. In
	// fact, when sorting with a comparator, these costs outweigh the benefits of
	// sorting in C++. By using our own JS-implemented Quick Sort (below), we get
	// a ~3500ms mean speed-up in `bench/bench.html`.

	function SortTemplate(comparator) {

	/**
	 * Swap the elements indexed by `x` and `y` in the array `ary`.
	 *
	 * @param {Array} ary
	 *        The array.
	 * @param {Number} x
	 *        The index of the first item.
	 * @param {Number} y
	 *        The index of the second item.
	 */
	function swap(ary, x, y) {
	  var temp = ary[x];
	  ary[x] = ary[y];
	  ary[y] = temp;
	}

	/**
	 * Returns a random integer within the range `low .. high` inclusive.
	 *
	 * @param {Number} low
	 *        The lower bound on the range.
	 * @param {Number} high
	 *        The upper bound on the range.
	 */
	function randomIntInRange(low, high) {
	  return Math.round(low + (Math.random() * (high - low)));
	}

	/**
	 * The Quick Sort algorithm.
	 *
	 * @param {Array} ary
	 *        An array to sort.
	 * @param {function} comparator
	 *        Function to use to compare two items.
	 * @param {Number} p
	 *        Start index of the array
	 * @param {Number} r
	 *        End index of the array
	 */
	function doQuickSort(ary, comparator, p, r) {
	  // If our lower bound is less than our upper bound, we (1) partition the
	  // array into two pieces and (2) recurse on each half. If it is not, this is
	  // the empty array and our base case.

	  if (p < r) {
	    // (1) Partitioning.
	    //
	    // The partitioning chooses a pivot between `p` and `r` and moves all
	    // elements that are less than or equal to the pivot to the before it, and
	    // all the elements that are greater than it after it. The effect is that
	    // once partition is done, the pivot is in the exact place it will be when
	    // the array is put in sorted order, and it will not need to be moved
	    // again. This runs in O(n) time.

	    // Always choose a random pivot so that an input array which is reverse
	    // sorted does not cause O(n^2) running time.
	    var pivotIndex = randomIntInRange(p, r);
	    var i = p - 1;

	    swap(ary, pivotIndex, r);
	    var pivot = ary[r];

	    // Immediately after `j` is incremented in this loop, the following hold
	    // true:
	    //
	    //   * Every element in `ary[p .. i]` is less than or equal to the pivot.
	    //
	    //   * Every element in `ary[i+1 .. j-1]` is greater than the pivot.
	    for (var j = p; j < r; j++) {
	      if (comparator(ary[j], pivot, false) <= 0) {
	        i += 1;
	        swap(ary, i, j);
	      }
	    }

	    swap(ary, i + 1, j);
	    var q = i + 1;

	    // (2) Recurse on each half.

	    doQuickSort(ary, comparator, p, q - 1);
	    doQuickSort(ary, comparator, q + 1, r);
	  }
	}

	  return doQuickSort;
	}

	function cloneSort(comparator) {
	  let template = SortTemplate.toString();
	  let templateFn = new Function(`return ${template}`)();
	  return templateFn(comparator);
	}

	/**
	 * Sort the given array in-place with the given comparator function.
	 *
	 * @param {Array} ary
	 *        An array to sort.
	 * @param {function} comparator
	 *        Function to use to compare two items.
	 */

	let sortCache = new WeakMap();
	quickSort.quickSort = function (ary, comparator, start = 0) {
	  let doQuickSort = sortCache.get(comparator);
	  if (doQuickSort === void 0) {
	    doQuickSort = cloneSort(comparator);
	    sortCache.set(comparator, doQuickSort);
	  }
	  doQuickSort(ary, comparator, start, ary.length - 1);
	};
	return quickSort;
}

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredSourceMapConsumer;

function requireSourceMapConsumer () {
	if (hasRequiredSourceMapConsumer) return sourceMapConsumer;
	hasRequiredSourceMapConsumer = 1;
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var util = requireUtil();
	var binarySearch = requireBinarySearch();
	var ArraySet = requireArraySet().ArraySet;
	var base64VLQ = requireBase64Vlq();
	var quickSort = requireQuickSort().quickSort;

	function SourceMapConsumer(aSourceMap, aSourceMapURL) {
	  var sourceMap = aSourceMap;
	  if (typeof aSourceMap === 'string') {
	    sourceMap = util.parseSourceMapInput(aSourceMap);
	  }

	  return sourceMap.sections != null
	    ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL)
	    : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
	}

	SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
	  return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
	};

	/**
	 * The version of the source mapping spec that we are consuming.
	 */
	SourceMapConsumer.prototype._version = 3;

	// `__generatedMappings` and `__originalMappings` are arrays that hold the
	// parsed mapping coordinates from the source map's "mappings" attribute. They
	// are lazily instantiated, accessed via the `_generatedMappings` and
	// `_originalMappings` getters respectively, and we only parse the mappings
	// and create these arrays once queried for a source location. We jump through
	// these hoops because there can be many thousands of mappings, and parsing
	// them is expensive, so we only want to do it if we must.
	//
	// Each object in the arrays is of the form:
	//
	//     {
	//       generatedLine: The line number in the generated code,
	//       generatedColumn: The column number in the generated code,
	//       source: The path to the original source file that generated this
	//               chunk of code,
	//       originalLine: The line number in the original source that
	//                     corresponds to this chunk of generated code,
	//       originalColumn: The column number in the original source that
	//                       corresponds to this chunk of generated code,
	//       name: The name of the original symbol which generated this chunk of
	//             code.
	//     }
	//
	// All properties except for `generatedLine` and `generatedColumn` can be
	// `null`.
	//
	// `_generatedMappings` is ordered by the generated positions.
	//
	// `_originalMappings` is ordered by the original positions.

	SourceMapConsumer.prototype.__generatedMappings = null;
	Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {
	  configurable: true,
	  enumerable: true,
	  get: function () {
	    if (!this.__generatedMappings) {
	      this._parseMappings(this._mappings, this.sourceRoot);
	    }

	    return this.__generatedMappings;
	  }
	});

	SourceMapConsumer.prototype.__originalMappings = null;
	Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {
	  configurable: true,
	  enumerable: true,
	  get: function () {
	    if (!this.__originalMappings) {
	      this._parseMappings(this._mappings, this.sourceRoot);
	    }

	    return this.__originalMappings;
	  }
	});

	SourceMapConsumer.prototype._charIsMappingSeparator =
	  function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
	    var c = aStr.charAt(index);
	    return c === ";" || c === ",";
	  };

	/**
	 * Parse the mappings in a string in to a data structure which we can easily
	 * query (the ordered arrays in the `this.__generatedMappings` and
	 * `this.__originalMappings` properties).
	 */
	SourceMapConsumer.prototype._parseMappings =
	  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
	    throw new Error("Subclasses must implement _parseMappings");
	  };

	SourceMapConsumer.GENERATED_ORDER = 1;
	SourceMapConsumer.ORIGINAL_ORDER = 2;

	SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
	SourceMapConsumer.LEAST_UPPER_BOUND = 2;

	/**
	 * Iterate over each mapping between an original source/line/column and a
	 * generated line/column in this source map.
	 *
	 * @param Function aCallback
	 *        The function that is called with each mapping.
	 * @param Object aContext
	 *        Optional. If specified, this object will be the value of `this` every
	 *        time that `aCallback` is called.
	 * @param aOrder
	 *        Either `SourceMapConsumer.GENERATED_ORDER` or
	 *        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
	 *        iterate over the mappings sorted by the generated file's line/column
	 *        order or the original's source/line/column order, respectively. Defaults to
	 *        `SourceMapConsumer.GENERATED_ORDER`.
	 */
	SourceMapConsumer.prototype.eachMapping =
	  function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
	    var context = aContext || null;
	    var order = aOrder || SourceMapConsumer.GENERATED_ORDER;

	    var mappings;
	    switch (order) {
	    case SourceMapConsumer.GENERATED_ORDER:
	      mappings = this._generatedMappings;
	      break;
	    case SourceMapConsumer.ORIGINAL_ORDER:
	      mappings = this._originalMappings;
	      break;
	    default:
	      throw new Error("Unknown order of iteration.");
	    }

	    var sourceRoot = this.sourceRoot;
	    var boundCallback = aCallback.bind(context);
	    var names = this._names;
	    var sources = this._sources;
	    var sourceMapURL = this._sourceMapURL;

	    for (var i = 0, n = mappings.length; i < n; i++) {
	      var mapping = mappings[i];
	      var source = mapping.source === null ? null : sources.at(mapping.source);
	      source = util.computeSourceURL(sourceRoot, source, sourceMapURL);
	      boundCallback({
	        source: source,
	        generatedLine: mapping.generatedLine,
	        generatedColumn: mapping.generatedColumn,
	        originalLine: mapping.originalLine,
	        originalColumn: mapping.originalColumn,
	        name: mapping.name === null ? null : names.at(mapping.name)
	      });
	    }
	  };

	/**
	 * Returns all generated line and column information for the original source,
	 * line, and column provided. If no column is provided, returns all mappings
	 * corresponding to a either the line we are searching for or the next
	 * closest line that has any mappings. Otherwise, returns all mappings
	 * corresponding to the given line and either the column we are searching for
	 * or the next closest column that has any offsets.
	 *
	 * The only argument is an object with the following properties:
	 *
	 *   - source: The filename of the original source.
	 *   - line: The line number in the original source.  The line number is 1-based.
	 *   - column: Optional. the column number in the original source.
	 *    The column number is 0-based.
	 *
	 * and an array of objects is returned, each with the following properties:
	 *
	 *   - line: The line number in the generated source, or null.  The
	 *    line number is 1-based.
	 *   - column: The column number in the generated source, or null.
	 *    The column number is 0-based.
	 */
	SourceMapConsumer.prototype.allGeneratedPositionsFor =
	  function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
	    var line = util.getArg(aArgs, 'line');

	    // When there is no exact match, BasicSourceMapConsumer.prototype._findMapping
	    // returns the index of the closest mapping less than the needle. By
	    // setting needle.originalColumn to 0, we thus find the last mapping for
	    // the given line, provided such a mapping exists.
	    var needle = {
	      source: util.getArg(aArgs, 'source'),
	      originalLine: line,
	      originalColumn: util.getArg(aArgs, 'column', 0)
	    };

	    needle.source = this._findSourceIndex(needle.source);
	    if (needle.source < 0) {
	      return [];
	    }

	    var mappings = [];

	    var index = this._findMapping(needle,
	                                  this._originalMappings,
	                                  "originalLine",
	                                  "originalColumn",
	                                  util.compareByOriginalPositions,
	                                  binarySearch.LEAST_UPPER_BOUND);
	    if (index >= 0) {
	      var mapping = this._originalMappings[index];

	      if (aArgs.column === undefined) {
	        var originalLine = mapping.originalLine;

	        // Iterate until either we run out of mappings, or we run into
	        // a mapping for a different line than the one we found. Since
	        // mappings are sorted, this is guaranteed to find all mappings for
	        // the line we found.
	        while (mapping && mapping.originalLine === originalLine) {
	          mappings.push({
	            line: util.getArg(mapping, 'generatedLine', null),
	            column: util.getArg(mapping, 'generatedColumn', null),
	            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
	          });

	          mapping = this._originalMappings[++index];
	        }
	      } else {
	        var originalColumn = mapping.originalColumn;

	        // Iterate until either we run out of mappings, or we run into
	        // a mapping for a different line than the one we were searching for.
	        // Since mappings are sorted, this is guaranteed to find all mappings for
	        // the line we are searching for.
	        while (mapping &&
	               mapping.originalLine === line &&
	               mapping.originalColumn == originalColumn) {
	          mappings.push({
	            line: util.getArg(mapping, 'generatedLine', null),
	            column: util.getArg(mapping, 'generatedColumn', null),
	            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
	          });

	          mapping = this._originalMappings[++index];
	        }
	      }
	    }

	    return mappings;
	  };

	sourceMapConsumer.SourceMapConsumer = SourceMapConsumer;

	/**
	 * A BasicSourceMapConsumer instance represents a parsed source map which we can
	 * query for information about the original file positions by giving it a file
	 * position in the generated source.
	 *
	 * The first parameter is the raw source map (either as a JSON string, or
	 * already parsed to an object). According to the spec, source maps have the
	 * following attributes:
	 *
	 *   - version: Which version of the source map spec this map is following.
	 *   - sources: An array of URLs to the original source files.
	 *   - names: An array of identifiers which can be referrenced by individual mappings.
	 *   - sourceRoot: Optional. The URL root from which all sources are relative.
	 *   - sourcesContent: Optional. An array of contents of the original source files.
	 *   - mappings: A string of base64 VLQs which contain the actual mappings.
	 *   - file: Optional. The generated file this source map is associated with.
	 *
	 * Here is an example source map, taken from the source map spec[0]:
	 *
	 *     {
	 *       version : 3,
	 *       file: "out.js",
	 *       sourceRoot : "",
	 *       sources: ["foo.js", "bar.js"],
	 *       names: ["src", "maps", "are", "fun"],
	 *       mappings: "AA,AB;;ABCDE;"
	 *     }
	 *
	 * The second parameter, if given, is a string whose value is the URL
	 * at which the source map was found.  This URL is used to compute the
	 * sources array.
	 *
	 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
	 */
	function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
	  var sourceMap = aSourceMap;
	  if (typeof aSourceMap === 'string') {
	    sourceMap = util.parseSourceMapInput(aSourceMap);
	  }

	  var version = util.getArg(sourceMap, 'version');
	  var sources = util.getArg(sourceMap, 'sources');
	  // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
	  // requires the array) to play nice here.
	  var names = util.getArg(sourceMap, 'names', []);
	  var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
	  var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
	  var mappings = util.getArg(sourceMap, 'mappings');
	  var file = util.getArg(sourceMap, 'file', null);

	  // Once again, Sass deviates from the spec and supplies the version as a
	  // string rather than a number, so we use loose equality checking here.
	  if (version != this._version) {
	    throw new Error('Unsupported version: ' + version);
	  }

	  if (sourceRoot) {
	    sourceRoot = util.normalize(sourceRoot);
	  }

	  sources = sources
	    .map(String)
	    // Some source maps produce relative source paths like "./foo.js" instead of
	    // "foo.js".  Normalize these first so that future comparisons will succeed.
	    // See bugzil.la/1090768.
	    .map(util.normalize)
	    // Always ensure that absolute sources are internally stored relative to
	    // the source root, if the source root is absolute. Not doing this would
	    // be particularly problematic when the source root is a prefix of the
	    // source (valid, but why??). See github issue #199 and bugzil.la/1188982.
	    .map(function (source) {
	      return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source)
	        ? util.relative(sourceRoot, source)
	        : source;
	    });

	  // Pass `true` below to allow duplicate names and sources. While source maps
	  // are intended to be compressed and deduplicated, the TypeScript compiler
	  // sometimes generates source maps with duplicates in them. See Github issue
	  // #72 and bugzil.la/889492.
	  this._names = ArraySet.fromArray(names.map(String), true);
	  this._sources = ArraySet.fromArray(sources, true);

	  this._absoluteSources = this._sources.toArray().map(function (s) {
	    return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
	  });

	  this.sourceRoot = sourceRoot;
	  this.sourcesContent = sourcesContent;
	  this._mappings = mappings;
	  this._sourceMapURL = aSourceMapURL;
	  this.file = file;
	}

	BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
	BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;

	/**
	 * Utility function to find the index of a source.  Returns -1 if not
	 * found.
	 */
	BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
	  var relativeSource = aSource;
	  if (this.sourceRoot != null) {
	    relativeSource = util.relative(this.sourceRoot, relativeSource);
	  }

	  if (this._sources.has(relativeSource)) {
	    return this._sources.indexOf(relativeSource);
	  }

	  // Maybe aSource is an absolute URL as returned by |sources|.  In
	  // this case we can't simply undo the transform.
	  var i;
	  for (i = 0; i < this._absoluteSources.length; ++i) {
	    if (this._absoluteSources[i] == aSource) {
	      return i;
	    }
	  }

	  return -1;
	};

	/**
	 * Create a BasicSourceMapConsumer from a SourceMapGenerator.
	 *
	 * @param SourceMapGenerator aSourceMap
	 *        The source map that will be consumed.
	 * @param String aSourceMapURL
	 *        The URL at which the source map can be found (optional)
	 * @returns BasicSourceMapConsumer
	 */
	BasicSourceMapConsumer.fromSourceMap =
	  function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
	    var smc = Object.create(BasicSourceMapConsumer.prototype);

	    var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
	    var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
	    smc.sourceRoot = aSourceMap._sourceRoot;
	    smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(),
	                                                            smc.sourceRoot);
	    smc.file = aSourceMap._file;
	    smc._sourceMapURL = aSourceMapURL;
	    smc._absoluteSources = smc._sources.toArray().map(function (s) {
	      return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
	    });

	    // Because we are modifying the entries (by converting string sources and
	    // names to indices into the sources and names ArraySets), we have to make
	    // a copy of the entry or else bad things happen. Shared mutable state
	    // strikes again! See github issue #191.

	    var generatedMappings = aSourceMap._mappings.toArray().slice();
	    var destGeneratedMappings = smc.__generatedMappings = [];
	    var destOriginalMappings = smc.__originalMappings = [];

	    for (var i = 0, length = generatedMappings.length; i < length; i++) {
	      var srcMapping = generatedMappings[i];
	      var destMapping = new Mapping;
	      destMapping.generatedLine = srcMapping.generatedLine;
	      destMapping.generatedColumn = srcMapping.generatedColumn;

	      if (srcMapping.source) {
	        destMapping.source = sources.indexOf(srcMapping.source);
	        destMapping.originalLine = srcMapping.originalLine;
	        destMapping.originalColumn = srcMapping.originalColumn;

	        if (srcMapping.name) {
	          destMapping.name = names.indexOf(srcMapping.name);
	        }

	        destOriginalMappings.push(destMapping);
	      }

	      destGeneratedMappings.push(destMapping);
	    }

	    quickSort(smc.__originalMappings, util.compareByOriginalPositions);

	    return smc;
	  };

	/**
	 * The version of the source mapping spec that we are consuming.
	 */
	BasicSourceMapConsumer.prototype._version = 3;

	/**
	 * The list of original sources.
	 */
	Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {
	  get: function () {
	    return this._absoluteSources.slice();
	  }
	});

	/**
	 * Provide the JIT with a nice shape / hidden class.
	 */
	function Mapping() {
	  this.generatedLine = 0;
	  this.generatedColumn = 0;
	  this.source = null;
	  this.originalLine = null;
	  this.originalColumn = null;
	  this.name = null;
	}

	/**
	 * Parse the mappings in a string in to a data structure which we can easily
	 * query (the ordered arrays in the `this.__generatedMappings` and
	 * `this.__originalMappings` properties).
	 */

	const compareGenerated = util.compareByGeneratedPositionsDeflatedNoLine;
	function sortGenerated(array, start) {
	  let l = array.length;
	  let n = array.length - start;
	  if (n <= 1) {
	    return;
	  } else if (n == 2) {
	    let a = array[start];
	    let b = array[start + 1];
	    if (compareGenerated(a, b) > 0) {
	      array[start] = b;
	      array[start + 1] = a;
	    }
	  } else if (n < 20) {
	    for (let i = start; i < l; i++) {
	      for (let j = i; j > start; j--) {
	        let a = array[j - 1];
	        let b = array[j];
	        if (compareGenerated(a, b) <= 0) {
	          break;
	        }
	        array[j - 1] = b;
	        array[j] = a;
	      }
	    }
	  } else {
	    quickSort(array, compareGenerated, start);
	  }
	}
	BasicSourceMapConsumer.prototype._parseMappings =
	  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
	    var generatedLine = 1;
	    var previousGeneratedColumn = 0;
	    var previousOriginalLine = 0;
	    var previousOriginalColumn = 0;
	    var previousSource = 0;
	    var previousName = 0;
	    var length = aStr.length;
	    var index = 0;
	    var temp = {};
	    var originalMappings = [];
	    var generatedMappings = [];
	    var mapping, segment, end, value;

	    let subarrayStart = 0;
	    while (index < length) {
	      if (aStr.charAt(index) === ';') {
	        generatedLine++;
	        index++;
	        previousGeneratedColumn = 0;

	        sortGenerated(generatedMappings, subarrayStart);
	        subarrayStart = generatedMappings.length;
	      }
	      else if (aStr.charAt(index) === ',') {
	        index++;
	      }
	      else {
	        mapping = new Mapping();
	        mapping.generatedLine = generatedLine;

	        for (end = index; end < length; end++) {
	          if (this._charIsMappingSeparator(aStr, end)) {
	            break;
	          }
	        }
	        aStr.slice(index, end);

	        segment = [];
	        while (index < end) {
	          base64VLQ.decode(aStr, index, temp);
	          value = temp.value;
	          index = temp.rest;
	          segment.push(value);
	        }

	        if (segment.length === 2) {
	          throw new Error('Found a source, but no line and column');
	        }

	        if (segment.length === 3) {
	          throw new Error('Found a source and line, but no column');
	        }

	        // Generated column.
	        mapping.generatedColumn = previousGeneratedColumn + segment[0];
	        previousGeneratedColumn = mapping.generatedColumn;

	        if (segment.length > 1) {
	          // Original source.
	          mapping.source = previousSource + segment[1];
	          previousSource += segment[1];

	          // Original line.
	          mapping.originalLine = previousOriginalLine + segment[2];
	          previousOriginalLine = mapping.originalLine;
	          // Lines are stored 0-based
	          mapping.originalLine += 1;

	          // Original column.
	          mapping.originalColumn = previousOriginalColumn + segment[3];
	          previousOriginalColumn = mapping.originalColumn;

	          if (segment.length > 4) {
	            // Original name.
	            mapping.name = previousName + segment[4];
	            previousName += segment[4];
	          }
	        }

	        generatedMappings.push(mapping);
	        if (typeof mapping.originalLine === 'number') {
	          let currentSource = mapping.source;
	          while (originalMappings.length <= currentSource) {
	            originalMappings.push(null);
	          }
	          if (originalMappings[currentSource] === null) {
	            originalMappings[currentSource] = [];
	          }
	          originalMappings[currentSource].push(mapping);
	        }
	      }
	    }

	    sortGenerated(generatedMappings, subarrayStart);
	    this.__generatedMappings = generatedMappings;

	    for (var i = 0; i < originalMappings.length; i++) {
	      if (originalMappings[i] != null) {
	        quickSort(originalMappings[i], util.compareByOriginalPositionsNoSource);
	      }
	    }
	    this.__originalMappings = [].concat(...originalMappings);
	  };

	/**
	 * Find the mapping that best matches the hypothetical "needle" mapping that
	 * we are searching for in the given "haystack" of mappings.
	 */
	BasicSourceMapConsumer.prototype._findMapping =
	  function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName,
	                                         aColumnName, aComparator, aBias) {
	    // To return the position we are searching for, we must first find the
	    // mapping for the given position and then return the opposite position it
	    // points to. Because the mappings are sorted, we can use binary search to
	    // find the best mapping.

	    if (aNeedle[aLineName] <= 0) {
	      throw new TypeError('Line must be greater than or equal to 1, got '
	                          + aNeedle[aLineName]);
	    }
	    if (aNeedle[aColumnName] < 0) {
	      throw new TypeError('Column must be greater than or equal to 0, got '
	                          + aNeedle[aColumnName]);
	    }

	    return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
	  };

	/**
	 * Compute the last column for each generated mapping. The last column is
	 * inclusive.
	 */
	BasicSourceMapConsumer.prototype.computeColumnSpans =
	  function SourceMapConsumer_computeColumnSpans() {
	    for (var index = 0; index < this._generatedMappings.length; ++index) {
	      var mapping = this._generatedMappings[index];

	      // Mappings do not contain a field for the last generated columnt. We
	      // can come up with an optimistic estimate, however, by assuming that
	      // mappings are contiguous (i.e. given two consecutive mappings, the
	      // first mapping ends where the second one starts).
	      if (index + 1 < this._generatedMappings.length) {
	        var nextMapping = this._generatedMappings[index + 1];

	        if (mapping.generatedLine === nextMapping.generatedLine) {
	          mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
	          continue;
	        }
	      }

	      // The last mapping for each line spans the entire line.
	      mapping.lastGeneratedColumn = Infinity;
	    }
	  };

	/**
	 * Returns the original source, line, and column information for the generated
	 * source's line and column positions provided. The only argument is an object
	 * with the following properties:
	 *
	 *   - line: The line number in the generated source.  The line number
	 *     is 1-based.
	 *   - column: The column number in the generated source.  The column
	 *     number is 0-based.
	 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
	 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
	 *     closest element that is smaller than or greater than the one we are
	 *     searching for, respectively, if the exact element cannot be found.
	 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
	 *
	 * and an object is returned with the following properties:
	 *
	 *   - source: The original source file, or null.
	 *   - line: The line number in the original source, or null.  The
	 *     line number is 1-based.
	 *   - column: The column number in the original source, or null.  The
	 *     column number is 0-based.
	 *   - name: The original identifier, or null.
	 */
	BasicSourceMapConsumer.prototype.originalPositionFor =
	  function SourceMapConsumer_originalPositionFor(aArgs) {
	    var needle = {
	      generatedLine: util.getArg(aArgs, 'line'),
	      generatedColumn: util.getArg(aArgs, 'column')
	    };

	    var index = this._findMapping(
	      needle,
	      this._generatedMappings,
	      "generatedLine",
	      "generatedColumn",
	      util.compareByGeneratedPositionsDeflated,
	      util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
	    );

	    if (index >= 0) {
	      var mapping = this._generatedMappings[index];

	      if (mapping.generatedLine === needle.generatedLine) {
	        var source = util.getArg(mapping, 'source', null);
	        if (source !== null) {
	          source = this._sources.at(source);
	          source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
	        }
	        var name = util.getArg(mapping, 'name', null);
	        if (name !== null) {
	          name = this._names.at(name);
	        }
	        return {
	          source: source,
	          line: util.getArg(mapping, 'originalLine', null),
	          column: util.getArg(mapping, 'originalColumn', null),
	          name: name
	        };
	      }
	    }

	    return {
	      source: null,
	      line: null,
	      column: null,
	      name: null
	    };
	  };

	/**
	 * Return true if we have the source content for every source in the source
	 * map, false otherwise.
	 */
	BasicSourceMapConsumer.prototype.hasContentsOfAllSources =
	  function BasicSourceMapConsumer_hasContentsOfAllSources() {
	    if (!this.sourcesContent) {
	      return false;
	    }
	    return this.sourcesContent.length >= this._sources.size() &&
	      !this.sourcesContent.some(function (sc) { return sc == null; });
	  };

	/**
	 * Returns the original source content. The only argument is the url of the
	 * original source file. Returns null if no original source content is
	 * available.
	 */
	BasicSourceMapConsumer.prototype.sourceContentFor =
	  function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
	    if (!this.sourcesContent) {
	      return null;
	    }

	    var index = this._findSourceIndex(aSource);
	    if (index >= 0) {
	      return this.sourcesContent[index];
	    }

	    var relativeSource = aSource;
	    if (this.sourceRoot != null) {
	      relativeSource = util.relative(this.sourceRoot, relativeSource);
	    }

	    var url;
	    if (this.sourceRoot != null
	        && (url = util.urlParse(this.sourceRoot))) {
	      // XXX: file:// URIs and absolute paths lead to unexpected behavior for
	      // many users. We can help them out when they expect file:// URIs to
	      // behave like it would if they were running a local HTTP server. See
	      // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
	      var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
	      if (url.scheme == "file"
	          && this._sources.has(fileUriAbsPath)) {
	        return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]
	      }

	      if ((!url.path || url.path == "/")
	          && this._sources.has("/" + relativeSource)) {
	        return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
	      }
	    }

	    // This function is used recursively from
	    // IndexedSourceMapConsumer.prototype.sourceContentFor. In that case, we
	    // don't want to throw if we can't find the source - we just want to
	    // return null, so we provide a flag to exit gracefully.
	    if (nullOnMissing) {
	      return null;
	    }
	    else {
	      throw new Error('"' + relativeSource + '" is not in the SourceMap.');
	    }
	  };

	/**
	 * Returns the generated line and column information for the original source,
	 * line, and column positions provided. The only argument is an object with
	 * the following properties:
	 *
	 *   - source: The filename of the original source.
	 *   - line: The line number in the original source.  The line number
	 *     is 1-based.
	 *   - column: The column number in the original source.  The column
	 *     number is 0-based.
	 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
	 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
	 *     closest element that is smaller than or greater than the one we are
	 *     searching for, respectively, if the exact element cannot be found.
	 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
	 *
	 * and an object is returned with the following properties:
	 *
	 *   - line: The line number in the generated source, or null.  The
	 *     line number is 1-based.
	 *   - column: The column number in the generated source, or null.
	 *     The column number is 0-based.
	 */
	BasicSourceMapConsumer.prototype.generatedPositionFor =
	  function SourceMapConsumer_generatedPositionFor(aArgs) {
	    var source = util.getArg(aArgs, 'source');
	    source = this._findSourceIndex(source);
	    if (source < 0) {
	      return {
	        line: null,
	        column: null,
	        lastColumn: null
	      };
	    }

	    var needle = {
	      source: source,
	      originalLine: util.getArg(aArgs, 'line'),
	      originalColumn: util.getArg(aArgs, 'column')
	    };

	    var index = this._findMapping(
	      needle,
	      this._originalMappings,
	      "originalLine",
	      "originalColumn",
	      util.compareByOriginalPositions,
	      util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND)
	    );

	    if (index >= 0) {
	      var mapping = this._originalMappings[index];

	      if (mapping.source === needle.source) {
	        return {
	          line: util.getArg(mapping, 'generatedLine', null),
	          column: util.getArg(mapping, 'generatedColumn', null),
	          lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
	        };
	      }
	    }

	    return {
	      line: null,
	      column: null,
	      lastColumn: null
	    };
	  };

	sourceMapConsumer.BasicSourceMapConsumer = BasicSourceMapConsumer;

	/**
	 * An IndexedSourceMapConsumer instance represents a parsed source map which
	 * we can query for information. It differs from BasicSourceMapConsumer in
	 * that it takes "indexed" source maps (i.e. ones with a "sections" field) as
	 * input.
	 *
	 * The first parameter is a raw source map (either as a JSON string, or already
	 * parsed to an object). According to the spec for indexed source maps, they
	 * have the following attributes:
	 *
	 *   - version: Which version of the source map spec this map is following.
	 *   - file: Optional. The generated file this source map is associated with.
	 *   - sections: A list of section definitions.
	 *
	 * Each value under the "sections" field has two fields:
	 *   - offset: The offset into the original specified at which this section
	 *       begins to apply, defined as an object with a "line" and "column"
	 *       field.
	 *   - map: A source map definition. This source map could also be indexed,
	 *       but doesn't have to be.
	 *
	 * Instead of the "map" field, it's also possible to have a "url" field
	 * specifying a URL to retrieve a source map from, but that's currently
	 * unsupported.
	 *
	 * Here's an example source map, taken from the source map spec[0], but
	 * modified to omit a section which uses the "url" field.
	 *
	 *  {
	 *    version : 3,
	 *    file: "app.js",
	 *    sections: [{
	 *      offset: {line:100, column:10},
	 *      map: {
	 *        version : 3,
	 *        file: "section.js",
	 *        sources: ["foo.js", "bar.js"],
	 *        names: ["src", "maps", "are", "fun"],
	 *        mappings: "AAAA,E;;ABCDE;"
	 *      }
	 *    }],
	 *  }
	 *
	 * The second parameter, if given, is a string whose value is the URL
	 * at which the source map was found.  This URL is used to compute the
	 * sources array.
	 *
	 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
	 */
	function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
	  var sourceMap = aSourceMap;
	  if (typeof aSourceMap === 'string') {
	    sourceMap = util.parseSourceMapInput(aSourceMap);
	  }

	  var version = util.getArg(sourceMap, 'version');
	  var sections = util.getArg(sourceMap, 'sections');

	  if (version != this._version) {
	    throw new Error('Unsupported version: ' + version);
	  }

	  this._sources = new ArraySet();
	  this._names = new ArraySet();

	  var lastOffset = {
	    line: -1,
	    column: 0
	  };
	  this._sections = sections.map(function (s) {
	    if (s.url) {
	      // The url field will require support for asynchronicity.
	      // See https://github.com/mozilla/source-map/issues/16
	      throw new Error('Support for url field in sections not implemented.');
	    }
	    var offset = util.getArg(s, 'offset');
	    var offsetLine = util.getArg(offset, 'line');
	    var offsetColumn = util.getArg(offset, 'column');

	    if (offsetLine < lastOffset.line ||
	        (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)) {
	      throw new Error('Section offsets must be ordered and non-overlapping.');
	    }
	    lastOffset = offset;

	    return {
	      generatedOffset: {
	        // The offset fields are 0-based, but we use 1-based indices when
	        // encoding/decoding from VLQ.
	        generatedLine: offsetLine + 1,
	        generatedColumn: offsetColumn + 1
	      },
	      consumer: new SourceMapConsumer(util.getArg(s, 'map'), aSourceMapURL)
	    }
	  });
	}

	IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
	IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;

	/**
	 * The version of the source mapping spec that we are consuming.
	 */
	IndexedSourceMapConsumer.prototype._version = 3;

	/**
	 * The list of original sources.
	 */
	Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {
	  get: function () {
	    var sources = [];
	    for (var i = 0; i < this._sections.length; i++) {
	      for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
	        sources.push(this._sections[i].consumer.sources[j]);
	      }
	    }
	    return sources;
	  }
	});

	/**
	 * Returns the original source, line, and column information for the generated
	 * source's line and column positions provided. The only argument is an object
	 * with the following properties:
	 *
	 *   - line: The line number in the generated source.  The line number
	 *     is 1-based.
	 *   - column: The column number in the generated source.  The column
	 *     number is 0-based.
	 *
	 * and an object is returned with the following properties:
	 *
	 *   - source: The original source file, or null.
	 *   - line: The line number in the original source, or null.  The
	 *     line number is 1-based.
	 *   - column: The column number in the original source, or null.  The
	 *     column number is 0-based.
	 *   - name: The original identifier, or null.
	 */
	IndexedSourceMapConsumer.prototype.originalPositionFor =
	  function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
	    var needle = {
	      generatedLine: util.getArg(aArgs, 'line'),
	      generatedColumn: util.getArg(aArgs, 'column')
	    };

	    // Find the section containing the generated position we're trying to map
	    // to an original position.
	    var sectionIndex = binarySearch.search(needle, this._sections,
	      function(needle, section) {
	        var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
	        if (cmp) {
	          return cmp;
	        }

	        return (needle.generatedColumn -
	                section.generatedOffset.generatedColumn);
	      });
	    var section = this._sections[sectionIndex];

	    if (!section) {
	      return {
	        source: null,
	        line: null,
	        column: null,
	        name: null
	      };
	    }

	    return section.consumer.originalPositionFor({
	      line: needle.generatedLine -
	        (section.generatedOffset.generatedLine - 1),
	      column: needle.generatedColumn -
	        (section.generatedOffset.generatedLine === needle.generatedLine
	         ? section.generatedOffset.generatedColumn - 1
	         : 0),
	      bias: aArgs.bias
	    });
	  };

	/**
	 * Return true if we have the source content for every source in the source
	 * map, false otherwise.
	 */
	IndexedSourceMapConsumer.prototype.hasContentsOfAllSources =
	  function IndexedSourceMapConsumer_hasContentsOfAllSources() {
	    return this._sections.every(function (s) {
	      return s.consumer.hasContentsOfAllSources();
	    });
	  };

	/**
	 * Returns the original source content. The only argument is the url of the
	 * original source file. Returns null if no original source content is
	 * available.
	 */
	IndexedSourceMapConsumer.prototype.sourceContentFor =
	  function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
	    for (var i = 0; i < this._sections.length; i++) {
	      var section = this._sections[i];

	      var content = section.consumer.sourceContentFor(aSource, true);
	      if (content || content === '') {
	        return content;
	      }
	    }
	    if (nullOnMissing) {
	      return null;
	    }
	    else {
	      throw new Error('"' + aSource + '" is not in the SourceMap.');
	    }
	  };

	/**
	 * Returns the generated line and column information for the original source,
	 * line, and column positions provided. The only argument is an object with
	 * the following properties:
	 *
	 *   - source: The filename of the original source.
	 *   - line: The line number in the original source.  The line number
	 *     is 1-based.
	 *   - column: The column number in the original source.  The column
	 *     number is 0-based.
	 *
	 * and an object is returned with the following properties:
	 *
	 *   - line: The line number in the generated source, or null.  The
	 *     line number is 1-based. 
	 *   - column: The column number in the generated source, or null.
	 *     The column number is 0-based.
	 */
	IndexedSourceMapConsumer.prototype.generatedPositionFor =
	  function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
	    for (var i = 0; i < this._sections.length; i++) {
	      var section = this._sections[i];

	      // Only consider this section if the requested source is in the list of
	      // sources of the consumer.
	      if (section.consumer._findSourceIndex(util.getArg(aArgs, 'source')) === -1) {
	        continue;
	      }
	      var generatedPosition = section.consumer.generatedPositionFor(aArgs);
	      if (generatedPosition) {
	        var ret = {
	          line: generatedPosition.line +
	            (section.generatedOffset.generatedLine - 1),
	          column: generatedPosition.column +
	            (section.generatedOffset.generatedLine === generatedPosition.line
	             ? section.generatedOffset.generatedColumn - 1
	             : 0)
	        };
	        return ret;
	      }
	    }

	    return {
	      line: null,
	      column: null
	    };
	  };

	/**
	 * Parse the mappings in a string in to a data structure which we can easily
	 * query (the ordered arrays in the `this.__generatedMappings` and
	 * `this.__originalMappings` properties).
	 */
	IndexedSourceMapConsumer.prototype._parseMappings =
	  function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
	    this.__generatedMappings = [];
	    this.__originalMappings = [];
	    for (var i = 0; i < this._sections.length; i++) {
	      var section = this._sections[i];
	      var sectionMappings = section.consumer._generatedMappings;
	      for (var j = 0; j < sectionMappings.length; j++) {
	        var mapping = sectionMappings[j];

	        var source = section.consumer._sources.at(mapping.source);
	        source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
	        this._sources.add(source);
	        source = this._sources.indexOf(source);

	        var name = null;
	        if (mapping.name) {
	          name = section.consumer._names.at(mapping.name);
	          this._names.add(name);
	          name = this._names.indexOf(name);
	        }

	        // The mappings coming from the consumer for the section have
	        // generated positions relative to the start of the section, so we
	        // need to offset them to be relative to the start of the concatenated
	        // generated file.
	        var adjustedMapping = {
	          source: source,
	          generatedLine: mapping.generatedLine +
	            (section.generatedOffset.generatedLine - 1),
	          generatedColumn: mapping.generatedColumn +
	            (section.generatedOffset.generatedLine === mapping.generatedLine
	            ? section.generatedOffset.generatedColumn - 1
	            : 0),
	          originalLine: mapping.originalLine,
	          originalColumn: mapping.originalColumn,
	          name: name
	        };

	        this.__generatedMappings.push(adjustedMapping);
	        if (typeof adjustedMapping.originalLine === 'number') {
	          this.__originalMappings.push(adjustedMapping);
	        }
	      }
	    }

	    quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
	    quickSort(this.__originalMappings, util.compareByOriginalPositions);
	  };

	sourceMapConsumer.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
	return sourceMapConsumer;
}

var sourceNode = {};

/* -*- Mode: js; js-indent-level: 2; -*- */

var hasRequiredSourceNode;

function requireSourceNode () {
	if (hasRequiredSourceNode) return sourceNode;
	hasRequiredSourceNode = 1;
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */

	var SourceMapGenerator = requireSourceMapGenerator().SourceMapGenerator;
	var util = requireUtil();

	// Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
	// operating systems these days (capturing the result).
	var REGEX_NEWLINE = /(\r?\n)/;

	// Newline character code for charCodeAt() comparisons
	var NEWLINE_CODE = 10;

	// Private symbol for identifying `SourceNode`s when multiple versions of
	// the source-map library are loaded. This MUST NOT CHANGE across
	// versions!
	var isSourceNode = "$$$isSourceNode$$$";

	/**
	 * SourceNodes provide a way to abstract over interpolating/concatenating
	 * snippets of generated JavaScript source code while maintaining the line and
	 * column information associated with the original source code.
	 *
	 * @param aLine The original line number.
	 * @param aColumn The original column number.
	 * @param aSource The original source's filename.
	 * @param aChunks Optional. An array of strings which are snippets of
	 *        generated JS, or other SourceNodes.
	 * @param aName The original identifier.
	 */
	function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
	  this.children = [];
	  this.sourceContents = {};
	  this.line = aLine == null ? null : aLine;
	  this.column = aColumn == null ? null : aColumn;
	  this.source = aSource == null ? null : aSource;
	  this.name = aName == null ? null : aName;
	  this[isSourceNode] = true;
	  if (aChunks != null) this.add(aChunks);
	}

	/**
	 * Creates a SourceNode from generated code and a SourceMapConsumer.
	 *
	 * @param aGeneratedCode The generated code
	 * @param aSourceMapConsumer The SourceMap for the generated code
	 * @param aRelativePath Optional. The path that relative sources in the
	 *        SourceMapConsumer should be relative to.
	 */
	SourceNode.fromStringWithSourceMap =
	  function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
	    // The SourceNode we want to fill with the generated code
	    // and the SourceMap
	    var node = new SourceNode();

	    // All even indices of this array are one line of the generated code,
	    // while all odd indices are the newlines between two adjacent lines
	    // (since `REGEX_NEWLINE` captures its match).
	    // Processed fragments are accessed by calling `shiftNextLine`.
	    var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
	    var remainingLinesIndex = 0;
	    var shiftNextLine = function() {
	      var lineContents = getNextLine();
	      // The last line of a file might not have a newline.
	      var newLine = getNextLine() || "";
	      return lineContents + newLine;

	      function getNextLine() {
	        return remainingLinesIndex < remainingLines.length ?
	            remainingLines[remainingLinesIndex++] : undefined;
	      }
	    };

	    // We need to remember the position of "remainingLines"
	    var lastGeneratedLine = 1, lastGeneratedColumn = 0;

	    // The generate SourceNodes we need a code range.
	    // To extract it current and last mapping is used.
	    // Here we store the last mapping.
	    var lastMapping = null;

	    aSourceMapConsumer.eachMapping(function (mapping) {
	      if (lastMapping !== null) {
	        // We add the code from "lastMapping" to "mapping":
	        // First check if there is a new line in between.
	        if (lastGeneratedLine < mapping.generatedLine) {
	          // Associate first line with "lastMapping"
	          addMappingWithCode(lastMapping, shiftNextLine());
	          lastGeneratedLine++;
	          lastGeneratedColumn = 0;
	          // The remaining code is added without mapping
	        } else {
	          // There is no new line in between.
	          // Associate the code between "lastGeneratedColumn" and
	          // "mapping.generatedColumn" with "lastMapping"
	          var nextLine = remainingLines[remainingLinesIndex] || '';
	          var code = nextLine.substr(0, mapping.generatedColumn -
	                                        lastGeneratedColumn);
	          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn -
	                                              lastGeneratedColumn);
	          lastGeneratedColumn = mapping.generatedColumn;
	          addMappingWithCode(lastMapping, code);
	          // No more remaining code, continue
	          lastMapping = mapping;
	          return;
	        }
	      }
	      // We add the generated code until the first mapping
	      // to the SourceNode without any mapping.
	      // Each line is added as separate string.
	      while (lastGeneratedLine < mapping.generatedLine) {
	        node.add(shiftNextLine());
	        lastGeneratedLine++;
	      }
	      if (lastGeneratedColumn < mapping.generatedColumn) {
	        var nextLine = remainingLines[remainingLinesIndex] || '';
	        node.add(nextLine.substr(0, mapping.generatedColumn));
	        remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
	        lastGeneratedColumn = mapping.generatedColumn;
	      }
	      lastMapping = mapping;
	    }, this);
	    // We have processed all mappings.
	    if (remainingLinesIndex < remainingLines.length) {
	      if (lastMapping) {
	        // Associate the remaining code in the current line with "lastMapping"
	        addMappingWithCode(lastMapping, shiftNextLine());
	      }
	      // and add the remaining lines without any mapping
	      node.add(remainingLines.splice(remainingLinesIndex).join(""));
	    }

	    // Copy sourcesContent into SourceNode
	    aSourceMapConsumer.sources.forEach(function (sourceFile) {
	      var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	      if (content != null) {
	        if (aRelativePath != null) {
	          sourceFile = util.join(aRelativePath, sourceFile);
	        }
	        node.setSourceContent(sourceFile, content);
	      }
	    });

	    return node;

	    function addMappingWithCode(mapping, code) {
	      if (mapping === null || mapping.source === undefined) {
	        node.add(code);
	      } else {
	        var source = aRelativePath
	          ? util.join(aRelativePath, mapping.source)
	          : mapping.source;
	        node.add(new SourceNode(mapping.originalLine,
	                                mapping.originalColumn,
	                                source,
	                                code,
	                                mapping.name));
	      }
	    }
	  };

	/**
	 * Add a chunk of generated JS to this source node.
	 *
	 * @param aChunk A string snippet of generated JS code, another instance of
	 *        SourceNode, or an array where each member is one of those things.
	 */
	SourceNode.prototype.add = function SourceNode_add(aChunk) {
	  if (Array.isArray(aChunk)) {
	    aChunk.forEach(function (chunk) {
	      this.add(chunk);
	    }, this);
	  }
	  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
	    if (aChunk) {
	      this.children.push(aChunk);
	    }
	  }
	  else {
	    throw new TypeError(
	      "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
	    );
	  }
	  return this;
	};

	/**
	 * Add a chunk of generated JS to the beginning of this source node.
	 *
	 * @param aChunk A string snippet of generated JS code, another instance of
	 *        SourceNode, or an array where each member is one of those things.
	 */
	SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
	  if (Array.isArray(aChunk)) {
	    for (var i = aChunk.length-1; i >= 0; i--) {
	      this.prepend(aChunk[i]);
	    }
	  }
	  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
	    this.children.unshift(aChunk);
	  }
	  else {
	    throw new TypeError(
	      "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
	    );
	  }
	  return this;
	};

	/**
	 * Walk over the tree of JS snippets in this node and its children. The
	 * walking function is called once for each snippet of JS and is passed that
	 * snippet and the its original associated source's line/column location.
	 *
	 * @param aFn The traversal function.
	 */
	SourceNode.prototype.walk = function SourceNode_walk(aFn) {
	  var chunk;
	  for (var i = 0, len = this.children.length; i < len; i++) {
	    chunk = this.children[i];
	    if (chunk[isSourceNode]) {
	      chunk.walk(aFn);
	    }
	    else {
	      if (chunk !== '') {
	        aFn(chunk, { source: this.source,
	                     line: this.line,
	                     column: this.column,
	                     name: this.name });
	      }
	    }
	  }
	};

	/**
	 * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
	 * each of `this.children`.
	 *
	 * @param aSep The separator.
	 */
	SourceNode.prototype.join = function SourceNode_join(aSep) {
	  var newChildren;
	  var i;
	  var len = this.children.length;
	  if (len > 0) {
	    newChildren = [];
	    for (i = 0; i < len-1; i++) {
	      newChildren.push(this.children[i]);
	      newChildren.push(aSep);
	    }
	    newChildren.push(this.children[i]);
	    this.children = newChildren;
	  }
	  return this;
	};

	/**
	 * Call String.prototype.replace on the very right-most source snippet. Useful
	 * for trimming whitespace from the end of a source node, etc.
	 *
	 * @param aPattern The pattern to replace.
	 * @param aReplacement The thing to replace the pattern with.
	 */
	SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
	  var lastChild = this.children[this.children.length - 1];
	  if (lastChild[isSourceNode]) {
	    lastChild.replaceRight(aPattern, aReplacement);
	  }
	  else if (typeof lastChild === 'string') {
	    this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
	  }
	  else {
	    this.children.push(''.replace(aPattern, aReplacement));
	  }
	  return this;
	};

	/**
	 * Set the source content for a source file. This will be added to the SourceMapGenerator
	 * in the sourcesContent field.
	 *
	 * @param aSourceFile The filename of the source file
	 * @param aSourceContent The content of the source file
	 */
	SourceNode.prototype.setSourceContent =
	  function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
	    this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
	  };

	/**
	 * Walk over the tree of SourceNodes. The walking function is called for each
	 * source file content and is passed the filename and source content.
	 *
	 * @param aFn The traversal function.
	 */
	SourceNode.prototype.walkSourceContents =
	  function SourceNode_walkSourceContents(aFn) {
	    for (var i = 0, len = this.children.length; i < len; i++) {
	      if (this.children[i][isSourceNode]) {
	        this.children[i].walkSourceContents(aFn);
	      }
	    }

	    var sources = Object.keys(this.sourceContents);
	    for (var i = 0, len = sources.length; i < len; i++) {
	      aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
	    }
	  };

	/**
	 * Return the string representation of this source node. Walks over the tree
	 * and concatenates all the various snippets together to one string.
	 */
	SourceNode.prototype.toString = function SourceNode_toString() {
	  var str = "";
	  this.walk(function (chunk) {
	    str += chunk;
	  });
	  return str;
	};

	/**
	 * Returns the string representation of this source node along with a source
	 * map.
	 */
	SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
	  var generated = {
	    code: "",
	    line: 1,
	    column: 0
	  };
	  var map = new SourceMapGenerator(aArgs);
	  var sourceMappingActive = false;
	  var lastOriginalSource = null;
	  var lastOriginalLine = null;
	  var lastOriginalColumn = null;
	  var lastOriginalName = null;
	  this.walk(function (chunk, original) {
	    generated.code += chunk;
	    if (original.source !== null
	        && original.line !== null
	        && original.column !== null) {
	      if(lastOriginalSource !== original.source
	         || lastOriginalLine !== original.line
	         || lastOriginalColumn !== original.column
	         || lastOriginalName !== original.name) {
	        map.addMapping({
	          source: original.source,
	          original: {
	            line: original.line,
	            column: original.column
	          },
	          generated: {
	            line: generated.line,
	            column: generated.column
	          },
	          name: original.name
	        });
	      }
	      lastOriginalSource = original.source;
	      lastOriginalLine = original.line;
	      lastOriginalColumn = original.column;
	      lastOriginalName = original.name;
	      sourceMappingActive = true;
	    } else if (sourceMappingActive) {
	      map.addMapping({
	        generated: {
	          line: generated.line,
	          column: generated.column
	        }
	      });
	      lastOriginalSource = null;
	      sourceMappingActive = false;
	    }
	    for (var idx = 0, length = chunk.length; idx < length; idx++) {
	      if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
	        generated.line++;
	        generated.column = 0;
	        // Mappings end at eol
	        if (idx + 1 === length) {
	          lastOriginalSource = null;
	          sourceMappingActive = false;
	        } else if (sourceMappingActive) {
	          map.addMapping({
	            source: original.source,
	            original: {
	              line: original.line,
	              column: original.column
	            },
	            generated: {
	              line: generated.line,
	              column: generated.column
	            },
	            name: original.name
	          });
	        }
	      } else {
	        generated.column++;
	      }
	    }
	  });
	  this.walkSourceContents(function (sourceFile, sourceContent) {
	    map.setSourceContent(sourceFile, sourceContent);
	  });

	  return { code: generated.code, map: map };
	};

	sourceNode.SourceNode = SourceNode;
	return sourceNode;
}

/*
 * Copyright 2009-2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE.txt or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

var hasRequiredSourceMap;

function requireSourceMap () {
	if (hasRequiredSourceMap) return sourceMap;
	hasRequiredSourceMap = 1;
	sourceMap.SourceMapGenerator = requireSourceMapGenerator().SourceMapGenerator;
	sourceMap.SourceMapConsumer = requireSourceMapConsumer().SourceMapConsumer;
	sourceMap.SourceNode = requireSourceNode().SourceNode;
	return sourceMap;
}

var nonSecure;
var hasRequiredNonSecure;

function requireNonSecure () {
	if (hasRequiredNonSecure) return nonSecure;
	hasRequiredNonSecure = 1;
	let urlAlphabet =
	  'useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict';
	let customAlphabet = (alphabet, defaultSize = 21) => {
	  return (size = defaultSize) => {
	    let id = '';
	    let i = size;
	    while (i--) {
	      id += alphabet[(Math.random() * alphabet.length) | 0];
	    }
	    return id
	  }
	};
	let nanoid = (size = 21) => {
	  let id = '';
	  let i = size;
	  while (i--) {
	    id += urlAlphabet[(Math.random() * 64) | 0];
	  }
	  return id
	};
	nonSecure = { nanoid, customAlphabet };
	return nonSecure;
}

var previousMap;
var hasRequiredPreviousMap;

function requirePreviousMap () {
	if (hasRequiredPreviousMap) return previousMap;
	hasRequiredPreviousMap = 1;

	let { SourceMapConsumer, SourceMapGenerator } = requireSourceMap();
	let { existsSync, readFileSync } = require$$1;
	let { dirname, join } = require$$2;

	function fromBase64(str) {
	  if (Buffer) {
	    return Buffer.from(str, 'base64').toString()
	  } else {
	    /* c8 ignore next 2 */
	    return window.atob(str)
	  }
	}

	class PreviousMap {
	  constructor(css, opts) {
	    if (opts.map === false) return
	    this.loadAnnotation(css);
	    this.inline = this.startWith(this.annotation, 'data:');

	    let prev = opts.map ? opts.map.prev : undefined;
	    let text = this.loadMap(opts.from, prev);
	    if (!this.mapFile && opts.from) {
	      this.mapFile = opts.from;
	    }
	    if (this.mapFile) this.root = dirname(this.mapFile);
	    if (text) this.text = text;
	  }

	  consumer() {
	    if (!this.consumerCache) {
	      this.consumerCache = new SourceMapConsumer(this.text);
	    }
	    return this.consumerCache
	  }

	  decodeInline(text) {
	    let baseCharsetUri = /^data:application\/json;charset=utf-?8;base64,/;
	    let baseUri = /^data:application\/json;base64,/;
	    let charsetUri = /^data:application\/json;charset=utf-?8,/;
	    let uri = /^data:application\/json,/;

	    if (charsetUri.test(text) || uri.test(text)) {
	      return decodeURIComponent(text.substr(RegExp.lastMatch.length))
	    }

	    if (baseCharsetUri.test(text) || baseUri.test(text)) {
	      return fromBase64(text.substr(RegExp.lastMatch.length))
	    }

	    let encoding = text.match(/data:application\/json;([^,]+),/)[1];
	    throw new Error('Unsupported source map encoding ' + encoding)
	  }

	  getAnnotationURL(sourceMapString) {
	    return sourceMapString.replace(/^\/\*\s*# sourceMappingURL=/, '').trim()
	  }

	  isMap(map) {
	    if (typeof map !== 'object') return false
	    return (
	      typeof map.mappings === 'string' ||
	      typeof map._mappings === 'string' ||
	      Array.isArray(map.sections)
	    )
	  }

	  loadAnnotation(css) {
	    let comments = css.match(/\/\*\s*# sourceMappingURL=/gm);
	    if (!comments) return

	    // sourceMappingURLs from comments, strings, etc.
	    let start = css.lastIndexOf(comments.pop());
	    let end = css.indexOf('*/', start);

	    if (start > -1 && end > -1) {
	      // Locate the last sourceMappingURL to avoid pickin
	      this.annotation = this.getAnnotationURL(css.substring(start, end));
	    }
	  }

	  loadFile(path) {
	    this.root = dirname(path);
	    if (existsSync(path)) {
	      this.mapFile = path;
	      return readFileSync(path, 'utf-8').toString().trim()
	    }
	  }

	  loadMap(file, prev) {
	    if (prev === false) return false

	    if (prev) {
	      if (typeof prev === 'string') {
	        return prev
	      } else if (typeof prev === 'function') {
	        let prevPath = prev(file);
	        if (prevPath) {
	          let map = this.loadFile(prevPath);
	          if (!map) {
	            throw new Error(
	              'Unable to load previous source map: ' + prevPath.toString()
	            )
	          }
	          return map
	        }
	      } else if (prev instanceof SourceMapConsumer) {
	        return SourceMapGenerator.fromSourceMap(prev).toString()
	      } else if (prev instanceof SourceMapGenerator) {
	        return prev.toString()
	      } else if (this.isMap(prev)) {
	        return JSON.stringify(prev)
	      } else {
	        throw new Error(
	          'Unsupported previous source map format: ' + prev.toString()
	        )
	      }
	    } else if (this.inline) {
	      return this.decodeInline(this.annotation)
	    } else if (this.annotation) {
	      let map = this.annotation;
	      if (file) map = join(dirname(file), map);
	      return this.loadFile(map)
	    }
	  }

	  startWith(string, start) {
	    if (!string) return false
	    return string.substr(0, start.length) === start
	  }

	  withContent() {
	    return !!(
	      this.consumer().sourcesContent &&
	      this.consumer().sourcesContent.length > 0
	    )
	  }
	}

	previousMap = PreviousMap;
	PreviousMap.default = PreviousMap;
	return previousMap;
}

var input;
var hasRequiredInput;

function requireInput () {
	if (hasRequiredInput) return input;
	hasRequiredInput = 1;

	let { SourceMapConsumer, SourceMapGenerator } = requireSourceMap();
	let { fileURLToPath, pathToFileURL } = require$$1$1;
	let { isAbsolute, resolve } = require$$2;
	let { nanoid } = requireNonSecure();

	let terminalHighlight = requireTerminalHighlight();
	let CssSyntaxError = requireCssSyntaxError();
	let PreviousMap = requirePreviousMap();

	let fromOffsetCache = Symbol('fromOffsetCache');

	let sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator);
	let pathAvailable = Boolean(resolve && isAbsolute);

	class Input {
	  constructor(css, opts = {}) {
	    if (
	      css === null ||
	      typeof css === 'undefined' ||
	      (typeof css === 'object' && !css.toString)
	    ) {
	      throw new Error(`PostCSS received ${css} instead of CSS string`)
	    }

	    this.css = css.toString();

	    if (this.css[0] === '\uFEFF' || this.css[0] === '\uFFFE') {
	      this.hasBOM = true;
	      this.css = this.css.slice(1);
	    } else {
	      this.hasBOM = false;
	    }

	    if (opts.from) {
	      if (
	        !pathAvailable ||
	        /^\w+:\/\//.test(opts.from) ||
	        isAbsolute(opts.from)
	      ) {
	        this.file = opts.from;
	      } else {
	        this.file = resolve(opts.from);
	      }
	    }

	    if (pathAvailable && sourceMapAvailable) {
	      let map = new PreviousMap(this.css, opts);
	      if (map.text) {
	        this.map = map;
	        let file = map.consumer().file;
	        if (!this.file && file) this.file = this.mapResolve(file);
	      }
	    }

	    if (!this.file) {
	      this.id = '<input css ' + nanoid(6) + '>';
	    }
	    if (this.map) this.map.file = this.from;
	  }

	  error(message, line, column, opts = {}) {
	    let result, endLine, endColumn;

	    if (line && typeof line === 'object') {
	      let start = line;
	      let end = column;
	      if (typeof start.offset === 'number') {
	        let pos = this.fromOffset(start.offset);
	        line = pos.line;
	        column = pos.col;
	      } else {
	        line = start.line;
	        column = start.column;
	      }
	      if (typeof end.offset === 'number') {
	        let pos = this.fromOffset(end.offset);
	        endLine = pos.line;
	        endColumn = pos.col;
	      } else {
	        endLine = end.line;
	        endColumn = end.column;
	      }
	    } else if (!column) {
	      let pos = this.fromOffset(line);
	      line = pos.line;
	      column = pos.col;
	    }

	    let origin = this.origin(line, column, endLine, endColumn);
	    if (origin) {
	      result = new CssSyntaxError(
	        message,
	        origin.endLine === undefined
	          ? origin.line
	          : { column: origin.column, line: origin.line },
	        origin.endLine === undefined
	          ? origin.column
	          : { column: origin.endColumn, line: origin.endLine },
	        origin.source,
	        origin.file,
	        opts.plugin
	      );
	    } else {
	      result = new CssSyntaxError(
	        message,
	        endLine === undefined ? line : { column, line },
	        endLine === undefined ? column : { column: endColumn, line: endLine },
	        this.css,
	        this.file,
	        opts.plugin
	      );
	    }

	    result.input = { column, endColumn, endLine, line, source: this.css };
	    if (this.file) {
	      if (pathToFileURL) {
	        result.input.url = pathToFileURL(this.file).toString();
	      }
	      result.input.file = this.file;
	    }

	    return result
	  }

	  fromOffset(offset) {
	    let lastLine, lineToIndex;
	    if (!this[fromOffsetCache]) {
	      let lines = this.css.split('\n');
	      lineToIndex = new Array(lines.length);
	      let prevIndex = 0;

	      for (let i = 0, l = lines.length; i < l; i++) {
	        lineToIndex[i] = prevIndex;
	        prevIndex += lines[i].length + 1;
	      }

	      this[fromOffsetCache] = lineToIndex;
	    } else {
	      lineToIndex = this[fromOffsetCache];
	    }
	    lastLine = lineToIndex[lineToIndex.length - 1];

	    let min = 0;
	    if (offset >= lastLine) {
	      min = lineToIndex.length - 1;
	    } else {
	      let max = lineToIndex.length - 2;
	      let mid;
	      while (min < max) {
	        mid = min + ((max - min) >> 1);
	        if (offset < lineToIndex[mid]) {
	          max = mid - 1;
	        } else if (offset >= lineToIndex[mid + 1]) {
	          min = mid + 1;
	        } else {
	          min = mid;
	          break
	        }
	      }
	    }
	    return {
	      col: offset - lineToIndex[min] + 1,
	      line: min + 1
	    }
	  }

	  mapResolve(file) {
	    if (/^\w+:\/\//.test(file)) {
	      return file
	    }
	    return resolve(this.map.consumer().sourceRoot || this.map.root || '.', file)
	  }

	  origin(line, column, endLine, endColumn) {
	    if (!this.map) return false
	    let consumer = this.map.consumer();

	    let from = consumer.originalPositionFor({ column, line });
	    if (!from.source) return false

	    let to;
	    if (typeof endLine === 'number') {
	      to = consumer.originalPositionFor({ column: endColumn, line: endLine });
	    }

	    let fromUrl;

	    if (isAbsolute(from.source)) {
	      fromUrl = pathToFileURL(from.source);
	    } else {
	      fromUrl = new URL(
	        from.source,
	        this.map.consumer().sourceRoot || pathToFileURL(this.map.mapFile)
	      );
	    }

	    let result = {
	      column: from.column,
	      endColumn: to && to.column,
	      endLine: to && to.line,
	      line: from.line,
	      url: fromUrl.toString()
	    };

	    if (fromUrl.protocol === 'file:') {
	      if (fileURLToPath) {
	        result.file = fileURLToPath(fromUrl);
	      } else {
	        /* c8 ignore next 2 */
	        throw new Error(`file: protocol is not available in this PostCSS build`)
	      }
	    }

	    let source = consumer.sourceContentFor(from.source);
	    if (source) result.source = source;

	    return result
	  }

	  toJSON() {
	    let json = {};
	    for (let name of ['hasBOM', 'css', 'file', 'id']) {
	      if (this[name] != null) {
	        json[name] = this[name];
	      }
	    }
	    if (this.map) {
	      json.map = { ...this.map };
	      if (json.map.consumerCache) {
	        json.map.consumerCache = undefined;
	      }
	    }
	    return json
	  }

	  get from() {
	    return this.file || this.id
	  }
	}

	input = Input;
	Input.default = Input;

	if (terminalHighlight && terminalHighlight.registerInput) {
	  terminalHighlight.registerInput(Input);
	}
	return input;
}

var mapGenerator;
var hasRequiredMapGenerator;

function requireMapGenerator () {
	if (hasRequiredMapGenerator) return mapGenerator;
	hasRequiredMapGenerator = 1;

	let { SourceMapConsumer, SourceMapGenerator } = requireSourceMap();
	let { dirname, relative, resolve, sep } = require$$2;
	let { pathToFileURL } = require$$1$1;

	let Input = requireInput();

	let sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator);
	let pathAvailable = Boolean(dirname && resolve && relative && sep);

	class MapGenerator {
	  constructor(stringify, root, opts, cssString) {
	    this.stringify = stringify;
	    this.mapOpts = opts.map || {};
	    this.root = root;
	    this.opts = opts;
	    this.css = cssString;
	    this.originalCSS = cssString;
	    this.usesFileUrls = !this.mapOpts.from && this.mapOpts.absolute;

	    this.memoizedFileURLs = new Map();
	    this.memoizedPaths = new Map();
	    this.memoizedURLs = new Map();
	  }

	  addAnnotation() {
	    let content;

	    if (this.isInline()) {
	      content =
	        'data:application/json;base64,' + this.toBase64(this.map.toString());
	    } else if (typeof this.mapOpts.annotation === 'string') {
	      content = this.mapOpts.annotation;
	    } else if (typeof this.mapOpts.annotation === 'function') {
	      content = this.mapOpts.annotation(this.opts.to, this.root);
	    } else {
	      content = this.outputFile() + '.map';
	    }
	    let eol = '\n';
	    if (this.css.includes('\r\n')) eol = '\r\n';

	    this.css += eol + '/*# sourceMappingURL=' + content + ' */';
	  }

	  applyPrevMaps() {
	    for (let prev of this.previous()) {
	      let from = this.toUrl(this.path(prev.file));
	      let root = prev.root || dirname(prev.file);
	      let map;

	      if (this.mapOpts.sourcesContent === false) {
	        map = new SourceMapConsumer(prev.text);
	        if (map.sourcesContent) {
	          map.sourcesContent = null;
	        }
	      } else {
	        map = prev.consumer();
	      }

	      this.map.applySourceMap(map, from, this.toUrl(this.path(root)));
	    }
	  }

	  clearAnnotation() {
	    if (this.mapOpts.annotation === false) return

	    if (this.root) {
	      let node;
	      for (let i = this.root.nodes.length - 1; i >= 0; i--) {
	        node = this.root.nodes[i];
	        if (node.type !== 'comment') continue
	        if (node.text.indexOf('# sourceMappingURL=') === 0) {
	          this.root.removeChild(i);
	        }
	      }
	    } else if (this.css) {
	      this.css = this.css.replace(/\n*?\/\*#[\S\s]*?\*\/$/gm, '');
	    }
	  }

	  generate() {
	    this.clearAnnotation();
	    if (pathAvailable && sourceMapAvailable && this.isMap()) {
	      return this.generateMap()
	    } else {
	      let result = '';
	      this.stringify(this.root, i => {
	        result += i;
	      });
	      return [result]
	    }
	  }

	  generateMap() {
	    if (this.root) {
	      this.generateString();
	    } else if (this.previous().length === 1) {
	      let prev = this.previous()[0].consumer();
	      prev.file = this.outputFile();
	      this.map = SourceMapGenerator.fromSourceMap(prev, {
	        ignoreInvalidMapping: true
	      });
	    } else {
	      this.map = new SourceMapGenerator({
	        file: this.outputFile(),
	        ignoreInvalidMapping: true
	      });
	      this.map.addMapping({
	        generated: { column: 0, line: 1 },
	        original: { column: 0, line: 1 },
	        source: this.opts.from
	          ? this.toUrl(this.path(this.opts.from))
	          : '<no source>'
	      });
	    }

	    if (this.isSourcesContent()) this.setSourcesContent();
	    if (this.root && this.previous().length > 0) this.applyPrevMaps();
	    if (this.isAnnotation()) this.addAnnotation();

	    if (this.isInline()) {
	      return [this.css]
	    } else {
	      return [this.css, this.map]
	    }
	  }

	  generateString() {
	    this.css = '';
	    this.map = new SourceMapGenerator({
	      file: this.outputFile(),
	      ignoreInvalidMapping: true
	    });

	    let line = 1;
	    let column = 1;

	    let noSource = '<no source>';
	    let mapping = {
	      generated: { column: 0, line: 0 },
	      original: { column: 0, line: 0 },
	      source: ''
	    };

	    let lines, last;
	    this.stringify(this.root, (str, node, type) => {
	      this.css += str;

	      if (node && type !== 'end') {
	        mapping.generated.line = line;
	        mapping.generated.column = column - 1;
	        if (node.source && node.source.start) {
	          mapping.source = this.sourcePath(node);
	          mapping.original.line = node.source.start.line;
	          mapping.original.column = node.source.start.column - 1;
	          this.map.addMapping(mapping);
	        } else {
	          mapping.source = noSource;
	          mapping.original.line = 1;
	          mapping.original.column = 0;
	          this.map.addMapping(mapping);
	        }
	      }

	      lines = str.match(/\n/g);
	      if (lines) {
	        line += lines.length;
	        last = str.lastIndexOf('\n');
	        column = str.length - last;
	      } else {
	        column += str.length;
	      }

	      if (node && type !== 'start') {
	        let p = node.parent || { raws: {} };
	        let childless =
	          node.type === 'decl' || (node.type === 'atrule' && !node.nodes);
	        if (!childless || node !== p.last || p.raws.semicolon) {
	          if (node.source && node.source.end) {
	            mapping.source = this.sourcePath(node);
	            mapping.original.line = node.source.end.line;
	            mapping.original.column = node.source.end.column - 1;
	            mapping.generated.line = line;
	            mapping.generated.column = column - 2;
	            this.map.addMapping(mapping);
	          } else {
	            mapping.source = noSource;
	            mapping.original.line = 1;
	            mapping.original.column = 0;
	            mapping.generated.line = line;
	            mapping.generated.column = column - 1;
	            this.map.addMapping(mapping);
	          }
	        }
	      }
	    });
	  }

	  isAnnotation() {
	    if (this.isInline()) {
	      return true
	    }
	    if (typeof this.mapOpts.annotation !== 'undefined') {
	      return this.mapOpts.annotation
	    }
	    if (this.previous().length) {
	      return this.previous().some(i => i.annotation)
	    }
	    return true
	  }

	  isInline() {
	    if (typeof this.mapOpts.inline !== 'undefined') {
	      return this.mapOpts.inline
	    }

	    let annotation = this.mapOpts.annotation;
	    if (typeof annotation !== 'undefined' && annotation !== true) {
	      return false
	    }

	    if (this.previous().length) {
	      return this.previous().some(i => i.inline)
	    }
	    return true
	  }

	  isMap() {
	    if (typeof this.opts.map !== 'undefined') {
	      return !!this.opts.map
	    }
	    return this.previous().length > 0
	  }

	  isSourcesContent() {
	    if (typeof this.mapOpts.sourcesContent !== 'undefined') {
	      return this.mapOpts.sourcesContent
	    }
	    if (this.previous().length) {
	      return this.previous().some(i => i.withContent())
	    }
	    return true
	  }

	  outputFile() {
	    if (this.opts.to) {
	      return this.path(this.opts.to)
	    } else if (this.opts.from) {
	      return this.path(this.opts.from)
	    } else {
	      return 'to.css'
	    }
	  }

	  path(file) {
	    if (this.mapOpts.absolute) return file
	    if (file.charCodeAt(0) === 60 /* `<` */) return file
	    if (/^\w+:\/\//.test(file)) return file
	    let cached = this.memoizedPaths.get(file);
	    if (cached) return cached

	    let from = this.opts.to ? dirname(this.opts.to) : '.';

	    if (typeof this.mapOpts.annotation === 'string') {
	      from = dirname(resolve(from, this.mapOpts.annotation));
	    }

	    let path = relative(from, file);
	    this.memoizedPaths.set(file, path);

	    return path
	  }

	  previous() {
	    if (!this.previousMaps) {
	      this.previousMaps = [];
	      if (this.root) {
	        this.root.walk(node => {
	          if (node.source && node.source.input.map) {
	            let map = node.source.input.map;
	            if (!this.previousMaps.includes(map)) {
	              this.previousMaps.push(map);
	            }
	          }
	        });
	      } else {
	        let input = new Input(this.originalCSS, this.opts);
	        if (input.map) this.previousMaps.push(input.map);
	      }
	    }

	    return this.previousMaps
	  }

	  setSourcesContent() {
	    let already = {};
	    if (this.root) {
	      this.root.walk(node => {
	        if (node.source) {
	          let from = node.source.input.from;
	          if (from && !already[from]) {
	            already[from] = true;
	            let fromUrl = this.usesFileUrls
	              ? this.toFileUrl(from)
	              : this.toUrl(this.path(from));
	            this.map.setSourceContent(fromUrl, node.source.input.css);
	          }
	        }
	      });
	    } else if (this.css) {
	      let from = this.opts.from
	        ? this.toUrl(this.path(this.opts.from))
	        : '<no source>';
	      this.map.setSourceContent(from, this.css);
	    }
	  }

	  sourcePath(node) {
	    if (this.mapOpts.from) {
	      return this.toUrl(this.mapOpts.from)
	    } else if (this.usesFileUrls) {
	      return this.toFileUrl(node.source.input.from)
	    } else {
	      return this.toUrl(this.path(node.source.input.from))
	    }
	  }

	  toBase64(str) {
	    if (Buffer) {
	      return Buffer.from(str).toString('base64')
	    } else {
	      return window.btoa(unescape(encodeURIComponent(str)))
	    }
	  }

	  toFileUrl(path) {
	    let cached = this.memoizedFileURLs.get(path);
	    if (cached) return cached

	    if (pathToFileURL) {
	      let fileURL = pathToFileURL(path).toString();
	      this.memoizedFileURLs.set(path, fileURL);

	      return fileURL
	    } else {
	      throw new Error(
	        '`map.absolute` option is not available in this PostCSS build'
	      )
	    }
	  }

	  toUrl(path) {
	    let cached = this.memoizedURLs.get(path);
	    if (cached) return cached

	    if (sep === '\\') {
	      path = path.replace(/\\/g, '/');
	    }

	    let url = encodeURI(path).replace(/[#?]/g, encodeURIComponent);
	    this.memoizedURLs.set(path, url);

	    return url
	  }
	}

	mapGenerator = MapGenerator;
	return mapGenerator;
}

var comment;
var hasRequiredComment;

function requireComment () {
	if (hasRequiredComment) return comment;
	hasRequiredComment = 1;

	let Node = requireNode();

	class Comment extends Node {
	  constructor(defaults) {
	    super(defaults);
	    this.type = 'comment';
	  }
	}

	comment = Comment;
	Comment.default = Comment;
	return comment;
}

var container;
var hasRequiredContainer;

function requireContainer () {
	if (hasRequiredContainer) return container;
	hasRequiredContainer = 1;

	let { isClean, my } = requireSymbols();
	let Declaration = requireDeclaration();
	let Comment = requireComment();
	let Node = requireNode();

	let parse, Rule, AtRule, Root;

	function cleanSource(nodes) {
	  return nodes.map(i => {
	    if (i.nodes) i.nodes = cleanSource(i.nodes);
	    delete i.source;
	    return i
	  })
	}

	function markDirtyUp(node) {
	  node[isClean] = false;
	  if (node.proxyOf.nodes) {
	    for (let i of node.proxyOf.nodes) {
	      markDirtyUp(i);
	    }
	  }
	}

	class Container extends Node {
	  append(...children) {
	    for (let child of children) {
	      let nodes = this.normalize(child, this.last);
	      for (let node of nodes) this.proxyOf.nodes.push(node);
	    }

	    this.markDirty();

	    return this
	  }

	  cleanRaws(keepBetween) {
	    super.cleanRaws(keepBetween);
	    if (this.nodes) {
	      for (let node of this.nodes) node.cleanRaws(keepBetween);
	    }
	  }

	  each(callback) {
	    if (!this.proxyOf.nodes) return undefined
	    let iterator = this.getIterator();

	    let index, result;
	    while (this.indexes[iterator] < this.proxyOf.nodes.length) {
	      index = this.indexes[iterator];
	      result = callback(this.proxyOf.nodes[index], index);
	      if (result === false) break

	      this.indexes[iterator] += 1;
	    }

	    delete this.indexes[iterator];
	    return result
	  }

	  every(condition) {
	    return this.nodes.every(condition)
	  }

	  getIterator() {
	    if (!this.lastEach) this.lastEach = 0;
	    if (!this.indexes) this.indexes = {};

	    this.lastEach += 1;
	    let iterator = this.lastEach;
	    this.indexes[iterator] = 0;

	    return iterator
	  }

	  getProxyProcessor() {
	    return {
	      get(node, prop) {
	        if (prop === 'proxyOf') {
	          return node
	        } else if (!node[prop]) {
	          return node[prop]
	        } else if (
	          prop === 'each' ||
	          (typeof prop === 'string' && prop.startsWith('walk'))
	        ) {
	          return (...args) => {
	            return node[prop](
	              ...args.map(i => {
	                if (typeof i === 'function') {
	                  return (child, index) => i(child.toProxy(), index)
	                } else {
	                  return i
	                }
	              })
	            )
	          }
	        } else if (prop === 'every' || prop === 'some') {
	          return cb => {
	            return node[prop]((child, ...other) =>
	              cb(child.toProxy(), ...other)
	            )
	          }
	        } else if (prop === 'root') {
	          return () => node.root().toProxy()
	        } else if (prop === 'nodes') {
	          return node.nodes.map(i => i.toProxy())
	        } else if (prop === 'first' || prop === 'last') {
	          return node[prop].toProxy()
	        } else {
	          return node[prop]
	        }
	      },

	      set(node, prop, value) {
	        if (node[prop] === value) return true
	        node[prop] = value;
	        if (prop === 'name' || prop === 'params' || prop === 'selector') {
	          node.markDirty();
	        }
	        return true
	      }
	    }
	  }

	  index(child) {
	    if (typeof child === 'number') return child
	    if (child.proxyOf) child = child.proxyOf;
	    return this.proxyOf.nodes.indexOf(child)
	  }

	  insertAfter(exist, add) {
	    let existIndex = this.index(exist);
	    let nodes = this.normalize(add, this.proxyOf.nodes[existIndex]).reverse();
	    existIndex = this.index(exist);
	    for (let node of nodes) this.proxyOf.nodes.splice(existIndex + 1, 0, node);

	    let index;
	    for (let id in this.indexes) {
	      index = this.indexes[id];
	      if (existIndex < index) {
	        this.indexes[id] = index + nodes.length;
	      }
	    }

	    this.markDirty();

	    return this
	  }

	  insertBefore(exist, add) {
	    let existIndex = this.index(exist);
	    let type = existIndex === 0 ? 'prepend' : false;
	    let nodes = this.normalize(add, this.proxyOf.nodes[existIndex], type).reverse();
	    existIndex = this.index(exist);
	    for (let node of nodes) this.proxyOf.nodes.splice(existIndex, 0, node);

	    let index;
	    for (let id in this.indexes) {
	      index = this.indexes[id];
	      if (existIndex <= index) {
	        this.indexes[id] = index + nodes.length;
	      }
	    }

	    this.markDirty();

	    return this
	  }

	  normalize(nodes, sample) {
	    if (typeof nodes === 'string') {
	      nodes = cleanSource(parse(nodes).nodes);
	    } else if (typeof nodes === 'undefined') {
	      nodes = [];
	    } else if (Array.isArray(nodes)) {
	      nodes = nodes.slice(0);
	      for (let i of nodes) {
	        if (i.parent) i.parent.removeChild(i, 'ignore');
	      }
	    } else if (nodes.type === 'root' && this.type !== 'document') {
	      nodes = nodes.nodes.slice(0);
	      for (let i of nodes) {
	        if (i.parent) i.parent.removeChild(i, 'ignore');
	      }
	    } else if (nodes.type) {
	      nodes = [nodes];
	    } else if (nodes.prop) {
	      if (typeof nodes.value === 'undefined') {
	        throw new Error('Value field is missed in node creation')
	      } else if (typeof nodes.value !== 'string') {
	        nodes.value = String(nodes.value);
	      }
	      nodes = [new Declaration(nodes)];
	    } else if (nodes.selector) {
	      nodes = [new Rule(nodes)];
	    } else if (nodes.name) {
	      nodes = [new AtRule(nodes)];
	    } else if (nodes.text) {
	      nodes = [new Comment(nodes)];
	    } else {
	      throw new Error('Unknown node type in node creation')
	    }

	    let processed = nodes.map(i => {
	      /* c8 ignore next */
	      if (!i[my]) Container.rebuild(i);
	      i = i.proxyOf;
	      if (i.parent) i.parent.removeChild(i);
	      if (i[isClean]) markDirtyUp(i);
	      if (typeof i.raws.before === 'undefined') {
	        if (sample && typeof sample.raws.before !== 'undefined') {
	          i.raws.before = sample.raws.before.replace(/\S/g, '');
	        }
	      }
	      i.parent = this.proxyOf;
	      return i
	    });

	    return processed
	  }

	  prepend(...children) {
	    children = children.reverse();
	    for (let child of children) {
	      let nodes = this.normalize(child, this.first, 'prepend').reverse();
	      for (let node of nodes) this.proxyOf.nodes.unshift(node);
	      for (let id in this.indexes) {
	        this.indexes[id] = this.indexes[id] + nodes.length;
	      }
	    }

	    this.markDirty();

	    return this
	  }

	  push(child) {
	    child.parent = this;
	    this.proxyOf.nodes.push(child);
	    return this
	  }

	  removeAll() {
	    for (let node of this.proxyOf.nodes) node.parent = undefined;
	    this.proxyOf.nodes = [];

	    this.markDirty();

	    return this
	  }

	  removeChild(child) {
	    child = this.index(child);
	    this.proxyOf.nodes[child].parent = undefined;
	    this.proxyOf.nodes.splice(child, 1);

	    let index;
	    for (let id in this.indexes) {
	      index = this.indexes[id];
	      if (index >= child) {
	        this.indexes[id] = index - 1;
	      }
	    }

	    this.markDirty();

	    return this
	  }

	  replaceValues(pattern, opts, callback) {
	    if (!callback) {
	      callback = opts;
	      opts = {};
	    }

	    this.walkDecls(decl => {
	      if (opts.props && !opts.props.includes(decl.prop)) return
	      if (opts.fast && !decl.value.includes(opts.fast)) return

	      decl.value = decl.value.replace(pattern, callback);
	    });

	    this.markDirty();

	    return this
	  }

	  some(condition) {
	    return this.nodes.some(condition)
	  }

	  walk(callback) {
	    return this.each((child, i) => {
	      let result;
	      try {
	        result = callback(child, i);
	      } catch (e) {
	        throw child.addToError(e)
	      }
	      if (result !== false && child.walk) {
	        result = child.walk(callback);
	      }

	      return result
	    })
	  }

	  walkAtRules(name, callback) {
	    if (!callback) {
	      callback = name;
	      return this.walk((child, i) => {
	        if (child.type === 'atrule') {
	          return callback(child, i)
	        }
	      })
	    }
	    if (name instanceof RegExp) {
	      return this.walk((child, i) => {
	        if (child.type === 'atrule' && name.test(child.name)) {
	          return callback(child, i)
	        }
	      })
	    }
	    return this.walk((child, i) => {
	      if (child.type === 'atrule' && child.name === name) {
	        return callback(child, i)
	      }
	    })
	  }

	  walkComments(callback) {
	    return this.walk((child, i) => {
	      if (child.type === 'comment') {
	        return callback(child, i)
	      }
	    })
	  }

	  walkDecls(prop, callback) {
	    if (!callback) {
	      callback = prop;
	      return this.walk((child, i) => {
	        if (child.type === 'decl') {
	          return callback(child, i)
	        }
	      })
	    }
	    if (prop instanceof RegExp) {
	      return this.walk((child, i) => {
	        if (child.type === 'decl' && prop.test(child.prop)) {
	          return callback(child, i)
	        }
	      })
	    }
	    return this.walk((child, i) => {
	      if (child.type === 'decl' && child.prop === prop) {
	        return callback(child, i)
	      }
	    })
	  }

	  walkRules(selector, callback) {
	    if (!callback) {
	      callback = selector;

	      return this.walk((child, i) => {
	        if (child.type === 'rule') {
	          return callback(child, i)
	        }
	      })
	    }
	    if (selector instanceof RegExp) {
	      return this.walk((child, i) => {
	        if (child.type === 'rule' && selector.test(child.selector)) {
	          return callback(child, i)
	        }
	      })
	    }
	    return this.walk((child, i) => {
	      if (child.type === 'rule' && child.selector === selector) {
	        return callback(child, i)
	      }
	    })
	  }

	  get first() {
	    if (!this.proxyOf.nodes) return undefined
	    return this.proxyOf.nodes[0]
	  }

	  get last() {
	    if (!this.proxyOf.nodes) return undefined
	    return this.proxyOf.nodes[this.proxyOf.nodes.length - 1]
	  }
	}

	Container.registerParse = dependant => {
	  parse = dependant;
	};

	Container.registerRule = dependant => {
	  Rule = dependant;
	};

	Container.registerAtRule = dependant => {
	  AtRule = dependant;
	};

	Container.registerRoot = dependant => {
	  Root = dependant;
	};

	container = Container;
	Container.default = Container;

	/* c8 ignore start */
	Container.rebuild = node => {
	  if (node.type === 'atrule') {
	    Object.setPrototypeOf(node, AtRule.prototype);
	  } else if (node.type === 'rule') {
	    Object.setPrototypeOf(node, Rule.prototype);
	  } else if (node.type === 'decl') {
	    Object.setPrototypeOf(node, Declaration.prototype);
	  } else if (node.type === 'comment') {
	    Object.setPrototypeOf(node, Comment.prototype);
	  } else if (node.type === 'root') {
	    Object.setPrototypeOf(node, Root.prototype);
	  }

	  node[my] = true;

	  if (node.nodes) {
	    node.nodes.forEach(child => {
	      Container.rebuild(child);
	    });
	  }
	};
	/* c8 ignore stop */
	return container;
}

var document$1;
var hasRequiredDocument;

function requireDocument () {
	if (hasRequiredDocument) return document$1;
	hasRequiredDocument = 1;

	let Container = requireContainer();

	let LazyResult, Processor;

	class Document extends Container {
	  constructor(defaults) {
	    // type needs to be passed to super, otherwise child roots won't be normalized correctly
	    super({ type: 'document', ...defaults });

	    if (!this.nodes) {
	      this.nodes = [];
	    }
	  }

	  toResult(opts = {}) {
	    let lazy = new LazyResult(new Processor(), this, opts);

	    return lazy.stringify()
	  }
	}

	Document.registerLazyResult = dependant => {
	  LazyResult = dependant;
	};

	Document.registerProcessor = dependant => {
	  Processor = dependant;
	};

	document$1 = Document;
	Document.default = Document;
	return document$1;
}

/* eslint-disable no-console */

var warnOnce;
var hasRequiredWarnOnce;

function requireWarnOnce () {
	if (hasRequiredWarnOnce) return warnOnce;
	hasRequiredWarnOnce = 1;

	let printed = {};

	warnOnce = function warnOnce(message) {
	  if (printed[message]) return
	  printed[message] = true;

	  if (typeof console !== 'undefined' && console.warn) {
	    console.warn(message);
	  }
	};
	return warnOnce;
}

var warning;
var hasRequiredWarning;

function requireWarning () {
	if (hasRequiredWarning) return warning;
	hasRequiredWarning = 1;

	class Warning {
	  constructor(text, opts = {}) {
	    this.type = 'warning';
	    this.text = text;

	    if (opts.node && opts.node.source) {
	      let range = opts.node.rangeBy(opts);
	      this.line = range.start.line;
	      this.column = range.start.column;
	      this.endLine = range.end.line;
	      this.endColumn = range.end.column;
	    }

	    for (let opt in opts) this[opt] = opts[opt];
	  }

	  toString() {
	    if (this.node) {
	      return this.node.error(this.text, {
	        index: this.index,
	        plugin: this.plugin,
	        word: this.word
	      }).message
	    }

	    if (this.plugin) {
	      return this.plugin + ': ' + this.text
	    }

	    return this.text
	  }
	}

	warning = Warning;
	Warning.default = Warning;
	return warning;
}

var result;
var hasRequiredResult;

function requireResult () {
	if (hasRequiredResult) return result;
	hasRequiredResult = 1;

	let Warning = requireWarning();

	class Result {
	  constructor(processor, root, opts) {
	    this.processor = processor;
	    this.messages = [];
	    this.root = root;
	    this.opts = opts;
	    this.css = undefined;
	    this.map = undefined;
	  }

	  toString() {
	    return this.css
	  }

	  warn(text, opts = {}) {
	    if (!opts.plugin) {
	      if (this.lastPlugin && this.lastPlugin.postcssPlugin) {
	        opts.plugin = this.lastPlugin.postcssPlugin;
	      }
	    }

	    let warning = new Warning(text, opts);
	    this.messages.push(warning);

	    return warning
	  }

	  warnings() {
	    return this.messages.filter(i => i.type === 'warning')
	  }

	  get content() {
	    return this.css
	  }
	}

	result = Result;
	Result.default = Result;
	return result;
}

var atRule;
var hasRequiredAtRule;

function requireAtRule () {
	if (hasRequiredAtRule) return atRule;
	hasRequiredAtRule = 1;

	let Container = requireContainer();

	class AtRule extends Container {
	  constructor(defaults) {
	    super(defaults);
	    this.type = 'atrule';
	  }

	  append(...children) {
	    if (!this.proxyOf.nodes) this.nodes = [];
	    return super.append(...children)
	  }

	  prepend(...children) {
	    if (!this.proxyOf.nodes) this.nodes = [];
	    return super.prepend(...children)
	  }
	}

	atRule = AtRule;
	AtRule.default = AtRule;

	Container.registerAtRule(AtRule);
	return atRule;
}

var root;
var hasRequiredRoot;

function requireRoot () {
	if (hasRequiredRoot) return root;
	hasRequiredRoot = 1;

	let Container = requireContainer();

	let LazyResult, Processor;

	class Root extends Container {
	  constructor(defaults) {
	    super(defaults);
	    this.type = 'root';
	    if (!this.nodes) this.nodes = [];
	  }

	  normalize(child, sample, type) {
	    let nodes = super.normalize(child);

	    if (sample) {
	      if (type === 'prepend') {
	        if (this.nodes.length > 1) {
	          sample.raws.before = this.nodes[1].raws.before;
	        } else {
	          delete sample.raws.before;
	        }
	      } else if (this.first !== sample) {
	        for (let node of nodes) {
	          node.raws.before = sample.raws.before;
	        }
	      }
	    }

	    return nodes
	  }

	  removeChild(child, ignore) {
	    let index = this.index(child);

	    if (!ignore && index === 0 && this.nodes.length > 1) {
	      this.nodes[1].raws.before = this.nodes[index].raws.before;
	    }

	    return super.removeChild(child)
	  }

	  toResult(opts = {}) {
	    let lazy = new LazyResult(new Processor(), this, opts);
	    return lazy.stringify()
	  }
	}

	Root.registerLazyResult = dependant => {
	  LazyResult = dependant;
	};

	Root.registerProcessor = dependant => {
	  Processor = dependant;
	};

	root = Root;
	Root.default = Root;

	Container.registerRoot(Root);
	return root;
}

var list_1;
var hasRequiredList;

function requireList () {
	if (hasRequiredList) return list_1;
	hasRequiredList = 1;

	let list = {
	  comma(string) {
	    return list.split(string, [','], true)
	  },

	  space(string) {
	    let spaces = [' ', '\n', '\t'];
	    return list.split(string, spaces)
	  },

	  split(string, separators, last) {
	    let array = [];
	    let current = '';
	    let split = false;

	    let func = 0;
	    let inQuote = false;
	    let prevQuote = '';
	    let escape = false;

	    for (let letter of string) {
	      if (escape) {
	        escape = false;
	      } else if (letter === '\\') {
	        escape = true;
	      } else if (inQuote) {
	        if (letter === prevQuote) {
	          inQuote = false;
	        }
	      } else if (letter === '"' || letter === "'") {
	        inQuote = true;
	        prevQuote = letter;
	      } else if (letter === '(') {
	        func += 1;
	      } else if (letter === ')') {
	        if (func > 0) func -= 1;
	      } else if (func === 0) {
	        if (separators.includes(letter)) split = true;
	      }

	      if (split) {
	        if (current !== '') array.push(current.trim());
	        current = '';
	        split = false;
	      } else {
	        current += letter;
	      }
	    }

	    if (last || current !== '') array.push(current.trim());
	    return array
	  }
	};

	list_1 = list;
	list.default = list;
	return list_1;
}

var rule;
var hasRequiredRule;

function requireRule () {
	if (hasRequiredRule) return rule;
	hasRequiredRule = 1;

	let Container = requireContainer();
	let list = requireList();

	class Rule extends Container {
	  constructor(defaults) {
	    super(defaults);
	    this.type = 'rule';
	    if (!this.nodes) this.nodes = [];
	  }

	  get selectors() {
	    return list.comma(this.selector)
	  }

	  set selectors(values) {
	    let match = this.selector ? this.selector.match(/,\s*/) : null;
	    let sep = match ? match[0] : ',' + this.raw('between', 'beforeOpen');
	    this.selector = values.join(sep);
	  }
	}

	rule = Rule;
	Rule.default = Rule;

	Container.registerRule(Rule);
	return rule;
}

var parser;
var hasRequiredParser;

function requireParser () {
	if (hasRequiredParser) return parser;
	hasRequiredParser = 1;

	let Declaration = requireDeclaration();
	let tokenizer = requireTokenize();
	let Comment = requireComment();
	let AtRule = requireAtRule();
	let Root = requireRoot();
	let Rule = requireRule();

	const SAFE_COMMENT_NEIGHBOR = {
	  empty: true,
	  space: true
	};

	function findLastWithPosition(tokens) {
	  for (let i = tokens.length - 1; i >= 0; i--) {
	    let token = tokens[i];
	    let pos = token[3] || token[2];
	    if (pos) return pos
	  }
	}

	class Parser {
	  constructor(input) {
	    this.input = input;

	    this.root = new Root();
	    this.current = this.root;
	    this.spaces = '';
	    this.semicolon = false;

	    this.createTokenizer();
	    this.root.source = { input, start: { column: 1, line: 1, offset: 0 } };
	  }

	  atrule(token) {
	    let node = new AtRule();
	    node.name = token[1].slice(1);
	    if (node.name === '') {
	      this.unnamedAtrule(node, token);
	    }
	    this.init(node, token[2]);

	    let type;
	    let prev;
	    let shift;
	    let last = false;
	    let open = false;
	    let params = [];
	    let brackets = [];

	    while (!this.tokenizer.endOfFile()) {
	      token = this.tokenizer.nextToken();
	      type = token[0];

	      if (type === '(' || type === '[') {
	        brackets.push(type === '(' ? ')' : ']');
	      } else if (type === '{' && brackets.length > 0) {
	        brackets.push('}');
	      } else if (type === brackets[brackets.length - 1]) {
	        brackets.pop();
	      }

	      if (brackets.length === 0) {
	        if (type === ';') {
	          node.source.end = this.getPosition(token[2]);
	          node.source.end.offset++;
	          this.semicolon = true;
	          break
	        } else if (type === '{') {
	          open = true;
	          break
	        } else if (type === '}') {
	          if (params.length > 0) {
	            shift = params.length - 1;
	            prev = params[shift];
	            while (prev && prev[0] === 'space') {
	              prev = params[--shift];
	            }
	            if (prev) {
	              node.source.end = this.getPosition(prev[3] || prev[2]);
	              node.source.end.offset++;
	            }
	          }
	          this.end(token);
	          break
	        } else {
	          params.push(token);
	        }
	      } else {
	        params.push(token);
	      }

	      if (this.tokenizer.endOfFile()) {
	        last = true;
	        break
	      }
	    }

	    node.raws.between = this.spacesAndCommentsFromEnd(params);
	    if (params.length) {
	      node.raws.afterName = this.spacesAndCommentsFromStart(params);
	      this.raw(node, 'params', params);
	      if (last) {
	        token = params[params.length - 1];
	        node.source.end = this.getPosition(token[3] || token[2]);
	        node.source.end.offset++;
	        this.spaces = node.raws.between;
	        node.raws.between = '';
	      }
	    } else {
	      node.raws.afterName = '';
	      node.params = '';
	    }

	    if (open) {
	      node.nodes = [];
	      this.current = node;
	    }
	  }

	  checkMissedSemicolon(tokens) {
	    let colon = this.colon(tokens);
	    if (colon === false) return

	    let founded = 0;
	    let token;
	    for (let j = colon - 1; j >= 0; j--) {
	      token = tokens[j];
	      if (token[0] !== 'space') {
	        founded += 1;
	        if (founded === 2) break
	      }
	    }
	    // If the token is a word, e.g. `!important`, `red` or any other valid property's value.
	    // Then we need to return the colon after that word token. [3] is the "end" colon of that word.
	    // And because we need it after that one we do +1 to get the next one.
	    throw this.input.error(
	      'Missed semicolon',
	      token[0] === 'word' ? token[3] + 1 : token[2]
	    )
	  }

	  colon(tokens) {
	    let brackets = 0;
	    let token, type, prev;
	    for (let [i, element] of tokens.entries()) {
	      token = element;
	      type = token[0];

	      if (type === '(') {
	        brackets += 1;
	      }
	      if (type === ')') {
	        brackets -= 1;
	      }
	      if (brackets === 0 && type === ':') {
	        if (!prev) {
	          this.doubleColon(token);
	        } else if (prev[0] === 'word' && prev[1] === 'progid') {
	          continue
	        } else {
	          return i
	        }
	      }

	      prev = token;
	    }
	    return false
	  }

	  comment(token) {
	    let node = new Comment();
	    this.init(node, token[2]);
	    node.source.end = this.getPosition(token[3] || token[2]);
	    node.source.end.offset++;

	    let text = token[1].slice(2, -2);
	    if (/^\s*$/.test(text)) {
	      node.text = '';
	      node.raws.left = text;
	      node.raws.right = '';
	    } else {
	      let match = text.match(/^(\s*)([^]*\S)(\s*)$/);
	      node.text = match[2];
	      node.raws.left = match[1];
	      node.raws.right = match[3];
	    }
	  }

	  createTokenizer() {
	    this.tokenizer = tokenizer(this.input);
	  }

	  decl(tokens, customProperty) {
	    let node = new Declaration();
	    this.init(node, tokens[0][2]);

	    let last = tokens[tokens.length - 1];
	    if (last[0] === ';') {
	      this.semicolon = true;
	      tokens.pop();
	    }

	    node.source.end = this.getPosition(
	      last[3] || last[2] || findLastWithPosition(tokens)
	    );
	    node.source.end.offset++;

	    while (tokens[0][0] !== 'word') {
	      if (tokens.length === 1) this.unknownWord(tokens);
	      node.raws.before += tokens.shift()[1];
	    }
	    node.source.start = this.getPosition(tokens[0][2]);

	    node.prop = '';
	    while (tokens.length) {
	      let type = tokens[0][0];
	      if (type === ':' || type === 'space' || type === 'comment') {
	        break
	      }
	      node.prop += tokens.shift()[1];
	    }

	    node.raws.between = '';

	    let token;
	    while (tokens.length) {
	      token = tokens.shift();

	      if (token[0] === ':') {
	        node.raws.between += token[1];
	        break
	      } else {
	        if (token[0] === 'word' && /\w/.test(token[1])) {
	          this.unknownWord([token]);
	        }
	        node.raws.between += token[1];
	      }
	    }

	    if (node.prop[0] === '_' || node.prop[0] === '*') {
	      node.raws.before += node.prop[0];
	      node.prop = node.prop.slice(1);
	    }

	    let firstSpaces = [];
	    let next;
	    while (tokens.length) {
	      next = tokens[0][0];
	      if (next !== 'space' && next !== 'comment') break
	      firstSpaces.push(tokens.shift());
	    }

	    this.precheckMissedSemicolon(tokens);

	    for (let i = tokens.length - 1; i >= 0; i--) {
	      token = tokens[i];
	      if (token[1].toLowerCase() === '!important') {
	        node.important = true;
	        let string = this.stringFrom(tokens, i);
	        string = this.spacesFromEnd(tokens) + string;
	        if (string !== ' !important') node.raws.important = string;
	        break
	      } else if (token[1].toLowerCase() === 'important') {
	        let cache = tokens.slice(0);
	        let str = '';
	        for (let j = i; j > 0; j--) {
	          let type = cache[j][0];
	          if (str.trim().indexOf('!') === 0 && type !== 'space') {
	            break
	          }
	          str = cache.pop()[1] + str;
	        }
	        if (str.trim().indexOf('!') === 0) {
	          node.important = true;
	          node.raws.important = str;
	          tokens = cache;
	        }
	      }

	      if (token[0] !== 'space' && token[0] !== 'comment') {
	        break
	      }
	    }

	    let hasWord = tokens.some(i => i[0] !== 'space' && i[0] !== 'comment');

	    if (hasWord) {
	      node.raws.between += firstSpaces.map(i => i[1]).join('');
	      firstSpaces = [];
	    }
	    this.raw(node, 'value', firstSpaces.concat(tokens), customProperty);

	    if (node.value.includes(':') && !customProperty) {
	      this.checkMissedSemicolon(tokens);
	    }
	  }

	  doubleColon(token) {
	    throw this.input.error(
	      'Double colon',
	      { offset: token[2] },
	      { offset: token[2] + token[1].length }
	    )
	  }

	  emptyRule(token) {
	    let node = new Rule();
	    this.init(node, token[2]);
	    node.selector = '';
	    node.raws.between = '';
	    this.current = node;
	  }

	  end(token) {
	    if (this.current.nodes && this.current.nodes.length) {
	      this.current.raws.semicolon = this.semicolon;
	    }
	    this.semicolon = false;

	    this.current.raws.after = (this.current.raws.after || '') + this.spaces;
	    this.spaces = '';

	    if (this.current.parent) {
	      this.current.source.end = this.getPosition(token[2]);
	      this.current.source.end.offset++;
	      this.current = this.current.parent;
	    } else {
	      this.unexpectedClose(token);
	    }
	  }

	  endFile() {
	    if (this.current.parent) this.unclosedBlock();
	    if (this.current.nodes && this.current.nodes.length) {
	      this.current.raws.semicolon = this.semicolon;
	    }
	    this.current.raws.after = (this.current.raws.after || '') + this.spaces;
	    this.root.source.end = this.getPosition(this.tokenizer.position());
	  }

	  freeSemicolon(token) {
	    this.spaces += token[1];
	    if (this.current.nodes) {
	      let prev = this.current.nodes[this.current.nodes.length - 1];
	      if (prev && prev.type === 'rule' && !prev.raws.ownSemicolon) {
	        prev.raws.ownSemicolon = this.spaces;
	        this.spaces = '';
	      }
	    }
	  }

	  // Helpers

	  getPosition(offset) {
	    let pos = this.input.fromOffset(offset);
	    return {
	      column: pos.col,
	      line: pos.line,
	      offset
	    }
	  }

	  init(node, offset) {
	    this.current.push(node);
	    node.source = {
	      input: this.input,
	      start: this.getPosition(offset)
	    };
	    node.raws.before = this.spaces;
	    this.spaces = '';
	    if (node.type !== 'comment') this.semicolon = false;
	  }

	  other(start) {
	    let end = false;
	    let type = null;
	    let colon = false;
	    let bracket = null;
	    let brackets = [];
	    let customProperty = start[1].startsWith('--');

	    let tokens = [];
	    let token = start;
	    while (token) {
	      type = token[0];
	      tokens.push(token);

	      if (type === '(' || type === '[') {
	        if (!bracket) bracket = token;
	        brackets.push(type === '(' ? ')' : ']');
	      } else if (customProperty && colon && type === '{') {
	        if (!bracket) bracket = token;
	        brackets.push('}');
	      } else if (brackets.length === 0) {
	        if (type === ';') {
	          if (colon) {
	            this.decl(tokens, customProperty);
	            return
	          } else {
	            break
	          }
	        } else if (type === '{') {
	          this.rule(tokens);
	          return
	        } else if (type === '}') {
	          this.tokenizer.back(tokens.pop());
	          end = true;
	          break
	        } else if (type === ':') {
	          colon = true;
	        }
	      } else if (type === brackets[brackets.length - 1]) {
	        brackets.pop();
	        if (brackets.length === 0) bracket = null;
	      }

	      token = this.tokenizer.nextToken();
	    }

	    if (this.tokenizer.endOfFile()) end = true;
	    if (brackets.length > 0) this.unclosedBracket(bracket);

	    if (end && colon) {
	      if (!customProperty) {
	        while (tokens.length) {
	          token = tokens[tokens.length - 1][0];
	          if (token !== 'space' && token !== 'comment') break
	          this.tokenizer.back(tokens.pop());
	        }
	      }
	      this.decl(tokens, customProperty);
	    } else {
	      this.unknownWord(tokens);
	    }
	  }

	  parse() {
	    let token;
	    while (!this.tokenizer.endOfFile()) {
	      token = this.tokenizer.nextToken();

	      switch (token[0]) {
	        case 'space':
	          this.spaces += token[1];
	          break

	        case ';':
	          this.freeSemicolon(token);
	          break

	        case '}':
	          this.end(token);
	          break

	        case 'comment':
	          this.comment(token);
	          break

	        case 'at-word':
	          this.atrule(token);
	          break

	        case '{':
	          this.emptyRule(token);
	          break

	        default:
	          this.other(token);
	          break
	      }
	    }
	    this.endFile();
	  }

	  precheckMissedSemicolon(/* tokens */) {
	    // Hook for Safe Parser
	  }

	  raw(node, prop, tokens, customProperty) {
	    let token, type;
	    let length = tokens.length;
	    let value = '';
	    let clean = true;
	    let next, prev;

	    for (let i = 0; i < length; i += 1) {
	      token = tokens[i];
	      type = token[0];
	      if (type === 'space' && i === length - 1 && !customProperty) {
	        clean = false;
	      } else if (type === 'comment') {
	        prev = tokens[i - 1] ? tokens[i - 1][0] : 'empty';
	        next = tokens[i + 1] ? tokens[i + 1][0] : 'empty';
	        if (!SAFE_COMMENT_NEIGHBOR[prev] && !SAFE_COMMENT_NEIGHBOR[next]) {
	          if (value.slice(-1) === ',') {
	            clean = false;
	          } else {
	            value += token[1];
	          }
	        } else {
	          clean = false;
	        }
	      } else {
	        value += token[1];
	      }
	    }
	    if (!clean) {
	      let raw = tokens.reduce((all, i) => all + i[1], '');
	      node.raws[prop] = { raw, value };
	    }
	    node[prop] = value;
	  }

	  rule(tokens) {
	    tokens.pop();

	    let node = new Rule();
	    this.init(node, tokens[0][2]);

	    node.raws.between = this.spacesAndCommentsFromEnd(tokens);
	    this.raw(node, 'selector', tokens);
	    this.current = node;
	  }

	  spacesAndCommentsFromEnd(tokens) {
	    let lastTokenType;
	    let spaces = '';
	    while (tokens.length) {
	      lastTokenType = tokens[tokens.length - 1][0];
	      if (lastTokenType !== 'space' && lastTokenType !== 'comment') break
	      spaces = tokens.pop()[1] + spaces;
	    }
	    return spaces
	  }

	  // Errors

	  spacesAndCommentsFromStart(tokens) {
	    let next;
	    let spaces = '';
	    while (tokens.length) {
	      next = tokens[0][0];
	      if (next !== 'space' && next !== 'comment') break
	      spaces += tokens.shift()[1];
	    }
	    return spaces
	  }

	  spacesFromEnd(tokens) {
	    let lastTokenType;
	    let spaces = '';
	    while (tokens.length) {
	      lastTokenType = tokens[tokens.length - 1][0];
	      if (lastTokenType !== 'space') break
	      spaces = tokens.pop()[1] + spaces;
	    }
	    return spaces
	  }

	  stringFrom(tokens, from) {
	    let result = '';
	    for (let i = from; i < tokens.length; i++) {
	      result += tokens[i][1];
	    }
	    tokens.splice(from, tokens.length - from);
	    return result
	  }

	  unclosedBlock() {
	    let pos = this.current.source.start;
	    throw this.input.error('Unclosed block', pos.line, pos.column)
	  }

	  unclosedBracket(bracket) {
	    throw this.input.error(
	      'Unclosed bracket',
	      { offset: bracket[2] },
	      { offset: bracket[2] + 1 }
	    )
	  }

	  unexpectedClose(token) {
	    throw this.input.error(
	      'Unexpected }',
	      { offset: token[2] },
	      { offset: token[2] + 1 }
	    )
	  }

	  unknownWord(tokens) {
	    throw this.input.error(
	      'Unknown word',
	      { offset: tokens[0][2] },
	      { offset: tokens[0][2] + tokens[0][1].length }
	    )
	  }

	  unnamedAtrule(node, token) {
	    throw this.input.error(
	      'At-rule without name',
	      { offset: token[2] },
	      { offset: token[2] + token[1].length }
	    )
	  }
	}

	parser = Parser;
	return parser;
}

var parse_1;
var hasRequiredParse;

function requireParse () {
	if (hasRequiredParse) return parse_1;
	hasRequiredParse = 1;

	let Container = requireContainer();
	let Parser = requireParser();
	let Input = requireInput();

	function parse(css, opts) {
	  let input = new Input(css, opts);
	  let parser = new Parser(input);
	  try {
	    parser.parse();
	  } catch (e) {
	    if (process.env.NODE_ENV !== 'production') {
	      if (e.name === 'CssSyntaxError' && opts && opts.from) {
	        if (/\.scss$/i.test(opts.from)) {
	          e.message +=
	            '\nYou tried to parse SCSS with ' +
	            'the standard CSS parser; ' +
	            'try again with the postcss-scss parser';
	        } else if (/\.sass/i.test(opts.from)) {
	          e.message +=
	            '\nYou tried to parse Sass with ' +
	            'the standard CSS parser; ' +
	            'try again with the postcss-sass parser';
	        } else if (/\.less$/i.test(opts.from)) {
	          e.message +=
	            '\nYou tried to parse Less with ' +
	            'the standard CSS parser; ' +
	            'try again with the postcss-less parser';
	        }
	      }
	    }
	    throw e
	  }

	  return parser.root
	}

	parse_1 = parse;
	parse.default = parse;

	Container.registerParse(parse);
	return parse_1;
}

var lazyResult;
var hasRequiredLazyResult;

function requireLazyResult () {
	if (hasRequiredLazyResult) return lazyResult;
	hasRequiredLazyResult = 1;

	let { isClean, my } = requireSymbols();
	let MapGenerator = requireMapGenerator();
	let stringify = requireStringify();
	let Container = requireContainer();
	let Document = requireDocument();
	let warnOnce = requireWarnOnce();
	let Result = requireResult();
	let parse = requireParse();
	let Root = requireRoot();

	const TYPE_TO_CLASS_NAME = {
	  atrule: 'AtRule',
	  comment: 'Comment',
	  decl: 'Declaration',
	  document: 'Document',
	  root: 'Root',
	  rule: 'Rule'
	};

	const PLUGIN_PROPS = {
	  AtRule: true,
	  AtRuleExit: true,
	  Comment: true,
	  CommentExit: true,
	  Declaration: true,
	  DeclarationExit: true,
	  Document: true,
	  DocumentExit: true,
	  Once: true,
	  OnceExit: true,
	  postcssPlugin: true,
	  prepare: true,
	  Root: true,
	  RootExit: true,
	  Rule: true,
	  RuleExit: true
	};

	const NOT_VISITORS = {
	  Once: true,
	  postcssPlugin: true,
	  prepare: true
	};

	const CHILDREN = 0;

	function isPromise(obj) {
	  return typeof obj === 'object' && typeof obj.then === 'function'
	}

	function getEvents(node) {
	  let key = false;
	  let type = TYPE_TO_CLASS_NAME[node.type];
	  if (node.type === 'decl') {
	    key = node.prop.toLowerCase();
	  } else if (node.type === 'atrule') {
	    key = node.name.toLowerCase();
	  }

	  if (key && node.append) {
	    return [
	      type,
	      type + '-' + key,
	      CHILDREN,
	      type + 'Exit',
	      type + 'Exit-' + key
	    ]
	  } else if (key) {
	    return [type, type + '-' + key, type + 'Exit', type + 'Exit-' + key]
	  } else if (node.append) {
	    return [type, CHILDREN, type + 'Exit']
	  } else {
	    return [type, type + 'Exit']
	  }
	}

	function toStack(node) {
	  let events;
	  if (node.type === 'document') {
	    events = ['Document', CHILDREN, 'DocumentExit'];
	  } else if (node.type === 'root') {
	    events = ['Root', CHILDREN, 'RootExit'];
	  } else {
	    events = getEvents(node);
	  }

	  return {
	    eventIndex: 0,
	    events,
	    iterator: 0,
	    node,
	    visitorIndex: 0,
	    visitors: []
	  }
	}

	function cleanMarks(node) {
	  node[isClean] = false;
	  if (node.nodes) node.nodes.forEach(i => cleanMarks(i));
	  return node
	}

	let postcss = {};

	class LazyResult {
	  constructor(processor, css, opts) {
	    this.stringified = false;
	    this.processed = false;

	    let root;
	    if (
	      typeof css === 'object' &&
	      css !== null &&
	      (css.type === 'root' || css.type === 'document')
	    ) {
	      root = cleanMarks(css);
	    } else if (css instanceof LazyResult || css instanceof Result) {
	      root = cleanMarks(css.root);
	      if (css.map) {
	        if (typeof opts.map === 'undefined') opts.map = {};
	        if (!opts.map.inline) opts.map.inline = false;
	        opts.map.prev = css.map;
	      }
	    } else {
	      let parser = parse;
	      if (opts.syntax) parser = opts.syntax.parse;
	      if (opts.parser) parser = opts.parser;
	      if (parser.parse) parser = parser.parse;

	      try {
	        root = parser(css, opts);
	      } catch (error) {
	        this.processed = true;
	        this.error = error;
	      }

	      if (root && !root[my]) {
	        /* c8 ignore next 2 */
	        Container.rebuild(root);
	      }
	    }

	    this.result = new Result(processor, root, opts);
	    this.helpers = { ...postcss, postcss, result: this.result };
	    this.plugins = this.processor.plugins.map(plugin => {
	      if (typeof plugin === 'object' && plugin.prepare) {
	        return { ...plugin, ...plugin.prepare(this.result) }
	      } else {
	        return plugin
	      }
	    });
	  }

	  async() {
	    if (this.error) return Promise.reject(this.error)
	    if (this.processed) return Promise.resolve(this.result)
	    if (!this.processing) {
	      this.processing = this.runAsync();
	    }
	    return this.processing
	  }

	  catch(onRejected) {
	    return this.async().catch(onRejected)
	  }

	  finally(onFinally) {
	    return this.async().then(onFinally, onFinally)
	  }

	  getAsyncError() {
	    throw new Error('Use process(css).then(cb) to work with async plugins')
	  }

	  handleError(error, node) {
	    let plugin = this.result.lastPlugin;
	    try {
	      if (node) node.addToError(error);
	      this.error = error;
	      if (error.name === 'CssSyntaxError' && !error.plugin) {
	        error.plugin = plugin.postcssPlugin;
	        error.setMessage();
	      } else if (plugin.postcssVersion) {
	        if (process.env.NODE_ENV !== 'production') {
	          let pluginName = plugin.postcssPlugin;
	          let pluginVer = plugin.postcssVersion;
	          let runtimeVer = this.result.processor.version;
	          let a = pluginVer.split('.');
	          let b = runtimeVer.split('.');

	          if (a[0] !== b[0] || parseInt(a[1]) > parseInt(b[1])) {
	            // eslint-disable-next-line no-console
	            console.error(
	              'Unknown error from PostCSS plugin. Your current PostCSS ' +
	                'version is ' +
	                runtimeVer +
	                ', but ' +
	                pluginName +
	                ' uses ' +
	                pluginVer +
	                '. Perhaps this is the source of the error below.'
	            );
	          }
	        }
	      }
	    } catch (err) {
	      /* c8 ignore next 3 */
	      // eslint-disable-next-line no-console
	      if (console && console.error) console.error(err);
	    }
	    return error
	  }

	  prepareVisitors() {
	    this.listeners = {};
	    let add = (plugin, type, cb) => {
	      if (!this.listeners[type]) this.listeners[type] = [];
	      this.listeners[type].push([plugin, cb]);
	    };
	    for (let plugin of this.plugins) {
	      if (typeof plugin === 'object') {
	        for (let event in plugin) {
	          if (!PLUGIN_PROPS[event] && /^[A-Z]/.test(event)) {
	            throw new Error(
	              `Unknown event ${event} in ${plugin.postcssPlugin}. ` +
	                `Try to update PostCSS (${this.processor.version} now).`
	            )
	          }
	          if (!NOT_VISITORS[event]) {
	            if (typeof plugin[event] === 'object') {
	              for (let filter in plugin[event]) {
	                if (filter === '*') {
	                  add(plugin, event, plugin[event][filter]);
	                } else {
	                  add(
	                    plugin,
	                    event + '-' + filter.toLowerCase(),
	                    plugin[event][filter]
	                  );
	                }
	              }
	            } else if (typeof plugin[event] === 'function') {
	              add(plugin, event, plugin[event]);
	            }
	          }
	        }
	      }
	    }
	    this.hasListener = Object.keys(this.listeners).length > 0;
	  }

	  async runAsync() {
	    this.plugin = 0;
	    for (let i = 0; i < this.plugins.length; i++) {
	      let plugin = this.plugins[i];
	      let promise = this.runOnRoot(plugin);
	      if (isPromise(promise)) {
	        try {
	          await promise;
	        } catch (error) {
	          throw this.handleError(error)
	        }
	      }
	    }

	    this.prepareVisitors();
	    if (this.hasListener) {
	      let root = this.result.root;
	      while (!root[isClean]) {
	        root[isClean] = true;
	        let stack = [toStack(root)];
	        while (stack.length > 0) {
	          let promise = this.visitTick(stack);
	          if (isPromise(promise)) {
	            try {
	              await promise;
	            } catch (e) {
	              let node = stack[stack.length - 1].node;
	              throw this.handleError(e, node)
	            }
	          }
	        }
	      }

	      if (this.listeners.OnceExit) {
	        for (let [plugin, visitor] of this.listeners.OnceExit) {
	          this.result.lastPlugin = plugin;
	          try {
	            if (root.type === 'document') {
	              let roots = root.nodes.map(subRoot =>
	                visitor(subRoot, this.helpers)
	              );

	              await Promise.all(roots);
	            } else {
	              await visitor(root, this.helpers);
	            }
	          } catch (e) {
	            throw this.handleError(e)
	          }
	        }
	      }
	    }

	    this.processed = true;
	    return this.stringify()
	  }

	  runOnRoot(plugin) {
	    this.result.lastPlugin = plugin;
	    try {
	      if (typeof plugin === 'object' && plugin.Once) {
	        if (this.result.root.type === 'document') {
	          let roots = this.result.root.nodes.map(root =>
	            plugin.Once(root, this.helpers)
	          );

	          if (isPromise(roots[0])) {
	            return Promise.all(roots)
	          }

	          return roots
	        }

	        return plugin.Once(this.result.root, this.helpers)
	      } else if (typeof plugin === 'function') {
	        return plugin(this.result.root, this.result)
	      }
	    } catch (error) {
	      throw this.handleError(error)
	    }
	  }

	  stringify() {
	    if (this.error) throw this.error
	    if (this.stringified) return this.result
	    this.stringified = true;

	    this.sync();

	    let opts = this.result.opts;
	    let str = stringify;
	    if (opts.syntax) str = opts.syntax.stringify;
	    if (opts.stringifier) str = opts.stringifier;
	    if (str.stringify) str = str.stringify;

	    let map = new MapGenerator(str, this.result.root, this.result.opts);
	    let data = map.generate();
	    this.result.css = data[0];
	    this.result.map = data[1];

	    return this.result
	  }

	  sync() {
	    if (this.error) throw this.error
	    if (this.processed) return this.result
	    this.processed = true;

	    if (this.processing) {
	      throw this.getAsyncError()
	    }

	    for (let plugin of this.plugins) {
	      let promise = this.runOnRoot(plugin);
	      if (isPromise(promise)) {
	        throw this.getAsyncError()
	      }
	    }

	    this.prepareVisitors();
	    if (this.hasListener) {
	      let root = this.result.root;
	      while (!root[isClean]) {
	        root[isClean] = true;
	        this.walkSync(root);
	      }
	      if (this.listeners.OnceExit) {
	        if (root.type === 'document') {
	          for (let subRoot of root.nodes) {
	            this.visitSync(this.listeners.OnceExit, subRoot);
	          }
	        } else {
	          this.visitSync(this.listeners.OnceExit, root);
	        }
	      }
	    }

	    return this.result
	  }

	  then(onFulfilled, onRejected) {
	    if (process.env.NODE_ENV !== 'production') {
	      if (!('from' in this.opts)) {
	        warnOnce(
	          'Without `from` option PostCSS could generate wrong source map ' +
	            'and will not find Browserslist config. Set it to CSS file path ' +
	            'or to `undefined` to prevent this warning.'
	        );
	      }
	    }
	    return this.async().then(onFulfilled, onRejected)
	  }

	  toString() {
	    return this.css
	  }

	  visitSync(visitors, node) {
	    for (let [plugin, visitor] of visitors) {
	      this.result.lastPlugin = plugin;
	      let promise;
	      try {
	        promise = visitor(node, this.helpers);
	      } catch (e) {
	        throw this.handleError(e, node.proxyOf)
	      }
	      if (node.type !== 'root' && node.type !== 'document' && !node.parent) {
	        return true
	      }
	      if (isPromise(promise)) {
	        throw this.getAsyncError()
	      }
	    }
	  }

	  visitTick(stack) {
	    let visit = stack[stack.length - 1];
	    let { node, visitors } = visit;

	    if (node.type !== 'root' && node.type !== 'document' && !node.parent) {
	      stack.pop();
	      return
	    }

	    if (visitors.length > 0 && visit.visitorIndex < visitors.length) {
	      let [plugin, visitor] = visitors[visit.visitorIndex];
	      visit.visitorIndex += 1;
	      if (visit.visitorIndex === visitors.length) {
	        visit.visitors = [];
	        visit.visitorIndex = 0;
	      }
	      this.result.lastPlugin = plugin;
	      try {
	        return visitor(node.toProxy(), this.helpers)
	      } catch (e) {
	        throw this.handleError(e, node)
	      }
	    }

	    if (visit.iterator !== 0) {
	      let iterator = visit.iterator;
	      let child;
	      while ((child = node.nodes[node.indexes[iterator]])) {
	        node.indexes[iterator] += 1;
	        if (!child[isClean]) {
	          child[isClean] = true;
	          stack.push(toStack(child));
	          return
	        }
	      }
	      visit.iterator = 0;
	      delete node.indexes[iterator];
	    }

	    let events = visit.events;
	    while (visit.eventIndex < events.length) {
	      let event = events[visit.eventIndex];
	      visit.eventIndex += 1;
	      if (event === CHILDREN) {
	        if (node.nodes && node.nodes.length) {
	          node[isClean] = true;
	          visit.iterator = node.getIterator();
	        }
	        return
	      } else if (this.listeners[event]) {
	        visit.visitors = this.listeners[event];
	        return
	      }
	    }
	    stack.pop();
	  }

	  walkSync(node) {
	    node[isClean] = true;
	    let events = getEvents(node);
	    for (let event of events) {
	      if (event === CHILDREN) {
	        if (node.nodes) {
	          node.each(child => {
	            if (!child[isClean]) this.walkSync(child);
	          });
	        }
	      } else {
	        let visitors = this.listeners[event];
	        if (visitors) {
	          if (this.visitSync(visitors, node.toProxy())) return
	        }
	      }
	    }
	  }

	  warnings() {
	    return this.sync().warnings()
	  }

	  get content() {
	    return this.stringify().content
	  }

	  get css() {
	    return this.stringify().css
	  }

	  get map() {
	    return this.stringify().map
	  }

	  get messages() {
	    return this.sync().messages
	  }

	  get opts() {
	    return this.result.opts
	  }

	  get processor() {
	    return this.result.processor
	  }

	  get root() {
	    return this.sync().root
	  }

	  get [Symbol.toStringTag]() {
	    return 'LazyResult'
	  }
	}

	LazyResult.registerPostcss = dependant => {
	  postcss = dependant;
	};

	lazyResult = LazyResult;
	LazyResult.default = LazyResult;

	Root.registerLazyResult(LazyResult);
	Document.registerLazyResult(LazyResult);
	return lazyResult;
}

var noWorkResult;
var hasRequiredNoWorkResult;

function requireNoWorkResult () {
	if (hasRequiredNoWorkResult) return noWorkResult;
	hasRequiredNoWorkResult = 1;

	let MapGenerator = requireMapGenerator();
	let stringify = requireStringify();
	let warnOnce = requireWarnOnce();
	let parse = requireParse();
	const Result = requireResult();

	class NoWorkResult {
	  constructor(processor, css, opts) {
	    css = css.toString();
	    this.stringified = false;

	    this._processor = processor;
	    this._css = css;
	    this._opts = opts;
	    this._map = undefined;
	    let root;

	    let str = stringify;
	    this.result = new Result(this._processor, root, this._opts);
	    this.result.css = css;

	    let self = this;
	    Object.defineProperty(this.result, 'root', {
	      get() {
	        return self.root
	      }
	    });

	    let map = new MapGenerator(str, root, this._opts, css);
	    if (map.isMap()) {
	      let [generatedCSS, generatedMap] = map.generate();
	      if (generatedCSS) {
	        this.result.css = generatedCSS;
	      }
	      if (generatedMap) {
	        this.result.map = generatedMap;
	      }
	    } else {
	      map.clearAnnotation();
	      this.result.css = map.css;
	    }
	  }

	  async() {
	    if (this.error) return Promise.reject(this.error)
	    return Promise.resolve(this.result)
	  }

	  catch(onRejected) {
	    return this.async().catch(onRejected)
	  }

	  finally(onFinally) {
	    return this.async().then(onFinally, onFinally)
	  }

	  sync() {
	    if (this.error) throw this.error
	    return this.result
	  }

	  then(onFulfilled, onRejected) {
	    if (process.env.NODE_ENV !== 'production') {
	      if (!('from' in this._opts)) {
	        warnOnce(
	          'Without `from` option PostCSS could generate wrong source map ' +
	            'and will not find Browserslist config. Set it to CSS file path ' +
	            'or to `undefined` to prevent this warning.'
	        );
	      }
	    }

	    return this.async().then(onFulfilled, onRejected)
	  }

	  toString() {
	    return this._css
	  }

	  warnings() {
	    return []
	  }

	  get content() {
	    return this.result.css
	  }

	  get css() {
	    return this.result.css
	  }

	  get map() {
	    return this.result.map
	  }

	  get messages() {
	    return []
	  }

	  get opts() {
	    return this.result.opts
	  }

	  get processor() {
	    return this.result.processor
	  }

	  get root() {
	    if (this._root) {
	      return this._root
	    }

	    let root;
	    let parser = parse;

	    try {
	      root = parser(this._css, this._opts);
	    } catch (error) {
	      this.error = error;
	    }

	    if (this.error) {
	      throw this.error
	    } else {
	      this._root = root;
	      return root
	    }
	  }

	  get [Symbol.toStringTag]() {
	    return 'NoWorkResult'
	  }
	}

	noWorkResult = NoWorkResult;
	NoWorkResult.default = NoWorkResult;
	return noWorkResult;
}

var processor;
var hasRequiredProcessor;

function requireProcessor () {
	if (hasRequiredProcessor) return processor;
	hasRequiredProcessor = 1;

	let NoWorkResult = requireNoWorkResult();
	let LazyResult = requireLazyResult();
	let Document = requireDocument();
	let Root = requireRoot();

	class Processor {
	  constructor(plugins = []) {
	    this.version = '8.4.38';
	    this.plugins = this.normalize(plugins);
	  }

	  normalize(plugins) {
	    let normalized = [];
	    for (let i of plugins) {
	      if (i.postcss === true) {
	        i = i();
	      } else if (i.postcss) {
	        i = i.postcss;
	      }

	      if (typeof i === 'object' && Array.isArray(i.plugins)) {
	        normalized = normalized.concat(i.plugins);
	      } else if (typeof i === 'object' && i.postcssPlugin) {
	        normalized.push(i);
	      } else if (typeof i === 'function') {
	        normalized.push(i);
	      } else if (typeof i === 'object' && (i.parse || i.stringify)) {
	        if (process.env.NODE_ENV !== 'production') {
	          throw new Error(
	            'PostCSS syntaxes cannot be used as plugins. Instead, please use ' +
	              'one of the syntax/parser/stringifier options as outlined ' +
	              'in your PostCSS runner documentation.'
	          )
	        }
	      } else {
	        throw new Error(i + ' is not a PostCSS plugin')
	      }
	    }
	    return normalized
	  }

	  process(css, opts = {}) {
	    if (
	      !this.plugins.length &&
	      !opts.parser &&
	      !opts.stringifier &&
	      !opts.syntax
	    ) {
	      return new NoWorkResult(this, css, opts)
	    } else {
	      return new LazyResult(this, css, opts)
	    }
	  }

	  use(plugin) {
	    this.plugins = this.plugins.concat(this.normalize([plugin]));
	    return this
	  }
	}

	processor = Processor;
	Processor.default = Processor;

	Root.registerProcessor(Processor);
	Document.registerProcessor(Processor);
	return processor;
}

var fromJSON_1;
var hasRequiredFromJSON;

function requireFromJSON () {
	if (hasRequiredFromJSON) return fromJSON_1;
	hasRequiredFromJSON = 1;

	let Declaration = requireDeclaration();
	let PreviousMap = requirePreviousMap();
	let Comment = requireComment();
	let AtRule = requireAtRule();
	let Input = requireInput();
	let Root = requireRoot();
	let Rule = requireRule();

	function fromJSON(json, inputs) {
	  if (Array.isArray(json)) return json.map(n => fromJSON(n))

	  let { inputs: ownInputs, ...defaults } = json;
	  if (ownInputs) {
	    inputs = [];
	    for (let input of ownInputs) {
	      let inputHydrated = { ...input, __proto__: Input.prototype };
	      if (inputHydrated.map) {
	        inputHydrated.map = {
	          ...inputHydrated.map,
	          __proto__: PreviousMap.prototype
	        };
	      }
	      inputs.push(inputHydrated);
	    }
	  }
	  if (defaults.nodes) {
	    defaults.nodes = json.nodes.map(n => fromJSON(n, inputs));
	  }
	  if (defaults.source) {
	    let { inputId, ...source } = defaults.source;
	    defaults.source = source;
	    if (inputId != null) {
	      defaults.source.input = inputs[inputId];
	    }
	  }
	  if (defaults.type === 'root') {
	    return new Root(defaults)
	  } else if (defaults.type === 'decl') {
	    return new Declaration(defaults)
	  } else if (defaults.type === 'rule') {
	    return new Rule(defaults)
	  } else if (defaults.type === 'comment') {
	    return new Comment(defaults)
	  } else if (defaults.type === 'atrule') {
	    return new AtRule(defaults)
	  } else {
	    throw new Error('Unknown node type: ' + json.type)
	  }
	}

	fromJSON_1 = fromJSON;
	fromJSON.default = fromJSON;
	return fromJSON_1;
}

var postcss_1;
var hasRequiredPostcss;

function requirePostcss () {
	if (hasRequiredPostcss) return postcss_1;
	hasRequiredPostcss = 1;

	let CssSyntaxError = requireCssSyntaxError();
	let Declaration = requireDeclaration();
	let LazyResult = requireLazyResult();
	let Container = requireContainer();
	let Processor = requireProcessor();
	let stringify = requireStringify();
	let fromJSON = requireFromJSON();
	let Document = requireDocument();
	let Warning = requireWarning();
	let Comment = requireComment();
	let AtRule = requireAtRule();
	let Result = requireResult();
	let Input = requireInput();
	let parse = requireParse();
	let list = requireList();
	let Rule = requireRule();
	let Root = requireRoot();
	let Node = requireNode();

	function postcss(...plugins) {
	  if (plugins.length === 1 && Array.isArray(plugins[0])) {
	    plugins = plugins[0];
	  }
	  return new Processor(plugins)
	}

	postcss.plugin = function plugin(name, initializer) {
	  let warningPrinted = false;
	  function creator(...args) {
	    // eslint-disable-next-line no-console
	    if (console && console.warn && !warningPrinted) {
	      warningPrinted = true;
	      // eslint-disable-next-line no-console
	      console.warn(
	        name +
	          ': postcss.plugin was deprecated. Migration guide:\n' +
	          'https://evilmartians.com/chronicles/postcss-8-plugin-migration'
	      );
	      if (process.env.LANG && process.env.LANG.startsWith('cn')) {
	        /* c8 ignore next 7 */
	        // eslint-disable-next-line no-console
	        console.warn(
	          name +
	            ': 里面 postcss.plugin 被弃用. 迁移指南:\n' +
	            'https://www.w3ctech.com/topic/2226'
	        );
	      }
	    }
	    let transformer = initializer(...args);
	    transformer.postcssPlugin = name;
	    transformer.postcssVersion = new Processor().version;
	    return transformer
	  }

	  let cache;
	  Object.defineProperty(creator, 'postcss', {
	    get() {
	      if (!cache) cache = creator();
	      return cache
	    }
	  });

	  creator.process = function (css, processOpts, pluginOpts) {
	    return postcss([creator(pluginOpts)]).process(css, processOpts)
	  };

	  return creator
	};

	postcss.stringify = stringify;
	postcss.parse = parse;
	postcss.fromJSON = fromJSON;
	postcss.list = list;

	postcss.comment = defaults => new Comment(defaults);
	postcss.atRule = defaults => new AtRule(defaults);
	postcss.decl = defaults => new Declaration(defaults);
	postcss.rule = defaults => new Rule(defaults);
	postcss.root = defaults => new Root(defaults);
	postcss.document = defaults => new Document(defaults);

	postcss.CssSyntaxError = CssSyntaxError;
	postcss.Declaration = Declaration;
	postcss.Container = Container;
	postcss.Processor = Processor;
	postcss.Document = Document;
	postcss.Comment = Comment;
	postcss.Warning = Warning;
	postcss.AtRule = AtRule;
	postcss.Result = Result;
	postcss.Input = Input;
	postcss.Rule = Rule;
	postcss.Root = Root;
	postcss.Node = Node;

	LazyResult.registerPostcss(postcss);

	postcss_1 = postcss;
	postcss.default = postcss;
	return postcss_1;
}

var postcssExports = requirePostcss();
var postcss = /*@__PURE__*/getDefaultExportFromCjs$1(postcssExports);

postcss.stringify;
postcss.fromJSON;
postcss.plugin;
postcss.parse;
postcss.list;

postcss.document;
postcss.comment;
postcss.atRule;
postcss.rule;
postcss.decl;
postcss.root;

postcss.CssSyntaxError;
postcss.Declaration;
postcss.Container;
postcss.Processor;
postcss.Document;
postcss.Comment;
postcss.Warning;
postcss.AtRule;
postcss.Result;
postcss.Input;
postcss.Rule;
postcss.Root;
postcss.Node;

var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
function getAugmentedNamespace(n) {
  if (n.__esModule)
    return n;
  var f = n.default;
  if (typeof f == "function") {
    var a = function a2() {
      if (this instanceof a2) {
        return Reflect.construct(f, arguments, this.constructor);
      }
      return f.apply(this, arguments);
    };
    a.prototype = f.prototype;
  } else
    a = {};
  Object.defineProperty(a, "__esModule", { value: true });
  Object.keys(n).forEach(function(k) {
    var d = Object.getOwnPropertyDescriptor(n, k);
    Object.defineProperty(a, k, d.get ? d : {
      enumerable: true,
      get: function() {
        return n[k];
      }
    });
  });
  return a;
}
const space_logo = "data:image/svg+xml,%3csvg%20xmlns='http://www.w3.org/2000/svg'%20width='10'%20height='10'%20fill='none'%3e%3cpath%20fill='%23FF3270'%20d='M1.93%206.03v2.04h2.04V6.03H1.93Z'/%3e%3cpath%20fill='%23861FFF'%20d='M6.03%206.03v2.04h2.04V6.03H6.03Z'/%3e%3cpath%20fill='%23097EFF'%20d='M1.93%201.93v2.04h2.04V1.93H1.93Z'/%3e%3cpath%20fill='%23000'%20fill-rule='evenodd'%20d='M.5%201.4c0-.5.4-.9.9-.9h3.1a.9.9%200%200%201%20.87.67A2.44%202.44%200%200%201%209.5%202.95c0%20.65-.25%201.24-.67%201.68.39.1.67.46.67.88v3.08c0%20.5-.4.91-.9.91H1.4a.9.9%200%200%201-.9-.9V1.4Zm1.43.53v2.04h2.04V1.93H1.93Zm0%206.14V6.03h2.04v2.04H1.93Zm4.1%200V6.03h2.04v2.04H6.03Zm0-5.12a1.02%201.02%200%201%201%202.04%200%201.02%201.02%200%200%201-2.04%200Z'%20clip-rule='evenodd'/%3e%3cpath%20fill='%23FFD702'%20d='M7.05%201.93a1.02%201.02%200%201%200%200%202.04%201.02%201.02%200%200%200%200-2.04Z'/%3e%3c/svg%3e";
var isMergeableObject = function isMergeableObject2(value) {
  return isNonNullObject(value) && !isSpecial(value);
};
function isNonNullObject(value) {
  return !!value && typeof value === "object";
}
function isSpecial(value) {
  var stringValue = Object.prototype.toString.call(value);
  return stringValue === "[object RegExp]" || stringValue === "[object Date]" || isReactElement(value);
}
var canUseSymbol = typeof Symbol === "function" && Symbol.for;
var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for("react.element") : 60103;
function isReactElement(value) {
  return value.$$typeof === REACT_ELEMENT_TYPE;
}
function emptyTarget(val) {
  return Array.isArray(val) ? [] : {};
}
function cloneUnlessOtherwiseSpecified(value, options2) {
  return options2.clone !== false && options2.isMergeableObject(value) ? deepmerge$1(emptyTarget(value), value, options2) : value;
}
function defaultArrayMerge(target, source, options2) {
  return target.concat(source).map(function(element) {
    return cloneUnlessOtherwiseSpecified(element, options2);
  });
}
function getMergeFunction(key, options2) {
  if (!options2.customMerge) {
    return deepmerge$1;
  }
  var customMerge = options2.customMerge(key);
  return typeof customMerge === "function" ? customMerge : deepmerge$1;
}
function getEnumerableOwnPropertySymbols(target) {
  return Object.getOwnPropertySymbols ? Object.getOwnPropertySymbols(target).filter(function(symbol) {
    return Object.propertyIsEnumerable.call(target, symbol);
  }) : [];
}
function getKeys(target) {
  return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target));
}
function propertyIsOnObject(object, property) {
  try {
    return property in object;
  } catch (_) {
    return false;
  }
}
function propertyIsUnsafe(target, key) {
  return propertyIsOnObject(target, key) && !(Object.hasOwnProperty.call(target, key) && Object.propertyIsEnumerable.call(target, key));
}
function mergeObject(target, source, options2) {
  var destination = {};
  if (options2.isMergeableObject(target)) {
    getKeys(target).forEach(function(key) {
      destination[key] = cloneUnlessOtherwiseSpecified(target[key], options2);
    });
  }
  getKeys(source).forEach(function(key) {
    if (propertyIsUnsafe(target, key)) {
      return;
    }
    if (propertyIsOnObject(target, key) && options2.isMergeableObject(source[key])) {
      destination[key] = getMergeFunction(key, options2)(target[key], source[key], options2);
    } else {
      destination[key] = cloneUnlessOtherwiseSpecified(source[key], options2);
    }
  });
  return destination;
}
function deepmerge$1(target, source, options2) {
  options2 = options2 || {};
  options2.arrayMerge = options2.arrayMerge || defaultArrayMerge;
  options2.isMergeableObject = options2.isMergeableObject || isMergeableObject;
  options2.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;
  var sourceIsArray = Array.isArray(source);
  var targetIsArray = Array.isArray(target);
  var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;
  if (!sourceAndTargetTypesMatch) {
    return cloneUnlessOtherwiseSpecified(source, options2);
  } else if (sourceIsArray) {
    return options2.arrayMerge(target, source, options2);
  } else {
    return mergeObject(target, source, options2);
  }
}
deepmerge$1.all = function deepmergeAll(array, options2) {
  if (!Array.isArray(array)) {
    throw new Error("first argument should be an array");
  }
  return array.reduce(function(prev, next) {
    return deepmerge$1(prev, next, options2);
  }, {});
};
var deepmerge_1 = deepmerge$1;
var cjs = deepmerge_1;
const deepmerge$2 = /* @__PURE__ */ getDefaultExportFromCjs(cjs);
var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
    d2.__proto__ = b2;
  } || function(d2, b2) {
    for (var p in b2)
      if (Object.prototype.hasOwnProperty.call(b2, p))
        d2[p] = b2[p];
  };
  return extendStatics(d, b);
};
function __extends$1(d, b) {
  if (typeof b !== "function" && b !== null)
    throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
var __assign$2 = function() {
  __assign$2 = Object.assign || function __assign2(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];
      for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p))
          t[p] = s[p];
    }
    return t;
  };
  return __assign$2.apply(this, arguments);
};
function __rest(s, e) {
  var t = {};
  for (var p in s)
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
        t[p[i]] = s[p[i]];
    }
  return t;
}
function __spreadArray(to, from, pack) {
  if (arguments.length === 2)
    for (var i = 0, l = from.length, ar2; i < l; i++) {
      if (ar2 || !(i in from)) {
        if (!ar2)
          ar2 = Array.prototype.slice.call(from, 0, i);
        ar2[i] = from[i];
      }
    }
  return to.concat(ar2 || Array.prototype.slice.call(from));
}
typeof SuppressedError === "function" ? SuppressedError : function(error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};
var ErrorKind;
(function(ErrorKind2) {
  ErrorKind2[ErrorKind2["EXPECT_ARGUMENT_CLOSING_BRACE"] = 1] = "EXPECT_ARGUMENT_CLOSING_BRACE";
  ErrorKind2[ErrorKind2["EMPTY_ARGUMENT"] = 2] = "EMPTY_ARGUMENT";
  ErrorKind2[ErrorKind2["MALFORMED_ARGUMENT"] = 3] = "MALFORMED_ARGUMENT";
  ErrorKind2[ErrorKind2["EXPECT_ARGUMENT_TYPE"] = 4] = "EXPECT_ARGUMENT_TYPE";
  ErrorKind2[ErrorKind2["INVALID_ARGUMENT_TYPE"] = 5] = "INVALID_ARGUMENT_TYPE";
  ErrorKind2[ErrorKind2["EXPECT_ARGUMENT_STYLE"] = 6] = "EXPECT_ARGUMENT_STYLE";
  ErrorKind2[ErrorKind2["INVALID_NUMBER_SKELETON"] = 7] = "INVALID_NUMBER_SKELETON";
  ErrorKind2[ErrorKind2["INVALID_DATE_TIME_SKELETON"] = 8] = "INVALID_DATE_TIME_SKELETON";
  ErrorKind2[ErrorKind2["EXPECT_NUMBER_SKELETON"] = 9] = "EXPECT_NUMBER_SKELETON";
  ErrorKind2[ErrorKind2["EXPECT_DATE_TIME_SKELETON"] = 10] = "EXPECT_DATE_TIME_SKELETON";
  ErrorKind2[ErrorKind2["UNCLOSED_QUOTE_IN_ARGUMENT_STYLE"] = 11] = "UNCLOSED_QUOTE_IN_ARGUMENT_STYLE";
  ErrorKind2[ErrorKind2["EXPECT_SELECT_ARGUMENT_OPTIONS"] = 12] = "EXPECT_SELECT_ARGUMENT_OPTIONS";
  ErrorKind2[ErrorKind2["EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE"] = 13] = "EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE";
  ErrorKind2[ErrorKind2["INVALID_PLURAL_ARGUMENT_OFFSET_VALUE"] = 14] = "INVALID_PLURAL_ARGUMENT_OFFSET_VALUE";
  ErrorKind2[ErrorKind2["EXPECT_SELECT_ARGUMENT_SELECTOR"] = 15] = "EXPECT_SELECT_ARGUMENT_SELECTOR";
  ErrorKind2[ErrorKind2["EXPECT_PLURAL_ARGUMENT_SELECTOR"] = 16] = "EXPECT_PLURAL_ARGUMENT_SELECTOR";
  ErrorKind2[ErrorKind2["EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT"] = 17] = "EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT";
  ErrorKind2[ErrorKind2["EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT"] = 18] = "EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT";
  ErrorKind2[ErrorKind2["INVALID_PLURAL_ARGUMENT_SELECTOR"] = 19] = "INVALID_PLURAL_ARGUMENT_SELECTOR";
  ErrorKind2[ErrorKind2["DUPLICATE_PLURAL_ARGUMENT_SELECTOR"] = 20] = "DUPLICATE_PLURAL_ARGUMENT_SELECTOR";
  ErrorKind2[ErrorKind2["DUPLICATE_SELECT_ARGUMENT_SELECTOR"] = 21] = "DUPLICATE_SELECT_ARGUMENT_SELECTOR";
  ErrorKind2[ErrorKind2["MISSING_OTHER_CLAUSE"] = 22] = "MISSING_OTHER_CLAUSE";
  ErrorKind2[ErrorKind2["INVALID_TAG"] = 23] = "INVALID_TAG";
  ErrorKind2[ErrorKind2["INVALID_TAG_NAME"] = 25] = "INVALID_TAG_NAME";
  ErrorKind2[ErrorKind2["UNMATCHED_CLOSING_TAG"] = 26] = "UNMATCHED_CLOSING_TAG";
  ErrorKind2[ErrorKind2["UNCLOSED_TAG"] = 27] = "UNCLOSED_TAG";
})(ErrorKind || (ErrorKind = {}));
var TYPE;
(function(TYPE2) {
  TYPE2[TYPE2["literal"] = 0] = "literal";
  TYPE2[TYPE2["argument"] = 1] = "argument";
  TYPE2[TYPE2["number"] = 2] = "number";
  TYPE2[TYPE2["date"] = 3] = "date";
  TYPE2[TYPE2["time"] = 4] = "time";
  TYPE2[TYPE2["select"] = 5] = "select";
  TYPE2[TYPE2["plural"] = 6] = "plural";
  TYPE2[TYPE2["pound"] = 7] = "pound";
  TYPE2[TYPE2["tag"] = 8] = "tag";
})(TYPE || (TYPE = {}));
var SKELETON_TYPE;
(function(SKELETON_TYPE2) {
  SKELETON_TYPE2[SKELETON_TYPE2["number"] = 0] = "number";
  SKELETON_TYPE2[SKELETON_TYPE2["dateTime"] = 1] = "dateTime";
})(SKELETON_TYPE || (SKELETON_TYPE = {}));
function isLiteralElement(el) {
  return el.type === TYPE.literal;
}
function isArgumentElement(el) {
  return el.type === TYPE.argument;
}
function isNumberElement(el) {
  return el.type === TYPE.number;
}
function isDateElement(el) {
  return el.type === TYPE.date;
}
function isTimeElement(el) {
  return el.type === TYPE.time;
}
function isSelectElement(el) {
  return el.type === TYPE.select;
}
function isPluralElement(el) {
  return el.type === TYPE.plural;
}
function isPoundElement(el) {
  return el.type === TYPE.pound;
}
function isTagElement(el) {
  return el.type === TYPE.tag;
}
function isNumberSkeleton(el) {
  return !!(el && typeof el === "object" && el.type === SKELETON_TYPE.number);
}
function isDateTimeSkeleton(el) {
  return !!(el && typeof el === "object" && el.type === SKELETON_TYPE.dateTime);
}
var SPACE_SEPARATOR_REGEX = /[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/;
var DATE_TIME_REGEX = /(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g;
function parseDateTimeSkeleton(skeleton) {
  var result = {};
  skeleton.replace(DATE_TIME_REGEX, function(match) {
    var len = match.length;
    switch (match[0]) {
      case "G":
        result.era = len === 4 ? "long" : len === 5 ? "narrow" : "short";
        break;
      case "y":
        result.year = len === 2 ? "2-digit" : "numeric";
        break;
      case "Y":
      case "u":
      case "U":
      case "r":
        throw new RangeError("`Y/u/U/r` (year) patterns are not supported, use `y` instead");
      case "q":
      case "Q":
        throw new RangeError("`q/Q` (quarter) patterns are not supported");
      case "M":
      case "L":
        result.month = ["numeric", "2-digit", "short", "long", "narrow"][len - 1];
        break;
      case "w":
      case "W":
        throw new RangeError("`w/W` (week) patterns are not supported");
      case "d":
        result.day = ["numeric", "2-digit"][len - 1];
        break;
      case "D":
      case "F":
      case "g":
        throw new RangeError("`D/F/g` (day) patterns are not supported, use `d` instead");
      case "E":
        result.weekday = len === 4 ? "long" : len === 5 ? "narrow" : "short";
        break;
      case "e":
        if (len < 4) {
          throw new RangeError("`e..eee` (weekday) patterns are not supported");
        }
        result.weekday = ["short", "long", "narrow", "short"][len - 4];
        break;
      case "c":
        if (len < 4) {
          throw new RangeError("`c..ccc` (weekday) patterns are not supported");
        }
        result.weekday = ["short", "long", "narrow", "short"][len - 4];
        break;
      case "a":
        result.hour12 = true;
        break;
      case "b":
      case "B":
        throw new RangeError("`b/B` (period) patterns are not supported, use `a` instead");
      case "h":
        result.hourCycle = "h12";
        result.hour = ["numeric", "2-digit"][len - 1];
        break;
      case "H":
        result.hourCycle = "h23";
        result.hour = ["numeric", "2-digit"][len - 1];
        break;
      case "K":
        result.hourCycle = "h11";
        result.hour = ["numeric", "2-digit"][len - 1];
        break;
      case "k":
        result.hourCycle = "h24";
        result.hour = ["numeric", "2-digit"][len - 1];
        break;
      case "j":
      case "J":
      case "C":
        throw new RangeError("`j/J/C` (hour) patterns are not supported, use `h/H/K/k` instead");
      case "m":
        result.minute = ["numeric", "2-digit"][len - 1];
        break;
      case "s":
        result.second = ["numeric", "2-digit"][len - 1];
        break;
      case "S":
      case "A":
        throw new RangeError("`S/A` (second) patterns are not supported, use `s` instead");
      case "z":
        result.timeZoneName = len < 4 ? "short" : "long";
        break;
      case "Z":
      case "O":
      case "v":
      case "V":
      case "X":
      case "x":
        throw new RangeError("`Z/O/v/V/X/x` (timeZone) patterns are not supported, use `z` instead");
    }
    return "";
  });
  return result;
}
var WHITE_SPACE_REGEX = /[\t-\r \x85\u200E\u200F\u2028\u2029]/i;
function parseNumberSkeletonFromString(skeleton) {
  if (skeleton.length === 0) {
    throw new Error("Number skeleton cannot be empty");
  }
  var stringTokens = skeleton.split(WHITE_SPACE_REGEX).filter(function(x) {
    return x.length > 0;
  });
  var tokens = [];
  for (var _i = 0, stringTokens_1 = stringTokens; _i < stringTokens_1.length; _i++) {
    var stringToken = stringTokens_1[_i];
    var stemAndOptions = stringToken.split("/");
    if (stemAndOptions.length === 0) {
      throw new Error("Invalid number skeleton");
    }
    var stem = stemAndOptions[0], options2 = stemAndOptions.slice(1);
    for (var _a2 = 0, options_1 = options2; _a2 < options_1.length; _a2++) {
      var option = options_1[_a2];
      if (option.length === 0) {
        throw new Error("Invalid number skeleton");
      }
    }
    tokens.push({ stem, options: options2 });
  }
  return tokens;
}
function icuUnitToEcma(unit) {
  return unit.replace(/^(.*?)-/, "");
}
var FRACTION_PRECISION_REGEX = /^\.(?:(0+)(\*)?|(#+)|(0+)(#+))$/g;
var SIGNIFICANT_PRECISION_REGEX = /^(@+)?(\+|#+)?[rs]?$/g;
var INTEGER_WIDTH_REGEX = /(\*)(0+)|(#+)(0+)|(0+)/g;
var CONCISE_INTEGER_WIDTH_REGEX = /^(0+)$/;
function parseSignificantPrecision(str) {
  var result = {};
  if (str[str.length - 1] === "r") {
    result.roundingPriority = "morePrecision";
  } else if (str[str.length - 1] === "s") {
    result.roundingPriority = "lessPrecision";
  }
  str.replace(SIGNIFICANT_PRECISION_REGEX, function(_, g1, g2) {
    if (typeof g2 !== "string") {
      result.minimumSignificantDigits = g1.length;
      result.maximumSignificantDigits = g1.length;
    } else if (g2 === "+") {
      result.minimumSignificantDigits = g1.length;
    } else if (g1[0] === "#") {
      result.maximumSignificantDigits = g1.length;
    } else {
      result.minimumSignificantDigits = g1.length;
      result.maximumSignificantDigits = g1.length + (typeof g2 === "string" ? g2.length : 0);
    }
    return "";
  });
  return result;
}
function parseSign(str) {
  switch (str) {
    case "sign-auto":
      return {
        signDisplay: "auto"
      };
    case "sign-accounting":
    case "()":
      return {
        currencySign: "accounting"
      };
    case "sign-always":
    case "+!":
      return {
        signDisplay: "always"
      };
    case "sign-accounting-always":
    case "()!":
      return {
        signDisplay: "always",
        currencySign: "accounting"
      };
    case "sign-except-zero":
    case "+?":
      return {
        signDisplay: "exceptZero"
      };
    case "sign-accounting-except-zero":
    case "()?":
      return {
        signDisplay: "exceptZero",
        currencySign: "accounting"
      };
    case "sign-never":
    case "+_":
      return {
        signDisplay: "never"
      };
  }
}
function parseConciseScientificAndEngineeringStem(stem) {
  var result;
  if (stem[0] === "E" && stem[1] === "E") {
    result = {
      notation: "engineering"
    };
    stem = stem.slice(2);
  } else if (stem[0] === "E") {
    result = {
      notation: "scientific"
    };
    stem = stem.slice(1);
  }
  if (result) {
    var signDisplay = stem.slice(0, 2);
    if (signDisplay === "+!") {
      result.signDisplay = "always";
      stem = stem.slice(2);
    } else if (signDisplay === "+?") {
      result.signDisplay = "exceptZero";
      stem = stem.slice(2);
    }
    if (!CONCISE_INTEGER_WIDTH_REGEX.test(stem)) {
      throw new Error("Malformed concise eng/scientific notation");
    }
    result.minimumIntegerDigits = stem.length;
  }
  return result;
}
function parseNotationOptions(opt) {
  var result = {};
  var signOpts = parseSign(opt);
  if (signOpts) {
    return signOpts;
  }
  return result;
}
function parseNumberSkeleton(tokens) {
  var result = {};
  for (var _i = 0, tokens_1 = tokens; _i < tokens_1.length; _i++) {
    var token = tokens_1[_i];
    switch (token.stem) {
      case "percent":
      case "%":
        result.style = "percent";
        continue;
      case "%x100":
        result.style = "percent";
        result.scale = 100;
        continue;
      case "currency":
        result.style = "currency";
        result.currency = token.options[0];
        continue;
      case "group-off":
      case ",_":
        result.useGrouping = false;
        continue;
      case "precision-integer":
      case ".":
        result.maximumFractionDigits = 0;
        continue;
      case "measure-unit":
      case "unit":
        result.style = "unit";
        result.unit = icuUnitToEcma(token.options[0]);
        continue;
      case "compact-short":
      case "K":
        result.notation = "compact";
        result.compactDisplay = "short";
        continue;
      case "compact-long":
      case "KK":
        result.notation = "compact";
        result.compactDisplay = "long";
        continue;
      case "scientific":
        result = __assign$2(__assign$2(__assign$2({}, result), { notation: "scientific" }), token.options.reduce(function(all, opt2) {
          return __assign$2(__assign$2({}, all), parseNotationOptions(opt2));
        }, {}));
        continue;
      case "engineering":
        result = __assign$2(__assign$2(__assign$2({}, result), { notation: "engineering" }), token.options.reduce(function(all, opt2) {
          return __assign$2(__assign$2({}, all), parseNotationOptions(opt2));
        }, {}));
        continue;
      case "notation-simple":
        result.notation = "standard";
        continue;
      case "unit-width-narrow":
        result.currencyDisplay = "narrowSymbol";
        result.unitDisplay = "narrow";
        continue;
      case "unit-width-short":
        result.currencyDisplay = "code";
        result.unitDisplay = "short";
        continue;
      case "unit-width-full-name":
        result.currencyDisplay = "name";
        result.unitDisplay = "long";
        continue;
      case "unit-width-iso-code":
        result.currencyDisplay = "symbol";
        continue;
      case "scale":
        result.scale = parseFloat(token.options[0]);
        continue;
      case "rounding-mode-floor":
        result.roundingMode = "floor";
        continue;
      case "rounding-mode-ceiling":
        result.roundingMode = "ceil";
        continue;
      case "rounding-mode-down":
        result.roundingMode = "trunc";
        continue;
      case "rounding-mode-up":
        result.roundingMode = "expand";
        continue;
      case "rounding-mode-half-even":
        result.roundingMode = "halfEven";
        continue;
      case "rounding-mode-half-down":
        result.roundingMode = "halfTrunc";
        continue;
      case "rounding-mode-half-up":
        result.roundingMode = "halfExpand";
        continue;
      case "integer-width":
        if (token.options.length > 1) {
          throw new RangeError("integer-width stems only accept a single optional option");
        }
        token.options[0].replace(INTEGER_WIDTH_REGEX, function(_, g1, g2, g3, g4, g5) {
          if (g1) {
            result.minimumIntegerDigits = g2.length;
          } else if (g3 && g4) {
            throw new Error("We currently do not support maximum integer digits");
          } else if (g5) {
            throw new Error("We currently do not support exact integer digits");
          }
          return "";
        });
        continue;
    }
    if (CONCISE_INTEGER_WIDTH_REGEX.test(token.stem)) {
      result.minimumIntegerDigits = token.stem.length;
      continue;
    }
    if (FRACTION_PRECISION_REGEX.test(token.stem)) {
      if (token.options.length > 1) {
        throw new RangeError("Fraction-precision stems only accept a single optional option");
      }
      token.stem.replace(FRACTION_PRECISION_REGEX, function(_, g1, g2, g3, g4, g5) {
        if (g2 === "*") {
          result.minimumFractionDigits = g1.length;
        } else if (g3 && g3[0] === "#") {
          result.maximumFractionDigits = g3.length;
        } else if (g4 && g5) {
          result.minimumFractionDigits = g4.length;
          result.maximumFractionDigits = g4.length + g5.length;
        } else {
          result.minimumFractionDigits = g1.length;
          result.maximumFractionDigits = g1.length;
        }
        return "";
      });
      var opt = token.options[0];
      if (opt === "w") {
        result = __assign$2(__assign$2({}, result), { trailingZeroDisplay: "stripIfInteger" });
      } else if (opt) {
        result = __assign$2(__assign$2({}, result), parseSignificantPrecision(opt));
      }
      continue;
    }
    if (SIGNIFICANT_PRECISION_REGEX.test(token.stem)) {
      result = __assign$2(__assign$2({}, result), parseSignificantPrecision(token.stem));
      continue;
    }
    var signOpts = parseSign(token.stem);
    if (signOpts) {
      result = __assign$2(__assign$2({}, result), signOpts);
    }
    var conciseScientificAndEngineeringOpts = parseConciseScientificAndEngineeringStem(token.stem);
    if (conciseScientificAndEngineeringOpts) {
      result = __assign$2(__assign$2({}, result), conciseScientificAndEngineeringOpts);
    }
  }
  return result;
}
var timeData = {
  "001": [
    "H",
    "h"
  ],
  "AC": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "AD": [
    "H",
    "hB"
  ],
  "AE": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "AF": [
    "H",
    "hb",
    "hB",
    "h"
  ],
  "AG": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "AI": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "AL": [
    "h",
    "H",
    "hB"
  ],
  "AM": [
    "H",
    "hB"
  ],
  "AO": [
    "H",
    "hB"
  ],
  "AR": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "AS": [
    "h",
    "H"
  ],
  "AT": [
    "H",
    "hB"
  ],
  "AU": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "AW": [
    "H",
    "hB"
  ],
  "AX": [
    "H"
  ],
  "AZ": [
    "H",
    "hB",
    "h"
  ],
  "BA": [
    "H",
    "hB",
    "h"
  ],
  "BB": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "BD": [
    "h",
    "hB",
    "H"
  ],
  "BE": [
    "H",
    "hB"
  ],
  "BF": [
    "H",
    "hB"
  ],
  "BG": [
    "H",
    "hB",
    "h"
  ],
  "BH": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "BI": [
    "H",
    "h"
  ],
  "BJ": [
    "H",
    "hB"
  ],
  "BL": [
    "H",
    "hB"
  ],
  "BM": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "BN": [
    "hb",
    "hB",
    "h",
    "H"
  ],
  "BO": [
    "H",
    "hB",
    "h",
    "hb"
  ],
  "BQ": [
    "H"
  ],
  "BR": [
    "H",
    "hB"
  ],
  "BS": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "BT": [
    "h",
    "H"
  ],
  "BW": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "BY": [
    "H",
    "h"
  ],
  "BZ": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "CA": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "CC": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "CD": [
    "hB",
    "H"
  ],
  "CF": [
    "H",
    "h",
    "hB"
  ],
  "CG": [
    "H",
    "hB"
  ],
  "CH": [
    "H",
    "hB",
    "h"
  ],
  "CI": [
    "H",
    "hB"
  ],
  "CK": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "CL": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "CM": [
    "H",
    "h",
    "hB"
  ],
  "CN": [
    "H",
    "hB",
    "hb",
    "h"
  ],
  "CO": [
    "h",
    "H",
    "hB",
    "hb"
  ],
  "CP": [
    "H"
  ],
  "CR": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "CU": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "CV": [
    "H",
    "hB"
  ],
  "CW": [
    "H",
    "hB"
  ],
  "CX": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "CY": [
    "h",
    "H",
    "hb",
    "hB"
  ],
  "CZ": [
    "H"
  ],
  "DE": [
    "H",
    "hB"
  ],
  "DG": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "DJ": [
    "h",
    "H"
  ],
  "DK": [
    "H"
  ],
  "DM": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "DO": [
    "h",
    "H",
    "hB",
    "hb"
  ],
  "DZ": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "EA": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "EC": [
    "H",
    "hB",
    "h",
    "hb"
  ],
  "EE": [
    "H",
    "hB"
  ],
  "EG": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "EH": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "ER": [
    "h",
    "H"
  ],
  "ES": [
    "H",
    "hB",
    "h",
    "hb"
  ],
  "ET": [
    "hB",
    "hb",
    "h",
    "H"
  ],
  "FI": [
    "H"
  ],
  "FJ": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "FK": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "FM": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "FO": [
    "H",
    "h"
  ],
  "FR": [
    "H",
    "hB"
  ],
  "GA": [
    "H",
    "hB"
  ],
  "GB": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "GD": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "GE": [
    "H",
    "hB",
    "h"
  ],
  "GF": [
    "H",
    "hB"
  ],
  "GG": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "GH": [
    "h",
    "H"
  ],
  "GI": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "GL": [
    "H",
    "h"
  ],
  "GM": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "GN": [
    "H",
    "hB"
  ],
  "GP": [
    "H",
    "hB"
  ],
  "GQ": [
    "H",
    "hB",
    "h",
    "hb"
  ],
  "GR": [
    "h",
    "H",
    "hb",
    "hB"
  ],
  "GT": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "GU": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "GW": [
    "H",
    "hB"
  ],
  "GY": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "HK": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "HN": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "HR": [
    "H",
    "hB"
  ],
  "HU": [
    "H",
    "h"
  ],
  "IC": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "ID": [
    "H"
  ],
  "IE": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "IL": [
    "H",
    "hB"
  ],
  "IM": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "IN": [
    "h",
    "H"
  ],
  "IO": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "IQ": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "IR": [
    "hB",
    "H"
  ],
  "IS": [
    "H"
  ],
  "IT": [
    "H",
    "hB"
  ],
  "JE": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "JM": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "JO": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "JP": [
    "H",
    "K",
    "h"
  ],
  "KE": [
    "hB",
    "hb",
    "H",
    "h"
  ],
  "KG": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "KH": [
    "hB",
    "h",
    "H",
    "hb"
  ],
  "KI": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "KM": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "KN": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "KP": [
    "h",
    "H",
    "hB",
    "hb"
  ],
  "KR": [
    "h",
    "H",
    "hB",
    "hb"
  ],
  "KW": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "KY": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "KZ": [
    "H",
    "hB"
  ],
  "LA": [
    "H",
    "hb",
    "hB",
    "h"
  ],
  "LB": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "LC": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "LI": [
    "H",
    "hB",
    "h"
  ],
  "LK": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "LR": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "LS": [
    "h",
    "H"
  ],
  "LT": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "LU": [
    "H",
    "h",
    "hB"
  ],
  "LV": [
    "H",
    "hB",
    "hb",
    "h"
  ],
  "LY": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "MA": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "MC": [
    "H",
    "hB"
  ],
  "MD": [
    "H",
    "hB"
  ],
  "ME": [
    "H",
    "hB",
    "h"
  ],
  "MF": [
    "H",
    "hB"
  ],
  "MG": [
    "H",
    "h"
  ],
  "MH": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "MK": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "ML": [
    "H"
  ],
  "MM": [
    "hB",
    "hb",
    "H",
    "h"
  ],
  "MN": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "MO": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "MP": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "MQ": [
    "H",
    "hB"
  ],
  "MR": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "MS": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "MT": [
    "H",
    "h"
  ],
  "MU": [
    "H",
    "h"
  ],
  "MV": [
    "H",
    "h"
  ],
  "MW": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "MX": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "MY": [
    "hb",
    "hB",
    "h",
    "H"
  ],
  "MZ": [
    "H",
    "hB"
  ],
  "NA": [
    "h",
    "H",
    "hB",
    "hb"
  ],
  "NC": [
    "H",
    "hB"
  ],
  "NE": [
    "H"
  ],
  "NF": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "NG": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "NI": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "NL": [
    "H",
    "hB"
  ],
  "NO": [
    "H",
    "h"
  ],
  "NP": [
    "H",
    "h",
    "hB"
  ],
  "NR": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "NU": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "NZ": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "OM": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "PA": [
    "h",
    "H",
    "hB",
    "hb"
  ],
  "PE": [
    "H",
    "hB",
    "h",
    "hb"
  ],
  "PF": [
    "H",
    "h",
    "hB"
  ],
  "PG": [
    "h",
    "H"
  ],
  "PH": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "PK": [
    "h",
    "hB",
    "H"
  ],
  "PL": [
    "H",
    "h"
  ],
  "PM": [
    "H",
    "hB"
  ],
  "PN": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "PR": [
    "h",
    "H",
    "hB",
    "hb"
  ],
  "PS": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "PT": [
    "H",
    "hB"
  ],
  "PW": [
    "h",
    "H"
  ],
  "PY": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "QA": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "RE": [
    "H",
    "hB"
  ],
  "RO": [
    "H",
    "hB"
  ],
  "RS": [
    "H",
    "hB",
    "h"
  ],
  "RU": [
    "H"
  ],
  "RW": [
    "H",
    "h"
  ],
  "SA": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "SB": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "SC": [
    "H",
    "h",
    "hB"
  ],
  "SD": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "SE": [
    "H"
  ],
  "SG": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "SH": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "SI": [
    "H",
    "hB"
  ],
  "SJ": [
    "H"
  ],
  "SK": [
    "H"
  ],
  "SL": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "SM": [
    "H",
    "h",
    "hB"
  ],
  "SN": [
    "H",
    "h",
    "hB"
  ],
  "SO": [
    "h",
    "H"
  ],
  "SR": [
    "H",
    "hB"
  ],
  "SS": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "ST": [
    "H",
    "hB"
  ],
  "SV": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "SX": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "SY": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "SZ": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "TA": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "TC": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "TD": [
    "h",
    "H",
    "hB"
  ],
  "TF": [
    "H",
    "h",
    "hB"
  ],
  "TG": [
    "H",
    "hB"
  ],
  "TH": [
    "H",
    "h"
  ],
  "TJ": [
    "H",
    "h"
  ],
  "TL": [
    "H",
    "hB",
    "hb",
    "h"
  ],
  "TM": [
    "H",
    "h"
  ],
  "TN": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "TO": [
    "h",
    "H"
  ],
  "TR": [
    "H",
    "hB"
  ],
  "TT": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "TW": [
    "hB",
    "hb",
    "h",
    "H"
  ],
  "TZ": [
    "hB",
    "hb",
    "H",
    "h"
  ],
  "UA": [
    "H",
    "hB",
    "h"
  ],
  "UG": [
    "hB",
    "hb",
    "H",
    "h"
  ],
  "UM": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "US": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "UY": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "UZ": [
    "H",
    "hB",
    "h"
  ],
  "VA": [
    "H",
    "h",
    "hB"
  ],
  "VC": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "VE": [
    "h",
    "H",
    "hB",
    "hb"
  ],
  "VG": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "VI": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "VN": [
    "H",
    "h"
  ],
  "VU": [
    "h",
    "H"
  ],
  "WF": [
    "H",
    "hB"
  ],
  "WS": [
    "h",
    "H"
  ],
  "XK": [
    "H",
    "hB",
    "h"
  ],
  "YE": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "YT": [
    "H",
    "hB"
  ],
  "ZA": [
    "H",
    "h",
    "hb",
    "hB"
  ],
  "ZM": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "ZW": [
    "H",
    "h"
  ],
  "af-ZA": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "ar-001": [
    "h",
    "hB",
    "hb",
    "H"
  ],
  "ca-ES": [
    "H",
    "h",
    "hB"
  ],
  "en-001": [
    "h",
    "hb",
    "H",
    "hB"
  ],
  "es-BO": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "es-BR": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "es-EC": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "es-ES": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "es-GQ": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "es-PE": [
    "H",
    "h",
    "hB",
    "hb"
  ],
  "fr-CA": [
    "H",
    "h",
    "hB"
  ],
  "gl-ES": [
    "H",
    "h",
    "hB"
  ],
  "gu-IN": [
    "hB",
    "hb",
    "h",
    "H"
  ],
  "hi-IN": [
    "hB",
    "h",
    "H"
  ],
  "it-CH": [
    "H",
    "h",
    "hB"
  ],
  "it-IT": [
    "H",
    "h",
    "hB"
  ],
  "kn-IN": [
    "hB",
    "h",
    "H"
  ],
  "ml-IN": [
    "hB",
    "h",
    "H"
  ],
  "mr-IN": [
    "hB",
    "hb",
    "h",
    "H"
  ],
  "pa-IN": [
    "hB",
    "hb",
    "h",
    "H"
  ],
  "ta-IN": [
    "hB",
    "h",
    "hb",
    "H"
  ],
  "te-IN": [
    "hB",
    "h",
    "H"
  ],
  "zu-ZA": [
    "H",
    "hB",
    "hb",
    "h"
  ]
};
function getBestPattern(skeleton, locale) {
  var skeletonCopy = "";
  for (var patternPos = 0; patternPos < skeleton.length; patternPos++) {
    var patternChar = skeleton.charAt(patternPos);
    if (patternChar === "j") {
      var extraLength = 0;
      while (patternPos + 1 < skeleton.length && skeleton.charAt(patternPos + 1) === patternChar) {
        extraLength++;
        patternPos++;
      }
      var hourLen = 1 + (extraLength & 1);
      var dayPeriodLen = extraLength < 2 ? 1 : 3 + (extraLength >> 1);
      var dayPeriodChar = "a";
      var hourChar = getDefaultHourSymbolFromLocale(locale);
      if (hourChar == "H" || hourChar == "k") {
        dayPeriodLen = 0;
      }
      while (dayPeriodLen-- > 0) {
        skeletonCopy += dayPeriodChar;
      }
      while (hourLen-- > 0) {
        skeletonCopy = hourChar + skeletonCopy;
      }
    } else if (patternChar === "J") {
      skeletonCopy += "H";
    } else {
      skeletonCopy += patternChar;
    }
  }
  return skeletonCopy;
}
function getDefaultHourSymbolFromLocale(locale) {
  var hourCycle = locale.hourCycle;
  if (hourCycle === void 0 && // @ts-ignore hourCycle(s) is not identified yet
  locale.hourCycles && // @ts-ignore
  locale.hourCycles.length) {
    hourCycle = locale.hourCycles[0];
  }
  if (hourCycle) {
    switch (hourCycle) {
      case "h24":
        return "k";
      case "h23":
        return "H";
      case "h12":
        return "h";
      case "h11":
        return "K";
      default:
        throw new Error("Invalid hourCycle");
    }
  }
  var languageTag = locale.language;
  var regionTag;
  if (languageTag !== "root") {
    regionTag = locale.maximize().region;
  }
  var hourCycles = timeData[regionTag || ""] || timeData[languageTag || ""] || timeData["".concat(languageTag, "-001")] || timeData["001"];
  return hourCycles[0];
}
var _a;
var SPACE_SEPARATOR_START_REGEX = new RegExp("^".concat(SPACE_SEPARATOR_REGEX.source, "*"));
var SPACE_SEPARATOR_END_REGEX = new RegExp("".concat(SPACE_SEPARATOR_REGEX.source, "*$"));
function createLocation(start, end) {
  return { start, end };
}
var hasNativeStartsWith = !!String.prototype.startsWith && "_a".startsWith("a", 1);
var hasNativeFromCodePoint = !!String.fromCodePoint;
var hasNativeFromEntries = !!Object.fromEntries;
var hasNativeCodePointAt = !!String.prototype.codePointAt;
var hasTrimStart = !!String.prototype.trimStart;
var hasTrimEnd = !!String.prototype.trimEnd;
var hasNativeIsSafeInteger = !!Number.isSafeInteger;
var isSafeInteger = hasNativeIsSafeInteger ? Number.isSafeInteger : function(n) {
  return typeof n === "number" && isFinite(n) && Math.floor(n) === n && Math.abs(n) <= 9007199254740991;
};
var REGEX_SUPPORTS_U_AND_Y = true;
try {
  var re = RE("([^\\p{White_Space}\\p{Pattern_Syntax}]*)", "yu");
  REGEX_SUPPORTS_U_AND_Y = ((_a = re.exec("a")) === null || _a === void 0 ? void 0 : _a[0]) === "a";
} catch (_) {
  REGEX_SUPPORTS_U_AND_Y = false;
}
var startsWith = hasNativeStartsWith ? (
  // Native
  function startsWith2(s, search, position) {
    return s.startsWith(search, position);
  }
) : (
  // For IE11
  function startsWith3(s, search, position) {
    return s.slice(position, position + search.length) === search;
  }
);
var fromCodePoint = hasNativeFromCodePoint ? String.fromCodePoint : (
  // IE11
  function fromCodePoint2() {
    var codePoints = [];
    for (var _i = 0; _i < arguments.length; _i++) {
      codePoints[_i] = arguments[_i];
    }
    var elements = "";
    var length = codePoints.length;
    var i = 0;
    var code2;
    while (length > i) {
      code2 = codePoints[i++];
      if (code2 > 1114111)
        throw RangeError(code2 + " is not a valid code point");
      elements += code2 < 65536 ? String.fromCharCode(code2) : String.fromCharCode(((code2 -= 65536) >> 10) + 55296, code2 % 1024 + 56320);
    }
    return elements;
  }
);
var fromEntries = (
  // native
  hasNativeFromEntries ? Object.fromEntries : (
    // Ponyfill
    function fromEntries2(entries2) {
      var obj = {};
      for (var _i = 0, entries_1 = entries2; _i < entries_1.length; _i++) {
        var _a2 = entries_1[_i], k = _a2[0], v = _a2[1];
        obj[k] = v;
      }
      return obj;
    }
  )
);
var codePointAt = hasNativeCodePointAt ? (
  // Native
  function codePointAt2(s, index) {
    return s.codePointAt(index);
  }
) : (
  // IE 11
  function codePointAt3(s, index) {
    var size = s.length;
    if (index < 0 || index >= size) {
      return void 0;
    }
    var first = s.charCodeAt(index);
    var second;
    return first < 55296 || first > 56319 || index + 1 === size || (second = s.charCodeAt(index + 1)) < 56320 || second > 57343 ? first : (first - 55296 << 10) + (second - 56320) + 65536;
  }
);
var trimStart = hasTrimStart ? (
  // Native
  function trimStart2(s) {
    return s.trimStart();
  }
) : (
  // Ponyfill
  function trimStart3(s) {
    return s.replace(SPACE_SEPARATOR_START_REGEX, "");
  }
);
var trimEnd = hasTrimEnd ? (
  // Native
  function trimEnd2(s) {
    return s.trimEnd();
  }
) : (
  // Ponyfill
  function trimEnd3(s) {
    return s.replace(SPACE_SEPARATOR_END_REGEX, "");
  }
);
function RE(s, flag) {
  return new RegExp(s, flag);
}
var matchIdentifierAtIndex;
if (REGEX_SUPPORTS_U_AND_Y) {
  var IDENTIFIER_PREFIX_RE_1 = RE("([^\\p{White_Space}\\p{Pattern_Syntax}]*)", "yu");
  matchIdentifierAtIndex = function matchIdentifierAtIndex2(s, index) {
    var _a2;
    IDENTIFIER_PREFIX_RE_1.lastIndex = index;
    var match = IDENTIFIER_PREFIX_RE_1.exec(s);
    return (_a2 = match[1]) !== null && _a2 !== void 0 ? _a2 : "";
  };
} else {
  matchIdentifierAtIndex = function matchIdentifierAtIndex2(s, index) {
    var match = [];
    while (true) {
      var c = codePointAt(s, index);
      if (c === void 0 || _isWhiteSpace(c) || _isPatternSyntax(c)) {
        break;
      }
      match.push(c);
      index += c >= 65536 ? 2 : 1;
    }
    return fromCodePoint.apply(void 0, match);
  };
}
var Parser$2 = (
  /** @class */
  function() {
    function Parser2(message, options2) {
      if (options2 === void 0) {
        options2 = {};
      }
      this.message = message;
      this.position = { offset: 0, line: 1, column: 1 };
      this.ignoreTag = !!options2.ignoreTag;
      this.locale = options2.locale;
      this.requiresOtherClause = !!options2.requiresOtherClause;
      this.shouldParseSkeletons = !!options2.shouldParseSkeletons;
    }
    Parser2.prototype.parse = function() {
      if (this.offset() !== 0) {
        throw Error("parser can only be used once");
      }
      return this.parseMessage(0, "", false);
    };
    Parser2.prototype.parseMessage = function(nestingLevel, parentArgType, expectingCloseTag) {
      var elements = [];
      while (!this.isEOF()) {
        var char = this.char();
        if (char === 123) {
          var result = this.parseArgument(nestingLevel, expectingCloseTag);
          if (result.err) {
            return result;
          }
          elements.push(result.val);
        } else if (char === 125 && nestingLevel > 0) {
          break;
        } else if (char === 35 && (parentArgType === "plural" || parentArgType === "selectordinal")) {
          var position = this.clonePosition();
          this.bump();
          elements.push({
            type: TYPE.pound,
            location: createLocation(position, this.clonePosition())
          });
        } else if (char === 60 && !this.ignoreTag && this.peek() === 47) {
          if (expectingCloseTag) {
            break;
          } else {
            return this.error(ErrorKind.UNMATCHED_CLOSING_TAG, createLocation(this.clonePosition(), this.clonePosition()));
          }
        } else if (char === 60 && !this.ignoreTag && _isAlpha(this.peek() || 0)) {
          var result = this.parseTag(nestingLevel, parentArgType);
          if (result.err) {
            return result;
          }
          elements.push(result.val);
        } else {
          var result = this.parseLiteral(nestingLevel, parentArgType);
          if (result.err) {
            return result;
          }
          elements.push(result.val);
        }
      }
      return { val: elements, err: null };
    };
    Parser2.prototype.parseTag = function(nestingLevel, parentArgType) {
      var startPosition = this.clonePosition();
      this.bump();
      var tagName = this.parseTagName();
      this.bumpSpace();
      if (this.bumpIf("/>")) {
        return {
          val: {
            type: TYPE.literal,
            value: "<".concat(tagName, "/>"),
            location: createLocation(startPosition, this.clonePosition())
          },
          err: null
        };
      } else if (this.bumpIf(">")) {
        var childrenResult = this.parseMessage(nestingLevel + 1, parentArgType, true);
        if (childrenResult.err) {
          return childrenResult;
        }
        var children = childrenResult.val;
        var endTagStartPosition = this.clonePosition();
        if (this.bumpIf("</")) {
          if (this.isEOF() || !_isAlpha(this.char())) {
            return this.error(ErrorKind.INVALID_TAG, createLocation(endTagStartPosition, this.clonePosition()));
          }
          var closingTagNameStartPosition = this.clonePosition();
          var closingTagName = this.parseTagName();
          if (tagName !== closingTagName) {
            return this.error(ErrorKind.UNMATCHED_CLOSING_TAG, createLocation(closingTagNameStartPosition, this.clonePosition()));
          }
          this.bumpSpace();
          if (!this.bumpIf(">")) {
            return this.error(ErrorKind.INVALID_TAG, createLocation(endTagStartPosition, this.clonePosition()));
          }
          return {
            val: {
              type: TYPE.tag,
              value: tagName,
              children,
              location: createLocation(startPosition, this.clonePosition())
            },
            err: null
          };
        } else {
          return this.error(ErrorKind.UNCLOSED_TAG, createLocation(startPosition, this.clonePosition()));
        }
      } else {
        return this.error(ErrorKind.INVALID_TAG, createLocation(startPosition, this.clonePosition()));
      }
    };
    Parser2.prototype.parseTagName = function() {
      var startOffset = this.offset();
      this.bump();
      while (!this.isEOF() && _isPotentialElementNameChar(this.char())) {
        this.bump();
      }
      return this.message.slice(startOffset, this.offset());
    };
    Parser2.prototype.parseLiteral = function(nestingLevel, parentArgType) {
      var start = this.clonePosition();
      var value = "";
      while (true) {
        var parseQuoteResult = this.tryParseQuote(parentArgType);
        if (parseQuoteResult) {
          value += parseQuoteResult;
          continue;
        }
        var parseUnquotedResult = this.tryParseUnquoted(nestingLevel, parentArgType);
        if (parseUnquotedResult) {
          value += parseUnquotedResult;
          continue;
        }
        var parseLeftAngleResult = this.tryParseLeftAngleBracket();
        if (parseLeftAngleResult) {
          value += parseLeftAngleResult;
          continue;
        }
        break;
      }
      var location2 = createLocation(start, this.clonePosition());
      return {
        val: { type: TYPE.literal, value, location: location2 },
        err: null
      };
    };
    Parser2.prototype.tryParseLeftAngleBracket = function() {
      if (!this.isEOF() && this.char() === 60 && (this.ignoreTag || // If at the opening tag or closing tag position, bail.
      !_isAlphaOrSlash(this.peek() || 0))) {
        this.bump();
        return "<";
      }
      return null;
    };
    Parser2.prototype.tryParseQuote = function(parentArgType) {
      if (this.isEOF() || this.char() !== 39) {
        return null;
      }
      switch (this.peek()) {
        case 39:
          this.bump();
          this.bump();
          return "'";
        case 123:
        case 60:
        case 62:
        case 125:
          break;
        case 35:
          if (parentArgType === "plural" || parentArgType === "selectordinal") {
            break;
          }
          return null;
        default:
          return null;
      }
      this.bump();
      var codePoints = [this.char()];
      this.bump();
      while (!this.isEOF()) {
        var ch = this.char();
        if (ch === 39) {
          if (this.peek() === 39) {
            codePoints.push(39);
            this.bump();
          } else {
            this.bump();
            break;
          }
        } else {
          codePoints.push(ch);
        }
        this.bump();
      }
      return fromCodePoint.apply(void 0, codePoints);
    };
    Parser2.prototype.tryParseUnquoted = function(nestingLevel, parentArgType) {
      if (this.isEOF()) {
        return null;
      }
      var ch = this.char();
      if (ch === 60 || ch === 123 || ch === 35 && (parentArgType === "plural" || parentArgType === "selectordinal") || ch === 125 && nestingLevel > 0) {
        return null;
      } else {
        this.bump();
        return fromCodePoint(ch);
      }
    };
    Parser2.prototype.parseArgument = function(nestingLevel, expectingCloseTag) {
      var openingBracePosition = this.clonePosition();
      this.bump();
      this.bumpSpace();
      if (this.isEOF()) {
        return this.error(ErrorKind.EXPECT_ARGUMENT_CLOSING_BRACE, createLocation(openingBracePosition, this.clonePosition()));
      }
      if (this.char() === 125) {
        this.bump();
        return this.error(ErrorKind.EMPTY_ARGUMENT, createLocation(openingBracePosition, this.clonePosition()));
      }
      var value = this.parseIdentifierIfPossible().value;
      if (!value) {
        return this.error(ErrorKind.MALFORMED_ARGUMENT, createLocation(openingBracePosition, this.clonePosition()));
      }
      this.bumpSpace();
      if (this.isEOF()) {
        return this.error(ErrorKind.EXPECT_ARGUMENT_CLOSING_BRACE, createLocation(openingBracePosition, this.clonePosition()));
      }
      switch (this.char()) {
        case 125: {
          this.bump();
          return {
            val: {
              type: TYPE.argument,
              // value does not include the opening and closing braces.
              value,
              location: createLocation(openingBracePosition, this.clonePosition())
            },
            err: null
          };
        }
        case 44: {
          this.bump();
          this.bumpSpace();
          if (this.isEOF()) {
            return this.error(ErrorKind.EXPECT_ARGUMENT_CLOSING_BRACE, createLocation(openingBracePosition, this.clonePosition()));
          }
          return this.parseArgumentOptions(nestingLevel, expectingCloseTag, value, openingBracePosition);
        }
        default:
          return this.error(ErrorKind.MALFORMED_ARGUMENT, createLocation(openingBracePosition, this.clonePosition()));
      }
    };
    Parser2.prototype.parseIdentifierIfPossible = function() {
      var startingPosition = this.clonePosition();
      var startOffset = this.offset();
      var value = matchIdentifierAtIndex(this.message, startOffset);
      var endOffset = startOffset + value.length;
      this.bumpTo(endOffset);
      var endPosition = this.clonePosition();
      var location2 = createLocation(startingPosition, endPosition);
      return { value, location: location2 };
    };
    Parser2.prototype.parseArgumentOptions = function(nestingLevel, expectingCloseTag, value, openingBracePosition) {
      var _a2;
      var typeStartPosition = this.clonePosition();
      var argType = this.parseIdentifierIfPossible().value;
      var typeEndPosition = this.clonePosition();
      switch (argType) {
        case "":
          return this.error(ErrorKind.EXPECT_ARGUMENT_TYPE, createLocation(typeStartPosition, typeEndPosition));
        case "number":
        case "date":
        case "time": {
          this.bumpSpace();
          var styleAndLocation = null;
          if (this.bumpIf(",")) {
            this.bumpSpace();
            var styleStartPosition = this.clonePosition();
            var result = this.parseSimpleArgStyleIfPossible();
            if (result.err) {
              return result;
            }
            var style = trimEnd(result.val);
            if (style.length === 0) {
              return this.error(ErrorKind.EXPECT_ARGUMENT_STYLE, createLocation(this.clonePosition(), this.clonePosition()));
            }
            var styleLocation = createLocation(styleStartPosition, this.clonePosition());
            styleAndLocation = { style, styleLocation };
          }
          var argCloseResult = this.tryParseArgumentClose(openingBracePosition);
          if (argCloseResult.err) {
            return argCloseResult;
          }
          var location_1 = createLocation(openingBracePosition, this.clonePosition());
          if (styleAndLocation && startsWith(styleAndLocation === null || styleAndLocation === void 0 ? void 0 : styleAndLocation.style, "::", 0)) {
            var skeleton = trimStart(styleAndLocation.style.slice(2));
            if (argType === "number") {
              var result = this.parseNumberSkeletonFromString(skeleton, styleAndLocation.styleLocation);
              if (result.err) {
                return result;
              }
              return {
                val: { type: TYPE.number, value, location: location_1, style: result.val },
                err: null
              };
            } else {
              if (skeleton.length === 0) {
                return this.error(ErrorKind.EXPECT_DATE_TIME_SKELETON, location_1);
              }
              var dateTimePattern = skeleton;
              if (this.locale) {
                dateTimePattern = getBestPattern(skeleton, this.locale);
              }
              var style = {
                type: SKELETON_TYPE.dateTime,
                pattern: dateTimePattern,
                location: styleAndLocation.styleLocation,
                parsedOptions: this.shouldParseSkeletons ? parseDateTimeSkeleton(dateTimePattern) : {}
              };
              var type = argType === "date" ? TYPE.date : TYPE.time;
              return {
                val: { type, value, location: location_1, style },
                err: null
              };
            }
          }
          return {
            val: {
              type: argType === "number" ? TYPE.number : argType === "date" ? TYPE.date : TYPE.time,
              value,
              location: location_1,
              style: (_a2 = styleAndLocation === null || styleAndLocation === void 0 ? void 0 : styleAndLocation.style) !== null && _a2 !== void 0 ? _a2 : null
            },
            err: null
          };
        }
        case "plural":
        case "selectordinal":
        case "select": {
          var typeEndPosition_1 = this.clonePosition();
          this.bumpSpace();
          if (!this.bumpIf(",")) {
            return this.error(ErrorKind.EXPECT_SELECT_ARGUMENT_OPTIONS, createLocation(typeEndPosition_1, __assign$2({}, typeEndPosition_1)));
          }
          this.bumpSpace();
          var identifierAndLocation = this.parseIdentifierIfPossible();
          var pluralOffset = 0;
          if (argType !== "select" && identifierAndLocation.value === "offset") {
            if (!this.bumpIf(":")) {
              return this.error(ErrorKind.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE, createLocation(this.clonePosition(), this.clonePosition()));
            }
            this.bumpSpace();
            var result = this.tryParseDecimalInteger(ErrorKind.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE, ErrorKind.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE);
            if (result.err) {
              return result;
            }
            this.bumpSpace();
            identifierAndLocation = this.parseIdentifierIfPossible();
            pluralOffset = result.val;
          }
          var optionsResult = this.tryParsePluralOrSelectOptions(nestingLevel, argType, expectingCloseTag, identifierAndLocation);
          if (optionsResult.err) {
            return optionsResult;
          }
          var argCloseResult = this.tryParseArgumentClose(openingBracePosition);
          if (argCloseResult.err) {
            return argCloseResult;
          }
          var location_2 = createLocation(openingBracePosition, this.clonePosition());
          if (argType === "select") {
            return {
              val: {
                type: TYPE.select,
                value,
                options: fromEntries(optionsResult.val),
                location: location_2
              },
              err: null
            };
          } else {
            return {
              val: {
                type: TYPE.plural,
                value,
                options: fromEntries(optionsResult.val),
                offset: pluralOffset,
                pluralType: argType === "plural" ? "cardinal" : "ordinal",
                location: location_2
              },
              err: null
            };
          }
        }
        default:
          return this.error(ErrorKind.INVALID_ARGUMENT_TYPE, createLocation(typeStartPosition, typeEndPosition));
      }
    };
    Parser2.prototype.tryParseArgumentClose = function(openingBracePosition) {
      if (this.isEOF() || this.char() !== 125) {
        return this.error(ErrorKind.EXPECT_ARGUMENT_CLOSING_BRACE, createLocation(openingBracePosition, this.clonePosition()));
      }
      this.bump();
      return { val: true, err: null };
    };
    Parser2.prototype.parseSimpleArgStyleIfPossible = function() {
      var nestedBraces = 0;
      var startPosition = this.clonePosition();
      while (!this.isEOF()) {
        var ch = this.char();
        switch (ch) {
          case 39: {
            this.bump();
            var apostrophePosition = this.clonePosition();
            if (!this.bumpUntil("'")) {
              return this.error(ErrorKind.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE, createLocation(apostrophePosition, this.clonePosition()));
            }
            this.bump();
            break;
          }
          case 123: {
            nestedBraces += 1;
            this.bump();
            break;
          }
          case 125: {
            if (nestedBraces > 0) {
              nestedBraces -= 1;
            } else {
              return {
                val: this.message.slice(startPosition.offset, this.offset()),
                err: null
              };
            }
            break;
          }
          default:
            this.bump();
            break;
        }
      }
      return {
        val: this.message.slice(startPosition.offset, this.offset()),
        err: null
      };
    };
    Parser2.prototype.parseNumberSkeletonFromString = function(skeleton, location2) {
      var tokens = [];
      try {
        tokens = parseNumberSkeletonFromString(skeleton);
      } catch (e) {
        return this.error(ErrorKind.INVALID_NUMBER_SKELETON, location2);
      }
      return {
        val: {
          type: SKELETON_TYPE.number,
          tokens,
          location: location2,
          parsedOptions: this.shouldParseSkeletons ? parseNumberSkeleton(tokens) : {}
        },
        err: null
      };
    };
    Parser2.prototype.tryParsePluralOrSelectOptions = function(nestingLevel, parentArgType, expectCloseTag, parsedFirstIdentifier) {
      var _a2;
      var hasOtherClause = false;
      var options2 = [];
      var parsedSelectors = /* @__PURE__ */ new Set();
      var selector = parsedFirstIdentifier.value, selectorLocation = parsedFirstIdentifier.location;
      while (true) {
        if (selector.length === 0) {
          var startPosition = this.clonePosition();
          if (parentArgType !== "select" && this.bumpIf("=")) {
            var result = this.tryParseDecimalInteger(ErrorKind.EXPECT_PLURAL_ARGUMENT_SELECTOR, ErrorKind.INVALID_PLURAL_ARGUMENT_SELECTOR);
            if (result.err) {
              return result;
            }
            selectorLocation = createLocation(startPosition, this.clonePosition());
            selector = this.message.slice(startPosition.offset, this.offset());
          } else {
            break;
          }
        }
        if (parsedSelectors.has(selector)) {
          return this.error(parentArgType === "select" ? ErrorKind.DUPLICATE_SELECT_ARGUMENT_SELECTOR : ErrorKind.DUPLICATE_PLURAL_ARGUMENT_SELECTOR, selectorLocation);
        }
        if (selector === "other") {
          hasOtherClause = true;
        }
        this.bumpSpace();
        var openingBracePosition = this.clonePosition();
        if (!this.bumpIf("{")) {
          return this.error(parentArgType === "select" ? ErrorKind.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT : ErrorKind.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT, createLocation(this.clonePosition(), this.clonePosition()));
        }
        var fragmentResult = this.parseMessage(nestingLevel + 1, parentArgType, expectCloseTag);
        if (fragmentResult.err) {
          return fragmentResult;
        }
        var argCloseResult = this.tryParseArgumentClose(openingBracePosition);
        if (argCloseResult.err) {
          return argCloseResult;
        }
        options2.push([
          selector,
          {
            value: fragmentResult.val,
            location: createLocation(openingBracePosition, this.clonePosition())
          }
        ]);
        parsedSelectors.add(selector);
        this.bumpSpace();
        _a2 = this.parseIdentifierIfPossible(), selector = _a2.value, selectorLocation = _a2.location;
      }
      if (options2.length === 0) {
        return this.error(parentArgType === "select" ? ErrorKind.EXPECT_SELECT_ARGUMENT_SELECTOR : ErrorKind.EXPECT_PLURAL_ARGUMENT_SELECTOR, createLocation(this.clonePosition(), this.clonePosition()));
      }
      if (this.requiresOtherClause && !hasOtherClause) {
        return this.error(ErrorKind.MISSING_OTHER_CLAUSE, createLocation(this.clonePosition(), this.clonePosition()));
      }
      return { val: options2, err: null };
    };
    Parser2.prototype.tryParseDecimalInteger = function(expectNumberError, invalidNumberError) {
      var sign = 1;
      var startingPosition = this.clonePosition();
      if (this.bumpIf("+"))
        ;
      else if (this.bumpIf("-")) {
        sign = -1;
      }
      var hasDigits = false;
      var decimal = 0;
      while (!this.isEOF()) {
        var ch = this.char();
        if (ch >= 48 && ch <= 57) {
          hasDigits = true;
          decimal = decimal * 10 + (ch - 48);
          this.bump();
        } else {
          break;
        }
      }
      var location2 = createLocation(startingPosition, this.clonePosition());
      if (!hasDigits) {
        return this.error(expectNumberError, location2);
      }
      decimal *= sign;
      if (!isSafeInteger(decimal)) {
        return this.error(invalidNumberError, location2);
      }
      return { val: decimal, err: null };
    };
    Parser2.prototype.offset = function() {
      return this.position.offset;
    };
    Parser2.prototype.isEOF = function() {
      return this.offset() === this.message.length;
    };
    Parser2.prototype.clonePosition = function() {
      return {
        offset: this.position.offset,
        line: this.position.line,
        column: this.position.column
      };
    };
    Parser2.prototype.char = function() {
      var offset = this.position.offset;
      if (offset >= this.message.length) {
        throw Error("out of bound");
      }
      var code2 = codePointAt(this.message, offset);
      if (code2 === void 0) {
        throw Error("Offset ".concat(offset, " is at invalid UTF-16 code unit boundary"));
      }
      return code2;
    };
    Parser2.prototype.error = function(kind, location2) {
      return {
        val: null,
        err: {
          kind,
          message: this.message,
          location: location2
        }
      };
    };
    Parser2.prototype.bump = function() {
      if (this.isEOF()) {
        return;
      }
      var code2 = this.char();
      if (code2 === 10) {
        this.position.line += 1;
        this.position.column = 1;
        this.position.offset += 1;
      } else {
        this.position.column += 1;
        this.position.offset += code2 < 65536 ? 1 : 2;
      }
    };
    Parser2.prototype.bumpIf = function(prefix) {
      if (startsWith(this.message, prefix, this.offset())) {
        for (var i = 0; i < prefix.length; i++) {
          this.bump();
        }
        return true;
      }
      return false;
    };
    Parser2.prototype.bumpUntil = function(pattern) {
      var currentOffset = this.offset();
      var index = this.message.indexOf(pattern, currentOffset);
      if (index >= 0) {
        this.bumpTo(index);
        return true;
      } else {
        this.bumpTo(this.message.length);
        return false;
      }
    };
    Parser2.prototype.bumpTo = function(targetOffset) {
      if (this.offset() > targetOffset) {
        throw Error("targetOffset ".concat(targetOffset, " must be greater than or equal to the current offset ").concat(this.offset()));
      }
      targetOffset = Math.min(targetOffset, this.message.length);
      while (true) {
        var offset = this.offset();
        if (offset === targetOffset) {
          break;
        }
        if (offset > targetOffset) {
          throw Error("targetOffset ".concat(targetOffset, " is at invalid UTF-16 code unit boundary"));
        }
        this.bump();
        if (this.isEOF()) {
          break;
        }
      }
    };
    Parser2.prototype.bumpSpace = function() {
      while (!this.isEOF() && _isWhiteSpace(this.char())) {
        this.bump();
      }
    };
    Parser2.prototype.peek = function() {
      if (this.isEOF()) {
        return null;
      }
      var code2 = this.char();
      var offset = this.offset();
      var nextCode = this.message.charCodeAt(offset + (code2 >= 65536 ? 2 : 1));
      return nextCode !== null && nextCode !== void 0 ? nextCode : null;
    };
    return Parser2;
  }()
);
function _isAlpha(codepoint) {
  return codepoint >= 97 && codepoint <= 122 || codepoint >= 65 && codepoint <= 90;
}
function _isAlphaOrSlash(codepoint) {
  return _isAlpha(codepoint) || codepoint === 47;
}
function _isPotentialElementNameChar(c) {
  return c === 45 || c === 46 || c >= 48 && c <= 57 || c === 95 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 183 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8255 && c <= 8256 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
}
function _isWhiteSpace(c) {
  return c >= 9 && c <= 13 || c === 32 || c === 133 || c >= 8206 && c <= 8207 || c === 8232 || c === 8233;
}
function _isPatternSyntax(c) {
  return c >= 33 && c <= 35 || c === 36 || c >= 37 && c <= 39 || c === 40 || c === 41 || c === 42 || c === 43 || c === 44 || c === 45 || c >= 46 && c <= 47 || c >= 58 && c <= 59 || c >= 60 && c <= 62 || c >= 63 && c <= 64 || c === 91 || c === 92 || c === 93 || c === 94 || c === 96 || c === 123 || c === 124 || c === 125 || c === 126 || c === 161 || c >= 162 && c <= 165 || c === 166 || c === 167 || c === 169 || c === 171 || c === 172 || c === 174 || c === 176 || c === 177 || c === 182 || c === 187 || c === 191 || c === 215 || c === 247 || c >= 8208 && c <= 8213 || c >= 8214 && c <= 8215 || c === 8216 || c === 8217 || c === 8218 || c >= 8219 && c <= 8220 || c === 8221 || c === 8222 || c === 8223 || c >= 8224 && c <= 8231 || c >= 8240 && c <= 8248 || c === 8249 || c === 8250 || c >= 8251 && c <= 8254 || c >= 8257 && c <= 8259 || c === 8260 || c === 8261 || c === 8262 || c >= 8263 && c <= 8273 || c === 8274 || c === 8275 || c >= 8277 && c <= 8286 || c >= 8592 && c <= 8596 || c >= 8597 && c <= 8601 || c >= 8602 && c <= 8603 || c >= 8604 && c <= 8607 || c === 8608 || c >= 8609 && c <= 8610 || c === 8611 || c >= 8612 && c <= 8613 || c === 8614 || c >= 8615 && c <= 8621 || c === 8622 || c >= 8623 && c <= 8653 || c >= 8654 && c <= 8655 || c >= 8656 && c <= 8657 || c === 8658 || c === 8659 || c === 8660 || c >= 8661 && c <= 8691 || c >= 8692 && c <= 8959 || c >= 8960 && c <= 8967 || c === 8968 || c === 8969 || c === 8970 || c === 8971 || c >= 8972 && c <= 8991 || c >= 8992 && c <= 8993 || c >= 8994 && c <= 9e3 || c === 9001 || c === 9002 || c >= 9003 && c <= 9083 || c === 9084 || c >= 9085 && c <= 9114 || c >= 9115 && c <= 9139 || c >= 9140 && c <= 9179 || c >= 9180 && c <= 9185 || c >= 9186 && c <= 9254 || c >= 9255 && c <= 9279 || c >= 9280 && c <= 9290 || c >= 9291 && c <= 9311 || c >= 9472 && c <= 9654 || c === 9655 || c >= 9656 && c <= 9664 || c === 9665 || c >= 9666 && c <= 9719 || c >= 9720 && c <= 9727 || c >= 9728 && c <= 9838 || c === 9839 || c >= 9840 && c <= 10087 || c === 10088 || c === 10089 || c === 10090 || c === 10091 || c === 10092 || c === 10093 || c === 10094 || c === 10095 || c === 10096 || c === 10097 || c === 10098 || c === 10099 || c === 10100 || c === 10101 || c >= 10132 && c <= 10175 || c >= 10176 && c <= 10180 || c === 10181 || c === 10182 || c >= 10183 && c <= 10213 || c === 10214 || c === 10215 || c === 10216 || c === 10217 || c === 10218 || c === 10219 || c === 10220 || c === 10221 || c === 10222 || c === 10223 || c >= 10224 && c <= 10239 || c >= 10240 && c <= 10495 || c >= 10496 && c <= 10626 || c === 10627 || c === 10628 || c === 10629 || c === 10630 || c === 10631 || c === 10632 || c === 10633 || c === 10634 || c === 10635 || c === 10636 || c === 10637 || c === 10638 || c === 10639 || c === 10640 || c === 10641 || c === 10642 || c === 10643 || c === 10644 || c === 10645 || c === 10646 || c === 10647 || c === 10648 || c >= 10649 && c <= 10711 || c === 10712 || c === 10713 || c === 10714 || c === 10715 || c >= 10716 && c <= 10747 || c === 10748 || c === 10749 || c >= 10750 && c <= 11007 || c >= 11008 && c <= 11055 || c >= 11056 && c <= 11076 || c >= 11077 && c <= 11078 || c >= 11079 && c <= 11084 || c >= 11085 && c <= 11123 || c >= 11124 && c <= 11125 || c >= 11126 && c <= 11157 || c === 11158 || c >= 11159 && c <= 11263 || c >= 11776 && c <= 11777 || c === 11778 || c === 11779 || c === 11780 || c === 11781 || c >= 11782 && c <= 11784 || c === 11785 || c === 11786 || c === 11787 || c === 11788 || c === 11789 || c >= 11790 && c <= 11798 || c === 11799 || c >= 11800 && c <= 11801 || c === 11802 || c === 11803 || c === 11804 || c === 11805 || c >= 11806 && c <= 11807 || c === 11808 || c === 11809 || c === 11810 || c === 11811 || c === 11812 || c === 11813 || c === 11814 || c === 11815 || c === 11816 || c === 11817 || c >= 11818 && c <= 11822 || c === 11823 || c >= 11824 && c <= 11833 || c >= 11834 && c <= 11835 || c >= 11836 && c <= 11839 || c === 11840 || c === 11841 || c === 11842 || c >= 11843 && c <= 11855 || c >= 11856 && c <= 11857 || c === 11858 || c >= 11859 && c <= 11903 || c >= 12289 && c <= 12291 || c === 12296 || c === 12297 || c === 12298 || c === 12299 || c === 12300 || c === 12301 || c === 12302 || c === 12303 || c === 12304 || c === 12305 || c >= 12306 && c <= 12307 || c === 12308 || c === 12309 || c === 12310 || c === 12311 || c === 12312 || c === 12313 || c === 12314 || c === 12315 || c === 12316 || c === 12317 || c >= 12318 && c <= 12319 || c === 12320 || c === 12336 || c === 64830 || c === 64831 || c >= 65093 && c <= 65094;
}
function pruneLocation(els) {
  els.forEach(function(el) {
    delete el.location;
    if (isSelectElement(el) || isPluralElement(el)) {
      for (var k in el.options) {
        delete el.options[k].location;
        pruneLocation(el.options[k].value);
      }
    } else if (isNumberElement(el) && isNumberSkeleton(el.style)) {
      delete el.style.location;
    } else if ((isDateElement(el) || isTimeElement(el)) && isDateTimeSkeleton(el.style)) {
      delete el.style.location;
    } else if (isTagElement(el)) {
      pruneLocation(el.children);
    }
  });
}
function parse(message, opts) {
  if (opts === void 0) {
    opts = {};
  }
  opts = __assign$2({ shouldParseSkeletons: true, requiresOtherClause: true }, opts);
  var result = new Parser$2(message, opts).parse();
  if (result.err) {
    var error = SyntaxError(ErrorKind[result.err.kind]);
    error.location = result.err.location;
    error.originalMessage = result.err.message;
    throw error;
  }
  if (!(opts === null || opts === void 0 ? void 0 : opts.captureLocation)) {
    pruneLocation(result.val);
  }
  return result.val;
}
function memoize(fn2, options2) {
  var cache = options2 && options2.cache ? options2.cache : cacheDefault;
  var serializer = options2 && options2.serializer ? options2.serializer : serializerDefault;
  var strategy = options2 && options2.strategy ? options2.strategy : strategyDefault;
  return strategy(fn2, {
    cache,
    serializer
  });
}
function isPrimitive(value) {
  return value == null || typeof value === "number" || typeof value === "boolean";
}
function monadic(fn2, cache, serializer, arg) {
  var cacheKey = isPrimitive(arg) ? arg : serializer(arg);
  var computedValue = cache.get(cacheKey);
  if (typeof computedValue === "undefined") {
    computedValue = fn2.call(this, arg);
    cache.set(cacheKey, computedValue);
  }
  return computedValue;
}
function variadic(fn2, cache, serializer) {
  var args = Array.prototype.slice.call(arguments, 3);
  var cacheKey = serializer(args);
  var computedValue = cache.get(cacheKey);
  if (typeof computedValue === "undefined") {
    computedValue = fn2.apply(this, args);
    cache.set(cacheKey, computedValue);
  }
  return computedValue;
}
function assemble(fn2, context, strategy, cache, serialize) {
  return strategy.bind(context, fn2, cache, serialize);
}
function strategyDefault(fn2, options2) {
  var strategy = fn2.length === 1 ? monadic : variadic;
  return assemble(fn2, this, strategy, options2.cache.create(), options2.serializer);
}
function strategyVariadic(fn2, options2) {
  return assemble(fn2, this, variadic, options2.cache.create(), options2.serializer);
}
function strategyMonadic(fn2, options2) {
  return assemble(fn2, this, monadic, options2.cache.create(), options2.serializer);
}
var serializerDefault = function() {
  return JSON.stringify(arguments);
};
function ObjectWithoutPrototypeCache() {
  this.cache = /* @__PURE__ */ Object.create(null);
}
ObjectWithoutPrototypeCache.prototype.get = function(key) {
  return this.cache[key];
};
ObjectWithoutPrototypeCache.prototype.set = function(key, value) {
  this.cache[key] = value;
};
var cacheDefault = {
  create: function create() {
    return new ObjectWithoutPrototypeCache();
  }
};
var strategies = {
  variadic: strategyVariadic,
  monadic: strategyMonadic
};
var ErrorCode;
(function(ErrorCode2) {
  ErrorCode2["MISSING_VALUE"] = "MISSING_VALUE";
  ErrorCode2["INVALID_VALUE"] = "INVALID_VALUE";
  ErrorCode2["MISSING_INTL_API"] = "MISSING_INTL_API";
})(ErrorCode || (ErrorCode = {}));
var FormatError = (
  /** @class */
  function(_super) {
    __extends$1(FormatError2, _super);
    function FormatError2(msg, code2, originalMessage) {
      var _this = _super.call(this, msg) || this;
      _this.code = code2;
      _this.originalMessage = originalMessage;
      return _this;
    }
    FormatError2.prototype.toString = function() {
      return "[formatjs Error: ".concat(this.code, "] ").concat(this.message);
    };
    return FormatError2;
  }(Error)
);
var InvalidValueError = (
  /** @class */
  function(_super) {
    __extends$1(InvalidValueError2, _super);
    function InvalidValueError2(variableId, value, options2, originalMessage) {
      return _super.call(this, 'Invalid values for "'.concat(variableId, '": "').concat(value, '". Options are "').concat(Object.keys(options2).join('", "'), '"'), ErrorCode.INVALID_VALUE, originalMessage) || this;
    }
    return InvalidValueError2;
  }(FormatError)
);
var InvalidValueTypeError = (
  /** @class */
  function(_super) {
    __extends$1(InvalidValueTypeError2, _super);
    function InvalidValueTypeError2(value, type, originalMessage) {
      return _super.call(this, 'Value for "'.concat(value, '" must be of type ').concat(type), ErrorCode.INVALID_VALUE, originalMessage) || this;
    }
    return InvalidValueTypeError2;
  }(FormatError)
);
var MissingValueError = (
  /** @class */
  function(_super) {
    __extends$1(MissingValueError2, _super);
    function MissingValueError2(variableId, originalMessage) {
      return _super.call(this, 'The intl string context variable "'.concat(variableId, '" was not provided to the string "').concat(originalMessage, '"'), ErrorCode.MISSING_VALUE, originalMessage) || this;
    }
    return MissingValueError2;
  }(FormatError)
);
var PART_TYPE;
(function(PART_TYPE2) {
  PART_TYPE2[PART_TYPE2["literal"] = 0] = "literal";
  PART_TYPE2[PART_TYPE2["object"] = 1] = "object";
})(PART_TYPE || (PART_TYPE = {}));
function mergeLiteral(parts) {
  if (parts.length < 2) {
    return parts;
  }
  return parts.reduce(function(all, part) {
    var lastPart = all[all.length - 1];
    if (!lastPart || lastPart.type !== PART_TYPE.literal || part.type !== PART_TYPE.literal) {
      all.push(part);
    } else {
      lastPart.value += part.value;
    }
    return all;
  }, []);
}
function isFormatXMLElementFn(el) {
  return typeof el === "function";
}
function formatToParts(els, locales, formatters, formats, values, currentPluralValue, originalMessage) {
  if (els.length === 1 && isLiteralElement(els[0])) {
    return [
      {
        type: PART_TYPE.literal,
        value: els[0].value
      }
    ];
  }
  var result = [];
  for (var _i = 0, els_1 = els; _i < els_1.length; _i++) {
    var el = els_1[_i];
    if (isLiteralElement(el)) {
      result.push({
        type: PART_TYPE.literal,
        value: el.value
      });
      continue;
    }
    if (isPoundElement(el)) {
      if (typeof currentPluralValue === "number") {
        result.push({
          type: PART_TYPE.literal,
          value: formatters.getNumberFormat(locales).format(currentPluralValue)
        });
      }
      continue;
    }
    var varName = el.value;
    if (!(values && varName in values)) {
      throw new MissingValueError(varName, originalMessage);
    }
    var value = values[varName];
    if (isArgumentElement(el)) {
      if (!value || typeof value === "string" || typeof value === "number") {
        value = typeof value === "string" || typeof value === "number" ? String(value) : "";
      }
      result.push({
        type: typeof value === "string" ? PART_TYPE.literal : PART_TYPE.object,
        value
      });
      continue;
    }
    if (isDateElement(el)) {
      var style = typeof el.style === "string" ? formats.date[el.style] : isDateTimeSkeleton(el.style) ? el.style.parsedOptions : void 0;
      result.push({
        type: PART_TYPE.literal,
        value: formatters.getDateTimeFormat(locales, style).format(value)
      });
      continue;
    }
    if (isTimeElement(el)) {
      var style = typeof el.style === "string" ? formats.time[el.style] : isDateTimeSkeleton(el.style) ? el.style.parsedOptions : formats.time.medium;
      result.push({
        type: PART_TYPE.literal,
        value: formatters.getDateTimeFormat(locales, style).format(value)
      });
      continue;
    }
    if (isNumberElement(el)) {
      var style = typeof el.style === "string" ? formats.number[el.style] : isNumberSkeleton(el.style) ? el.style.parsedOptions : void 0;
      if (style && style.scale) {
        value = value * (style.scale || 1);
      }
      result.push({
        type: PART_TYPE.literal,
        value: formatters.getNumberFormat(locales, style).format(value)
      });
      continue;
    }
    if (isTagElement(el)) {
      var children = el.children, value_1 = el.value;
      var formatFn = values[value_1];
      if (!isFormatXMLElementFn(formatFn)) {
        throw new InvalidValueTypeError(value_1, "function", originalMessage);
      }
      var parts = formatToParts(children, locales, formatters, formats, values, currentPluralValue);
      var chunks = formatFn(parts.map(function(p) {
        return p.value;
      }));
      if (!Array.isArray(chunks)) {
        chunks = [chunks];
      }
      result.push.apply(result, chunks.map(function(c) {
        return {
          type: typeof c === "string" ? PART_TYPE.literal : PART_TYPE.object,
          value: c
        };
      }));
    }
    if (isSelectElement(el)) {
      var opt = el.options[value] || el.options.other;
      if (!opt) {
        throw new InvalidValueError(el.value, value, Object.keys(el.options), originalMessage);
      }
      result.push.apply(result, formatToParts(opt.value, locales, formatters, formats, values));
      continue;
    }
    if (isPluralElement(el)) {
      var opt = el.options["=".concat(value)];
      if (!opt) {
        if (!Intl.PluralRules) {
          throw new FormatError('Intl.PluralRules is not available in this environment.\nTry polyfilling it using "@formatjs/intl-pluralrules"\n', ErrorCode.MISSING_INTL_API, originalMessage);
        }
        var rule = formatters.getPluralRules(locales, { type: el.pluralType }).select(value - (el.offset || 0));
        opt = el.options[rule] || el.options.other;
      }
      if (!opt) {
        throw new InvalidValueError(el.value, value, Object.keys(el.options), originalMessage);
      }
      result.push.apply(result, formatToParts(opt.value, locales, formatters, formats, values, value - (el.offset || 0)));
      continue;
    }
  }
  return mergeLiteral(result);
}
function mergeConfig(c1, c2) {
  if (!c2) {
    return c1;
  }
  return __assign$2(__assign$2(__assign$2({}, c1 || {}), c2 || {}), Object.keys(c1).reduce(function(all, k) {
    all[k] = __assign$2(__assign$2({}, c1[k]), c2[k] || {});
    return all;
  }, {}));
}
function mergeConfigs(defaultConfig, configs) {
  if (!configs) {
    return defaultConfig;
  }
  return Object.keys(defaultConfig).reduce(function(all, k) {
    all[k] = mergeConfig(defaultConfig[k], configs[k]);
    return all;
  }, __assign$2({}, defaultConfig));
}
function createFastMemoizeCache(store) {
  return {
    create: function() {
      return {
        get: function(key) {
          return store[key];
        },
        set: function(key, value) {
          store[key] = value;
        }
      };
    }
  };
}
function createDefaultFormatters(cache) {
  if (cache === void 0) {
    cache = {
      number: {},
      dateTime: {},
      pluralRules: {}
    };
  }
  return {
    getNumberFormat: memoize(function() {
      var _a2;
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
      }
      return new ((_a2 = Intl.NumberFormat).bind.apply(_a2, __spreadArray([void 0], args, false)))();
    }, {
      cache: createFastMemoizeCache(cache.number),
      strategy: strategies.variadic
    }),
    getDateTimeFormat: memoize(function() {
      var _a2;
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
      }
      return new ((_a2 = Intl.DateTimeFormat).bind.apply(_a2, __spreadArray([void 0], args, false)))();
    }, {
      cache: createFastMemoizeCache(cache.dateTime),
      strategy: strategies.variadic
    }),
    getPluralRules: memoize(function() {
      var _a2;
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
      }
      return new ((_a2 = Intl.PluralRules).bind.apply(_a2, __spreadArray([void 0], args, false)))();
    }, {
      cache: createFastMemoizeCache(cache.pluralRules),
      strategy: strategies.variadic
    })
  };
}
var IntlMessageFormat = (
  /** @class */
  function() {
    function IntlMessageFormat2(message, locales, overrideFormats, opts) {
      var _this = this;
      if (locales === void 0) {
        locales = IntlMessageFormat2.defaultLocale;
      }
      this.formatterCache = {
        number: {},
        dateTime: {},
        pluralRules: {}
      };
      this.format = function(values) {
        var parts = _this.formatToParts(values);
        if (parts.length === 1) {
          return parts[0].value;
        }
        var result = parts.reduce(function(all, part) {
          if (!all.length || part.type !== PART_TYPE.literal || typeof all[all.length - 1] !== "string") {
            all.push(part.value);
          } else {
            all[all.length - 1] += part.value;
          }
          return all;
        }, []);
        if (result.length <= 1) {
          return result[0] || "";
        }
        return result;
      };
      this.formatToParts = function(values) {
        return formatToParts(_this.ast, _this.locales, _this.formatters, _this.formats, values, void 0, _this.message);
      };
      this.resolvedOptions = function() {
        var _a3;
        return {
          locale: ((_a3 = _this.resolvedLocale) === null || _a3 === void 0 ? void 0 : _a3.toString()) || Intl.NumberFormat.supportedLocalesOf(_this.locales)[0]
        };
      };
      this.getAst = function() {
        return _this.ast;
      };
      this.locales = locales;
      this.resolvedLocale = IntlMessageFormat2.resolveLocale(locales);
      if (typeof message === "string") {
        this.message = message;
        if (!IntlMessageFormat2.__parse) {
          throw new TypeError("IntlMessageFormat.__parse must be set to process `message` of type `string`");
        }
        var _a2 = opts || {};
        _a2.formatters;
        var parseOpts = __rest(_a2, ["formatters"]);
        this.ast = IntlMessageFormat2.__parse(message, __assign$2(__assign$2({}, parseOpts), { locale: this.resolvedLocale }));
      } else {
        this.ast = message;
      }
      if (!Array.isArray(this.ast)) {
        throw new TypeError("A message must be provided as a String or AST.");
      }
      this.formats = mergeConfigs(IntlMessageFormat2.formats, overrideFormats);
      this.formatters = opts && opts.formatters || createDefaultFormatters(this.formatterCache);
    }
    Object.defineProperty(IntlMessageFormat2, "defaultLocale", {
      get: function() {
        if (!IntlMessageFormat2.memoizedDefaultLocale) {
          IntlMessageFormat2.memoizedDefaultLocale = new Intl.NumberFormat().resolvedOptions().locale;
        }
        return IntlMessageFormat2.memoizedDefaultLocale;
      },
      enumerable: false,
      configurable: true
    });
    IntlMessageFormat2.memoizedDefaultLocale = null;
    IntlMessageFormat2.resolveLocale = function(locales) {
      if (typeof Intl.Locale === "undefined") {
        return;
      }
      var supportedLocales = Intl.NumberFormat.supportedLocalesOf(locales);
      if (supportedLocales.length > 0) {
        return new Intl.Locale(supportedLocales[0]);
      }
      return new Intl.Locale(typeof locales === "string" ? locales : locales[0]);
    };
    IntlMessageFormat2.__parse = parse;
    IntlMessageFormat2.formats = {
      number: {
        integer: {
          maximumFractionDigits: 0
        },
        currency: {
          style: "currency"
        },
        percent: {
          style: "percent"
        }
      },
      date: {
        short: {
          month: "numeric",
          day: "numeric",
          year: "2-digit"
        },
        medium: {
          month: "short",
          day: "numeric",
          year: "numeric"
        },
        long: {
          month: "long",
          day: "numeric",
          year: "numeric"
        },
        full: {
          weekday: "long",
          month: "long",
          day: "numeric",
          year: "numeric"
        }
      },
      time: {
        short: {
          hour: "numeric",
          minute: "numeric"
        },
        medium: {
          hour: "numeric",
          minute: "numeric",
          second: "numeric"
        },
        long: {
          hour: "numeric",
          minute: "numeric",
          second: "numeric",
          timeZoneName: "short"
        },
        full: {
          hour: "numeric",
          minute: "numeric",
          second: "numeric",
          timeZoneName: "short"
        }
      }
    };
    return IntlMessageFormat2;
  }()
);
function delve(obj, fullKey) {
  if (fullKey == null)
    return void 0;
  if (fullKey in obj) {
    return obj[fullKey];
  }
  const keys = fullKey.split(".");
  let result = obj;
  for (let p = 0; p < keys.length; p++) {
    if (typeof result === "object") {
      if (p > 0) {
        const partialKey = keys.slice(p, keys.length).join(".");
        if (partialKey in result) {
          result = result[partialKey];
          break;
        }
      }
      result = result[keys[p]];
    } else {
      result = void 0;
    }
  }
  return result;
}
const lookupCache = {};
const addToCache = (path2, locale, message) => {
  if (!message)
    return message;
  if (!(locale in lookupCache))
    lookupCache[locale] = {};
  if (!(path2 in lookupCache[locale]))
    lookupCache[locale][path2] = message;
  return message;
};
const lookup = (path2, refLocale) => {
  if (refLocale == null)
    return void 0;
  if (refLocale in lookupCache && path2 in lookupCache[refLocale]) {
    return lookupCache[refLocale][path2];
  }
  const locales = getPossibleLocales(refLocale);
  for (let i = 0; i < locales.length; i++) {
    const locale = locales[i];
    const message = getMessageFromDictionary(locale, path2);
    if (message) {
      return addToCache(path2, refLocale, message);
    }
  }
  return void 0;
};
let dictionary;
const $dictionary = writable({});
function getLocaleDictionary(locale) {
  return dictionary[locale] || null;
}
function hasLocaleDictionary(locale) {
  return locale in dictionary;
}
function getMessageFromDictionary(locale, id) {
  if (!hasLocaleDictionary(locale)) {
    return null;
  }
  const localeDictionary = getLocaleDictionary(locale);
  const match = delve(localeDictionary, id);
  return match;
}
function getClosestAvailableLocale(refLocale) {
  if (refLocale == null)
    return void 0;
  const relatedLocales = getPossibleLocales(refLocale);
  for (let i = 0; i < relatedLocales.length; i++) {
    const locale = relatedLocales[i];
    if (hasLocaleDictionary(locale)) {
      return locale;
    }
  }
  return void 0;
}
function addMessages(locale, ...partials) {
  delete lookupCache[locale];
  $dictionary.update((d) => {
    d[locale] = deepmerge$2.all([d[locale] || {}, ...partials]);
    return d;
  });
}
derived(
  [$dictionary],
  ([dictionary2]) => Object.keys(dictionary2)
);
$dictionary.subscribe((newDictionary) => dictionary = newDictionary);
const queue = {};
function removeLoaderFromQueue(locale, loader) {
  queue[locale].delete(loader);
  if (queue[locale].size === 0) {
    delete queue[locale];
  }
}
function getLocaleQueue(locale) {
  return queue[locale];
}
function getLocalesQueues(locale) {
  return getPossibleLocales(locale).map((localeItem) => {
    const localeQueue = getLocaleQueue(localeItem);
    return [localeItem, localeQueue ? [...localeQueue] : []];
  }).filter(([, localeQueue]) => localeQueue.length > 0);
}
function hasLocaleQueue(locale) {
  if (locale == null)
    return false;
  return getPossibleLocales(locale).some(
    (localeQueue) => {
      var _a2;
      return (_a2 = getLocaleQueue(localeQueue)) == null ? void 0 : _a2.size;
    }
  );
}
function loadLocaleQueue(locale, localeQueue) {
  const allLoadersPromise = Promise.all(
    localeQueue.map((loader) => {
      removeLoaderFromQueue(locale, loader);
      return loader().then((partial) => partial.default || partial);
    })
  );
  return allLoadersPromise.then((partials) => addMessages(locale, ...partials));
}
const activeFlushes = {};
function flush(locale) {
  if (!hasLocaleQueue(locale)) {
    if (locale in activeFlushes) {
      return activeFlushes[locale];
    }
    return Promise.resolve();
  }
  const queues = getLocalesQueues(locale);
  activeFlushes[locale] = Promise.all(
    queues.map(
      ([localeName, localeQueue]) => loadLocaleQueue(localeName, localeQueue)
    )
  ).then(() => {
    if (hasLocaleQueue(locale)) {
      return flush(locale);
    }
    delete activeFlushes[locale];
  });
  return activeFlushes[locale];
}
var __getOwnPropSymbols$2 = Object.getOwnPropertySymbols;
var __hasOwnProp$2 = Object.prototype.hasOwnProperty;
var __propIsEnum$2 = Object.prototype.propertyIsEnumerable;
var __objRest$1 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2)
    for (var prop of __getOwnPropSymbols$2(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultFormats = {
  number: {
    scientific: { notation: "scientific" },
    engineering: { notation: "engineering" },
    compactLong: { notation: "compact", compactDisplay: "long" },
    compactShort: { notation: "compact", compactDisplay: "short" }
  },
  date: {
    short: { month: "numeric", day: "numeric", year: "2-digit" },
    medium: { month: "short", day: "numeric", year: "numeric" },
    long: { month: "long", day: "numeric", year: "numeric" },
    full: { weekday: "long", month: "long", day: "numeric", year: "numeric" }
  },
  time: {
    short: { hour: "numeric", minute: "numeric" },
    medium: { hour: "numeric", minute: "numeric", second: "numeric" },
    long: {
      hour: "numeric",
      minute: "numeric",
      second: "numeric",
      timeZoneName: "short"
    },
    full: {
      hour: "numeric",
      minute: "numeric",
      second: "numeric",
      timeZoneName: "short"
    }
  }
};
function defaultMissingKeyHandler({ locale, id }) {
  console.warn(
    `[svelte-i18n] The message "${id}" was not found in "${getPossibleLocales(
      locale
    ).join('", "')}".${hasLocaleQueue(getCurrentLocale()) ? `

Note: there are at least one loader still registered to this locale that wasn't executed.` : ""}`
  );
}
const defaultOptions = {
  fallbackLocale: null,
  loadingDelay: 200,
  formats: defaultFormats,
  warnOnMissingMessages: true,
  handleMissingMessage: void 0,
  ignoreTag: true
};
const options = defaultOptions;
function getOptions() {
  return options;
}
function init(opts) {
  const _a2 = opts, { formats } = _a2, rest = __objRest$1(_a2, ["formats"]);
  let initialLocale = opts.fallbackLocale;
  if (opts.initialLocale) {
    try {
      if (IntlMessageFormat.resolveLocale(opts.initialLocale)) {
        initialLocale = opts.initialLocale;
      }
    } catch (e) {
      console.warn(
        `[svelte-i18n] The initial locale "${opts.initialLocale}" is not a valid locale.`
      );
    }
  }
  if (rest.warnOnMissingMessages) {
    delete rest.warnOnMissingMessages;
    if (rest.handleMissingMessage == null) {
      rest.handleMissingMessage = defaultMissingKeyHandler;
    } else {
      console.warn(
        '[svelte-i18n] The "warnOnMissingMessages" option is deprecated. Please use the "handleMissingMessage" option instead.'
      );
    }
  }
  Object.assign(options, rest, { initialLocale });
  if (formats) {
    if ("number" in formats) {
      Object.assign(options.formats.number, formats.number);
    }
    if ("date" in formats) {
      Object.assign(options.formats.date, formats.date);
    }
    if ("time" in formats) {
      Object.assign(options.formats.time, formats.time);
    }
  }
  return $locale.set(initialLocale);
}
const $isLoading = writable(false);
var __defProp$1 = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1 = Object.getOwnPropertySymbols;
var __hasOwnProp$1 = Object.prototype.hasOwnProperty;
var __propIsEnum$1 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1 = (obj, key, value) => key in obj ? __defProp$1(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1.call(b, prop))
      __defNormalProp$1(a, prop, b[prop]);
  if (__getOwnPropSymbols$1)
    for (var prop of __getOwnPropSymbols$1(b)) {
      if (__propIsEnum$1.call(b, prop))
        __defNormalProp$1(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
let current;
const internalLocale = writable(null);
function getSubLocales(refLocale) {
  return refLocale.split("-").map((_, i, arr) => arr.slice(0, i + 1).join("-")).reverse();
}
function getPossibleLocales(refLocale, fallbackLocale = getOptions().fallbackLocale) {
  const locales = getSubLocales(refLocale);
  if (fallbackLocale) {
    return [.../* @__PURE__ */ new Set([...locales, ...getSubLocales(fallbackLocale)])];
  }
  return locales;
}
function getCurrentLocale() {
  return current != null ? current : void 0;
}
internalLocale.subscribe((newLocale) => {
  current = newLocale != null ? newLocale : void 0;
  if (typeof window !== "undefined" && newLocale != null) {
    document.documentElement.setAttribute("lang", newLocale);
  }
});
const set = (newLocale) => {
  if (newLocale && getClosestAvailableLocale(newLocale) && hasLocaleQueue(newLocale)) {
    const { loadingDelay } = getOptions();
    let loadingTimer;
    if (typeof window !== "undefined" && getCurrentLocale() != null && loadingDelay) {
      loadingTimer = window.setTimeout(
        () => $isLoading.set(true),
        loadingDelay
      );
    } else {
      $isLoading.set(true);
    }
    return flush(newLocale).then(() => {
      internalLocale.set(newLocale);
    }).finally(() => {
      clearTimeout(loadingTimer);
      $isLoading.set(false);
    });
  }
  return internalLocale.set(newLocale);
};
const $locale = __spreadProps(__spreadValues$1({}, internalLocale), {
  set
});
const getLocaleFromNavigator = () => {
  if (typeof window === "undefined")
    return null;
  return window.navigator.language || window.navigator.languages[0];
};
const monadicMemoize = (fn2) => {
  const cache = /* @__PURE__ */ Object.create(null);
  const memoizedFn = (arg) => {
    const cacheKey = JSON.stringify(arg);
    if (cacheKey in cache) {
      return cache[cacheKey];
    }
    return cache[cacheKey] = fn2(arg);
  };
  return memoizedFn;
};
var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getIntlFormatterOptions = (type, name) => {
  const { formats } = getOptions();
  if (type in formats && name in formats[type]) {
    return formats[type][name];
  }
  throw new Error(`[svelte-i18n] Unknown "${name}" ${type} format.`);
};
const createNumberFormatter = monadicMemoize(
  (_a2) => {
    var _b = _a2, { locale, format } = _b, options2 = __objRest(_b, ["locale", "format"]);
    if (locale == null) {
      throw new Error('[svelte-i18n] A "locale" must be set to format numbers');
    }
    if (format) {
      options2 = getIntlFormatterOptions("number", format);
    }
    return new Intl.NumberFormat(locale, options2);
  }
);
const createDateFormatter = monadicMemoize(
  (_c) => {
    var _d = _c, { locale, format } = _d, options2 = __objRest(_d, ["locale", "format"]);
    if (locale == null) {
      throw new Error('[svelte-i18n] A "locale" must be set to format dates');
    }
    if (format) {
      options2 = getIntlFormatterOptions("date", format);
    } else if (Object.keys(options2).length === 0) {
      options2 = getIntlFormatterOptions("date", "short");
    }
    return new Intl.DateTimeFormat(locale, options2);
  }
);
const createTimeFormatter = monadicMemoize(
  (_e) => {
    var _f = _e, { locale, format } = _f, options2 = __objRest(_f, ["locale", "format"]);
    if (locale == null) {
      throw new Error(
        '[svelte-i18n] A "locale" must be set to format time values'
      );
    }
    if (format) {
      options2 = getIntlFormatterOptions("time", format);
    } else if (Object.keys(options2).length === 0) {
      options2 = getIntlFormatterOptions("time", "short");
    }
    return new Intl.DateTimeFormat(locale, options2);
  }
);
const getNumberFormatter = (_g = {}) => {
  var _h = _g, {
    locale = getCurrentLocale()
  } = _h, args = __objRest(_h, [
    "locale"
  ]);
  return createNumberFormatter(__spreadValues({ locale }, args));
};
const getDateFormatter = (_i = {}) => {
  var _j = _i, {
    locale = getCurrentLocale()
  } = _j, args = __objRest(_j, [
    "locale"
  ]);
  return createDateFormatter(__spreadValues({ locale }, args));
};
const getTimeFormatter = (_k = {}) => {
  var _l = _k, {
    locale = getCurrentLocale()
  } = _l, args = __objRest(_l, [
    "locale"
  ]);
  return createTimeFormatter(__spreadValues({ locale }, args));
};
const getMessageFormatter = monadicMemoize(
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  (message, locale = getCurrentLocale()) => new IntlMessageFormat(message, locale, getOptions().formats, {
    ignoreTag: getOptions().ignoreTag
  })
);
const formatMessage = (id, options2 = {}) => {
  var _a2, _b, _c, _d;
  let messageObj = options2;
  if (typeof id === "object") {
    messageObj = id;
    id = messageObj.id;
  }
  const {
    values,
    locale = getCurrentLocale(),
    default: defaultValue
  } = messageObj;
  if (locale == null) {
    throw new Error(
      "[svelte-i18n] Cannot format a message without first setting the initial locale."
    );
  }
  let message = lookup(id, locale);
  if (!message) {
    message = (_d = (_c = (_b = (_a2 = getOptions()).handleMissingMessage) == null ? void 0 : _b.call(_a2, { locale, id, defaultValue })) != null ? _c : defaultValue) != null ? _d : id;
  } else if (typeof message !== "string") {
    console.warn(
      `[svelte-i18n] Message with id "${id}" must be of type "string", found: "${typeof message}". Gettin its value through the "$format" method is deprecated; use the "json" method instead.`
    );
    return message;
  }
  if (!values) {
    return message;
  }
  let result = message;
  try {
    result = getMessageFormatter(message, locale).format(values);
  } catch (e) {
    if (e instanceof Error) {
      console.warn(
        `[svelte-i18n] Message "${id}" has syntax error:`,
        e.message
      );
    }
  }
  return result;
};
const formatTime = (t, options2) => {
  return getTimeFormatter(options2).format(t);
};
const formatDate = (d, options2) => {
  return getDateFormatter(options2).format(d);
};
const formatNumber = (n, options2) => {
  return getNumberFormatter(options2).format(n);
};
const getJSON = (id, locale = getCurrentLocale()) => {
  return lookup(id, locale);
};
const $format = derived([$locale, $dictionary], () => formatMessage);
derived([$locale], () => formatTime);
derived([$locale], () => formatDate);
derived([$locale], () => formatNumber);
derived([$locale, $dictionary], () => getJSON);
const css$j$1 = {
  code: ".nav-holder.svelte-n2mxwf.svelte-n2mxwf{padding:var(--size-2) 0;border-bottom:solid 1px var(--border-color-primary)}nav.svelte-n2mxwf.svelte-n2mxwf{display:flex;flex-wrap:wrap;gap:var(--size-2);justify-content:flex-end;margin:0 auto;padding:0 var(--size-8)}nav.svelte-n2mxwf a.svelte-n2mxwf,button.svelte-n2mxwf.svelte-n2mxwf{padding:var(--size-1) var(--size-2);border-radius:var(--block-radius);border-width:var(--block-border-width);border-color:transparent;color:var(--body-text-color-subdued)}nav.svelte-n2mxwf a.active.svelte-n2mxwf,button.active.svelte-n2mxwf.svelte-n2mxwf{color:var(--body-text-color);border-color:var(--block-border-color);background-color:var(--block-background-fill)}.gradio-container-5-35-0.svelte-n2mxwf.svelte-n2mxwf{display:flex;position:relative;flex-direction:column;padding:0;min-height:1px;overflow:hidden;color:var(--button-secondary-text-color)}.embed-container.svelte-n2mxwf.svelte-n2mxwf{margin:var(--size-4) 0px;border:1px solid var(--button-secondary-border-color);border-radius:var(--embed-radius)}.with-info.svelte-n2mxwf.svelte-n2mxwf{padding-bottom:var(--size-7)}.embed-container.svelte-n2mxwf>main.svelte-n2mxwf{padding:var(--size-4)}main.svelte-n2mxwf.svelte-n2mxwf{display:flex;flex-grow:1;flex-direction:column}.app.svelte-n2mxwf.svelte-n2mxwf{position:relative;margin:auto;padding:var(--size-4) var(--size-8);width:100%;height:100%}@media(min-width: 640px){.fillable.svelte-n2mxwf.svelte-n2mxwf:not(.fill_width){max-width:640px}}@media(min-width: 768px){.fillable.svelte-n2mxwf.svelte-n2mxwf:not(.fill_width){max-width:768px}}@media(min-width: 1024px){.fillable.svelte-n2mxwf.svelte-n2mxwf:not(.fill_width){max-width:1024px}}@media(min-width: 1280px){.fillable.svelte-n2mxwf.svelte-n2mxwf:not(.fill_width){max-width:1280px}}@media(min-width: 1536px){.fillable.svelte-n2mxwf.svelte-n2mxwf:not(.fill_width){max-width:1536px}}@media(min-width: 1920px){.fillable.svelte-n2mxwf.svelte-n2mxwf:not(.fill_width){max-width:1920px}}.info.svelte-n2mxwf.svelte-n2mxwf{display:flex;position:absolute;bottom:0;justify-content:flex-start;border-top:1px solid var(--button-secondary-border-color);padding:var(--size-1) var(--size-5);width:100%;color:var(--body-text-color-subdued);font-size:var(--text-md);white-space:nowrap}.info.svelte-n2mxwf>span.svelte-n2mxwf{word-wrap:break-word;-break:keep-all;display:block;word-break:keep-all}.info.svelte-n2mxwf>span.svelte-n2mxwf:nth-child(1){margin-right:4px;min-width:0px;max-width:max-content;overflow:hidden;color:var(--body-text-color);text-overflow:ellipsis;white-space:nowrap}.info.svelte-n2mxwf>span.svelte-n2mxwf:nth-child(2){margin-right:3px}.info.svelte-n2mxwf>span.svelte-n2mxwf:nth-child(2),.info.svelte-n2mxwf>span.svelte-n2mxwf:nth-child(3){width:max-content}.info.svelte-n2mxwf>span.svelte-n2mxwf:nth-child(3){align-self:flex-end;justify-self:flex-end;margin-left:auto;text-align:right}.info.svelte-n2mxwf>span.svelte-n2mxwf:nth-child(1){flex-shrink:9}.hidden-title.svelte-n2mxwf.svelte-n2mxwf{position:absolute;left:var(--size-5);opacity:0;background:var(--button-secondary-background-fill);padding-right:4px}.info.svelte-n2mxwf a.svelte-n2mxwf{color:var(--body-text-color)}.title.svelte-n2mxwf.svelte-n2mxwf{font-size:var(--text-sm);font-family:var(--font-mono)}.hf.svelte-n2mxwf.svelte-n2mxwf{margin-left:5px}.space-logo.svelte-n2mxwf img.svelte-n2mxwf{display:inline-block;margin-bottom:4px;height:12px}main.svelte-n2mxwf a.svelte-n2mxwf:hover{text-decoration:underline}",
  map: '{"version":3,"file":"Embed.svelte","sources":["Embed.svelte"],"sourcesContent":["<script lang=\\"ts\\">import { getContext } from \\"svelte\\";\\nimport space_logo from \\"./images/spaces.svg\\";\\nimport { _ } from \\"svelte-i18n\\";\\nexport let wrapper;\\nexport let version;\\nexport let initial_height;\\nexport let fill_width;\\nexport let is_embed;\\nexport let is_lite;\\nexport let space;\\nexport let display;\\nexport let info;\\nexport let loaded;\\nexport let pages = [];\\nexport let current_page = \\"\\";\\nexport let root;\\nconst set_page = getContext(\\"set_lite_page\\");\\n<\/script>\\n\\n<div\\n\\tbind:this={wrapper}\\n\\tclass:fill_width\\n\\tclass:embed-container={display}\\n\\tclass:with-info={info}\\n\\tclass=\\"gradio-container gradio-container-{version}\\"\\n\\tstyle:min-height={loaded ? \\"initial\\" : initial_height}\\n\\tstyle:flex-grow={!display ? \\"1\\" : \\"auto\\"}\\n\\tdata-iframe-height\\n>\\n\\t{#if pages.length > 1}\\n\\t\\t<div class=\\"nav-holder\\">\\n\\t\\t\\t<nav class=\\"fillable\\" class:fill_width>\\n\\t\\t\\t\\t{#each pages as [route, label], i}\\n\\t\\t\\t\\t\\t{#if is_lite}\\n\\t\\t\\t\\t\\t\\t<button\\n\\t\\t\\t\\t\\t\\t\\tclass:active={route === current_page}\\n\\t\\t\\t\\t\\t\\t\\ton:click={(e) => {\\n\\t\\t\\t\\t\\t\\t\\t\\te.preventDefault();\\n\\t\\t\\t\\t\\t\\t\\t\\tset_page?.(route);\\n\\t\\t\\t\\t\\t\\t\\t}}\\n\\t\\t\\t\\t\\t\\t\\t>{label}\\n\\t\\t\\t\\t\\t\\t</button>\\n\\t\\t\\t\\t\\t{:else}\\n\\t\\t\\t\\t\\t\\t<a\\n\\t\\t\\t\\t\\t\\t\\thref={`${root}/${route}`}\\n\\t\\t\\t\\t\\t\\t\\tclass:active={route === current_page}\\n\\t\\t\\t\\t\\t\\t\\tdata-sveltekit-reload\\n\\t\\t\\t\\t\\t\\t\\t>{label}\\n\\t\\t\\t\\t\\t\\t</a>\\n\\t\\t\\t\\t\\t{/if}\\n\\t\\t\\t\\t{/each}\\n\\t\\t\\t</nav>\\n\\t\\t</div>\\n\\t{/if}\\n\\t<main class=\\"fillable\\" class:fill_width class:app={!display && !is_embed}>\\n\\t\\t<slot />\\n\\t\\t<div>\\n\\t\\t\\t{#if display && space && info}\\n\\t\\t\\t\\t<div class=\\"info\\">\\n\\t\\t\\t\\t\\t<span>\\n\\t\\t\\t\\t\\t\\t<a href=\\"https://huggingface.co/spaces/{space}\\" class=\\"title\\"\\n\\t\\t\\t\\t\\t\\t\\t>{space}</a\\n\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t</span>\\n\\t\\t\\t\\t\\t<span>\\n\\t\\t\\t\\t\\t\\t{$_(\\"common.built_with\\")}\\n\\t\\t\\t\\t\\t\\t<a class=\\"gradio\\" href=\\"https://gradio.app\\">Gradio</a>.\\n\\t\\t\\t\\t\\t</span>\\n\\t\\t\\t\\t\\t<span>\\n\\t\\t\\t\\t\\t\\t{$_(\\"common.hosted_on\\")}\\n\\t\\t\\t\\t\\t\\t<a class=\\"hf\\" href=\\"https://huggingface.co/spaces\\"\\n\\t\\t\\t\\t\\t\\t\\t><span class=\\"space-logo\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t<img src={space_logo} alt=\\"Hugging Face Space\\" />\\n\\t\\t\\t\\t\\t\\t\\t</span> Spaces</a\\n\\t\\t\\t\\t\\t\\t>\\n\\t\\t\\t\\t\\t</span>\\n\\t\\t\\t\\t</div>\\n\\t\\t\\t{/if}\\n\\t\\t</div>\\n\\t</main>\\n</div>\\n\\n<style>\\n\\t.nav-holder {\\n\\t\\tpadding: var(--size-2) 0;\\n\\t\\tborder-bottom: solid 1px var(--border-color-primary);\\n\\t}\\n\\tnav {\\n\\t\\tdisplay: flex;\\n\\t\\tflex-wrap: wrap;\\n\\t\\tgap: var(--size-2);\\n\\t\\tjustify-content: flex-end;\\n\\t\\tmargin: 0 auto;\\n\\t\\tpadding: 0 var(--size-8);\\n\\t}\\n\\tnav a,\\n\\tbutton {\\n\\t\\tpadding: var(--size-1) var(--size-2);\\n\\t\\tborder-radius: var(--block-radius);\\n\\t\\tborder-width: var(--block-border-width);\\n\\t\\tborder-color: transparent;\\n\\t\\tcolor: var(--body-text-color-subdued);\\n\\t}\\n\\tnav a.active,\\n\\tbutton.active {\\n\\t\\tcolor: var(--body-text-color);\\n\\t\\tborder-color: var(--block-border-color);\\n\\t\\tbackground-color: var(--block-background-fill);\\n\\t}\\n\\t.gradio-container-5-35-0 {\\n\\t\\tdisplay: flex;\\n\\t\\tposition: relative;\\n\\t\\tflex-direction: column;\\n\\t\\tpadding: 0;\\n\\t\\tmin-height: 1px;\\n\\t\\toverflow: hidden;\\n\\t\\tcolor: var(--button-secondary-text-color);\\n\\t}\\n\\n\\t.embed-container {\\n\\t\\tmargin: var(--size-4) 0px;\\n\\t\\tborder: 1px solid var(--button-secondary-border-color);\\n\\t\\tborder-radius: var(--embed-radius);\\n\\t}\\n\\n\\t.with-info {\\n\\t\\tpadding-bottom: var(--size-7);\\n\\t}\\n\\n\\t.embed-container > main {\\n\\t\\tpadding: var(--size-4);\\n\\t}\\n\\n\\tmain {\\n\\t\\tdisplay: flex;\\n\\t\\tflex-grow: 1;\\n\\t\\tflex-direction: column;\\n\\t}\\n\\n\\t.app {\\n\\t\\tposition: relative;\\n\\t\\tmargin: auto;\\n\\t\\tpadding: var(--size-4) var(--size-8);\\n\\t\\twidth: 100%;\\n\\t\\theight: 100%;\\n\\t}\\n\\n\\t@media (min-width: 640px) {\\n\\t\\t.fillable:not(.fill_width) {\\n\\t\\t\\tmax-width: 640px;\\n\\t\\t}\\n\\t}\\n\\t@media (min-width: 768px) {\\n\\t\\t.fillable:not(.fill_width) {\\n\\t\\t\\tmax-width: 768px;\\n\\t\\t}\\n\\t}\\n\\t@media (min-width: 1024px) {\\n\\t\\t.fillable:not(.fill_width) {\\n\\t\\t\\tmax-width: 1024px;\\n\\t\\t}\\n\\t}\\n\\t@media (min-width: 1280px) {\\n\\t\\t.fillable:not(.fill_width) {\\n\\t\\t\\tmax-width: 1280px;\\n\\t\\t}\\n\\t}\\n\\t@media (min-width: 1536px) {\\n\\t\\t.fillable:not(.fill_width) {\\n\\t\\t\\tmax-width: 1536px;\\n\\t\\t}\\n\\t}\\n\\t@media (min-width: 1920px) {\\n\\t\\t.fillable:not(.fill_width) {\\n\\t\\t\\tmax-width: 1920px;\\n\\t\\t}\\n\\t}\\n\\n\\t.info {\\n\\t\\tdisplay: flex;\\n\\t\\tposition: absolute;\\n\\t\\tbottom: 0;\\n\\t\\tjustify-content: flex-start;\\n\\t\\tborder-top: 1px solid var(--button-secondary-border-color);\\n\\t\\tpadding: var(--size-1) var(--size-5);\\n\\t\\twidth: 100%;\\n\\t\\tcolor: var(--body-text-color-subdued);\\n\\t\\tfont-size: var(--text-md);\\n\\t\\twhite-space: nowrap;\\n\\t}\\n\\n\\t.info > span {\\n\\t\\tword-wrap: break-word;\\n\\t\\t-break: keep-all;\\n\\t\\tdisplay: block;\\n\\t\\tword-break: keep-all;\\n\\t}\\n\\n\\t.info > span:nth-child(1) {\\n\\t\\tmargin-right: 4px;\\n\\t\\tmin-width: 0px;\\n\\t\\tmax-width: max-content;\\n\\t\\toverflow: hidden;\\n\\t\\tcolor: var(--body-text-color);\\n\\t\\ttext-overflow: ellipsis;\\n\\t\\twhite-space: nowrap;\\n\\t}\\n\\n\\t.info > span:nth-child(2) {\\n\\t\\tmargin-right: 3px;\\n\\t}\\n\\n\\t.info > span:nth-child(2),\\n\\t.info > span:nth-child(3) {\\n\\t\\twidth: max-content;\\n\\t}\\n\\n\\t.info > span:nth-child(3) {\\n\\t\\talign-self: flex-end;\\n\\t\\tjustify-self: flex-end;\\n\\t\\tmargin-left: auto;\\n\\t\\ttext-align: right;\\n\\t}\\n\\n\\t.info > span:nth-child(1) {\\n\\t\\tflex-shrink: 9;\\n\\t}\\n\\n\\t.hidden-title {\\n\\t\\tposition: absolute;\\n\\t\\tleft: var(--size-5);\\n\\t\\topacity: 0;\\n\\t\\tbackground: var(--button-secondary-background-fill);\\n\\t\\tpadding-right: 4px;\\n\\t}\\n\\n\\t.info a {\\n\\t\\tcolor: var(--body-text-color);\\n\\t}\\n\\n\\t.title {\\n\\t\\tfont-size: var(--text-sm);\\n\\t\\tfont-family: var(--font-mono);\\n\\t}\\n\\n\\t.hf {\\n\\t\\tmargin-left: 5px;\\n\\t}\\n\\n\\t.space-logo img {\\n\\t\\tdisplay: inline-block;\\n\\t\\tmargin-bottom: 4px;\\n\\t\\theight: 12px;\\n\\t}\\n\\n\\tmain a:hover {\\n\\t\\ttext-decoration: underline;\\n\\t}</style>\\n"],"names":[],"mappings":"AAmFC,uCAAY,CACX,OAAO,CAAE,IAAI,QAAQ,CAAC,CAAC,CAAC,CACxB,aAAa,CAAE,KAAK,CAAC,GAAG,CAAC,IAAI,sBAAsB,CACpD,CACA,+BAAI,CACH,OAAO,CAAE,IAAI,CACb,SAAS,CAAE,IAAI,CACf,GAAG,CAAE,IAAI,QAAQ,CAAC,CAClB,eAAe,CAAE,QAAQ,CACzB,MAAM,CAAE,CAAC,CAAC,IAAI,CACd,OAAO,CAAE,CAAC,CAAC,IAAI,QAAQ,CACxB,CACA,iBAAG,CAAC,eAAC,CACL,kCAAO,CACN,OAAO,CAAE,IAAI,QAAQ,CAAC,CAAC,IAAI,QAAQ,CAAC,CACpC,aAAa,CAAE,IAAI,cAAc,CAAC,CAClC,YAAY,CAAE,IAAI,oBAAoB,CAAC,CACvC,YAAY,CAAE,WAAW,CACzB,KAAK,CAAE,IAAI,yBAAyB,CACrC,CACA,iBAAG,CAAC,CAAC,qBAAO,CACZ,MAAM,mCAAQ,CACb,KAAK,CAAE,IAAI,iBAAiB,CAAC,CAC7B,YAAY,CAAE,IAAI,oBAAoB,CAAC,CACvC,gBAAgB,CAAE,IAAI,uBAAuB,CAC9C,CACA,oDAAyB,CACxB,OAAO,CAAE,IAAI,CACb,QAAQ,CAAE,QAAQ,CAClB,cAAc,CAAE,MAAM,CACtB,OAAO,CAAE,CAAC,CACV,UAAU,CAAE,GAAG,CACf,QAAQ,CAAE,MAAM,CAChB,KAAK,CAAE,IAAI,6BAA6B,CACzC,CAEA,4CAAiB,CAChB,MAAM,CAAE,IAAI,QAAQ,CAAC,CAAC,GAAG,CACzB,MAAM,CAAE,GAAG,CAAC,KAAK,CAAC,IAAI,+BAA+B,CAAC,CACtD,aAAa,CAAE,IAAI,cAAc,CAClC,CAEA,sCAAW,CACV,cAAc,CAAE,IAAI,QAAQ,CAC7B,CAEA,8BAAgB,CAAG,kBAAK,CACvB,OAAO,CAAE,IAAI,QAAQ,CACtB,CAEA,gCAAK,CACJ,OAAO,CAAE,IAAI,CACb,SAAS,CAAE,CAAC,CACZ,cAAc,CAAE,MACjB,CAEA,gCAAK,CACJ,QAAQ,CAAE,QAAQ,CAClB,MAAM,CAAE,IAAI,CACZ,OAAO,CAAE,IAAI,QAAQ,CAAC,CAAC,IAAI,QAAQ,CAAC,CACpC,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IACT,CAEA,MAAO,YAAY,KAAK,CAAE,CACzB,qCAAS,KAAK,WAAW,CAAE,CAC1B,SAAS,CAAE,KACZ,CACD,CACA,MAAO,YAAY,KAAK,CAAE,CACzB,qCAAS,KAAK,WAAW,CAAE,CAC1B,SAAS,CAAE,KACZ,CACD,CACA,MAAO,YAAY,MAAM,CAAE,CAC1B,qCAAS,KAAK,WAAW,CAAE,CAC1B,SAAS,CAAE,MACZ,CACD,CACA,MAAO,YAAY,MAAM,CAAE,CAC1B,qCAAS,KAAK,WAAW,CAAE,CAC1B,SAAS,CAAE,MACZ,CACD,CACA,MAAO,YAAY,MAAM,CAAE,CAC1B,qCAAS,KAAK,WAAW,CAAE,CAC1B,SAAS,CAAE,MACZ,CACD,CACA,MAAO,YAAY,MAAM,CAAE,CAC1B,qCAAS,KAAK,WAAW,CAAE,CAC1B,SAAS,CAAE,MACZ,CACD,CAEA,iCAAM,CACL,OAAO,CAAE,IAAI,CACb,QAAQ,CAAE,QAAQ,CAClB,MAAM,CAAE,CAAC,CACT,eAAe,CAAE,UAAU,CAC3B,UAAU,CAAE,GAAG,CAAC,KAAK,CAAC,IAAI,+BAA+B,CAAC,CAC1D,OAAO,CAAE,IAAI,QAAQ,CAAC,CAAC,IAAI,QAAQ,CAAC,CACpC,KAAK,CAAE,IAAI,CACX,KAAK,CAAE,IAAI,yBAAyB,CAAC,CACrC,SAAS,CAAE,IAAI,SAAS,CAAC,CACzB,WAAW,CAAE,MACd,CAEA,mBAAK,CAAG,kBAAK,CACZ,SAAS,CAAE,UAAU,CACrB,MAAM,CAAE,QAAQ,CAChB,OAAO,CAAE,KAAK,CACd,UAAU,CAAE,QACb,CAEA,mBAAK,CAAG,kBAAI,WAAW,CAAC,CAAE,CACzB,YAAY,CAAE,GAAG,CACjB,SAAS,CAAE,GAAG,CACd,SAAS,CAAE,WAAW,CACtB,QAAQ,CAAE,MAAM,CAChB,KAAK,CAAE,IAAI,iBAAiB,CAAC,CAC7B,aAAa,CAAE,QAAQ,CACvB,WAAW,CAAE,MACd,CAEA,mBAAK,CAAG,kBAAI,WAAW,CAAC,CAAE,CACzB,YAAY,CAAE,GACf,CAEA,mBAAK,CAAG,kBAAI,WAAW,CAAC,CAAC,CACzB,mBAAK,CAAG,kBAAI,WAAW,CAAC,CAAE,CACzB,KAAK,CAAE,WACR,CAEA,mBAAK,CAAG,kBAAI,WAAW,CAAC,CAAE,CACzB,UAAU,CAAE,QAAQ,CACpB,YAAY,CAAE,QAAQ,CACtB,WAAW,CAAE,IAAI,CACjB,UAAU,CAAE,KACb,CAEA,mBAAK,CAAG,kBAAI,WAAW,CAAC,CAAE,CACzB,WAAW,CAAE,CACd,CAEA,yCAAc,CACb,QAAQ,CAAE,QAAQ,CAClB,IAAI,CAAE,IAAI,QAAQ,CAAC,CACnB,OAAO,CAAE,CAAC,CACV,UAAU,CAAE,IAAI,kCAAkC,CAAC,CACnD,aAAa,CAAE,GAChB,CAEA,mBAAK,CAAC,eAAE,CACP,KAAK,CAAE,IAAI,iBAAiB,CAC7B,CAEA,kCAAO,CACN,SAAS,CAAE,IAAI,SAAS,CAAC,CACzB,WAAW,CAAE,IAAI,WAAW,CAC7B,CAEA,+BAAI,CACH,WAAW,CAAE,GACd,CAEA,yBAAW,CAAC,iBAAI,CACf,OAAO,CAAE,YAAY,CACrB,aAAa,CAAE,GAAG,CAClB,MAAM,CAAE,IACT,CAEA,kBAAI,CAAC,eAAC,MAAO,CACZ,eAAe,CAAE,SAClB"}'
};
const Embed = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $_, $$unsubscribe__;
  $$unsubscribe__ = subscribe($format, (value) => $_ = value);
  let { wrapper } = $$props;
  let { version } = $$props;
  let { initial_height } = $$props;
  let { fill_width } = $$props;
  let { is_embed } = $$props;
  let { is_lite } = $$props;
  let { space } = $$props;
  let { display } = $$props;
  let { info } = $$props;
  let { loaded } = $$props;
  let { pages = [] } = $$props;
  let { current_page = "" } = $$props;
  let { root } = $$props;
  getContext("set_lite_page");
  if ($$props.wrapper === void 0 && $$bindings.wrapper && wrapper !== void 0)
    $$bindings.wrapper(wrapper);
  if ($$props.version === void 0 && $$bindings.version && version !== void 0)
    $$bindings.version(version);
  if ($$props.initial_height === void 0 && $$bindings.initial_height && initial_height !== void 0)
    $$bindings.initial_height(initial_height);
  if ($$props.fill_width === void 0 && $$bindings.fill_width && fill_width !== void 0)
    $$bindings.fill_width(fill_width);
  if ($$props.is_embed === void 0 && $$bindings.is_embed && is_embed !== void 0)
    $$bindings.is_embed(is_embed);
  if ($$props.is_lite === void 0 && $$bindings.is_lite && is_lite !== void 0)
    $$bindings.is_lite(is_lite);
  if ($$props.space === void 0 && $$bindings.space && space !== void 0)
    $$bindings.space(space);
  if ($$props.display === void 0 && $$bindings.display && display !== void 0)
    $$bindings.display(display);
  if ($$props.info === void 0 && $$bindings.info && info !== void 0)
    $$bindings.info(info);
  if ($$props.loaded === void 0 && $$bindings.loaded && loaded !== void 0)
    $$bindings.loaded(loaded);
  if ($$props.pages === void 0 && $$bindings.pages && pages !== void 0)
    $$bindings.pages(pages);
  if ($$props.current_page === void 0 && $$bindings.current_page && current_page !== void 0)
    $$bindings.current_page(current_page);
  if ($$props.root === void 0 && $$bindings.root && root !== void 0)
    $$bindings.root(root);
  $$result.css.add(css$j$1);
  $$unsubscribe__();
  return `<div class="${[
    "gradio-container gradio-container-" + escape$4(version, true) + " svelte-n2mxwf",
    (fill_width ? "fill_width" : "") + " " + (display ? "embed-container" : "") + " " + (info ? "with-info" : "")
  ].join(" ").trim()}" data-iframe-height${add_styles({
    "min-height": loaded ? "initial" : initial_height,
    "flex-grow": !display ? "1" : "auto"
  })}${add_attribute("this", wrapper, 0)}>${pages.length > 1 ? `<div class="nav-holder svelte-n2mxwf"><nav class="${["fillable svelte-n2mxwf", fill_width ? "fill_width" : ""].join(" ").trim()}">${each$1(pages, ([route, label2], i) => {
    return `${is_lite ? `<button class="${["svelte-n2mxwf", route === current_page ? "active" : ""].join(" ").trim()}">${escape$4(label2)} </button>` : `<a${add_attribute("href", `${root}/${route}`, 0)} data-sveltekit-reload class="${["svelte-n2mxwf", route === current_page ? "active" : ""].join(" ").trim()}">${escape$4(label2)} </a>`}`;
  })}</nav></div>` : ``} <main class="${[
    "fillable svelte-n2mxwf",
    (fill_width ? "fill_width" : "") + " " + (!display && !is_embed ? "app" : "")
  ].join(" ").trim()}">${slots.default ? slots.default({}) : ``} <div>${display && space && info ? `<div class="info svelte-n2mxwf"><span class="svelte-n2mxwf"><a href="${"https://huggingface.co/spaces/" + escape$4(space, true)}" class="title svelte-n2mxwf">${escape$4(space)}</a></span> <span class="svelte-n2mxwf">${escape$4($_("common.built_with"))} <a class="gradio svelte-n2mxwf" href="https://gradio.app" data-svelte-h="svelte-jht9bl">Gradio</a>.</span> <span class="svelte-n2mxwf">${escape$4($_("common.hosted_on"))} <a class="hf svelte-n2mxwf" href="https://huggingface.co/spaces" data-svelte-h="svelte-d5sowi"><span class="space-logo svelte-n2mxwf"><img${add_attribute("src", space_logo, 0)} alt="Hugging Face Space" class="svelte-n2mxwf"></span> Spaces</a></span></div>` : ``}</div></main> </div>`;
});
let supports_adopted_stylesheets = false;
if (typeof window !== "undefined" && "attachShadow" in Element.prototype && "adoptedStyleSheets" in Document.prototype) {
  const shadow_root_test = document.createElement("div").attachShadow({ mode: "open" });
  supports_adopted_stylesheets = "adoptedStyleSheets" in shadow_root_test;
}
function mount_css(url, target) {
  const base = new URL(import.meta.url).origin;
  var _url = url;
  if (window.location.origin !== base) {
    _url = new URL(url, base).href;
  }
  const existing_link = document.querySelector(`link[href='${_url}']`);
  if (existing_link)
    return Promise.resolve();
  const link2 = document.createElement("link");
  link2.rel = "stylesheet";
  link2.href = _url;
  return new Promise((res, rej) => {
    link2.addEventListener("load", () => res());
    link2.addEventListener("error", () => {
      console.error(`Unable to preload CSS for ${_url}`);
      res();
    });
    target.appendChild(link2);
  });
}
function prefix_css(string, version, style_element) {
  if (!supports_adopted_stylesheets)
    return string;
  if (!style_element) {
    style_element = document.createElement("style");
  }
  style_element.remove();
  const stylesheet = new CSSStyleSheet();
  stylesheet.replaceSync(string);
  let importString = "";
  string = string.replace(/@import\s+url\((.*?)\);\s*/g, (match, url) => {
    importString += `@import url(${url});
`;
    return "";
  });
  const rules = stylesheet.cssRules;
  let css_string = "";
  let gradio_css_infix = `.gradio-container.gradio-container-${version} .contain `;
  for (let i = 0; i < rules.length; i++) {
    const rule = rules[i];
    let is_dark_rule = rule.cssText.includes(".dark");
    if (rule instanceof CSSStyleRule) {
      const selector = rule.selectorText;
      if (selector) {
        const new_selector = selector.replace(".dark", "").split(",").map(
          (s) => `${is_dark_rule ? ".dark" : ""} ${gradio_css_infix} ${s.trim()} `
        ).join(",");
        css_string += rule.cssText;
        css_string += rule.cssText.replace(selector, new_selector);
      }
    } else if (rule instanceof CSSMediaRule) {
      let mediaCssString = `@media ${rule.media.mediaText} {`;
      for (let j = 0; j < rule.cssRules.length; j++) {
        const innerRule = rule.cssRules[j];
        if (innerRule instanceof CSSStyleRule) {
          let is_dark_rule2 = innerRule.cssText.includes(".dark ");
          const selector = innerRule.selectorText;
          const new_selector = selector.replace(".dark", "").split(",").map(
            (s) => `${is_dark_rule2 ? ".dark" : ""} ${gradio_css_infix} ${s.trim()} `
          ).join(",");
          mediaCssString += innerRule.cssText.replace(selector, new_selector);
        }
      }
      mediaCssString += "}";
      css_string += mediaCssString;
    } else if (rule instanceof CSSKeyframesRule) {
      css_string += `@keyframes ${rule.name} {`;
      for (let j = 0; j < rule.cssRules.length; j++) {
        const innerRule = rule.cssRules[j];
        if (innerRule instanceof CSSKeyframeRule) {
          css_string += `${innerRule.keyText} { ${innerRule.style.cssText} }`;
        }
      }
      css_string += "}";
    } else if (rule instanceof CSSFontFaceRule) {
      css_string += `@font-face { ${rule.style.cssText} }`;
    }
  }
  return importString + css_string;
}
const component_map = {
  "accordion": {
    component: () => import('./Index38-CrKuULg5.js')
  },
  "annotatedimage": {
    component: () => import('./Index18-BFtRe80F.js')
  },
  "audio": {
    base: () => import('./StaticAudio-Dj3J7OTT.js'),
    example: () => import('./Example3-ChhbuRRh.js'),
    component: () => import('./index19-CtWue-tS.js')
  },
  "box": {
    component: () => import('./Index6-wmlKTlkP.js')
  },
  "browserstate": {
    component: () => import('./Index63-C7TTSXUc.js')
  },
  "button": {
    component: () => Promise.resolve().then(function () { return Index40; })
  },
  "chatbot": {
    component: () => import('./Index60-BzmqapZy.js')
  },
  "checkbox": {
    example: () => import('./Example4-C9pjgshT.js'),
    component: () => Promise.resolve().then(function () { return Index39; })
  },
  "checkboxgroup": {
    example: () => import('./Example5-Bxn-629i.js'),
    component: () => import('./Index20-xklTEGKp.js')
  },
  "code": {
    example: () => import('./Example6-CCSV4Q_z.js'),
    component: () => import('./Index16-BPS_NBU9.js').then((n) => n.K)
  },
  "colorpicker": {
    example: () => import('./Example7-oFTyFl-S.js'),
    component: () => import('./Index49-LYqnjpC2.js')
  },
  "column": {
    component: () => Promise.resolve().then(function () { return Index24; })
  },
  "core": {
    component: () => import('./index-CKu_rogU.js')
  },
  "dataframe": {
    example: () => import('./Example8-CQi9rL_X.js'),
    component: () => import('./Index61--sh4drWx.js')
  },
  "dataset": {
    component: () => import('./Index21-CiZiW4Gx.js')
  },
  "datetime": {
    example: () => import('./Example-C-8cAxFS.js'),
    component: () => import('./Index54-gpYn3g8M.js')
  },
  "downloadbutton": {
    component: () => import('./Index41-Eui56eCo.js')
  },
  "dropdown": {
    example: () => Promise.resolve().then(function () { return Example10; }),
    component: () => Promise.resolve().then(function () { return Index57; })
  },
  "file": {
    example: () => import('./Example12-DW0UR_n9.js'),
    component: () => import('./Index10-CZ5k4WEC.js')
  },
  "fileexplorer": {
    example: () => import('./Example13-BKLMTCm5.js'),
    component: () => import('./Index59-6UABZ9f8.js')
  },
  "form": {
    component: () => Promise.resolve().then(function () { return Index23; })
  },
  "gallery": {
    base: () => import('./Gallery-CDwAK6Yu.js'),
    component: () => import('./Index9-Bgh2nmLE.js')
  },
  "group": {
    component: () => import('./Index25-ByC6VMt3.js')
  },
  "highlightedtext": {
    component: () => import('./Index58-DwudTWaN.js')
  },
  "html": {
    base: () => import('./Index50-CfNtVWFO.js'),
    example: () => import('./Example14-D9VFfuV4.js'),
    component: () => import('./Index50-CfNtVWFO.js')
  },
  "image": {
    base: () => import('./ImagePreview-CE6xfNvA.js'),
    example: () => import('./Example11-COKkp33w.js'),
    component: () => import('./Index26-ymEQyVq4.js')
  },
  "imageeditor": {
    example: () => import('./Example15-0npWTXK2.js'),
    component: () => import('./Index3-Kx0rGZQV.js').then((n) => n.as)
  },
  "imageslider": {
    example: () => import('./Example16-k-JrRsz1.js'),
    component: () => import('./Index62-CxbFnAkg.js')
  },
  "json": {
    example: () => import('./Example17-BbB28DhW.js'),
    component: () => import('./Index11-gJKMWS9A.js')
  },
  "label": {
    component: () => import('./Index42-Dpms_QEd.js')
  },
  "markdown": {
    example: () => import('./Example18-BG1054HT.js'),
    component: () => import('./Index51-5OjiaP1g.js')
  },
  "model3d": {
    example: () => import('./Example19-ChhbuRRh.js'),
    component: () => import('./Index56-Z9sizsdW.js')
  },
  "multimodaltextbox": {
    example: () => import('./Example20-BPqQIhMx.js'),
    component: () => import('./Index43-C-myzTN3.js')
  },
  "nativeplot": {
    example: () => import('./Example2-GlHk8xMb.js'),
    component: () => import('./Index27-Bmhx7qAU.js')
  },
  "number": {
    example: () => import('./Example21-BZvRS_56.js'),
    component: () => import('./Index28-DALe59ht.js')
  },
  "paramviewer": {
    example: () => import('./Example22-Om2jn4YY.js'),
    component: () => import('./Index55-BAQfS_z5.js')
  },
  "plot": {
    base: () => import('./Plot-ByOrYSVF.js'),
    component: () => import('./Index12-GsWOBa6d.js')
  },
  "radio": {
    example: () => import('./Example23-D6vWifHP.js'),
    component: () => import('./Index52-BM0nbSPk.js')
  },
  "row": {
    component: () => import('./Index29-B5gZ2nKu.js')
  },
  "sidebar": {
    component: () => import('./Index44-DqZy1qhd.js')
  },
  "sketchbox": {
    component: () => import('./Index30-C1szKdfU.js')
  },
  "slider": {
    example: () => import('./Example24-QVi4PgT9.js'),
    component: () => import('./Index31-B-z-3jDy.js')
  },
  "state": {
    component: () => import('./Index13-ncdRc_uO.js')
  },
  "statustracker": {
    component: () => import('./index2-BZoDrbx5.js')
  },
  "tabitem": {
    component: () => import('./Index45-lZra31TB.js')
  },
  "tabs": {
    component: () => import('./Index46-z-UN4d-t.js')
  },
  "textbox": {
    example: () => Promise.resolve().then(function () { return Example9; }),
    component: () => Promise.resolve().then(function () { return Index22; })
  },
  "timer": {
    component: () => import('./Index14-NgWLaxlE.js')
  },
  "uploadbutton": {
    component: () => import('./Index47-Lz0qmQcc.js')
  },
  "video": {
    base: () => import('./VideoPreview-BAZAjQ0Z.js').then((n) => n.b),
    example: () => import('./Example25-DL3kHyhT.js'),
    component: () => import('./index53-BKriOYNI.js')
  }
};
const request_map = {};
const is_browser$2 = typeof window !== "undefined";
function load_component({ api_url, name, id, variant }) {
  const comps = is_browser$2 && window.__GRADIO__CC__;
  const _component_map = {
    // eslint-disable-next-line no-undef
    ...component_map,
    ...!comps ? {} : comps
  };
  let _id = id || name;
  if (request_map[`${_id}-${variant}`]) {
    return { component: request_map[`${_id}-${variant}`], name };
  }
  try {
    if (!_component_map?.[_id]?.[variant] && !_component_map?.[name]?.[variant])
      throw new Error();
    request_map[`${_id}-${variant}`] = (_component_map?.[_id]?.[variant] || // for dev mode custom components
    _component_map?.[name]?.[variant])();
    return {
      name,
      component: request_map[`${_id}-${variant}`]
    };
  } catch (e) {
    if (!_id)
      throw new Error(`Component not found: ${name}`);
    try {
      request_map[`${_id}-${variant}`] = get_component_with_css(
        api_url,
        _id,
        variant
      );
      return {
        name,
        component: request_map[`${_id}-${variant}`]
      };
    } catch (e2) {
      if (variant === "example") {
        request_map[`${_id}-${variant}`] = import('./Example26-QVi4PgT9.js');
        return {
          name,
          component: request_map[`${_id}-${variant}`]
        };
      }
      console.error(`failed to load: ${name}`);
      console.error(e2);
      throw e2;
    }
  }
}
function load_css(url) {
  if (!is_browser$2) {
    return Promise.resolve();
  }
  return new Promise((resolve, reject) => {
    const link2 = document.createElement("link");
    link2.rel = "stylesheet";
    link2.href = url;
    document.head.appendChild(link2);
    link2.onload = () => resolve();
    link2.onerror = () => reject();
  });
}
function get_component_with_css(api_url, id, variant) {
  const environment = is_browser$2 ? "client" : "server";
  let path2;
  if (environment === "server") {
    return Promise.all([
      load_css(`${api_url}/custom_component/${id}/${variant}/style.css`),
      import(
        /* @vite-ignore */
        './Index48-BYLty7T8.js'
      )
    ]).then(([_, module]) => {
      return module;
    });
  }
  path2 = `${api_url}/custom_component/${id}/${environment}/${variant}/index.js`;
  return Promise.all([
    load_css(`${api_url}/custom_component/${id}/${environment}/${variant}/style.css`),
    import(
      /* @vite-ignore */
      path2
    )
  ]).then(([_, module]) => {
    return module;
  });
}
function create_loading_status_store() {
  const store = writable({});
  const fn_inputs = {};
  const fn_outputs = {};
  const pending_outputs = /* @__PURE__ */ new Map();
  const pending_inputs = /* @__PURE__ */ new Map();
  const inputs_to_update = /* @__PURE__ */ new Map();
  const fn_status = {};
  function update({
    fn_index,
    status,
    queue: queue2 = true,
    size,
    position = null,
    eta = null,
    message = null,
    progress,
    time_limit = null
  }) {
    const outputs = fn_outputs[fn_index];
    const inputs = fn_inputs[fn_index];
    const last_status = fn_status[fn_index];
    const outputs_to_update = outputs.map((id) => {
      let new_status;
      const pending_count = pending_outputs.get(id) || 0;
      if (last_status === "pending" && status !== "pending") {
        let new_count = pending_count - 1;
        pending_outputs.set(id, new_count < 0 ? 0 : new_count);
        new_status = new_count > 0 ? "pending" : status;
      } else if (last_status === "pending" && status === "pending") {
        new_status = "pending";
      } else if (last_status !== "pending" && status === "pending") {
        new_status = "pending";
        pending_outputs.set(id, pending_count + 1);
      } else {
        new_status = status;
      }
      return {
        id,
        queue_position: position,
        queue_size: size,
        eta,
        status: new_status,
        message,
        progress
      };
    });
    inputs.forEach((id) => {
      const pending_count = pending_inputs.get(id) || 0;
      if (last_status === "pending" && status !== "pending") {
        let new_count = pending_count - 1;
        pending_inputs.set(id, new_count < 0 ? 0 : new_count);
        inputs_to_update.set(id, status);
      } else if (last_status !== "pending" && status === "pending") {
        pending_inputs.set(id, pending_count + 1);
        inputs_to_update.set(id, status);
      } else {
        inputs_to_update.delete(id);
      }
    });
    store.update((outputs2) => {
      outputs_to_update.forEach(
        ({
          id,
          queue_position,
          queue_size,
          eta: eta2,
          status: status2,
          message: message2,
          progress: progress2
        }) => {
          outputs2[id] = {
            queue: queue2,
            queue_size,
            queue_position,
            eta: eta2,
            message: message2,
            progress: progress2,
            status: status2,
            fn_index
          };
        }
      );
      return outputs2;
    });
    fn_status[fn_index] = status;
  }
  function register(index, inputs, outputs) {
    fn_inputs[index] = inputs;
    fn_outputs[index] = outputs;
  }
  return {
    update,
    register,
    subscribe: store.subscribe,
    get_status_for_fn(i) {
      return fn_status[i];
    },
    get_inputs_to_update() {
      return inputs_to_update;
    }
  };
}
let pending_updates = [];
const is_browser$1 = typeof window !== "undefined";
const raf$1 = is_browser$1 ? requestAnimationFrame : async (fn2) => await fn2();
function create_components(initial_layout) {
  let _component_map;
  let target_map = writable({});
  let _target_map = {};
  let inputs;
  let outputs;
  let constructor_map;
  let instance_map;
  let loading_status = create_loading_status_store();
  const layout_store = writable(initial_layout);
  let _components = [];
  let app;
  let keys_per_render_id = {};
  let _rootNode;
  function set_event_specific_args(dependencies) {
    dependencies.forEach((dep) => {
      dep.targets.forEach((target) => {
        const instance = instance_map[target[0]];
        if (instance && dep.event_specific_args?.length > 0) {
          dep.event_specific_args?.forEach((arg) => {
            instance.props[arg] = dep[arg];
          });
        }
      });
    });
  }
  async function create_layout({
    app: _app,
    components,
    layout,
    dependencies,
    root,
    options: options2
  }) {
    flush2();
    app = _app;
    if (instance_map) {
      components.forEach((c) => {
        if (c.props.value == null && c.id in instance_map) {
          c.props.value = instance_map[c.id].props.value;
        }
      });
    }
    _components = components;
    inputs = /* @__PURE__ */ new Set();
    outputs = /* @__PURE__ */ new Set();
    pending_updates = [];
    constructor_map = /* @__PURE__ */ new Map();
    _component_map = /* @__PURE__ */ new Map();
    instance_map = {};
    _rootNode = {
      id: layout.id,
      type: "column",
      props: { interactive: false, scale: options2.fill_height ? 1 : null },
      has_modes: false,
      instance: null,
      component: null,
      component_class_id: "",
      key: null
    };
    components.push(_rootNode);
    dependencies.forEach((dep) => {
      loading_status.register(
        dep.id,
        dep.inputs,
        dep.show_progress_on || dep.outputs
      );
      dep.frontend_fn = process_frontend_fn(
        dep.js,
        !!dep.backend_fn,
        dep.inputs.length,
        dep.outputs.length
      );
      create_target_meta(dep.targets, dep.id, _target_map);
      get_inputs_outputs(dep, inputs, outputs);
    });
    target_map.set(_target_map);
    constructor_map = preload_all_components(components, root);
    instance_map = components.reduce(
      (acc, c) => {
        acc[c.id] = c;
        return acc;
      },
      {}
    );
    await walk_layout(layout, root, _components);
    layout_store.set(_rootNode);
    set_event_specific_args(dependencies);
  }
  function rerender_layout({
    render_id,
    components,
    layout,
    root,
    dependencies
  }) {
    components.forEach((c) => {
      for (const prop in c.props) {
        if (c.props[prop] === null) {
          c.props[prop] = void 0;
        }
      }
    });
    let replacement_components = [];
    let new_components = [];
    components.forEach((c) => {
      if (c.key == null || !keys_per_render_id[render_id]?.includes(c.key)) {
        new_components.push(c);
      } else {
        replacement_components.push(c);
      }
    });
    let _constructor_map = preload_all_components(new_components, root);
    _constructor_map.forEach((v, k) => {
      constructor_map.set(k, v);
    });
    _target_map = {};
    dependencies.forEach((dep) => {
      loading_status.register(dep.id, dep.inputs, dep.outputs);
      dep.frontend_fn = process_frontend_fn(
        dep.js,
        !!dep.backend_fn,
        dep.inputs.length,
        dep.outputs.length
      );
      create_target_meta(dep.targets, dep.id, _target_map);
      get_inputs_outputs(dep, inputs, outputs);
    });
    target_map.set(_target_map);
    let current_element = instance_map[layout.id];
    const add_to_current_children = (component) => {
      if (component.children) {
        component.children.forEach((child) => {
          add_to_current_children(child);
        });
      }
    };
    add_to_current_children(current_element);
    Object.entries(instance_map).forEach(([id, component]) => {
      let _id = Number(id);
      if (component.rendered_in === render_id) {
        let replacement_component = replacement_components.find(
          (c) => c.key === component.key
        );
        if (component.key != null && replacement_component !== void 0) {
          const instance = instance_map[component.id];
          for (const prop in replacement_component.props) {
            if (!replacement_component.props.preserved_by_key?.includes(prop)) {
              instance.props[prop] = replacement_component.props[prop];
            }
          }
        } else {
          delete instance_map[_id];
          if (_component_map.has(_id)) {
            _component_map.delete(_id);
          }
        }
      }
    });
    const components_to_add = new_components.concat(
      replacement_components.filter((c) => !instance_map[c.id])
    );
    components_to_add.forEach((c) => {
      instance_map[c.id] = c;
      _component_map.set(c.id, c);
    });
    if (current_element.parent) {
      current_element.parent.children[current_element.parent.children.indexOf(current_element)] = instance_map[layout.id];
    }
    walk_layout(
      layout,
      root,
      _components.concat(components),
      current_element.parent
    ).then(() => {
      layout_store.set(_rootNode);
      keys_per_render_id[render_id] = components.map((c) => c.key).filter((c) => c != null);
    });
    set_event_specific_args(dependencies);
  }
  async function walk_layout(node2, root, components, parent) {
    const instance = instance_map[node2.id];
    if (!instance.component) {
      instance.component = (await constructor_map.get(
        instance.component_class_id || instance.type
      ))?.default;
    }
    instance.parent = parent;
    if (instance.type === "dataset") {
      instance.props.component_map = get_component(
        instance.type,
        instance.component_class_id,
        root,
        components,
        instance.props.components
      ).example_components;
    }
    if (_target_map[instance.id]) {
      instance.props.attached_events = Object.keys(_target_map[instance.id]);
    }
    instance.props.interactive = determine_interactivity(
      instance.id,
      instance.props.interactive,
      instance.props.value,
      inputs,
      outputs
    );
    instance.props.server = process_server_fn(
      instance.id,
      instance.props.server_fns,
      app
    );
    _component_map.set(instance.id, instance);
    if (node2.children) {
      instance.children = await Promise.all(
        node2.children.map((v) => walk_layout(v, root, components, instance))
      );
    }
    if (instance.type === "tabs" && !instance.props.initial_tabs) {
      const tab_items_props = node2.children?.map((c, i) => {
        const instance2 = instance_map[c.id];
        instance2.props.id ??= c.id;
        return {
          type: instance2.type,
          props: {
            ...instance2.props,
            id: instance2.props.id,
            order: i
          }
        };
      }) || [];
      const child_tab_items = tab_items_props.filter(
        (child) => child.type === "tabitem"
      );
      instance.props.initial_tabs = child_tab_items?.map((child) => ({
        label: child.props.label,
        id: child.props.id,
        visible: child.props.visible,
        interactive: child.props.interactive,
        order: child.props.order
      }));
    }
    if (instance.type === "tabs") {
      node2.children?.forEach((c, i) => {
        const child = instance_map[c.id];
        child.props.order = i;
      });
    }
    return instance;
  }
  let update_scheduled = false;
  let update_scheduled_store = writable(false);
  function flush2() {
    layout_store.update((layout) => {
      for (let i = 0; i < pending_updates.length; i++) {
        for (let j = 0; j < pending_updates[i].length; j++) {
          const update = pending_updates[i][j];
          if (!update)
            continue;
          const instance = instance_map[update.id];
          if (!instance)
            continue;
          let new_value;
          if (update.value instanceof Map)
            new_value = new Map(update.value);
          else if (update.value instanceof Set)
            new_value = new Set(update.value);
          else if (Array.isArray(update.value))
            new_value = [...update.value];
          else if (update.value == null)
            new_value = null;
          else if (typeof update.value === "object")
            new_value = { ...update.value };
          else
            new_value = update.value;
          instance.props[update.prop] = new_value;
        }
      }
      return layout;
    });
    pending_updates = [];
    update_scheduled = false;
    update_scheduled_store.set(false);
  }
  function update_value(updates) {
    if (!updates)
      return;
    pending_updates.push(updates);
    if (!update_scheduled) {
      update_scheduled = true;
      update_scheduled_store.set(true);
      raf$1(flush2);
    }
  }
  function get_data(id) {
    let comp = _component_map.get(id);
    if (!comp) {
      const layout = get_store_value(layout_store);
      comp = findComponentById(layout, id);
    }
    if (!comp) {
      return null;
    }
    if (comp.instance?.get_value) {
      return comp.instance.get_value();
    }
    return comp.props.value;
  }
  function findComponentById(node2, id) {
    if (node2.id === id) {
      return node2;
    }
    if (node2.children) {
      for (const child of node2.children) {
        const result = findComponentById(child, id);
        if (result) {
          return result;
        }
      }
    }
    return void 0;
  }
  function modify_stream(id, state) {
    const comp = _component_map.get(id);
    if (comp && comp.instance?.modify_stream_state) {
      comp.instance.modify_stream_state(state);
    }
  }
  function get_stream_state(id) {
    const comp = _component_map.get(id);
    if (comp?.instance?.get_stream_state)
      return comp.instance.get_stream_state();
    return "not_set";
  }
  function set_time_limit(id, time_limit) {
    const comp = _component_map.get(id);
    if (comp?.instance?.set_time_limit) {
      comp.instance.set_time_limit(time_limit);
    }
  }
  return {
    layout: layout_store,
    targets: target_map,
    update_value,
    get_data,
    modify_stream,
    get_stream_state,
    set_time_limit,
    loading_status,
    scheduled_updates: update_scheduled_store,
    create_layout,
    rerender_layout
  };
}
const AsyncFunction = Object.getPrototypeOf(
  async function() {
  }
).constructor;
function process_frontend_fn(source, backend_fn, input_length, output_length) {
  if (!source || source === true)
    return null;
  const wrap = backend_fn ? input_length === 1 : output_length === 1;
  try {
    return new AsyncFunction(
      "__fn_args",
      `  let result = await (${source})(...__fn_args);
  if (typeof result === "undefined") return [];
  return (${wrap} && !Array.isArray(result)) ? [result] : result;`
    );
  } catch (e) {
    console.error("Could not parse custom js method.");
    console.error(e);
    return null;
  }
}
function create_target_meta(targets, fn_id, target_map) {
  targets.forEach(([id, trigger]) => {
    if (!target_map[id]) {
      target_map[id] = {};
    }
    if (target_map[id]?.[trigger] && !target_map[id]?.[trigger].includes(fn_id)) {
      target_map[id][trigger].push(fn_id);
    } else {
      target_map[id][trigger] = [fn_id];
    }
  });
  return target_map;
}
function get_inputs_outputs(dep, inputs, outputs) {
  dep.inputs.forEach((input) => inputs.add(input));
  dep.outputs.forEach((output) => outputs.add(output));
  return [inputs, outputs];
}
function has_no_default_value(value) {
  return Array.isArray(value) && value.length === 0 || value === "" || value === 0 || !value;
}
function determine_interactivity(id, interactive_prop, value, inputs, outputs) {
  if (interactive_prop === false) {
    return false;
  } else if (interactive_prop === true) {
    return true;
  } else if (inputs.has(id) || !outputs.has(id) && has_no_default_value(value)) {
    return true;
  }
  return false;
}
function process_server_fn(id, server_fns, app) {
  if (!server_fns) {
    return {};
  }
  return server_fns.reduce((acc, fn2) => {
    acc[fn2] = async (...args) => {
      if (args.length === 1) {
        args = args[0];
      }
      const result = await app.component_server(id, fn2, args);
      return result;
    };
    return acc;
  }, {});
}
function get_component(type, class_id, root, components, example_components) {
  let example_component_map = /* @__PURE__ */ new Map();
  if (type === "api")
    type = "state";
  if (type === "dataset" && example_components) {
    example_components.forEach((name) => {
      if (example_component_map.has(name)) {
        return;
      }
      let _c2;
      const matching_component = components.find((c) => c.type === name);
      if (matching_component) {
        _c2 = load_component({
          api_url: root,
          name,
          id: matching_component.component_class_id,
          variant: "example"
        });
        example_component_map.set(name, _c2.component);
      }
    });
  }
  const _c = load_component({
    api_url: root,
    name: type,
    id: class_id,
    variant: "component"
  });
  return {
    component: _c.component,
    name: _c.name,
    example_components: example_component_map.size > 0 ? example_component_map : void 0
  };
}
function preload_all_components(components, root) {
  let constructor_map = /* @__PURE__ */ new Map();
  components.forEach((c) => {
    const { component, example_components } = get_component(
      c.type,
      c.component_class_id,
      root,
      components
    );
    constructor_map.set(c.component_class_id || c.type, component);
    if (example_components) {
      for (const [name, example_component] of example_components) {
        constructor_map.set(name, example_component);
      }
    }
  });
  return constructor_map;
}
const _name$u = "العربية";
const annotated_image$u = {
  annotated_image: "صورة مشروحة"
};
const audio$u = {
  allow_recording_access: "يرجى السماح بالوصول إلى الميكروفون للتسجيل",
  audio: "صوتي",
  record_from_microphone: "تسجيل من الميكروفون",
  stop_recording: "إيقاف التسجيل",
  no_device_support: "لا يمكن الوصول إلى أجهزة الوسائط. تأكد من أنك تعمل على مصدر آمن (https) أو localhost (أو قمت بتمرير شهادة SSL صالحة إلى ssl_verify)، وأنك سمحت للمتصفح بالوصول إلى جهازك.",
  stop: "إيقاف",
  resume: "استئناف",
  record: "تسجيل",
  no_microphone: "لم يتم العثور على ميكروفون",
  pause: "إيقاف مؤقت",
  play: "تشغيل",
  waiting: "جاري الانتظار",
  drop_to_upload: "اسقط ملف صوت هنا للتحميل"
};
const blocks$u = {
  connection_can_break: "على الهاتف المحمول، يمكن أن ينقطع الاتصال إذا تم تغيير التبويب أو دخل الجهاز في وضع السكون، مما يؤدي إلى فقدان موقعك في قائمة الانتظار.",
  long_requests_queue: "هناك قائمة انتظار طويلة من الطلبات المعلقة. قم بتكرار هذا الفضاء للتخطي.",
  lost_connection: "فقد الاتصال بسبب مغادرة الصفحة. إعادة الانضمام إلى قائمة الانتظار...",
  waiting_for_inputs: "انتظار انتهاء تحميل الملف(ات)، يرجى إعادة المحاولة."
};
const checkbox$u = {
  checkbox: "خانة اختيار",
  checkbox_group: "مجموعة خانات الاختيار"
};
const code$u = {
  code: "الكود"
};
const color_picker$u = {
  color_picker: "منتقي الألوان"
};
const common$u = {
  built_with: "بُني باستخدام",
  built_with_gradio: "تم الإنشاء بإستخدام Gradio",
  clear: "أمسح",
  download: "تحميل",
  edit: "تعديل",
  empty: "فارغ",
  error: "خطأ",
  hosted_on: "مستضاف على",
  loading: "جاري التحميل",
  logo: "شعار",
  or: "أو",
  remove: "إزالة",
  settings: "الإعدادات",
  share: "مشاركة",
  submit: "أرسل",
  undo: "تراجع",
  no_devices: "لم يتم العثور على أجهزة",
  language: "اللغة",
  display_theme: "مظهر العرض",
  pwa: "تطبيق ويب تقدمي"
};
const dataframe$u = {
  incorrect_format: "تنسيق غير صحيح، يتم دعم ملفات CSV و TSV فقط",
  new_column: "إضافة عمود",
  new_row: "صف جديد",
  add_row_above: "إضافة صف فوق",
  add_row_below: "إضافة صف تحت",
  add_column_left: "إضافة عمود لليسار",
  add_column_right: "إضافة عمود لليمين",
  delete_row: "حذف الصف",
  delete_column: "حذف العمود",
  sort_column: "فرز العمود",
  sort_ascending: "فرز تصاعدي",
  sort_descending: "فرز تنازلي",
  drop_to_upload: "اسقط ملفات CSV أو TSV هنا لاستيراد البيانات إلى الإطار الجدولية",
  clear_sort: "مسح الترتيب"
};
const dropdown$u = {
  dropdown: "قائمة منسدلة"
};
const errors$u = {
  build_error: "هناك خطأ في البناء",
  config_error: "هناك خطأ في التكوين",
  contact_page_author: "يرجى الاتصال بمؤلف الصفحة",
  no_app_file: "لا يوجد ملف تطبيق",
  runtime_error: "هناك خطأ في وقت التشغيل",
  space_not_working: "المساحة لا تعمل لأن {0}",
  space_paused: "المساحة متوقفة مؤقتًا",
  use_via_api: "استخدم عبر API"
};
const file$u = {
  uploading: "جاري الرفع..."
};
const highlighted_text$u = {
  highlighted_text: "نص مميز"
};
const image$u = {
  allow_webcam_access: "يرجى السماح بالوصول إلى كاميرا الويب للتسجيل.",
  brush_color: "لون الفرشاة",
  brush_radius: "حجم الفرشاة",
  image: "صورة",
  remove_image: "إزالة الصورة",
  select_brush_color: "اختر لون الفرشاة",
  start_drawing: "ابدأ الرسم",
  use_brush: "استخدم الفرشاة",
  drop_to_upload: "اسقط ملف الصورة هنا لتحميله"
};
const label$u = {
  label: "ملصق"
};
const login$u = {
  enable_cookies: "إذا كنت تزور مساحة HuggingFace في وضع التصفح المتخفي، يجب عليك تمكين ملفات تعريف الارتباط من الجهات الخارجية.",
  incorrect_credentials: "بيانات الاعتماد غير صحيحة",
  username: "اسم المستخدم",
  password: "كلمة المرور",
  login: "تسجيل الدخول"
};
const number$u = {
  number: "رقم"
};
const plot$u = {
  plot: "رسم بياني"
};
const radio$u = {
  radio: "زر راديو"
};
const slider$u = {
  slider: "شريط التمرير"
};
const upload_text$u = {
  click_to_upload: "انقر للتحميل",
  drop_audio: "أسقط الملف الصوتي هنا",
  drop_csv: "أسقط ملف البيانات هنا",
  drop_file: "أسقط الملف هنا",
  drop_image: "أسقط الصورة هنا",
  drop_video: "أسقط الفيديو هنا",
  drop_gallery: "أسقط الوسائط هنا",
  paste_clipboard: "لصق من الحافظة"
};
const video$u = {
  drop_to_upload: "اسقط ملف الفيديو هنا للتحميل"
};
const chatbot$u = {
  edit: "تعديل",
  retry: "إعادة المحاولة",
  undo: "تراجع",
  submit: "إرسال",
  cancel: "إلغاء",
  like: "إعجاب",
  dislike: "عدم الإعجاب",
  clear: "مسح المحادثة"
};
const ar = {
  _name: _name$u,
  "3D_model": {
    "3d_model": "نموذج ثلاثي الأبعاد",
    drop_to_upload: "اسقط ملف نموذج 3D (.obj، .glb، .stl، .gltf، .splat، أو .ply) هنا للتحميل"
  },
  annotated_image: annotated_image$u,
  audio: audio$u,
  blocks: blocks$u,
  checkbox: checkbox$u,
  code: code$u,
  color_picker: color_picker$u,
  common: common$u,
  dataframe: dataframe$u,
  dropdown: dropdown$u,
  errors: errors$u,
  file: file$u,
  highlighted_text: highlighted_text$u,
  image: image$u,
  label: label$u,
  login: login$u,
  number: number$u,
  plot: plot$u,
  radio: radio$u,
  slider: slider$u,
  upload_text: upload_text$u,
  video: video$u,
  chatbot: chatbot$u
};
const __vite_glob_0_0 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$u,
  annotated_image: annotated_image$u,
  audio: audio$u,
  blocks: blocks$u,
  chatbot: chatbot$u,
  checkbox: checkbox$u,
  code: code$u,
  color_picker: color_picker$u,
  common: common$u,
  dataframe: dataframe$u,
  default: ar,
  dropdown: dropdown$u,
  errors: errors$u,
  file: file$u,
  highlighted_text: highlighted_text$u,
  image: image$u,
  label: label$u,
  login: login$u,
  number: number$u,
  plot: plot$u,
  radio: radio$u,
  slider: slider$u,
  upload_text: upload_text$u,
  video: video$u
}, Symbol.toStringTag, { value: "Module" }));
const _name$t = "Català";
const annotated_image$t = {
  annotated_image: "Imatge Anotada"
};
const audio$t = {
  allow_recording_access: "Si us plau, permeteu l'accés al micròfon per gravar.",
  audio: "Àudio",
  record_from_microphone: "Gravar des del micròfon",
  stop_recording: "Aturar la gravació",
  no_device_support: "No s'ha pogut accedir als dispositius multimèdia. Comproveu que esteu executant en un origen segur (https) o localhost (o heu passat un certificat SSL vàlid a ssl_verify), i que heu permès l'accés del navegador al vostre dispositiu.",
  stop: "Aturar",
  resume: "Reprendre",
  record: "Gravar",
  no_microphone: "No s'ha trobat cap micròfon",
  pause: "Pausa",
  play: "Reproduir",
  waiting: "Esperant",
  drop_to_upload: "Arrossega un fitxer d'àudio aquí per pujar-lo"
};
const blocks$t = {
  connection_can_break: "En dispositius mòbils, la connexió es pot trencar si aquesta pestanya perd el focus o el dispositiu s'adorm, perdent la vostra posició a la cua.",
  long_requests_queue: "Hi ha una llarga cua de sol·licituds pendents. Dupliqueu aquest Space per saltar-la.",
  lost_connection: "S'ha perdut la connexió en deixar la pàgina. Tornant a la cua...",
  waiting_for_inputs: "Esperant la finalització de la pujada dels fitxers, si us plau, torna a provar."
};
const checkbox$t = {
  checkbox: "Casella de selecció",
  checkbox_group: "Grup de caselles"
};
const code$t = {
  code: "Codi"
};
const color_picker$t = {
  color_picker: "Selector de color"
};
const common$t = {
  built_with: "construït amb",
  built_with_gradio: "Construït amb Gradio",
  clear: "Neteja",
  download: "Descarregar",
  edit: "Editar",
  empty: "Buit",
  error: "Error",
  hosted_on: "Allotjat a",
  loading: "S'està carregant",
  logo: "logotip",
  or: "o",
  remove: "Eliminar",
  settings: "Configuració",
  share: "Compartir",
  submit: "Envia",
  undo: "Desfer",
  no_devices: "No s'han trobat dispositius",
  language: "Idioma",
  display_theme: "Tema de visualització",
  pwa: "Aplicació web progressiva"
};
const dataframe$t = {
  incorrect_format: "Format incorrecte, només s'admeten fitxers CSV i TSV",
  new_column: "Afegir columna",
  new_row: "Nova fila",
  add_row_above: "Afegir fila a dalt",
  add_row_below: "Afegir fila a baix",
  add_column_left: "Afegir columna a l'esquerra",
  add_column_right: "Afegir columna a la dreta",
  delete_row: "Esborrar fila",
  delete_column: "Suprimeix la columna",
  sort_column: "Ordena la columna",
  sort_ascending: "Ordena ascendent",
  sort_descending: "Ordena descendent",
  drop_to_upload: "Arrossega fitxers CSV o TSV aquí per importar dades al dataframe",
  clear_sort: "Neteja la classificació"
};
const dropdown$t = {
  dropdown: "Desplegable"
};
const errors$t = {
  build_error: "hi ha un error de compilació",
  config_error: "hi ha un error de configuració",
  contact_page_author: "Si us plau, contacteu amb l'autor de la pàgina per informar-lo.",
  no_app_file: "no hi ha fitxer d'aplicació",
  runtime_error: "hi ha un error d'execució",
  space_not_working: `"L'Space no funciona perquè" {0}`,
  space_paused: "l'space està en pausa",
  use_via_api: "Utilitzar via API"
};
const file$t = {
  uploading: "Pujant..."
};
const highlighted_text$t = {
  highlighted_text: "Text ressaltat"
};
const image$t = {
  allow_webcam_access: "Si us plau, permeteu l'accés a la càmera web per gravar.",
  brush_color: "Color del pinzell",
  brush_radius: "Radi del pinzell",
  image: "Imatge",
  remove_image: "Eliminar imatge",
  select_brush_color: "Seleccionar color del pinzell",
  start_drawing: "Començar a dibuixar",
  use_brush: "Utilitzar pinzell",
  drop_to_upload: "Arrossega un fitxer d'imatge aquí per pujar-lo"
};
const label$t = {
  label: "Etiqueta"
};
const login$t = {
  enable_cookies: "Si esteu visitant un Space de HuggingFace en mode Incògnit, heu d'habilitar les cookies de tercers.",
  incorrect_credentials: "Credencials incorrectes",
  username: "nom d'usuari",
  password: "contrasenya",
  login: "Iniciar sessió"
};
const number$t = {
  number: "Número"
};
const plot$t = {
  plot: "Gràfic"
};
const radio$t = {
  radio: "Ràdio"
};
const slider$t = {
  slider: "Control lliscant"
};
const upload_text$t = {
  click_to_upload: "Feu clic per pujar",
  drop_audio: "Deixeu anar l'àudio aquí",
  drop_csv: "Deixeu anar el CSV aquí",
  drop_file: "Deixeu anar el fitxer aquí",
  drop_image: "Deixeu anar la imatge aquí",
  drop_video: "Deixeu anar el vídeo aquí",
  drop_gallery: "Deixeu anar els mitjans aquí",
  paste_clipboard: "Enganxar del porta-retalls"
};
const video$t = {
  drop_to_upload: "Arrossega un fitxer de vídeo aquí per pujar-lo"
};
const chatbot$t = {
  edit: "Editar",
  retry: "Tornar a provar",
  undo: "Desfer",
  submit: "Enviar",
  cancel: "Cancel·lar",
  like: "M'agrada",
  dislike: "No m'agrada",
  clear: "Netejar xat"
};
const ca = {
  _name: _name$t,
  "3D_model": {
    "3d_model": "Model 3D",
    drop_to_upload: "Arrossega un model 3D (.obj, .glb, .stl, .gltf, .splat o .ply) aquí per pujar-lo."
  },
  annotated_image: annotated_image$t,
  audio: audio$t,
  blocks: blocks$t,
  checkbox: checkbox$t,
  code: code$t,
  color_picker: color_picker$t,
  common: common$t,
  dataframe: dataframe$t,
  dropdown: dropdown$t,
  errors: errors$t,
  file: file$t,
  highlighted_text: highlighted_text$t,
  image: image$t,
  label: label$t,
  login: login$t,
  number: number$t,
  plot: plot$t,
  radio: radio$t,
  slider: slider$t,
  upload_text: upload_text$t,
  video: video$t,
  chatbot: chatbot$t
};
const __vite_glob_0_1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$t,
  annotated_image: annotated_image$t,
  audio: audio$t,
  blocks: blocks$t,
  chatbot: chatbot$t,
  checkbox: checkbox$t,
  code: code$t,
  color_picker: color_picker$t,
  common: common$t,
  dataframe: dataframe$t,
  default: ca,
  dropdown: dropdown$t,
  errors: errors$t,
  file: file$t,
  highlighted_text: highlighted_text$t,
  image: image$t,
  label: label$t,
  login: login$t,
  number: number$t,
  plot: plot$t,
  radio: radio$t,
  slider: slider$t,
  upload_text: upload_text$t,
  video: video$t
}, Symbol.toStringTag, { value: "Module" }));
const _name$s = "کوردی";
const annotated_image$s = {
  annotated_image: "وێنەی نیشانە کراو"
};
const audio$s = {
  allow_recording_access: "تکایە ڕێگە بدە بە دەستگەیشتن بە مایکرۆفۆن بۆ تۆمارکردن",
  audio: "دەنگ",
  record_from_microphone: "تۆمارکردن لە مایکرۆفۆنەوە",
  stop_recording: "تۆمارکردن بوەستێنە",
  no_device_support: "ناتوانرێت دەستبگات بە ئامێرەکانی میدیا. دڵنیابە لەوەی کە لەسەر سەرچاوەیەکی پارێزراو (https) یان localhost کاردەکەیت (یان بڕوانامەیەکی SSL دروستت داوە)، و ڕێگەت داوە بە وێبگەڕەکە دەستی بگات بە ئامێرەکەت.",
  stop: "وەستان",
  resume: "بەردەوامبوون",
  record: "تۆمارکردن",
  no_microphone: "هیچ مایکرۆفۆنێک نەدۆزرایەوە",
  pause: "وەستاندنی کاتی",
  play: "لێدان",
  waiting: "چاوەڕوانی",
  drop_to_upload: "فایلی دەنگی لێرە دابنێ بۆ بارکردن"
};
const blocks$s = {
  connection_can_break: "لە مۆبایلدا، پەیوەندییەکە دەکرێت بپچڕێت ئەگەر ئەم تابە چالاک نەبێت یان ئامێرەکە بچێتە دۆخی پشوو، ئەمەش شوێنی خۆت لە ڕیزدا لەدەست دەدات.",
  long_requests_queue: "ڕیزێکی درێژی داواکاری هەیە. ئەم سپەیسە دووباد بکە بۆی چاوەڕوان نەبیت.",
  lost_connection: "پەیوەندی پچڕا بەهۆی جێهێشتنی پەیج. گەڕانەوە بۆ ڕیز...",
  waiting_for_inputs: "بەخێربێی بۆ فایل(ەکان) دەستپێکردن، هەڵبژارە دووبارە هەوڵ بدە."
};
const checkbox$s = {
  checkbox: "بۆکسی هەڵبژاردن",
  checkbox_group: "گروپی بۆکسی هەڵبژاردن"
};
const code$s = {
  code: "کۆد"
};
const color_picker$s = {
  color_picker: "هەڵبژاردنی ڕەنگ"
};
const common$s = {
  built_with: "دروستکراوە لەگەڵ...",
  built_with_gradio: "Gradio دروستکراوە بە",
  clear: "خاوێنکردنەوە",
  download: "دابەزاندن",
  edit: "بژارکردن",
  empty: "بەتاڵ",
  error: "هەڵە",
  hosted_on: "میوانداری کراوە لە",
  loading: "بارکردن",
  logo: "لۆگۆ",
  or: "یان",
  remove: "لابردن",
  settings: "ڕێکخستنەکان",
  share: "هاوبەشکردن",
  submit: "پێشکەشکردن",
  undo: "پووچکردنەوە",
  no_devices: "هیچ ئامێرێک نەدۆزرایەوە",
  language: "زمان",
  display_theme: "ڕووکاری نیشاندان",
  pwa: "بەرنامەی وێبی پێشکەوتوو"
};
const dataframe$s = {
  incorrect_format: "فۆرماتێکی هەڵە، تەنها فایلەکانی CSV و TSV پشتگیری دەکرێن",
  new_column: "زیادکردنی ستوون",
  new_row: "ڕیزی نوێ",
  add_row_above: "زیادکردنی ڕیز لە سەرەوە",
  add_row_below: "زیادکردنی ڕیز لە خوارەوە",
  add_column_left: "زیادکردنی ستوون لە چەپەوە",
  add_column_right: "زیادکردنی ستوون لە ڕاستەوە",
  delete_row: "ڕووی ڕاکردن",
  delete_column: "کۆلۆنی ڕاکردن",
  sort_column: "کۆلۆنی ڕێکەوە کردن",
  sort_ascending: "بەرچاوەی ڕوونی",
  sort_descending: "سەرچاوەکە بەپاشی بەرگرێڕەوە بەڕێوە بکە",
  drop_to_upload: "فایلەکانی CSV یان TSV لەگەڵ ئەمە بکەوە تا داتا بەرچوون بێت لەوەی دەیتە فرەیمەکەدا",
  clear_sort: "ڕاژکردنی ڕوونکردن"
};
const dropdown$s = {
  dropdown: "لیستی داکەوتوو"
};
const errors$s = {
  build_error: "هەڵەیەک هەیە لە دروستکردندا",
  config_error: "هەڵەیەک هەیە لە ڕێکخستندا",
  contact_page_author: "تکایە پەیوەندی بکە بە نووسەری لاپەڕەکە بۆ ئاگادارکردنەوە.",
  no_app_file: "فایلی بەرنامە نییە",
  runtime_error: "هەڵەیەک هەیە لە کاتی جێبەجێکردندا",
  space_not_working: '"سپەیسەکە کار ناکات چونکە" {0}',
  space_paused: "سپەیسەکە وەستێنراوە",
  use_via_api: "بەکارهێنان لە ڕێگەی API"
};
const file$s = {
  uploading: "بارکردن..."
};
const highlighted_text$s = {
  highlighted_text: "دەقی دیاریکراو"
};
const image$s = {
  allow_webcam_access: "تکایە ڕێگە بدە بە بەکارهێنانی کامێرای وێب بۆ تۆمارکردن.",
  brush_color: "ڕەنگی فڵچە",
  brush_radius: "تیژڕەوی فڵچە",
  image: "وێنە",
  remove_image: "لابردنی وێنە",
  select_brush_color: "ڕەنگی فڵچە هەڵبژێرە",
  start_drawing: "دەست بکە بە وێنەکێشان",
  use_brush: "فڵچە بەکاربهێنە",
  drop_to_upload: "فایل وێنەیەک هەروەها لەمەکە دەڕوونە بۆ بارکردنەوە"
};
const label$s = {
  label: "لەیبڵ"
};
const login$s = {
  enable_cookies: "ئەگەر تۆ سەردانی HuggingFace Space دەکەیت لە دۆخی نادیاردا، پێویستە کووکی لایەنی سێیەم چالاک بکەیت.",
  incorrect_credentials: "زانیاری چوونەژوورەوە هەڵەیە",
  username: "ناوی بەکارهێنەر",
  password: "وشەی نهێنی",
  login: "چوونە ژوورەوە"
};
const number$s = {
  number: "ژمارە"
};
const plot$s = {
  plot: "هێڵکاری"
};
const radio$s = {
  radio: "ڕادیۆ"
};
const slider$s = {
  slider: "سلایدەر"
};
const upload_text$s = {
  click_to_upload: "کلیک بکە بۆ بارکردن",
  drop_audio: "دەنگ لێرە دابنێ",
  drop_csv: "لێرەدا CSV دابنێ",
  drop_file: "فایل لێرە دابنێ",
  drop_image: "وێنە لێرەدا دابنێ",
  drop_video: "ڤیدیۆ لێرە دابنێ",
  drop_gallery: "میدیا لێرە دابنێ",
  paste_clipboard: "لکاندن لە کلیپبۆردەوە"
};
const video$s = {
  drop_to_upload: "فایل ویدیۆییەکەت هەنە بکەرەوە بۆ بارکردنەوە"
};
const chatbot$s = {
  edit: "دەستکاری",
  retry: "هەوڵدانەوە",
  undo: "گەڕانەوە",
  submit: "ناردن",
  cancel: "هەڵوەشاندنەوە",
  like: "پەسەند",
  dislike: "ناپەسەند",
  clear: "پاککردنەوەی گفتوگۆ"
};
const ckb = {
  _name: _name$s,
  "3D_model": {
    "3d_model": "مۆدێلی سێ ڕەهەندی",
    drop_to_upload: "فایل مۆدێلی ٣دی (.obj، .glb، .stl، .gltf، .splat یان .ply) لەمە هێرە بکە لەبەر بارکردنی."
  },
  annotated_image: annotated_image$s,
  audio: audio$s,
  blocks: blocks$s,
  checkbox: checkbox$s,
  code: code$s,
  color_picker: color_picker$s,
  common: common$s,
  dataframe: dataframe$s,
  dropdown: dropdown$s,
  errors: errors$s,
  file: file$s,
  highlighted_text: highlighted_text$s,
  image: image$s,
  label: label$s,
  login: login$s,
  number: number$s,
  plot: plot$s,
  radio: radio$s,
  slider: slider$s,
  upload_text: upload_text$s,
  video: video$s,
  chatbot: chatbot$s
};
const __vite_glob_0_2 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$s,
  annotated_image: annotated_image$s,
  audio: audio$s,
  blocks: blocks$s,
  chatbot: chatbot$s,
  checkbox: checkbox$s,
  code: code$s,
  color_picker: color_picker$s,
  common: common$s,
  dataframe: dataframe$s,
  default: ckb,
  dropdown: dropdown$s,
  errors: errors$s,
  file: file$s,
  highlighted_text: highlighted_text$s,
  image: image$s,
  label: label$s,
  login: login$s,
  number: number$s,
  plot: plot$s,
  radio: radio$s,
  slider: slider$s,
  upload_text: upload_text$s,
  video: video$s
}, Symbol.toStringTag, { value: "Module" }));
const _name$r = "Deutsch";
const annotated_image$r = {
  annotated_image: "Annotiertes Bild"
};
const audio$r = {
  allow_recording_access: "Bitte erlauben Sie den Zugriff auf das Mikrofon für die Aufnahme.",
  audio: "Audio",
  record_from_microphone: "Vom Mikrofon aufnehmen",
  stop_recording: "Aufnahme stoppen",
  no_device_support: "Auf Mediengeräte konnte nicht zugegriffen werden. Stellen Sie sicher, dass Sie sich auf einer sicheren Quelle (https) oder localhost befinden (oder ein gültiges SSL-Zertifikat an ssl_verify übergeben haben) und Sie dem Browser den Zugriff auf Ihr Gerät erlaubt haben.",
  stop: "Stopp",
  resume: "Fortsetzen",
  record: "Aufnehmen",
  no_microphone: "Kein Mikrofon gefunden",
  pause: "Pause",
  play: "Abspielen",
  waiting: "Warten",
  drop_to_upload: "Laden Sie eine Audiodatei hier ab, um sie hochzuladen."
};
const blocks$r = {
  connection_can_break: "Auf Mobilgeräten kann die Verbindung unterbrochen werden, wenn dieser Tab den Fokus verliert oder das Gerät in den Ruhezustand geht, wodurch Ihre Position in der Warteschlange verloren geht.",
  long_requests_queue: "Es gibt eine lange Warteschlange ausstehender Anfragen. Duplizieren Sie diesen Space zum Überspringen.",
  lost_connection: "Verbindung durch Verlassen der Seite verloren. Kehre zur Warteschlange zurück...",
  waiting_for_inputs: "Warten auf das Hochladen der Datei(en), bitte versuchen Sie es erneut."
};
const checkbox$r = {
  checkbox: "Kontrollkästchen",
  checkbox_group: "Kontrollkästchengruppe"
};
const code$r = {
  code: "Code"
};
const color_picker$r = {
  color_picker: "Farbwähler"
};
const common$r = {
  built_with: "erstellt mit",
  built_with_gradio: "Mit Gradio erstellt",
  clear: "Löschen",
  download: "Herunterladen",
  edit: "Bearbeiten",
  empty: "Leer",
  error: "Fehler",
  hosted_on: "Gehostet auf",
  loading: "Laden",
  logo: "Logo",
  or: "oder",
  remove: "Entfernen",
  settings: "Einstellungen",
  share: "Teilen",
  submit: "Absenden",
  undo: "Rückgängig",
  no_devices: "Keine Geräte gefunden",
  language: "Sprache",
  display_theme: "Anzeigedesign",
  pwa: "Progressive Web App"
};
const dataframe$r = {
  incorrect_format: "Falsches Format, nur CSV- und TSV-Dateien werden unterstützt",
  new_column: "Spalte hinzufügen",
  new_row: "Neue Zeile",
  add_row_above: "Zeile oben hinzufügen",
  add_row_below: "Zeile unten hinzufügen",
  add_column_left: "Spalte links hinzufügen",
  add_column_right: "Spalte rechts hinzufügen",
  delete_row: "Zeile löschen",
  delete_column: "Spalte löschen",
  sort_column: "Spalte sortieren",
  sort_ascending: "Aufsteigend sortieren",
  sort_descending: "Absteigend sortieren",
  drop_to_upload: "CSV- oder TSV-Dateien hier ablegen, um Daten in den DataFrame zu importieren.",
  clear_sort: "Sortierung aufheben"
};
const dropdown$r = {
  dropdown: "Dropdown-Menü"
};
const errors$r = {
  build_error: "Es gibt einen Build-Fehler",
  config_error: "Es gibt einen Konfigurationsfehler",
  contact_page_author: "Bitte kontaktieren Sie den Autor der Seite.",
  no_app_file: "Es gibt keine App-Datei",
  runtime_error: "Es gibt einen Laufzeitfehler",
  space_not_working: '"Space funktioniert nicht, weil" {0}',
  space_paused: "Der Space ist pausiert",
  use_via_api: "Über API verwenden"
};
const file$r = {
  uploading: "Hochladen..."
};
const highlighted_text$r = {
  highlighted_text: "Hervorgehobener Text"
};
const image$r = {
  allow_webcam_access: "Bitte erlauben Sie den Zugriff auf die Webcam für die Aufnahme.",
  brush_color: "Pinselfarbe",
  brush_radius: "Pinselgröße",
  image: "Bild",
  remove_image: "Bild entfernen",
  select_brush_color: "Pinselfarbe auswählen",
  start_drawing: "Zeichnen beginnen",
  use_brush: "Pinsel verwenden",
  drop_to_upload: "Laden Sie ein Bild hier ab, um es hochzuladen."
};
const label$r = {
  label: "Beschriftung"
};
const login$r = {
  enable_cookies: "Wenn Sie einen HuggingFace Space im Inkognito-Modus besuchen, müssen Sie Cookies von Drittanbietern aktivieren.",
  incorrect_credentials: "Falsche Anmeldedaten",
  username: "Benutzername",
  password: "Passwort",
  login: "Anmelden"
};
const number$r = {
  number: "Zahl"
};
const plot$r = {
  plot: "Diagramm"
};
const radio$r = {
  radio: "Optionsfeld"
};
const slider$r = {
  slider: "Schieberegler"
};
const upload_text$r = {
  click_to_upload: "Hochladen",
  drop_audio: "Audio hier ablegen",
  drop_csv: "CSV Datei hier ablegen",
  drop_file: "Datei hier ablegen",
  drop_image: "Bild hier ablegen",
  drop_video: "Video hier ablegen",
  drop_gallery: "Medien hier ablegen",
  paste_clipboard: "Aus Zwischenablage einfügen"
};
const video$r = {
  drop_to_upload: "Laden Sie eine Video-Datei hier ab, um sie hochzuladen."
};
const chatbot$r = {
  edit: "Bearbeiten",
  retry: "Wiederholen",
  undo: "Rückgängig",
  submit: "Senden",
  cancel: "Abbrechen",
  like: "Gefällt mir",
  dislike: "Gefällt mir nicht",
  clear: "Chat leeren"
};
const de = {
  _name: _name$r,
  "3D_model": {
    "3d_model": "3D-Modell",
    drop_to_upload: "Laden Sie eine 3D-Modell-Datei (.obj, .glb, .stl, .gltf, .splat oder .ply) hier ab, um sie hochzuladen."
  },
  annotated_image: annotated_image$r,
  audio: audio$r,
  blocks: blocks$r,
  checkbox: checkbox$r,
  code: code$r,
  color_picker: color_picker$r,
  common: common$r,
  dataframe: dataframe$r,
  dropdown: dropdown$r,
  errors: errors$r,
  file: file$r,
  highlighted_text: highlighted_text$r,
  image: image$r,
  label: label$r,
  login: login$r,
  number: number$r,
  plot: plot$r,
  radio: radio$r,
  slider: slider$r,
  upload_text: upload_text$r,
  video: video$r,
  chatbot: chatbot$r
};
const __vite_glob_0_3 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$r,
  annotated_image: annotated_image$r,
  audio: audio$r,
  blocks: blocks$r,
  chatbot: chatbot$r,
  checkbox: checkbox$r,
  code: code$r,
  color_picker: color_picker$r,
  common: common$r,
  dataframe: dataframe$r,
  default: de,
  dropdown: dropdown$r,
  errors: errors$r,
  file: file$r,
  highlighted_text: highlighted_text$r,
  image: image$r,
  label: label$r,
  login: login$r,
  number: number$r,
  plot: plot$r,
  radio: radio$r,
  slider: slider$r,
  upload_text: upload_text$r,
  video: video$r
}, Symbol.toStringTag, { value: "Module" }));
const _name$q = "English";
const annotated_image$q = {
  annotated_image: "Annotated Image"
};
const audio$q = {
  allow_recording_access: "Please allow access to the microphone for recording.",
  audio: "Audio",
  drop_to_upload: "Drop an audio file here to upload",
  record_from_microphone: "Record from microphone",
  stop_recording: "Stop recording",
  no_device_support: "Media devices could not be accessed. Check that you are running on a secure origin (https) or localhost (or you have passed a valid SSL certificate to ssl_verify), and you have allowed browser access to your device.",
  stop: "Stop",
  resume: "Resume",
  record: "Record",
  no_microphone: "No microphone found",
  pause: "Pause",
  play: "Play",
  waiting: "Waiting"
};
const blocks$q = {
  connection_can_break: "On mobile, the connection can break if this tab is unfocused or the device sleeps, losing your position in queue.",
  long_requests_queue: "There is a long queue of requests pending. Duplicate this Space to skip.",
  lost_connection: "Lost connection due to leaving page. Rejoining queue...",
  waiting_for_inputs: "Waiting for file(s) to finish uploading, please retry."
};
const chatbot$q = {
  edit: "Edit",
  retry: "Retry",
  undo: "Undo",
  submit: "Submit",
  cancel: "Cancel",
  like: "Like",
  dislike: "Dislike",
  clear: "Clear"
};
const checkbox$q = {
  checkbox: "Checkbox",
  checkbox_group: "Checkbox Group"
};
const code$q = {
  code: "Code"
};
const color_picker$q = {
  color_picker: "Color Picker"
};
const common$q = {
  built_with: "built with",
  built_with_gradio: "Built with Gradio",
  clear: "Clear",
  download: "Download",
  edit: "Edit",
  empty: "Empty",
  error: "Error",
  hosted_on: "Hosted on",
  loading: "Loading",
  logo: "logo",
  or: "or",
  remove: "Remove",
  settings: "Settings",
  share: "Share",
  submit: "Submit",
  undo: "Undo",
  no_devices: "No devices found",
  language: "Language",
  display_theme: "Display Theme",
  pwa: "Progressive Web App",
  record: "Record",
  stop_recording: "Stop Recording",
  screen_studio: "Screen Studio",
  share_gradio_tab: "[Sharing] Gradio Tab",
  run: "Run"
};
const dataframe$q = {
  incorrect_format: "Incorrect format, only CSV and TSV files are supported",
  new_column: "Add column",
  new_row: "New row",
  add_row_above: "Add row above",
  add_row_below: "Add row below",
  delete_row: "Delete row",
  delete_column: "Delete column",
  add_column_left: "Add column to the left",
  add_column_right: "Add column to the right",
  sort_column: "Sort column",
  sort_ascending: "Sort ascending",
  sort_descending: "Sort descending",
  drop_to_upload: "Drop CSV or TSV files here to import data into dataframe",
  clear_sort: "Clear sort",
  filter: "Filter",
  clear_filter: "Clear filters"
};
const dropdown$q = {
  dropdown: "Dropdown"
};
const errors$q = {
  build_error: "there is a build error",
  config_error: "there is a config error",
  contact_page_author: "Please contact the author of the page to let them know.",
  no_app_file: "there is no app file",
  runtime_error: "there is a runtime error",
  space_not_working: `"Space isn't working because" {0}`,
  space_paused: "the space is paused",
  use_via_api: "Use via API",
  use_via_api_or_mcp: "Use via API or MCP"
};
const file$q = {
  uploading: "Uploading..."
};
const highlighted_text$q = {
  highlighted_text: "Highlighted Text"
};
const image$q = {
  allow_webcam_access: "Please allow access to the webcam for recording.",
  brush_color: "Brush color",
  brush_radius: "Brush radius",
  image: "Image",
  remove_image: "Remove Image",
  select_brush_color: "Select brush color",
  start_drawing: "Start drawing",
  use_brush: "Use brush",
  drop_to_upload: "Drop an image file here to upload"
};
const label$q = {
  label: "Label"
};
const login$q = {
  enable_cookies: "If you are visiting a HuggingFace Space in Incognito mode, you must enable third party cookies.",
  incorrect_credentials: "Incorrect Credentials",
  username: "username",
  password: "password",
  login: "Login"
};
const number$q = {
  number: "Number"
};
const plot$q = {
  plot: "Plot"
};
const radio$q = {
  radio: "Radio"
};
const slider$q = {
  slider: "Slider"
};
const upload_text$q = {
  click_to_upload: "Click to Upload",
  drop_audio: "Drop Audio Here",
  drop_csv: "Drop CSV Here",
  drop_file: "Drop File Here",
  drop_image: "Drop Image Here",
  drop_video: "Drop Video Here",
  drop_gallery: "Drop Media Here",
  paste_clipboard: "Paste from Clipboard"
};
const video$q = {
  drop_to_upload: "Drop a video file here to upload"
};
const en = {
  _name: _name$q,
  "3D_model": {
    "3d_model": "3D Model",
    drop_to_upload: "Drop a 3D model (.obj, .glb, .stl, .gltf, .splat, or .ply) file here to upload"
  },
  annotated_image: annotated_image$q,
  audio: audio$q,
  blocks: blocks$q,
  chatbot: chatbot$q,
  checkbox: checkbox$q,
  code: code$q,
  color_picker: color_picker$q,
  common: common$q,
  dataframe: dataframe$q,
  dropdown: dropdown$q,
  errors: errors$q,
  file: file$q,
  highlighted_text: highlighted_text$q,
  image: image$q,
  label: label$q,
  login: login$q,
  number: number$q,
  plot: plot$q,
  radio: radio$q,
  slider: slider$q,
  upload_text: upload_text$q,
  video: video$q
};
const __vite_glob_0_4 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$q,
  annotated_image: annotated_image$q,
  audio: audio$q,
  blocks: blocks$q,
  chatbot: chatbot$q,
  checkbox: checkbox$q,
  code: code$q,
  color_picker: color_picker$q,
  common: common$q,
  dataframe: dataframe$q,
  default: en,
  dropdown: dropdown$q,
  errors: errors$q,
  file: file$q,
  highlighted_text: highlighted_text$q,
  image: image$q,
  label: label$q,
  login: login$q,
  number: number$q,
  plot: plot$q,
  radio: radio$q,
  slider: slider$q,
  upload_text: upload_text$q,
  video: video$q
}, Symbol.toStringTag, { value: "Module" }));
const _name$p = "Español";
const annotated_image$p = {
  annotated_image: "Imagen Anotada"
};
const audio$p = {
  allow_recording_access: "Por favor, permita el acceso al micrófono para grabar.",
  audio: "Audio",
  record_from_microphone: "Grabar desde el micrófono",
  stop_recording: "Detener grabación",
  no_device_support: "No se pudo acceder a los dispositivos multimedia. Compruebe que está ejecutando en un origen seguro (https) o localhost (o que ha pasado un certificado SSL válido a ssl_verify), y que ha permitido el acceso del navegador a su dispositivo.",
  stop: "Detener",
  resume: "Reanudar",
  record: "Grabar",
  no_microphone: "No se encontró micrófono",
  pause: "Pausar",
  play: "Reproducir",
  waiting: "Esperando",
  drop_to_upload: "Arrastra un archivo de audio aquí para subirlo"
};
const blocks$p = {
  connection_can_break: "En dispositivos móviles, la conexión puede interrumpirse si esta pestaña pierde el foco o el dispositivo entra en reposo, perdiendo su posición en la cola.",
  long_requests_queue: "Hay una larga cola de solicitudes pendientes. Duplique este Space para saltarse la cola.",
  lost_connection: "Se perdió la conexión al abandonar la página. Volviendo a la cola...",
  waiting_for_inputs: "Esperando a que se complete(n) la(s) carga(s) de archivo(s), por favor inténtelo de nuevo."
};
const checkbox$p = {
  checkbox: "Casilla de verificación",
  checkbox_group: "Grupo de casillas"
};
const code$p = {
  code: "Código"
};
const color_picker$p = {
  color_picker: "Selector de color"
};
const common$p = {
  built_with: "construido con",
  built_with_gradio: "Construido con Gradio",
  clear: "Limpiar",
  download: "Descargar",
  edit: "Editar",
  empty: "Vacío",
  error: "Error",
  flag: "Marcar",
  hosted_on: "Alojado en",
  loading: "Cargando",
  logo: "logo",
  or: "o",
  remove: "Eliminar",
  settings: "Configuración",
  share: "Compartir",
  submit: "Enviar",
  undo: "Deshacer",
  no_devices: "No se encontraron dispositivos",
  language: "Idioma",
  display_theme: "Tema de visualización",
  pwa: "Aplicación web progresiva"
};
const dataframe$p = {
  incorrect_format: "Formato incorrecto, solo se admiten archivos CSV y TSV",
  new_column: "Agregar columna",
  new_row: "Nueva fila",
  add_row_above: "Agregar fila arriba",
  add_row_below: "Agregar fila abajo",
  add_column_left: "Agregar columna a la izquierda",
  add_column_right: "Agregar columna a la derecha",
  delete_row: "Eliminar fila",
  delete_column: "Eliminar columna",
  sort_column: "Ordenar columna",
  sort_ascending: "Ordenar ascendente",
  sort_descending: "Ordenar descendente",
  drop_to_upload: "Arrastra y suelta los archivos CSV o TSV aquí para importar datos al dataframe",
  clear_sort: "Limpiar ordenamiento"
};
const dropdown$p = {
  dropdown: "Menú desplegable"
};
const errors$p = {
  build_error: "hay un error de compilación",
  config_error: "hay un error de configuración",
  contact_page_author: "Por favor, contacte al autor de la página para informarle.",
  no_app_file: "no hay archivo de aplicación",
  runtime_error: "hay un error de ejecución",
  space_not_working: '"El Space no funciona porque" {0}',
  space_paused: "el space está pausado",
  use_via_api: "Usar vía API",
  use_via_api_or_mcp: "Usar vía API o MCP"
};
const file$p = {
  uploading: "Subiendo..."
};
const highlighted_text$p = {
  highlighted_text: "Texto resaltado"
};
const image$p = {
  allow_webcam_access: "Por favor, permita el acceso a la cámara web para grabar.",
  brush_color: "Color del pincel",
  brush_radius: "Radio del pincel",
  image: "Imagen",
  remove_image: "Eliminar imagen",
  select_brush_color: "Seleccionar color del pincel",
  start_drawing: "Empezar a dibujar",
  use_brush: "Usar pincel",
  drop_to_upload: "Arrastra un archivo de imagen aquí para subirlo"
};
const label$p = {
  label: "Etiqueta"
};
const login$p = {
  enable_cookies: "Si está visitando un Space de HuggingFace en modo Incógnito, debe habilitar las cookies de terceros.",
  incorrect_credentials: "Credenciales incorrectas",
  username: "usuario",
  password: "contraseña",
  login: "Iniciar sesión"
};
const number$p = {
  number: "Número"
};
const plot$p = {
  plot: "Gráfico"
};
const radio$p = {
  radio: "Radio"
};
const slider$p = {
  slider: "Deslizador"
};
const upload_text$p = {
  click_to_upload: "Haga clic para cargar",
  drop_audio: "Coloque el audio aquí",
  drop_csv: "Coloque el CSV aquí",
  drop_file: "Coloque el archivo aquí",
  drop_image: "Coloque la imagen aquí",
  drop_video: "Coloque el video aquí",
  drop_gallery: "Coloque las imágenes aquí",
  paste_clipboard: "Pegar desde el portapapeles"
};
const video$p = {
  drop_to_upload: "Arrastra un archivo de video aquí para subirlo"
};
const chatbot$p = {
  edit: "Editar",
  retry: "Reintentar",
  undo: "Deshacer",
  submit: "Enviar",
  cancel: "Cancelar",
  like: "Me gusta",
  dislike: "No me gusta",
  clear: "Limpiar chat"
};
const es = {
  _name: _name$p,
  "3D_model": {
    "3d_model": "Modelo 3D",
    drop_to_upload: "Arrastra y suelta un archivo de modelo 3D (.obj, .glb, .stl, .gltf, .splat o .ply) aquí para cargarlo."
  },
  annotated_image: annotated_image$p,
  audio: audio$p,
  blocks: blocks$p,
  checkbox: checkbox$p,
  code: code$p,
  color_picker: color_picker$p,
  common: common$p,
  dataframe: dataframe$p,
  dropdown: dropdown$p,
  errors: errors$p,
  file: file$p,
  highlighted_text: highlighted_text$p,
  image: image$p,
  label: label$p,
  login: login$p,
  number: number$p,
  plot: plot$p,
  radio: radio$p,
  slider: slider$p,
  upload_text: upload_text$p,
  video: video$p,
  chatbot: chatbot$p
};
const __vite_glob_0_5 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$p,
  annotated_image: annotated_image$p,
  audio: audio$p,
  blocks: blocks$p,
  chatbot: chatbot$p,
  checkbox: checkbox$p,
  code: code$p,
  color_picker: color_picker$p,
  common: common$p,
  dataframe: dataframe$p,
  default: es,
  dropdown: dropdown$p,
  errors: errors$p,
  file: file$p,
  highlighted_text: highlighted_text$p,
  image: image$p,
  label: label$p,
  login: login$p,
  number: number$p,
  plot: plot$p,
  radio: radio$p,
  slider: slider$p,
  upload_text: upload_text$p,
  video: video$p
}, Symbol.toStringTag, { value: "Module" }));
const _name$o = "Euskara";
const annotated_image$o = {
  annotated_image: "Irudi Erantsia"
};
const audio$o = {
  allow_recording_access: "Mesedez, baimendu mikrofonoaren sarbidea grabatzeko.",
  audio: "Audioa",
  record_from_microphone: "Mikrofonotik grabatu",
  stop_recording: "Grabaketa gelditu",
  no_device_support: "Ezin izan da multimedia gailuetara sartu. Ziurtatu jatorri seguru batean (https) edo localhost-en exekutatzen ari zarela (edo SSL ziurtagiri baliozkoa eman diozula ssl_verify-ri), eta nabigatzaileari zure gailura sarbidea eman diozula.",
  stop: "Gelditu",
  resume: "Jarraitu",
  record: "Grabatu",
  no_microphone: "Ez da mikrofonorik aurkitu",
  pause: "Pausatu",
  play: "Erreproduzitu",
  waiting: "Itxaroten",
  drop_to_upload: "Arrastatu audio fitxategia hemen igotzeko"
};
const blocks$o = {
  connection_can_break: "Mugikorretan, konexioa eten daiteke fitxa honek fokua galtzen badu edo gailua lokartu egiten bada, ilaran duzun posizioa galduz.",
  long_requests_queue: "Eskaera ilara luzea dago zain. Space hau bikoiztu saltatzeko.",
  lost_connection: "Konexioa galdu da orria uzteagatik. Ilarara itzultzen...",
  waiting_for_inputs: "Itxaron fitxategiak igo arte, saiatu berriro mesedez"
};
const checkbox$o = {
  checkbox: "Kontrol-laukia",
  checkbox_group: "Kontrol-laukien taldea"
};
const code$o = {
  code: "Kodea"
};
const color_picker$o = {
  color_picker: "Kolore hautatzailea"
};
const common$o = {
  built_with: "honekin eraikia",
  built_with_gradio: "Gradio-rekin eraikia",
  clear: "Garbitu",
  download: "Deskargatu",
  edit: "Editatu",
  empty: "Hutsik",
  error: "Errorea",
  hosted_on: "Ostatatuta",
  loading: "Kargatzen",
  logo: "logoa",
  or: "edo",
  remove: "Kendu",
  settings: "Ezarpenak",
  share: "Partekatu",
  submit: "Bidali",
  undo: "Desegin",
  no_devices: "Ez da gailurik aurkitu",
  language: "Hizkuntza",
  display_theme: "Bistaratze gaia",
  pwa: "Web Aplikazio Aurreratua"
};
const dataframe$o = {
  incorrect_format: "Formatu okerra, CSV eta TSV fitxategiak soilik onartzen dira",
  new_column: "Zutabea gehitu",
  new_row: "Errenkada berria",
  add_row_above: "Errenkada gehitu gainean",
  add_row_below: "Errenkada gehitu azpian",
  add_column_left: "Zutabea gehitu ezkerrean",
  add_column_right: "Zutabea gehitu eskuinean",
  delete_row: "Ezabatu errenkila",
  delete_column: "Ezabatu zutabea",
  sort_column: "Ordenatu zutabea",
  sort_ascending: "Behetik gorako ordena",
  sort_descending: "Goitik beherako ordena",
  drop_to_upload: "Arrastatu CSV edo TSV fitxategiak hemen datuak dataframe-an inportatzeko",
  clear_sort: "Garbitu ordena"
};
const dropdown$o = {
  dropdown: "Goitibeherako menua"
};
const errors$o = {
  build_error: "eraikitze errore bat dago",
  config_error: "konfigurazio errore bat dago",
  contact_page_author: "Mesedez, jarri harremanetan orriaren egilearekin jakinarazteko.",
  no_app_file: "ez dago aplikazio fitxategirik",
  runtime_error: "exekuzio errore bat dago",
  space_not_working: '"Space-a ez dabil honako arrazoi honengatik:" {0}',
  space_paused: "space-a pausatuta dago",
  use_via_api: "API bidez erabili"
};
const file$o = {
  uploading: "Igotzen..."
};
const highlighted_text$o = {
  highlighted_text: "Nabarmendutako testua"
};
const image$o = {
  allow_webcam_access: "Mesedez, baimendu web-kameraren sarbidea grabatzeko.",
  brush_color: "Pintzelaren kolorea",
  brush_radius: "Pintzelaren tamaina",
  image: "Irudia",
  remove_image: "Irudia kendu",
  select_brush_color: "Aukeratu pintzelaren kolorea",
  start_drawing: "Hasi marrazten",
  use_brush: "Pintzela erabili",
  drop_to_upload: "Arrastatu irudi fitxategia hemen igotzeko"
};
const label$o = {
  label: "Etiketa"
};
const login$o = {
  enable_cookies: "HuggingFace Space bat Inkognito moduan bisitatzen ari bazara, hirugarrenen cookieak gaitu behar dituzu.",
  incorrect_credentials: "Kredentzial okerrak",
  username: "erabiltzaile izena",
  password: "pasahitza",
  login: "Saioa hasi"
};
const number$o = {
  number: "Zenbakia"
};
const plot$o = {
  plot: "Grafikoa"
};
const radio$o = {
  radio: "Aukera botoia"
};
const slider$o = {
  slider: "Graduatzailea"
};
const upload_text$o = {
  click_to_upload: "Klikatu igotzeko",
  drop_audio: "Utzi audioa hemen",
  drop_csv: "Utzi CSV-a hemen",
  drop_file: "Utzi fitxategia hemen",
  drop_image: "Utzi irudia hemen",
  drop_video: "Utzi bideoa hemen",
  drop_gallery: "Utzi multimedia hemen",
  paste_clipboard: "Itsatsi arbeleko edukia"
};
const video$o = {
  drop_to_upload: "Arrastatu bideo fitxategia hemen igotzeko"
};
const chatbot$o = {
  edit: "Editatu",
  retry: "Saiatu berriro",
  undo: "Desegin",
  submit: "Bidali",
  cancel: "Utzi",
  like: "Gustuko dut",
  dislike: "Ez dut gustuko",
  clear: "Garbitu txata"
};
const eu = {
  _name: _name$o,
  "3D_model": {
    "3d_model": "3D Modeloa",
    drop_to_upload: "Arrastatu 3D modelo bat (.obj, .glb, .stl, .gltf, .splat edo .ply) igotzeko."
  },
  annotated_image: annotated_image$o,
  audio: audio$o,
  blocks: blocks$o,
  checkbox: checkbox$o,
  code: code$o,
  color_picker: color_picker$o,
  common: common$o,
  dataframe: dataframe$o,
  dropdown: dropdown$o,
  errors: errors$o,
  file: file$o,
  highlighted_text: highlighted_text$o,
  image: image$o,
  label: label$o,
  login: login$o,
  number: number$o,
  plot: plot$o,
  radio: radio$o,
  slider: slider$o,
  upload_text: upload_text$o,
  video: video$o,
  chatbot: chatbot$o
};
const __vite_glob_0_6 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$o,
  annotated_image: annotated_image$o,
  audio: audio$o,
  blocks: blocks$o,
  chatbot: chatbot$o,
  checkbox: checkbox$o,
  code: code$o,
  color_picker: color_picker$o,
  common: common$o,
  dataframe: dataframe$o,
  default: eu,
  dropdown: dropdown$o,
  errors: errors$o,
  file: file$o,
  highlighted_text: highlighted_text$o,
  image: image$o,
  label: label$o,
  login: login$o,
  number: number$o,
  plot: plot$o,
  radio: radio$o,
  slider: slider$o,
  upload_text: upload_text$o,
  video: video$o
}, Symbol.toStringTag, { value: "Module" }));
const _name$n = "فارسی";
const annotated_image$n = {
  annotated_image: "تصویر حاشیه‌نویسی شده"
};
const audio$n = {
  allow_recording_access: "لطفاً برای ضبط صدا، دسترسی به میکروفون را مجاز کنید.",
  audio: "صدا",
  record_from_microphone: "ضبط از میکروفون",
  stop_recording: "توقف ضبط",
  no_device_support: "دسترسی به دستگاه‌های رسانه‌ای امکان‌پذیر نیست. اطمینان حاصل کنید که در یک منبع امن (https) یا localhost اجرا می‌شود (یا یک گواهی SSL معتبر به ssl_verify داده‌اید)، و به مرورگر اجازه دسترسی به دستگاه خود را داده‌اید.",
  stop: "توقف",
  resume: "ادامه",
  record: "ضبط",
  no_microphone: "میکروفونی یافت نشد",
  pause: "مکث",
  play: "پخش",
  waiting: "در حال انتظار",
  drop_to_upload: "فایل صوتی خود را اینجا رها کنید تا بارگذاری شود"
};
const blocks$n = {
  connection_can_break: "در موبایل، اگر این تب از حالت فعال خارج شود یا دستگاه به خواب برود، اتصال می‌تواند قطع شود و موقعیت شما در صف از دست می‌رود.",
  long_requests_queue: "صف طولانی از درخواست‌های در انتظار وجود دارد. برای رد کردن صف، این Space را تکثیر کنید.",
  lost_connection: "اتصال به دلیل ترک صفحه قطع شد. در حال بازگشت به صف...",
  waiting_for_inputs: "در انتظار به پایان رسیدن بارگذاری فایل‌ها، لطفاً مجدداً امتحان کنید."
};
const checkbox$n = {
  checkbox: "چک‌باکس",
  checkbox_group: "گروه چک‌باکس"
};
const code$n = {
  code: "کد"
};
const color_picker$n = {
  color_picker: "انتخابگر رنگ"
};
const common$n = {
  built_with: "ساخته شده با",
  built_with_gradio: "ساخته شده با Gradio",
  clear: "پاک کردن",
  download: "دانلود",
  edit: "ویرایش",
  empty: "خالی",
  error: "خطا",
  hosted_on: "میزبانی شده در",
  loading: "در حال بارگذاری",
  logo: "لوگو",
  or: "یا",
  remove: "حذف",
  settings: "تنظیمات",
  share: "اشتراک‌گذاری",
  submit: "ارسال",
  undo: "واگرد",
  no_devices: "هیچ دستگاهی یافت نشد",
  language: "زبان",
  display_theme: "تم نمایش",
  pwa: "وب‌اپلیکیشن پیشرونده"
};
const dataframe$n = {
  incorrect_format: "فرمت نادرست، فقط فایل‌های CSV و TSV پشتیبانی می‌شوند",
  new_column: "افزودن ستون",
  new_row: "سطر جدید",
  add_row_above: "افزودن سطر در بالا",
  add_row_below: "افزودن سطر در پایین",
  add_column_left: "افزودن ستون در چپ",
  add_column_right: "افزودن ستون در راست",
  delete_row: "حذف سطر",
  delete_column: "حذف ستون",
  sort_column: "ستون را مرتب کنید",
  sort_ascending: "مرتب‌سازی صعودی",
  sort_descending: "مرتب‌سازی نزولی",
  drop_to_upload: "فایل‌های CSV یا TSV را اینجا رها کنید تا داده‌ها را به دیتافریم وارد کنید",
  clear_sort: "مرتب‌سازی را پاک کنید"
};
const dropdown$n = {
  dropdown: "منوی کشویی"
};
const errors$n = {
  build_error: "خطای ساخت وجود دارد",
  config_error: "خطای پیکربندی وجود دارد",
  contact_page_author: "لطفاً با نویسنده صفحه تماس بگیرید تا به او اطلاع دهید.",
  no_app_file: "فایل برنامه وجود ندارد",
  runtime_error: "خطای زمان اجرا وجود دارد",
  space_not_working: '"Space کار نمی‌کند زیرا" {0}',
  space_paused: "Space متوقف شده است",
  use_via_api: "استفاده از طریق API"
};
const file$n = {
  uploading: "در حال آپلود..."
};
const highlighted_text$n = {
  highlighted_text: "متن برجسته شده"
};
const image$n = {
  allow_webcam_access: "لطفاً برای ضبط، دسترسی به وب‌کم را مجاز کنید.",
  brush_color: "رنگ قلم",
  brush_radius: "اندازه قلم",
  image: "تصویر",
  remove_image: "حذف تصویر",
  select_brush_color: "انتخاب رنگ قلم",
  start_drawing: "شروع طراحی",
  use_brush: "استفاده از قلم",
  drop_to_upload: "فایل تصویر را اینجا رها کنید تا آپلود شود"
};
const label$n = {
  label: "برچسب"
};
const login$n = {
  enable_cookies: "اگر در حالت ناشناس از HuggingFace Space بازدید می‌کنید، باید کوکی‌های شخص ثالث را فعال کنید.",
  incorrect_credentials: "اطلاعات ورود نادرست",
  username: "نام کاربری",
  password: "رمز عبور",
  login: "ورود"
};
const number$n = {
  number: "عدد"
};
const plot$n = {
  plot: "نمودار"
};
const radio$n = {
  radio: "دکمه رادیویی"
};
const slider$n = {
  slider: "اسلایدر"
};
const upload_text$n = {
  click_to_upload: "برای آپلود کلیک کنید",
  drop_audio: "فایل صوتی را اینجا رها کنید",
  drop_csv: "CSV را اینجا رها کنید",
  drop_file: "فایل را اینجا رها کنید",
  drop_image: "تصویر را اینجا رها کنید",
  drop_video: "ویدیو را اینجا رها کنید",
  drop_gallery: "رسانه را اینجا رها کنید",
  paste_clipboard: "چسباندن از کلیپ‌بورد"
};
const video$n = {
  drop_to_upload: "فایل ویدیو را اینجا رها کنید تا آپلود شود"
};
const chatbot$n = {
  edit: "ویرایش",
  retry: "تلاش مجدد",
  undo: "بازگشت",
  submit: "ارسال",
  cancel: "لغو",
  like: "پسندیدم",
  dislike: "نپسندیدم",
  clear: "پاک کردن گفتگو"
};
const fa = {
  _name: _name$n,
  "3D_model": {
    "3d_model": "مدل سه‌بعدی",
    drop_to_upload: "فایل مدل سه‌بعدی (.obj، .glb، .stl، .gltf، .splat یا .ply) را اینجا رها کنید تا بارگذاری شود."
  },
  annotated_image: annotated_image$n,
  audio: audio$n,
  blocks: blocks$n,
  checkbox: checkbox$n,
  code: code$n,
  color_picker: color_picker$n,
  common: common$n,
  dataframe: dataframe$n,
  dropdown: dropdown$n,
  errors: errors$n,
  file: file$n,
  highlighted_text: highlighted_text$n,
  image: image$n,
  label: label$n,
  login: login$n,
  number: number$n,
  plot: plot$n,
  radio: radio$n,
  slider: slider$n,
  upload_text: upload_text$n,
  video: video$n,
  chatbot: chatbot$n
};
const __vite_glob_0_7 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$n,
  annotated_image: annotated_image$n,
  audio: audio$n,
  blocks: blocks$n,
  chatbot: chatbot$n,
  checkbox: checkbox$n,
  code: code$n,
  color_picker: color_picker$n,
  common: common$n,
  dataframe: dataframe$n,
  default: fa,
  dropdown: dropdown$n,
  errors: errors$n,
  file: file$n,
  highlighted_text: highlighted_text$n,
  image: image$n,
  label: label$n,
  login: login$n,
  number: number$n,
  plot: plot$n,
  radio: radio$n,
  slider: slider$n,
  upload_text: upload_text$n,
  video: video$n
}, Symbol.toStringTag, { value: "Module" }));
const _name$m = "Suomi";
const annotated_image$m = {
  annotated_image: "Merkitty kuva"
};
const audio$m = {
  allow_recording_access: "Anna lupa mikrofonin käyttöön nauhoitusta varten.",
  audio: "Ääni",
  record_from_microphone: "Nauhoita mikrofonista",
  stop_recording: "Lopeta nauhoitus",
  no_device_support: "Medialaitteisiin ei saada yhteyttä. Varmista, että käytät suojattua lähdettä (https) tai localhostia (tai olet antanut kelvollisen SSL-varmenteen ssl_verify:lle), ja olet antanut selaimelle luvan käyttää laitettasi.",
  stop: "Pysäytä",
  resume: "Jatka",
  record: "Nauhoita",
  no_microphone: "Mikrofonia ei löydy",
  pause: "Tauko",
  play: "Toista",
  waiting: "Odotetaan",
  drop_to_upload: "Lataa kuvatiedosto tähän pudottamalla se"
};
const blocks$m = {
  connection_can_break: "Mobiililaitteilla yhteys voi katketa, jos tämä välilehti menettää fokuksen tai laite menee lepotilaan, jolloin paikkasi jonossa menetetään.",
  long_requests_queue: "Jonossa on paljon odottavia pyyntöjä. Monista tämä Space ohittaaksesi jonon.",
  lost_connection: "Yhteys katkesi sivulta poistumisen vuoksi. Palataan jonoon...",
  waiting_for_inputs: "Odotetaan tiedostojen lataamisen päättymistä, yritä uudelleen."
};
const checkbox$m = {
  checkbox: "Valintaruutu",
  checkbox_group: "Valintaruuturyhmä"
};
const code$m = {
  code: "Koodi"
};
const color_picker$m = {
  color_picker: "Värivalitsin"
};
const common$m = {
  built_with: "Tehty käyttäen",
  built_with_gradio: "Tehty Gradiolla",
  clear: "Tyhjennä",
  download: "Lataa",
  edit: "Muokkaa",
  empty: "Tyhjä",
  error: "Virhe",
  hosted_on: "Isännöity palvelimella",
  loading: "Ladataan",
  logo: "logo",
  or: "tai",
  remove: "Poista",
  settings: "Asetukset",
  share: "Jaa",
  submit: "Lähetä",
  undo: "Kumoa",
  no_devices: "Laitteita ei löytynyt",
  language: "Kieli",
  display_theme: "Näyttöteema",
  pwa: "Progressiivinen verkkosovellus"
};
const dataframe$m = {
  incorrect_format: "Väärä muoto, vain CSV- ja TSV-tiedostot ovat tuettuja",
  new_column: "Lisää sarake",
  new_row: "Uusi rivi",
  add_row_above: "Lisää rivi yläpuolelle",
  add_row_below: "Lisää rivi alapuolelle",
  add_column_left: "Lisää sarake vasemmalle",
  add_column_right: "Lisää sarake oikealle",
  delete_row: "Poista rivi",
  delete_column: "Poista sarake",
  sort_column: "Lajittele sarake",
  sort_ascending: "Lajittele nousevaan järjestykseen",
  sort_descending: "Lajittele laskevaan järjestykseen",
  drop_to_upload: "Lataa CSV- tai TSV-tiedostoja tähän tuodaaksesi datan dataframeen.",
  clear_sort: "Tyhjennä järjestys"
};
const dropdown$m = {
  dropdown: "Pudotusvalikko"
};
const errors$m = {
  build_error: "rakennusvirhe",
  config_error: "määritysvirhe",
  contact_page_author: "Ota yhteyttä sivun tekijään ilmoittaaksesi.",
  no_app_file: "sovellustiedostoa ei ole",
  runtime_error: "ajonaikainen virhe",
  space_not_working: '"Space ei toimi koska" {0}',
  space_paused: "Space on keskeytetty",
  use_via_api: "Käytä API:n kautta"
};
const file$m = {
  uploading: "Ladataan..."
};
const highlighted_text$m = {
  highlighted_text: "Korostettu teksti"
};
const image$m = {
  allow_webcam_access: "Anna lupa web-kameran käyttöön nauhoitusta varten.",
  brush_color: "Siveltimen väri",
  brush_radius: "Siveltimen koko",
  image: "Kuva",
  remove_image: "Poista kuva",
  select_brush_color: "Valitse siveltimen väri",
  start_drawing: "Aloita piirtäminen",
  use_brush: "Käytä sivellintä",
  drop_to_upload: "Lataa kuva tiedosto tähän pudottamalla se"
};
const label$m = {
  label: "Tunniste"
};
const login$m = {
  enable_cookies: "Jos vierailet HuggingFace Spacessa Incognito-tilassa, sinun täytyy sallia kolmannen osapuolen evästeet.",
  incorrect_credentials: "Virheelliset kirjautumistiedot",
  username: "käyttäjätunnus",
  password: "salasana",
  login: "Kirjaudu sisään"
};
const number$m = {
  number: "Numero"
};
const plot$m = {
  plot: "Kaavio"
};
const radio$m = {
  radio: "Valintanappi"
};
const slider$m = {
  slider: "Liukusäädin"
};
const upload_text$m = {
  click_to_upload: "Napsauta ladataksesi",
  drop_audio: "Pudota äänitiedosto tähän",
  drop_csv: "Pudota CSV-tiedosto tähän",
  drop_file: "Pudota tiedosto tähän",
  drop_image: "Pudota kuva tähän",
  drop_video: "Pudota video tähän",
  drop_gallery: "Pudota media tähän",
  paste_clipboard: "Liitä leikepöydältä"
};
const video$m = {
  drop_to_upload: "Lataa videotiedosto pudottamalla se tähän."
};
const chatbot$m = {
  edit: "Muokkaa",
  retry: "Yritä uudelleen",
  undo: "Kumoa",
  submit: "Lähetä",
  cancel: "Peruuta",
  like: "Tykkää",
  dislike: "En tykkää",
  clear: "Tyhjennä keskustelu"
};
const fi = {
  _name: _name$m,
  "3D_model": {
    "3d_model": "3D-malli",
    drop_to_upload: "Lataa 3D-malli (.obj, .glb, .stl, .gltf, .splat tai .ply) tähän pudottamalla tiedosto."
  },
  annotated_image: annotated_image$m,
  audio: audio$m,
  blocks: blocks$m,
  checkbox: checkbox$m,
  code: code$m,
  color_picker: color_picker$m,
  common: common$m,
  dataframe: dataframe$m,
  dropdown: dropdown$m,
  errors: errors$m,
  file: file$m,
  highlighted_text: highlighted_text$m,
  image: image$m,
  label: label$m,
  login: login$m,
  number: number$m,
  plot: plot$m,
  radio: radio$m,
  slider: slider$m,
  upload_text: upload_text$m,
  video: video$m,
  chatbot: chatbot$m
};
const __vite_glob_0_8 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$m,
  annotated_image: annotated_image$m,
  audio: audio$m,
  blocks: blocks$m,
  chatbot: chatbot$m,
  checkbox: checkbox$m,
  code: code$m,
  color_picker: color_picker$m,
  common: common$m,
  dataframe: dataframe$m,
  default: fi,
  dropdown: dropdown$m,
  errors: errors$m,
  file: file$m,
  highlighted_text: highlighted_text$m,
  image: image$m,
  label: label$m,
  login: login$m,
  number: number$m,
  plot: plot$m,
  radio: radio$m,
  slider: slider$m,
  upload_text: upload_text$m,
  video: video$m
}, Symbol.toStringTag, { value: "Module" }));
const _name$l = "Français";
const annotated_image$l = {
  annotated_image: "Image annotée"
};
const audio$l = {
  allow_recording_access: "Veuillez autoriser l'accès au microphone pour l'enregistrement.",
  audio: "Audio",
  record_from_microphone: "Enregistrer depuis le microphone",
  stop_recording: "Arrêter l'enregistrement",
  no_device_support: "Impossible d'accéder aux périphériques multimédias. Assurez-vous que vous êtes sur une source sécurisée (https) ou localhost (ou avez passé un certificat SSL valide à ssl_verify), et que vous avez autorisé l'accès du navigateur à votre appareil.",
  stop: "Arrêter",
  resume: "Reprendre",
  record: "Enregistrer",
  no_microphone: "Aucun microphone trouvé",
  pause: "Pause",
  play: "Lecture",
  waiting: "En attente",
  drop_to_upload: "Déposez un fichier audio ici pour le télécharger"
};
const blocks$l = {
  connection_can_break: "Sur mobile, la connexion peut être interrompue si cet onglet perd le focus ou si l'appareil se met en veille, perdant votre position dans la file d'attente.",
  long_requests_queue: "Il y a une longue file d'attente de requêtes en attente. Dupliquez ce Space pour la contourner.",
  lost_connection: "Connexion perdue en quittant la page. Retour à la file d'attente...",
  waiting_for_inputs: "En attente de la fin du téléchargement des fichier(s), veuillez réessayer."
};
const checkbox$l = {
  checkbox: "Case à cocher",
  checkbox_group: "Groupe de cases à cocher"
};
const code$l = {
  code: "Code"
};
const color_picker$l = {
  color_picker: "Sélecteur de couleur"
};
const common$l = {
  built_with: "créé avec",
  built_with_gradio: "Créé avec Gradio",
  clear: "Effacer",
  download: "Télécharger",
  edit: "Modifier",
  empty: "Vide",
  flag: "Marquer",
  error: "Erreur",
  hosted_on: "Hébergé sur",
  loading: "Chargement",
  logo: "logo",
  or: "ou",
  remove: "Supprimer",
  settings: "Paramètres",
  share: "Partager",
  submit: "Envoyer",
  undo: "Annuler",
  no_devices: "Aucun périphérique trouvé",
  language: "Langue",
  display_theme: "Thème d'affichage",
  pwa: "Application web progressive",
  run: "Exécuter"
};
const dataframe$l = {
  incorrect_format: "Format incorrect, seuls les fichiers CSV et TSV sont pris en charge",
  new_column: "Ajouter une colonne",
  new_row: "Nouvelle ligne",
  add_row_above: "Ajouter une ligne au-dessus",
  add_row_below: "Ajouter une ligne en dessous",
  add_column_left: "Ajouter une colonne à gauche",
  add_column_right: "Ajouter une colonne à droite",
  delete_row: "Supprimer la ligne",
  delete_column: "Supprimer la colonne",
  sort_column: "Trier la colonne",
  sort_ascending: "Trier par ordre croissant",
  sort_descending: "Trier par ordre décroissant",
  drop_to_upload: "Déposez ici les fichiers CSV ou TSV pour importer les données dans le dataframe.",
  clear_sort: "Effacer le tri"
};
const dropdown$l = {
  dropdown: "Menu déroulant"
};
const errors$l = {
  build_error: "il y a une erreur de construction",
  config_error: "il y a une erreur de configuration",
  contact_page_author: "Veuillez contacter l'auteur de la page pour l'informer.",
  no_app_file: "il n'y a pas de fichier d'application",
  runtime_error: "il y a une erreur d'exécution",
  space_not_working: '"Le Space ne fonctionne pas car" {0}',
  space_paused: "le Space est en pause",
  use_via_api: "Utiliser via API",
  use_via_api_or_mcp: "Utiliser via API ou MCP"
};
const file$l = {
  uploading: "Téléchargement..."
};
const highlighted_text$l = {
  highlighted_text: "Texte surligné"
};
const image$l = {
  allow_webcam_access: "Veuillez autoriser l'accès à la webcam pour l'enregistrement.",
  brush_color: "Couleur du pinceau",
  brush_radius: "Taille du pinceau",
  image: "Image",
  remove_image: "Supprimer l'image",
  select_brush_color: "Sélectionner la couleur du pinceau",
  start_drawing: "Commencer à dessiner",
  use_brush: "Utiliser le pinceau",
  drop_to_upload: "Déposez un fichier image ici pour télécharger"
};
const label$l = {
  label: "Étiquette"
};
const login$l = {
  enable_cookies: "Si vous visitez un Space HuggingFace en mode Incognito, vous devez activer les cookies tiers.",
  incorrect_credentials: "Identifiants incorrects",
  username: "nom d'utilisateur",
  password: "mot de passe",
  login: "Connexion"
};
const number$l = {
  number: "Nombre"
};
const plot$l = {
  plot: "Graphique"
};
const radio$l = {
  radio: "Bouton radio"
};
const slider$l = {
  slider: "Curseur"
};
const upload_text$l = {
  click_to_upload: "Cliquez pour télécharger un fichier",
  drop_audio: "Déposez l'audio ici",
  drop_csv: "Déposez le fichier CSV ici",
  drop_file: "Déposez le fichier ici",
  drop_image: "Déposez l'image ici",
  drop_video: "Déposez la vidéo ici",
  drop_gallery: "Déposez les médias ici",
  paste_clipboard: "Coller depuis le presse-papiers"
};
const video$l = {
  drop_to_upload: "Déposez un fichier vidéo ici pour le télécharger"
};
const chatbot$l = {
  edit: "Modifier",
  retry: "Réessayer",
  undo: "Annuler",
  submit: "Envoyer",
  cancel: "Annuler",
  like: "J'aime",
  dislike: "Je n'aime pas",
  clear: "Effacer la conversation"
};
const fr = {
  _name: _name$l,
  "3D_model": {
    "3d_model": "Modèle 3D",
    drop_to_upload: "Déposez un fichier image ici pour le télécharger"
  },
  annotated_image: annotated_image$l,
  audio: audio$l,
  blocks: blocks$l,
  checkbox: checkbox$l,
  code: code$l,
  color_picker: color_picker$l,
  common: common$l,
  dataframe: dataframe$l,
  dropdown: dropdown$l,
  errors: errors$l,
  file: file$l,
  highlighted_text: highlighted_text$l,
  image: image$l,
  label: label$l,
  login: login$l,
  number: number$l,
  plot: plot$l,
  radio: radio$l,
  slider: slider$l,
  upload_text: upload_text$l,
  video: video$l,
  chatbot: chatbot$l
};
const __vite_glob_0_9 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$l,
  annotated_image: annotated_image$l,
  audio: audio$l,
  blocks: blocks$l,
  chatbot: chatbot$l,
  checkbox: checkbox$l,
  code: code$l,
  color_picker: color_picker$l,
  common: common$l,
  dataframe: dataframe$l,
  default: fr,
  dropdown: dropdown$l,
  errors: errors$l,
  file: file$l,
  highlighted_text: highlighted_text$l,
  image: image$l,
  label: label$l,
  login: login$l,
  number: number$l,
  plot: plot$l,
  radio: radio$l,
  slider: slider$l,
  upload_text: upload_text$l,
  video: video$l
}, Symbol.toStringTag, { value: "Module" }));
const _name$k = "עברית";
const annotated_image$k = {
  annotated_image: "תמונה מוערת"
};
const audio$k = {
  allow_recording_access: "אנא אפשר/י גישה למיקרופון להקלטה.",
  audio: "שמע",
  record_from_microphone: "הקלט ממיקרופון",
  stop_recording: "עצור הקלטה",
  no_device_support: "לא ניתן לגשת להתקני מדיה. וודא שאתה מריץ ממקור מאובטח (https) או localhost (או שהעברת אישור SSL תקף ל-ssl_verify), ושאישרת לדפדפן גישה למכשיר שלך.",
  stop: "עצור",
  resume: "המשך",
  record: "הקלט",
  no_microphone: "לא נמצא מיקרופון",
  pause: "השהה",
  play: "נגן",
  waiting: "ממתין",
  drop_to_upload: "הטילו קובץ אודיו כאן כדי להעלות"
};
const blocks$k = {
  connection_can_break: "בנייד, החיבור עלול להתנתק אם כרטיסייה זו מאבדת מיקוד או המכשיר נכנס למצב שינה, מה שיגרום לאיבוד מקומך בתור.",
  long_requests_queue: "יש תור ארוך של בקשות ממתינות. שכפל Space זה כדי לדלג על התור.",
  lost_connection: "החיבור אבד בגלל עזיבת העמוד. חוזר לתור...",
  waiting_for_inputs: "מחכים לסיום העלאה של הקבצים, אנא נסה שוב."
};
const checkbox$k = {
  checkbox: "תיבת סימון",
  checkbox_group: "קבוצת תיבות סימון"
};
const code$k = {
  code: "קוד"
};
const color_picker$k = {
  color_picker: "בוחר צבעים"
};
const common$k = {
  built_with: "נבנה עם",
  built_with_gradio: "נבנה עם Gradio",
  clear: "נקה",
  download: "הורד",
  edit: "ערוך",
  empty: "ריק",
  error: "שגיאה",
  hosted_on: "מאוחסן ב",
  loading: "טוען",
  logo: "לוגו",
  or: "או",
  remove: "הסר",
  settings: "הגדרות",
  share: "שתף",
  submit: "שלח",
  undo: "בטל",
  no_devices: "לא נמצאו התקנים",
  language: "שפה",
  display_theme: "ערכת נושא",
  pwa: "יישום ווב מתקדם"
};
const dataframe$k = {
  incorrect_format: "פורמט שגוי, רק קבצי CSV ו-TSV נתמכים",
  new_column: "הוסף עמודה",
  new_row: "שורה חדשה",
  add_row_above: "הוסף שורה מעל",
  add_row_below: "הוסף שורה מתחת",
  add_column_left: "הוסף עמודה משמאל",
  add_column_right: "הוסף עמודה מימין",
  delete_row: "מחק שורה",
  delete_column: "מחק עמודה",
  sort_column: "מיין עמודה",
  sort_ascending: "מיין בסדר עולה",
  sort_descending: "מיין בסדר יורד",
  drop_to_upload: "הטילו קבצי CSV או TSV כאן כדי לייבא נתונים לתוך dataframe",
  clear_sort: "נקה סדר"
};
const dropdown$k = {
  dropdown: "תפריט נפתח"
};
const errors$k = {
  build_error: "יש שגיאת בנייה",
  config_error: "יש שגיאת תצורה",
  contact_page_author: "אנא צור קשר עם מחבר העמוד כדי ליידע אותו.",
  no_app_file: "אין קובץ יישום",
  runtime_error: "יש שגיאת זמן ריצה",
  space_not_working: '"ה-Space לא עובד כי" {0}',
  space_paused: "ה-Space מושהה",
  use_via_api: "השתמש דרך API"
};
const file$k = {
  uploading: "מעלה..."
};
const highlighted_text$k = {
  highlighted_text: "טקסט מודגש"
};
const image$k = {
  allow_webcam_access: "אנא אפשר גישה למצלמת האינטרנט להקלטה.",
  brush_color: "צבע מברשת",
  brush_radius: "גודל מברשת",
  image: "תמונה",
  remove_image: "הסר תמונה",
  select_brush_color: "בחר צבע מברשת",
  start_drawing: "התחל לצייר",
  use_brush: "השתמש במברשת",
  drop_to_upload: "הטילו קובץ תמונה כאן כדי להעלות"
};
const label$k = {
  label: "תווית"
};
const login$k = {
  enable_cookies: "אם אתה מבקר ב-Space של HuggingFace במצב גלישה בסתר, עליך לאפשר קובצי cookie של צד שלישי.",
  incorrect_credentials: "פרטי התחברות שגויים",
  username: "שם משתמש",
  password: "סיסמה",
  login: "התחבר"
};
const number$k = {
  number: "מספר"
};
const plot$k = {
  plot: "תרשים"
};
const radio$k = {
  radio: "כפתור רדיו"
};
const slider$k = {
  slider: "מחוון"
};
const upload_text$k = {
  click_to_upload: "לחץ להעלאה",
  drop_audio: "שחרר קובץ שמע כאן",
  drop_csv: "שחרר קובץ CSV כאן",
  drop_file: "שחרר קובץ כאן",
  drop_image: "שחרר תמונה כאן",
  drop_video: "שחרר וידאו כאן",
  drop_gallery: "שחרר מדיה כאן",
  paste_clipboard: "הדבק מהלוח"
};
const video$k = {
  drop_to_upload: "הטילו קובץ וידאו כאן כדי להעלות"
};
const chatbot$k = {
  edit: "עריכה",
  retry: "נסה שוב",
  undo: "בטל",
  submit: "שלח",
  cancel: "ביטול",
  like: "אהבתי",
  dislike: "לא אהבתי",
  clear: "נקה שיחה"
};
const he = {
  _name: _name$k,
  "3D_model": {
    "3d_model": "מודל תלת מימד",
    drop_to_upload: "הטילו קובץ מודל 3D (.obj, .glb, .stl, .gltf, .splat או .ply) כאן כדי להעלות"
  },
  annotated_image: annotated_image$k,
  audio: audio$k,
  blocks: blocks$k,
  checkbox: checkbox$k,
  code: code$k,
  color_picker: color_picker$k,
  common: common$k,
  dataframe: dataframe$k,
  dropdown: dropdown$k,
  errors: errors$k,
  file: file$k,
  highlighted_text: highlighted_text$k,
  image: image$k,
  label: label$k,
  login: login$k,
  number: number$k,
  plot: plot$k,
  radio: radio$k,
  slider: slider$k,
  upload_text: upload_text$k,
  video: video$k,
  chatbot: chatbot$k
};
const __vite_glob_0_10 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$k,
  annotated_image: annotated_image$k,
  audio: audio$k,
  blocks: blocks$k,
  chatbot: chatbot$k,
  checkbox: checkbox$k,
  code: code$k,
  color_picker: color_picker$k,
  common: common$k,
  dataframe: dataframe$k,
  default: he,
  dropdown: dropdown$k,
  errors: errors$k,
  file: file$k,
  highlighted_text: highlighted_text$k,
  image: image$k,
  label: label$k,
  login: login$k,
  number: number$k,
  plot: plot$k,
  radio: radio$k,
  slider: slider$k,
  upload_text: upload_text$k,
  video: video$k
}, Symbol.toStringTag, { value: "Module" }));
const _name$j = "हिंदी";
const annotated_image$j = {
  annotated_image: "एनोटेट की गई छवि"
};
const audio$j = {
  allow_recording_access: "कृपया रिकॉर्डिंग के लिए माइक्रोफ़ोन एक्सेस की अनुमति दें।",
  audio: "ऑडियो",
  record_from_microphone: "माइक्रोफ़ोन से रिकॉर्ड करें",
  stop_recording: "रिकॉर्डिंग रोकें",
  no_device_support: "मीडिया डिवाइस तक पहुंच नहीं हो सकी। सुनिश्चित करें कि आप एक सुरक्षित स्रोत (https) या localhost पर चल रहे हैं (या ssl_verify को एक वैध SSL प्रमाणपत्र दिया है), और आपने अपने ब्राउज़र को अपने डिवाइस तक पहुंच की अनुमति दी है।",
  stop: "रोकें",
  resume: "जारी रखें",
  record: "रिकॉर्ड",
  no_microphone: "कोई माइक्रोफ़ोन नहीं मिला",
  pause: "रोकें",
  play: "चलाएं",
  waiting: "प्रतीक्षा कर रहा है",
  drop_to_upload: "यहाँ एक ऑडियो फाइल डालें अपलोड करने के लिए"
};
const blocks$j = {
  connection_can_break: "मोबाइल पर, यदि यह टैब फोकस खो देता है या डिवाइस स्लीप मोड में चला जाता है, तो कनेक्शन टूट सकता है, जिससे कतार में आपका स्थान खो जाएगा।",
  long_requests_queue: "लंबित अनुरोधों की एक लंबी कतार है। इसे छोड़ने के लिए इस Space को डुप्लिकेट करें।",
  lost_connection: "पेज छोड़ने के कारण कनेक्शन टूट गया। कतार में वापस जा रहा है...",
  waiting_for_inputs: "फाइलें अपलोड होने का इंतजार कर रहे हैं, कृपया पुन: प्रयास करें।"
};
const checkbox$j = {
  checkbox: "चेकबॉक्स",
  checkbox_group: "चेकबॉक्स समूह"
};
const code$j = {
  code: "कोड"
};
const color_picker$j = {
  color_picker: "रंग चयनकर्ता"
};
const common$j = {
  built_with: "के साथ बनाया गया",
  built_with_gradio: "Gradio के साथ बनाया गया",
  clear: "साफ़ करें",
  download: "डाउनलोड",
  edit: "संपादित करें",
  empty: "खाली",
  error: "त्रुटि",
  hosted_on: "पर होस्ट किया गया",
  loading: "लोड हो रहा है",
  logo: "लोगो",
  or: "या",
  remove: "हटाएं",
  settings: "सेटिंग्स",
  share: "साझा करें",
  submit: "सबमिट करें",
  undo: "पूर्ववत करें",
  no_devices: "कोई डिवाइस नहीं मिला",
  language: "भाषा",
  display_theme: "प्रदर्शन थीम",
  pwa: "प्रोग्रेसिव वेब ऐप"
};
const dataframe$j = {
  incorrect_format: "गलत प्रारूप, केवल CSV और TSV फ़ाइलें समर्थित हैं",
  new_column: "कॉलम जोड़ें",
  new_row: "नई पंक्ति",
  add_row_above: "ऊपर पंक्ति जोड़ें",
  add_row_below: "नीचे पंक्ति जोड़ें",
  add_column_left: "बाएं कॉलम जोड़ें",
  add_column_right: "दाएं कॉलम जोड़ें",
  delete_row: "पंक्ति हटाएं",
  delete_column: "कॉलम हटाएं",
  sort_column: "कॉलम को क्रमबद्ध करें",
  sort_ascending: "आरोही क्रम में क्रमबद्ध करें",
  sort_descending: "अवरोही क्रम में क्रमबद्ध करें",
  drop_to_upload: "यहाँ CSV या TSV फाइलें ड्रॉप करें ताकि डेटा डेटाफ़्रेम में आयात किया जा सके",
  clear_sort: "क्रमबद्धता हटाएं"
};
const dropdown$j = {
  dropdown: "ड्रॉपडाउन"
};
const errors$j = {
  build_error: "एक बिल्ड त्रुटि है",
  config_error: "एक कॉन्फ़िगरेशन त्रुटि है",
  contact_page_author: "कृपया पेज के लेखक को सूचित करने के लिए संपर्क करें।",
  no_app_file: "कोई ऐप फ़ाइल नहीं है",
  runtime_error: "एक रनटाइम त्रुटि है",
  space_not_working: '"Space काम नहीं कर रहा है क्योंकि" {0}',
  space_paused: "Space रोका गया है",
  use_via_api: "API के माध्यम से उपयोग करें"
};
const file$j = {
  uploading: "अपलोड हो रहा है..."
};
const highlighted_text$j = {
  highlighted_text: "हाइलाइट किया गया टेक्स्ट"
};
const image$j = {
  allow_webcam_access: "कृपया रिकॉर्डिंग के लिए वेबकैम एक्सेस की अनुमति दें।",
  brush_color: "ब्रश का रंग",
  brush_radius: "ब्रश का आकार",
  image: "छवि",
  remove_image: "छवि हटाएं",
  select_brush_color: "ब्रश का रंग चुनें",
  start_drawing: "चित्रकारी शुरू करें",
  use_brush: "ब्रश का उपयोग करें",
  drop_to_upload: "यहाँ एक छवि फाइल डालें अपलोड करने के लिए"
};
const label$j = {
  label: "लेबल"
};
const login$j = {
  enable_cookies: "यदि आप इनकॉग्निटो मोड में HuggingFace Space का दौरा कर रहे हैं, तो आपको थर्ड-पार्टी कुकीज़ को सक्षम करना होगा।",
  incorrect_credentials: "गलत क्रेडेंशियल्स",
  username: "उपयोगकर्ता नाम",
  password: "पासवर्ड",
  login: "लॉग इन करें"
};
const number$j = {
  number: "संख्या"
};
const plot$j = {
  plot: "प्लॉट"
};
const radio$j = {
  radio: "रेडियो बटन"
};
const slider$j = {
  slider: "स्लाइडर"
};
const upload_text$j = {
  click_to_upload: "अपलोड करने के लिए क्लिक करें",
  drop_audio: "ऑडियो यहाँ छोड़ें",
  drop_csv: "CSV फाइल यहाँ छोड़ें",
  drop_file: "फ़ाइल यहाँ छोड़ें",
  drop_image: "छवि यहाँ छोड़ें",
  drop_video: "वीडियो यहाँ छोड़ें",
  drop_gallery: "मीडिया यहाँ छोड़ें",
  paste_clipboard: "क्लिपबोर्ड से पेस्ट करें"
};
const video$j = {
  drop_to_upload: "यहाँ एक वीडियो फाइल डालें अपलोड करने के लिए"
};
const chatbot$j = {
  edit: "संपादित करें",
  retry: "पुनः प्रयास करें",
  undo: "वापस लें",
  submit: "भेजें",
  cancel: "रद्द करें",
  like: "पसंद",
  dislike: "नापसंद",
  clear: "चैट साफ़ करें"
};
const hi = {
  _name: _name$j,
  "3D_model": {
    "3d_model": "3D मॉडल",
    drop_to_upload: "यहाँ 3D मॉडल (.obj, .glb, .stl, .gltf, .splat, या .ply) फ़ाइल ड्रॉप करें अपलोड करने के लिए"
  },
  annotated_image: annotated_image$j,
  audio: audio$j,
  blocks: blocks$j,
  checkbox: checkbox$j,
  code: code$j,
  color_picker: color_picker$j,
  common: common$j,
  dataframe: dataframe$j,
  dropdown: dropdown$j,
  errors: errors$j,
  file: file$j,
  highlighted_text: highlighted_text$j,
  image: image$j,
  label: label$j,
  login: login$j,
  number: number$j,
  plot: plot$j,
  radio: radio$j,
  slider: slider$j,
  upload_text: upload_text$j,
  video: video$j,
  chatbot: chatbot$j
};
const __vite_glob_0_11 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$j,
  annotated_image: annotated_image$j,
  audio: audio$j,
  blocks: blocks$j,
  chatbot: chatbot$j,
  checkbox: checkbox$j,
  code: code$j,
  color_picker: color_picker$j,
  common: common$j,
  dataframe: dataframe$j,
  default: hi,
  dropdown: dropdown$j,
  errors: errors$j,
  file: file$j,
  highlighted_text: highlighted_text$j,
  image: image$j,
  label: label$j,
  login: login$j,
  number: number$j,
  plot: plot$j,
  radio: radio$j,
  slider: slider$j,
  upload_text: upload_text$j,
  video: video$j
}, Symbol.toStringTag, { value: "Module" }));
const _name$i = "日本語";
const annotated_image$i = {
  annotated_image: "注釈付き画像"
};
const audio$i = {
  allow_recording_access: "録音のためにマイクへのアクセスを許可してください",
  audio: "音声",
  record_from_microphone: "マイクから録音",
  stop_recording: "録音を停止",
  no_device_support: "メディアデバイスにアクセスできません。安全なソース（https）またはlocalhostで実行していること（またはssl_verifyに有効なSSL証明書を渡していること）、ブラウザにデバイスへのアクセスを許可していることを確認してください",
  stop: "停止",
  resume: "再開",
  record: "録音",
  no_microphone: "マイクが見つかりません",
  pause: "一時停止",
  play: "再生",
  waiting: "待機中",
  drop_to_upload: "ここにオーディオファイルをドロップしてアップロードしてください"
};
const blocks$i = {
  connection_can_break: "モバイルでは、このタブがフォーカスを失うかデバイスがスリープモードになると接続が切断され、キュー内の位置が失われる可能性があります",
  long_requests_queue: "保留中のリクエストの長いキューがあります。このSpaceを複製してスキップしてください",
  lost_connection: "ページを離れたため接続が切断されました。キューに戻ります...",
  waiting_for_inputs: "ファイルのアップロードが完了するのを待っています。再度お試しください"
};
const checkbox$i = {
  checkbox: "チェックボックス",
  checkbox_group: "チェックボックスグループ"
};
const code$i = {
  code: "コード"
};
const color_picker$i = {
  color_picker: "カラーピッカー"
};
const common$i = {
  built_with: "で作成",
  built_with_gradio: "Gradioで作成",
  clear: "クリア",
  download: "ダウンロード",
  edit: "編集",
  empty: "空",
  error: "エラー",
  hosted_on: "でホスト",
  loading: "読み込み中",
  logo: "ロゴ",
  or: "または",
  remove: "削除",
  settings: "設定",
  share: "共有",
  submit: "送信",
  undo: "元に戻す",
  no_devices: "デバイスが見つかりません",
  language: "言語",
  display_theme: "表示テーマ",
  pwa: "プログレッシブウェブアプリ"
};
const dataframe$i = {
  incorrect_format: "不正なフォーマット、CSVとTSVファイルのみサポートされています",
  new_column: "列を追加",
  new_row: "新しい行",
  add_row_above: "上に行を追加",
  add_row_below: "下に行を追加",
  add_column_left: "左に列を追加",
  add_column_right: "右に列を追加",
  delete_row: "行を削除",
  delete_column: "列を削除",
  sort_column: "列をソート",
  sort_ascending: "昇順に並べ替え",
  sort_descending: "降順に並べ替え",
  drop_to_upload: "CSVまたはTSVファイルをここにドロップして、データをデータフレームにインポートします",
  clear_sort: "ソートをクリア"
};
const dropdown$i = {
  dropdown: "ドロップダウン"
};
const errors$i = {
  build_error: "ビルドエラーがあります",
  config_error: "設定エラーがあります",
  contact_page_author: "ページの作者に連絡して知らせてください",
  no_app_file: "アプリファイルがありません",
  runtime_error: "ランタイムエラーがあります",
  space_not_working: '"Spaceが動作していません。理由：" {0}',
  space_paused: "Spaceが一時停止されています",
  use_via_api: "APIを介して使用",
  use_via_api_or_mcp: "APIまたはMCP経由で使用"
};
const file$i = {
  uploading: "アップロード中..."
};
const highlighted_text$i = {
  highlighted_text: "ハイライトされたテキスト"
};
const image$i = {
  allow_webcam_access: "録画のためにウェブカメラへのアクセスを許可してください",
  brush_color: "ブラシの色",
  brush_radius: "ブラシのサイズ",
  image: "画像",
  remove_image: "画像を削除",
  select_brush_color: "ブラシの色を選択",
  start_drawing: "描画を開始",
  use_brush: "ブラシを使用",
  drop_to_upload: "ここに画像ファイルをドロップしてアップロードしてください"
};
const label$i = {
  label: "ラベル"
};
const login$i = {
  enable_cookies: "シークレットモードでHuggingFace Spaceを訪問している場合、サードパーティのCookieを有効にする必要があります",
  incorrect_credentials: "認証情報が正しくありません",
  username: "ユーザー名",
  password: "パスワード",
  login: "ログイン"
};
const number$i = {
  number: "数値"
};
const plot$i = {
  plot: "プロット"
};
const radio$i = {
  radio: "ラジオボタン"
};
const slider$i = {
  slider: "スライダー"
};
const upload_text$i = {
  click_to_upload: "クリックしてアップロード",
  drop_audio: "音声をここにドロップ",
  drop_csv: "CSVファイルをここにドロップ",
  drop_file: "ファイルをここにドロップ",
  drop_image: "画像をここにドロップ",
  drop_video: "動画をここにドロップ",
  drop_gallery: "メディアをここにドロップ",
  paste_clipboard: "クリップボードから貼り付け"
};
const video$i = {
  drop_to_upload: "ビデオファイルをここにドロップしてアップロードしてください"
};
const chatbot$i = {
  edit: "編集",
  retry: "再試行",
  undo: "元に戻す",
  submit: "送信",
  cancel: "キャンセル",
  like: "いいね",
  dislike: "よくないね",
  clear: "会話をクリア"
};
const ja = {
  _name: _name$i,
  "3D_model": {
    "3d_model": "3Dモデル",
    drop_to_upload: "3D モデル (.obj, .glb, .stl, .gltf, .splat, .ply) ファイルをここにドロップしてアップロードしてください"
  },
  annotated_image: annotated_image$i,
  audio: audio$i,
  blocks: blocks$i,
  checkbox: checkbox$i,
  code: code$i,
  color_picker: color_picker$i,
  common: common$i,
  dataframe: dataframe$i,
  dropdown: dropdown$i,
  errors: errors$i,
  file: file$i,
  highlighted_text: highlighted_text$i,
  image: image$i,
  label: label$i,
  login: login$i,
  number: number$i,
  plot: plot$i,
  radio: radio$i,
  slider: slider$i,
  upload_text: upload_text$i,
  video: video$i,
  chatbot: chatbot$i
};
const __vite_glob_0_12 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$i,
  annotated_image: annotated_image$i,
  audio: audio$i,
  blocks: blocks$i,
  chatbot: chatbot$i,
  checkbox: checkbox$i,
  code: code$i,
  color_picker: color_picker$i,
  common: common$i,
  dataframe: dataframe$i,
  default: ja,
  dropdown: dropdown$i,
  errors: errors$i,
  file: file$i,
  highlighted_text: highlighted_text$i,
  image: image$i,
  label: label$i,
  login: login$i,
  number: number$i,
  plot: plot$i,
  radio: radio$i,
  slider: slider$i,
  upload_text: upload_text$i,
  video: video$i
}, Symbol.toStringTag, { value: "Module" }));
const _name$h = "한국어";
const annotated_image$h = {
  annotated_image: "주석이 달린 이미지"
};
const audio$h = {
  allow_recording_access: "녹음을 위해 마이크 접근을 허용해 주세요.",
  audio: "오디오",
  record_from_microphone: "마이크로 녹음",
  stop_recording: "녹음 중지",
  no_device_support: "미디어 장치에 접근할 수 없습니다. 보안 소스(https) 또는 localhost에서 실행 중인지(또는 ssl_verify에 유효한 SSL 인증서를 전달했는지), 브라우저에 장치 접근 권한을 부여했는지 확인하세요.",
  stop: "중지",
  resume: "재개",
  record: "녹음",
  no_microphone: "마이크를 찾을 수 없습니다",
  pause: "일시정지",
  play: "재생",
  waiting: "대기 중",
  drop_to_upload: "오디오 파일을 여기에 놓아 업로드하세요."
};
const blocks$h = {
  connection_can_break: "모바일에서는 이 탭이 포커스를 잃거나 기기가 절전 모드로 전환되면 연결이 끊어져 대기열의 위치를 잃을 수 있습니다.",
  long_requests_queue: "대기 중인 요청의 긴 대기열이 있습니다. 이 Space를 복제하여 건너뛰세요.",
  lost_connection: "페이지를 떠나 연결이 끊어졌습니다. 대기열로 돌아가는 중...",
  waiting_for_inputs: "파일 업로드가 완료될 때까지 기다렸다가 다시 시도해주세요."
};
const checkbox$h = {
  checkbox: "체크박스",
  checkbox_group: "체크박스 그룹"
};
const code$h = {
  code: "코드"
};
const color_picker$h = {
  color_picker: "색상 선택기"
};
const common$h = {
  built_with: "로 제작됨",
  built_with_gradio: "Gradio로 제작됨",
  clear: "지우기",
  download: "다운로드",
  edit: "편집",
  empty: "비어 있음",
  error: "오류",
  hosted_on: "에서 호스팅됨",
  loading: "로딩 중",
  logo: "로고",
  or: "또는",
  remove: "제거",
  settings: "설정",
  share: "공유",
  submit: "제출",
  undo: "실행 취소",
  no_devices: "장치를 찾을 수 없습니다",
  language: "언어",
  display_theme: "디스플레이 테마",
  pwa: "프로그레시브 웹 앱"
};
const dataframe$h = {
  incorrect_format: "잘못된 형식입니다. CSV 및 TSV 파일만 지원됩니다",
  new_column: "열 추가",
  new_row: "새 행",
  add_row_above: "위에 행 추가",
  add_row_below: "아래에 행 추가",
  add_column_left: "왼쪽에 열 추가",
  add_column_right: "오른쪽에 열 추가",
  delete_row: "행 삭제",
  delete_column: "열 삭제",
  sort_column: "정렬 열",
  sort_ascending: "오름차순 정렬",
  sort_descending: "내림차순 정렬",
  drop_to_upload: "CSV 또는 TSV 파일을 여기에 끌어다 놓아 데이터프레임에 데이터를 가져올 수 있습니다.",
  clear_sort: "정렬 해제"
};
const dropdown$h = {
  dropdown: "드롭다운"
};
const errors$h = {
  build_error: "빌드 오류가 있습니다",
  config_error: "구성 오류가 있습니다",
  contact_page_author: "페이지 작성자에게 연락하여 알려주세요.",
  no_app_file: "앱 파일이 없습니다",
  runtime_error: "런타임 오류가 있습니다",
  space_not_working: '"Space가 작동하지 않는 이유:" {0}',
  space_paused: "space가 일시 중지되었습니다",
  use_via_api: "API를 통해 사용",
  use_via_api_or_mcp: "API 또는 MCP를 통해 사용"
};
const file$h = {
  uploading: "업로드 중..."
};
const highlighted_text$h = {
  highlighted_text: "강조 표시된 텍스트"
};
const image$h = {
  allow_webcam_access: "녹화를 위해 웹캠 접근을 허용해 주세요.",
  brush_color: "브러시 색상",
  brush_radius: "브러시 크기",
  image: "이미지",
  remove_image: "이미지 제거",
  select_brush_color: "브러시 색상 선택",
  start_drawing: "그리기 시작",
  use_brush: "브러시 사용",
  drop_to_upload: "이곳에 이미지 파일을 끌어다 놓으세요."
};
const label$h = {
  label: "레이블"
};
const login$h = {
  enable_cookies: "시크릿 모드에서 HuggingFace Space를 방문하는 경우 타사 쿠키를 활성화해야 합니다.",
  incorrect_credentials: "잘못된 자격 증명",
  username: "사용자 이름",
  password: "비밀번호",
  login: "로그인"
};
const number$h = {
  number: "숫자"
};
const plot$h = {
  plot: "플롯"
};
const radio$h = {
  radio: "라디오"
};
const slider$h = {
  slider: "슬라이더"
};
const upload_text$h = {
  click_to_upload: "클릭하여 업로드",
  drop_audio: "오디오를 여기에 드롭",
  drop_csv: "CSV를 여기에 드롭",
  drop_file: "파일을 여기에 드롭",
  drop_image: "이미지를 여기에 드롭",
  drop_video: "비디오를 여기에 드롭",
  drop_gallery: "미디어를 여기에 드롭",
  paste_clipboard: "클립보드에서 붙여넣기"
};
const video$h = {
  drop_to_upload: "여기에 비디오 파일을 끌어다 놓으세요."
};
const chatbot$h = {
  edit: "편집",
  retry: "다시 시도",
  undo: "실행 취소",
  submit: "제출",
  cancel: "취소",
  like: "좋아요",
  dislike: "싫어요",
  clear: "대화 지우기"
};
const ko = {
  _name: _name$h,
  "3D_model": {
    "3d_model": "3D 모델",
    drop_to_upload: "3D 모델 (.obj, .glb, .stl, .gltf, .splat, 또는 .ply) 파일을 여기에 놓아 업로드하세요."
  },
  annotated_image: annotated_image$h,
  audio: audio$h,
  blocks: blocks$h,
  checkbox: checkbox$h,
  code: code$h,
  color_picker: color_picker$h,
  common: common$h,
  dataframe: dataframe$h,
  dropdown: dropdown$h,
  errors: errors$h,
  file: file$h,
  highlighted_text: highlighted_text$h,
  image: image$h,
  label: label$h,
  login: login$h,
  number: number$h,
  plot: plot$h,
  radio: radio$h,
  slider: slider$h,
  upload_text: upload_text$h,
  video: video$h,
  chatbot: chatbot$h
};
const __vite_glob_0_13 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$h,
  annotated_image: annotated_image$h,
  audio: audio$h,
  blocks: blocks$h,
  chatbot: chatbot$h,
  checkbox: checkbox$h,
  code: code$h,
  color_picker: color_picker$h,
  common: common$h,
  dataframe: dataframe$h,
  default: ko,
  dropdown: dropdown$h,
  errors: errors$h,
  file: file$h,
  highlighted_text: highlighted_text$h,
  image: image$h,
  label: label$h,
  login: login$h,
  number: number$h,
  plot: plot$h,
  radio: radio$h,
  slider: slider$h,
  upload_text: upload_text$h,
  video: video$h
}, Symbol.toStringTag, { value: "Module" }));
const _name$g = "Lietuvių";
const common$g = {
  built_with_gradio: "Sukurta su Gradio",
  clear: "Išvalyti",
  or: "arba",
  submit: "Pateikti",
  settings: "Nustatymai",
  built_with: "sukurta su",
  download: "Atsisiųsti",
  edit: "Redaguoti",
  empty: "Tuščia",
  error: "Klaida",
  hosted_on: "Talpinama",
  loading: "Kraunama",
  logo: "logotipas",
  remove: "Pašalinti",
  share: "Dalintis",
  undo: "Atšaukti",
  no_devices: "Nerasta jokių įrenginių",
  language: "Kalba",
  display_theme: "Ekrano tema",
  pwa: "Progresyvi interneto programėlė"
};
const upload_text$g = {
  click_to_upload: "Spustelėkite norėdami įkelti",
  drop_audio: "Įkelkite garso įrašą čia",
  drop_csv: "Įkelkite CSV čia",
  drop_file: "Įkelkite failą čia",
  drop_image: "Įkelkite paveikslėlį čia",
  drop_video: "Įkelkite vaizdo įrašą čia",
  drop_gallery: "Įkelkite mediją čia",
  paste_clipboard: "Įklijuoti iš iškarpinės"
};
const annotated_image$g = {
  annotated_image: "Pažymėtas paveikslėlis"
};
const audio$g = {
  allow_recording_access: "Prašome suteikti prieigą prie mikrofono įrašymui.",
  audio: "Garsas",
  drop_to_upload: "Įkelkite garso failą čia",
  record_from_microphone: "Įrašyti iš mikrofono",
  stop_recording: "Stabdyti įrašymą",
  no_device_support: "Nepavyko pasiekti medijos įrenginių. Patikrinkite, ar naudojate saugią prieigą (https) arba localhost (arba perduodate galiojantį SSL sertifikatą į ssl_verify), ir leidžiate naršyklei prieiti prie jūsų įrenginio.",
  stop: "Stabdyti",
  resume: "Tęsti",
  record: "Įrašyti",
  no_microphone: "Mikrofonas nerastas",
  pause: "Pristabdyti",
  play: "Groti",
  waiting: "Laukiama"
};
const blocks$g = {
  connection_can_break: "Mobiliajame įrenginyje ryšys gali nutrūkti, jei šis skirtukas bus neaktyvus arba įrenginys užmigs, todėl galite prarasti savo vietą eilėje.",
  long_requests_queue: "Yra ilga laukiančių užklausų eilė. Dubliuokite šią erdvę, kad praleistumėte eilę.",
  lost_connection: "Ryšys nutrūko išėjus iš puslapio. Vėl jungiamasi į eilę...",
  waiting_for_inputs: "Laukiama, kol bus baigti įkelti failai, prašome bandyti dar kartą."
};
const checkbox$g = {
  checkbox: "Žymimasis langelis",
  checkbox_group: "Žymimųjų langelių grupė"
};
const code$g = {
  code: "Kodas"
};
const color_picker$g = {
  color_picker: "Spalvos pasirinkimas"
};
const dataframe$g = {
  incorrect_format: "Neteisingas formatas, palaikomi tik CSV ir TSV failai",
  new_column: "Pridėti stulpelį",
  new_row: "Nauja eilutė",
  add_row_above: "Pridėti eilutę viršuje",
  add_row_below: "Pridėti eilutę žemiau",
  delete_row: "Ištrinti eilutę",
  delete_column: "Ištrinti stulpelį",
  add_column_left: "Pridėti stulpelį kairėje",
  add_column_right: "Pridėti stulpelį dešinėje",
  sort_column: "Rikiuoti stulpelį",
  sort_ascending: "Rikiuoti didėjančia tvarka",
  sort_descending: "Rikiuoti mažėjančia tvarka",
  drop_to_upload: "Įkelkite CSV arba TSV failus čia, kad importuotumėte duomenis į duomenų lentelę",
  clear_sort: "Išvalyti rikiavimą"
};
const dropdown$g = {
  dropdown: "Išskleidžiamasis sąrašas"
};
const errors$g = {
  build_error: "yra kompiliavimo klaida",
  config_error: "yra konfigūracijos klaida",
  contact_page_author: "Prašome susisiekti su puslapio autoriumi.",
  no_app_file: "nėra programos failo",
  runtime_error: "yra vykdymo klaida",
  space_not_working: '"Erdvė neveikia, nes" {0}',
  space_paused: "erdvė yra pristabdyta",
  use_via_api: "Naudoti per API",
  use_via_api_or_mcp: "Naudoti per API arba MCP"
};
const file$g = {
  uploading: "Įkeliama..."
};
const highlighted_text$g = {
  highlighted_text: "Paryškintas tekstas"
};
const image$g = {
  allow_webcam_access: "Prašome suteikti prieigą prie internetinės kameros įrašymui.",
  brush_color: "Teptuko spalva",
  brush_radius: "Teptuko dydis",
  image: "Paveikslėlis",
  remove_image: "Pašalinti paveikslėlį",
  select_brush_color: "Pasirinkite teptuko spalvą",
  start_drawing: "Pradėti piešti",
  use_brush: "Naudoti teptuką",
  drop_to_upload: "Įkelkite paveikslėlio failą čia"
};
const label$g = {
  label: "Etiketė"
};
const login$g = {
  enable_cookies: "Jei lankotės HuggingFace erdvėje inkognito režimu, turite leisti trečiųjų šalių slapukus.",
  incorrect_credentials: "Neteisingi prisijungimo duomenys",
  username: "Vartotojo vardas",
  password: "Slaptažodis",
  login: "Prisijungti"
};
const number$g = {
  number: "Skaičius"
};
const plot$g = {
  plot: "Grafikas"
};
const radio$g = {
  radio: "Pasirinkimo mygtukas"
};
const slider$g = {
  slider: "Slankiklis"
};
const video$g = {
  drop_to_upload: "Įkelkite vaizdo įrašo failą čia"
};
const chatbot$g = {
  edit: "Redaguoti",
  retry: "Bandyti dar kartą",
  undo: "Atšaukti",
  submit: "Pateikti",
  cancel: "Atšaukti",
  like: "Patinka",
  dislike: "Nepatinka",
  clear: "Išvalyti pokalbį"
};
const lt = {
  _name: _name$g,
  common: common$g,
  upload_text: upload_text$g,
  "3D_model": {
    "3d_model": "3D modelis",
    drop_to_upload: "Įkelkite 3D modelio failą (.obj, .glb, .stl, .gltf, .splat arba .ply) čia"
  },
  annotated_image: annotated_image$g,
  audio: audio$g,
  blocks: blocks$g,
  checkbox: checkbox$g,
  code: code$g,
  color_picker: color_picker$g,
  dataframe: dataframe$g,
  dropdown: dropdown$g,
  errors: errors$g,
  file: file$g,
  highlighted_text: highlighted_text$g,
  image: image$g,
  label: label$g,
  login: login$g,
  number: number$g,
  plot: plot$g,
  radio: radio$g,
  slider: slider$g,
  video: video$g,
  chatbot: chatbot$g
};
const __vite_glob_0_14 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$g,
  annotated_image: annotated_image$g,
  audio: audio$g,
  blocks: blocks$g,
  chatbot: chatbot$g,
  checkbox: checkbox$g,
  code: code$g,
  color_picker: color_picker$g,
  common: common$g,
  dataframe: dataframe$g,
  default: lt,
  dropdown: dropdown$g,
  errors: errors$g,
  file: file$g,
  highlighted_text: highlighted_text$g,
  image: image$g,
  label: label$g,
  login: login$g,
  number: number$g,
  plot: plot$g,
  radio: radio$g,
  slider: slider$g,
  upload_text: upload_text$g,
  video: video$g
}, Symbol.toStringTag, { value: "Module" }));
const _name$f = "Norsk bokmål";
const annotated_image$f = {
  annotated_image: "Annotert bilde"
};
const audio$f = {
  allow_recording_access: "Vennligst tillat mikrofontilgang for opptak.",
  audio: "Lyd",
  record_from_microphone: "Ta opp fra mikrofon",
  stop_recording: "Stopp opptak",
  no_device_support: "Kan ikke få tilgang til medieenheter. Sørg for at du kjører på en sikker kilde (https) eller localhost (eller har gitt et gyldig SSL-sertifikat til ssl_verify), og at du har gitt nettleseren tilgang til enheten din.",
  stop: "Stopp",
  resume: "Fortsett",
  record: "Ta opp",
  no_microphone: "Ingen mikrofon funnet",
  pause: "Pause",
  play: "Spill av",
  waiting: "Venter",
  drop_to_upload: "Slipp en lydfil her for å laste opp"
};
const blocks$f = {
  connection_can_break: "På mobil kan tilkoblingen brytes hvis denne fanen mister fokus eller enheten går i dvale, og du mister plassen din i køen.",
  long_requests_queue: "Det er en lang kø med ventende forespørsler. Dupliser denne Space for å hoppe over køen.",
  lost_connection: "Mistet tilkobling på grunn av at siden ble forlatt. Går tilbake til køen...",
  waiting_for_inputs: "Venter på at fil(er) skal bli lastet opp, vennligst prøv igjen."
};
const checkbox$f = {
  checkbox: "Avkrysningsboks",
  checkbox_group: "Avkrysningsboksgruppe"
};
const code$f = {
  code: "Kode"
};
const color_picker$f = {
  color_picker: "Fargevelger"
};
const common$f = {
  built_with: "bygget med",
  built_with_gradio: "Bygget med Gradio",
  clear: "Tøm",
  download: "Last ned",
  edit: "Rediger",
  empty: "Tom",
  error: "Feil",
  hosted_on: "Hostet på",
  loading: "Laster",
  logo: "Logo",
  or: "eller",
  remove: "Fjern",
  settings: "Innstillinger",
  share: "Del",
  submit: "Send",
  undo: "Angre",
  no_devices: "Ingen enheter funnet",
  language: "Språk",
  display_theme: "Visningstema",
  pwa: "Progressiv webapplikasjon"
};
const dataframe$f = {
  incorrect_format: "Feil format, kun CSV- og TSV-filer støttes",
  new_column: "Legg til kolonne",
  new_row: "Ny rad",
  add_row_above: "Legg til rad over",
  add_row_below: "Legg til rad under",
  add_column_left: "Legg til kolonne til venstre",
  add_column_right: "Legg til kolonne til høyre",
  delete_row: "Slett rad",
  delete_column: "Slett kolonne",
  sort_column: "Sorter kolonne",
  sort_ascending: "Sorter stigende",
  sort_descending: "Sorter synkende",
  drop_to_upload: "Slipp CSV- eller TSV-filer her for å importere data til dataramme",
  clear_sort: "Fjern sortering"
};
const dropdown$f = {
  dropdown: "Nedtrekksmeny"
};
const errors$f = {
  build_error: "Det er en byggefeil",
  config_error: "Det er en konfigurasjonsfeil",
  contact_page_author: "Vennligst kontakt sidens forfatter for å informere dem.",
  no_app_file: "Det er ingen app-fil",
  runtime_error: "Det er en kjøretidsfeil",
  space_not_working: '"Space fungerer ikke fordi" {0}',
  space_paused: "Space er pauset",
  use_via_api: "Bruk via API",
  use_via_api_or_mcp: "Bruk via API eller MCP"
};
const file$f = {
  uploading: "Laster opp..."
};
const highlighted_text$f = {
  highlighted_text: "Uthevet tekst"
};
const image$f = {
  allow_webcam_access: "Vennligst tillat webkameratilgang for opptak.",
  brush_color: "Penselfarge",
  brush_radius: "Penselstørrelse",
  image: "Bilde",
  remove_image: "Fjern bilde",
  select_brush_color: "Velg penselfarge",
  start_drawing: "Start tegning",
  use_brush: "Bruk pensel",
  drop_to_upload: "Slipp en bildefil her for å laste opp"
};
const label$f = {
  label: "Etikett"
};
const login$f = {
  enable_cookies: "Hvis du besøker en HuggingFace Space i inkognitomodus, må du aktivere tredjeparts informasjonskapsler.",
  incorrect_credentials: "Feil påloggingsinformasjon",
  username: "Brukernavn",
  password: "Passord",
  login: "Logg inn"
};
const number$f = {
  number: "Tall"
};
const plot$f = {
  plot: "Plott"
};
const radio$f = {
  radio: "Radioknapp"
};
const slider$f = {
  slider: "Glidebryter"
};
const upload_text$f = {
  click_to_upload: "Klikk for å laste opp",
  drop_audio: "Slipp lyd her",
  drop_csv: "Slipp CSV her",
  drop_file: "Slipp fil her",
  drop_image: "Slipp bilde her",
  drop_video: "Slipp video her",
  drop_gallery: "Slipp media her",
  paste_clipboard: "Lim inn fra utklippstavle"
};
const video$f = {
  drop_to_upload: "Slipp en videofil her for å laste opp"
};
const chatbot$f = {
  edit: "Rediger",
  retry: "Prøv igjen",
  undo: "Angre",
  submit: "Send",
  cancel: "Avbryt",
  like: "Liker",
  dislike: "Liker ikke",
  clear: "Tøm samtalen"
};
const nb = {
  _name: _name$f,
  "3D_model": {
    "3d_model": "3D-modell",
    drop_to_upload: "Slipp en 3D-modell (.obj, .glb, .stl, .gltf, .splat eller .ply) fil her for å laste opp"
  },
  annotated_image: annotated_image$f,
  audio: audio$f,
  blocks: blocks$f,
  checkbox: checkbox$f,
  code: code$f,
  color_picker: color_picker$f,
  common: common$f,
  dataframe: dataframe$f,
  dropdown: dropdown$f,
  errors: errors$f,
  file: file$f,
  highlighted_text: highlighted_text$f,
  image: image$f,
  label: label$f,
  login: login$f,
  number: number$f,
  plot: plot$f,
  radio: radio$f,
  slider: slider$f,
  upload_text: upload_text$f,
  video: video$f,
  chatbot: chatbot$f
};
const __vite_glob_0_15 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$f,
  annotated_image: annotated_image$f,
  audio: audio$f,
  blocks: blocks$f,
  chatbot: chatbot$f,
  checkbox: checkbox$f,
  code: code$f,
  color_picker: color_picker$f,
  common: common$f,
  dataframe: dataframe$f,
  default: nb,
  dropdown: dropdown$f,
  errors: errors$f,
  file: file$f,
  highlighted_text: highlighted_text$f,
  image: image$f,
  label: label$f,
  login: login$f,
  number: number$f,
  plot: plot$f,
  radio: radio$f,
  slider: slider$f,
  upload_text: upload_text$f,
  video: video$f
}, Symbol.toStringTag, { value: "Module" }));
const _name$e = "Nederlands";
const common$e = {
  built_with_gradio: "Gemaakt met Gradio",
  clear: "Wissen",
  or: "of",
  submit: "Verzenden",
  settings: "Instellingen",
  built_with: "Gebouwd met",
  download: "Downloaden",
  edit: "Bewerken",
  empty: "Leeg",
  error: "Fout",
  hosted_on: "Gehost op",
  loading: "Laden",
  logo: "Logo",
  remove: "Verwijderen",
  share: "Delen",
  undo: "Ongedaan maken",
  no_devices: "Geen apparaten gevonden",
  language: "Taal",
  display_theme: "Weergavethema",
  pwa: "Progressieve Web App"
};
const upload_text$e = {
  click_to_upload: "Klik om te uploaden",
  drop_audio: "Sleep een geluidsbestand hier",
  drop_csv: "Sleep een CSV-bestand hier",
  drop_file: "Sleep een bestand hier",
  drop_image: "Sleep een afbeelding hier",
  drop_video: "Sleep een video hier",
  drop_gallery: "Sleep media hier",
  paste_clipboard: "Plakken vanuit klembord"
};
const annotated_image$e = {
  annotated_image: "Geannoteerde afbeelding"
};
const audio$e = {
  allow_recording_access: "Geef alstublieft toegang tot de microfoon voor opname.",
  audio: "Audio",
  drop_to_upload: "Sleep een audiobestand hier om te uploaden",
  record_from_microphone: "Opnemen via microfoon",
  stop_recording: "Opname stoppen",
  no_device_support: "Media-apparaten konden niet worden benaderd. Controleer of u werkt vanaf een beveiligde oorsprong (https) of localhost (of u een geldig SSL-certificaat heeft doorgegeven aan ssl_verify), en of u browsertoestemming heeft gegeven voor toegang tot uw apparaat.",
  stop: "Stoppen",
  resume: "Hervatten",
  record: "Opnemen",
  no_microphone: "Geen microfoon gevonden",
  pause: "Pauzeren",
  play: "Afspelen",
  waiting: "Wachten"
};
const blocks$e = {
  connection_can_break: "Op mobiel kan de verbinding verbroken worden als dit tabblad niet actief is of het apparaat in slaapstand gaat, waardoor je plaats in de wachtrij verloren gaat.",
  long_requests_queue: "Er is een lange wachtrij van aanvragen. Dupliceer deze Space om de wachtrij over te slaan.",
  lost_connection: "Verbinding verloren door het verlaten van de pagina. Opnieuw aansluiten in de wachtrij...",
  waiting_for_inputs: "Wachten tot het uploaden van bestand(en) is voltooid, probeer het opnieuw."
};
const checkbox$e = {
  checkbox: "Selectievakje",
  checkbox_group: "Selectievakjesgroep"
};
const code$e = {
  code: "Code"
};
const color_picker$e = {
  color_picker: "Kleurkiezer"
};
const dataframe$e = {
  incorrect_format: "Onjuist formaat, alleen CSV- en TSV-bestanden worden ondersteund",
  new_column: "Kolom toevoegen",
  new_row: "Nieuwe rij",
  add_row_above: "Rij boven toevoegen",
  add_row_below: "Rij onder toevoegen",
  delete_row: "Rij verwijderen",
  delete_column: "Kolom verwijderen",
  add_column_left: "Kolom links toevoegen",
  add_column_right: "Kolom rechts toevoegen",
  sort_column: "Kolom sorteren",
  sort_ascending: "Oplopend sorteren",
  sort_descending: "Aflopend sorteren",
  drop_to_upload: "Sleep CSV- of TSV-bestanden hier om gegevens in het dataframe te importeren",
  clear_sort: "Sortering wissen"
};
const dropdown$e = {
  dropdown: "Vervolgkeuzelijst"
};
const errors$e = {
  build_error: "Er is een bouwfout",
  config_error: "Er is een configuratiefout",
  contact_page_author: "Neem contact op met de auteur van de pagina om dit te melden.",
  no_app_file: "Er is geen app-bestand",
  runtime_error: "Er is een runtime-fout",
  space_not_working: '"Space werkt niet omdat" {0}',
  space_paused: "De Space is gepauzeerd",
  use_via_api: "Gebruik via API",
  use_via_api_or_mcp: "Gebruik via API of MCP"
};
const file$e = {
  uploading: "Uploaden..."
};
const highlighted_text$e = {
  highlighted_text: "Gemarkeerde tekst"
};
const image$e = {
  allow_webcam_access: "Geef alstublieft toegang tot de webcam voor opname.",
  brush_color: "Penseelkleur",
  brush_radius: "Penseelgrootte",
  image: "Afbeelding",
  remove_image: "Afbeelding verwijderen",
  select_brush_color: "Penseelkleur kiezen",
  start_drawing: "Beginnen met tekenen",
  use_brush: "Penseel gebruiken",
  drop_to_upload: "Sleep een afbeelding hier om te uploaden"
};
const label$e = {
  label: "Label"
};
const login$e = {
  enable_cookies: "Als u een HuggingFace Space bezoekt in incognitomodus, moet u cookies van derden inschakelen.",
  incorrect_credentials: "Onjuiste inloggegevens",
  username: "Gebruikersnaam",
  password: "Wachtwoord",
  login: "Inloggen"
};
const number$e = {
  number: "Getal"
};
const plot$e = {
  plot: "Grafiek"
};
const radio$e = {
  radio: "Keuzerondje"
};
const slider$e = {
  slider: "Schuifbalk"
};
const video$e = {
  drop_to_upload: "Sleep een videobestand hier om te uploaden"
};
const chatbot$e = {
  edit: "Bewerken",
  retry: "Opnieuw proberen",
  undo: "Ongedaan maken",
  submit: "Verzenden",
  cancel: "Annuleren",
  like: "Vind ik leuk",
  dislike: "Vind ik niet leuk",
  clear: "Gesprek wissen"
};
const nl = {
  _name: _name$e,
  common: common$e,
  upload_text: upload_text$e,
  "3D_model": {
    "3d_model": "3D-model",
    drop_to_upload: "Sleep een 3D-model (.obj, .glb, .stl, .gltf, .splat of .ply) bestand hier om te uploaden"
  },
  annotated_image: annotated_image$e,
  audio: audio$e,
  blocks: blocks$e,
  checkbox: checkbox$e,
  code: code$e,
  color_picker: color_picker$e,
  dataframe: dataframe$e,
  dropdown: dropdown$e,
  errors: errors$e,
  file: file$e,
  highlighted_text: highlighted_text$e,
  image: image$e,
  label: label$e,
  login: login$e,
  number: number$e,
  plot: plot$e,
  radio: radio$e,
  slider: slider$e,
  video: video$e,
  chatbot: chatbot$e
};
const __vite_glob_0_16 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$e,
  annotated_image: annotated_image$e,
  audio: audio$e,
  blocks: blocks$e,
  chatbot: chatbot$e,
  checkbox: checkbox$e,
  code: code$e,
  color_picker: color_picker$e,
  common: common$e,
  dataframe: dataframe$e,
  default: nl,
  dropdown: dropdown$e,
  errors: errors$e,
  file: file$e,
  highlighted_text: highlighted_text$e,
  image: image$e,
  label: label$e,
  login: login$e,
  number: number$e,
  plot: plot$e,
  radio: radio$e,
  slider: slider$e,
  upload_text: upload_text$e,
  video: video$e
}, Symbol.toStringTag, { value: "Module" }));
const _name$d = "Polski";
const annotated_image$d = {
  annotated_image: "Obraz z adnotacjami"
};
const audio$d = {
  allow_recording_access: "Proszę zezwolić na dostęp do mikrofonu w celu nagrywania.",
  audio: "Audio",
  record_from_microphone: "Nagraj z mikrofonu",
  stop_recording: "Zatrzymaj nagrywanie",
  no_device_support: "Nie można uzyskać dostępu do urządzeń multimedialnych. Upewnij się, że działasz na bezpiecznym źródle (https) lub localhost (lub przekazałeś prawidłowy certyfikat SSL do ssl_verify), i że zezwoliłeś przeglądarce na dostęp do twojego urządzenia.",
  stop: "Stop",
  resume: "Wznów",
  record: "Nagrywaj",
  no_microphone: "Nie znaleziono mikrofonu",
  pause: "Pauza",
  play: "Odtwórz",
  waiting: "Oczekiwanie",
  drop_to_upload: "Upuść plik audio tutaj, aby go przesłać"
};
const blocks$d = {
  connection_can_break: "Na urządzeniu mobilnym połączenie może zostać przerwane, jeśli ta karta straci fokus lub urządzenie przejdzie w tryb uśpienia, tracąc twoje miejsce w kolejce.",
  long_requests_queue: "Istnieje długa kolejka oczekujących żądań. Zduplikuj ten Space, aby ją pominąć.",
  lost_connection: "Utracono połączenie z powodu opuszczenia strony. Powrót do kolejki...",
  waiting_for_inputs: "Oczekiwanie na zakończenie przesyłania pliku(ów), proszę spróbować ponownie."
};
const checkbox$d = {
  checkbox: "Pole wyboru",
  checkbox_group: "Grupa pól wyboru"
};
const code$d = {
  code: "Kod"
};
const color_picker$d = {
  color_picker: "Wybór koloru"
};
const common$d = {
  built_with: "Zbudowane z",
  built_with_gradio: "Zbudowane z Gradio",
  clear: "Wyczyść",
  download: "Pobierz",
  edit: "Edytuj",
  empty: "Pusty",
  error: "Błąd",
  hosted_on: "Hostowane na",
  loading: "Ładowanie",
  logo: "Logo",
  or: "lub",
  remove: "Usuń",
  settings: "Ustawienia",
  share: "Udostępnij",
  submit: "Wyślij",
  undo: "Cofnij",
  no_devices: "Nie znaleziono urządzeń",
  language: "Język",
  display_theme: "Motyw wyświetlania",
  pwa: "Progresywna aplikacja webowa"
};
const dataframe$d = {
  incorrect_format: "Nieprawidłowy format, obsługiwane są tylko pliki CSV i TSV",
  new_column: "Dodaj kolumnę",
  new_row: "Nowy wiersz",
  add_row_above: "Dodaj wiersz powyżej",
  add_row_below: "Dodaj wiersz poniżej",
  add_column_left: "Dodaj kolumnę po lewej",
  add_column_right: "Dodaj kolumnę po prawej",
  delete_row: "Usuń wiersz",
  delete_column: "Usuń kolumnę",
  sort_column: "Sortuj kolumnę",
  sort_ascending: "Sortuj rosnąco",
  sort_descending: "Sortuj malejąco",
  drop_to_upload: "Upuść pliki CSV lub TSV tutaj, aby zaimportować dane do ramki danych",
  clear_sort: "Wyczyść sortowanie"
};
const dropdown$d = {
  dropdown: "Lista rozwijana"
};
const errors$d = {
  build_error: "Wystąpił błąd kompilacji",
  config_error: "Wystąpił błąd konfiguracji",
  contact_page_author: "Proszę skontaktować się z autorem strony, aby go poinformować.",
  no_app_file: "Brak pliku aplikacji",
  runtime_error: "Wystąpił błąd wykonania",
  space_not_working: '"Space nie działa, ponieważ" {0}',
  space_paused: "Space jest wstrzymany",
  use_via_api: "Użyj przez API",
  use_via_api_or_mcp: "Użyj przez API lub MCP"
};
const file$d = {
  uploading: "Przesyłanie..."
};
const highlighted_text$d = {
  highlighted_text: "Wyróżniony tekst"
};
const image$d = {
  allow_webcam_access: "Proszę zezwolić na dostęp do kamery internetowej w celu nagrywania.",
  brush_color: "Kolor pędzla",
  brush_radius: "Rozmiar pędzla",
  image: "Obraz",
  remove_image: "Usuń obraz",
  select_brush_color: "Wybierz kolor pędzla",
  start_drawing: "Rozpocznij rysowanie",
  use_brush: "Użyj pędzla",
  drop_to_upload: "Upuść plik obrazu tutaj, aby go przesłać"
};
const label$d = {
  label: "Etykieta"
};
const login$d = {
  enable_cookies: "Jeśli odwiedzasz HuggingFace Space w trybie incognito, musisz włączyć pliki cookie stron trzecich.",
  incorrect_credentials: "Nieprawidłowe dane logowania",
  username: "Nazwa użytkownika",
  password: "Hasło",
  login: "Zaloguj się"
};
const number$d = {
  number: "Liczba"
};
const plot$d = {
  plot: "Wykres"
};
const radio$d = {
  radio: "Przycisk opcji"
};
const slider$d = {
  slider: "Suwak"
};
const upload_text$d = {
  click_to_upload: "Kliknij, aby przesłać",
  drop_audio: "Upuść plik audio tutaj",
  drop_csv: "Upuść plik CSV tutaj",
  drop_file: "Upuść plik tutaj",
  drop_image: "Upuść obraz tutaj",
  drop_video: "Upuść plik wideo tutaj",
  drop_gallery: "Upuść media tutaj",
  paste_clipboard: "Wklej ze schowka"
};
const video$d = {
  drop_to_upload: "Upuść plik wideo tutaj, aby go przesłać"
};
const chatbot$d = {
  edit: "Edytuj",
  retry: "Spróbuj ponownie",
  undo: "Cofnij",
  submit: "Wyślij",
  cancel: "Anuluj",
  like: "Lubię to",
  dislike: "Nie lubię tego",
  clear: "Wyczyść czat"
};
const pl = {
  _name: _name$d,
  "3D_model": {
    "3d_model": "Model 3D",
    drop_to_upload: "Upuść plik modelu 3D (.obj, .glb, .stl, .gltf, .splat lub .ply) tutaj, aby go przesłać"
  },
  annotated_image: annotated_image$d,
  audio: audio$d,
  blocks: blocks$d,
  checkbox: checkbox$d,
  code: code$d,
  color_picker: color_picker$d,
  common: common$d,
  dataframe: dataframe$d,
  dropdown: dropdown$d,
  errors: errors$d,
  file: file$d,
  highlighted_text: highlighted_text$d,
  image: image$d,
  label: label$d,
  login: login$d,
  number: number$d,
  plot: plot$d,
  radio: radio$d,
  slider: slider$d,
  upload_text: upload_text$d,
  video: video$d,
  chatbot: chatbot$d
};
const __vite_glob_0_17 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$d,
  annotated_image: annotated_image$d,
  audio: audio$d,
  blocks: blocks$d,
  chatbot: chatbot$d,
  checkbox: checkbox$d,
  code: code$d,
  color_picker: color_picker$d,
  common: common$d,
  dataframe: dataframe$d,
  default: pl,
  dropdown: dropdown$d,
  errors: errors$d,
  file: file$d,
  highlighted_text: highlighted_text$d,
  image: image$d,
  label: label$d,
  login: login$d,
  number: number$d,
  plot: plot$d,
  radio: radio$d,
  slider: slider$d,
  upload_text: upload_text$d,
  video: video$d
}, Symbol.toStringTag, { value: "Module" }));
const _name$c = "Português do Brasil";
const common$c = {
  built_with_gradio: "Construído com Gradio",
  clear: "Limpar",
  error: "Erro",
  flag: "Marcar",
  loading: "Carregando",
  or: "ou",
  submit: "Enviar",
  built_with: "Construído com",
  download: "Baixar",
  edit: "Editar",
  empty: "Vazio",
  hosted_on: "Hospedado em",
  logo: "Logotipo",
  settings: "Configurações",
  undo: "Desfazer",
  no_devices: "Nenhum dispositivo encontrado",
  language: "Idioma",
  display_theme: "Tema de exibição",
  pwa: "Aplicativo web progressivo",
  share: "Compartilhar",
  remove: "Remover"
};
const upload_text$c = {
  click_to_upload: "Clique para fazer upload",
  drop_audio: "Solte o áudio aqui",
  drop_csv: "Solte o CSV aqui",
  drop_file: "Solte o arquivo aqui",
  drop_image: "Solte a imagem aqui",
  drop_video: "Solte o vídeo aqui",
  drop_gallery: "Solte a mídia aqui",
  paste_clipboard: "Colar da área de transferência"
};
const annotated_image$c = {
  annotated_image: "Imagem anotada"
};
const audio$c = {
  allow_recording_access: "Por favor, permita o acesso ao microfone para gravação.",
  audio: "Áudio",
  drop_to_upload: "Solte um arquivo de áudio aqui para fazer upload",
  record_from_microphone: "Gravar do microfone",
  stop_recording: "Parar gravação",
  no_device_support: "Os dispositivos de mídia não puderam ser acessados. Verifique se você está executando em uma origem segura (https) ou localhost (ou se forneceu um certificado SSL válido para ssl_verify), e se permitiu o acesso do navegador ao seu dispositivo.",
  stop: "Parar",
  resume: "Retomar",
  record: "Gravar",
  no_microphone: "Nenhum microfone encontrado",
  pause: "Pausar",
  play: "Reproduzir",
  waiting: "Aguardando"
};
const blocks$c = {
  connection_can_break: "No celular, a conexão pode ser interrompida se esta aba ficar em segundo plano ou se o dispositivo entrar em modo de repouso, fazendo você perder sua posição na fila.",
  long_requests_queue: "Há uma longa fila de solicitações pendentes. Duplique este Space para pular a fila.",
  lost_connection: "Conexão perdida ao sair da página. Retornando para a fila...",
  waiting_for_inputs: "Aguardando o(s) arquivo(s) terminar(em) de ser carregado(s), por favor, tente novamente."
};
const checkbox$c = {
  checkbox: "Caixa de seleção",
  checkbox_group: "Grupo de caixas de seleção"
};
const code$c = {
  code: "Código"
};
const color_picker$c = {
  color_picker: "Seletor de cor"
};
const dataframe$c = {
  incorrect_format: "Formato incorreto, apenas arquivos CSV e TSV são suportados",
  new_column: "Adicionar coluna",
  new_row: "Nova linha",
  add_row_above: "Adicionar linha acima",
  add_row_below: "Adicionar linha abaixo",
  delete_row: "Excluir linha",
  delete_column: "Excluir coluna",
  add_column_left: "Adicionar coluna à esquerda",
  add_column_right: "Adicionar coluna à direita",
  sort_column: "Classificar coluna",
  sort_ascending: "Ordenar em ordem crescente",
  sort_descending: "Ordenar em ordem decrescente",
  drop_to_upload: "Solte arquivos CSV ou TSV aqui para importar dados para o dataframe",
  clear_sort: "Limpar classificação",
  filter: "Filtrar",
  clear_filter: "Limpar filtros"
};
const dropdown$c = {
  dropdown: "Menu suspenso"
};
const errors$c = {
  build_error: "Houve um erro de compilação",
  config_error: "Há um erro de configuração",
  contact_page_author: "Por favor, entre em contato com o autor da página para informá-lo.",
  no_app_file: "Não há arquivo de aplicativo",
  space_not_working: '"O Space não está funcionando porque" {0}',
  space_paused: "O Space está pausado",
  use_via_api: "Usar via API",
  use_via_api_or_mcp: "Usar via API ou MCP",
  runtime_error: "Houve um erro de execução"
};
const file$c = {
  uploading: "Carregando..."
};
const highlighted_text$c = {
  highlighted_text: "Texto destacado"
};
const image$c = {
  allow_webcam_access: "Por favor, permita o acesso à webcam para gravação.",
  brush_color: "Cor do pincel",
  brush_radius: "Tamanho do pincel",
  image: "Imagem",
  remove_image: "Remover imagem",
  select_brush_color: "Selecione a cor do pincel",
  start_drawing: "Começar a desenhar",
  use_brush: "Usar pincel",
  drop_to_upload: "Solte um arquivo de imagem aqui para fazer upload"
};
const label$c = {
  label: "Rótulo"
};
const login$c = {
  enable_cookies: "Se você estiver visitando um HuggingFace Space no modo incógnito, você deve habilitar cookies de terceiros.",
  incorrect_credentials: "Credenciais incorretas",
  username: "Nome de usuário",
  password: "Senha",
  login: "Entrar"
};
const number$c = {
  number: "Número"
};
const plot$c = {
  plot: "Gráfico"
};
const radio$c = {
  radio: "Botão de opção"
};
const slider$c = {
  slider: "Controle deslizante"
};
const video$c = {
  drop_to_upload: "Solte um arquivo de vídeo aqui para fazer upload"
};
const chatbot$c = {
  edit: "Editar",
  retry: "Tentar novamente",
  undo: "Desfazer",
  submit: "Enviar",
  cancel: "Cancelar",
  like: "Gostei",
  dislike: "Não gostei",
  clear: "Limpar conversa"
};
const ptBR = {
  _name: _name$c,
  common: common$c,
  upload_text: upload_text$c,
  "3D_model": {
    "3d_model": "Modelo 3D",
    drop_to_upload: "Solte um arquivo de modelo 3D (.obj, .glb, .stl, .gltf, .splat ou .ply) aqui para fazer upload"
  },
  annotated_image: annotated_image$c,
  audio: audio$c,
  blocks: blocks$c,
  checkbox: checkbox$c,
  code: code$c,
  color_picker: color_picker$c,
  dataframe: dataframe$c,
  dropdown: dropdown$c,
  errors: errors$c,
  file: file$c,
  highlighted_text: highlighted_text$c,
  image: image$c,
  label: label$c,
  login: login$c,
  number: number$c,
  plot: plot$c,
  radio: radio$c,
  slider: slider$c,
  video: video$c,
  chatbot: chatbot$c
};
const __vite_glob_0_18 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$c,
  annotated_image: annotated_image$c,
  audio: audio$c,
  blocks: blocks$c,
  chatbot: chatbot$c,
  checkbox: checkbox$c,
  code: code$c,
  color_picker: color_picker$c,
  common: common$c,
  dataframe: dataframe$c,
  default: ptBR,
  dropdown: dropdown$c,
  errors: errors$c,
  file: file$c,
  highlighted_text: highlighted_text$c,
  image: image$c,
  label: label$c,
  login: login$c,
  number: number$c,
  plot: plot$c,
  radio: radio$c,
  slider: slider$c,
  upload_text: upload_text$c,
  video: video$c
}, Symbol.toStringTag, { value: "Module" }));
const _name$b = "Português";
const annotated_image$b = {
  annotated_image: "Imagem anotada"
};
const audio$b = {
  allow_recording_access: "Por favor, permita o acesso ao microfone para gravação.",
  audio: "Áudio",
  record_from_microphone: "Gravar do microfone",
  stop_recording: "Parar gravação",
  no_device_support: "Não é possível aceder a dispositivos de média. Certifique-se de que está a executar numa fonte segura (https) ou localhost (ou passou um certificado SSL válido para ssl_verify), e que permitiu o acesso do navegador ao seu dispositivo.",
  stop: "Parar",
  resume: "Retomar",
  record: "Gravar",
  no_microphone: "Nenhum microfone encontrado",
  pause: "Pausar",
  play: "Reproduzir",
  waiting: "Aguardando",
  drop_to_upload: "Solte um arquivo de áudio aqui para fazer upload"
};
const blocks$b = {
  connection_can_break: "No telemóvel, a ligação pode ser interrompida se este separador perder o foco ou o dispositivo entrar em modo de suspensão, perdendo a sua posição na fila.",
  long_requests_queue: "Há uma longa fila de solicitações pendentes. Duplique este Space para saltar a fila.",
  lost_connection: "Ligação perdida devido à saída da página. A voltar à fila...",
  waiting_for_inputs: "A aguardar o término do carregamento do(s) ficheiro(s), por favor, tente novamente."
};
const checkbox$b = {
  checkbox: "Caixa de seleção",
  checkbox_group: "Grupo de caixas de seleção"
};
const code$b = {
  code: "Código"
};
const color_picker$b = {
  color_picker: "Seletor de cor"
};
const common$b = {
  built_with: "Construído com",
  built_with_gradio: "Construído com Gradio",
  clear: "Limpar",
  download: "Descarregar",
  edit: "Editar",
  empty: "Vazio",
  error: "Erro",
  hosted_on: "Alojado em",
  loading: "A carregar",
  logo: "Logótipo",
  or: "ou",
  remove: "Remover",
  settings: "Configurações",
  share: "Partilhar",
  submit: "Enviar",
  undo: "Desfazer",
  no_devices: "Nenhum dispositivo encontrado",
  language: "Idioma",
  display_theme: "Tema de exibição",
  pwa: "Aplicação web progressiva"
};
const dataframe$b = {
  incorrect_format: "Formato incorreto, apenas ficheiros CSV e TSV são suportados",
  new_column: "Adicionar coluna",
  new_row: "Nova linha",
  add_row_above: "Adicionar linha acima",
  add_row_below: "Adicionar linha abaixo",
  add_column_left: "Adicionar coluna à esquerda",
  add_column_right: "Adicionar coluna à direita",
  delete_row: "Eliminar linha",
  delete_column: "Eliminar coluna",
  sort_column: "Ordenar coluna",
  sort_ascending: "Ordenar por ordem crescente",
  sort_descending: "Ordenar por ordem decrescente",
  drop_to_upload: "Solte ficheiros CSV ou TSV aqui para importar dados para o dataframe",
  clear_sort: "Limpar ordenação",
  filter: "Filtrar",
  clear_filter: "Limpar filtros"
};
const dropdown$b = {
  dropdown: "Lista suspensa"
};
const errors$b = {
  build_error: "Há um erro de compilação",
  config_error: "Há um erro de configuração",
  contact_page_author: "Por favor, entre em contacto com o autor da página para informá-lo.",
  no_app_file: "Não há ficheiro de aplicação",
  runtime_error: "Há um erro de execução",
  space_not_working: '"O Space não está a funcionar porque" {0}',
  space_paused: "O Space está em pausa",
  use_via_api: "Usar via API",
  use_via_api_or_mcp: "Usar via API ou MCP"
};
const file$b = {
  uploading: "A carregar..."
};
const highlighted_text$b = {
  highlighted_text: "Texto destacado"
};
const image$b = {
  allow_webcam_access: "Por favor, permita o acesso à webcam para gravação.",
  brush_color: "Cor do pincel",
  brush_radius: "Tamanho do pincel",
  image: "Imagem",
  remove_image: "Remover imagem",
  select_brush_color: "Selecionar cor do pincel",
  start_drawing: "Começar a desenhar",
  use_brush: "Usar pincel",
  drop_to_upload: "Solte um ficheiro de imagem aqui para fazer upload"
};
const label$b = {
  label: "Rótulo"
};
const login$b = {
  enable_cookies: "Se estiver a visitar um Space HuggingFace no modo anónimo, precisa de ativar cookies de terceiros.",
  incorrect_credentials: "Credenciais incorretas",
  username: "Nome de utilizador",
  password: "Palavra-passe",
  login: "Iniciar sessão"
};
const number$b = {
  number: "Número"
};
const plot$b = {
  plot: "Gráfico"
};
const radio$b = {
  radio: "Botão de opção"
};
const slider$b = {
  slider: "Controlo deslizante"
};
const upload_text$b = {
  click_to_upload: "Clique para carregar",
  drop_audio: "Solte o áudio aqui",
  drop_csv: "Solte o CSV aqui",
  drop_file: "Solte o ficheiro aqui",
  drop_image: "Solte a imagem aqui",
  drop_video: "Solte o vídeo aqui",
  drop_gallery: "Solte a média aqui",
  paste_clipboard: "Colar da área de transferência"
};
const video$b = {
  drop_to_upload: "Solte um ficheiro de vídeo aqui para fazer upload"
};
const chatbot$b = {
  edit: "Editar",
  retry: "Tentar novamente",
  undo: "Desfazer",
  submit: "Enviar",
  cancel: "Cancelar",
  like: "Gosto",
  dislike: "Não gosto",
  clear: "Limpar conversa"
};
const pt = {
  _name: _name$b,
  "3D_model": {
    "3d_model": "Modelo 3D",
    drop_to_upload: "Solte um arquivo de modelo 3D (.obj, .glb, .stl, .gltf, .splat ou .ply) aqui para fazer upload"
  },
  annotated_image: annotated_image$b,
  audio: audio$b,
  blocks: blocks$b,
  checkbox: checkbox$b,
  code: code$b,
  color_picker: color_picker$b,
  common: common$b,
  dataframe: dataframe$b,
  dropdown: dropdown$b,
  errors: errors$b,
  file: file$b,
  highlighted_text: highlighted_text$b,
  image: image$b,
  label: label$b,
  login: login$b,
  number: number$b,
  plot: plot$b,
  radio: radio$b,
  slider: slider$b,
  upload_text: upload_text$b,
  video: video$b,
  chatbot: chatbot$b
};
const __vite_glob_0_19 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$b,
  annotated_image: annotated_image$b,
  audio: audio$b,
  blocks: blocks$b,
  chatbot: chatbot$b,
  checkbox: checkbox$b,
  code: code$b,
  color_picker: color_picker$b,
  common: common$b,
  dataframe: dataframe$b,
  default: pt,
  dropdown: dropdown$b,
  errors: errors$b,
  file: file$b,
  highlighted_text: highlighted_text$b,
  image: image$b,
  label: label$b,
  login: login$b,
  number: number$b,
  plot: plot$b,
  radio: radio$b,
  slider: slider$b,
  upload_text: upload_text$b,
  video: video$b
}, Symbol.toStringTag, { value: "Module" }));
const _name$a = "Română";
const annotated_image$a = {
  annotated_image: "Imagine adnotată"
};
const audio$a = {
  allow_recording_access: "Vă rugăm să permiteți accesul la microfon pentru înregistrare.",
  audio: "Audio",
  record_from_microphone: "Înregistrare de la microfon",
  stop_recording: "Oprire înregistrare",
  no_device_support: "Nu se poate accesa dispozitivele media. Asigurați-vă că rulați pe o sursă sigură (https) sau localhost (sau ați transmis un certificat SSL valid la ssl_verify), și că ați permis browserului accesul la dispozitivul dvs.",
  stop: "Stop",
  resume: "Reluare",
  record: "Înregistrare",
  no_microphone: "Nu s-a găsit niciun microfon",
  pause: "Pauză",
  play: "Redare",
  waiting: "Așteptare",
  drop_to_upload: "Plasați un fișier audio aici pentru a-l încărca"
};
const blocks$a = {
  connection_can_break: "Pe mobil, conexiunea poate fi întreruptă dacă această filă își pierde focusul sau dispozitivul intră în modul de repaus, pierzându-vă poziția în coadă.",
  long_requests_queue: "Există o coadă lungă de cereri în așteptare. Duplicați acest Space pentru a o evita.",
  lost_connection: "Conexiune pierdută din cauza părăsirii paginii. Revenire la coadă...",
  waiting_for_inputs: "Așteptarea finalizării încărcării fișierului (fișierelor), vă rugăm să reîncercați."
};
const checkbox$a = {
  checkbox: "Casetă de bifat",
  checkbox_group: "Grup de casete de bifat"
};
const code$a = {
  code: "Cod"
};
const color_picker$a = {
  color_picker: "Selector de culoare"
};
const common$a = {
  built_with: "Construit cu",
  built_with_gradio: "Construit cu Gradio",
  clear: "Șterge",
  download: "Descarcă",
  edit: "Editează",
  empty: "Gol",
  error: "Eroare",
  hosted_on: "Găzduit pe",
  loading: "Se încarcă",
  logo: "Logo",
  or: "sau",
  remove: "Elimină",
  settings: "Setări",
  share: "Distribuie",
  submit: "Trimite",
  undo: "Anulează",
  no_devices: "Nu s-au găsit dispozitive",
  language: "Limbă",
  display_theme: "Temă de afișare",
  pwa: "Aplicație web progresivă"
};
const dataframe$a = {
  incorrect_format: "Format incorect, sunt acceptate doar fișiere CSV și TSV",
  new_column: "Adaugă coloană",
  new_row: "Rând nou",
  add_row_above: "Adaugă rând deasupra",
  add_row_below: "Adaugă rând dedesubt",
  add_column_left: "Adaugă coloană la stânga",
  add_column_right: "Adaugă coloană la dreapta",
  delete_row: "Șterge rând",
  delete_column: "Șterge coloana",
  sort_column: "Sortează coloana",
  sort_ascending: "Sortează crescător",
  sort_descending: "Sortează descrescător",
  drop_to_upload: "Plasați fișiere CSV sau TSV aici pentru a importa datele în tabelul de date",
  clear_sort: "Șterge sortarea"
};
const dropdown$a = {
  dropdown: "Listă derulantă"
};
const errors$a = {
  build_error: "Există o eroare de compilare",
  config_error: "Există o eroare de configurare",
  contact_page_author: "Vă rugăm să contactați autorul paginii pentru a-l informa.",
  no_app_file: "Nu există fișier de aplicație",
  runtime_error: "Există o eroare de execuție",
  space_not_working: '"Space-ul nu funcționează deoarece" {0}',
  space_paused: "Space-ul este în pauză",
  use_via_api: "Utilizați prin API",
  use_via_api_or_mcp: "Utilizați prin API sau MCP"
};
const file$a = {
  uploading: "Se încarcă..."
};
const highlighted_text$a = {
  highlighted_text: "Text evidențiat"
};
const image$a = {
  allow_webcam_access: "Vă rugăm să permiteți accesul la camera web pentru înregistrare.",
  brush_color: "Culoare pensulă",
  brush_radius: "Dimensiune pensulă",
  image: "Imagine",
  remove_image: "Elimină imaginea",
  select_brush_color: "Selectează culoarea pensulei",
  start_drawing: "Începe să desenezi",
  use_brush: "Folosește pensula",
  drop_to_upload: "Plasați un fișier imagine aici pentru a-l încărca"
};
const label$a = {
  label: "Etichetă"
};
const login$a = {
  enable_cookies: "Dacă vizitați un Space HuggingFace în modul incognito, trebuie să activați cookie-urile terțe.",
  incorrect_credentials: "Credențiale incorecte",
  username: "Nume de utilizator",
  password: "Parolă",
  login: "Autentificare"
};
const number$a = {
  number: "Număr"
};
const plot$a = {
  plot: "Grafic"
};
const radio$a = {
  radio: "Buton radio"
};
const slider$a = {
  slider: "Glisor"
};
const upload_text$a = {
  click_to_upload: "Click pentru încărcare",
  drop_audio: "Plasați audio aici",
  drop_csv: "Plasați CSV aici",
  drop_file: "Plasați fișierul aici",
  drop_image: "Plasați imaginea aici",
  drop_video: "Plasați video aici",
  drop_gallery: "Plasați media aici",
  paste_clipboard: "Lipește din clipboard"
};
const video$a = {
  drop_to_upload: "Plasați un fișier video aici pentru a-l încărca"
};
const chatbot$a = {
  edit: "Editează",
  retry: "Încearcă din nou",
  undo: "Anulează",
  submit: "Trimite",
  cancel: "Anulează",
  like: "Îmi place",
  dislike: "Nu-mi place",
  clear: "Șterge conversația"
};
const ro = {
  _name: _name$a,
  "3D_model": {
    "3d_model": "Model 3D",
    drop_to_upload: "Plasați un fișier cu model 3D (.obj, .glb, .stl, .gltf, .splat sau .ply) aici pentru a-l încărca"
  },
  annotated_image: annotated_image$a,
  audio: audio$a,
  blocks: blocks$a,
  checkbox: checkbox$a,
  code: code$a,
  color_picker: color_picker$a,
  common: common$a,
  dataframe: dataframe$a,
  dropdown: dropdown$a,
  errors: errors$a,
  file: file$a,
  highlighted_text: highlighted_text$a,
  image: image$a,
  label: label$a,
  login: login$a,
  number: number$a,
  plot: plot$a,
  radio: radio$a,
  slider: slider$a,
  upload_text: upload_text$a,
  video: video$a,
  chatbot: chatbot$a
};
const __vite_glob_0_20 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$a,
  annotated_image: annotated_image$a,
  audio: audio$a,
  blocks: blocks$a,
  chatbot: chatbot$a,
  checkbox: checkbox$a,
  code: code$a,
  color_picker: color_picker$a,
  common: common$a,
  dataframe: dataframe$a,
  default: ro,
  dropdown: dropdown$a,
  errors: errors$a,
  file: file$a,
  highlighted_text: highlighted_text$a,
  image: image$a,
  label: label$a,
  login: login$a,
  number: number$a,
  plot: plot$a,
  radio: radio$a,
  slider: slider$a,
  upload_text: upload_text$a,
  video: video$a
}, Symbol.toStringTag, { value: "Module" }));
const _name$9 = "Русский";
const annotated_image$9 = {
  annotated_image: "Изображение с аннотациями"
};
const audio$9 = {
  allow_recording_access: "Пожалуйста, разрешите доступ к микрофону для записи.",
  audio: "Аудио",
  record_from_microphone: "Запись с микрофона",
  stop_recording: "Остановить запись",
  no_device_support: "Невозможно получить доступ к медиа-устройствам. Убедитесь, что вы работаете с безопасного источника (https) или localhost (или передали действительный SSL-сертификат в ssl_verify), и что вы разрешили браузеру доступ к вашему устройству.",
  stop: "Стоп",
  resume: "Продолжить",
  record: "Запись",
  no_microphone: "Микрофон не найден",
  pause: "Пауза",
  play: "Воспроизвести",
  waiting: "Ожидание",
  drop_to_upload: "Перетащите аудиофайл сюда для загрузки"
};
const blocks$9 = {
  connection_can_break: "На мобильном устройстве соединение может прерваться, если эта вкладка потеряет фокус или устройство перейдет в спящий режим, что приведет к потере вашего места в очереди.",
  long_requests_queue: "Существует длинная очередь ожидающих запросов. Создайте дубликат этого Space, чтобы пропустить очередь.",
  lost_connection: "Соединение потеряно из-за ухода со страницы. Возвращение в очередь...",
  waiting_for_inputs: "Ожидание завершения загрузки файла(ов), пожалуйста, повторите попытку."
};
const checkbox$9 = {
  checkbox: "Флажок",
  checkbox_group: "Группа флажков"
};
const code$9 = {
  code: "Код"
};
const color_picker$9 = {
  color_picker: "Выбор цвета"
};
const common$9 = {
  built_with: "Создано с помощью",
  built_with_gradio: "Создано с помощью Gradio",
  clear: "Очистить",
  download: "Скачать",
  edit: "Редактировать",
  empty: "Пусто",
  error: "Ошибка",
  hosted_on: "Размещено на",
  loading: "Загрузка",
  logo: "Логотип",
  or: "или",
  remove: "Удалить",
  settings: "Настройки",
  share: "Поделиться",
  submit: "Отправить",
  undo: "Отменить",
  no_devices: "Устройства не найдены",
  language: "Язык",
  display_theme: "Тема оформления",
  pwa: "Прогрессивное веб-приложение"
};
const dataframe$9 = {
  incorrect_format: "Неверный формат, поддерживаются только файлы CSV и TSV",
  new_column: "Добавить столбец",
  new_row: "Новая строка",
  add_row_above: "Добавить строку выше",
  add_row_below: "Добавить строку ниже",
  add_column_left: "Добавить столбец слева",
  add_column_right: "Добавить столбец справа",
  delete_row: "Удалить строку",
  delete_column: "Удалить столбец",
  sort_column: "Сортировать столбец",
  sort_ascending: "Сортировать по возрастанию",
  sort_descending: "Сортировать по убыванию",
  drop_to_upload: "Перетащите файлы CSV или TSV сюда для импорта данных в таблицу данных",
  clear_sort: "Очистить сортировку"
};
const dropdown$9 = {
  dropdown: "Выпадающий список"
};
const errors$9 = {
  build_error: "Произошла ошибка сборки",
  config_error: "Произошла ошибка конфигурации",
  contact_page_author: "Пожалуйста, свяжитесь с автором страницы, чтобы сообщить об этом.",
  no_app_file: "Отсутствует файл приложения",
  runtime_error: "Произошла ошибка выполнения",
  space_not_working: '"Space не работает, потому что" {0}',
  space_paused: "Space приостановлен",
  use_via_api: "Использовать через API",
  use_via_api_or_mcp: "Использовать через API или MCP"
};
const file$9 = {
  uploading: "Загрузка..."
};
const highlighted_text$9 = {
  highlighted_text: "Выделенный текст"
};
const image$9 = {
  allow_webcam_access: "Пожалуйста, разрешите доступ к веб-камере для записи.",
  brush_color: "Цвет кисти",
  brush_radius: "Размер кисти",
  image: "Изображение",
  remove_image: "Удалить изображение",
  select_brush_color: "Выбрать цвет кисти",
  start_drawing: "Начать рисование",
  use_brush: "Использовать кисть",
  drop_to_upload: "Перетащите изображение сюда для загрузки"
};
const label$9 = {
  label: "Метка"
};
const login$9 = {
  enable_cookies: "Если вы посещаете Space HuggingFace в режиме инкогнито, вам необходимо включить сторонние куки.",
  incorrect_credentials: "Неверные учетные данные",
  username: "Имя пользователя",
  password: "Пароль",
  login: "Войти"
};
const number$9 = {
  number: "Число"
};
const plot$9 = {
  plot: "График"
};
const radio$9 = {
  radio: "Переключатель"
};
const slider$9 = {
  slider: "Ползунок"
};
const upload_text$9 = {
  click_to_upload: "Нажмите для загрузки",
  drop_audio: "Перетащите аудио сюда",
  drop_csv: "Перетащите CSV сюда",
  drop_file: "Перетащите файл сюда",
  drop_image: "Перетащите изображение сюда",
  drop_video: "Перетащите видео сюда",
  drop_gallery: "Перетащите медиа сюда",
  paste_clipboard: "Вставить из буфера обмена"
};
const video$9 = {
  drop_to_upload: "Перетащите видеофайл сюда для загрузки"
};
const chatbot$9 = {
  edit: "Редактировать",
  retry: "Повторить",
  undo: "Отменить",
  submit: "Отправить",
  cancel: "Отмена",
  like: "Нравится",
  dislike: "Не нравится",
  clear: "Очистить чат"
};
const ru = {
  _name: _name$9,
  "3D_model": {
    "3d_model": "3D-модель",
    drop_to_upload: "Перетащите сюда 3D-модель (.obj, .glb, .stl, .gltf, .splat или .ply) для загрузки"
  },
  annotated_image: annotated_image$9,
  audio: audio$9,
  blocks: blocks$9,
  checkbox: checkbox$9,
  code: code$9,
  color_picker: color_picker$9,
  common: common$9,
  dataframe: dataframe$9,
  dropdown: dropdown$9,
  errors: errors$9,
  file: file$9,
  highlighted_text: highlighted_text$9,
  image: image$9,
  label: label$9,
  login: login$9,
  number: number$9,
  plot: plot$9,
  radio: radio$9,
  slider: slider$9,
  upload_text: upload_text$9,
  video: video$9,
  chatbot: chatbot$9
};
const __vite_glob_0_21 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$9,
  annotated_image: annotated_image$9,
  audio: audio$9,
  blocks: blocks$9,
  chatbot: chatbot$9,
  checkbox: checkbox$9,
  code: code$9,
  color_picker: color_picker$9,
  common: common$9,
  dataframe: dataframe$9,
  default: ru,
  dropdown: dropdown$9,
  errors: errors$9,
  file: file$9,
  highlighted_text: highlighted_text$9,
  image: image$9,
  label: label$9,
  login: login$9,
  number: number$9,
  plot: plot$9,
  radio: radio$9,
  slider: slider$9,
  upload_text: upload_text$9,
  video: video$9
}, Symbol.toStringTag, { value: "Module" }));
const _name$8 = "Svenska";
const annotated_image$8 = {
  annotated_image: "Annoterad bild"
};
const audio$8 = {
  allow_recording_access: "Tillåt mikrofonåtkomst för inspelning.",
  audio: "Ljud",
  record_from_microphone: "Spela in från mikrofon",
  stop_recording: "Stoppa inspelning",
  no_device_support: "Kan inte få åtkomst till medieenheter. Se till att du använder en säker källa (https) eller localhost (eller har gett ett giltigt SSL-certifikat till ssl_verify) och att du har gett webbläsaren åtkomst till din enhet.",
  stop: "Stopp",
  resume: "Fortsätt",
  record: "Spela in",
  no_microphone: "Ingen mikrofon hittades",
  pause: "Paus",
  play: "Spela upp",
  waiting: "Väntar",
  drop_to_upload: "Släpp en ljudfil här för att ladda upp"
};
const blocks$8 = {
  connection_can_break: "På mobila enheter kan anslutningen brytas om fliken lämnas eller om enheten går i viloläge, och du förlorar din plats i kön.",
  long_requests_queue: "Det är en lång kö med väntande förfrågningar. Duplicera detta Space för att hoppa över kön.",
  lost_connection: "Anslutningen bröts eftersom sidan lämnades. Återgår till kön...",
  waiting_for_inputs: "Väntar på att fil(er) ska vara klara att ladda upp, vänligen försök igen."
};
const checkbox$8 = {
  checkbox: "Kryssruta",
  checkbox_group: "Kryssrutgrupp"
};
const code$8 = {
  code: "Kod"
};
const color_picker$8 = {
  color_picker: "Färgväljare"
};
const common$8 = {
  built_with: "Byggt med",
  built_with_gradio: "Byggt med Gradio",
  clear: "Rensa",
  download: "Ladda ner",
  edit: "Redigera",
  empty: "Tom",
  error: "Fel",
  hosted_on: "Värd på",
  loading: "Laddar",
  logo: "Logotyp",
  or: "eller",
  remove: "Ta bort",
  settings: "Inställningar",
  share: "Dela",
  submit: "Skicka",
  undo: "Ångra",
  no_devices: "Inga enheter hittades",
  language: "Språk",
  display_theme: "Visningstema",
  pwa: "Progressiv webbapplikation"
};
const dataframe$8 = {
  incorrect_format: "Fel format, endast CSV- och TSV-filer stöds",
  new_column: "Lägg till kolumn",
  new_row: "Ny rad",
  add_row_above: "Lägg till rad ovanför",
  add_row_below: "Lägg till rad nedanför",
  add_column_left: "Lägg till kolumn till vänster",
  add_column_right: "Lägg till kolumn till höger",
  delete_row: "Ta bort rad",
  delete_column: "Ta bort kolumn",
  sort_column: "Sortera kolumn",
  sort_ascending: "Sortera stigande",
  sort_descending: "Sortera fallande",
  drop_to_upload: "Släpp CSV- eller TSV-filer här för att importera data till dataramverk",
  clear_sort: "Rensa sortering"
};
const dropdown$8 = {
  dropdown: "Rullgardinsmeny"
};
const errors$8 = {
  build_error: "Det finns ett byggfel",
  config_error: "Det finns ett konfigurationsfel",
  contact_page_author: "Kontakta sidans författare för att informera dem.",
  no_app_file: "Det finns ingen app-fil",
  runtime_error: "Det finns ett körtidsfel",
  space_not_working: '"Space fungerar inte eftersom" {0}',
  space_paused: "Space är pausat",
  use_via_api: "Använd via API",
  use_via_api_or_mcp: "Använd via API eller MCP"
};
const file$8 = {
  uploading: "Laddar upp..."
};
const highlighted_text$8 = {
  highlighted_text: "Markerad text"
};
const image$8 = {
  allow_webcam_access: "Tillåt webbkameråtkomst för inspelning.",
  brush_color: "Penselfärg",
  brush_radius: "Penselstorlek",
  image: "Bild",
  remove_image: "Ta bort bild",
  select_brush_color: "Välj penselfärg",
  start_drawing: "Börja rita",
  use_brush: "Använd pensel",
  drop_to_upload: "Släpp en bildfil här för att ladda upp"
};
const label$8 = {
  label: "Etikett"
};
const login$8 = {
  enable_cookies: "Om du besöker ett HuggingFace Space i inkognitoläge måste du aktivera tredjepartscookies.",
  incorrect_credentials: "Felaktiga inloggningsuppgifter",
  username: "Användarnamn",
  password: "Lösenord",
  login: "Logga in"
};
const number$8 = {
  number: "Nummer"
};
const plot$8 = {
  plot: "Diagram"
};
const radio$8 = {
  radio: "Radioknapp"
};
const slider$8 = {
  slider: "Skjutreglage"
};
const upload_text$8 = {
  click_to_upload: "Klicka för att ladda upp",
  drop_audio: "Släpp ljud här",
  drop_csv: "Släpp CSV här",
  drop_file: "Släpp fil här",
  drop_image: "Släpp bild här",
  drop_video: "Släpp video här",
  drop_gallery: "Släpp media här",
  paste_clipboard: "Klistra in från urklipp"
};
const video$8 = {
  drop_to_upload: "Släpp en videofil här för att ladda upp"
};
const chatbot$8 = {
  edit: "Redigera",
  retry: "Försök igen",
  undo: "Ångra",
  submit: "Skicka",
  cancel: "Avbryt",
  like: "Gilla",
  dislike: "Ogilla",
  clear: "Rensa chatten"
};
const sv = {
  _name: _name$8,
  "3D_model": {
    "3d_model": "3D-modell",
    drop_to_upload: "Släpp en 3D-modellfil (.obj, .glb, .stl, .gltf, .splat eller .ply) här för att ladda upp"
  },
  annotated_image: annotated_image$8,
  audio: audio$8,
  blocks: blocks$8,
  checkbox: checkbox$8,
  code: code$8,
  color_picker: color_picker$8,
  common: common$8,
  dataframe: dataframe$8,
  dropdown: dropdown$8,
  errors: errors$8,
  file: file$8,
  highlighted_text: highlighted_text$8,
  image: image$8,
  label: label$8,
  login: login$8,
  number: number$8,
  plot: plot$8,
  radio: radio$8,
  slider: slider$8,
  upload_text: upload_text$8,
  video: video$8,
  chatbot: chatbot$8
};
const __vite_glob_0_22 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$8,
  annotated_image: annotated_image$8,
  audio: audio$8,
  blocks: blocks$8,
  chatbot: chatbot$8,
  checkbox: checkbox$8,
  code: code$8,
  color_picker: color_picker$8,
  common: common$8,
  dataframe: dataframe$8,
  default: sv,
  dropdown: dropdown$8,
  errors: errors$8,
  file: file$8,
  highlighted_text: highlighted_text$8,
  image: image$8,
  label: label$8,
  login: login$8,
  number: number$8,
  plot: plot$8,
  radio: radio$8,
  slider: slider$8,
  upload_text: upload_text$8,
  video: video$8
}, Symbol.toStringTag, { value: "Module" }));
const _name$7 = "தமிழ்";
const common$7 = {
  built_with_gradio: "கிரேடியோவுடன் உருவாக்கப்பட்டது",
  clear: "அழிக்கவும்",
  or: "அல்லது",
  submit: "சமர்ப்பிக்கவும்",
  built_with: "உருவாக்கப்பட்டது",
  download: "பதிவிறக்கம்",
  edit: "திருத்து",
  empty: "காலியாக உள்ளது",
  error: "பிழை",
  hosted_on: "இதில் ஹோஸ்ட் செய்யப்பட்டது",
  loading: "ஏற்றுகிறது",
  logo: "லோகோ",
  remove: "நீக்கு",
  settings: "அமைப்புகள்",
  share: "பகிர்",
  undo: "செயல்தவிர்",
  no_devices: "சாதனங்கள் எதுவும் கிடைக்கவில்லை",
  language: "மொழி",
  display_theme: "காட்சி தீம்",
  pwa: "முன்னேற்ற வலை பயன்பாடு"
};
const upload_text$7 = {
  click_to_upload: "பதிவேற்ற கிளிக் செய்யவும்",
  drop_audio: "ஆடியோவை இங்கே விடவும்",
  drop_csv: "CSV ஐ இங்கே விடவும்",
  drop_file: "கோப்பை இங்கே விடவும்",
  drop_image: "படத்தை இங்கே விடவும்",
  drop_video: "வீடியோவை இங்கே விடவும்",
  drop_gallery: "மீடியாவை இங்கே விடவும்",
  paste_clipboard: "கிளிப்போர்டிலிருந்து ஒட்டவும்"
};
const annotated_image$7 = {
  annotated_image: "குறிப்பிடப்பட்ட படம்"
};
const audio$7 = {
  allow_recording_access: "தயவுசெய்து பதிவு செய்ய மைக்ரோஃபோன் அணுகலை அனுமதிக்கவும்.",
  audio: "ஒலி",
  drop_to_upload: "ஒலிக் கோப்பை பதிவேற்ற இங்கே விடவும்",
  record_from_microphone: "மைக்ரோஃபோனிலிருந்து பதிவு செய்யவும்",
  stop_recording: "பதிவை நிறுத்தவும்",
  no_device_support: "மீடியா சாதனங்களை அணுக முடியவில்லை. நீங்கள் பாதுகாப்பான மூலத்தில் (https) அல்லது localhost இல் இயங்குகிறீர்களா (அல்லது ssl_verify க்கு செல்லுபடியாகும் SSL சான்றிதழை அனுப்பியுள்ளீர்களா) என்பதையும், உங்கள் சாதனத்திற்கான உலாவி அணுகலை அனுமதித்துள்ளீர்களா என்பதையும் சரிபார்க்கவும்.",
  stop: "நிறுத்து",
  resume: "தொடரவும்",
  record: "பதிவு செய்",
  no_microphone: "மைக்ரோஃபோன் எதுவும் கிடைக்கவில்லை",
  pause: "இடைநிறுத்து",
  play: "இயக்கு",
  waiting: "காத்திருக்கிறது"
};
const blocks$7 = {
  connection_can_break: "மொபைலில், இந்தத் தாவல் ஃபோகஸை இழந்தால் அல்லது சாதனம் உறங்கினால், இணைப்பு துண்டிக்கப்பட்டு, வரிசையில் உங்கள் இடத்தை இழக்கலாம்.",
  long_requests_queue: "காத்திருக்கும் கோரிக்கைகளின் நீண்ட வரிசை உள்ளது. வரிசையைத் தவிர்க்க இந்த Space ஐ நகலெடுக்கவும்.",
  lost_connection: "பக்கத்தை விட்டு வெளியேறியதால் இணைப்பு துண்டிக்கப்பட்டது. வரிசைக்கு மீண்டும் இணைகிறது...",
  waiting_for_inputs: "கோப்பு(கள்) பதிவேற்றம் முடிவடைய காத்திருக்கிறது, தயவுசெய்து மீண்டும் முயற்சிக்கவும்."
};
const checkbox$7 = {
  checkbox: "தேர்வுப்பெட்டி",
  checkbox_group: "தேர்வுப்பெட்டி குழு"
};
const code$7 = {
  code: "குறியீடு"
};
const color_picker$7 = {
  color_picker: "வண்ணத் தேர்வி"
};
const dataframe$7 = {
  incorrect_format: "தவறான வடிவம், CSV மற்றும் TSV கோப்புகள் மட்டுமே ஆதரிக்கப்படுகின்றன",
  new_column: "நெடுவரிசை சேர்க்க",
  new_row: "புதிய வரிசை",
  add_row_above: "மேலே வரிசை சேர்க்க",
  add_row_below: "கீழே வரிசை சேர்க்க",
  delete_row: "வரிசையை நீக்கு",
  delete_column: "நெடுவரிசையை நீக்கு",
  add_column_left: "இடது பக்கத்தில் நெடுவரிசை சேர்க்க",
  add_column_right: "வலது பக்கத்தில் நெடுவரிசை சேர்க்க",
  sort_column: "நெடுவரிசையை வரிசைப்படுத்து",
  sort_ascending: "ஏறுவரிசையில் வரிசைப்படுத்து",
  sort_descending: "இறங்குவரிசையில் வரிசைப்படுத்து",
  drop_to_upload: "தரவுத்தளத்திற்கு தரவை இறக்குமதி செய்ய CSV அல்லது TSV கோப்புகளை இங்கே விடவும்",
  clear_sort: "வரிசைப்படுத்தலை அழி"
};
const dropdown$7 = {
  dropdown: "கீழ்தோன்றல் பட்டியல்"
};
const errors$7 = {
  build_error: "உருவாக்க பிழை உள்ளது",
  config_error: "கட்டமைப்பு பிழை உள்ளது",
  contact_page_author: "தயவுசெய்து பக்க ஆசிரியரைத் தொடர்பு கொண்டு தெரிவிக்கவும்.",
  no_app_file: "பயன்பாட்டுக் கோப்பு இல்லை",
  runtime_error: "இயக்க நேர பிழை உள்ளது",
  space_not_working: '"Space செயல்படவில்லை ஏனெனில்" {0}',
  space_paused: "Space இடைநிறுத்தப்பட்டுள்ளது",
  use_via_api: "API மூலம் பயன்படுத்தவும்",
  use_via_api_or_mcp: "API அல்லது MCP மூலம் பயன்படுத்தவும்"
};
const file$7 = {
  uploading: "பதிவேற்றுகிறது..."
};
const highlighted_text$7 = {
  highlighted_text: "சிறப்பிக்கப்பட்ட உரை"
};
const image$7 = {
  allow_webcam_access: "தயவுசெய்து பதிவு செய்ய வெப்கேம் அணுகலை அனுமதிக்கவும்.",
  brush_color: "தூரிகை நிறம்",
  brush_radius: "தூரிகை அளவு",
  image: "படம்",
  remove_image: "படத்தை நீக்கு",
  select_brush_color: "தூரிகை நிறத்தைத் தேர்ந்தெடுக்கவும்",
  start_drawing: "வரைய தொடங்கவும்",
  use_brush: "தூரிகையைப் பயன்படுத்தவும்",
  drop_to_upload: "பட கோப்பை பதிவேற்ற இங்கே விடவும்"
};
const label$7 = {
  label: "லேபிள்"
};
const login$7 = {
  enable_cookies: "நீங்கள் மறைநிலை பயன்முறையில் HuggingFace Space ஐப் பார்வையிட்டால், மூன்றாம் தரப்பு குக்கீகளை இயக்க வேண்டும்.",
  incorrect_credentials: "தவறான சான்றுகள்",
  username: "பயனர்பெயர்",
  password: "கடவுச்சொல்",
  login: "உள்நுழைய"
};
const number$7 = {
  number: "எண்"
};
const plot$7 = {
  plot: "வரைபடம்"
};
const radio$7 = {
  radio: "ரேடியோ பொத்தான்"
};
const slider$7 = {
  slider: "சறுக்கி"
};
const video$7 = {
  drop_to_upload: "வீடியோ கோப்பை பதிவேற்ற இங்கே விடவும்"
};
const chatbot$7 = {
  edit: "திருத்து",
  retry: "மீண்டும் முயற்சி",
  undo: "செயல்தவிர்",
  submit: "சமர்ப்பிக்கவும்",
  cancel: "ரத்து",
  like: "விரும்புகிறேன்",
  dislike: "விரும்பவில்லை",
  clear: "உரையாடலை அழி"
};
const ta = {
  _name: _name$7,
  common: common$7,
  upload_text: upload_text$7,
  "3D_model": {
    "3d_model": "3D மாதிரி",
    drop_to_upload: "3D மாதிரி கோப்பை (.obj, .glb, .stl, .gltf, .splat, அல்லது .ply) பதிவேற்ற இங்கே விடவும்"
  },
  annotated_image: annotated_image$7,
  audio: audio$7,
  blocks: blocks$7,
  checkbox: checkbox$7,
  code: code$7,
  color_picker: color_picker$7,
  dataframe: dataframe$7,
  dropdown: dropdown$7,
  errors: errors$7,
  file: file$7,
  highlighted_text: highlighted_text$7,
  image: image$7,
  label: label$7,
  login: login$7,
  number: number$7,
  plot: plot$7,
  radio: radio$7,
  slider: slider$7,
  video: video$7,
  chatbot: chatbot$7
};
const __vite_glob_0_23 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$7,
  annotated_image: annotated_image$7,
  audio: audio$7,
  blocks: blocks$7,
  chatbot: chatbot$7,
  checkbox: checkbox$7,
  code: code$7,
  color_picker: color_picker$7,
  common: common$7,
  dataframe: dataframe$7,
  default: ta,
  dropdown: dropdown$7,
  errors: errors$7,
  file: file$7,
  highlighted_text: highlighted_text$7,
  image: image$7,
  label: label$7,
  login: login$7,
  number: number$7,
  plot: plot$7,
  radio: radio$7,
  slider: slider$7,
  upload_text: upload_text$7,
  video: video$7
}, Symbol.toStringTag, { value: "Module" }));
const _name$6 = "ภาษาไทย";
const annotated_image$6 = {
  annotated_image: "รูปภาพที่มีคำอธิบาย"
};
const audio$6 = {
  allow_recording_access: "กรุณาอนุญาตการเข้าถึงไมโครโฟนเพื่อบันทึกเสียง",
  audio: "เสียง",
  drop_to_upload: "ลากและวางไฟล์เสียงที่นี่เพื่ออัปโหลด",
  record_from_microphone: "บันทึกจากไมโครโฟน",
  stop_recording: "หยุดบันทึก",
  no_device_support: "ไม่สามารถเข้าถึงอุปกรณ์สื่อได้ โปรดตรวจสอบว่าคุณใช้งานบนโดเมนที่ปลอดภัย (https) หรือ localhost (หรือคุณได้กำหนดค่า SSL ที่ถูกต้อง) และอนุญาตให้เบราว์เซอร์เข้าถึงอุปกรณ์ของคุณ",
  stop: "หยุด",
  resume: "ทำงานต่อ",
  record: "บันทึก",
  no_microphone: "ไม่พบไมโครโฟน",
  pause: "หยุดชั่วคราว",
  play: "เล่น",
  waiting: "กำลังรอ"
};
const blocks$6 = {
  connection_can_break: "บนมือถือ การเชื่อมต่ออาจหลุดหากแท็บนี้ไม่ได้อยู่ในโฟกัสหรืออุปกรณ์เข้าสู่โหมดพัก ส่งผลให้เสียตำแหน่งในคิว",
  long_requests_queue: "มีคิวคำขอรออยู่เป็นจำนวนมาก คัดลอก Space นี้เพื่อข้ามคิว",
  lost_connection: "การเชื่อมต่อขาดหายเนื่องจากออกจากหน้า กำลังเข้าคิวใหม่...",
  waiting_for_inputs: "กำลังรอไฟล์อัปโหลดเสร็จ กรุณาลองใหม่"
};
const checkbox$6 = {
  checkbox: "กล่องเลือก",
  checkbox_group: "กลุ่มกล่องเลือก"
};
const code$6 = {
  code: "โค้ด"
};
const color_picker$6 = {
  color_picker: "ตัวเลือกสี"
};
const common$6 = {
  built_with: "สร้างด้วย",
  built_with_gradio: "สร้างด้วย Gradio",
  clear: "ล้าง",
  download: "ดาวน์โหลด",
  edit: "แก้ไข",
  empty: "ว่างเปล่า",
  error: "ข้อผิดพลาด",
  hosted_on: "โฮสต์บน",
  loading: "กำลังโหลด",
  logo: "โลโก้",
  or: "หรือ",
  remove: "ลบ",
  settings: "การตั้งค่า",
  share: "แชร์",
  submit: "ส่ง",
  undo: "เลิกทำ",
  no_devices: "ไม่พบอุปกรณ์",
  language: "ภาษา",
  display_theme: "ธีมการแสดงผล",
  pwa: "โปรเกรสซีฟเว็บแอป"
};
const dataframe$6 = {
  incorrect_format: "รูปแบบไม่ถูกต้อง รองรับเฉพาะไฟล์ CSV และ TSV",
  new_column: "เพิ่มคอลัมน์",
  new_row: "แถวใหม่",
  add_row_above: "เพิ่มแถวด้านบน",
  add_row_below: "เพิ่มแถวด้านล่าง",
  delete_row: "ลบแถว",
  delete_column: "ลบคอลัมน์",
  add_column_left: "เพิ่มคอลัมน์ทางซ้าย",
  add_column_right: "เพิ่มคอลัมน์ทางขวา",
  sort_column: "เรียงลำดับคอลัมน์",
  sort_ascending: "เรียงจากน้อยไปมาก",
  sort_descending: "เรียงจากมากไปน้อย",
  drop_to_upload: "ลากและวางไฟล์ CSV หรือ TSV ที่นี่เพื่อนำเข้าข้อมูลลงในตาราง",
  clear_sort: "ล้างการเรียงลำดับ"
};
const dropdown$6 = {
  dropdown: "เมนูดรอปดาวน์"
};
const errors$6 = {
  build_error: "เกิดข้อผิดพลาดในการสร้าง",
  config_error: "เกิดข้อผิดพลาดในการกำหนดค่า",
  contact_page_author: "โปรดติดต่อผู้ดูแลเพจเพื่อแจ้งให้ทราบ",
  no_app_file: "ไม่พบไฟล์แอป",
  runtime_error: "เกิดข้อผิดพลาดขณะทำงาน",
  space_not_working: '"Space ใช้งานไม่ได้เนื่องจาก" {0}',
  space_paused: "Space ถูกหยุดชั่วคราว",
  use_via_api: "ใช้งานผ่าน API",
  use_via_api_or_mcp: "ใช้งานผ่าน API หรือ MCP"
};
const file$6 = {
  uploading: "กำลังอัปโหลด..."
};
const highlighted_text$6 = {
  highlighted_text: "ข้อความที่ถูกเน้น"
};
const image$6 = {
  allow_webcam_access: "กรุณาอนุญาตการเข้าถึงเว็บแคมเพื่อบันทึกภาพ",
  brush_color: "สีแปรง",
  brush_radius: "ขนาดแปรง",
  image: "รูปภาพ",
  remove_image: "ลบรูปภาพ",
  select_brush_color: "เลือกสีแปรง",
  start_drawing: "เริ่มวาด",
  use_brush: "ใช้แปรง",
  drop_to_upload: "ลากและวางไฟล์รูปภาพที่นี่เพื่ออัปโหลด"
};
const label$6 = {
  label: "ป้ายกำกับ"
};
const login$6 = {
  enable_cookies: "หากคุณเข้าใช้งาน HuggingFace Space ในโหมดไม่ระบุตัวตน คุณต้องเปิดใช้งานคุกกี้ของบุคคลที่สาม",
  incorrect_credentials: "ชื่อผู้ใช้หรือรหัสผ่านไม่ถูกต้อง",
  username: "ชื่อผู้ใช้",
  password: "รหัสผ่าน",
  login: "เข้าสู่ระบบ"
};
const number$6 = {
  number: "ตัวเลข"
};
const plot$6 = {
  plot: "กราฟ"
};
const radio$6 = {
  radio: "ปุ่มตัวเลือก"
};
const slider$6 = {
  slider: "แถบเลื่อน"
};
const upload_text$6 = {
  click_to_upload: "คลิกเพื่ออัปโหลด",
  drop_audio: "ลากและวางไฟล์เสียงที่นี่",
  drop_csv: "ลากและวางไฟล์ CSV ที่นี่",
  drop_file: "ลากและวางไฟล์ที่นี่",
  drop_image: "ลากและวางไฟล์รูปภาพที่นี่",
  drop_video: "ลากและวางไฟล์วิดีโอที่นี่",
  drop_gallery: "ลากและวางไฟล์สื่อที่นี่",
  paste_clipboard: "วางจากคลิปบอร์ด"
};
const video$6 = {
  drop_to_upload: "ลากและวางไฟล์วิดีโอที่นี่เพื่ออัปโหลด"
};
const chatbot$6 = {
  edit: "แก้ไข",
  retry: "ลองใหม่",
  undo: "เลิกทำ",
  submit: "ส่ง",
  cancel: "ยกเลิก",
  like: "ถูกใจ",
  dislike: "ไม่ถูกใจ",
  clear: "ล้างการสนทนา"
};
const th = {
  _name: _name$6,
  "3D_model": {
    "3d_model": "โมเดล 3 มิติ",
    drop_to_upload: "ลากและวางไฟล์โมเดล 3 มิติ (.obj, .glb, .stl, .gltf, .splat, หรือ .ply) ที่นี่เพื่ออัปโหลด"
  },
  annotated_image: annotated_image$6,
  audio: audio$6,
  blocks: blocks$6,
  checkbox: checkbox$6,
  code: code$6,
  color_picker: color_picker$6,
  common: common$6,
  dataframe: dataframe$6,
  dropdown: dropdown$6,
  errors: errors$6,
  file: file$6,
  highlighted_text: highlighted_text$6,
  image: image$6,
  label: label$6,
  login: login$6,
  number: number$6,
  plot: plot$6,
  radio: radio$6,
  slider: slider$6,
  upload_text: upload_text$6,
  video: video$6,
  chatbot: chatbot$6
};
const __vite_glob_0_24 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$6,
  annotated_image: annotated_image$6,
  audio: audio$6,
  blocks: blocks$6,
  chatbot: chatbot$6,
  checkbox: checkbox$6,
  code: code$6,
  color_picker: color_picker$6,
  common: common$6,
  dataframe: dataframe$6,
  default: th,
  dropdown: dropdown$6,
  errors: errors$6,
  file: file$6,
  highlighted_text: highlighted_text$6,
  image: image$6,
  label: label$6,
  login: login$6,
  number: number$6,
  plot: plot$6,
  radio: radio$6,
  slider: slider$6,
  upload_text: upload_text$6,
  video: video$6
}, Symbol.toStringTag, { value: "Module" }));
const _name$5 = "Türkçe";
const common$5 = {
  built_with_gradio: "Gradio ile oluşturulmuştur",
  clear: "Temizle",
  or: "veya",
  submit: "Gönder",
  built_with: "İle oluşturuldu",
  download: "İndir",
  edit: "Düzenle",
  empty: "Boş",
  error: "Hata",
  hosted_on: "Şurada barındırılıyor:",
  loading: "Yükleniyor",
  logo: "Logo",
  remove: "Kaldır",
  settings: "Ayarlar",
  share: "Paylaş",
  undo: "Geri Al",
  no_devices: "Hiçbir cihaz bulunamadı",
  language: "Dil",
  display_theme: "Görünüm Teması",
  pwa: "Progressive Web Uygulaması"
};
const upload_text$5 = {
  click_to_upload: "Yüklemek için tıkla",
  drop_audio: "Ses dosyasını buraya sürükle",
  drop_csv: "CSV dosyasını buraya sürükle",
  drop_file: "Dosyayı buraya sürükle",
  drop_image: "Resmi buraya sürükle",
  drop_video: "Videoyu buraya sürükle",
  drop_gallery: "Medyayı buraya bırak",
  paste_clipboard: "Panodan yapıştır"
};
const annotated_image$5 = {
  annotated_image: "Açıklamalı Görüntü"
};
const audio$5 = {
  allow_recording_access: "Lütfen kayıt yapmak için mikrofona erişim izni verin.",
  audio: "Ses",
  drop_to_upload: "Yüklemek için bir ses dosyasını buraya bırakın",
  record_from_microphone: "Mikrofondan kaydet",
  stop_recording: "Kaydı durdur",
  no_device_support: "Medya cihazlarına erişilemedi. Güvenli bir kökende (https) veya yerel makinede (localhost) çalıştığınızdan emin olun (veya geçerli bir SSL sertifikası ile ssl_verify'yi geçtiniz) ve tarayıcınızın cihazınıza erişim izni verdiğini kontrol edin.",
  stop: "Durdur",
  resume: "Devam Et",
  record: "Kaydet",
  no_microphone: "Hiçbir mikrofon bulunamadı",
  pause: "Duraklat",
  play: "Oynat",
  waiting: "Bekliyor"
};
const blocks$5 = {
  connection_can_break: "Mobil cihazda, bu sekme odaklanmadığında veya cihaz uyku moduna geçtiğinde bağlantı kopabilir ve kuyrukta olduğunuz yer kaybedilebilir.",
  long_requests_queue: "Bekleyen isteklerin uzun bir kuyruğu var. Kuyruktan atlamak için bu Space'i kopyalayın.",
  lost_connection: "Sayfa terk edildiği için bağlantı kaybedildi. Kuyruğa yeniden katılıyor...",
  waiting_for_inputs: "Dosya(lar)ın yükleme işlemini tamamlaması bekleniyor, lütfen yeniden deneyin."
};
const checkbox$5 = {
  checkbox: "Onay Kutusu",
  checkbox_group: "Onay Kutusu Grubu"
};
const code$5 = {
  code: "Kod"
};
const color_picker$5 = {
  color_picker: "Renk Seçici"
};
const dataframe$5 = {
  incorrect_format: "Yanlış format, sadece CSV ve TSV dosyaları destekleniyor",
  new_column: "Sütun ekle",
  new_row: "Yeni satır",
  add_row_above: "Yukarıya satır ekle",
  add_row_below: "Aşağıya satır ekle",
  delete_row: "Satırı sil",
  delete_column: "Sütunu sil",
  add_column_left: "Sola sütun ekle",
  add_column_right: "Sağa sütun ekle",
  sort_column: "Sütunu sırala",
  sort_ascending: "Artan sırala",
  sort_descending: "Azalan sırala",
  drop_to_upload: "Veriyi veri çerçevesine aktarmak için CSV veya TSV dosyalarını buraya bırakın",
  clear_sort: "Sıralamayı temizle"
};
const dropdown$5 = {
  dropdown: "Açılır Liste"
};
const errors$5 = {
  build_error: "Bir derleme hatası var",
  config_error: "Bir yapılandırma hatası var",
  contact_page_author: "Lütfen sayfanın yazarıyla iletişime geçin ve bildirin.",
  no_app_file: "Uygulama dosyası yok",
  runtime_error: "Bir çalışma zamanı hatası var",
  space_not_working: '"Space çalışmıyor çünkü" {0}',
  space_paused: "Space duraklatıldı",
  use_via_api: "API üzerinden kullan",
  use_via_api_or_mcp: "API veya MCP üzerinden kullan"
};
const file$5 = {
  uploading: "Yükleniyor..."
};
const highlighted_text$5 = {
  highlighted_text: "Vurgulanan Metin"
};
const image$5 = {
  allow_webcam_access: "Lütfen kayıt için web kamerasına erişim izni verin.",
  brush_color: "Fırça rengi",
  brush_radius: "Fırça boyutu",
  image: "Görüntü",
  remove_image: "Resmi kaldır",
  select_brush_color: "Fırça rengini seç",
  start_drawing: "Çizim yapmaya başla",
  use_brush: "Fırça kullan",
  drop_to_upload: "Yüklemek için bir görüntü dosyasını buraya bırakın"
};
const label$5 = {
  label: "Etiket"
};
const login$5 = {
  enable_cookies: "Eğer HuggingFace Space'i Gizli Mod'da ziyaret ediyorsanız, üçüncü taraf çerezleri etkinleştirmelisiniz.",
  incorrect_credentials: "Yanlış kimlik bilgileri",
  username: "Kullanıcı adı",
  password: "Parola",
  login: "Giriş yap"
};
const number$5 = {
  number: "Sayı"
};
const plot$5 = {
  plot: "Grafik"
};
const radio$5 = {
  radio: "Radyo Düğmesi"
};
const slider$5 = {
  slider: "Kaydırıcı"
};
const video$5 = {
  drop_to_upload: "Yüklemek için bir video dosyasını buraya bırakın"
};
const chatbot$5 = {
  edit: "Düzenle",
  retry: "Tekrar Dene",
  undo: "Geri Al",
  submit: "Gönder",
  cancel: "İptal",
  like: "Beğen",
  dislike: "Beğenme",
  clear: "Sohbeti Temizle"
};
const tr = {
  _name: _name$5,
  common: common$5,
  upload_text: upload_text$5,
  "3D_model": {
    "3d_model": "3D Model",
    drop_to_upload: "Yüklemek için bir 3D model dosyasını (.obj, .glb, .stl, .gltf, .splat veya .ply) buraya bırakın"
  },
  annotated_image: annotated_image$5,
  audio: audio$5,
  blocks: blocks$5,
  checkbox: checkbox$5,
  code: code$5,
  color_picker: color_picker$5,
  dataframe: dataframe$5,
  dropdown: dropdown$5,
  errors: errors$5,
  file: file$5,
  highlighted_text: highlighted_text$5,
  image: image$5,
  label: label$5,
  login: login$5,
  number: number$5,
  plot: plot$5,
  radio: radio$5,
  slider: slider$5,
  video: video$5,
  chatbot: chatbot$5
};
const __vite_glob_0_25 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$5,
  annotated_image: annotated_image$5,
  audio: audio$5,
  blocks: blocks$5,
  chatbot: chatbot$5,
  checkbox: checkbox$5,
  code: code$5,
  color_picker: color_picker$5,
  common: common$5,
  dataframe: dataframe$5,
  default: tr,
  dropdown: dropdown$5,
  errors: errors$5,
  file: file$5,
  highlighted_text: highlighted_text$5,
  image: image$5,
  label: label$5,
  login: login$5,
  number: number$5,
  plot: plot$5,
  radio: radio$5,
  slider: slider$5,
  upload_text: upload_text$5,
  video: video$5
}, Symbol.toStringTag, { value: "Module" }));
const _name$4 = "Українська";
const common$4 = {
  built_with_gradio: "Зроблено на основі Gradio",
  clear: "Очистити",
  or: "або",
  submit: "Надіслати",
  settings: "Налаштування",
  built_with: "Зроблено з",
  download: "Завантажити",
  edit: "Редагувати",
  empty: "Порожній",
  error: "Помилка",
  hosted_on: "Розміщено на",
  loading: "Завантаження",
  logo: "Логотип",
  remove: "Видалити",
  share: "Поділитися",
  undo: "Скасувати",
  no_devices: "Пристроїв не знайдено",
  language: "Мова",
  display_theme: "Тема оформлення",
  pwa: "Прогресивний веб-додаток"
};
const upload_text$4 = {
  click_to_upload: "Натисніть, щоб завантажити",
  drop_audio: "Перетягніть аудіо сюди",
  drop_csv: "Перетягніть CSV-файл сюди",
  drop_file: "Перетягніть файл сюди",
  drop_image: "Перетягніть зображення сюди",
  drop_video: "Перетягніть відео сюди",
  drop_gallery: "Перетягніть медіа сюди",
  paste_clipboard: "Вставити з буфера обміну"
};
const annotated_image$4 = {
  annotated_image: "Анотоване зображення"
};
const audio$4 = {
  allow_recording_access: "Будь ласка, дайте доступ до мікрофона для запису.",
  audio: "Аудіо",
  drop_to_upload: "Перетягніть аудіофайл сюди, щоб завантажити",
  record_from_microphone: "Записати з мікрофона",
  stop_recording: "Зупинити запис",
  no_device_support: "Медійні пристрої не можуть бути доступні. Переконайтеся, що ви запускаєте з захищеного джерела (https) або localhost (або ви передали дійсний SSL-сертифікат до ssl_verify), і ви дозволили браузеру доступ до вашого пристрою.",
  stop: "Зупинити",
  resume: "Відновити",
  record: "Записати",
  no_microphone: "Мікрофон не виявлено",
  pause: "Пауза",
  play: "Відтворити",
  waiting: "Очікування"
};
const blocks$4 = {
  connection_can_break: "На мобільному пристрої з'єднання може перерватися, якщо ця вкладка втрачає фокус або пристрій увійде в режим сну, в результаті чого ви втратите своє місце в черзі.",
  long_requests_queue: "У черзі залишилось багато запитів. Скопіюйте цей Space, щоб пропустити чергу.",
  lost_connection: "З'єднання втрачено через вихід зі сторінки. Переміщення до кінця черги...",
  waiting_for_inputs: "Чекаємо завершення завантаження файлу(ів), будь ласка, спробуйте ще раз."
};
const checkbox$4 = {
  checkbox: "Прапорець",
  checkbox_group: "Група прапорців"
};
const code$4 = {
  code: "Код"
};
const color_picker$4 = {
  color_picker: "Вибір кольору"
};
const dataframe$4 = {
  incorrect_format: "Неправильний формат, підтримуються лише файли CSV та TSV",
  new_column: "Додати стовпець",
  new_row: "Новий рядок",
  add_row_above: "Додати рядок вище",
  add_row_below: "Додати рядок нижче",
  delete_row: "Видалити рядок",
  delete_column: "Видалити стовпець",
  add_column_left: "Додати стовпець зліва",
  add_column_right: "Додати стовпець справа",
  sort_column: "Сортувати стовпець",
  sort_ascending: "Сортувати за зростанням",
  sort_descending: "Сортувати за спаданням",
  drop_to_upload: "Перетягніть CSV або TSV файли сюди, щоб імпортувати дані в таблицю даних",
  clear_sort: "Очистити сортування"
};
const dropdown$4 = {
  dropdown: "Випадне меню"
};
const errors$4 = {
  build_error: "Є помилка побудови",
  config_error: "Є помилка конфігурації",
  contact_page_author: "Будь ласка, зв'яжіться з автором сторінки, щоб повідомити.",
  no_app_file: "Немає файлу додатку",
  runtime_error: "Є помилка виконання",
  space_not_working: '"Space не працює, оскільки" {0}',
  space_paused: "Space призупинено",
  use_via_api: "Використовувати через API",
  use_via_api_or_mcp: "Використовувати через API або MCP"
};
const file$4 = {
  uploading: "Завантаження..."
};
const highlighted_text$4 = {
  highlighted_text: "Виділений текст"
};
const image$4 = {
  allow_webcam_access: "Будь ласка, дайте доступ до веб-камери для запису.",
  brush_color: "Колір пензля",
  brush_radius: "Розмір пензля",
  image: "Зображення",
  remove_image: "Видалити зображення",
  select_brush_color: "Виберіть колір пензля",
  start_drawing: "Почніть малювати",
  use_brush: "Використовуйте пензель",
  drop_to_upload: "Перетягніть файл зображення сюди, щоб завантажити"
};
const label$4 = {
  label: "Мітка"
};
const login$4 = {
  enable_cookies: "Якщо ви відвідуєте HuggingFace Space у режимі Інкогніто, вам потрібно увімкнути сторонні куки.",
  incorrect_credentials: "Неправильні облікові дані",
  username: "Ім'я користувача",
  password: "Пароль",
  login: "Увійти"
};
const number$4 = {
  number: "Число"
};
const plot$4 = {
  plot: "Діаграма"
};
const radio$4 = {
  radio: "Перемикач"
};
const slider$4 = {
  slider: "Повзунок"
};
const video$4 = {
  drop_to_upload: "Перетягніть відеофайл сюди, щоб завантажити"
};
const chatbot$4 = {
  edit: "Редагувати",
  retry: "Повторити",
  undo: "Скасувати",
  submit: "Надіслати",
  cancel: "Скасувати",
  like: "Подобається",
  dislike: "Не подобається",
  clear: "Очистити чат"
};
const uk = {
  _name: _name$4,
  common: common$4,
  upload_text: upload_text$4,
  "3D_model": {
    "3d_model": "3D-модель",
    drop_to_upload: "Перетягніть файл 3D-моделі (.obj, .glb, .stl, .gltf, .splat або .ply) сюди, щоб завантажити"
  },
  annotated_image: annotated_image$4,
  audio: audio$4,
  blocks: blocks$4,
  checkbox: checkbox$4,
  code: code$4,
  color_picker: color_picker$4,
  dataframe: dataframe$4,
  dropdown: dropdown$4,
  errors: errors$4,
  file: file$4,
  highlighted_text: highlighted_text$4,
  image: image$4,
  label: label$4,
  login: login$4,
  number: number$4,
  plot: plot$4,
  radio: radio$4,
  slider: slider$4,
  video: video$4,
  chatbot: chatbot$4
};
const __vite_glob_0_26 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$4,
  annotated_image: annotated_image$4,
  audio: audio$4,
  blocks: blocks$4,
  chatbot: chatbot$4,
  checkbox: checkbox$4,
  code: code$4,
  color_picker: color_picker$4,
  common: common$4,
  dataframe: dataframe$4,
  default: uk,
  dropdown: dropdown$4,
  errors: errors$4,
  file: file$4,
  highlighted_text: highlighted_text$4,
  image: image$4,
  label: label$4,
  login: login$4,
  number: number$4,
  plot: plot$4,
  radio: radio$4,
  slider: slider$4,
  upload_text: upload_text$4,
  video: video$4
}, Symbol.toStringTag, { value: "Module" }));
const _name$3 = "اردو";
const common$3 = {
  built_with_gradio: "Gradio کے ساتھ بنایا گیا",
  clear: "صاف کریں",
  or: "یا",
  submit: "جمع کریں",
  settings: "ترتیبات",
  built_with: "کے ساتھ بنایا گیا",
  download: "ڈاؤن لوڈ کریں",
  edit: "ترمیم کریں",
  empty: "خالی",
  error: "خطا",
  hosted_on: "پر میزبانی کی جا رہی ہے",
  loading: "لوڈ ہو رہا ہے",
  logo: "لوگو",
  remove: "حذف کریں",
  share: "شیئر کریں",
  undo: "واپس لیں",
  no_devices: "کوئی ڈیوائس نہیں ملی",
  language: "زبان",
  display_theme: "تھیم کی نمائش",
  pwa: "پروگریسیو ویب ایپ"
};
const upload_text$3 = {
  click_to_upload: "اپ لوڈ کے لیے کلک کریں",
  drop_audio: "یہاں آڈیو ڈراپ کریں",
  drop_csv: "یہاں CSV ڈراپ کریں",
  drop_file: "یہاں فائل ڈراپ کریں",
  drop_image: "یہاں تصویر ڈراپ کریں",
  drop_video: "یہاں ویڈیو ڈراپ کریں",
  drop_gallery: "میڈیا یہاں ڈالیں",
  paste_clipboard: "کلپ بورڈ سے پیسٹ کریں"
};
const annotated_image$3 = {
  annotated_image: "تشریحی تصویر"
};
const audio$3 = {
  allow_recording_access: "براہ مہربانی ریکارڈنگ کے لیے مائیکروفون تک رسائی کی اجازت دیں۔",
  audio: "آڈیو",
  drop_to_upload: "اپلوڈ کرنے کے لیے آڈیو فائل یہاں ڈراپ کریں",
  record_from_microphone: "مائیکروفون سے ریکارڈ کریں",
  stop_recording: "ریکارڈنگ بند کریں",
  no_device_support: "میڈیا ڈیوائسز تک رسائی حاصل نہیں کی جا سکی۔ یقینی بنائیں کہ آپ محفوظ ذریعہ (https) یا localhost پر چلا رہے ہیں (یا آپ نے ssl_verify میں درست SSL سرٹیفکیٹ منتقل کیا ہے)، اور آپ نے براؤزر کو اپنے ڈیوائس تک رسائی کی اجازت دی ہے۔",
  stop: "روکیں",
  resume: "دوبارہ شروع کریں",
  record: "ریکارڈ کریں",
  no_microphone: "کوئی مائیکروفون نہیں ملا",
  pause: "روکیں",
  play: "چلائیں",
  waiting: "انتظار کر رہا ہے"
};
const blocks$3 = {
  connection_can_break: "موبائل پر، اگر اس ٹیب کا فوکس کھو جائے یا ڈیوائس سلیپ موڈ میں چلا جائے تو کنکشن ٹوٹ سکتا ہے، جس سے آپ قطار میں اپنی جگہ کھو سکتے ہیں۔",
  long_requests_queue: "درخواستوں کی ایک لمبی قطار زیر التواء ہے۔ قطار چھوڑنے کے لیے اس Space کو ڈپلیکیٹ کریں۔",
  lost_connection: "صفحہ چھوڑنے کی وجہ سے کنکشن کھو گیا۔ قطار میں دوبارہ شامل ہو رہا ہے...",
  waiting_for_inputs: "فائل(وں) کے اپ لوڈ ہونے کا انتظار ہے، براہ کرم دوبارہ کوشش کریں۔"
};
const checkbox$3 = {
  checkbox: "چیک باکس",
  checkbox_group: "چیک باکس گروپ"
};
const code$3 = {
  code: "کوڈ"
};
const color_picker$3 = {
  color_picker: "رنگ منتخب کرنے والا"
};
const dataframe$3 = {
  incorrect_format: "غلط فارمیٹ، صرف CSV اور TSV فائلوں کی حمایت کی جاتی ہے",
  new_column: "کالم شامل کریں",
  new_row: "نئی قطار",
  add_row_above: "اوپر قطار شامل کریں",
  add_row_below: "نیچے قطار شامل کریں",
  delete_row: "قطار حذف کریں",
  delete_column: "کالم حذف کریں",
  add_column_left: "بائیں طرف کالم شامل کریں",
  add_column_right: "دائیں طرف کالم شامل کریں",
  sort_column: "کالم کو ترتیب دیں",
  sort_ascending: "صعودی ترتیب دیں",
  sort_descending: "نزولی ترتیب دیں",
  drop_to_upload: "ڈیٹا کو ڈیٹا فریم میں درآمد کرنے کے لیے CSV یا TSV فائلیں یہاں ڈراپ کریں",
  clear_sort: "ترتیب صاف کریں"
};
const dropdown$3 = {
  dropdown: "ڈراپ ڈاؤن"
};
const errors$3 = {
  build_error: "تعمیر میں خطا ہے",
  config_error: "ترتیب میں خطا ہے",
  contact_page_author: "براہ کرم صفحہ کے مصنف سے رابطہ کریں تاکہ انہیں مطلع کیا جا سکے۔",
  no_app_file: "کوئی ایپ فائل نہیں ہے",
  runtime_error: "رن ٹائم میں خطا ہے",
  space_not_working: '"Space کام نہیں کر رہا ہے کیونکہ" {0}',
  space_paused: "Space موقوف ہے",
  use_via_api: "API کے ذریعے استعمال کریں",
  use_via_api_or_mcp: "API یا MCP کے ذریعے استعمال کریں"
};
const file$3 = {
  uploading: "اپلوڈ ہو رہا ہے..."
};
const highlighted_text$3 = {
  highlighted_text: "نمایاں کردہ متن"
};
const image$3 = {
  allow_webcam_access: "براہ مہربانی ریکارڈنگ کے لیے ویب کیم تک رسائی کی اجازت دیں۔",
  brush_color: "برش کا رنگ",
  brush_radius: "برش کا سائز",
  image: "تصویر",
  remove_image: "تصویر حذف کریں",
  select_brush_color: "برش کا رنگ منتخب کریں",
  start_drawing: "ڈرائنگ شروع کریں",
  use_brush: "برش استعمال کریں",
  drop_to_upload: "اپلوڈ کرنے کے لیے تصویر فائل یہاں ڈراپ کریں"
};
const label$3 = {
  label: "لیبل"
};
const login$3 = {
  enable_cookies: "اگر آپ انکوگنیٹو موڈ میں HuggingFace Space ملاحظہ کر رہے ہیں تو، آپ کو تیسرے فریق کے کوکیز کو فعال کرنا ہوگا۔",
  incorrect_credentials: "غلط اسناد",
  username: "صارف نام",
  password: "پاس ورڈ",
  login: "لاگ ان کریں"
};
const number$3 = {
  number: "نمبر"
};
const plot$3 = {
  plot: "گراف"
};
const radio$3 = {
  radio: "ریڈیو بٹن"
};
const slider$3 = {
  slider: "سلائیڈر"
};
const video$3 = {
  drop_to_upload: "اپلوڈ کرنے کے لیے ویڈیو فائل یہاں ڈراپ کریں"
};
const chatbot$3 = {
  edit: "ترمیم",
  retry: "دوبارہ کوشش",
  undo: "واپس",
  submit: "جمع کریں",
  cancel: "منسوخ",
  like: "پسند",
  dislike: "ناپسند",
  clear: "گفتگو صاف کریں"
};
const ur = {
  _name: _name$3,
  common: common$3,
  upload_text: upload_text$3,
  "3D_model": {
    "3d_model": "3D ماڈل",
    drop_to_upload: "اپلوڈ کرنے کے لیے 3D ماڈل (.obj, .glb, .stl, .gltf, .splat، یا .ply) فائل یہاں ڈراپ کریں"
  },
  annotated_image: annotated_image$3,
  audio: audio$3,
  blocks: blocks$3,
  checkbox: checkbox$3,
  code: code$3,
  color_picker: color_picker$3,
  dataframe: dataframe$3,
  dropdown: dropdown$3,
  errors: errors$3,
  file: file$3,
  highlighted_text: highlighted_text$3,
  image: image$3,
  label: label$3,
  login: login$3,
  number: number$3,
  plot: plot$3,
  radio: radio$3,
  slider: slider$3,
  video: video$3,
  chatbot: chatbot$3
};
const __vite_glob_0_27 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$3,
  annotated_image: annotated_image$3,
  audio: audio$3,
  blocks: blocks$3,
  chatbot: chatbot$3,
  checkbox: checkbox$3,
  code: code$3,
  color_picker: color_picker$3,
  common: common$3,
  dataframe: dataframe$3,
  default: ur,
  dropdown: dropdown$3,
  errors: errors$3,
  file: file$3,
  highlighted_text: highlighted_text$3,
  image: image$3,
  label: label$3,
  login: login$3,
  number: number$3,
  plot: plot$3,
  radio: radio$3,
  slider: slider$3,
  upload_text: upload_text$3,
  video: video$3
}, Symbol.toStringTag, { value: "Module" }));
const _name$2 = "O'zbek";
const common$2 = {
  built_with_gradio: "Gradio bilan yaratilgan",
  clear: "Tozalash",
  submit: "Yuborish",
  built_with: "Bilan yaratilgan",
  download: "Yuklab olish",
  edit: "Tahrirlash",
  empty: "Bo'sh",
  error: "Xato",
  hosted_on: "Joylashtirilgan",
  loading: "Yuklanmoqda",
  logo: "Logo",
  or: "yoki",
  remove: "O'chirish",
  settings: "Sozlamalar",
  share: "Ulashish",
  undo: "Bekor qilish",
  no_devices: "Hech qanday qurilma topilmadi",
  language: "Til",
  display_theme: "Ko'rinish mavzusi",
  pwa: "Progressive web-ilova"
};
const upload_text$2 = {
  click_to_upload: "Yuklash uchun bosing",
  drop_audio: "Audioni shu yerga tashlang",
  drop_csv: "CSV faylni shu yerga tashlang",
  drop_file: "Faylni shu yerga tashlang",
  drop_image: "Rasmni shu yerga tashlang",
  drop_video: "Videoni shu yerga tashlang",
  drop_gallery: "Mediafaylni shu yerga tashlang",
  paste_clipboard: "Klipboarddan qo'yish"
};
const annotated_image$2 = {
  annotated_image: "Izohli rasm"
};
const audio$2 = {
  allow_recording_access: "Iltimos, yozib olish uchun mikrofonga ruxsat bering.",
  audio: "Audio",
  drop_to_upload: "Audio faylni yuklash uchun shu yerga tashlang",
  record_from_microphone: "Mikrofondan yozib olish",
  stop_recording: "Yozib olishni to'xtatish",
  no_device_support: "Media qurilmalariga kira olmadik. Xavfsiz manbada (https) yoki localhost-da ishlayotganingizni tekshiring (yoki to'g'ri SSL sertifikatini ssl_verify-ga berganingizni) va brauzer qurilmangizga kirishiga ruxsat berganingizni tekshiring.",
  stop: "To'xtatish",
  resume: "Davom ettirish",
  record: "Yozib olish",
  no_microphone: "Mikrofon topilmadi",
  pause: "Pauza",
  play: "Ijro etish",
  waiting: "Kutilmoqda"
};
const blocks$2 = {
  connection_can_break: "Mobil qurilmada, agar bu yorliq fokusdan chiqsa yoki qurilma uyqu rejimiga o'tsa, aloqa uzilib, navbatdagi o'rningizni yo'qotishingiz mumkin.",
  long_requests_queue: "So'rovlar navbati juda uzun. Navbatni chetlab o'tish uchun bu Space-ni nusxalang.",
  lost_connection: "Sahifadan chiqib ketganligi sababli aloqa uzildi. Navbatga qayta qo'shilmoqda...",
  waiting_for_inputs: "Fayl(lar) yuklanib bo'lishini kutish, iltimos, qayta urinib ko'ring."
};
const checkbox$2 = {
  checkbox: "Belgilash katagi",
  checkbox_group: "Belgilash kataklari guruhi"
};
const code$2 = {
  code: "Kod"
};
const color_picker$2 = {
  color_picker: "Rang tanlagich"
};
const dataframe$2 = {
  incorrect_format: "Noto'g'ri format, faqat CSV va TSV fayllari qo'llab-quvvatlanadi",
  new_column: "Ustun qo'shish",
  new_row: "Yangi qator",
  add_row_above: "Yuqoriga qator qo'shish",
  add_row_below: "Pastga qator qo'shish",
  delete_row: "Qatorni o'chirish",
  delete_column: "Ustunni o'chirish",
  add_column_left: "Chapga ustun qo'shish",
  add_column_right: "O'ngga ustun qo'shish",
  sort_column: "Ustunni saralash",
  sort_ascending: "O'sish tartibida saralash",
  sort_descending: "Kamayish tartibida saralash",
  drop_to_upload: "Ma'lumotlarni ma'lumotlar jadvaliga import qilish uchun CSV yoki TSV fayllarini shu yerga tashlang",
  clear_sort: "Saralashni tozalash"
};
const dropdown$2 = {
  dropdown: "Ochiluvchi ro'yxat"
};
const errors$2 = {
  build_error: "Tuzilish xatosi mavjud",
  config_error: "Konfiguratsiya xatosi mavjud",
  contact_page_author: "Iltimos, sahifa muallifiga bog'laning va ularga xabar bering.",
  no_app_file: "Ilova fayli yo'q",
  runtime_error: "Bajarilish vaqti xatosi mavjud",
  space_not_working: '"Space ishlamayapti, chunki" {0}',
  space_paused: "Space to'xtatilgan",
  use_via_api: "API orqali foydalaning",
  use_via_api_or_mcp: "API yoki MCP orqali foydalaning"
};
const file$2 = {
  uploading: "Yuklanmoqda..."
};
const highlighted_text$2 = {
  highlighted_text: "Ajratilgan matn"
};
const image$2 = {
  allow_webcam_access: "Iltimos, yozib olish uchun veb-kameraga ruxsat bering.",
  brush_color: "Cho'tka rangi",
  brush_radius: "Cho'tka o'lchami",
  image: "Rasm",
  remove_image: "Rasmni o'chirish",
  select_brush_color: "Cho'tka rangini tanlang",
  start_drawing: "Chizishni boshlang",
  use_brush: "Cho'tkadan foydalaning",
  drop_to_upload: "Rasm faylini yuklash uchun shu yerga tashlang"
};
const label$2 = {
  label: "Yorliq"
};
const login$2 = {
  enable_cookies: "Agar HuggingFace Space-ni Inkognito rejimida ko'rayotgan bo'lsangiz, uchinchi tomon kukilarini yoqishingiz kerak.",
  incorrect_credentials: "Noto'g'ri kirish ma'lumotlari",
  username: "Foydalanuvchi nomi",
  password: "Parol",
  login: "Kirish"
};
const number$2 = {
  number: "Raqam"
};
const plot$2 = {
  plot: "Grafik"
};
const radio$2 = {
  radio: "Radio tugma"
};
const slider$2 = {
  slider: "Slayder"
};
const video$2 = {
  drop_to_upload: "Video faylni yuklash uchun shu yerga tashlang"
};
const chatbot$2 = {
  edit: "Tahrirlash",
  retry: "Qayta urinish",
  undo: "Bekor qilish",
  submit: "Yuborish",
  cancel: "Bekor qilish",
  like: "Yoqdi",
  dislike: "Yoqmadi",
  clear: "Suhbatni tozalash"
};
const uz = {
  _name: _name$2,
  common: common$2,
  upload_text: upload_text$2,
  "3D_model": {
    "3d_model": "3D model",
    drop_to_upload: "3D model (.obj, .glb, .stl, .gltf, .splat yoki .ply) faylni yuklash uchun shu yerga tashlang"
  },
  annotated_image: annotated_image$2,
  audio: audio$2,
  blocks: blocks$2,
  checkbox: checkbox$2,
  code: code$2,
  color_picker: color_picker$2,
  dataframe: dataframe$2,
  dropdown: dropdown$2,
  errors: errors$2,
  file: file$2,
  highlighted_text: highlighted_text$2,
  image: image$2,
  label: label$2,
  login: login$2,
  number: number$2,
  plot: plot$2,
  radio: radio$2,
  slider: slider$2,
  video: video$2,
  chatbot: chatbot$2
};
const __vite_glob_0_28 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$2,
  annotated_image: annotated_image$2,
  audio: audio$2,
  blocks: blocks$2,
  chatbot: chatbot$2,
  checkbox: checkbox$2,
  code: code$2,
  color_picker: color_picker$2,
  common: common$2,
  dataframe: dataframe$2,
  default: uz,
  dropdown: dropdown$2,
  errors: errors$2,
  file: file$2,
  highlighted_text: highlighted_text$2,
  image: image$2,
  label: label$2,
  login: login$2,
  number: number$2,
  plot: plot$2,
  radio: radio$2,
  slider: slider$2,
  upload_text: upload_text$2,
  video: video$2
}, Symbol.toStringTag, { value: "Module" }));
const _name$1 = "简体中文";
const annotated_image$1 = {
  annotated_image: "标注图像"
};
const audio$1 = {
  allow_recording_access: "请允许访问麦克风以进行录音。",
  audio: "音频",
  record_from_microphone: "从麦克风录制",
  stop_recording: "停止录制",
  no_device_support: "无法访问媒体设备。请检查您是否在安全来源（https）或本地主机上运行（或者您已经通过 ssl_verify 传递了有效的 SSL 证书），并且您已经允许浏览器访问您的设备。",
  stop: "停止",
  resume: "继续",
  record: "录制",
  no_microphone: "找不到麦克风",
  pause: "暂停",
  play: "播放",
  waiting: "等待中",
  drop_to_upload: "将音频文件拖放到此处以上传"
};
const blocks$1 = {
  connection_can_break: "在移动设备上，如果此标签页失去焦点或设备休眠，连接可能会中断，导致您在队列中失去位置。",
  long_requests_queue: "有一个长时间的待处理请求队列。复制此 Space 以跳过队列。",
  lost_connection: "由于离开页面，连接已丢失。正在重新加入队列...",
  waiting_for_inputs: "等待文件上传完成，请稍后重试。"
};
const checkbox$1 = {
  checkbox: "复选框",
  checkbox_group: "复选框组"
};
const code$1 = {
  code: "代码"
};
const color_picker$1 = {
  color_picker: "颜色选择器"
};
const common$1 = {
  built_with: "构建于",
  built_with_gradio: "使用 Gradio 构建",
  clear: "清除",
  download: "下载",
  edit: "编辑",
  empty: "空",
  error: "错误",
  hosted_on: "托管在",
  loading: "加载中",
  logo: "标志",
  or: "或",
  remove: "移除",
  share: "分享",
  submit: "提交",
  undo: "撤销",
  settings: "设置",
  no_devices: "未找到设备",
  language: "语言",
  display_theme: "显示主题",
  pwa: "渐进式 Web 应用"
};
const dataframe$1 = {
  incorrect_format: "格式不正确，仅支持 CSV 和 TSV 文件",
  new_column: "添加列",
  new_row: "新行",
  add_row_above: "在上方添加行",
  add_row_below: "在下方添加行",
  delete_row: "删除行",
  delete_column: "删除列",
  add_column_left: "在左侧添加列",
  add_column_right: "在右侧添加列",
  sort_column: "排序列",
  sort_ascending: "升序排序",
  sort_descending: "降序排序",
  drop_to_upload: "将 CSV 或 TSV 文件拖放到此处以将数据导入数据框",
  clear_sort: "清除排序"
};
const dropdown$1 = {
  dropdown: "下拉菜单"
};
const errors$1 = {
  build_error: "存在构建错误",
  config_error: "存在配置错误",
  contact_page_author: "请联系页面的作者并告知他们。",
  no_app_file: "不存在应用文件",
  runtime_error: "存在运行时错误",
  space_not_working: '"Space 无法工作，原因：" {0}',
  space_paused: "Space 已暂停",
  use_via_api: "通过 API 使用",
  use_via_api_or_mcp: "通过 API 或 MCP 使用"
};
const file$1 = {
  uploading: "正在上传..."
};
const highlighted_text$1 = {
  highlighted_text: "高亮文本"
};
const image$1 = {
  allow_webcam_access: "请允许访问网络摄像头以进行录制。",
  brush_color: "画笔颜色",
  brush_radius: "画笔大小",
  image: "图像",
  remove_image: "移除图像",
  select_brush_color: "选择画笔颜色",
  start_drawing: "开始绘画",
  use_brush: "使用画笔",
  drop_to_upload: "将图像文件拖放到此处以上传"
};
const label$1 = {
  label: "标签"
};
const login$1 = {
  enable_cookies: "如果您正在使用隐身模式访问 HuggingFace Space，您必须启用第三方 cookie。",
  incorrect_credentials: "凭据不正确",
  login: "登录",
  username: "用户名",
  password: "密码"
};
const number$1 = {
  number: "数字"
};
const plot$1 = {
  plot: "图表"
};
const radio$1 = {
  radio: "单选框"
};
const slider$1 = {
  slider: "滑块"
};
const upload_text$1 = {
  click_to_upload: "点击上传",
  drop_audio: "将音频拖放到此处",
  drop_csv: "将 CSV 文件拖放到此处",
  drop_file: "将文件拖放到此处",
  drop_image: "将图像拖放到此处",
  drop_video: "将视频拖放到此处",
  drop_gallery: "在此处放置媒体文件",
  paste_clipboard: "从剪贴板粘贴"
};
const video$1 = {
  drop_to_upload: "将视频文件拖放到此处以上传"
};
const chatbot$1 = {
  edit: "编辑",
  retry: "重试",
  undo: "撤销",
  submit: "发送",
  cancel: "取消",
  like: "赞",
  dislike: "踩",
  clear: "清空对话"
};
const zhCN = {
  _name: _name$1,
  "3D_model": {
    "3d_model": "3D模型",
    drop_to_upload: "将 3D 模型（.obj、.glb、.stl、.gltf、.splat 或 .ply）文件拖放到此处以上传"
  },
  annotated_image: annotated_image$1,
  audio: audio$1,
  blocks: blocks$1,
  checkbox: checkbox$1,
  code: code$1,
  color_picker: color_picker$1,
  common: common$1,
  dataframe: dataframe$1,
  dropdown: dropdown$1,
  errors: errors$1,
  file: file$1,
  highlighted_text: highlighted_text$1,
  image: image$1,
  label: label$1,
  login: login$1,
  number: number$1,
  plot: plot$1,
  radio: radio$1,
  slider: slider$1,
  upload_text: upload_text$1,
  video: video$1,
  chatbot: chatbot$1
};
const __vite_glob_0_29 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name: _name$1,
  annotated_image: annotated_image$1,
  audio: audio$1,
  blocks: blocks$1,
  chatbot: chatbot$1,
  checkbox: checkbox$1,
  code: code$1,
  color_picker: color_picker$1,
  common: common$1,
  dataframe: dataframe$1,
  default: zhCN,
  dropdown: dropdown$1,
  errors: errors$1,
  file: file$1,
  highlighted_text: highlighted_text$1,
  image: image$1,
  label: label$1,
  login: login$1,
  number: number$1,
  plot: plot$1,
  radio: radio$1,
  slider: slider$1,
  upload_text: upload_text$1,
  video: video$1
}, Symbol.toStringTag, { value: "Module" }));
const _name = "繁體中文";
const common = {
  built_with_gradio: "使用 Gradio 建構",
  clear: "清除",
  or: "或",
  submit: "提交",
  built_with: "使用",
  download: "下載",
  edit: "編輯",
  empty: "空白",
  error: "錯誤",
  hosted_on: "托管於",
  loading: "載入中",
  logo: "標誌",
  remove: "移除",
  settings: "設定",
  share: "分享",
  undo: "復原",
  no_devices: "未找到裝置",
  language: "語言",
  display_theme: "顯示主題",
  pwa: "漸進式網頁應用程式"
};
const upload_text = {
  click_to_upload: "點擊上傳",
  drop_audio: "拖放音訊至此處",
  drop_csv: "拖放 CSV 至此處",
  drop_file: "拖放檔案至此處",
  drop_image: "拖放圖片至此處",
  drop_video: "拖放影片至此處",
  drop_gallery: "在此處拖放媒體",
  paste_clipboard: "從剪貼簿貼上"
};
const annotated_image = {
  annotated_image: "標註圖像"
};
const audio = {
  allow_recording_access: "請允許存取麥克風以進行錄音。",
  audio: "音訊",
  drop_to_upload: "將音訊檔案拖放到這裡上傳",
  record_from_microphone: "從麥克風錄音",
  stop_recording: "停止錄製",
  no_device_support: "無法存取媒體裝置。請確認您正在使用安全來源（https）或本機主機（或您已提供有效的 SSL 憑證以進行 ssl_verify），並且已允許瀏覽器存取您的裝置。",
  stop: "停止",
  resume: "繼續",
  record: "錄製",
  no_microphone: "未找到麥克風",
  pause: "暫停",
  play: "播放",
  waiting: "等待中"
};
const blocks = {
  connection_can_break: "在行動裝置上，如果此分頁失去焦點或裝置進入睡眠模式，連線可能會中斷，導致您在隊列中的位置遺失。",
  long_requests_queue: "目前有許多待處理的請求。複製此 Space 以跳過隊列。",
  lost_connection: "因離開頁面而失去連接。正在重新加入隊列...",
  waiting_for_inputs: "等待檔案上傳完成，請稍後重試。"
};
const checkbox = {
  checkbox: "核取方塊",
  checkbox_group: "核取方塊群組"
};
const code = {
  code: "程式碼"
};
const color_picker = {
  color_picker: "顏色選擇器"
};
const dataframe = {
  incorrect_format: "格式不正確，僅支援 CSV 和 TSV 檔案",
  new_column: "新增欄位",
  new_row: "新增列",
  add_row_above: "在上方新增列",
  add_row_below: "在下方新增列",
  delete_row: "刪除列",
  delete_column: "刪除欄位",
  add_column_left: "在左側新增欄位",
  add_column_right: "在右側新增欄位",
  sort_column: "排序欄位",
  sort_ascending: "升冪排序",
  sort_descending: "降冪排序",
  drop_to_upload: "將 CSV 或 TSV 檔案拖放到這裡以匯入資料到資料框中",
  clear_sort: "清除排序"
};
const dropdown = {
  dropdown: "下拉選單"
};
const errors = {
  build_error: "有建置錯誤",
  config_error: "有設定錯誤",
  contact_page_author: "請聯繫頁面的作者以通知他們。",
  no_app_file: "沒有應用程式檔案",
  runtime_error: "有執行時錯誤",
  space_not_working: '"Space 無法運作，因為" {0}',
  space_paused: "Space 已暫停",
  use_via_api: "透過 API 使用",
  use_via_api_or_mcp: "透過 API 或 MCP 使用"
};
const file = {
  uploading: "上傳中..."
};
const highlighted_text = {
  highlighted_text: "醒目提示的文字"
};
const image = {
  allow_webcam_access: "請允許存取網路攝影機以進行錄製。",
  brush_color: "筆刷顏色",
  brush_radius: "筆刷大小",
  image: "圖像",
  remove_image: "移除圖片",
  select_brush_color: "選擇筆刷顏色",
  start_drawing: "開始繪圖",
  use_brush: "使用筆刷",
  drop_to_upload: "將圖像檔案拖放到這裡上傳"
};
const label = {
  label: "標籤"
};
const login = {
  enable_cookies: "如果您在無痕模式下訪問 HuggingFace Space，您必須啟用第三方 Cookie。",
  incorrect_credentials: "憑證錯誤",
  username: "使用者名稱",
  password: "密碼",
  login: "登入"
};
const number = {
  number: "數字"
};
const plot = {
  plot: "圖表"
};
const radio = {
  radio: "單選按鈕"
};
const slider = {
  slider: "滑桿"
};
const video = {
  drop_to_upload: "將影片檔案拖放到這裡上傳"
};
const chatbot = {
  edit: "編輯",
  retry: "重試",
  undo: "復原",
  submit: "送出",
  cancel: "取消",
  like: "讚",
  dislike: "不讚",
  clear: "清空對話"
};
const zhTW = {
  _name,
  common,
  upload_text,
  "3D_model": {
    "3d_model": "3D 模型",
    drop_to_upload: "將 3D 模型 (.obj、.glb、.stl、.gltf、.splat 或 .ply) 檔案拖放到這裡上傳"
  },
  annotated_image,
  audio,
  blocks,
  checkbox,
  code,
  color_picker,
  dataframe,
  dropdown,
  errors,
  file,
  highlighted_text,
  image,
  label,
  login,
  number,
  plot,
  radio,
  slider,
  video,
  chatbot
};
const __vite_glob_0_30 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  _name,
  annotated_image,
  audio,
  blocks,
  chatbot,
  checkbox,
  code,
  color_picker,
  common,
  dataframe,
  default: zhTW,
  dropdown,
  errors,
  file,
  highlighted_text,
  image,
  label,
  login,
  number,
  plot,
  radio,
  slider,
  upload_text,
  video
}, Symbol.toStringTag, { value: "Module" }));
const ordered_colors = [
  "red",
  "green",
  "blue",
  "yellow",
  "purple",
  "teal",
  "orange",
  "cyan",
  "lime",
  "pink"
];
const color_values = [
  { color: "red", primary: 600, secondary: 100 },
  { color: "green", primary: 600, secondary: 100 },
  { color: "blue", primary: 600, secondary: 100 },
  { color: "yellow", primary: 500, secondary: 100 },
  { color: "purple", primary: 600, secondary: 100 },
  { color: "teal", primary: 600, secondary: 100 },
  { color: "orange", primary: 600, secondary: 100 },
  { color: "cyan", primary: 600, secondary: 100 },
  { color: "lime", primary: 500, secondary: 100 },
  { color: "pink", primary: 600, secondary: 100 }
];
const tw_colors = {
  inherit: "inherit",
  current: "currentColor",
  transparent: "transparent",
  black: "#000",
  white: "#fff",
  slate: {
    50: "#f8fafc",
    100: "#f1f5f9",
    200: "#e2e8f0",
    300: "#cbd5e1",
    400: "#94a3b8",
    500: "#64748b",
    600: "#475569",
    700: "#334155",
    800: "#1e293b",
    900: "#0f172a",
    950: "#020617"
  },
  gray: {
    50: "#f9fafb",
    100: "#f3f4f6",
    200: "#e5e7eb",
    300: "#d1d5db",
    400: "#9ca3af",
    500: "#6b7280",
    600: "#4b5563",
    700: "#374151",
    800: "#1f2937",
    900: "#111827",
    950: "#030712"
  },
  zinc: {
    50: "#fafafa",
    100: "#f4f4f5",
    200: "#e4e4e7",
    300: "#d4d4d8",
    400: "#a1a1aa",
    500: "#71717a",
    600: "#52525b",
    700: "#3f3f46",
    800: "#27272a",
    900: "#18181b",
    950: "#09090b"
  },
  neutral: {
    50: "#fafafa",
    100: "#f5f5f5",
    200: "#e5e5e5",
    300: "#d4d4d4",
    400: "#a3a3a3",
    500: "#737373",
    600: "#525252",
    700: "#404040",
    800: "#262626",
    900: "#171717",
    950: "#0a0a0a"
  },
  stone: {
    50: "#fafaf9",
    100: "#f5f5f4",
    200: "#e7e5e4",
    300: "#d6d3d1",
    400: "#a8a29e",
    500: "#78716c",
    600: "#57534e",
    700: "#44403c",
    800: "#292524",
    900: "#1c1917",
    950: "#0c0a09"
  },
  red: {
    50: "#fef2f2",
    100: "#fee2e2",
    200: "#fecaca",
    300: "#fca5a5",
    400: "#f87171",
    500: "#ef4444",
    600: "#dc2626",
    700: "#b91c1c",
    800: "#991b1b",
    900: "#7f1d1d",
    950: "#450a0a"
  },
  orange: {
    50: "#fff7ed",
    100: "#ffedd5",
    200: "#fed7aa",
    300: "#fdba74",
    400: "#fb923c",
    500: "#f97316",
    600: "#ea580c",
    700: "#c2410c",
    800: "#9a3412",
    900: "#7c2d12",
    950: "#431407"
  },
  amber: {
    50: "#fffbeb",
    100: "#fef3c7",
    200: "#fde68a",
    300: "#fcd34d",
    400: "#fbbf24",
    500: "#f59e0b",
    600: "#d97706",
    700: "#b45309",
    800: "#92400e",
    900: "#78350f",
    950: "#451a03"
  },
  yellow: {
    50: "#fefce8",
    100: "#fef9c3",
    200: "#fef08a",
    300: "#fde047",
    400: "#facc15",
    500: "#eab308",
    600: "#ca8a04",
    700: "#a16207",
    800: "#854d0e",
    900: "#713f12",
    950: "#422006"
  },
  lime: {
    50: "#f7fee7",
    100: "#ecfccb",
    200: "#d9f99d",
    300: "#bef264",
    400: "#a3e635",
    500: "#84cc16",
    600: "#65a30d",
    700: "#4d7c0f",
    800: "#3f6212",
    900: "#365314",
    950: "#1a2e05"
  },
  green: {
    50: "#f0fdf4",
    100: "#dcfce7",
    200: "#bbf7d0",
    300: "#86efac",
    400: "#4ade80",
    500: "#22c55e",
    600: "#16a34a",
    700: "#15803d",
    800: "#166534",
    900: "#14532d",
    950: "#052e16"
  },
  emerald: {
    50: "#ecfdf5",
    100: "#d1fae5",
    200: "#a7f3d0",
    300: "#6ee7b7",
    400: "#34d399",
    500: "#10b981",
    600: "#059669",
    700: "#047857",
    800: "#065f46",
    900: "#064e3b",
    950: "#022c22"
  },
  teal: {
    50: "#f0fdfa",
    100: "#ccfbf1",
    200: "#99f6e4",
    300: "#5eead4",
    400: "#2dd4bf",
    500: "#14b8a6",
    600: "#0d9488",
    700: "#0f766e",
    800: "#115e59",
    900: "#134e4a",
    950: "#042f2e"
  },
  cyan: {
    50: "#ecfeff",
    100: "#cffafe",
    200: "#a5f3fc",
    300: "#67e8f9",
    400: "#22d3ee",
    500: "#06b6d4",
    600: "#0891b2",
    700: "#0e7490",
    800: "#155e75",
    900: "#164e63",
    950: "#083344"
  },
  sky: {
    50: "#f0f9ff",
    100: "#e0f2fe",
    200: "#bae6fd",
    300: "#7dd3fc",
    400: "#38bdf8",
    500: "#0ea5e9",
    600: "#0284c7",
    700: "#0369a1",
    800: "#075985",
    900: "#0c4a6e",
    950: "#082f49"
  },
  blue: {
    50: "#eff6ff",
    100: "#dbeafe",
    200: "#bfdbfe",
    300: "#93c5fd",
    400: "#60a5fa",
    500: "#3b82f6",
    600: "#2563eb",
    700: "#1d4ed8",
    800: "#1e40af",
    900: "#1e3a8a",
    950: "#172554"
  },
  indigo: {
    50: "#eef2ff",
    100: "#e0e7ff",
    200: "#c7d2fe",
    300: "#a5b4fc",
    400: "#818cf8",
    500: "#6366f1",
    600: "#4f46e5",
    700: "#4338ca",
    800: "#3730a3",
    900: "#312e81",
    950: "#1e1b4b"
  },
  violet: {
    50: "#f5f3ff",
    100: "#ede9fe",
    200: "#ddd6fe",
    300: "#c4b5fd",
    400: "#a78bfa",
    500: "#8b5cf6",
    600: "#7c3aed",
    700: "#6d28d9",
    800: "#5b21b6",
    900: "#4c1d95",
    950: "#2e1065"
  },
  purple: {
    50: "#faf5ff",
    100: "#f3e8ff",
    200: "#e9d5ff",
    300: "#d8b4fe",
    400: "#c084fc",
    500: "#a855f7",
    600: "#9333ea",
    700: "#7e22ce",
    800: "#6b21a8",
    900: "#581c87",
    950: "#3b0764"
  },
  fuchsia: {
    50: "#fdf4ff",
    100: "#fae8ff",
    200: "#f5d0fe",
    300: "#f0abfc",
    400: "#e879f9",
    500: "#d946ef",
    600: "#c026d3",
    700: "#a21caf",
    800: "#86198f",
    900: "#701a75",
    950: "#4a044e"
  },
  pink: {
    50: "#fdf2f8",
    100: "#fce7f3",
    200: "#fbcfe8",
    300: "#f9a8d4",
    400: "#f472b6",
    500: "#ec4899",
    600: "#db2777",
    700: "#be185d",
    800: "#9d174d",
    900: "#831843",
    950: "#500724"
  },
  rose: {
    50: "#fff1f2",
    100: "#ffe4e6",
    200: "#fecdd3",
    300: "#fda4af",
    400: "#fb7185",
    500: "#f43f5e",
    600: "#e11d48",
    700: "#be123c",
    800: "#9f1239",
    900: "#881337",
    950: "#4c0519"
  }
};
const colors = color_values.reduce(
  (acc, { color, primary, secondary }) => ({
    ...acc,
    [color]: {
      primary: tw_colors[color][primary],
      secondary: tw_colors[color][secondary]
    }
  }),
  {}
);
function formatter(value) {
  if (value == null) {
    return "";
  }
  const string_value = String(value);
  const translate = get_store_value($format);
  let direct_translation = translate(string_value);
  if (direct_translation !== string_value) {
    return direct_translation;
  }
  const lower_value = string_value.toLowerCase();
  for (const common_key of all_common_keys) {
    const key_name = common_key.substring(common_key.indexOf(".") + 1);
    if (lower_value === key_name) {
      const translation = translate(common_key);
      if (translation !== common_key) {
        return translation;
      }
      break;
    }
  }
  return string_value;
}
const reactive_formatter = derived($format, () => formatter);
const langs = /* @__PURE__ */ Object.assign({
  "./lang/ar.json": __vite_glob_0_0,
  "./lang/ca.json": __vite_glob_0_1,
  "./lang/ckb.json": __vite_glob_0_2,
  "./lang/de.json": __vite_glob_0_3,
  "./lang/en.json": __vite_glob_0_4,
  "./lang/es.json": __vite_glob_0_5,
  "./lang/eu.json": __vite_glob_0_6,
  "./lang/fa.json": __vite_glob_0_7,
  "./lang/fi.json": __vite_glob_0_8,
  "./lang/fr.json": __vite_glob_0_9,
  "./lang/he.json": __vite_glob_0_10,
  "./lang/hi.json": __vite_glob_0_11,
  "./lang/ja.json": __vite_glob_0_12,
  "./lang/ko.json": __vite_glob_0_13,
  "./lang/lt.json": __vite_glob_0_14,
  "./lang/nb.json": __vite_glob_0_15,
  "./lang/nl.json": __vite_glob_0_16,
  "./lang/pl.json": __vite_glob_0_17,
  "./lang/pt-BR.json": __vite_glob_0_18,
  "./lang/pt.json": __vite_glob_0_19,
  "./lang/ro.json": __vite_glob_0_20,
  "./lang/ru.json": __vite_glob_0_21,
  "./lang/sv.json": __vite_glob_0_22,
  "./lang/ta.json": __vite_glob_0_23,
  "./lang/th.json": __vite_glob_0_24,
  "./lang/tr.json": __vite_glob_0_25,
  "./lang/uk.json": __vite_glob_0_26,
  "./lang/ur.json": __vite_glob_0_27,
  "./lang/uz.json": __vite_glob_0_28,
  "./lang/zh-CN.json": __vite_glob_0_29,
  "./lang/zh-TW.json": __vite_glob_0_30
});
function is_translation_metadata(obj) {
  console.log(obj);
  const result = obj && typeof obj === "object" && obj.__type__ === "translation_metadata" && typeof obj.key === "string";
  return result;
}
function translate_if_needed(value) {
  if (typeof value !== "string") {
    return value;
  }
  const i18n_marker = "__i18n__";
  const marker_index = value.indexOf(i18n_marker);
  if (marker_index === -1) {
    return value;
  }
  try {
    const before_marker = marker_index > 0 ? value.substring(0, marker_index) : "";
    const after_marker_index = marker_index + i18n_marker.length;
    const json_start = value.indexOf("{", after_marker_index);
    let json_end = -1;
    let bracket_count = 0;
    for (let i = json_start; i < value.length; i++) {
      if (value[i] === "{")
        bracket_count++;
      if (value[i] === "}")
        bracket_count--;
      if (bracket_count === 0) {
        json_end = i + 1;
        break;
      }
    }
    if (json_end === -1) {
      console.error("Could not find end of JSON in i18n string");
      return value;
    }
    const metadata_json = value.substring(json_start, json_end);
    const after_json = json_end < value.length ? value.substring(json_end) : "";
    try {
      const metadata = JSON.parse(metadata_json);
      if (metadata && metadata.key) {
        const translated = formatter(metadata.key);
        return before_marker + translated + after_json;
      }
    } catch (jsonError) {
      console.error("Error parsing i18n JSON:", jsonError);
    }
    return value;
  } catch (e) {
    console.error("Error processing translation:", e);
    return value;
  }
}
function process_langs() {
  return Object.fromEntries(
    Object.entries(langs).map(([path2, module]) => [
      path2.split("/").pop().split(".")[0],
      module.default
    ])
  );
}
const processed_langs = process_langs();
const available_locales = Object.keys(processed_langs);
const language_choices = Object.entries(
  processed_langs
).map(([code2, data]) => [data._name || code2, code2]);
let all_common_keys = /* @__PURE__ */ new Set();
let i18n_initialized = false;
let previous_translations;
async function setupi18n(custom_translations) {
  const should_reinitialize = i18n_initialized && custom_translations !== previous_translations;
  if (i18n_initialized && !should_reinitialize) {
    return;
  }
  previous_translations = custom_translations;
  load_translations({
    ...processed_langs,
    ...custom_translations ?? {}
  });
  const browser_locale = getLocaleFromNavigator();
  let initial_locale = browser_locale && available_locales.includes(browser_locale) ? browser_locale : null;
  if (!initial_locale) {
    const normalized_locale = browser_locale?.split("-")[0];
    initial_locale = normalized_locale && available_locales.includes(normalized_locale) ? normalized_locale : "en";
  }
  await init({
    fallbackLocale: "en",
    initialLocale: initial_locale
  });
  for (const lang_code in processed_langs) {
    if (processed_langs[lang_code] && typeof processed_langs[lang_code] === "object" && processed_langs[lang_code].common && typeof processed_langs[lang_code].common === "object") {
      const common_ns = processed_langs[lang_code].common;
      for (const key in common_ns) {
        all_common_keys.add(`common.${key}`);
      }
    }
  }
  i18n_initialized = true;
}
function changeLocale(new_locale) {
  $locale.set(new_locale);
}
function get_initial_locale(browser_locale, available_locales2, fallback_locale = "en") {
  if (!browser_locale)
    return fallback_locale;
  if (available_locales2.includes(browser_locale)) {
    return browser_locale;
  }
  return fallback_locale;
}
function load_translations(translations) {
  if (!translations) {
    return;
  }
  try {
    for (const lang in translations) {
      addMessages(lang, translations[lang]);
    }
  } catch (e) {
    console.error("Error loading translations:", e);
  }
}
function pretty_si(num) {
  let units = ["", "k", "M", "G", "T", "P", "E", "Z"];
  let i = 0;
  while (num > 1e3 && i < units.length - 1) {
    num /= 1e3;
    i++;
  }
  let unit = units[i];
  return (Number.isInteger(num) ? num : num.toFixed(1)) + unit;
}
const css$i$1 = {
  code: "svg.svelte-zyxd38.svelte-zyxd38{width:var(--size-20);height:var(--size-20)}svg.svelte-zyxd38 path.svelte-zyxd38{fill:var(--loader-color)}div.svelte-zyxd38.svelte-zyxd38{z-index:var(--layer-2)}.margin.svelte-zyxd38.svelte-zyxd38{margin:var(--size-4)}",
  map: '{"version":3,"file":"Loader.svelte","sources":["Loader.svelte"],"sourcesContent":["<script lang=\\"ts\\">import { onMount } from \\"svelte\\";\\nimport { spring } from \\"svelte/motion\\";\\nexport let margin = true;\\nconst top = spring([0, 0]);\\nconst bottom = spring([0, 0]);\\nlet dismounted;\\nasync function animate() {\\n    await Promise.all([top.set([125, 140]), bottom.set([-125, -140])]);\\n    await Promise.all([top.set([-125, 140]), bottom.set([125, -140])]);\\n    await Promise.all([top.set([-125, 0]), bottom.set([125, -0])]);\\n    await Promise.all([top.set([125, 0]), bottom.set([-125, 0])]);\\n}\\nasync function run() {\\n    await animate();\\n    if (!dismounted)\\n        run();\\n}\\nasync function loading() {\\n    await Promise.all([top.set([125, 0]), bottom.set([-125, 0])]);\\n    run();\\n}\\nonMount(() => {\\n    loading();\\n    return () => dismounted = true;\\n});\\n<\/script>\\n\\n<div class:margin>\\n\\t<svg\\n\\t\\tviewBox=\\"-1200 -1200 3000 3000\\"\\n\\t\\tfill=\\"none\\"\\n\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t>\\n\\t\\t<g style=\\"transform: translate({$top[0]}px, {$top[1]}px);\\">\\n\\t\\t\\t<path\\n\\t\\t\\t\\td=\\"M255.926 0.754768L509.702 139.936V221.027L255.926 81.8465V0.754768Z\\"\\n\\t\\t\\t\\tfill=\\"#FF7C00\\"\\n\\t\\t\\t\\tfill-opacity=\\"0.4\\"\\n\\t\\t\\t/>\\n\\t\\t\\t<path\\n\\t\\t\\t\\td=\\"M509.69 139.936L254.981 279.641V361.255L509.69 221.55V139.936Z\\"\\n\\t\\t\\t\\tfill=\\"#FF7C00\\"\\n\\t\\t\\t/>\\n\\t\\t\\t<path\\n\\t\\t\\t\\td=\\"M0.250138 139.937L254.981 279.641V361.255L0.250138 221.55V139.937Z\\"\\n\\t\\t\\t\\tfill=\\"#FF7C00\\"\\n\\t\\t\\t\\tfill-opacity=\\"0.4\\"\\n\\t\\t\\t/>\\n\\t\\t\\t<path\\n\\t\\t\\t\\td=\\"M255.923 0.232622L0.236328 139.936V221.55L255.923 81.8469V0.232622Z\\"\\n\\t\\t\\t\\tfill=\\"#FF7C00\\"\\n\\t\\t\\t/>\\n\\t\\t</g>\\n\\t\\t<g style=\\"transform: translate({$bottom[0]}px, {$bottom[1]}px);\\">\\n\\t\\t\\t<path\\n\\t\\t\\t\\td=\\"M255.926 141.5L509.702 280.681V361.773L255.926 222.592V141.5Z\\"\\n\\t\\t\\t\\tfill=\\"#FF7C00\\"\\n\\t\\t\\t\\tfill-opacity=\\"0.4\\"\\n\\t\\t\\t/>\\n\\t\\t\\t<path\\n\\t\\t\\t\\td=\\"M509.69 280.679L254.981 420.384V501.998L509.69 362.293V280.679Z\\"\\n\\t\\t\\t\\tfill=\\"#FF7C00\\"\\n\\t\\t\\t/>\\n\\t\\t\\t<path\\n\\t\\t\\t\\td=\\"M0.250138 280.681L254.981 420.386V502L0.250138 362.295V280.681Z\\"\\n\\t\\t\\t\\tfill=\\"#FF7C00\\"\\n\\t\\t\\t\\tfill-opacity=\\"0.4\\"\\n\\t\\t\\t/>\\n\\t\\t\\t<path\\n\\t\\t\\t\\td=\\"M255.923 140.977L0.236328 280.68V362.294L255.923 222.591V140.977Z\\"\\n\\t\\t\\t\\tfill=\\"#FF7C00\\"\\n\\t\\t\\t/>\\n\\t\\t</g>\\n\\t</svg>\\n</div>\\n\\n<style>\\n\\tsvg {\\n\\t\\twidth: var(--size-20);\\n\\t\\theight: var(--size-20);\\n\\t}\\n\\n\\tsvg path {\\n\\t\\tfill: var(--loader-color);\\n\\t}\\n\\n\\tdiv {\\n\\t\\tz-index: var(--layer-2);\\n\\t}\\n\\n\\t.margin {\\n\\t\\tmargin: var(--size-4);\\n\\t}</style>\\n"],"names":[],"mappings":"AA6EC,+BAAI,CACH,KAAK,CAAE,IAAI,SAAS,CAAC,CACrB,MAAM,CAAE,IAAI,SAAS,CACtB,CAEA,iBAAG,CAAC,kBAAK,CACR,IAAI,CAAE,IAAI,cAAc,CACzB,CAEA,+BAAI,CACH,OAAO,CAAE,IAAI,SAAS,CACvB,CAEA,mCAAQ,CACP,MAAM,CAAE,IAAI,QAAQ,CACrB"}'
};
const Loader = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $top, $$unsubscribe_top;
  let $bottom, $$unsubscribe_bottom;
  let { margin = true } = $$props;
  const top = spring([0, 0]);
  $$unsubscribe_top = subscribe(top, (value) => $top = value);
  const bottom = spring([0, 0]);
  $$unsubscribe_bottom = subscribe(bottom, (value) => $bottom = value);
  if ($$props.margin === void 0 && $$bindings.margin && margin !== void 0)
    $$bindings.margin(margin);
  $$result.css.add(css$i$1);
  $$unsubscribe_top();
  $$unsubscribe_bottom();
  return `<div class="${["svelte-zyxd38", margin ? "margin" : ""].join(" ").trim()}"><svg viewBox="-1200 -1200 3000 3000" fill="none" xmlns="http://www.w3.org/2000/svg" class="svelte-zyxd38"><g style="${"transform: translate(" + escape$4($top[0], true) + "px, " + escape$4($top[1], true) + "px);"}"><path d="M255.926 0.754768L509.702 139.936V221.027L255.926 81.8465V0.754768Z" fill="#FF7C00" fill-opacity="0.4" class="svelte-zyxd38"></path><path d="M509.69 139.936L254.981 279.641V361.255L509.69 221.55V139.936Z" fill="#FF7C00" class="svelte-zyxd38"></path><path d="M0.250138 139.937L254.981 279.641V361.255L0.250138 221.55V139.937Z" fill="#FF7C00" fill-opacity="0.4" class="svelte-zyxd38"></path><path d="M255.923 0.232622L0.236328 139.936V221.55L255.923 81.8469V0.232622Z" fill="#FF7C00" class="svelte-zyxd38"></path></g><g style="${"transform: translate(" + escape$4($bottom[0], true) + "px, " + escape$4($bottom[1], true) + "px);"}"><path d="M255.926 141.5L509.702 280.681V361.773L255.926 222.592V141.5Z" fill="#FF7C00" fill-opacity="0.4" class="svelte-zyxd38"></path><path d="M509.69 280.679L254.981 420.384V501.998L509.69 362.293V280.679Z" fill="#FF7C00" class="svelte-zyxd38"></path><path d="M0.250138 280.681L254.981 420.386V502L0.250138 362.295V280.681Z" fill="#FF7C00" fill-opacity="0.4" class="svelte-zyxd38"></path><path d="M255.923 140.977L0.236328 280.68V362.294L255.923 222.591V140.977Z" fill="#FF7C00" class="svelte-zyxd38"></path></g></svg> </div>`;
});
const css$h$1 = {
  code: ".block.svelte-1svsvh2{position:relative;margin:0;box-shadow:var(--block-shadow);border-width:var(--block-border-width);border-color:var(--block-border-color);border-radius:var(--block-radius);background:var(--block-background-fill);width:100%;line-height:var(--line-sm)}.block.fullscreen.svelte-1svsvh2{border-radius:0}.auto-margin.svelte-1svsvh2{margin-left:auto;margin-right:auto}.block.border_focus.svelte-1svsvh2{border-color:var(--color-accent)}.block.border_contrast.svelte-1svsvh2{border-color:var(--body-text-color)}.padded.svelte-1svsvh2{padding:var(--block-padding)}.hidden.svelte-1svsvh2{display:none}.flex.svelte-1svsvh2{display:flex;flex-direction:column}.hide-container.svelte-1svsvh2:not(.fullscreen){margin:0;box-shadow:none;--block-border-width:0;background:transparent;padding:0;overflow:visible}.resize-handle.svelte-1svsvh2{position:absolute;bottom:0;right:0;width:10px;height:10px;fill:var(--block-border-color);cursor:nwse-resize}.fullscreen.svelte-1svsvh2{position:fixed;top:0;left:0;width:100vw;height:100vh;z-index:1000;overflow:auto}.animating.svelte-1svsvh2{animation:svelte-1svsvh2-pop-out 0.1s ease-out forwards}@keyframes svelte-1svsvh2-pop-out{0%{position:fixed;top:var(--start-top);left:var(--start-left);width:var(--start-width);height:var(--start-height);z-index:100}100%{position:fixed;top:0vh;left:0vw;width:100vw;height:100vh;z-index:1000}}.placeholder.svelte-1svsvh2{border-radius:var(--block-radius);border-width:var(--block-border-width);border-color:var(--block-border-color);border-style:dashed}",
  map: '{"version":3,"file":"Block.svelte","sources":["Block.svelte"],"sourcesContent":["<script lang=\\"ts\\">export let height = void 0;\\nexport let min_height = void 0;\\nexport let max_height = void 0;\\nexport let width = void 0;\\nexport let elem_id = \\"\\";\\nexport let elem_classes = [];\\nexport let variant = \\"solid\\";\\nexport let border_mode = \\"base\\";\\nexport let padding = true;\\nexport let type = \\"normal\\";\\nexport let test_id = void 0;\\nexport let explicit_call = false;\\nexport let container = true;\\nexport let visible = true;\\nexport let allow_overflow = true;\\nexport let overflow_behavior = \\"auto\\";\\nexport let scale = null;\\nexport let min_width = 0;\\nexport let flex = false;\\nexport let resizable = false;\\nexport let rtl = false;\\nexport let fullscreen = false;\\nlet old_fullscreen = fullscreen;\\nlet element;\\nlet tag = type === \\"fieldset\\" ? \\"fieldset\\" : \\"div\\";\\nlet placeholder_height = 0;\\nlet placeholder_width = 0;\\nlet preexpansionBoundingRect = null;\\nfunction handleKeydown(event) {\\n    if (fullscreen && event.key === \\"Escape\\") {\\n        fullscreen = false;\\n    }\\n}\\n$: if (fullscreen !== old_fullscreen) {\\n    old_fullscreen = fullscreen;\\n    if (fullscreen) {\\n        preexpansionBoundingRect = element.getBoundingClientRect();\\n        placeholder_height = element.offsetHeight;\\n        placeholder_width = element.offsetWidth;\\n        window.addEventListener(\\"keydown\\", handleKeydown);\\n    }\\n    else {\\n        preexpansionBoundingRect = null;\\n        window.removeEventListener(\\"keydown\\", handleKeydown);\\n    }\\n}\\nconst get_dimension = (dimension_value) => {\\n    if (dimension_value === void 0) {\\n        return void 0;\\n    }\\n    if (typeof dimension_value === \\"number\\") {\\n        return dimension_value + \\"px\\";\\n    }\\n    else if (typeof dimension_value === \\"string\\") {\\n        return dimension_value;\\n    }\\n};\\n$: if (!visible) {\\n    flex = false;\\n}\\nconst resize = (e) => {\\n    let prevY = e.clientY;\\n    const onMouseMove = (e2) => {\\n        const dy = e2.clientY - prevY;\\n        prevY = e2.clientY;\\n        element.style.height = `${element.offsetHeight + dy}px`;\\n    };\\n    const onMouseUp = () => {\\n        window.removeEventListener(\\"mousemove\\", onMouseMove);\\n        window.removeEventListener(\\"mouseup\\", onMouseUp);\\n    };\\n    window.addEventListener(\\"mousemove\\", onMouseMove);\\n    window.addEventListener(\\"mouseup\\", onMouseUp);\\n};\\n<\/script>\\n\\n<svelte:element\\n\\tthis={tag}\\n\\tbind:this={element}\\n\\tdata-testid={test_id}\\n\\tid={elem_id}\\n\\tclass:hidden={visible === false}\\n\\tclass=\\"block {elem_classes?.join(\' \') || \'\'}\\"\\n\\tclass:padded={padding}\\n\\tclass:flex\\n\\tclass:border_focus={border_mode === \\"focus\\"}\\n\\tclass:border_contrast={border_mode === \\"contrast\\"}\\n\\tclass:hide-container={!explicit_call && !container}\\n\\tstyle:height={fullscreen ? undefined : get_dimension(height)}\\n\\tstyle:min-height={fullscreen ? undefined : get_dimension(min_height)}\\n\\tstyle:max-height={fullscreen ? undefined : get_dimension(max_height)}\\n\\tclass:fullscreen\\n\\tclass:animating={fullscreen && preexpansionBoundingRect !== null}\\n\\tstyle:--start-top={preexpansionBoundingRect\\n\\t\\t? `${preexpansionBoundingRect.top}px`\\n\\t\\t: \\"0px\\"}\\n\\tstyle:--start-left={preexpansionBoundingRect\\n\\t\\t? `${preexpansionBoundingRect.left}px`\\n\\t\\t: \\"0px\\"}\\n\\tstyle:--start-width={preexpansionBoundingRect\\n\\t\\t? `${preexpansionBoundingRect.width}px`\\n\\t\\t: \\"0px\\"}\\n\\tstyle:--start-height={preexpansionBoundingRect\\n\\t\\t? `${preexpansionBoundingRect.height}px`\\n\\t\\t: \\"0px\\"}\\n\\tstyle:width={fullscreen\\n\\t\\t? undefined\\n\\t\\t: typeof width === \\"number\\"\\n\\t\\t\\t? `calc(min(${width}px, 100%))`\\n\\t\\t\\t: get_dimension(width)}\\n\\tstyle:border-style={variant}\\n\\tstyle:overflow={allow_overflow ? overflow_behavior : \\"hidden\\"}\\n\\tstyle:flex-grow={scale}\\n\\tstyle:min-width={`calc(min(${min_width}px, 100%))`}\\n\\tstyle:border-width=\\"var(--block-border-width)\\"\\n\\tclass:auto-margin={scale === null}\\n\\tdir={rtl ? \\"rtl\\" : \\"ltr\\"}\\n>\\n\\t<slot />\\n\\t{#if resizable}\\n\\t\\t<!-- svelte-ignore a11y-no-static-element-interactions -->\\n\\t\\t<svg\\n\\t\\t\\tclass=\\"resize-handle\\"\\n\\t\\t\\txmlns=\\"http://www.w3.org/2000/svg\\"\\n\\t\\t\\tviewBox=\\"0 0 10 10\\"\\n\\t\\t\\ton:mousedown={resize}\\n\\t\\t>\\n\\t\\t\\t<line x1=\\"1\\" y1=\\"9\\" x2=\\"9\\" y2=\\"1\\" stroke=\\"gray\\" stroke-width=\\"0.5\\" />\\n\\t\\t\\t<line x1=\\"5\\" y1=\\"9\\" x2=\\"9\\" y2=\\"5\\" stroke=\\"gray\\" stroke-width=\\"0.5\\" />\\n\\t\\t</svg>\\n\\t{/if}\\n</svelte:element>\\n{#if fullscreen}\\n\\t<div\\n\\t\\tclass=\\"placeholder\\"\\n\\t\\tstyle:height={placeholder_height + \\"px\\"}\\n\\t\\tstyle:width={placeholder_width + \\"px\\"}\\n\\t></div>\\n{/if}\\n\\n<style>\\n\\t.block {\\n\\t\\tposition: relative;\\n\\t\\tmargin: 0;\\n\\t\\tbox-shadow: var(--block-shadow);\\n\\t\\tborder-width: var(--block-border-width);\\n\\t\\tborder-color: var(--block-border-color);\\n\\t\\tborder-radius: var(--block-radius);\\n\\t\\tbackground: var(--block-background-fill);\\n\\t\\twidth: 100%;\\n\\t\\tline-height: var(--line-sm);\\n\\t}\\n\\t.block.fullscreen {\\n\\t\\tborder-radius: 0;\\n\\t}\\n\\n\\t.auto-margin {\\n\\t\\tmargin-left: auto;\\n\\t\\tmargin-right: auto;\\n\\t}\\n\\n\\t.block.border_focus {\\n\\t\\tborder-color: var(--color-accent);\\n\\t}\\n\\n\\t.block.border_contrast {\\n\\t\\tborder-color: var(--body-text-color);\\n\\t}\\n\\n\\t.padded {\\n\\t\\tpadding: var(--block-padding);\\n\\t}\\n\\n\\t.hidden {\\n\\t\\tdisplay: none;\\n\\t}\\n\\n\\t.flex {\\n\\t\\tdisplay: flex;\\n\\t\\tflex-direction: column;\\n\\t}\\n\\t.hide-container:not(.fullscreen) {\\n\\t\\tmargin: 0;\\n\\t\\tbox-shadow: none;\\n\\t\\t--block-border-width: 0;\\n\\t\\tbackground: transparent;\\n\\t\\tpadding: 0;\\n\\t\\toverflow: visible;\\n\\t}\\n\\t.resize-handle {\\n\\t\\tposition: absolute;\\n\\t\\tbottom: 0;\\n\\t\\tright: 0;\\n\\t\\twidth: 10px;\\n\\t\\theight: 10px;\\n\\t\\tfill: var(--block-border-color);\\n\\t\\tcursor: nwse-resize;\\n\\t}\\n\\t.fullscreen {\\n\\t\\tposition: fixed;\\n\\t\\ttop: 0;\\n\\t\\tleft: 0;\\n\\t\\twidth: 100vw;\\n\\t\\theight: 100vh;\\n\\t\\tz-index: 1000;\\n\\t\\toverflow: auto;\\n\\t}\\n\\n\\t.animating {\\n\\t\\tanimation: pop-out 0.1s ease-out forwards;\\n\\t}\\n\\n\\t@keyframes pop-out {\\n\\t\\t0% {\\n\\t\\t\\tposition: fixed;\\n\\t\\t\\ttop: var(--start-top);\\n\\t\\t\\tleft: var(--start-left);\\n\\t\\t\\twidth: var(--start-width);\\n\\t\\t\\theight: var(--start-height);\\n\\t\\t\\tz-index: 100;\\n\\t\\t}\\n\\t\\t100% {\\n\\t\\t\\tposition: fixed;\\n\\t\\t\\ttop: 0vh;\\n\\t\\t\\tleft: 0vw;\\n\\t\\t\\twidth: 100vw;\\n\\t\\t\\theight: 100vh;\\n\\t\\t\\tz-index: 1000;\\n\\t\\t}\\n\\t}\\n\\n\\t.placeholder {\\n\\t\\tborder-radius: var(--block-radius);\\n\\t\\tborder-width: var(--block-border-width);\\n\\t\\tborder-color: var(--block-border-color);\\n\\t\\tborder-style: dashed;\\n\\t}</style>\\n"],"names":[],"mappings":"AA6IC,qBAAO,CACN,QAAQ,CAAE,QAAQ,CAClB,MAAM,CAAE,CAAC,CACT,UAAU,CAAE,IAAI,cAAc,CAAC,CAC/B,YAAY,CAAE,IAAI,oBAAoB,CAAC,CACvC,YAAY,CAAE,IAAI,oBAAoB,CAAC,CACvC,aAAa,CAAE,IAAI,cAAc,CAAC,CAClC,UAAU,CAAE,IAAI,uBAAuB,CAAC,CACxC,KAAK,CAAE,IAAI,CACX,WAAW,CAAE,IAAI,SAAS,CAC3B,CACA,MAAM,0BAAY,CACjB,aAAa,CAAE,CAChB,CAEA,2BAAa,CACZ,WAAW,CAAE,IAAI,CACjB,YAAY,CAAE,IACf,CAEA,MAAM,4BAAc,CACnB,YAAY,CAAE,IAAI,cAAc,CACjC,CAEA,MAAM,+BAAiB,CACtB,YAAY,CAAE,IAAI,iBAAiB,CACpC,CAEA,sBAAQ,CACP,OAAO,CAAE,IAAI,eAAe,CAC7B,CAEA,sBAAQ,CACP,OAAO,CAAE,IACV,CAEA,oBAAM,CACL,OAAO,CAAE,IAAI,CACb,cAAc,CAAE,MACjB,CACA,8BAAe,KAAK,WAAW,CAAE,CAChC,MAAM,CAAE,CAAC,CACT,UAAU,CAAE,IAAI,CAChB,oBAAoB,CAAE,CAAC,CACvB,UAAU,CAAE,WAAW,CACvB,OAAO,CAAE,CAAC,CACV,QAAQ,CAAE,OACX,CACA,6BAAe,CACd,QAAQ,CAAE,QAAQ,CAClB,MAAM,CAAE,CAAC,CACT,KAAK,CAAE,CAAC,CACR,KAAK,CAAE,IAAI,CACX,MAAM,CAAE,IAAI,CACZ,IAAI,CAAE,IAAI,oBAAoB,CAAC,CAC/B,MAAM,CAAE,WACT,CACA,0BAAY,CACX,QAAQ,CAAE,KAAK,CACf,GAAG,CAAE,CAAC,CACN,IAAI,CAAE,CAAC,CACP,KAAK,CAAE,KAAK,CACZ,MAAM,CAAE,KAAK,CACb,OAAO,CAAE,IAAI,CACb,QAAQ,CAAE,IACX,CAEA,yBAAW,CACV,SAAS,CAAE,sBAAO,CAAC,IAAI,CAAC,QAAQ,CAAC,QAClC,CAEA,WAAW,sBAAQ,CAClB,EAAG,CACF,QAAQ,CAAE,KAAK,CACf,GAAG,CAAE,IAAI,WAAW,CAAC,CACrB,IAAI,CAAE,IAAI,YAAY,CAAC,CACvB,KAAK,CAAE,IAAI,aAAa,CAAC,CACzB,MAAM,CAAE,IAAI,cAAc,CAAC,CAC3B,OAAO,CAAE,GACV,CACA,IAAK,CACJ,QAAQ,CAAE,KAAK,CACf,GAAG,CAAE,GAAG,CACR,IAAI,CAAE,GAAG,CACT,KAAK,CAAE,KAAK,CACZ,MAAM,CAAE,KAAK,CACb,OAAO,CAAE,IACV,CACD,CAEA,2BAAa,CACZ,aAAa,CAAE,IAAI,cAAc,CAAC,CAClC,YAAY,CAAE,IAAI,oBAAoB,CAAC,CACvC,YAAY,CAAE,IAAI,oBAAoB,CAAC,CACvC,YAAY,CAAE,MACf"}'
};
const Block = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { height = void 0 } = $$props;
  let { min_height = void 0 } = $$props;
  let { max_height = void 0 } = $$props;
  let { width = void 0 } = $$props;
  let { elem_id = "" } = $$props;
  let { elem_classes = [] } = $$props;
  let { variant = "solid" } = $$props;
  let { border_mode = "base" } = $$props;
  let { padding = true } = $$props;
  let { type = "normal" } = $$props;
  let { test_id = void 0 } = $$props;
  let { explicit_call = false } = $$props;
  let { container = true } = $$props;
  let { visible = true } = $$props;
  let { allow_overflow = true } = $$props;
  let { overflow_behavior = "auto" } = $$props;
  let { scale = null } = $$props;
  let { min_width = 0 } = $$props;
  let { flex = false } = $$props;
  let { resizable = false } = $$props;
  let { rtl = false } = $$props;
  let { fullscreen = false } = $$props;
  let old_fullscreen = fullscreen;
  let element;
  let tag2 = type === "fieldset" ? "fieldset" : "div";
  let placeholder_height = 0;
  let placeholder_width = 0;
  let preexpansionBoundingRect = null;
  function handleKeydown(event) {
    if (fullscreen && event.key === "Escape") {
      fullscreen = false;
    }
  }
  const get_dimension = (dimension_value) => {
    if (dimension_value === void 0) {
      return void 0;
    }
    if (typeof dimension_value === "number") {
      return dimension_value + "px";
    } else if (typeof dimension_value === "string") {
      return dimension_value;
    }
  };
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.min_height === void 0 && $$bindings.min_height && min_height !== void 0)
    $$bindings.min_height(min_height);
  if ($$props.max_height === void 0 && $$bindings.max_height && max_height !== void 0)
    $$bindings.max_height(max_height);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.elem_id === void 0 && $$bindings.elem_id && elem_id !== void 0)
    $$bindings.elem_id(elem_id);
  if ($$props.elem_classes === void 0 && $$bindings.elem_classes && elem_classes !== void 0)
    $$bindings.elem_classes(elem_classes);
  if ($$props.variant === void 0 && $$bindings.variant && variant !== void 0)
    $$bindings.variant(variant);
  if ($$props.border_mode === void 0 && $$bindings.border_mode && border_mode !== void 0)
    $$bindings.border_mode(border_mode);
  if ($$props.padding === void 0 && $$bindings.padding && padding !== void 0)
    $$bindings.padding(padding);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0)
    $$bindings.type(type);
  if ($$props.test_id === void 0 && $$bindings.test_id && test_id !== void 0)
    $$bindings.test_id(test_id);
  if ($$props.explicit_call === void 0 && $$bindings.explicit_call && explicit_call !== void 0)
    $$bindings.explicit_call(explicit_call);
  if ($$props.container === void 0 && $$bindings.container && container !== void 0)
    $$bindings.container(container);
  if ($$props.visible === void 0 && $$bindings.visible && visible !== void 0)
    $$bindings.visible(visible);
  if ($$props.allow_overflow === void 0 && $$bindings.allow_overflow && allow_overflow !== void 0)
    $$bindings.allow_overflow(allow_overflow);
  if ($$props.overflow_behavior === void 0 && $$bindings.overflow_behavior && overflow_behavior !== void 0)
    $$bindings.overflow_behavior(overflow_behavior);
  if ($$props.scale === void 0 && $$bindings.scale && scale !== void 0)
    $$bindings.scale(scale);
  if ($$props.min_width === void 0 && $$bindings.min_width && min_width !== void 0)
    $$bindings.min_width(min_width);
  if ($$props.flex === void 0 && $$bindings.flex && flex !== void 0)
    $$bindings.flex(flex);
  if ($$props.resizable === void 0 && $$bindings.resizable && resizable !== void 0)
    $$bindings.resizable(resizable);
  if ($$props.rtl === void 0 && $$bindings.rtl && rtl !== void 0)
    $$bindings.rtl(rtl);
  if ($$props.fullscreen === void 0 && $$bindings.fullscreen && fullscreen !== void 0)
    $$bindings.fullscreen(fullscreen);
  $$result.css.add(css$h$1);
  {
    if (fullscreen !== old_fullscreen) {
      old_fullscreen = fullscreen;
      if (fullscreen) {
        preexpansionBoundingRect = element.getBoundingClientRect();
        placeholder_height = element.offsetHeight;
        placeholder_width = element.offsetWidth;
        window.addEventListener("keydown", handleKeydown);
      } else {
        preexpansionBoundingRect = null;
        window.removeEventListener("keydown", handleKeydown);
      }
    }
  }
  {
    if (!visible) {
      flex = false;
    }
  }
  return `${((tag$1) => {
    return tag$1 ? `<${tag2}${add_attribute("data-testid", test_id, 0)}${add_attribute("id", elem_id, 0)} class="${[
      "block " + escape$4(elem_classes?.join(" ") || "", true) + " svelte-1svsvh2",
      (visible === false ? "hidden" : "") + " " + (padding ? "padded" : "") + " " + (flex ? "flex" : "") + " " + (border_mode === "focus" ? "border_focus" : "") + " " + (border_mode === "contrast" ? "border_contrast" : "") + " " + (!explicit_call && !container ? "hide-container" : "") + " " + (fullscreen ? "fullscreen" : "") + " " + (fullscreen && preexpansionBoundingRect !== null ? "animating" : "") + " " + (scale === null ? "auto-margin" : "")
    ].join(" ").trim()}"${add_attribute("dir", rtl ? "rtl" : "ltr", 0)}${add_styles({
      "height": fullscreen ? void 0 : get_dimension(height),
      "min-height": fullscreen ? void 0 : get_dimension(min_height),
      "max-height": fullscreen ? void 0 : get_dimension(max_height),
      "--start-top": preexpansionBoundingRect ? `${preexpansionBoundingRect.top}px` : "0px",
      "--start-left": preexpansionBoundingRect ? `${preexpansionBoundingRect.left}px` : "0px",
      "--start-width": preexpansionBoundingRect ? `${preexpansionBoundingRect.width}px` : "0px",
      "--start-height": preexpansionBoundingRect ? `${preexpansionBoundingRect.height}px` : "0px",
      "width": fullscreen ? void 0 : typeof width === "number" ? `calc(min(${width}px, 100%))` : get_dimension(width),
      "border-style": variant,
      "overflow": allow_overflow ? overflow_behavior : "hidden",
      "flex-grow": scale,
      "min-width": `calc(min(${min_width}px, 100%))`,
      "border-width": `var(--block-border-width)`
    })}${add_attribute("this", element, 0)}>${is_void(tag$1) ? "" : `${slots.default ? slots.default({}) : ``} ${resizable ? ` <svg class="resize-handle svelte-1svsvh2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 10"><line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="0.5"></line><line x1="5" y1="9" x2="9" y2="5" stroke="gray" stroke-width="0.5"></line></svg>` : ``}`}${is_void(tag$1) ? "" : `</${tag$1}>`}` : "";
  })(tag2)} ${fullscreen ? `<div class="placeholder svelte-1svsvh2"${add_styles({
    "height": placeholder_height + "px",
    "width": placeholder_width + "px"
  })}></div>` : ``}`;
});
class SourceLocation {
  // The + prefix indicates that these fields aren't writeable
  // Lexer holding the input string.
  // Start offset, zero-based inclusive.
  // End offset, zero-based exclusive.
  constructor(lexer, start, end) {
    this.lexer = void 0;
    this.start = void 0;
    this.end = void 0;
    this.lexer = lexer;
    this.start = start;
    this.end = end;
  }
  /**
   * Merges two `SourceLocation`s from location providers, given they are
   * provided in order of appearance.
   * - Returns the first one's location if only the first is provided.
   * - Returns a merged range of the first and the last if both are provided
   *   and their lexers match.
   * - Otherwise, returns null.
   */
  static range(first, second) {
    if (!second) {
      return first && first.loc;
    } else if (!first || !first.loc || !second.loc || first.loc.lexer !== second.loc.lexer) {
      return null;
    } else {
      return new SourceLocation(first.loc.lexer, first.loc.start, second.loc.end);
    }
  }
}
class Token {
  // don't expand the token
  // used in \noexpand
  constructor(text2, loc) {
    this.text = void 0;
    this.loc = void 0;
    this.noexpand = void 0;
    this.treatAsRelax = void 0;
    this.text = text2;
    this.loc = loc;
  }
  /**
   * Given a pair of tokens (this and endToken), compute a `Token` encompassing
   * the whole input range enclosed by these two.
   */
  range(endToken, text2) {
    return new Token(text2, SourceLocation.range(this, endToken));
  }
}
class ParseError {
  // Error start position based on passed-in Token or ParseNode.
  // Length of affected text based on passed-in Token or ParseNode.
  // The underlying error message without any context added.
  constructor(message, token) {
    this.name = void 0;
    this.position = void 0;
    this.length = void 0;
    this.rawMessage = void 0;
    var error = "KaTeX parse error: " + message;
    var start;
    var end;
    var loc = token && token.loc;
    if (loc && loc.start <= loc.end) {
      var input = loc.lexer.input;
      start = loc.start;
      end = loc.end;
      if (start === input.length) {
        error += " at end of input: ";
      } else {
        error += " at position " + (start + 1) + ": ";
      }
      var underlined = input.slice(start, end).replace(/[^]/g, "$&̲");
      var left;
      if (start > 15) {
        left = "…" + input.slice(start - 15, start);
      } else {
        left = input.slice(0, start);
      }
      var right;
      if (end + 15 < input.length) {
        right = input.slice(end, end + 15) + "…";
      } else {
        right = input.slice(end);
      }
      error += left + underlined + right;
    }
    var self2 = new Error(error);
    self2.name = "ParseError";
    self2.__proto__ = ParseError.prototype;
    self2.position = start;
    if (start != null && end != null) {
      self2.length = end - start;
    }
    self2.rawMessage = message;
    return self2;
  }
}
ParseError.prototype.__proto__ = Error.prototype;
var contains = function contains2(list2, elem) {
  return list2.indexOf(elem) !== -1;
};
var deflt = function deflt2(setting, defaultIfUndefined) {
  return setting === void 0 ? defaultIfUndefined : setting;
};
var uppercase = /([A-Z])/g;
var hyphenate = function hyphenate2(str) {
  return str.replace(uppercase, "-$1").toLowerCase();
};
var ESCAPE_LOOKUP = {
  "&": "&amp;",
  ">": "&gt;",
  "<": "&lt;",
  '"': "&quot;",
  "'": "&#x27;"
};
var ESCAPE_REGEX = /[&><"']/g;
function escape$3(text2) {
  return String(text2).replace(ESCAPE_REGEX, (match) => ESCAPE_LOOKUP[match]);
}
var getBaseElem = function getBaseElem2(group) {
  if (group.type === "ordgroup") {
    if (group.body.length === 1) {
      return getBaseElem2(group.body[0]);
    } else {
      return group;
    }
  } else if (group.type === "color") {
    if (group.body.length === 1) {
      return getBaseElem2(group.body[0]);
    } else {
      return group;
    }
  } else if (group.type === "font") {
    return getBaseElem2(group.body);
  } else {
    return group;
  }
};
var isCharacterBox = function isCharacterBox2(group) {
  var baseElem = getBaseElem(group);
  return baseElem.type === "mathord" || baseElem.type === "textord" || baseElem.type === "atom";
};
var assert = function assert2(value) {
  if (!value) {
    throw new Error("Expected non-null, but got " + String(value));
  }
  return value;
};
var protocolFromUrl = function protocolFromUrl2(url) {
  var protocol = /^[\x00-\x20]*([^\\/#?]*?)(:|&#0*58|&#x0*3a|&colon)/i.exec(url);
  if (!protocol) {
    return "_relative";
  }
  if (protocol[2] !== ":") {
    return null;
  }
  if (!/^[a-zA-Z][a-zA-Z0-9+\-.]*$/.test(protocol[1])) {
    return null;
  }
  return protocol[1].toLowerCase();
};
var utils = {
  contains,
  deflt,
  escape: escape$3,
  hyphenate,
  getBaseElem,
  isCharacterBox,
  protocolFromUrl
};
class Style {
  constructor(id, size, cramped) {
    this.id = void 0;
    this.size = void 0;
    this.cramped = void 0;
    this.id = id;
    this.size = size;
    this.cramped = cramped;
  }
  /**
   * Get the style of a superscript given a base in the current style.
   */
  sup() {
    return styles[sup[this.id]];
  }
  /**
   * Get the style of a subscript given a base in the current style.
   */
  sub() {
    return styles[sub[this.id]];
  }
  /**
   * Get the style of a fraction numerator given the fraction in the current
   * style.
   */
  fracNum() {
    return styles[fracNum[this.id]];
  }
  /**
   * Get the style of a fraction denominator given the fraction in the current
   * style.
   */
  fracDen() {
    return styles[fracDen[this.id]];
  }
  /**
   * Get the cramped version of a style (in particular, cramping a cramped style
   * doesn't change the style).
   */
  cramp() {
    return styles[cramp[this.id]];
  }
  /**
   * Get a text or display version of this style.
   */
  text() {
    return styles[text$1[this.id]];
  }
  /**
   * Return true if this style is tightly spaced (scriptstyle/scriptscriptstyle)
   */
  isTight() {
    return this.size >= 2;
  }
}
var D = 0;
var Dc = 1;
var T = 2;
var Tc = 3;
var S = 4;
var Sc = 5;
var SS = 6;
var SSc = 7;
var styles = [new Style(D, 0, false), new Style(Dc, 0, true), new Style(T, 1, false), new Style(Tc, 1, true), new Style(S, 2, false), new Style(Sc, 2, true), new Style(SS, 3, false), new Style(SSc, 3, true)];
var sup = [S, Sc, S, Sc, SS, SSc, SS, SSc];
var sub = [Sc, Sc, Sc, Sc, SSc, SSc, SSc, SSc];
var fracNum = [T, Tc, S, Sc, SS, SSc, SS, SSc];
var fracDen = [Tc, Tc, Sc, Sc, SSc, SSc, SSc, SSc];
var cramp = [Dc, Dc, Tc, Tc, Sc, Sc, SSc, SSc];
var text$1 = [D, Dc, T, Tc, T, Tc, T, Tc];
var Style$1 = {
  DISPLAY: styles[D],
  TEXT: styles[T],
  SCRIPT: styles[S],
  SCRIPTSCRIPT: styles[SS]
};
var scriptData = [{
  // Latin characters beyond the Latin-1 characters we have metrics for.
  // Needed for Czech, Hungarian and Turkish text, for example.
  name: "latin",
  blocks: [
    [256, 591],
    // Latin Extended-A and Latin Extended-B
    [768, 879]
    // Combining Diacritical marks
  ]
}, {
  // The Cyrillic script used by Russian and related languages.
  // A Cyrillic subset used to be supported as explicitly defined
  // symbols in symbols.js
  name: "cyrillic",
  blocks: [[1024, 1279]]
}, {
  // Armenian
  name: "armenian",
  blocks: [[1328, 1423]]
}, {
  // The Brahmic scripts of South and Southeast Asia
  // Devanagari (0900–097F)
  // Bengali (0980–09FF)
  // Gurmukhi (0A00–0A7F)
  // Gujarati (0A80–0AFF)
  // Oriya (0B00–0B7F)
  // Tamil (0B80–0BFF)
  // Telugu (0C00–0C7F)
  // Kannada (0C80–0CFF)
  // Malayalam (0D00–0D7F)
  // Sinhala (0D80–0DFF)
  // Thai (0E00–0E7F)
  // Lao (0E80–0EFF)
  // Tibetan (0F00–0FFF)
  // Myanmar (1000–109F)
  name: "brahmic",
  blocks: [[2304, 4255]]
}, {
  name: "georgian",
  blocks: [[4256, 4351]]
}, {
  // Chinese and Japanese.
  // The "k" in cjk is for Korean, but we've separated Korean out
  name: "cjk",
  blocks: [
    [12288, 12543],
    // CJK symbols and punctuation, Hiragana, Katakana
    [19968, 40879],
    // CJK ideograms
    [65280, 65376]
    // Fullwidth punctuation
    // TODO: add halfwidth Katakana and Romanji glyphs
  ]
}, {
  // Korean
  name: "hangul",
  blocks: [[44032, 55215]]
}];
function scriptFromCodepoint(codepoint) {
  for (var i = 0; i < scriptData.length; i++) {
    var script = scriptData[i];
    for (var _i = 0; _i < script.blocks.length; _i++) {
      var block2 = script.blocks[_i];
      if (codepoint >= block2[0] && codepoint <= block2[1]) {
        return script.name;
      }
    }
  }
  return null;
}
var allBlocks = [];
scriptData.forEach((s) => s.blocks.forEach((b) => allBlocks.push(...b)));
function supportedCodepoint(codepoint) {
  for (var i = 0; i < allBlocks.length; i += 2) {
    if (codepoint >= allBlocks[i] && codepoint <= allBlocks[i + 1]) {
      return true;
    }
  }
  return false;
}
var hLinePad = 80;
var sqrtMain = function sqrtMain2(extraVinculum, hLinePad2) {
  return "M95," + (622 + extraVinculum + hLinePad2) + "\nc-2.7,0,-7.17,-2.7,-13.5,-8c-5.8,-5.3,-9.5,-10,-9.5,-14\nc0,-2,0.3,-3.3,1,-4c1.3,-2.7,23.83,-20.7,67.5,-54\nc44.2,-33.3,65.8,-50.3,66.5,-51c1.3,-1.3,3,-2,5,-2c4.7,0,8.7,3.3,12,10\ns173,378,173,378c0.7,0,35.3,-71,104,-213c68.7,-142,137.5,-285,206.5,-429\nc69,-144,104.5,-217.7,106.5,-221\nl" + extraVinculum / 2.075 + " -" + extraVinculum + "\nc5.3,-9.3,12,-14,20,-14\nH400000v" + (40 + extraVinculum) + "H845.2724\ns-225.272,467,-225.272,467s-235,486,-235,486c-2.7,4.7,-9,7,-19,7\nc-6,0,-10,-1,-12,-3s-194,-422,-194,-422s-65,47,-65,47z\nM" + (834 + extraVinculum) + " " + hLinePad2 + "h400000v" + (40 + extraVinculum) + "h-400000z";
};
var sqrtSize1 = function sqrtSize12(extraVinculum, hLinePad2) {
  return "M263," + (601 + extraVinculum + hLinePad2) + "c0.7,0,18,39.7,52,119\nc34,79.3,68.167,158.7,102.5,238c34.3,79.3,51.8,119.3,52.5,120\nc340,-704.7,510.7,-1060.3,512,-1067\nl" + extraVinculum / 2.084 + " -" + extraVinculum + "\nc4.7,-7.3,11,-11,19,-11\nH40000v" + (40 + extraVinculum) + "H1012.3\ns-271.3,567,-271.3,567c-38.7,80.7,-84,175,-136,283c-52,108,-89.167,185.3,-111.5,232\nc-22.3,46.7,-33.8,70.3,-34.5,71c-4.7,4.7,-12.3,7,-23,7s-12,-1,-12,-1\ns-109,-253,-109,-253c-72.7,-168,-109.3,-252,-110,-252c-10.7,8,-22,16.7,-34,26\nc-22,17.3,-33.3,26,-34,26s-26,-26,-26,-26s76,-59,76,-59s76,-60,76,-60z\nM" + (1001 + extraVinculum) + " " + hLinePad2 + "h400000v" + (40 + extraVinculum) + "h-400000z";
};
var sqrtSize2 = function sqrtSize22(extraVinculum, hLinePad2) {
  return "M983 " + (10 + extraVinculum + hLinePad2) + "\nl" + extraVinculum / 3.13 + " -" + extraVinculum + "\nc4,-6.7,10,-10,18,-10 H400000v" + (40 + extraVinculum) + "\nH1013.1s-83.4,268,-264.1,840c-180.7,572,-277,876.3,-289,913c-4.7,4.7,-12.7,7,-24,7\ns-12,0,-12,0c-1.3,-3.3,-3.7,-11.7,-7,-25c-35.3,-125.3,-106.7,-373.3,-214,-744\nc-10,12,-21,25,-33,39s-32,39,-32,39c-6,-5.3,-15,-14,-27,-26s25,-30,25,-30\nc26.7,-32.7,52,-63,76,-91s52,-60,52,-60s208,722,208,722\nc56,-175.3,126.3,-397.3,211,-666c84.7,-268.7,153.8,-488.2,207.5,-658.5\nc53.7,-170.3,84.5,-266.8,92.5,-289.5z\nM" + (1001 + extraVinculum) + " " + hLinePad2 + "h400000v" + (40 + extraVinculum) + "h-400000z";
};
var sqrtSize3 = function sqrtSize32(extraVinculum, hLinePad2) {
  return "M424," + (2398 + extraVinculum + hLinePad2) + "\nc-1.3,-0.7,-38.5,-172,-111.5,-514c-73,-342,-109.8,-513.3,-110.5,-514\nc0,-2,-10.7,14.3,-32,49c-4.7,7.3,-9.8,15.7,-15.5,25c-5.7,9.3,-9.8,16,-12.5,20\ns-5,7,-5,7c-4,-3.3,-8.3,-7.7,-13,-13s-13,-13,-13,-13s76,-122,76,-122s77,-121,77,-121\ns209,968,209,968c0,-2,84.7,-361.7,254,-1079c169.3,-717.3,254.7,-1077.7,256,-1081\nl" + extraVinculum / 4.223 + " -" + extraVinculum + "c4,-6.7,10,-10,18,-10 H400000\nv" + (40 + extraVinculum) + "H1014.6\ns-87.3,378.7,-272.6,1166c-185.3,787.3,-279.3,1182.3,-282,1185\nc-2,6,-10,9,-24,9\nc-8,0,-12,-0.7,-12,-2z M" + (1001 + extraVinculum) + " " + hLinePad2 + "\nh400000v" + (40 + extraVinculum) + "h-400000z";
};
var sqrtSize4 = function sqrtSize42(extraVinculum, hLinePad2) {
  return "M473," + (2713 + extraVinculum + hLinePad2) + "\nc339.3,-1799.3,509.3,-2700,510,-2702 l" + extraVinculum / 5.298 + " -" + extraVinculum + "\nc3.3,-7.3,9.3,-11,18,-11 H400000v" + (40 + extraVinculum) + "H1017.7\ns-90.5,478,-276.2,1466c-185.7,988,-279.5,1483,-281.5,1485c-2,6,-10,9,-24,9\nc-8,0,-12,-0.7,-12,-2c0,-1.3,-5.3,-32,-16,-92c-50.7,-293.3,-119.7,-693.3,-207,-1200\nc0,-1.3,-5.3,8.7,-16,30c-10.7,21.3,-21.3,42.7,-32,64s-16,33,-16,33s-26,-26,-26,-26\ns76,-153,76,-153s77,-151,77,-151c0.7,0.7,35.7,202,105,604c67.3,400.7,102,602.7,104,\n606zM" + (1001 + extraVinculum) + " " + hLinePad2 + "h400000v" + (40 + extraVinculum) + "H1017.7z";
};
var phasePath = function phasePath2(y) {
  var x = y / 2;
  return "M400000 " + y + " H0 L" + x + " 0 l65 45 L145 " + (y - 80) + " H400000z";
};
var sqrtTall = function sqrtTall2(extraVinculum, hLinePad2, viewBoxHeight) {
  var vertSegment = viewBoxHeight - 54 - hLinePad2 - extraVinculum;
  return "M702 " + (extraVinculum + hLinePad2) + "H400000" + (40 + extraVinculum) + "\nH742v" + vertSegment + "l-4 4-4 4c-.667.7 -2 1.5-4 2.5s-4.167 1.833-6.5 2.5-5.5 1-9.5 1\nh-12l-28-84c-16.667-52-96.667 -294.333-240-727l-212 -643 -85 170\nc-4-3.333-8.333-7.667-13 -13l-13-13l77-155 77-156c66 199.333 139 419.667\n219 661 l218 661zM702 " + hLinePad2 + "H400000v" + (40 + extraVinculum) + "H742z";
};
var sqrtPath = function sqrtPath2(size, extraVinculum, viewBoxHeight) {
  extraVinculum = 1e3 * extraVinculum;
  var path2 = "";
  switch (size) {
    case "sqrtMain":
      path2 = sqrtMain(extraVinculum, hLinePad);
      break;
    case "sqrtSize1":
      path2 = sqrtSize1(extraVinculum, hLinePad);
      break;
    case "sqrtSize2":
      path2 = sqrtSize2(extraVinculum, hLinePad);
      break;
    case "sqrtSize3":
      path2 = sqrtSize3(extraVinculum, hLinePad);
      break;
    case "sqrtSize4":
      path2 = sqrtSize4(extraVinculum, hLinePad);
      break;
    case "sqrtTall":
      path2 = sqrtTall(extraVinculum, hLinePad, viewBoxHeight);
  }
  return path2;
};
var innerPath = function innerPath2(name, height) {
  switch (name) {
    case "⎜":
      return "M291 0 H417 V" + height + " H291z M291 0 H417 V" + height + " H291z";
    case "∣":
      return "M145 0 H188 V" + height + " H145z M145 0 H188 V" + height + " H145z";
    case "∥":
      return "M145 0 H188 V" + height + " H145z M145 0 H188 V" + height + " H145z" + ("M367 0 H410 V" + height + " H367z M367 0 H410 V" + height + " H367z");
    case "⎟":
      return "M457 0 H583 V" + height + " H457z M457 0 H583 V" + height + " H457z";
    case "⎢":
      return "M319 0 H403 V" + height + " H319z M319 0 H403 V" + height + " H319z";
    case "⎥":
      return "M263 0 H347 V" + height + " H263z M263 0 H347 V" + height + " H263z";
    case "⎪":
      return "M384 0 H504 V" + height + " H384z M384 0 H504 V" + height + " H384z";
    case "⏐":
      return "M312 0 H355 V" + height + " H312z M312 0 H355 V" + height + " H312z";
    case "‖":
      return "M257 0 H300 V" + height + " H257z M257 0 H300 V" + height + " H257z" + ("M478 0 H521 V" + height + " H478z M478 0 H521 V" + height + " H478z");
    default:
      return "";
  }
};
var path = {
  // The doubleleftarrow geometry is from glyph U+21D0 in the font KaTeX Main
  doubleleftarrow: "M262 157\nl10-10c34-36 62.7-77 86-123 3.3-8 5-13.3 5-16 0-5.3-6.7-8-20-8-7.3\n 0-12.2.5-14.5 1.5-2.3 1-4.8 4.5-7.5 10.5-49.3 97.3-121.7 169.3-217 216-28\n 14-57.3 25-88 33-6.7 2-11 3.8-13 5.5-2 1.7-3 4.2-3 7.5s1 5.8 3 7.5\nc2 1.7 6.3 3.5 13 5.5 68 17.3 128.2 47.8 180.5 91.5 52.3 43.7 93.8 96.2 124.5\n 157.5 9.3 8 15.3 12.3 18 13h6c12-.7 18-4 18-10 0-2-1.7-7-5-15-23.3-46-52-87\n-86-123l-10-10h399738v-40H218c328 0 0 0 0 0l-10-8c-26.7-20-65.7-43-117-69 2.7\n-2 6-3.7 10-5 36.7-16 72.3-37.3 107-64l10-8h399782v-40z\nm8 0v40h399730v-40zm0 194v40h399730v-40z",
  // doublerightarrow is from glyph U+21D2 in font KaTeX Main
  doublerightarrow: "M399738 392l\n-10 10c-34 36-62.7 77-86 123-3.3 8-5 13.3-5 16 0 5.3 6.7 8 20 8 7.3 0 12.2-.5\n 14.5-1.5 2.3-1 4.8-4.5 7.5-10.5 49.3-97.3 121.7-169.3 217-216 28-14 57.3-25 88\n-33 6.7-2 11-3.8 13-5.5 2-1.7 3-4.2 3-7.5s-1-5.8-3-7.5c-2-1.7-6.3-3.5-13-5.5-68\n-17.3-128.2-47.8-180.5-91.5-52.3-43.7-93.8-96.2-124.5-157.5-9.3-8-15.3-12.3-18\n-13h-6c-12 .7-18 4-18 10 0 2 1.7 7 5 15 23.3 46 52 87 86 123l10 10H0v40h399782\nc-328 0 0 0 0 0l10 8c26.7 20 65.7 43 117 69-2.7 2-6 3.7-10 5-36.7 16-72.3 37.3\n-107 64l-10 8H0v40zM0 157v40h399730v-40zm0 194v40h399730v-40z",
  // leftarrow is from glyph U+2190 in font KaTeX Main
  leftarrow: "M400000 241H110l3-3c68.7-52.7 113.7-120\n 135-202 4-14.7 6-23 6-25 0-7.3-7-11-21-11-8 0-13.2.8-15.5 2.5-2.3 1.7-4.2 5.8\n-5.5 12.5-1.3 4.7-2.7 10.3-4 17-12 48.7-34.8 92-68.5 130S65.3 228.3 18 247\nc-10 4-16 7.7-18 11 0 8.7 6 14.3 18 17 47.3 18.7 87.8 47 121.5 85S196 441.3 208\n 490c.7 2 1.3 5 2 9s1.2 6.7 1.5 8c.3 1.3 1 3.3 2 6s2.2 4.5 3.5 5.5c1.3 1 3.3\n 1.8 6 2.5s6 1 10 1c14 0 21-3.7 21-11 0-2-2-10.3-6-25-20-79.3-65-146.7-135-202\n l-3-3h399890zM100 241v40h399900v-40z",
  // overbrace is from glyphs U+23A9/23A8/23A7 in font KaTeX_Size4-Regular
  leftbrace: "M6 548l-6-6v-35l6-11c56-104 135.3-181.3 238-232 57.3-28.7 117\n-45 179-50h399577v120H403c-43.3 7-81 15-113 26-100.7 33-179.7 91-237 174-2.7\n 5-6 9-10 13-.7 1-7.3 1-20 1H6z",
  leftbraceunder: "M0 6l6-6h17c12.688 0 19.313.3 20 1 4 4 7.313 8.3 10 13\n 35.313 51.3 80.813 93.8 136.5 127.5 55.688 33.7 117.188 55.8 184.5 66.5.688\n 0 2 .3 4 1 18.688 2.7 76 4.3 172 5h399450v120H429l-6-1c-124.688-8-235-61.7\n-331-161C60.687 138.7 32.312 99.3 7 54L0 41V6z",
  // overgroup is from the MnSymbol package (public domain)
  leftgroup: "M400000 80\nH435C64 80 168.3 229.4 21 260c-5.9 1.2-18 0-18 0-2 0-3-1-3-3v-38C76 61 257 0\n 435 0h399565z",
  leftgroupunder: "M400000 262\nH435C64 262 168.3 112.6 21 82c-5.9-1.2-18 0-18 0-2 0-3 1-3 3v38c76 158 257 219\n 435 219h399565z",
  // Harpoons are from glyph U+21BD in font KaTeX Main
  leftharpoon: "M0 267c.7 5.3 3 10 7 14h399993v-40H93c3.3\n-3.3 10.2-9.5 20.5-18.5s17.8-15.8 22.5-20.5c50.7-52 88-110.3 112-175 4-11.3 5\n-18.3 3-21-1.3-4-7.3-6-18-6-8 0-13 .7-15 2s-4.7 6.7-8 16c-42 98.7-107.3 174.7\n-196 228-6.7 4.7-10.7 8-12 10-1.3 2-2 5.7-2 11zm100-26v40h399900v-40z",
  leftharpoonplus: "M0 267c.7 5.3 3 10 7 14h399993v-40H93c3.3-3.3 10.2-9.5\n 20.5-18.5s17.8-15.8 22.5-20.5c50.7-52 88-110.3 112-175 4-11.3 5-18.3 3-21-1.3\n-4-7.3-6-18-6-8 0-13 .7-15 2s-4.7 6.7-8 16c-42 98.7-107.3 174.7-196 228-6.7 4.7\n-10.7 8-12 10-1.3 2-2 5.7-2 11zm100-26v40h399900v-40zM0 435v40h400000v-40z\nm0 0v40h400000v-40z",
  leftharpoondown: "M7 241c-4 4-6.333 8.667-7 14 0 5.333.667 9 2 11s5.333\n 5.333 12 10c90.667 54 156 130 196 228 3.333 10.667 6.333 16.333 9 17 2 .667 5\n 1 9 1h5c10.667 0 16.667-2 18-6 2-2.667 1-9.667-3-21-32-87.333-82.667-157.667\n-152-211l-3-3h399907v-40zM93 281 H400000 v-40L7 241z",
  leftharpoondownplus: "M7 435c-4 4-6.3 8.7-7 14 0 5.3.7 9 2 11s5.3 5.3 12\n 10c90.7 54 156 130 196 228 3.3 10.7 6.3 16.3 9 17 2 .7 5 1 9 1h5c10.7 0 16.7\n-2 18-6 2-2.7 1-9.7-3-21-32-87.3-82.7-157.7-152-211l-3-3h399907v-40H7zm93 0\nv40h399900v-40zM0 241v40h399900v-40zm0 0v40h399900v-40z",
  // hook is from glyph U+21A9 in font KaTeX Main
  lefthook: "M400000 281 H103s-33-11.2-61-33.5S0 197.3 0 164s14.2-61.2 42.5\n-83.5C70.8 58.2 104 47 142 47 c16.7 0 25 6.7 25 20 0 12-8.7 18.7-26 20-40 3.3\n-68.7 15.7-86 37-10 12-15 25.3-15 40 0 22.7 9.8 40.7 29.5 54 19.7 13.3 43.5 21\n 71.5 23h399859zM103 281v-40h399897v40z",
  leftlinesegment: "M40 281 V428 H0 V94 H40 V241 H400000 v40z\nM40 281 V428 H0 V94 H40 V241 H400000 v40z",
  leftmapsto: "M40 281 V448H0V74H40V241H400000v40z\nM40 281 V448H0V74H40V241H400000v40z",
  // tofrom is from glyph U+21C4 in font KaTeX AMS Regular
  leftToFrom: "M0 147h400000v40H0zm0 214c68 40 115.7 95.7 143 167h22c15.3 0 23\n-.3 23-1 0-1.3-5.3-13.7-16-37-18-35.3-41.3-69-70-101l-7-8h399905v-40H95l7-8\nc28.7-32 52-65.7 70-101 10.7-23.3 16-35.7 16-37 0-.7-7.7-1-23-1h-22C115.7 265.3\n 68 321 0 361zm0-174v-40h399900v40zm100 154v40h399900v-40z",
  longequal: "M0 50 h400000 v40H0z m0 194h40000v40H0z\nM0 50 h400000 v40H0z m0 194h40000v40H0z",
  midbrace: "M200428 334\nc-100.7-8.3-195.3-44-280-108-55.3-42-101.7-93-139-153l-9-14c-2.7 4-5.7 8.7-9 14\n-53.3 86.7-123.7 153-211 199-66.7 36-137.3 56.3-212 62H0V214h199568c178.3-11.7\n 311.7-78.3 403-201 6-8 9.7-12 11-12 .7-.7 6.7-1 18-1s17.3.3 18 1c1.3 0 5 4 11\n 12 44.7 59.3 101.3 106.3 170 141s145.3 54.3 229 60h199572v120z",
  midbraceunder: "M199572 214\nc100.7 8.3 195.3 44 280 108 55.3 42 101.7 93 139 153l9 14c2.7-4 5.7-8.7 9-14\n 53.3-86.7 123.7-153 211-199 66.7-36 137.3-56.3 212-62h199568v120H200432c-178.3\n 11.7-311.7 78.3-403 201-6 8-9.7 12-11 12-.7.7-6.7 1-18 1s-17.3-.3-18-1c-1.3 0\n-5-4-11-12-44.7-59.3-101.3-106.3-170-141s-145.3-54.3-229-60H0V214z",
  oiintSize1: "M512.6 71.6c272.6 0 320.3 106.8 320.3 178.2 0 70.8-47.7 177.6\n-320.3 177.6S193.1 320.6 193.1 249.8c0-71.4 46.9-178.2 319.5-178.2z\nm368.1 178.2c0-86.4-60.9-215.4-368.1-215.4-306.4 0-367.3 129-367.3 215.4 0 85.8\n60.9 214.8 367.3 214.8 307.2 0 368.1-129 368.1-214.8z",
  oiintSize2: "M757.8 100.1c384.7 0 451.1 137.6 451.1 230 0 91.3-66.4 228.8\n-451.1 228.8-386.3 0-452.7-137.5-452.7-228.8 0-92.4 66.4-230 452.7-230z\nm502.4 230c0-111.2-82.4-277.2-502.4-277.2s-504 166-504 277.2\nc0 110 84 276 504 276s502.4-166 502.4-276z",
  oiiintSize1: "M681.4 71.6c408.9 0 480.5 106.8 480.5 178.2 0 70.8-71.6 177.6\n-480.5 177.6S202.1 320.6 202.1 249.8c0-71.4 70.5-178.2 479.3-178.2z\nm525.8 178.2c0-86.4-86.8-215.4-525.7-215.4-437.9 0-524.7 129-524.7 215.4 0\n85.8 86.8 214.8 524.7 214.8 438.9 0 525.7-129 525.7-214.8z",
  oiiintSize2: "M1021.2 53c603.6 0 707.8 165.8 707.8 277.2 0 110-104.2 275.8\n-707.8 275.8-606 0-710.2-165.8-710.2-275.8C311 218.8 415.2 53 1021.2 53z\nm770.4 277.1c0-131.2-126.4-327.6-770.5-327.6S248.4 198.9 248.4 330.1\nc0 130 128.8 326.4 772.7 326.4s770.5-196.4 770.5-326.4z",
  rightarrow: "M0 241v40h399891c-47.3 35.3-84 78-110 128\n-16.7 32-27.7 63.7-33 95 0 1.3-.2 2.7-.5 4-.3 1.3-.5 2.3-.5 3 0 7.3 6.7 11 20\n 11 8 0 13.2-.8 15.5-2.5 2.3-1.7 4.2-5.5 5.5-11.5 2-13.3 5.7-27 11-41 14.7-44.7\n 39-84.5 73-119.5s73.7-60.2 119-75.5c6-2 9-5.7 9-11s-3-9-9-11c-45.3-15.3-85\n-40.5-119-75.5s-58.3-74.8-73-119.5c-4.7-14-8.3-27.3-11-40-1.3-6.7-3.2-10.8-5.5\n-12.5-2.3-1.7-7.5-2.5-15.5-2.5-14 0-21 3.7-21 11 0 2 2 10.3 6 25 20.7 83.3 67\n 151.7 139 205zm0 0v40h399900v-40z",
  rightbrace: "M400000 542l\n-6 6h-17c-12.7 0-19.3-.3-20-1-4-4-7.3-8.3-10-13-35.3-51.3-80.8-93.8-136.5-127.5\ns-117.2-55.8-184.5-66.5c-.7 0-2-.3-4-1-18.7-2.7-76-4.3-172-5H0V214h399571l6 1\nc124.7 8 235 61.7 331 161 31.3 33.3 59.7 72.7 85 118l7 13v35z",
  rightbraceunder: "M399994 0l6 6v35l-6 11c-56 104-135.3 181.3-238 232-57.3\n 28.7-117 45-179 50H-300V214h399897c43.3-7 81-15 113-26 100.7-33 179.7-91 237\n-174 2.7-5 6-9 10-13 .7-1 7.3-1 20-1h17z",
  rightgroup: "M0 80h399565c371 0 266.7 149.4 414 180 5.9 1.2 18 0 18 0 2 0\n 3-1 3-3v-38c-76-158-257-219-435-219H0z",
  rightgroupunder: "M0 262h399565c371 0 266.7-149.4 414-180 5.9-1.2 18 0 18\n 0 2 0 3 1 3 3v38c-76 158-257 219-435 219H0z",
  rightharpoon: "M0 241v40h399993c4.7-4.7 7-9.3 7-14 0-9.3\n-3.7-15.3-11-18-92.7-56.7-159-133.7-199-231-3.3-9.3-6-14.7-8-16-2-1.3-7-2-15-2\n-10.7 0-16.7 2-18 6-2 2.7-1 9.7 3 21 15.3 42 36.7 81.8 64 119.5 27.3 37.7 58\n 69.2 92 94.5zm0 0v40h399900v-40z",
  rightharpoonplus: "M0 241v40h399993c4.7-4.7 7-9.3 7-14 0-9.3-3.7-15.3-11\n-18-92.7-56.7-159-133.7-199-231-3.3-9.3-6-14.7-8-16-2-1.3-7-2-15-2-10.7 0-16.7\n 2-18 6-2 2.7-1 9.7 3 21 15.3 42 36.7 81.8 64 119.5 27.3 37.7 58 69.2 92 94.5z\nm0 0v40h399900v-40z m100 194v40h399900v-40zm0 0v40h399900v-40z",
  rightharpoondown: "M399747 511c0 7.3 6.7 11 20 11 8 0 13-.8 15-2.5s4.7-6.8\n 8-15.5c40-94 99.3-166.3 178-217 13.3-8 20.3-12.3 21-13 5.3-3.3 8.5-5.8 9.5\n-7.5 1-1.7 1.5-5.2 1.5-10.5s-2.3-10.3-7-15H0v40h399908c-34 25.3-64.7 57-92 95\n-27.3 38-48.7 77.7-64 119-3.3 8.7-5 14-5 16zM0 241v40h399900v-40z",
  rightharpoondownplus: "M399747 705c0 7.3 6.7 11 20 11 8 0 13-.8\n 15-2.5s4.7-6.8 8-15.5c40-94 99.3-166.3 178-217 13.3-8 20.3-12.3 21-13 5.3-3.3\n 8.5-5.8 9.5-7.5 1-1.7 1.5-5.2 1.5-10.5s-2.3-10.3-7-15H0v40h399908c-34 25.3\n-64.7 57-92 95-27.3 38-48.7 77.7-64 119-3.3 8.7-5 14-5 16zM0 435v40h399900v-40z\nm0-194v40h400000v-40zm0 0v40h400000v-40z",
  righthook: "M399859 241c-764 0 0 0 0 0 40-3.3 68.7-15.7 86-37 10-12 15-25.3\n 15-40 0-22.7-9.8-40.7-29.5-54-19.7-13.3-43.5-21-71.5-23-17.3-1.3-26-8-26-20 0\n-13.3 8.7-20 26-20 38 0 71 11.2 99 33.5 0 0 7 5.6 21 16.7 14 11.2 21 33.5 21\n 66.8s-14 61.2-42 83.5c-28 22.3-61 33.5-99 33.5L0 241z M0 281v-40h399859v40z",
  rightlinesegment: "M399960 241 V94 h40 V428 h-40 V281 H0 v-40z\nM399960 241 V94 h40 V428 h-40 V281 H0 v-40z",
  rightToFrom: "M400000 167c-70.7-42-118-97.7-142-167h-23c-15.3 0-23 .3-23\n 1 0 1.3 5.3 13.7 16 37 18 35.3 41.3 69 70 101l7 8H0v40h399905l-7 8c-28.7 32\n-52 65.7-70 101-10.7 23.3-16 35.7-16 37 0 .7 7.7 1 23 1h23c24-69.3 71.3-125 142\n-167z M100 147v40h399900v-40zM0 341v40h399900v-40z",
  // twoheadleftarrow is from glyph U+219E in font KaTeX AMS Regular
  twoheadleftarrow: "M0 167c68 40\n 115.7 95.7 143 167h22c15.3 0 23-.3 23-1 0-1.3-5.3-13.7-16-37-18-35.3-41.3-69\n-70-101l-7-8h125l9 7c50.7 39.3 85 86 103 140h46c0-4.7-6.3-18.7-19-42-18-35.3\n-40-67.3-66-96l-9-9h399716v-40H284l9-9c26-28.7 48-60.7 66-96 12.7-23.333 19\n-37.333 19-42h-46c-18 54-52.3 100.7-103 140l-9 7H95l7-8c28.7-32 52-65.7 70-101\n 10.7-23.333 16-35.7 16-37 0-.7-7.7-1-23-1h-22C115.7 71.3 68 127 0 167z",
  twoheadrightarrow: "M400000 167\nc-68-40-115.7-95.7-143-167h-22c-15.3 0-23 .3-23 1 0 1.3 5.3 13.7 16 37 18 35.3\n 41.3 69 70 101l7 8h-125l-9-7c-50.7-39.3-85-86-103-140h-46c0 4.7 6.3 18.7 19 42\n 18 35.3 40 67.3 66 96l9 9H0v40h399716l-9 9c-26 28.7-48 60.7-66 96-12.7 23.333\n-19 37.333-19 42h46c18-54 52.3-100.7 103-140l9-7h125l-7 8c-28.7 32-52 65.7-70\n 101-10.7 23.333-16 35.7-16 37 0 .7 7.7 1 23 1h22c27.3-71.3 75-127 143-167z",
  // tilde1 is a modified version of a glyph from the MnSymbol package
  tilde1: "M200 55.538c-77 0-168 73.953-177 73.953-3 0-7\n-2.175-9-5.437L2 97c-1-2-2-4-2-6 0-4 2-7 5-9l20-12C116 12 171 0 207 0c86 0\n 114 68 191 68 78 0 168-68 177-68 4 0 7 2 9 5l12 19c1 2.175 2 4.35 2 6.525 0\n 4.35-2 7.613-5 9.788l-19 13.05c-92 63.077-116.937 75.308-183 76.128\n-68.267.847-113-73.952-191-73.952z",
  // ditto tilde2, tilde3, & tilde4
  tilde2: "M344 55.266c-142 0-300.638 81.316-311.5 86.418\n-8.01 3.762-22.5 10.91-23.5 5.562L1 120c-1-2-1-3-1-4 0-5 3-9 8-10l18.4-9C160.9\n 31.9 283 0 358 0c148 0 188 122 331 122s314-97 326-97c4 0 8 2 10 7l7 21.114\nc1 2.14 1 3.21 1 4.28 0 5.347-3 9.626-7 10.696l-22.3 12.622C852.6 158.372 751\n 181.476 676 181.476c-149 0-189-126.21-332-126.21z",
  tilde3: "M786 59C457 59 32 175.242 13 175.242c-6 0-10-3.457\n-11-10.37L.15 138c-1-7 3-12 10-13l19.2-6.4C378.4 40.7 634.3 0 804.3 0c337 0\n 411.8 157 746.8 157 328 0 754-112 773-112 5 0 10 3 11 9l1 14.075c1 8.066-.697\n 16.595-6.697 17.492l-21.052 7.31c-367.9 98.146-609.15 122.696-778.15 122.696\n -338 0-409-156.573-744-156.573z",
  tilde4: "M786 58C457 58 32 177.487 13 177.487c-6 0-10-3.345\n-11-10.035L.15 143c-1-7 3-12 10-13l22-6.7C381.2 35 637.15 0 807.15 0c337 0 409\n 177 744 177 328 0 754-127 773-127 5 0 10 3 11 9l1 14.794c1 7.805-3 13.38-9\n 14.495l-20.7 5.574c-366.85 99.79-607.3 139.372-776.3 139.372-338 0-409\n -175.236-744-175.236z",
  // vec is from glyph U+20D7 in font KaTeX Main
  vec: "M377 20c0-5.333 1.833-10 5.5-14S391 0 397 0c4.667 0 8.667 1.667 12 5\n3.333 2.667 6.667 9 10 19 6.667 24.667 20.333 43.667 41 57 7.333 4.667 11\n10.667 11 18 0 6-1 10-3 12s-6.667 5-14 9c-28.667 14.667-53.667 35.667-75 63\n-1.333 1.333-3.167 3.5-5.5 6.5s-4 4.833-5 5.5c-1 .667-2.5 1.333-4.5 2s-4.333 1\n-7 1c-4.667 0-9.167-1.833-13.5-5.5S337 184 337 178c0-12.667 15.667-32.333 47-59\nH213l-171-1c-8.667-6-13-12.333-13-19 0-4.667 4.333-11.333 13-20h359\nc-16-25.333-24-45-24-59z",
  // widehat1 is a modified version of a glyph from the MnSymbol package
  widehat1: "M529 0h5l519 115c5 1 9 5 9 10 0 1-1 2-1 3l-4 22\nc-1 5-5 9-11 9h-2L532 67 19 159h-2c-5 0-9-4-11-9l-5-22c-1-6 2-12 8-13z",
  // ditto widehat2, widehat3, & widehat4
  widehat2: "M1181 0h2l1171 176c6 0 10 5 10 11l-2 23c-1 6-5 10\n-11 10h-1L1182 67 15 220h-1c-6 0-10-4-11-10l-2-23c-1-6 4-11 10-11z",
  widehat3: "M1181 0h2l1171 236c6 0 10 5 10 11l-2 23c-1 6-5 10\n-11 10h-1L1182 67 15 280h-1c-6 0-10-4-11-10l-2-23c-1-6 4-11 10-11z",
  widehat4: "M1181 0h2l1171 296c6 0 10 5 10 11l-2 23c-1 6-5 10\n-11 10h-1L1182 67 15 340h-1c-6 0-10-4-11-10l-2-23c-1-6 4-11 10-11z",
  // widecheck paths are all inverted versions of widehat
  widecheck1: "M529,159h5l519,-115c5,-1,9,-5,9,-10c0,-1,-1,-2,-1,-3l-4,-22c-1,\n-5,-5,-9,-11,-9h-2l-512,92l-513,-92h-2c-5,0,-9,4,-11,9l-5,22c-1,6,2,12,8,13z",
  widecheck2: "M1181,220h2l1171,-176c6,0,10,-5,10,-11l-2,-23c-1,-6,-5,-10,\n-11,-10h-1l-1168,153l-1167,-153h-1c-6,0,-10,4,-11,10l-2,23c-1,6,4,11,10,11z",
  widecheck3: "M1181,280h2l1171,-236c6,0,10,-5,10,-11l-2,-23c-1,-6,-5,-10,\n-11,-10h-1l-1168,213l-1167,-213h-1c-6,0,-10,4,-11,10l-2,23c-1,6,4,11,10,11z",
  widecheck4: "M1181,340h2l1171,-296c6,0,10,-5,10,-11l-2,-23c-1,-6,-5,-10,\n-11,-10h-1l-1168,273l-1167,-273h-1c-6,0,-10,4,-11,10l-2,23c-1,6,4,11,10,11z",
  // The next ten paths support reaction arrows from the mhchem package.
  // Arrows for \ce{<-->} are offset from xAxis by 0.22ex, per mhchem in LaTeX
  // baraboveleftarrow is mostly from glyph U+2190 in font KaTeX Main
  baraboveleftarrow: "M400000 620h-399890l3 -3c68.7 -52.7 113.7 -120 135 -202\nc4 -14.7 6 -23 6 -25c0 -7.3 -7 -11 -21 -11c-8 0 -13.2 0.8 -15.5 2.5\nc-2.3 1.7 -4.2 5.8 -5.5 12.5c-1.3 4.7 -2.7 10.3 -4 17c-12 48.7 -34.8 92 -68.5 130\ns-74.2 66.3 -121.5 85c-10 4 -16 7.7 -18 11c0 8.7 6 14.3 18 17c47.3 18.7 87.8 47\n121.5 85s56.5 81.3 68.5 130c0.7 2 1.3 5 2 9s1.2 6.7 1.5 8c0.3 1.3 1 3.3 2 6\ns2.2 4.5 3.5 5.5c1.3 1 3.3 1.8 6 2.5s6 1 10 1c14 0 21 -3.7 21 -11\nc0 -2 -2 -10.3 -6 -25c-20 -79.3 -65 -146.7 -135 -202l-3 -3h399890z\nM100 620v40h399900v-40z M0 241v40h399900v-40zM0 241v40h399900v-40z",
  // rightarrowabovebar is mostly from glyph U+2192, KaTeX Main
  rightarrowabovebar: "M0 241v40h399891c-47.3 35.3-84 78-110 128-16.7 32\n-27.7 63.7-33 95 0 1.3-.2 2.7-.5 4-.3 1.3-.5 2.3-.5 3 0 7.3 6.7 11 20 11 8 0\n13.2-.8 15.5-2.5 2.3-1.7 4.2-5.5 5.5-11.5 2-13.3 5.7-27 11-41 14.7-44.7 39\n-84.5 73-119.5s73.7-60.2 119-75.5c6-2 9-5.7 9-11s-3-9-9-11c-45.3-15.3-85-40.5\n-119-75.5s-58.3-74.8-73-119.5c-4.7-14-8.3-27.3-11-40-1.3-6.7-3.2-10.8-5.5\n-12.5-2.3-1.7-7.5-2.5-15.5-2.5-14 0-21 3.7-21 11 0 2 2 10.3 6 25 20.7 83.3 67\n151.7 139 205zm96 379h399894v40H0zm0 0h399904v40H0z",
  // The short left harpoon has 0.5em (i.e. 500 units) kern on the left end.
  // Ref from mhchem.sty: \rlap{\raisebox{-.22ex}{$\kern0.5em
  baraboveshortleftharpoon: "M507,435c-4,4,-6.3,8.7,-7,14c0,5.3,0.7,9,2,11\nc1.3,2,5.3,5.3,12,10c90.7,54,156,130,196,228c3.3,10.7,6.3,16.3,9,17\nc2,0.7,5,1,9,1c0,0,5,0,5,0c10.7,0,16.7,-2,18,-6c2,-2.7,1,-9.7,-3,-21\nc-32,-87.3,-82.7,-157.7,-152,-211c0,0,-3,-3,-3,-3l399351,0l0,-40\nc-398570,0,-399437,0,-399437,0z M593 435 v40 H399500 v-40z\nM0 281 v-40 H399908 v40z M0 281 v-40 H399908 v40z",
  rightharpoonaboveshortbar: "M0,241 l0,40c399126,0,399993,0,399993,0\nc4.7,-4.7,7,-9.3,7,-14c0,-9.3,-3.7,-15.3,-11,-18c-92.7,-56.7,-159,-133.7,-199,\n-231c-3.3,-9.3,-6,-14.7,-8,-16c-2,-1.3,-7,-2,-15,-2c-10.7,0,-16.7,2,-18,6\nc-2,2.7,-1,9.7,3,21c15.3,42,36.7,81.8,64,119.5c27.3,37.7,58,69.2,92,94.5z\nM0 241 v40 H399908 v-40z M0 475 v-40 H399500 v40z M0 475 v-40 H399500 v40z",
  shortbaraboveleftharpoon: "M7,435c-4,4,-6.3,8.7,-7,14c0,5.3,0.7,9,2,11\nc1.3,2,5.3,5.3,12,10c90.7,54,156,130,196,228c3.3,10.7,6.3,16.3,9,17c2,0.7,5,1,9,\n1c0,0,5,0,5,0c10.7,0,16.7,-2,18,-6c2,-2.7,1,-9.7,-3,-21c-32,-87.3,-82.7,-157.7,\n-152,-211c0,0,-3,-3,-3,-3l399907,0l0,-40c-399126,0,-399993,0,-399993,0z\nM93 435 v40 H400000 v-40z M500 241 v40 H400000 v-40z M500 241 v40 H400000 v-40z",
  shortrightharpoonabovebar: "M53,241l0,40c398570,0,399437,0,399437,0\nc4.7,-4.7,7,-9.3,7,-14c0,-9.3,-3.7,-15.3,-11,-18c-92.7,-56.7,-159,-133.7,-199,\n-231c-3.3,-9.3,-6,-14.7,-8,-16c-2,-1.3,-7,-2,-15,-2c-10.7,0,-16.7,2,-18,6\nc-2,2.7,-1,9.7,3,21c15.3,42,36.7,81.8,64,119.5c27.3,37.7,58,69.2,92,94.5z\nM500 241 v40 H399408 v-40z M500 435 v40 H400000 v-40z"
};
var tallDelim = function tallDelim2(label2, midHeight) {
  switch (label2) {
    case "lbrack":
      return "M403 1759 V84 H666 V0 H319 V1759 v" + midHeight + " v1759 h347 v-84\nH403z M403 1759 V0 H319 V1759 v" + midHeight + " v1759 h84z";
    case "rbrack":
      return "M347 1759 V0 H0 V84 H263 V1759 v" + midHeight + " v1759 H0 v84 H347z\nM347 1759 V0 H263 V1759 v" + midHeight + " v1759 h84z";
    case "vert":
      return "M145 15 v585 v" + midHeight + " v585 c2.667,10,9.667,15,21,15\nc10,0,16.667,-5,20,-15 v-585 v" + -midHeight + " v-585 c-2.667,-10,-9.667,-15,-21,-15\nc-10,0,-16.667,5,-20,15z M188 15 H145 v585 v" + midHeight + " v585 h43z";
    case "doublevert":
      return "M145 15 v585 v" + midHeight + " v585 c2.667,10,9.667,15,21,15\nc10,0,16.667,-5,20,-15 v-585 v" + -midHeight + " v-585 c-2.667,-10,-9.667,-15,-21,-15\nc-10,0,-16.667,5,-20,15z M188 15 H145 v585 v" + midHeight + " v585 h43z\nM367 15 v585 v" + midHeight + " v585 c2.667,10,9.667,15,21,15\nc10,0,16.667,-5,20,-15 v-585 v" + -midHeight + " v-585 c-2.667,-10,-9.667,-15,-21,-15\nc-10,0,-16.667,5,-20,15z M410 15 H367 v585 v" + midHeight + " v585 h43z";
    case "lfloor":
      return "M319 602 V0 H403 V602 v" + midHeight + " v1715 h263 v84 H319z\nMM319 602 V0 H403 V602 v" + midHeight + " v1715 H319z";
    case "rfloor":
      return "M319 602 V0 H403 V602 v" + midHeight + " v1799 H0 v-84 H319z\nMM319 602 V0 H403 V602 v" + midHeight + " v1715 H319z";
    case "lceil":
      return "M403 1759 V84 H666 V0 H319 V1759 v" + midHeight + " v602 h84z\nM403 1759 V0 H319 V1759 v" + midHeight + " v602 h84z";
    case "rceil":
      return "M347 1759 V0 H0 V84 H263 V1759 v" + midHeight + " v602 h84z\nM347 1759 V0 h-84 V1759 v" + midHeight + " v602 h84z";
    case "lparen":
      return "M863,9c0,-2,-2,-5,-6,-9c0,0,-17,0,-17,0c-12.7,0,-19.3,0.3,-20,1\nc-5.3,5.3,-10.3,11,-15,17c-242.7,294.7,-395.3,682,-458,1162c-21.3,163.3,-33.3,349,\n-36,557 l0," + (midHeight + 84) + "c0.2,6,0,26,0,60c2,159.3,10,310.7,24,454c53.3,528,210,\n949.7,470,1265c4.7,6,9.7,11.7,15,17c0.7,0.7,7,1,19,1c0,0,18,0,18,0c4,-4,6,-7,6,-9\nc0,-2.7,-3.3,-8.7,-10,-18c-135.3,-192.7,-235.5,-414.3,-300.5,-665c-65,-250.7,-102.5,\n-544.7,-112.5,-882c-2,-104,-3,-167,-3,-189\nl0,-" + (midHeight + 92) + "c0,-162.7,5.7,-314,17,-454c20.7,-272,63.7,-513,129,-723c65.3,\n-210,155.3,-396.3,270,-559c6.7,-9.3,10,-15.3,10,-18z";
    case "rparen":
      return "M76,0c-16.7,0,-25,3,-25,9c0,2,2,6.3,6,13c21.3,28.7,42.3,60.3,\n63,95c96.7,156.7,172.8,332.5,228.5,527.5c55.7,195,92.8,416.5,111.5,664.5\nc11.3,139.3,17,290.7,17,454c0,28,1.7,43,3.3,45l0," + (midHeight + 9) + "\nc-3,4,-3.3,16.7,-3.3,38c0,162,-5.7,313.7,-17,455c-18.7,248,-55.8,469.3,-111.5,664\nc-55.7,194.7,-131.8,370.3,-228.5,527c-20.7,34.7,-41.7,66.3,-63,95c-2,3.3,-4,7,-6,11\nc0,7.3,5.7,11,17,11c0,0,11,0,11,0c9.3,0,14.3,-0.3,15,-1c5.3,-5.3,10.3,-11,15,-17\nc242.7,-294.7,395.3,-681.7,458,-1161c21.3,-164.7,33.3,-350.7,36,-558\nl0,-" + (midHeight + 144) + "c-2,-159.3,-10,-310.7,-24,-454c-53.3,-528,-210,-949.7,\n-470,-1265c-4.7,-6,-9.7,-11.7,-15,-17c-0.7,-0.7,-6.7,-1,-18,-1z";
    default:
      throw new Error("Unknown stretchy delimiter.");
  }
};
class DocumentFragment {
  // HtmlDomNode
  // Never used; needed for satisfying interface.
  constructor(children) {
    this.children = void 0;
    this.classes = void 0;
    this.height = void 0;
    this.depth = void 0;
    this.maxFontSize = void 0;
    this.style = void 0;
    this.children = children;
    this.classes = [];
    this.height = 0;
    this.depth = 0;
    this.maxFontSize = 0;
    this.style = {};
  }
  hasClass(className) {
    return utils.contains(this.classes, className);
  }
  /** Convert the fragment into a node. */
  toNode() {
    var frag = document.createDocumentFragment();
    for (var i = 0; i < this.children.length; i++) {
      frag.appendChild(this.children[i].toNode());
    }
    return frag;
  }
  /** Convert the fragment into HTML markup. */
  toMarkup() {
    var markup = "";
    for (var i = 0; i < this.children.length; i++) {
      markup += this.children[i].toMarkup();
    }
    return markup;
  }
  /**
   * Converts the math node into a string, similar to innerText. Applies to
   * MathDomNode's only.
   */
  toText() {
    var toText = (child) => child.toText();
    return this.children.map(toText).join("");
  }
}
var fontMetricsData = {
  "AMS-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "65": [0, 0.68889, 0, 0, 0.72222],
    "66": [0, 0.68889, 0, 0, 0.66667],
    "67": [0, 0.68889, 0, 0, 0.72222],
    "68": [0, 0.68889, 0, 0, 0.72222],
    "69": [0, 0.68889, 0, 0, 0.66667],
    "70": [0, 0.68889, 0, 0, 0.61111],
    "71": [0, 0.68889, 0, 0, 0.77778],
    "72": [0, 0.68889, 0, 0, 0.77778],
    "73": [0, 0.68889, 0, 0, 0.38889],
    "74": [0.16667, 0.68889, 0, 0, 0.5],
    "75": [0, 0.68889, 0, 0, 0.77778],
    "76": [0, 0.68889, 0, 0, 0.66667],
    "77": [0, 0.68889, 0, 0, 0.94445],
    "78": [0, 0.68889, 0, 0, 0.72222],
    "79": [0.16667, 0.68889, 0, 0, 0.77778],
    "80": [0, 0.68889, 0, 0, 0.61111],
    "81": [0.16667, 0.68889, 0, 0, 0.77778],
    "82": [0, 0.68889, 0, 0, 0.72222],
    "83": [0, 0.68889, 0, 0, 0.55556],
    "84": [0, 0.68889, 0, 0, 0.66667],
    "85": [0, 0.68889, 0, 0, 0.72222],
    "86": [0, 0.68889, 0, 0, 0.72222],
    "87": [0, 0.68889, 0, 0, 1],
    "88": [0, 0.68889, 0, 0, 0.72222],
    "89": [0, 0.68889, 0, 0, 0.72222],
    "90": [0, 0.68889, 0, 0, 0.66667],
    "107": [0, 0.68889, 0, 0, 0.55556],
    "160": [0, 0, 0, 0, 0.25],
    "165": [0, 0.675, 0.025, 0, 0.75],
    "174": [0.15559, 0.69224, 0, 0, 0.94666],
    "240": [0, 0.68889, 0, 0, 0.55556],
    "295": [0, 0.68889, 0, 0, 0.54028],
    "710": [0, 0.825, 0, 0, 2.33334],
    "732": [0, 0.9, 0, 0, 2.33334],
    "770": [0, 0.825, 0, 0, 2.33334],
    "771": [0, 0.9, 0, 0, 2.33334],
    "989": [0.08167, 0.58167, 0, 0, 0.77778],
    "1008": [0, 0.43056, 0.04028, 0, 0.66667],
    "8245": [0, 0.54986, 0, 0, 0.275],
    "8463": [0, 0.68889, 0, 0, 0.54028],
    "8487": [0, 0.68889, 0, 0, 0.72222],
    "8498": [0, 0.68889, 0, 0, 0.55556],
    "8502": [0, 0.68889, 0, 0, 0.66667],
    "8503": [0, 0.68889, 0, 0, 0.44445],
    "8504": [0, 0.68889, 0, 0, 0.66667],
    "8513": [0, 0.68889, 0, 0, 0.63889],
    "8592": [-0.03598, 0.46402, 0, 0, 0.5],
    "8594": [-0.03598, 0.46402, 0, 0, 0.5],
    "8602": [-0.13313, 0.36687, 0, 0, 1],
    "8603": [-0.13313, 0.36687, 0, 0, 1],
    "8606": [0.01354, 0.52239, 0, 0, 1],
    "8608": [0.01354, 0.52239, 0, 0, 1],
    "8610": [0.01354, 0.52239, 0, 0, 1.11111],
    "8611": [0.01354, 0.52239, 0, 0, 1.11111],
    "8619": [0, 0.54986, 0, 0, 1],
    "8620": [0, 0.54986, 0, 0, 1],
    "8621": [-0.13313, 0.37788, 0, 0, 1.38889],
    "8622": [-0.13313, 0.36687, 0, 0, 1],
    "8624": [0, 0.69224, 0, 0, 0.5],
    "8625": [0, 0.69224, 0, 0, 0.5],
    "8630": [0, 0.43056, 0, 0, 1],
    "8631": [0, 0.43056, 0, 0, 1],
    "8634": [0.08198, 0.58198, 0, 0, 0.77778],
    "8635": [0.08198, 0.58198, 0, 0, 0.77778],
    "8638": [0.19444, 0.69224, 0, 0, 0.41667],
    "8639": [0.19444, 0.69224, 0, 0, 0.41667],
    "8642": [0.19444, 0.69224, 0, 0, 0.41667],
    "8643": [0.19444, 0.69224, 0, 0, 0.41667],
    "8644": [0.1808, 0.675, 0, 0, 1],
    "8646": [0.1808, 0.675, 0, 0, 1],
    "8647": [0.1808, 0.675, 0, 0, 1],
    "8648": [0.19444, 0.69224, 0, 0, 0.83334],
    "8649": [0.1808, 0.675, 0, 0, 1],
    "8650": [0.19444, 0.69224, 0, 0, 0.83334],
    "8651": [0.01354, 0.52239, 0, 0, 1],
    "8652": [0.01354, 0.52239, 0, 0, 1],
    "8653": [-0.13313, 0.36687, 0, 0, 1],
    "8654": [-0.13313, 0.36687, 0, 0, 1],
    "8655": [-0.13313, 0.36687, 0, 0, 1],
    "8666": [0.13667, 0.63667, 0, 0, 1],
    "8667": [0.13667, 0.63667, 0, 0, 1],
    "8669": [-0.13313, 0.37788, 0, 0, 1],
    "8672": [-0.064, 0.437, 0, 0, 1.334],
    "8674": [-0.064, 0.437, 0, 0, 1.334],
    "8705": [0, 0.825, 0, 0, 0.5],
    "8708": [0, 0.68889, 0, 0, 0.55556],
    "8709": [0.08167, 0.58167, 0, 0, 0.77778],
    "8717": [0, 0.43056, 0, 0, 0.42917],
    "8722": [-0.03598, 0.46402, 0, 0, 0.5],
    "8724": [0.08198, 0.69224, 0, 0, 0.77778],
    "8726": [0.08167, 0.58167, 0, 0, 0.77778],
    "8733": [0, 0.69224, 0, 0, 0.77778],
    "8736": [0, 0.69224, 0, 0, 0.72222],
    "8737": [0, 0.69224, 0, 0, 0.72222],
    "8738": [0.03517, 0.52239, 0, 0, 0.72222],
    "8739": [0.08167, 0.58167, 0, 0, 0.22222],
    "8740": [0.25142, 0.74111, 0, 0, 0.27778],
    "8741": [0.08167, 0.58167, 0, 0, 0.38889],
    "8742": [0.25142, 0.74111, 0, 0, 0.5],
    "8756": [0, 0.69224, 0, 0, 0.66667],
    "8757": [0, 0.69224, 0, 0, 0.66667],
    "8764": [-0.13313, 0.36687, 0, 0, 0.77778],
    "8765": [-0.13313, 0.37788, 0, 0, 0.77778],
    "8769": [-0.13313, 0.36687, 0, 0, 0.77778],
    "8770": [-0.03625, 0.46375, 0, 0, 0.77778],
    "8774": [0.30274, 0.79383, 0, 0, 0.77778],
    "8776": [-0.01688, 0.48312, 0, 0, 0.77778],
    "8778": [0.08167, 0.58167, 0, 0, 0.77778],
    "8782": [0.06062, 0.54986, 0, 0, 0.77778],
    "8783": [0.06062, 0.54986, 0, 0, 0.77778],
    "8785": [0.08198, 0.58198, 0, 0, 0.77778],
    "8786": [0.08198, 0.58198, 0, 0, 0.77778],
    "8787": [0.08198, 0.58198, 0, 0, 0.77778],
    "8790": [0, 0.69224, 0, 0, 0.77778],
    "8791": [0.22958, 0.72958, 0, 0, 0.77778],
    "8796": [0.08198, 0.91667, 0, 0, 0.77778],
    "8806": [0.25583, 0.75583, 0, 0, 0.77778],
    "8807": [0.25583, 0.75583, 0, 0, 0.77778],
    "8808": [0.25142, 0.75726, 0, 0, 0.77778],
    "8809": [0.25142, 0.75726, 0, 0, 0.77778],
    "8812": [0.25583, 0.75583, 0, 0, 0.5],
    "8814": [0.20576, 0.70576, 0, 0, 0.77778],
    "8815": [0.20576, 0.70576, 0, 0, 0.77778],
    "8816": [0.30274, 0.79383, 0, 0, 0.77778],
    "8817": [0.30274, 0.79383, 0, 0, 0.77778],
    "8818": [0.22958, 0.72958, 0, 0, 0.77778],
    "8819": [0.22958, 0.72958, 0, 0, 0.77778],
    "8822": [0.1808, 0.675, 0, 0, 0.77778],
    "8823": [0.1808, 0.675, 0, 0, 0.77778],
    "8828": [0.13667, 0.63667, 0, 0, 0.77778],
    "8829": [0.13667, 0.63667, 0, 0, 0.77778],
    "8830": [0.22958, 0.72958, 0, 0, 0.77778],
    "8831": [0.22958, 0.72958, 0, 0, 0.77778],
    "8832": [0.20576, 0.70576, 0, 0, 0.77778],
    "8833": [0.20576, 0.70576, 0, 0, 0.77778],
    "8840": [0.30274, 0.79383, 0, 0, 0.77778],
    "8841": [0.30274, 0.79383, 0, 0, 0.77778],
    "8842": [0.13597, 0.63597, 0, 0, 0.77778],
    "8843": [0.13597, 0.63597, 0, 0, 0.77778],
    "8847": [0.03517, 0.54986, 0, 0, 0.77778],
    "8848": [0.03517, 0.54986, 0, 0, 0.77778],
    "8858": [0.08198, 0.58198, 0, 0, 0.77778],
    "8859": [0.08198, 0.58198, 0, 0, 0.77778],
    "8861": [0.08198, 0.58198, 0, 0, 0.77778],
    "8862": [0, 0.675, 0, 0, 0.77778],
    "8863": [0, 0.675, 0, 0, 0.77778],
    "8864": [0, 0.675, 0, 0, 0.77778],
    "8865": [0, 0.675, 0, 0, 0.77778],
    "8872": [0, 0.69224, 0, 0, 0.61111],
    "8873": [0, 0.69224, 0, 0, 0.72222],
    "8874": [0, 0.69224, 0, 0, 0.88889],
    "8876": [0, 0.68889, 0, 0, 0.61111],
    "8877": [0, 0.68889, 0, 0, 0.61111],
    "8878": [0, 0.68889, 0, 0, 0.72222],
    "8879": [0, 0.68889, 0, 0, 0.72222],
    "8882": [0.03517, 0.54986, 0, 0, 0.77778],
    "8883": [0.03517, 0.54986, 0, 0, 0.77778],
    "8884": [0.13667, 0.63667, 0, 0, 0.77778],
    "8885": [0.13667, 0.63667, 0, 0, 0.77778],
    "8888": [0, 0.54986, 0, 0, 1.11111],
    "8890": [0.19444, 0.43056, 0, 0, 0.55556],
    "8891": [0.19444, 0.69224, 0, 0, 0.61111],
    "8892": [0.19444, 0.69224, 0, 0, 0.61111],
    "8901": [0, 0.54986, 0, 0, 0.27778],
    "8903": [0.08167, 0.58167, 0, 0, 0.77778],
    "8905": [0.08167, 0.58167, 0, 0, 0.77778],
    "8906": [0.08167, 0.58167, 0, 0, 0.77778],
    "8907": [0, 0.69224, 0, 0, 0.77778],
    "8908": [0, 0.69224, 0, 0, 0.77778],
    "8909": [-0.03598, 0.46402, 0, 0, 0.77778],
    "8910": [0, 0.54986, 0, 0, 0.76042],
    "8911": [0, 0.54986, 0, 0, 0.76042],
    "8912": [0.03517, 0.54986, 0, 0, 0.77778],
    "8913": [0.03517, 0.54986, 0, 0, 0.77778],
    "8914": [0, 0.54986, 0, 0, 0.66667],
    "8915": [0, 0.54986, 0, 0, 0.66667],
    "8916": [0, 0.69224, 0, 0, 0.66667],
    "8918": [0.0391, 0.5391, 0, 0, 0.77778],
    "8919": [0.0391, 0.5391, 0, 0, 0.77778],
    "8920": [0.03517, 0.54986, 0, 0, 1.33334],
    "8921": [0.03517, 0.54986, 0, 0, 1.33334],
    "8922": [0.38569, 0.88569, 0, 0, 0.77778],
    "8923": [0.38569, 0.88569, 0, 0, 0.77778],
    "8926": [0.13667, 0.63667, 0, 0, 0.77778],
    "8927": [0.13667, 0.63667, 0, 0, 0.77778],
    "8928": [0.30274, 0.79383, 0, 0, 0.77778],
    "8929": [0.30274, 0.79383, 0, 0, 0.77778],
    "8934": [0.23222, 0.74111, 0, 0, 0.77778],
    "8935": [0.23222, 0.74111, 0, 0, 0.77778],
    "8936": [0.23222, 0.74111, 0, 0, 0.77778],
    "8937": [0.23222, 0.74111, 0, 0, 0.77778],
    "8938": [0.20576, 0.70576, 0, 0, 0.77778],
    "8939": [0.20576, 0.70576, 0, 0, 0.77778],
    "8940": [0.30274, 0.79383, 0, 0, 0.77778],
    "8941": [0.30274, 0.79383, 0, 0, 0.77778],
    "8994": [0.19444, 0.69224, 0, 0, 0.77778],
    "8995": [0.19444, 0.69224, 0, 0, 0.77778],
    "9416": [0.15559, 0.69224, 0, 0, 0.90222],
    "9484": [0, 0.69224, 0, 0, 0.5],
    "9488": [0, 0.69224, 0, 0, 0.5],
    "9492": [0, 0.37788, 0, 0, 0.5],
    "9496": [0, 0.37788, 0, 0, 0.5],
    "9585": [0.19444, 0.68889, 0, 0, 0.88889],
    "9586": [0.19444, 0.74111, 0, 0, 0.88889],
    "9632": [0, 0.675, 0, 0, 0.77778],
    "9633": [0, 0.675, 0, 0, 0.77778],
    "9650": [0, 0.54986, 0, 0, 0.72222],
    "9651": [0, 0.54986, 0, 0, 0.72222],
    "9654": [0.03517, 0.54986, 0, 0, 0.77778],
    "9660": [0, 0.54986, 0, 0, 0.72222],
    "9661": [0, 0.54986, 0, 0, 0.72222],
    "9664": [0.03517, 0.54986, 0, 0, 0.77778],
    "9674": [0.11111, 0.69224, 0, 0, 0.66667],
    "9733": [0.19444, 0.69224, 0, 0, 0.94445],
    "10003": [0, 0.69224, 0, 0, 0.83334],
    "10016": [0, 0.69224, 0, 0, 0.83334],
    "10731": [0.11111, 0.69224, 0, 0, 0.66667],
    "10846": [0.19444, 0.75583, 0, 0, 0.61111],
    "10877": [0.13667, 0.63667, 0, 0, 0.77778],
    "10878": [0.13667, 0.63667, 0, 0, 0.77778],
    "10885": [0.25583, 0.75583, 0, 0, 0.77778],
    "10886": [0.25583, 0.75583, 0, 0, 0.77778],
    "10887": [0.13597, 0.63597, 0, 0, 0.77778],
    "10888": [0.13597, 0.63597, 0, 0, 0.77778],
    "10889": [0.26167, 0.75726, 0, 0, 0.77778],
    "10890": [0.26167, 0.75726, 0, 0, 0.77778],
    "10891": [0.48256, 0.98256, 0, 0, 0.77778],
    "10892": [0.48256, 0.98256, 0, 0, 0.77778],
    "10901": [0.13667, 0.63667, 0, 0, 0.77778],
    "10902": [0.13667, 0.63667, 0, 0, 0.77778],
    "10933": [0.25142, 0.75726, 0, 0, 0.77778],
    "10934": [0.25142, 0.75726, 0, 0, 0.77778],
    "10935": [0.26167, 0.75726, 0, 0, 0.77778],
    "10936": [0.26167, 0.75726, 0, 0, 0.77778],
    "10937": [0.26167, 0.75726, 0, 0, 0.77778],
    "10938": [0.26167, 0.75726, 0, 0, 0.77778],
    "10949": [0.25583, 0.75583, 0, 0, 0.77778],
    "10950": [0.25583, 0.75583, 0, 0, 0.77778],
    "10955": [0.28481, 0.79383, 0, 0, 0.77778],
    "10956": [0.28481, 0.79383, 0, 0, 0.77778],
    "57350": [0.08167, 0.58167, 0, 0, 0.22222],
    "57351": [0.08167, 0.58167, 0, 0, 0.38889],
    "57352": [0.08167, 0.58167, 0, 0, 0.77778],
    "57353": [0, 0.43056, 0.04028, 0, 0.66667],
    "57356": [0.25142, 0.75726, 0, 0, 0.77778],
    "57357": [0.25142, 0.75726, 0, 0, 0.77778],
    "57358": [0.41951, 0.91951, 0, 0, 0.77778],
    "57359": [0.30274, 0.79383, 0, 0, 0.77778],
    "57360": [0.30274, 0.79383, 0, 0, 0.77778],
    "57361": [0.41951, 0.91951, 0, 0, 0.77778],
    "57366": [0.25142, 0.75726, 0, 0, 0.77778],
    "57367": [0.25142, 0.75726, 0, 0, 0.77778],
    "57368": [0.25142, 0.75726, 0, 0, 0.77778],
    "57369": [0.25142, 0.75726, 0, 0, 0.77778],
    "57370": [0.13597, 0.63597, 0, 0, 0.77778],
    "57371": [0.13597, 0.63597, 0, 0, 0.77778]
  },
  "Caligraphic-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "65": [0, 0.68333, 0, 0.19445, 0.79847],
    "66": [0, 0.68333, 0.03041, 0.13889, 0.65681],
    "67": [0, 0.68333, 0.05834, 0.13889, 0.52653],
    "68": [0, 0.68333, 0.02778, 0.08334, 0.77139],
    "69": [0, 0.68333, 0.08944, 0.11111, 0.52778],
    "70": [0, 0.68333, 0.09931, 0.11111, 0.71875],
    "71": [0.09722, 0.68333, 0.0593, 0.11111, 0.59487],
    "72": [0, 0.68333, 965e-5, 0.11111, 0.84452],
    "73": [0, 0.68333, 0.07382, 0, 0.54452],
    "74": [0.09722, 0.68333, 0.18472, 0.16667, 0.67778],
    "75": [0, 0.68333, 0.01445, 0.05556, 0.76195],
    "76": [0, 0.68333, 0, 0.13889, 0.68972],
    "77": [0, 0.68333, 0, 0.13889, 1.2009],
    "78": [0, 0.68333, 0.14736, 0.08334, 0.82049],
    "79": [0, 0.68333, 0.02778, 0.11111, 0.79611],
    "80": [0, 0.68333, 0.08222, 0.08334, 0.69556],
    "81": [0.09722, 0.68333, 0, 0.11111, 0.81667],
    "82": [0, 0.68333, 0, 0.08334, 0.8475],
    "83": [0, 0.68333, 0.075, 0.13889, 0.60556],
    "84": [0, 0.68333, 0.25417, 0, 0.54464],
    "85": [0, 0.68333, 0.09931, 0.08334, 0.62583],
    "86": [0, 0.68333, 0.08222, 0, 0.61278],
    "87": [0, 0.68333, 0.08222, 0.08334, 0.98778],
    "88": [0, 0.68333, 0.14643, 0.13889, 0.7133],
    "89": [0.09722, 0.68333, 0.08222, 0.08334, 0.66834],
    "90": [0, 0.68333, 0.07944, 0.13889, 0.72473],
    "160": [0, 0, 0, 0, 0.25]
  },
  "Fraktur-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "33": [0, 0.69141, 0, 0, 0.29574],
    "34": [0, 0.69141, 0, 0, 0.21471],
    "38": [0, 0.69141, 0, 0, 0.73786],
    "39": [0, 0.69141, 0, 0, 0.21201],
    "40": [0.24982, 0.74947, 0, 0, 0.38865],
    "41": [0.24982, 0.74947, 0, 0, 0.38865],
    "42": [0, 0.62119, 0, 0, 0.27764],
    "43": [0.08319, 0.58283, 0, 0, 0.75623],
    "44": [0, 0.10803, 0, 0, 0.27764],
    "45": [0.08319, 0.58283, 0, 0, 0.75623],
    "46": [0, 0.10803, 0, 0, 0.27764],
    "47": [0.24982, 0.74947, 0, 0, 0.50181],
    "48": [0, 0.47534, 0, 0, 0.50181],
    "49": [0, 0.47534, 0, 0, 0.50181],
    "50": [0, 0.47534, 0, 0, 0.50181],
    "51": [0.18906, 0.47534, 0, 0, 0.50181],
    "52": [0.18906, 0.47534, 0, 0, 0.50181],
    "53": [0.18906, 0.47534, 0, 0, 0.50181],
    "54": [0, 0.69141, 0, 0, 0.50181],
    "55": [0.18906, 0.47534, 0, 0, 0.50181],
    "56": [0, 0.69141, 0, 0, 0.50181],
    "57": [0.18906, 0.47534, 0, 0, 0.50181],
    "58": [0, 0.47534, 0, 0, 0.21606],
    "59": [0.12604, 0.47534, 0, 0, 0.21606],
    "61": [-0.13099, 0.36866, 0, 0, 0.75623],
    "63": [0, 0.69141, 0, 0, 0.36245],
    "65": [0, 0.69141, 0, 0, 0.7176],
    "66": [0, 0.69141, 0, 0, 0.88397],
    "67": [0, 0.69141, 0, 0, 0.61254],
    "68": [0, 0.69141, 0, 0, 0.83158],
    "69": [0, 0.69141, 0, 0, 0.66278],
    "70": [0.12604, 0.69141, 0, 0, 0.61119],
    "71": [0, 0.69141, 0, 0, 0.78539],
    "72": [0.06302, 0.69141, 0, 0, 0.7203],
    "73": [0, 0.69141, 0, 0, 0.55448],
    "74": [0.12604, 0.69141, 0, 0, 0.55231],
    "75": [0, 0.69141, 0, 0, 0.66845],
    "76": [0, 0.69141, 0, 0, 0.66602],
    "77": [0, 0.69141, 0, 0, 1.04953],
    "78": [0, 0.69141, 0, 0, 0.83212],
    "79": [0, 0.69141, 0, 0, 0.82699],
    "80": [0.18906, 0.69141, 0, 0, 0.82753],
    "81": [0.03781, 0.69141, 0, 0, 0.82699],
    "82": [0, 0.69141, 0, 0, 0.82807],
    "83": [0, 0.69141, 0, 0, 0.82861],
    "84": [0, 0.69141, 0, 0, 0.66899],
    "85": [0, 0.69141, 0, 0, 0.64576],
    "86": [0, 0.69141, 0, 0, 0.83131],
    "87": [0, 0.69141, 0, 0, 1.04602],
    "88": [0, 0.69141, 0, 0, 0.71922],
    "89": [0.18906, 0.69141, 0, 0, 0.83293],
    "90": [0.12604, 0.69141, 0, 0, 0.60201],
    "91": [0.24982, 0.74947, 0, 0, 0.27764],
    "93": [0.24982, 0.74947, 0, 0, 0.27764],
    "94": [0, 0.69141, 0, 0, 0.49965],
    "97": [0, 0.47534, 0, 0, 0.50046],
    "98": [0, 0.69141, 0, 0, 0.51315],
    "99": [0, 0.47534, 0, 0, 0.38946],
    "100": [0, 0.62119, 0, 0, 0.49857],
    "101": [0, 0.47534, 0, 0, 0.40053],
    "102": [0.18906, 0.69141, 0, 0, 0.32626],
    "103": [0.18906, 0.47534, 0, 0, 0.5037],
    "104": [0.18906, 0.69141, 0, 0, 0.52126],
    "105": [0, 0.69141, 0, 0, 0.27899],
    "106": [0, 0.69141, 0, 0, 0.28088],
    "107": [0, 0.69141, 0, 0, 0.38946],
    "108": [0, 0.69141, 0, 0, 0.27953],
    "109": [0, 0.47534, 0, 0, 0.76676],
    "110": [0, 0.47534, 0, 0, 0.52666],
    "111": [0, 0.47534, 0, 0, 0.48885],
    "112": [0.18906, 0.52396, 0, 0, 0.50046],
    "113": [0.18906, 0.47534, 0, 0, 0.48912],
    "114": [0, 0.47534, 0, 0, 0.38919],
    "115": [0, 0.47534, 0, 0, 0.44266],
    "116": [0, 0.62119, 0, 0, 0.33301],
    "117": [0, 0.47534, 0, 0, 0.5172],
    "118": [0, 0.52396, 0, 0, 0.5118],
    "119": [0, 0.52396, 0, 0, 0.77351],
    "120": [0.18906, 0.47534, 0, 0, 0.38865],
    "121": [0.18906, 0.47534, 0, 0, 0.49884],
    "122": [0.18906, 0.47534, 0, 0, 0.39054],
    "160": [0, 0, 0, 0, 0.25],
    "8216": [0, 0.69141, 0, 0, 0.21471],
    "8217": [0, 0.69141, 0, 0, 0.21471],
    "58112": [0, 0.62119, 0, 0, 0.49749],
    "58113": [0, 0.62119, 0, 0, 0.4983],
    "58114": [0.18906, 0.69141, 0, 0, 0.33328],
    "58115": [0.18906, 0.69141, 0, 0, 0.32923],
    "58116": [0.18906, 0.47534, 0, 0, 0.50343],
    "58117": [0, 0.69141, 0, 0, 0.33301],
    "58118": [0, 0.62119, 0, 0, 0.33409],
    "58119": [0, 0.47534, 0, 0, 0.50073]
  },
  "Main-Bold": {
    "32": [0, 0, 0, 0, 0.25],
    "33": [0, 0.69444, 0, 0, 0.35],
    "34": [0, 0.69444, 0, 0, 0.60278],
    "35": [0.19444, 0.69444, 0, 0, 0.95833],
    "36": [0.05556, 0.75, 0, 0, 0.575],
    "37": [0.05556, 0.75, 0, 0, 0.95833],
    "38": [0, 0.69444, 0, 0, 0.89444],
    "39": [0, 0.69444, 0, 0, 0.31944],
    "40": [0.25, 0.75, 0, 0, 0.44722],
    "41": [0.25, 0.75, 0, 0, 0.44722],
    "42": [0, 0.75, 0, 0, 0.575],
    "43": [0.13333, 0.63333, 0, 0, 0.89444],
    "44": [0.19444, 0.15556, 0, 0, 0.31944],
    "45": [0, 0.44444, 0, 0, 0.38333],
    "46": [0, 0.15556, 0, 0, 0.31944],
    "47": [0.25, 0.75, 0, 0, 0.575],
    "48": [0, 0.64444, 0, 0, 0.575],
    "49": [0, 0.64444, 0, 0, 0.575],
    "50": [0, 0.64444, 0, 0, 0.575],
    "51": [0, 0.64444, 0, 0, 0.575],
    "52": [0, 0.64444, 0, 0, 0.575],
    "53": [0, 0.64444, 0, 0, 0.575],
    "54": [0, 0.64444, 0, 0, 0.575],
    "55": [0, 0.64444, 0, 0, 0.575],
    "56": [0, 0.64444, 0, 0, 0.575],
    "57": [0, 0.64444, 0, 0, 0.575],
    "58": [0, 0.44444, 0, 0, 0.31944],
    "59": [0.19444, 0.44444, 0, 0, 0.31944],
    "60": [0.08556, 0.58556, 0, 0, 0.89444],
    "61": [-0.10889, 0.39111, 0, 0, 0.89444],
    "62": [0.08556, 0.58556, 0, 0, 0.89444],
    "63": [0, 0.69444, 0, 0, 0.54305],
    "64": [0, 0.69444, 0, 0, 0.89444],
    "65": [0, 0.68611, 0, 0, 0.86944],
    "66": [0, 0.68611, 0, 0, 0.81805],
    "67": [0, 0.68611, 0, 0, 0.83055],
    "68": [0, 0.68611, 0, 0, 0.88194],
    "69": [0, 0.68611, 0, 0, 0.75555],
    "70": [0, 0.68611, 0, 0, 0.72361],
    "71": [0, 0.68611, 0, 0, 0.90416],
    "72": [0, 0.68611, 0, 0, 0.9],
    "73": [0, 0.68611, 0, 0, 0.43611],
    "74": [0, 0.68611, 0, 0, 0.59444],
    "75": [0, 0.68611, 0, 0, 0.90138],
    "76": [0, 0.68611, 0, 0, 0.69166],
    "77": [0, 0.68611, 0, 0, 1.09166],
    "78": [0, 0.68611, 0, 0, 0.9],
    "79": [0, 0.68611, 0, 0, 0.86388],
    "80": [0, 0.68611, 0, 0, 0.78611],
    "81": [0.19444, 0.68611, 0, 0, 0.86388],
    "82": [0, 0.68611, 0, 0, 0.8625],
    "83": [0, 0.68611, 0, 0, 0.63889],
    "84": [0, 0.68611, 0, 0, 0.8],
    "85": [0, 0.68611, 0, 0, 0.88472],
    "86": [0, 0.68611, 0.01597, 0, 0.86944],
    "87": [0, 0.68611, 0.01597, 0, 1.18888],
    "88": [0, 0.68611, 0, 0, 0.86944],
    "89": [0, 0.68611, 0.02875, 0, 0.86944],
    "90": [0, 0.68611, 0, 0, 0.70277],
    "91": [0.25, 0.75, 0, 0, 0.31944],
    "92": [0.25, 0.75, 0, 0, 0.575],
    "93": [0.25, 0.75, 0, 0, 0.31944],
    "94": [0, 0.69444, 0, 0, 0.575],
    "95": [0.31, 0.13444, 0.03194, 0, 0.575],
    "97": [0, 0.44444, 0, 0, 0.55902],
    "98": [0, 0.69444, 0, 0, 0.63889],
    "99": [0, 0.44444, 0, 0, 0.51111],
    "100": [0, 0.69444, 0, 0, 0.63889],
    "101": [0, 0.44444, 0, 0, 0.52708],
    "102": [0, 0.69444, 0.10903, 0, 0.35139],
    "103": [0.19444, 0.44444, 0.01597, 0, 0.575],
    "104": [0, 0.69444, 0, 0, 0.63889],
    "105": [0, 0.69444, 0, 0, 0.31944],
    "106": [0.19444, 0.69444, 0, 0, 0.35139],
    "107": [0, 0.69444, 0, 0, 0.60694],
    "108": [0, 0.69444, 0, 0, 0.31944],
    "109": [0, 0.44444, 0, 0, 0.95833],
    "110": [0, 0.44444, 0, 0, 0.63889],
    "111": [0, 0.44444, 0, 0, 0.575],
    "112": [0.19444, 0.44444, 0, 0, 0.63889],
    "113": [0.19444, 0.44444, 0, 0, 0.60694],
    "114": [0, 0.44444, 0, 0, 0.47361],
    "115": [0, 0.44444, 0, 0, 0.45361],
    "116": [0, 0.63492, 0, 0, 0.44722],
    "117": [0, 0.44444, 0, 0, 0.63889],
    "118": [0, 0.44444, 0.01597, 0, 0.60694],
    "119": [0, 0.44444, 0.01597, 0, 0.83055],
    "120": [0, 0.44444, 0, 0, 0.60694],
    "121": [0.19444, 0.44444, 0.01597, 0, 0.60694],
    "122": [0, 0.44444, 0, 0, 0.51111],
    "123": [0.25, 0.75, 0, 0, 0.575],
    "124": [0.25, 0.75, 0, 0, 0.31944],
    "125": [0.25, 0.75, 0, 0, 0.575],
    "126": [0.35, 0.34444, 0, 0, 0.575],
    "160": [0, 0, 0, 0, 0.25],
    "163": [0, 0.69444, 0, 0, 0.86853],
    "168": [0, 0.69444, 0, 0, 0.575],
    "172": [0, 0.44444, 0, 0, 0.76666],
    "176": [0, 0.69444, 0, 0, 0.86944],
    "177": [0.13333, 0.63333, 0, 0, 0.89444],
    "184": [0.17014, 0, 0, 0, 0.51111],
    "198": [0, 0.68611, 0, 0, 1.04166],
    "215": [0.13333, 0.63333, 0, 0, 0.89444],
    "216": [0.04861, 0.73472, 0, 0, 0.89444],
    "223": [0, 0.69444, 0, 0, 0.59722],
    "230": [0, 0.44444, 0, 0, 0.83055],
    "247": [0.13333, 0.63333, 0, 0, 0.89444],
    "248": [0.09722, 0.54167, 0, 0, 0.575],
    "305": [0, 0.44444, 0, 0, 0.31944],
    "338": [0, 0.68611, 0, 0, 1.16944],
    "339": [0, 0.44444, 0, 0, 0.89444],
    "567": [0.19444, 0.44444, 0, 0, 0.35139],
    "710": [0, 0.69444, 0, 0, 0.575],
    "711": [0, 0.63194, 0, 0, 0.575],
    "713": [0, 0.59611, 0, 0, 0.575],
    "714": [0, 0.69444, 0, 0, 0.575],
    "715": [0, 0.69444, 0, 0, 0.575],
    "728": [0, 0.69444, 0, 0, 0.575],
    "729": [0, 0.69444, 0, 0, 0.31944],
    "730": [0, 0.69444, 0, 0, 0.86944],
    "732": [0, 0.69444, 0, 0, 0.575],
    "733": [0, 0.69444, 0, 0, 0.575],
    "915": [0, 0.68611, 0, 0, 0.69166],
    "916": [0, 0.68611, 0, 0, 0.95833],
    "920": [0, 0.68611, 0, 0, 0.89444],
    "923": [0, 0.68611, 0, 0, 0.80555],
    "926": [0, 0.68611, 0, 0, 0.76666],
    "928": [0, 0.68611, 0, 0, 0.9],
    "931": [0, 0.68611, 0, 0, 0.83055],
    "933": [0, 0.68611, 0, 0, 0.89444],
    "934": [0, 0.68611, 0, 0, 0.83055],
    "936": [0, 0.68611, 0, 0, 0.89444],
    "937": [0, 0.68611, 0, 0, 0.83055],
    "8211": [0, 0.44444, 0.03194, 0, 0.575],
    "8212": [0, 0.44444, 0.03194, 0, 1.14999],
    "8216": [0, 0.69444, 0, 0, 0.31944],
    "8217": [0, 0.69444, 0, 0, 0.31944],
    "8220": [0, 0.69444, 0, 0, 0.60278],
    "8221": [0, 0.69444, 0, 0, 0.60278],
    "8224": [0.19444, 0.69444, 0, 0, 0.51111],
    "8225": [0.19444, 0.69444, 0, 0, 0.51111],
    "8242": [0, 0.55556, 0, 0, 0.34444],
    "8407": [0, 0.72444, 0.15486, 0, 0.575],
    "8463": [0, 0.69444, 0, 0, 0.66759],
    "8465": [0, 0.69444, 0, 0, 0.83055],
    "8467": [0, 0.69444, 0, 0, 0.47361],
    "8472": [0.19444, 0.44444, 0, 0, 0.74027],
    "8476": [0, 0.69444, 0, 0, 0.83055],
    "8501": [0, 0.69444, 0, 0, 0.70277],
    "8592": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8593": [0.19444, 0.69444, 0, 0, 0.575],
    "8594": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8595": [0.19444, 0.69444, 0, 0, 0.575],
    "8596": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8597": [0.25, 0.75, 0, 0, 0.575],
    "8598": [0.19444, 0.69444, 0, 0, 1.14999],
    "8599": [0.19444, 0.69444, 0, 0, 1.14999],
    "8600": [0.19444, 0.69444, 0, 0, 1.14999],
    "8601": [0.19444, 0.69444, 0, 0, 1.14999],
    "8636": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8637": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8640": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8641": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8656": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8657": [0.19444, 0.69444, 0, 0, 0.70277],
    "8658": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8659": [0.19444, 0.69444, 0, 0, 0.70277],
    "8660": [-0.10889, 0.39111, 0, 0, 1.14999],
    "8661": [0.25, 0.75, 0, 0, 0.70277],
    "8704": [0, 0.69444, 0, 0, 0.63889],
    "8706": [0, 0.69444, 0.06389, 0, 0.62847],
    "8707": [0, 0.69444, 0, 0, 0.63889],
    "8709": [0.05556, 0.75, 0, 0, 0.575],
    "8711": [0, 0.68611, 0, 0, 0.95833],
    "8712": [0.08556, 0.58556, 0, 0, 0.76666],
    "8715": [0.08556, 0.58556, 0, 0, 0.76666],
    "8722": [0.13333, 0.63333, 0, 0, 0.89444],
    "8723": [0.13333, 0.63333, 0, 0, 0.89444],
    "8725": [0.25, 0.75, 0, 0, 0.575],
    "8726": [0.25, 0.75, 0, 0, 0.575],
    "8727": [-0.02778, 0.47222, 0, 0, 0.575],
    "8728": [-0.02639, 0.47361, 0, 0, 0.575],
    "8729": [-0.02639, 0.47361, 0, 0, 0.575],
    "8730": [0.18, 0.82, 0, 0, 0.95833],
    "8733": [0, 0.44444, 0, 0, 0.89444],
    "8734": [0, 0.44444, 0, 0, 1.14999],
    "8736": [0, 0.69224, 0, 0, 0.72222],
    "8739": [0.25, 0.75, 0, 0, 0.31944],
    "8741": [0.25, 0.75, 0, 0, 0.575],
    "8743": [0, 0.55556, 0, 0, 0.76666],
    "8744": [0, 0.55556, 0, 0, 0.76666],
    "8745": [0, 0.55556, 0, 0, 0.76666],
    "8746": [0, 0.55556, 0, 0, 0.76666],
    "8747": [0.19444, 0.69444, 0.12778, 0, 0.56875],
    "8764": [-0.10889, 0.39111, 0, 0, 0.89444],
    "8768": [0.19444, 0.69444, 0, 0, 0.31944],
    "8771": [222e-5, 0.50222, 0, 0, 0.89444],
    "8773": [0.027, 0.638, 0, 0, 0.894],
    "8776": [0.02444, 0.52444, 0, 0, 0.89444],
    "8781": [222e-5, 0.50222, 0, 0, 0.89444],
    "8801": [222e-5, 0.50222, 0, 0, 0.89444],
    "8804": [0.19667, 0.69667, 0, 0, 0.89444],
    "8805": [0.19667, 0.69667, 0, 0, 0.89444],
    "8810": [0.08556, 0.58556, 0, 0, 1.14999],
    "8811": [0.08556, 0.58556, 0, 0, 1.14999],
    "8826": [0.08556, 0.58556, 0, 0, 0.89444],
    "8827": [0.08556, 0.58556, 0, 0, 0.89444],
    "8834": [0.08556, 0.58556, 0, 0, 0.89444],
    "8835": [0.08556, 0.58556, 0, 0, 0.89444],
    "8838": [0.19667, 0.69667, 0, 0, 0.89444],
    "8839": [0.19667, 0.69667, 0, 0, 0.89444],
    "8846": [0, 0.55556, 0, 0, 0.76666],
    "8849": [0.19667, 0.69667, 0, 0, 0.89444],
    "8850": [0.19667, 0.69667, 0, 0, 0.89444],
    "8851": [0, 0.55556, 0, 0, 0.76666],
    "8852": [0, 0.55556, 0, 0, 0.76666],
    "8853": [0.13333, 0.63333, 0, 0, 0.89444],
    "8854": [0.13333, 0.63333, 0, 0, 0.89444],
    "8855": [0.13333, 0.63333, 0, 0, 0.89444],
    "8856": [0.13333, 0.63333, 0, 0, 0.89444],
    "8857": [0.13333, 0.63333, 0, 0, 0.89444],
    "8866": [0, 0.69444, 0, 0, 0.70277],
    "8867": [0, 0.69444, 0, 0, 0.70277],
    "8868": [0, 0.69444, 0, 0, 0.89444],
    "8869": [0, 0.69444, 0, 0, 0.89444],
    "8900": [-0.02639, 0.47361, 0, 0, 0.575],
    "8901": [-0.02639, 0.47361, 0, 0, 0.31944],
    "8902": [-0.02778, 0.47222, 0, 0, 0.575],
    "8968": [0.25, 0.75, 0, 0, 0.51111],
    "8969": [0.25, 0.75, 0, 0, 0.51111],
    "8970": [0.25, 0.75, 0, 0, 0.51111],
    "8971": [0.25, 0.75, 0, 0, 0.51111],
    "8994": [-0.13889, 0.36111, 0, 0, 1.14999],
    "8995": [-0.13889, 0.36111, 0, 0, 1.14999],
    "9651": [0.19444, 0.69444, 0, 0, 1.02222],
    "9657": [-0.02778, 0.47222, 0, 0, 0.575],
    "9661": [0.19444, 0.69444, 0, 0, 1.02222],
    "9667": [-0.02778, 0.47222, 0, 0, 0.575],
    "9711": [0.19444, 0.69444, 0, 0, 1.14999],
    "9824": [0.12963, 0.69444, 0, 0, 0.89444],
    "9825": [0.12963, 0.69444, 0, 0, 0.89444],
    "9826": [0.12963, 0.69444, 0, 0, 0.89444],
    "9827": [0.12963, 0.69444, 0, 0, 0.89444],
    "9837": [0, 0.75, 0, 0, 0.44722],
    "9838": [0.19444, 0.69444, 0, 0, 0.44722],
    "9839": [0.19444, 0.69444, 0, 0, 0.44722],
    "10216": [0.25, 0.75, 0, 0, 0.44722],
    "10217": [0.25, 0.75, 0, 0, 0.44722],
    "10815": [0, 0.68611, 0, 0, 0.9],
    "10927": [0.19667, 0.69667, 0, 0, 0.89444],
    "10928": [0.19667, 0.69667, 0, 0, 0.89444],
    "57376": [0.19444, 0.69444, 0, 0, 0]
  },
  "Main-BoldItalic": {
    "32": [0, 0, 0, 0, 0.25],
    "33": [0, 0.69444, 0.11417, 0, 0.38611],
    "34": [0, 0.69444, 0.07939, 0, 0.62055],
    "35": [0.19444, 0.69444, 0.06833, 0, 0.94444],
    "37": [0.05556, 0.75, 0.12861, 0, 0.94444],
    "38": [0, 0.69444, 0.08528, 0, 0.88555],
    "39": [0, 0.69444, 0.12945, 0, 0.35555],
    "40": [0.25, 0.75, 0.15806, 0, 0.47333],
    "41": [0.25, 0.75, 0.03306, 0, 0.47333],
    "42": [0, 0.75, 0.14333, 0, 0.59111],
    "43": [0.10333, 0.60333, 0.03306, 0, 0.88555],
    "44": [0.19444, 0.14722, 0, 0, 0.35555],
    "45": [0, 0.44444, 0.02611, 0, 0.41444],
    "46": [0, 0.14722, 0, 0, 0.35555],
    "47": [0.25, 0.75, 0.15806, 0, 0.59111],
    "48": [0, 0.64444, 0.13167, 0, 0.59111],
    "49": [0, 0.64444, 0.13167, 0, 0.59111],
    "50": [0, 0.64444, 0.13167, 0, 0.59111],
    "51": [0, 0.64444, 0.13167, 0, 0.59111],
    "52": [0.19444, 0.64444, 0.13167, 0, 0.59111],
    "53": [0, 0.64444, 0.13167, 0, 0.59111],
    "54": [0, 0.64444, 0.13167, 0, 0.59111],
    "55": [0.19444, 0.64444, 0.13167, 0, 0.59111],
    "56": [0, 0.64444, 0.13167, 0, 0.59111],
    "57": [0, 0.64444, 0.13167, 0, 0.59111],
    "58": [0, 0.44444, 0.06695, 0, 0.35555],
    "59": [0.19444, 0.44444, 0.06695, 0, 0.35555],
    "61": [-0.10889, 0.39111, 0.06833, 0, 0.88555],
    "63": [0, 0.69444, 0.11472, 0, 0.59111],
    "64": [0, 0.69444, 0.09208, 0, 0.88555],
    "65": [0, 0.68611, 0, 0, 0.86555],
    "66": [0, 0.68611, 0.0992, 0, 0.81666],
    "67": [0, 0.68611, 0.14208, 0, 0.82666],
    "68": [0, 0.68611, 0.09062, 0, 0.87555],
    "69": [0, 0.68611, 0.11431, 0, 0.75666],
    "70": [0, 0.68611, 0.12903, 0, 0.72722],
    "71": [0, 0.68611, 0.07347, 0, 0.89527],
    "72": [0, 0.68611, 0.17208, 0, 0.8961],
    "73": [0, 0.68611, 0.15681, 0, 0.47166],
    "74": [0, 0.68611, 0.145, 0, 0.61055],
    "75": [0, 0.68611, 0.14208, 0, 0.89499],
    "76": [0, 0.68611, 0, 0, 0.69777],
    "77": [0, 0.68611, 0.17208, 0, 1.07277],
    "78": [0, 0.68611, 0.17208, 0, 0.8961],
    "79": [0, 0.68611, 0.09062, 0, 0.85499],
    "80": [0, 0.68611, 0.0992, 0, 0.78721],
    "81": [0.19444, 0.68611, 0.09062, 0, 0.85499],
    "82": [0, 0.68611, 0.02559, 0, 0.85944],
    "83": [0, 0.68611, 0.11264, 0, 0.64999],
    "84": [0, 0.68611, 0.12903, 0, 0.7961],
    "85": [0, 0.68611, 0.17208, 0, 0.88083],
    "86": [0, 0.68611, 0.18625, 0, 0.86555],
    "87": [0, 0.68611, 0.18625, 0, 1.15999],
    "88": [0, 0.68611, 0.15681, 0, 0.86555],
    "89": [0, 0.68611, 0.19803, 0, 0.86555],
    "90": [0, 0.68611, 0.14208, 0, 0.70888],
    "91": [0.25, 0.75, 0.1875, 0, 0.35611],
    "93": [0.25, 0.75, 0.09972, 0, 0.35611],
    "94": [0, 0.69444, 0.06709, 0, 0.59111],
    "95": [0.31, 0.13444, 0.09811, 0, 0.59111],
    "97": [0, 0.44444, 0.09426, 0, 0.59111],
    "98": [0, 0.69444, 0.07861, 0, 0.53222],
    "99": [0, 0.44444, 0.05222, 0, 0.53222],
    "100": [0, 0.69444, 0.10861, 0, 0.59111],
    "101": [0, 0.44444, 0.085, 0, 0.53222],
    "102": [0.19444, 0.69444, 0.21778, 0, 0.4],
    "103": [0.19444, 0.44444, 0.105, 0, 0.53222],
    "104": [0, 0.69444, 0.09426, 0, 0.59111],
    "105": [0, 0.69326, 0.11387, 0, 0.35555],
    "106": [0.19444, 0.69326, 0.1672, 0, 0.35555],
    "107": [0, 0.69444, 0.11111, 0, 0.53222],
    "108": [0, 0.69444, 0.10861, 0, 0.29666],
    "109": [0, 0.44444, 0.09426, 0, 0.94444],
    "110": [0, 0.44444, 0.09426, 0, 0.64999],
    "111": [0, 0.44444, 0.07861, 0, 0.59111],
    "112": [0.19444, 0.44444, 0.07861, 0, 0.59111],
    "113": [0.19444, 0.44444, 0.105, 0, 0.53222],
    "114": [0, 0.44444, 0.11111, 0, 0.50167],
    "115": [0, 0.44444, 0.08167, 0, 0.48694],
    "116": [0, 0.63492, 0.09639, 0, 0.385],
    "117": [0, 0.44444, 0.09426, 0, 0.62055],
    "118": [0, 0.44444, 0.11111, 0, 0.53222],
    "119": [0, 0.44444, 0.11111, 0, 0.76777],
    "120": [0, 0.44444, 0.12583, 0, 0.56055],
    "121": [0.19444, 0.44444, 0.105, 0, 0.56166],
    "122": [0, 0.44444, 0.13889, 0, 0.49055],
    "126": [0.35, 0.34444, 0.11472, 0, 0.59111],
    "160": [0, 0, 0, 0, 0.25],
    "168": [0, 0.69444, 0.11473, 0, 0.59111],
    "176": [0, 0.69444, 0, 0, 0.94888],
    "184": [0.17014, 0, 0, 0, 0.53222],
    "198": [0, 0.68611, 0.11431, 0, 1.02277],
    "216": [0.04861, 0.73472, 0.09062, 0, 0.88555],
    "223": [0.19444, 0.69444, 0.09736, 0, 0.665],
    "230": [0, 0.44444, 0.085, 0, 0.82666],
    "248": [0.09722, 0.54167, 0.09458, 0, 0.59111],
    "305": [0, 0.44444, 0.09426, 0, 0.35555],
    "338": [0, 0.68611, 0.11431, 0, 1.14054],
    "339": [0, 0.44444, 0.085, 0, 0.82666],
    "567": [0.19444, 0.44444, 0.04611, 0, 0.385],
    "710": [0, 0.69444, 0.06709, 0, 0.59111],
    "711": [0, 0.63194, 0.08271, 0, 0.59111],
    "713": [0, 0.59444, 0.10444, 0, 0.59111],
    "714": [0, 0.69444, 0.08528, 0, 0.59111],
    "715": [0, 0.69444, 0, 0, 0.59111],
    "728": [0, 0.69444, 0.10333, 0, 0.59111],
    "729": [0, 0.69444, 0.12945, 0, 0.35555],
    "730": [0, 0.69444, 0, 0, 0.94888],
    "732": [0, 0.69444, 0.11472, 0, 0.59111],
    "733": [0, 0.69444, 0.11472, 0, 0.59111],
    "915": [0, 0.68611, 0.12903, 0, 0.69777],
    "916": [0, 0.68611, 0, 0, 0.94444],
    "920": [0, 0.68611, 0.09062, 0, 0.88555],
    "923": [0, 0.68611, 0, 0, 0.80666],
    "926": [0, 0.68611, 0.15092, 0, 0.76777],
    "928": [0, 0.68611, 0.17208, 0, 0.8961],
    "931": [0, 0.68611, 0.11431, 0, 0.82666],
    "933": [0, 0.68611, 0.10778, 0, 0.88555],
    "934": [0, 0.68611, 0.05632, 0, 0.82666],
    "936": [0, 0.68611, 0.10778, 0, 0.88555],
    "937": [0, 0.68611, 0.0992, 0, 0.82666],
    "8211": [0, 0.44444, 0.09811, 0, 0.59111],
    "8212": [0, 0.44444, 0.09811, 0, 1.18221],
    "8216": [0, 0.69444, 0.12945, 0, 0.35555],
    "8217": [0, 0.69444, 0.12945, 0, 0.35555],
    "8220": [0, 0.69444, 0.16772, 0, 0.62055],
    "8221": [0, 0.69444, 0.07939, 0, 0.62055]
  },
  "Main-Italic": {
    "32": [0, 0, 0, 0, 0.25],
    "33": [0, 0.69444, 0.12417, 0, 0.30667],
    "34": [0, 0.69444, 0.06961, 0, 0.51444],
    "35": [0.19444, 0.69444, 0.06616, 0, 0.81777],
    "37": [0.05556, 0.75, 0.13639, 0, 0.81777],
    "38": [0, 0.69444, 0.09694, 0, 0.76666],
    "39": [0, 0.69444, 0.12417, 0, 0.30667],
    "40": [0.25, 0.75, 0.16194, 0, 0.40889],
    "41": [0.25, 0.75, 0.03694, 0, 0.40889],
    "42": [0, 0.75, 0.14917, 0, 0.51111],
    "43": [0.05667, 0.56167, 0.03694, 0, 0.76666],
    "44": [0.19444, 0.10556, 0, 0, 0.30667],
    "45": [0, 0.43056, 0.02826, 0, 0.35778],
    "46": [0, 0.10556, 0, 0, 0.30667],
    "47": [0.25, 0.75, 0.16194, 0, 0.51111],
    "48": [0, 0.64444, 0.13556, 0, 0.51111],
    "49": [0, 0.64444, 0.13556, 0, 0.51111],
    "50": [0, 0.64444, 0.13556, 0, 0.51111],
    "51": [0, 0.64444, 0.13556, 0, 0.51111],
    "52": [0.19444, 0.64444, 0.13556, 0, 0.51111],
    "53": [0, 0.64444, 0.13556, 0, 0.51111],
    "54": [0, 0.64444, 0.13556, 0, 0.51111],
    "55": [0.19444, 0.64444, 0.13556, 0, 0.51111],
    "56": [0, 0.64444, 0.13556, 0, 0.51111],
    "57": [0, 0.64444, 0.13556, 0, 0.51111],
    "58": [0, 0.43056, 0.0582, 0, 0.30667],
    "59": [0.19444, 0.43056, 0.0582, 0, 0.30667],
    "61": [-0.13313, 0.36687, 0.06616, 0, 0.76666],
    "63": [0, 0.69444, 0.1225, 0, 0.51111],
    "64": [0, 0.69444, 0.09597, 0, 0.76666],
    "65": [0, 0.68333, 0, 0, 0.74333],
    "66": [0, 0.68333, 0.10257, 0, 0.70389],
    "67": [0, 0.68333, 0.14528, 0, 0.71555],
    "68": [0, 0.68333, 0.09403, 0, 0.755],
    "69": [0, 0.68333, 0.12028, 0, 0.67833],
    "70": [0, 0.68333, 0.13305, 0, 0.65277],
    "71": [0, 0.68333, 0.08722, 0, 0.77361],
    "72": [0, 0.68333, 0.16389, 0, 0.74333],
    "73": [0, 0.68333, 0.15806, 0, 0.38555],
    "74": [0, 0.68333, 0.14028, 0, 0.525],
    "75": [0, 0.68333, 0.14528, 0, 0.76888],
    "76": [0, 0.68333, 0, 0, 0.62722],
    "77": [0, 0.68333, 0.16389, 0, 0.89666],
    "78": [0, 0.68333, 0.16389, 0, 0.74333],
    "79": [0, 0.68333, 0.09403, 0, 0.76666],
    "80": [0, 0.68333, 0.10257, 0, 0.67833],
    "81": [0.19444, 0.68333, 0.09403, 0, 0.76666],
    "82": [0, 0.68333, 0.03868, 0, 0.72944],
    "83": [0, 0.68333, 0.11972, 0, 0.56222],
    "84": [0, 0.68333, 0.13305, 0, 0.71555],
    "85": [0, 0.68333, 0.16389, 0, 0.74333],
    "86": [0, 0.68333, 0.18361, 0, 0.74333],
    "87": [0, 0.68333, 0.18361, 0, 0.99888],
    "88": [0, 0.68333, 0.15806, 0, 0.74333],
    "89": [0, 0.68333, 0.19383, 0, 0.74333],
    "90": [0, 0.68333, 0.14528, 0, 0.61333],
    "91": [0.25, 0.75, 0.1875, 0, 0.30667],
    "93": [0.25, 0.75, 0.10528, 0, 0.30667],
    "94": [0, 0.69444, 0.06646, 0, 0.51111],
    "95": [0.31, 0.12056, 0.09208, 0, 0.51111],
    "97": [0, 0.43056, 0.07671, 0, 0.51111],
    "98": [0, 0.69444, 0.06312, 0, 0.46],
    "99": [0, 0.43056, 0.05653, 0, 0.46],
    "100": [0, 0.69444, 0.10333, 0, 0.51111],
    "101": [0, 0.43056, 0.07514, 0, 0.46],
    "102": [0.19444, 0.69444, 0.21194, 0, 0.30667],
    "103": [0.19444, 0.43056, 0.08847, 0, 0.46],
    "104": [0, 0.69444, 0.07671, 0, 0.51111],
    "105": [0, 0.65536, 0.1019, 0, 0.30667],
    "106": [0.19444, 0.65536, 0.14467, 0, 0.30667],
    "107": [0, 0.69444, 0.10764, 0, 0.46],
    "108": [0, 0.69444, 0.10333, 0, 0.25555],
    "109": [0, 0.43056, 0.07671, 0, 0.81777],
    "110": [0, 0.43056, 0.07671, 0, 0.56222],
    "111": [0, 0.43056, 0.06312, 0, 0.51111],
    "112": [0.19444, 0.43056, 0.06312, 0, 0.51111],
    "113": [0.19444, 0.43056, 0.08847, 0, 0.46],
    "114": [0, 0.43056, 0.10764, 0, 0.42166],
    "115": [0, 0.43056, 0.08208, 0, 0.40889],
    "116": [0, 0.61508, 0.09486, 0, 0.33222],
    "117": [0, 0.43056, 0.07671, 0, 0.53666],
    "118": [0, 0.43056, 0.10764, 0, 0.46],
    "119": [0, 0.43056, 0.10764, 0, 0.66444],
    "120": [0, 0.43056, 0.12042, 0, 0.46389],
    "121": [0.19444, 0.43056, 0.08847, 0, 0.48555],
    "122": [0, 0.43056, 0.12292, 0, 0.40889],
    "126": [0.35, 0.31786, 0.11585, 0, 0.51111],
    "160": [0, 0, 0, 0, 0.25],
    "168": [0, 0.66786, 0.10474, 0, 0.51111],
    "176": [0, 0.69444, 0, 0, 0.83129],
    "184": [0.17014, 0, 0, 0, 0.46],
    "198": [0, 0.68333, 0.12028, 0, 0.88277],
    "216": [0.04861, 0.73194, 0.09403, 0, 0.76666],
    "223": [0.19444, 0.69444, 0.10514, 0, 0.53666],
    "230": [0, 0.43056, 0.07514, 0, 0.71555],
    "248": [0.09722, 0.52778, 0.09194, 0, 0.51111],
    "338": [0, 0.68333, 0.12028, 0, 0.98499],
    "339": [0, 0.43056, 0.07514, 0, 0.71555],
    "710": [0, 0.69444, 0.06646, 0, 0.51111],
    "711": [0, 0.62847, 0.08295, 0, 0.51111],
    "713": [0, 0.56167, 0.10333, 0, 0.51111],
    "714": [0, 0.69444, 0.09694, 0, 0.51111],
    "715": [0, 0.69444, 0, 0, 0.51111],
    "728": [0, 0.69444, 0.10806, 0, 0.51111],
    "729": [0, 0.66786, 0.11752, 0, 0.30667],
    "730": [0, 0.69444, 0, 0, 0.83129],
    "732": [0, 0.66786, 0.11585, 0, 0.51111],
    "733": [0, 0.69444, 0.1225, 0, 0.51111],
    "915": [0, 0.68333, 0.13305, 0, 0.62722],
    "916": [0, 0.68333, 0, 0, 0.81777],
    "920": [0, 0.68333, 0.09403, 0, 0.76666],
    "923": [0, 0.68333, 0, 0, 0.69222],
    "926": [0, 0.68333, 0.15294, 0, 0.66444],
    "928": [0, 0.68333, 0.16389, 0, 0.74333],
    "931": [0, 0.68333, 0.12028, 0, 0.71555],
    "933": [0, 0.68333, 0.11111, 0, 0.76666],
    "934": [0, 0.68333, 0.05986, 0, 0.71555],
    "936": [0, 0.68333, 0.11111, 0, 0.76666],
    "937": [0, 0.68333, 0.10257, 0, 0.71555],
    "8211": [0, 0.43056, 0.09208, 0, 0.51111],
    "8212": [0, 0.43056, 0.09208, 0, 1.02222],
    "8216": [0, 0.69444, 0.12417, 0, 0.30667],
    "8217": [0, 0.69444, 0.12417, 0, 0.30667],
    "8220": [0, 0.69444, 0.1685, 0, 0.51444],
    "8221": [0, 0.69444, 0.06961, 0, 0.51444],
    "8463": [0, 0.68889, 0, 0, 0.54028]
  },
  "Main-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "33": [0, 0.69444, 0, 0, 0.27778],
    "34": [0, 0.69444, 0, 0, 0.5],
    "35": [0.19444, 0.69444, 0, 0, 0.83334],
    "36": [0.05556, 0.75, 0, 0, 0.5],
    "37": [0.05556, 0.75, 0, 0, 0.83334],
    "38": [0, 0.69444, 0, 0, 0.77778],
    "39": [0, 0.69444, 0, 0, 0.27778],
    "40": [0.25, 0.75, 0, 0, 0.38889],
    "41": [0.25, 0.75, 0, 0, 0.38889],
    "42": [0, 0.75, 0, 0, 0.5],
    "43": [0.08333, 0.58333, 0, 0, 0.77778],
    "44": [0.19444, 0.10556, 0, 0, 0.27778],
    "45": [0, 0.43056, 0, 0, 0.33333],
    "46": [0, 0.10556, 0, 0, 0.27778],
    "47": [0.25, 0.75, 0, 0, 0.5],
    "48": [0, 0.64444, 0, 0, 0.5],
    "49": [0, 0.64444, 0, 0, 0.5],
    "50": [0, 0.64444, 0, 0, 0.5],
    "51": [0, 0.64444, 0, 0, 0.5],
    "52": [0, 0.64444, 0, 0, 0.5],
    "53": [0, 0.64444, 0, 0, 0.5],
    "54": [0, 0.64444, 0, 0, 0.5],
    "55": [0, 0.64444, 0, 0, 0.5],
    "56": [0, 0.64444, 0, 0, 0.5],
    "57": [0, 0.64444, 0, 0, 0.5],
    "58": [0, 0.43056, 0, 0, 0.27778],
    "59": [0.19444, 0.43056, 0, 0, 0.27778],
    "60": [0.0391, 0.5391, 0, 0, 0.77778],
    "61": [-0.13313, 0.36687, 0, 0, 0.77778],
    "62": [0.0391, 0.5391, 0, 0, 0.77778],
    "63": [0, 0.69444, 0, 0, 0.47222],
    "64": [0, 0.69444, 0, 0, 0.77778],
    "65": [0, 0.68333, 0, 0, 0.75],
    "66": [0, 0.68333, 0, 0, 0.70834],
    "67": [0, 0.68333, 0, 0, 0.72222],
    "68": [0, 0.68333, 0, 0, 0.76389],
    "69": [0, 0.68333, 0, 0, 0.68056],
    "70": [0, 0.68333, 0, 0, 0.65278],
    "71": [0, 0.68333, 0, 0, 0.78472],
    "72": [0, 0.68333, 0, 0, 0.75],
    "73": [0, 0.68333, 0, 0, 0.36111],
    "74": [0, 0.68333, 0, 0, 0.51389],
    "75": [0, 0.68333, 0, 0, 0.77778],
    "76": [0, 0.68333, 0, 0, 0.625],
    "77": [0, 0.68333, 0, 0, 0.91667],
    "78": [0, 0.68333, 0, 0, 0.75],
    "79": [0, 0.68333, 0, 0, 0.77778],
    "80": [0, 0.68333, 0, 0, 0.68056],
    "81": [0.19444, 0.68333, 0, 0, 0.77778],
    "82": [0, 0.68333, 0, 0, 0.73611],
    "83": [0, 0.68333, 0, 0, 0.55556],
    "84": [0, 0.68333, 0, 0, 0.72222],
    "85": [0, 0.68333, 0, 0, 0.75],
    "86": [0, 0.68333, 0.01389, 0, 0.75],
    "87": [0, 0.68333, 0.01389, 0, 1.02778],
    "88": [0, 0.68333, 0, 0, 0.75],
    "89": [0, 0.68333, 0.025, 0, 0.75],
    "90": [0, 0.68333, 0, 0, 0.61111],
    "91": [0.25, 0.75, 0, 0, 0.27778],
    "92": [0.25, 0.75, 0, 0, 0.5],
    "93": [0.25, 0.75, 0, 0, 0.27778],
    "94": [0, 0.69444, 0, 0, 0.5],
    "95": [0.31, 0.12056, 0.02778, 0, 0.5],
    "97": [0, 0.43056, 0, 0, 0.5],
    "98": [0, 0.69444, 0, 0, 0.55556],
    "99": [0, 0.43056, 0, 0, 0.44445],
    "100": [0, 0.69444, 0, 0, 0.55556],
    "101": [0, 0.43056, 0, 0, 0.44445],
    "102": [0, 0.69444, 0.07778, 0, 0.30556],
    "103": [0.19444, 0.43056, 0.01389, 0, 0.5],
    "104": [0, 0.69444, 0, 0, 0.55556],
    "105": [0, 0.66786, 0, 0, 0.27778],
    "106": [0.19444, 0.66786, 0, 0, 0.30556],
    "107": [0, 0.69444, 0, 0, 0.52778],
    "108": [0, 0.69444, 0, 0, 0.27778],
    "109": [0, 0.43056, 0, 0, 0.83334],
    "110": [0, 0.43056, 0, 0, 0.55556],
    "111": [0, 0.43056, 0, 0, 0.5],
    "112": [0.19444, 0.43056, 0, 0, 0.55556],
    "113": [0.19444, 0.43056, 0, 0, 0.52778],
    "114": [0, 0.43056, 0, 0, 0.39167],
    "115": [0, 0.43056, 0, 0, 0.39445],
    "116": [0, 0.61508, 0, 0, 0.38889],
    "117": [0, 0.43056, 0, 0, 0.55556],
    "118": [0, 0.43056, 0.01389, 0, 0.52778],
    "119": [0, 0.43056, 0.01389, 0, 0.72222],
    "120": [0, 0.43056, 0, 0, 0.52778],
    "121": [0.19444, 0.43056, 0.01389, 0, 0.52778],
    "122": [0, 0.43056, 0, 0, 0.44445],
    "123": [0.25, 0.75, 0, 0, 0.5],
    "124": [0.25, 0.75, 0, 0, 0.27778],
    "125": [0.25, 0.75, 0, 0, 0.5],
    "126": [0.35, 0.31786, 0, 0, 0.5],
    "160": [0, 0, 0, 0, 0.25],
    "163": [0, 0.69444, 0, 0, 0.76909],
    "167": [0.19444, 0.69444, 0, 0, 0.44445],
    "168": [0, 0.66786, 0, 0, 0.5],
    "172": [0, 0.43056, 0, 0, 0.66667],
    "176": [0, 0.69444, 0, 0, 0.75],
    "177": [0.08333, 0.58333, 0, 0, 0.77778],
    "182": [0.19444, 0.69444, 0, 0, 0.61111],
    "184": [0.17014, 0, 0, 0, 0.44445],
    "198": [0, 0.68333, 0, 0, 0.90278],
    "215": [0.08333, 0.58333, 0, 0, 0.77778],
    "216": [0.04861, 0.73194, 0, 0, 0.77778],
    "223": [0, 0.69444, 0, 0, 0.5],
    "230": [0, 0.43056, 0, 0, 0.72222],
    "247": [0.08333, 0.58333, 0, 0, 0.77778],
    "248": [0.09722, 0.52778, 0, 0, 0.5],
    "305": [0, 0.43056, 0, 0, 0.27778],
    "338": [0, 0.68333, 0, 0, 1.01389],
    "339": [0, 0.43056, 0, 0, 0.77778],
    "567": [0.19444, 0.43056, 0, 0, 0.30556],
    "710": [0, 0.69444, 0, 0, 0.5],
    "711": [0, 0.62847, 0, 0, 0.5],
    "713": [0, 0.56778, 0, 0, 0.5],
    "714": [0, 0.69444, 0, 0, 0.5],
    "715": [0, 0.69444, 0, 0, 0.5],
    "728": [0, 0.69444, 0, 0, 0.5],
    "729": [0, 0.66786, 0, 0, 0.27778],
    "730": [0, 0.69444, 0, 0, 0.75],
    "732": [0, 0.66786, 0, 0, 0.5],
    "733": [0, 0.69444, 0, 0, 0.5],
    "915": [0, 0.68333, 0, 0, 0.625],
    "916": [0, 0.68333, 0, 0, 0.83334],
    "920": [0, 0.68333, 0, 0, 0.77778],
    "923": [0, 0.68333, 0, 0, 0.69445],
    "926": [0, 0.68333, 0, 0, 0.66667],
    "928": [0, 0.68333, 0, 0, 0.75],
    "931": [0, 0.68333, 0, 0, 0.72222],
    "933": [0, 0.68333, 0, 0, 0.77778],
    "934": [0, 0.68333, 0, 0, 0.72222],
    "936": [0, 0.68333, 0, 0, 0.77778],
    "937": [0, 0.68333, 0, 0, 0.72222],
    "8211": [0, 0.43056, 0.02778, 0, 0.5],
    "8212": [0, 0.43056, 0.02778, 0, 1],
    "8216": [0, 0.69444, 0, 0, 0.27778],
    "8217": [0, 0.69444, 0, 0, 0.27778],
    "8220": [0, 0.69444, 0, 0, 0.5],
    "8221": [0, 0.69444, 0, 0, 0.5],
    "8224": [0.19444, 0.69444, 0, 0, 0.44445],
    "8225": [0.19444, 0.69444, 0, 0, 0.44445],
    "8230": [0, 0.123, 0, 0, 1.172],
    "8242": [0, 0.55556, 0, 0, 0.275],
    "8407": [0, 0.71444, 0.15382, 0, 0.5],
    "8463": [0, 0.68889, 0, 0, 0.54028],
    "8465": [0, 0.69444, 0, 0, 0.72222],
    "8467": [0, 0.69444, 0, 0.11111, 0.41667],
    "8472": [0.19444, 0.43056, 0, 0.11111, 0.63646],
    "8476": [0, 0.69444, 0, 0, 0.72222],
    "8501": [0, 0.69444, 0, 0, 0.61111],
    "8592": [-0.13313, 0.36687, 0, 0, 1],
    "8593": [0.19444, 0.69444, 0, 0, 0.5],
    "8594": [-0.13313, 0.36687, 0, 0, 1],
    "8595": [0.19444, 0.69444, 0, 0, 0.5],
    "8596": [-0.13313, 0.36687, 0, 0, 1],
    "8597": [0.25, 0.75, 0, 0, 0.5],
    "8598": [0.19444, 0.69444, 0, 0, 1],
    "8599": [0.19444, 0.69444, 0, 0, 1],
    "8600": [0.19444, 0.69444, 0, 0, 1],
    "8601": [0.19444, 0.69444, 0, 0, 1],
    "8614": [0.011, 0.511, 0, 0, 1],
    "8617": [0.011, 0.511, 0, 0, 1.126],
    "8618": [0.011, 0.511, 0, 0, 1.126],
    "8636": [-0.13313, 0.36687, 0, 0, 1],
    "8637": [-0.13313, 0.36687, 0, 0, 1],
    "8640": [-0.13313, 0.36687, 0, 0, 1],
    "8641": [-0.13313, 0.36687, 0, 0, 1],
    "8652": [0.011, 0.671, 0, 0, 1],
    "8656": [-0.13313, 0.36687, 0, 0, 1],
    "8657": [0.19444, 0.69444, 0, 0, 0.61111],
    "8658": [-0.13313, 0.36687, 0, 0, 1],
    "8659": [0.19444, 0.69444, 0, 0, 0.61111],
    "8660": [-0.13313, 0.36687, 0, 0, 1],
    "8661": [0.25, 0.75, 0, 0, 0.61111],
    "8704": [0, 0.69444, 0, 0, 0.55556],
    "8706": [0, 0.69444, 0.05556, 0.08334, 0.5309],
    "8707": [0, 0.69444, 0, 0, 0.55556],
    "8709": [0.05556, 0.75, 0, 0, 0.5],
    "8711": [0, 0.68333, 0, 0, 0.83334],
    "8712": [0.0391, 0.5391, 0, 0, 0.66667],
    "8715": [0.0391, 0.5391, 0, 0, 0.66667],
    "8722": [0.08333, 0.58333, 0, 0, 0.77778],
    "8723": [0.08333, 0.58333, 0, 0, 0.77778],
    "8725": [0.25, 0.75, 0, 0, 0.5],
    "8726": [0.25, 0.75, 0, 0, 0.5],
    "8727": [-0.03472, 0.46528, 0, 0, 0.5],
    "8728": [-0.05555, 0.44445, 0, 0, 0.5],
    "8729": [-0.05555, 0.44445, 0, 0, 0.5],
    "8730": [0.2, 0.8, 0, 0, 0.83334],
    "8733": [0, 0.43056, 0, 0, 0.77778],
    "8734": [0, 0.43056, 0, 0, 1],
    "8736": [0, 0.69224, 0, 0, 0.72222],
    "8739": [0.25, 0.75, 0, 0, 0.27778],
    "8741": [0.25, 0.75, 0, 0, 0.5],
    "8743": [0, 0.55556, 0, 0, 0.66667],
    "8744": [0, 0.55556, 0, 0, 0.66667],
    "8745": [0, 0.55556, 0, 0, 0.66667],
    "8746": [0, 0.55556, 0, 0, 0.66667],
    "8747": [0.19444, 0.69444, 0.11111, 0, 0.41667],
    "8764": [-0.13313, 0.36687, 0, 0, 0.77778],
    "8768": [0.19444, 0.69444, 0, 0, 0.27778],
    "8771": [-0.03625, 0.46375, 0, 0, 0.77778],
    "8773": [-0.022, 0.589, 0, 0, 0.778],
    "8776": [-0.01688, 0.48312, 0, 0, 0.77778],
    "8781": [-0.03625, 0.46375, 0, 0, 0.77778],
    "8784": [-0.133, 0.673, 0, 0, 0.778],
    "8801": [-0.03625, 0.46375, 0, 0, 0.77778],
    "8804": [0.13597, 0.63597, 0, 0, 0.77778],
    "8805": [0.13597, 0.63597, 0, 0, 0.77778],
    "8810": [0.0391, 0.5391, 0, 0, 1],
    "8811": [0.0391, 0.5391, 0, 0, 1],
    "8826": [0.0391, 0.5391, 0, 0, 0.77778],
    "8827": [0.0391, 0.5391, 0, 0, 0.77778],
    "8834": [0.0391, 0.5391, 0, 0, 0.77778],
    "8835": [0.0391, 0.5391, 0, 0, 0.77778],
    "8838": [0.13597, 0.63597, 0, 0, 0.77778],
    "8839": [0.13597, 0.63597, 0, 0, 0.77778],
    "8846": [0, 0.55556, 0, 0, 0.66667],
    "8849": [0.13597, 0.63597, 0, 0, 0.77778],
    "8850": [0.13597, 0.63597, 0, 0, 0.77778],
    "8851": [0, 0.55556, 0, 0, 0.66667],
    "8852": [0, 0.55556, 0, 0, 0.66667],
    "8853": [0.08333, 0.58333, 0, 0, 0.77778],
    "8854": [0.08333, 0.58333, 0, 0, 0.77778],
    "8855": [0.08333, 0.58333, 0, 0, 0.77778],
    "8856": [0.08333, 0.58333, 0, 0, 0.77778],
    "8857": [0.08333, 0.58333, 0, 0, 0.77778],
    "8866": [0, 0.69444, 0, 0, 0.61111],
    "8867": [0, 0.69444, 0, 0, 0.61111],
    "8868": [0, 0.69444, 0, 0, 0.77778],
    "8869": [0, 0.69444, 0, 0, 0.77778],
    "8872": [0.249, 0.75, 0, 0, 0.867],
    "8900": [-0.05555, 0.44445, 0, 0, 0.5],
    "8901": [-0.05555, 0.44445, 0, 0, 0.27778],
    "8902": [-0.03472, 0.46528, 0, 0, 0.5],
    "8904": [5e-3, 0.505, 0, 0, 0.9],
    "8942": [0.03, 0.903, 0, 0, 0.278],
    "8943": [-0.19, 0.313, 0, 0, 1.172],
    "8945": [-0.1, 0.823, 0, 0, 1.282],
    "8968": [0.25, 0.75, 0, 0, 0.44445],
    "8969": [0.25, 0.75, 0, 0, 0.44445],
    "8970": [0.25, 0.75, 0, 0, 0.44445],
    "8971": [0.25, 0.75, 0, 0, 0.44445],
    "8994": [-0.14236, 0.35764, 0, 0, 1],
    "8995": [-0.14236, 0.35764, 0, 0, 1],
    "9136": [0.244, 0.744, 0, 0, 0.412],
    "9137": [0.244, 0.745, 0, 0, 0.412],
    "9651": [0.19444, 0.69444, 0, 0, 0.88889],
    "9657": [-0.03472, 0.46528, 0, 0, 0.5],
    "9661": [0.19444, 0.69444, 0, 0, 0.88889],
    "9667": [-0.03472, 0.46528, 0, 0, 0.5],
    "9711": [0.19444, 0.69444, 0, 0, 1],
    "9824": [0.12963, 0.69444, 0, 0, 0.77778],
    "9825": [0.12963, 0.69444, 0, 0, 0.77778],
    "9826": [0.12963, 0.69444, 0, 0, 0.77778],
    "9827": [0.12963, 0.69444, 0, 0, 0.77778],
    "9837": [0, 0.75, 0, 0, 0.38889],
    "9838": [0.19444, 0.69444, 0, 0, 0.38889],
    "9839": [0.19444, 0.69444, 0, 0, 0.38889],
    "10216": [0.25, 0.75, 0, 0, 0.38889],
    "10217": [0.25, 0.75, 0, 0, 0.38889],
    "10222": [0.244, 0.744, 0, 0, 0.412],
    "10223": [0.244, 0.745, 0, 0, 0.412],
    "10229": [0.011, 0.511, 0, 0, 1.609],
    "10230": [0.011, 0.511, 0, 0, 1.638],
    "10231": [0.011, 0.511, 0, 0, 1.859],
    "10232": [0.024, 0.525, 0, 0, 1.609],
    "10233": [0.024, 0.525, 0, 0, 1.638],
    "10234": [0.024, 0.525, 0, 0, 1.858],
    "10236": [0.011, 0.511, 0, 0, 1.638],
    "10815": [0, 0.68333, 0, 0, 0.75],
    "10927": [0.13597, 0.63597, 0, 0, 0.77778],
    "10928": [0.13597, 0.63597, 0, 0, 0.77778],
    "57376": [0.19444, 0.69444, 0, 0, 0]
  },
  "Math-BoldItalic": {
    "32": [0, 0, 0, 0, 0.25],
    "48": [0, 0.44444, 0, 0, 0.575],
    "49": [0, 0.44444, 0, 0, 0.575],
    "50": [0, 0.44444, 0, 0, 0.575],
    "51": [0.19444, 0.44444, 0, 0, 0.575],
    "52": [0.19444, 0.44444, 0, 0, 0.575],
    "53": [0.19444, 0.44444, 0, 0, 0.575],
    "54": [0, 0.64444, 0, 0, 0.575],
    "55": [0.19444, 0.44444, 0, 0, 0.575],
    "56": [0, 0.64444, 0, 0, 0.575],
    "57": [0.19444, 0.44444, 0, 0, 0.575],
    "65": [0, 0.68611, 0, 0, 0.86944],
    "66": [0, 0.68611, 0.04835, 0, 0.8664],
    "67": [0, 0.68611, 0.06979, 0, 0.81694],
    "68": [0, 0.68611, 0.03194, 0, 0.93812],
    "69": [0, 0.68611, 0.05451, 0, 0.81007],
    "70": [0, 0.68611, 0.15972, 0, 0.68889],
    "71": [0, 0.68611, 0, 0, 0.88673],
    "72": [0, 0.68611, 0.08229, 0, 0.98229],
    "73": [0, 0.68611, 0.07778, 0, 0.51111],
    "74": [0, 0.68611, 0.10069, 0, 0.63125],
    "75": [0, 0.68611, 0.06979, 0, 0.97118],
    "76": [0, 0.68611, 0, 0, 0.75555],
    "77": [0, 0.68611, 0.11424, 0, 1.14201],
    "78": [0, 0.68611, 0.11424, 0, 0.95034],
    "79": [0, 0.68611, 0.03194, 0, 0.83666],
    "80": [0, 0.68611, 0.15972, 0, 0.72309],
    "81": [0.19444, 0.68611, 0, 0, 0.86861],
    "82": [0, 0.68611, 421e-5, 0, 0.87235],
    "83": [0, 0.68611, 0.05382, 0, 0.69271],
    "84": [0, 0.68611, 0.15972, 0, 0.63663],
    "85": [0, 0.68611, 0.11424, 0, 0.80027],
    "86": [0, 0.68611, 0.25555, 0, 0.67778],
    "87": [0, 0.68611, 0.15972, 0, 1.09305],
    "88": [0, 0.68611, 0.07778, 0, 0.94722],
    "89": [0, 0.68611, 0.25555, 0, 0.67458],
    "90": [0, 0.68611, 0.06979, 0, 0.77257],
    "97": [0, 0.44444, 0, 0, 0.63287],
    "98": [0, 0.69444, 0, 0, 0.52083],
    "99": [0, 0.44444, 0, 0, 0.51342],
    "100": [0, 0.69444, 0, 0, 0.60972],
    "101": [0, 0.44444, 0, 0, 0.55361],
    "102": [0.19444, 0.69444, 0.11042, 0, 0.56806],
    "103": [0.19444, 0.44444, 0.03704, 0, 0.5449],
    "104": [0, 0.69444, 0, 0, 0.66759],
    "105": [0, 0.69326, 0, 0, 0.4048],
    "106": [0.19444, 0.69326, 0.0622, 0, 0.47083],
    "107": [0, 0.69444, 0.01852, 0, 0.6037],
    "108": [0, 0.69444, 88e-4, 0, 0.34815],
    "109": [0, 0.44444, 0, 0, 1.0324],
    "110": [0, 0.44444, 0, 0, 0.71296],
    "111": [0, 0.44444, 0, 0, 0.58472],
    "112": [0.19444, 0.44444, 0, 0, 0.60092],
    "113": [0.19444, 0.44444, 0.03704, 0, 0.54213],
    "114": [0, 0.44444, 0.03194, 0, 0.5287],
    "115": [0, 0.44444, 0, 0, 0.53125],
    "116": [0, 0.63492, 0, 0, 0.41528],
    "117": [0, 0.44444, 0, 0, 0.68102],
    "118": [0, 0.44444, 0.03704, 0, 0.56666],
    "119": [0, 0.44444, 0.02778, 0, 0.83148],
    "120": [0, 0.44444, 0, 0, 0.65903],
    "121": [0.19444, 0.44444, 0.03704, 0, 0.59028],
    "122": [0, 0.44444, 0.04213, 0, 0.55509],
    "160": [0, 0, 0, 0, 0.25],
    "915": [0, 0.68611, 0.15972, 0, 0.65694],
    "916": [0, 0.68611, 0, 0, 0.95833],
    "920": [0, 0.68611, 0.03194, 0, 0.86722],
    "923": [0, 0.68611, 0, 0, 0.80555],
    "926": [0, 0.68611, 0.07458, 0, 0.84125],
    "928": [0, 0.68611, 0.08229, 0, 0.98229],
    "931": [0, 0.68611, 0.05451, 0, 0.88507],
    "933": [0, 0.68611, 0.15972, 0, 0.67083],
    "934": [0, 0.68611, 0, 0, 0.76666],
    "936": [0, 0.68611, 0.11653, 0, 0.71402],
    "937": [0, 0.68611, 0.04835, 0, 0.8789],
    "945": [0, 0.44444, 0, 0, 0.76064],
    "946": [0.19444, 0.69444, 0.03403, 0, 0.65972],
    "947": [0.19444, 0.44444, 0.06389, 0, 0.59003],
    "948": [0, 0.69444, 0.03819, 0, 0.52222],
    "949": [0, 0.44444, 0, 0, 0.52882],
    "950": [0.19444, 0.69444, 0.06215, 0, 0.50833],
    "951": [0.19444, 0.44444, 0.03704, 0, 0.6],
    "952": [0, 0.69444, 0.03194, 0, 0.5618],
    "953": [0, 0.44444, 0, 0, 0.41204],
    "954": [0, 0.44444, 0, 0, 0.66759],
    "955": [0, 0.69444, 0, 0, 0.67083],
    "956": [0.19444, 0.44444, 0, 0, 0.70787],
    "957": [0, 0.44444, 0.06898, 0, 0.57685],
    "958": [0.19444, 0.69444, 0.03021, 0, 0.50833],
    "959": [0, 0.44444, 0, 0, 0.58472],
    "960": [0, 0.44444, 0.03704, 0, 0.68241],
    "961": [0.19444, 0.44444, 0, 0, 0.6118],
    "962": [0.09722, 0.44444, 0.07917, 0, 0.42361],
    "963": [0, 0.44444, 0.03704, 0, 0.68588],
    "964": [0, 0.44444, 0.13472, 0, 0.52083],
    "965": [0, 0.44444, 0.03704, 0, 0.63055],
    "966": [0.19444, 0.44444, 0, 0, 0.74722],
    "967": [0.19444, 0.44444, 0, 0, 0.71805],
    "968": [0.19444, 0.69444, 0.03704, 0, 0.75833],
    "969": [0, 0.44444, 0.03704, 0, 0.71782],
    "977": [0, 0.69444, 0, 0, 0.69155],
    "981": [0.19444, 0.69444, 0, 0, 0.7125],
    "982": [0, 0.44444, 0.03194, 0, 0.975],
    "1009": [0.19444, 0.44444, 0, 0, 0.6118],
    "1013": [0, 0.44444, 0, 0, 0.48333],
    "57649": [0, 0.44444, 0, 0, 0.39352],
    "57911": [0.19444, 0.44444, 0, 0, 0.43889]
  },
  "Math-Italic": {
    "32": [0, 0, 0, 0, 0.25],
    "48": [0, 0.43056, 0, 0, 0.5],
    "49": [0, 0.43056, 0, 0, 0.5],
    "50": [0, 0.43056, 0, 0, 0.5],
    "51": [0.19444, 0.43056, 0, 0, 0.5],
    "52": [0.19444, 0.43056, 0, 0, 0.5],
    "53": [0.19444, 0.43056, 0, 0, 0.5],
    "54": [0, 0.64444, 0, 0, 0.5],
    "55": [0.19444, 0.43056, 0, 0, 0.5],
    "56": [0, 0.64444, 0, 0, 0.5],
    "57": [0.19444, 0.43056, 0, 0, 0.5],
    "65": [0, 0.68333, 0, 0.13889, 0.75],
    "66": [0, 0.68333, 0.05017, 0.08334, 0.75851],
    "67": [0, 0.68333, 0.07153, 0.08334, 0.71472],
    "68": [0, 0.68333, 0.02778, 0.05556, 0.82792],
    "69": [0, 0.68333, 0.05764, 0.08334, 0.7382],
    "70": [0, 0.68333, 0.13889, 0.08334, 0.64306],
    "71": [0, 0.68333, 0, 0.08334, 0.78625],
    "72": [0, 0.68333, 0.08125, 0.05556, 0.83125],
    "73": [0, 0.68333, 0.07847, 0.11111, 0.43958],
    "74": [0, 0.68333, 0.09618, 0.16667, 0.55451],
    "75": [0, 0.68333, 0.07153, 0.05556, 0.84931],
    "76": [0, 0.68333, 0, 0.02778, 0.68056],
    "77": [0, 0.68333, 0.10903, 0.08334, 0.97014],
    "78": [0, 0.68333, 0.10903, 0.08334, 0.80347],
    "79": [0, 0.68333, 0.02778, 0.08334, 0.76278],
    "80": [0, 0.68333, 0.13889, 0.08334, 0.64201],
    "81": [0.19444, 0.68333, 0, 0.08334, 0.79056],
    "82": [0, 0.68333, 773e-5, 0.08334, 0.75929],
    "83": [0, 0.68333, 0.05764, 0.08334, 0.6132],
    "84": [0, 0.68333, 0.13889, 0.08334, 0.58438],
    "85": [0, 0.68333, 0.10903, 0.02778, 0.68278],
    "86": [0, 0.68333, 0.22222, 0, 0.58333],
    "87": [0, 0.68333, 0.13889, 0, 0.94445],
    "88": [0, 0.68333, 0.07847, 0.08334, 0.82847],
    "89": [0, 0.68333, 0.22222, 0, 0.58056],
    "90": [0, 0.68333, 0.07153, 0.08334, 0.68264],
    "97": [0, 0.43056, 0, 0, 0.52859],
    "98": [0, 0.69444, 0, 0, 0.42917],
    "99": [0, 0.43056, 0, 0.05556, 0.43276],
    "100": [0, 0.69444, 0, 0.16667, 0.52049],
    "101": [0, 0.43056, 0, 0.05556, 0.46563],
    "102": [0.19444, 0.69444, 0.10764, 0.16667, 0.48959],
    "103": [0.19444, 0.43056, 0.03588, 0.02778, 0.47697],
    "104": [0, 0.69444, 0, 0, 0.57616],
    "105": [0, 0.65952, 0, 0, 0.34451],
    "106": [0.19444, 0.65952, 0.05724, 0, 0.41181],
    "107": [0, 0.69444, 0.03148, 0, 0.5206],
    "108": [0, 0.69444, 0.01968, 0.08334, 0.29838],
    "109": [0, 0.43056, 0, 0, 0.87801],
    "110": [0, 0.43056, 0, 0, 0.60023],
    "111": [0, 0.43056, 0, 0.05556, 0.48472],
    "112": [0.19444, 0.43056, 0, 0.08334, 0.50313],
    "113": [0.19444, 0.43056, 0.03588, 0.08334, 0.44641],
    "114": [0, 0.43056, 0.02778, 0.05556, 0.45116],
    "115": [0, 0.43056, 0, 0.05556, 0.46875],
    "116": [0, 0.61508, 0, 0.08334, 0.36111],
    "117": [0, 0.43056, 0, 0.02778, 0.57246],
    "118": [0, 0.43056, 0.03588, 0.02778, 0.48472],
    "119": [0, 0.43056, 0.02691, 0.08334, 0.71592],
    "120": [0, 0.43056, 0, 0.02778, 0.57153],
    "121": [0.19444, 0.43056, 0.03588, 0.05556, 0.49028],
    "122": [0, 0.43056, 0.04398, 0.05556, 0.46505],
    "160": [0, 0, 0, 0, 0.25],
    "915": [0, 0.68333, 0.13889, 0.08334, 0.61528],
    "916": [0, 0.68333, 0, 0.16667, 0.83334],
    "920": [0, 0.68333, 0.02778, 0.08334, 0.76278],
    "923": [0, 0.68333, 0, 0.16667, 0.69445],
    "926": [0, 0.68333, 0.07569, 0.08334, 0.74236],
    "928": [0, 0.68333, 0.08125, 0.05556, 0.83125],
    "931": [0, 0.68333, 0.05764, 0.08334, 0.77986],
    "933": [0, 0.68333, 0.13889, 0.05556, 0.58333],
    "934": [0, 0.68333, 0, 0.08334, 0.66667],
    "936": [0, 0.68333, 0.11, 0.05556, 0.61222],
    "937": [0, 0.68333, 0.05017, 0.08334, 0.7724],
    "945": [0, 0.43056, 37e-4, 0.02778, 0.6397],
    "946": [0.19444, 0.69444, 0.05278, 0.08334, 0.56563],
    "947": [0.19444, 0.43056, 0.05556, 0, 0.51773],
    "948": [0, 0.69444, 0.03785, 0.05556, 0.44444],
    "949": [0, 0.43056, 0, 0.08334, 0.46632],
    "950": [0.19444, 0.69444, 0.07378, 0.08334, 0.4375],
    "951": [0.19444, 0.43056, 0.03588, 0.05556, 0.49653],
    "952": [0, 0.69444, 0.02778, 0.08334, 0.46944],
    "953": [0, 0.43056, 0, 0.05556, 0.35394],
    "954": [0, 0.43056, 0, 0, 0.57616],
    "955": [0, 0.69444, 0, 0, 0.58334],
    "956": [0.19444, 0.43056, 0, 0.02778, 0.60255],
    "957": [0, 0.43056, 0.06366, 0.02778, 0.49398],
    "958": [0.19444, 0.69444, 0.04601, 0.11111, 0.4375],
    "959": [0, 0.43056, 0, 0.05556, 0.48472],
    "960": [0, 0.43056, 0.03588, 0, 0.57003],
    "961": [0.19444, 0.43056, 0, 0.08334, 0.51702],
    "962": [0.09722, 0.43056, 0.07986, 0.08334, 0.36285],
    "963": [0, 0.43056, 0.03588, 0, 0.57141],
    "964": [0, 0.43056, 0.1132, 0.02778, 0.43715],
    "965": [0, 0.43056, 0.03588, 0.02778, 0.54028],
    "966": [0.19444, 0.43056, 0, 0.08334, 0.65417],
    "967": [0.19444, 0.43056, 0, 0.05556, 0.62569],
    "968": [0.19444, 0.69444, 0.03588, 0.11111, 0.65139],
    "969": [0, 0.43056, 0.03588, 0, 0.62245],
    "977": [0, 0.69444, 0, 0.08334, 0.59144],
    "981": [0.19444, 0.69444, 0, 0.08334, 0.59583],
    "982": [0, 0.43056, 0.02778, 0, 0.82813],
    "1009": [0.19444, 0.43056, 0, 0.08334, 0.51702],
    "1013": [0, 0.43056, 0, 0.05556, 0.4059],
    "57649": [0, 0.43056, 0, 0.02778, 0.32246],
    "57911": [0.19444, 0.43056, 0, 0.08334, 0.38403]
  },
  "SansSerif-Bold": {
    "32": [0, 0, 0, 0, 0.25],
    "33": [0, 0.69444, 0, 0, 0.36667],
    "34": [0, 0.69444, 0, 0, 0.55834],
    "35": [0.19444, 0.69444, 0, 0, 0.91667],
    "36": [0.05556, 0.75, 0, 0, 0.55],
    "37": [0.05556, 0.75, 0, 0, 1.02912],
    "38": [0, 0.69444, 0, 0, 0.83056],
    "39": [0, 0.69444, 0, 0, 0.30556],
    "40": [0.25, 0.75, 0, 0, 0.42778],
    "41": [0.25, 0.75, 0, 0, 0.42778],
    "42": [0, 0.75, 0, 0, 0.55],
    "43": [0.11667, 0.61667, 0, 0, 0.85556],
    "44": [0.10556, 0.13056, 0, 0, 0.30556],
    "45": [0, 0.45833, 0, 0, 0.36667],
    "46": [0, 0.13056, 0, 0, 0.30556],
    "47": [0.25, 0.75, 0, 0, 0.55],
    "48": [0, 0.69444, 0, 0, 0.55],
    "49": [0, 0.69444, 0, 0, 0.55],
    "50": [0, 0.69444, 0, 0, 0.55],
    "51": [0, 0.69444, 0, 0, 0.55],
    "52": [0, 0.69444, 0, 0, 0.55],
    "53": [0, 0.69444, 0, 0, 0.55],
    "54": [0, 0.69444, 0, 0, 0.55],
    "55": [0, 0.69444, 0, 0, 0.55],
    "56": [0, 0.69444, 0, 0, 0.55],
    "57": [0, 0.69444, 0, 0, 0.55],
    "58": [0, 0.45833, 0, 0, 0.30556],
    "59": [0.10556, 0.45833, 0, 0, 0.30556],
    "61": [-0.09375, 0.40625, 0, 0, 0.85556],
    "63": [0, 0.69444, 0, 0, 0.51945],
    "64": [0, 0.69444, 0, 0, 0.73334],
    "65": [0, 0.69444, 0, 0, 0.73334],
    "66": [0, 0.69444, 0, 0, 0.73334],
    "67": [0, 0.69444, 0, 0, 0.70278],
    "68": [0, 0.69444, 0, 0, 0.79445],
    "69": [0, 0.69444, 0, 0, 0.64167],
    "70": [0, 0.69444, 0, 0, 0.61111],
    "71": [0, 0.69444, 0, 0, 0.73334],
    "72": [0, 0.69444, 0, 0, 0.79445],
    "73": [0, 0.69444, 0, 0, 0.33056],
    "74": [0, 0.69444, 0, 0, 0.51945],
    "75": [0, 0.69444, 0, 0, 0.76389],
    "76": [0, 0.69444, 0, 0, 0.58056],
    "77": [0, 0.69444, 0, 0, 0.97778],
    "78": [0, 0.69444, 0, 0, 0.79445],
    "79": [0, 0.69444, 0, 0, 0.79445],
    "80": [0, 0.69444, 0, 0, 0.70278],
    "81": [0.10556, 0.69444, 0, 0, 0.79445],
    "82": [0, 0.69444, 0, 0, 0.70278],
    "83": [0, 0.69444, 0, 0, 0.61111],
    "84": [0, 0.69444, 0, 0, 0.73334],
    "85": [0, 0.69444, 0, 0, 0.76389],
    "86": [0, 0.69444, 0.01528, 0, 0.73334],
    "87": [0, 0.69444, 0.01528, 0, 1.03889],
    "88": [0, 0.69444, 0, 0, 0.73334],
    "89": [0, 0.69444, 0.0275, 0, 0.73334],
    "90": [0, 0.69444, 0, 0, 0.67223],
    "91": [0.25, 0.75, 0, 0, 0.34306],
    "93": [0.25, 0.75, 0, 0, 0.34306],
    "94": [0, 0.69444, 0, 0, 0.55],
    "95": [0.35, 0.10833, 0.03056, 0, 0.55],
    "97": [0, 0.45833, 0, 0, 0.525],
    "98": [0, 0.69444, 0, 0, 0.56111],
    "99": [0, 0.45833, 0, 0, 0.48889],
    "100": [0, 0.69444, 0, 0, 0.56111],
    "101": [0, 0.45833, 0, 0, 0.51111],
    "102": [0, 0.69444, 0.07639, 0, 0.33611],
    "103": [0.19444, 0.45833, 0.01528, 0, 0.55],
    "104": [0, 0.69444, 0, 0, 0.56111],
    "105": [0, 0.69444, 0, 0, 0.25556],
    "106": [0.19444, 0.69444, 0, 0, 0.28611],
    "107": [0, 0.69444, 0, 0, 0.53056],
    "108": [0, 0.69444, 0, 0, 0.25556],
    "109": [0, 0.45833, 0, 0, 0.86667],
    "110": [0, 0.45833, 0, 0, 0.56111],
    "111": [0, 0.45833, 0, 0, 0.55],
    "112": [0.19444, 0.45833, 0, 0, 0.56111],
    "113": [0.19444, 0.45833, 0, 0, 0.56111],
    "114": [0, 0.45833, 0.01528, 0, 0.37222],
    "115": [0, 0.45833, 0, 0, 0.42167],
    "116": [0, 0.58929, 0, 0, 0.40417],
    "117": [0, 0.45833, 0, 0, 0.56111],
    "118": [0, 0.45833, 0.01528, 0, 0.5],
    "119": [0, 0.45833, 0.01528, 0, 0.74445],
    "120": [0, 0.45833, 0, 0, 0.5],
    "121": [0.19444, 0.45833, 0.01528, 0, 0.5],
    "122": [0, 0.45833, 0, 0, 0.47639],
    "126": [0.35, 0.34444, 0, 0, 0.55],
    "160": [0, 0, 0, 0, 0.25],
    "168": [0, 0.69444, 0, 0, 0.55],
    "176": [0, 0.69444, 0, 0, 0.73334],
    "180": [0, 0.69444, 0, 0, 0.55],
    "184": [0.17014, 0, 0, 0, 0.48889],
    "305": [0, 0.45833, 0, 0, 0.25556],
    "567": [0.19444, 0.45833, 0, 0, 0.28611],
    "710": [0, 0.69444, 0, 0, 0.55],
    "711": [0, 0.63542, 0, 0, 0.55],
    "713": [0, 0.63778, 0, 0, 0.55],
    "728": [0, 0.69444, 0, 0, 0.55],
    "729": [0, 0.69444, 0, 0, 0.30556],
    "730": [0, 0.69444, 0, 0, 0.73334],
    "732": [0, 0.69444, 0, 0, 0.55],
    "733": [0, 0.69444, 0, 0, 0.55],
    "915": [0, 0.69444, 0, 0, 0.58056],
    "916": [0, 0.69444, 0, 0, 0.91667],
    "920": [0, 0.69444, 0, 0, 0.85556],
    "923": [0, 0.69444, 0, 0, 0.67223],
    "926": [0, 0.69444, 0, 0, 0.73334],
    "928": [0, 0.69444, 0, 0, 0.79445],
    "931": [0, 0.69444, 0, 0, 0.79445],
    "933": [0, 0.69444, 0, 0, 0.85556],
    "934": [0, 0.69444, 0, 0, 0.79445],
    "936": [0, 0.69444, 0, 0, 0.85556],
    "937": [0, 0.69444, 0, 0, 0.79445],
    "8211": [0, 0.45833, 0.03056, 0, 0.55],
    "8212": [0, 0.45833, 0.03056, 0, 1.10001],
    "8216": [0, 0.69444, 0, 0, 0.30556],
    "8217": [0, 0.69444, 0, 0, 0.30556],
    "8220": [0, 0.69444, 0, 0, 0.55834],
    "8221": [0, 0.69444, 0, 0, 0.55834]
  },
  "SansSerif-Italic": {
    "32": [0, 0, 0, 0, 0.25],
    "33": [0, 0.69444, 0.05733, 0, 0.31945],
    "34": [0, 0.69444, 316e-5, 0, 0.5],
    "35": [0.19444, 0.69444, 0.05087, 0, 0.83334],
    "36": [0.05556, 0.75, 0.11156, 0, 0.5],
    "37": [0.05556, 0.75, 0.03126, 0, 0.83334],
    "38": [0, 0.69444, 0.03058, 0, 0.75834],
    "39": [0, 0.69444, 0.07816, 0, 0.27778],
    "40": [0.25, 0.75, 0.13164, 0, 0.38889],
    "41": [0.25, 0.75, 0.02536, 0, 0.38889],
    "42": [0, 0.75, 0.11775, 0, 0.5],
    "43": [0.08333, 0.58333, 0.02536, 0, 0.77778],
    "44": [0.125, 0.08333, 0, 0, 0.27778],
    "45": [0, 0.44444, 0.01946, 0, 0.33333],
    "46": [0, 0.08333, 0, 0, 0.27778],
    "47": [0.25, 0.75, 0.13164, 0, 0.5],
    "48": [0, 0.65556, 0.11156, 0, 0.5],
    "49": [0, 0.65556, 0.11156, 0, 0.5],
    "50": [0, 0.65556, 0.11156, 0, 0.5],
    "51": [0, 0.65556, 0.11156, 0, 0.5],
    "52": [0, 0.65556, 0.11156, 0, 0.5],
    "53": [0, 0.65556, 0.11156, 0, 0.5],
    "54": [0, 0.65556, 0.11156, 0, 0.5],
    "55": [0, 0.65556, 0.11156, 0, 0.5],
    "56": [0, 0.65556, 0.11156, 0, 0.5],
    "57": [0, 0.65556, 0.11156, 0, 0.5],
    "58": [0, 0.44444, 0.02502, 0, 0.27778],
    "59": [0.125, 0.44444, 0.02502, 0, 0.27778],
    "61": [-0.13, 0.37, 0.05087, 0, 0.77778],
    "63": [0, 0.69444, 0.11809, 0, 0.47222],
    "64": [0, 0.69444, 0.07555, 0, 0.66667],
    "65": [0, 0.69444, 0, 0, 0.66667],
    "66": [0, 0.69444, 0.08293, 0, 0.66667],
    "67": [0, 0.69444, 0.11983, 0, 0.63889],
    "68": [0, 0.69444, 0.07555, 0, 0.72223],
    "69": [0, 0.69444, 0.11983, 0, 0.59722],
    "70": [0, 0.69444, 0.13372, 0, 0.56945],
    "71": [0, 0.69444, 0.11983, 0, 0.66667],
    "72": [0, 0.69444, 0.08094, 0, 0.70834],
    "73": [0, 0.69444, 0.13372, 0, 0.27778],
    "74": [0, 0.69444, 0.08094, 0, 0.47222],
    "75": [0, 0.69444, 0.11983, 0, 0.69445],
    "76": [0, 0.69444, 0, 0, 0.54167],
    "77": [0, 0.69444, 0.08094, 0, 0.875],
    "78": [0, 0.69444, 0.08094, 0, 0.70834],
    "79": [0, 0.69444, 0.07555, 0, 0.73611],
    "80": [0, 0.69444, 0.08293, 0, 0.63889],
    "81": [0.125, 0.69444, 0.07555, 0, 0.73611],
    "82": [0, 0.69444, 0.08293, 0, 0.64584],
    "83": [0, 0.69444, 0.09205, 0, 0.55556],
    "84": [0, 0.69444, 0.13372, 0, 0.68056],
    "85": [0, 0.69444, 0.08094, 0, 0.6875],
    "86": [0, 0.69444, 0.1615, 0, 0.66667],
    "87": [0, 0.69444, 0.1615, 0, 0.94445],
    "88": [0, 0.69444, 0.13372, 0, 0.66667],
    "89": [0, 0.69444, 0.17261, 0, 0.66667],
    "90": [0, 0.69444, 0.11983, 0, 0.61111],
    "91": [0.25, 0.75, 0.15942, 0, 0.28889],
    "93": [0.25, 0.75, 0.08719, 0, 0.28889],
    "94": [0, 0.69444, 0.0799, 0, 0.5],
    "95": [0.35, 0.09444, 0.08616, 0, 0.5],
    "97": [0, 0.44444, 981e-5, 0, 0.48056],
    "98": [0, 0.69444, 0.03057, 0, 0.51667],
    "99": [0, 0.44444, 0.08336, 0, 0.44445],
    "100": [0, 0.69444, 0.09483, 0, 0.51667],
    "101": [0, 0.44444, 0.06778, 0, 0.44445],
    "102": [0, 0.69444, 0.21705, 0, 0.30556],
    "103": [0.19444, 0.44444, 0.10836, 0, 0.5],
    "104": [0, 0.69444, 0.01778, 0, 0.51667],
    "105": [0, 0.67937, 0.09718, 0, 0.23889],
    "106": [0.19444, 0.67937, 0.09162, 0, 0.26667],
    "107": [0, 0.69444, 0.08336, 0, 0.48889],
    "108": [0, 0.69444, 0.09483, 0, 0.23889],
    "109": [0, 0.44444, 0.01778, 0, 0.79445],
    "110": [0, 0.44444, 0.01778, 0, 0.51667],
    "111": [0, 0.44444, 0.06613, 0, 0.5],
    "112": [0.19444, 0.44444, 0.0389, 0, 0.51667],
    "113": [0.19444, 0.44444, 0.04169, 0, 0.51667],
    "114": [0, 0.44444, 0.10836, 0, 0.34167],
    "115": [0, 0.44444, 0.0778, 0, 0.38333],
    "116": [0, 0.57143, 0.07225, 0, 0.36111],
    "117": [0, 0.44444, 0.04169, 0, 0.51667],
    "118": [0, 0.44444, 0.10836, 0, 0.46111],
    "119": [0, 0.44444, 0.10836, 0, 0.68334],
    "120": [0, 0.44444, 0.09169, 0, 0.46111],
    "121": [0.19444, 0.44444, 0.10836, 0, 0.46111],
    "122": [0, 0.44444, 0.08752, 0, 0.43472],
    "126": [0.35, 0.32659, 0.08826, 0, 0.5],
    "160": [0, 0, 0, 0, 0.25],
    "168": [0, 0.67937, 0.06385, 0, 0.5],
    "176": [0, 0.69444, 0, 0, 0.73752],
    "184": [0.17014, 0, 0, 0, 0.44445],
    "305": [0, 0.44444, 0.04169, 0, 0.23889],
    "567": [0.19444, 0.44444, 0.04169, 0, 0.26667],
    "710": [0, 0.69444, 0.0799, 0, 0.5],
    "711": [0, 0.63194, 0.08432, 0, 0.5],
    "713": [0, 0.60889, 0.08776, 0, 0.5],
    "714": [0, 0.69444, 0.09205, 0, 0.5],
    "715": [0, 0.69444, 0, 0, 0.5],
    "728": [0, 0.69444, 0.09483, 0, 0.5],
    "729": [0, 0.67937, 0.07774, 0, 0.27778],
    "730": [0, 0.69444, 0, 0, 0.73752],
    "732": [0, 0.67659, 0.08826, 0, 0.5],
    "733": [0, 0.69444, 0.09205, 0, 0.5],
    "915": [0, 0.69444, 0.13372, 0, 0.54167],
    "916": [0, 0.69444, 0, 0, 0.83334],
    "920": [0, 0.69444, 0.07555, 0, 0.77778],
    "923": [0, 0.69444, 0, 0, 0.61111],
    "926": [0, 0.69444, 0.12816, 0, 0.66667],
    "928": [0, 0.69444, 0.08094, 0, 0.70834],
    "931": [0, 0.69444, 0.11983, 0, 0.72222],
    "933": [0, 0.69444, 0.09031, 0, 0.77778],
    "934": [0, 0.69444, 0.04603, 0, 0.72222],
    "936": [0, 0.69444, 0.09031, 0, 0.77778],
    "937": [0, 0.69444, 0.08293, 0, 0.72222],
    "8211": [0, 0.44444, 0.08616, 0, 0.5],
    "8212": [0, 0.44444, 0.08616, 0, 1],
    "8216": [0, 0.69444, 0.07816, 0, 0.27778],
    "8217": [0, 0.69444, 0.07816, 0, 0.27778],
    "8220": [0, 0.69444, 0.14205, 0, 0.5],
    "8221": [0, 0.69444, 316e-5, 0, 0.5]
  },
  "SansSerif-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "33": [0, 0.69444, 0, 0, 0.31945],
    "34": [0, 0.69444, 0, 0, 0.5],
    "35": [0.19444, 0.69444, 0, 0, 0.83334],
    "36": [0.05556, 0.75, 0, 0, 0.5],
    "37": [0.05556, 0.75, 0, 0, 0.83334],
    "38": [0, 0.69444, 0, 0, 0.75834],
    "39": [0, 0.69444, 0, 0, 0.27778],
    "40": [0.25, 0.75, 0, 0, 0.38889],
    "41": [0.25, 0.75, 0, 0, 0.38889],
    "42": [0, 0.75, 0, 0, 0.5],
    "43": [0.08333, 0.58333, 0, 0, 0.77778],
    "44": [0.125, 0.08333, 0, 0, 0.27778],
    "45": [0, 0.44444, 0, 0, 0.33333],
    "46": [0, 0.08333, 0, 0, 0.27778],
    "47": [0.25, 0.75, 0, 0, 0.5],
    "48": [0, 0.65556, 0, 0, 0.5],
    "49": [0, 0.65556, 0, 0, 0.5],
    "50": [0, 0.65556, 0, 0, 0.5],
    "51": [0, 0.65556, 0, 0, 0.5],
    "52": [0, 0.65556, 0, 0, 0.5],
    "53": [0, 0.65556, 0, 0, 0.5],
    "54": [0, 0.65556, 0, 0, 0.5],
    "55": [0, 0.65556, 0, 0, 0.5],
    "56": [0, 0.65556, 0, 0, 0.5],
    "57": [0, 0.65556, 0, 0, 0.5],
    "58": [0, 0.44444, 0, 0, 0.27778],
    "59": [0.125, 0.44444, 0, 0, 0.27778],
    "61": [-0.13, 0.37, 0, 0, 0.77778],
    "63": [0, 0.69444, 0, 0, 0.47222],
    "64": [0, 0.69444, 0, 0, 0.66667],
    "65": [0, 0.69444, 0, 0, 0.66667],
    "66": [0, 0.69444, 0, 0, 0.66667],
    "67": [0, 0.69444, 0, 0, 0.63889],
    "68": [0, 0.69444, 0, 0, 0.72223],
    "69": [0, 0.69444, 0, 0, 0.59722],
    "70": [0, 0.69444, 0, 0, 0.56945],
    "71": [0, 0.69444, 0, 0, 0.66667],
    "72": [0, 0.69444, 0, 0, 0.70834],
    "73": [0, 0.69444, 0, 0, 0.27778],
    "74": [0, 0.69444, 0, 0, 0.47222],
    "75": [0, 0.69444, 0, 0, 0.69445],
    "76": [0, 0.69444, 0, 0, 0.54167],
    "77": [0, 0.69444, 0, 0, 0.875],
    "78": [0, 0.69444, 0, 0, 0.70834],
    "79": [0, 0.69444, 0, 0, 0.73611],
    "80": [0, 0.69444, 0, 0, 0.63889],
    "81": [0.125, 0.69444, 0, 0, 0.73611],
    "82": [0, 0.69444, 0, 0, 0.64584],
    "83": [0, 0.69444, 0, 0, 0.55556],
    "84": [0, 0.69444, 0, 0, 0.68056],
    "85": [0, 0.69444, 0, 0, 0.6875],
    "86": [0, 0.69444, 0.01389, 0, 0.66667],
    "87": [0, 0.69444, 0.01389, 0, 0.94445],
    "88": [0, 0.69444, 0, 0, 0.66667],
    "89": [0, 0.69444, 0.025, 0, 0.66667],
    "90": [0, 0.69444, 0, 0, 0.61111],
    "91": [0.25, 0.75, 0, 0, 0.28889],
    "93": [0.25, 0.75, 0, 0, 0.28889],
    "94": [0, 0.69444, 0, 0, 0.5],
    "95": [0.35, 0.09444, 0.02778, 0, 0.5],
    "97": [0, 0.44444, 0, 0, 0.48056],
    "98": [0, 0.69444, 0, 0, 0.51667],
    "99": [0, 0.44444, 0, 0, 0.44445],
    "100": [0, 0.69444, 0, 0, 0.51667],
    "101": [0, 0.44444, 0, 0, 0.44445],
    "102": [0, 0.69444, 0.06944, 0, 0.30556],
    "103": [0.19444, 0.44444, 0.01389, 0, 0.5],
    "104": [0, 0.69444, 0, 0, 0.51667],
    "105": [0, 0.67937, 0, 0, 0.23889],
    "106": [0.19444, 0.67937, 0, 0, 0.26667],
    "107": [0, 0.69444, 0, 0, 0.48889],
    "108": [0, 0.69444, 0, 0, 0.23889],
    "109": [0, 0.44444, 0, 0, 0.79445],
    "110": [0, 0.44444, 0, 0, 0.51667],
    "111": [0, 0.44444, 0, 0, 0.5],
    "112": [0.19444, 0.44444, 0, 0, 0.51667],
    "113": [0.19444, 0.44444, 0, 0, 0.51667],
    "114": [0, 0.44444, 0.01389, 0, 0.34167],
    "115": [0, 0.44444, 0, 0, 0.38333],
    "116": [0, 0.57143, 0, 0, 0.36111],
    "117": [0, 0.44444, 0, 0, 0.51667],
    "118": [0, 0.44444, 0.01389, 0, 0.46111],
    "119": [0, 0.44444, 0.01389, 0, 0.68334],
    "120": [0, 0.44444, 0, 0, 0.46111],
    "121": [0.19444, 0.44444, 0.01389, 0, 0.46111],
    "122": [0, 0.44444, 0, 0, 0.43472],
    "126": [0.35, 0.32659, 0, 0, 0.5],
    "160": [0, 0, 0, 0, 0.25],
    "168": [0, 0.67937, 0, 0, 0.5],
    "176": [0, 0.69444, 0, 0, 0.66667],
    "184": [0.17014, 0, 0, 0, 0.44445],
    "305": [0, 0.44444, 0, 0, 0.23889],
    "567": [0.19444, 0.44444, 0, 0, 0.26667],
    "710": [0, 0.69444, 0, 0, 0.5],
    "711": [0, 0.63194, 0, 0, 0.5],
    "713": [0, 0.60889, 0, 0, 0.5],
    "714": [0, 0.69444, 0, 0, 0.5],
    "715": [0, 0.69444, 0, 0, 0.5],
    "728": [0, 0.69444, 0, 0, 0.5],
    "729": [0, 0.67937, 0, 0, 0.27778],
    "730": [0, 0.69444, 0, 0, 0.66667],
    "732": [0, 0.67659, 0, 0, 0.5],
    "733": [0, 0.69444, 0, 0, 0.5],
    "915": [0, 0.69444, 0, 0, 0.54167],
    "916": [0, 0.69444, 0, 0, 0.83334],
    "920": [0, 0.69444, 0, 0, 0.77778],
    "923": [0, 0.69444, 0, 0, 0.61111],
    "926": [0, 0.69444, 0, 0, 0.66667],
    "928": [0, 0.69444, 0, 0, 0.70834],
    "931": [0, 0.69444, 0, 0, 0.72222],
    "933": [0, 0.69444, 0, 0, 0.77778],
    "934": [0, 0.69444, 0, 0, 0.72222],
    "936": [0, 0.69444, 0, 0, 0.77778],
    "937": [0, 0.69444, 0, 0, 0.72222],
    "8211": [0, 0.44444, 0.02778, 0, 0.5],
    "8212": [0, 0.44444, 0.02778, 0, 1],
    "8216": [0, 0.69444, 0, 0, 0.27778],
    "8217": [0, 0.69444, 0, 0, 0.27778],
    "8220": [0, 0.69444, 0, 0, 0.5],
    "8221": [0, 0.69444, 0, 0, 0.5]
  },
  "Script-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "65": [0, 0.7, 0.22925, 0, 0.80253],
    "66": [0, 0.7, 0.04087, 0, 0.90757],
    "67": [0, 0.7, 0.1689, 0, 0.66619],
    "68": [0, 0.7, 0.09371, 0, 0.77443],
    "69": [0, 0.7, 0.18583, 0, 0.56162],
    "70": [0, 0.7, 0.13634, 0, 0.89544],
    "71": [0, 0.7, 0.17322, 0, 0.60961],
    "72": [0, 0.7, 0.29694, 0, 0.96919],
    "73": [0, 0.7, 0.19189, 0, 0.80907],
    "74": [0.27778, 0.7, 0.19189, 0, 1.05159],
    "75": [0, 0.7, 0.31259, 0, 0.91364],
    "76": [0, 0.7, 0.19189, 0, 0.87373],
    "77": [0, 0.7, 0.15981, 0, 1.08031],
    "78": [0, 0.7, 0.3525, 0, 0.9015],
    "79": [0, 0.7, 0.08078, 0, 0.73787],
    "80": [0, 0.7, 0.08078, 0, 1.01262],
    "81": [0, 0.7, 0.03305, 0, 0.88282],
    "82": [0, 0.7, 0.06259, 0, 0.85],
    "83": [0, 0.7, 0.19189, 0, 0.86767],
    "84": [0, 0.7, 0.29087, 0, 0.74697],
    "85": [0, 0.7, 0.25815, 0, 0.79996],
    "86": [0, 0.7, 0.27523, 0, 0.62204],
    "87": [0, 0.7, 0.27523, 0, 0.80532],
    "88": [0, 0.7, 0.26006, 0, 0.94445],
    "89": [0, 0.7, 0.2939, 0, 0.70961],
    "90": [0, 0.7, 0.24037, 0, 0.8212],
    "160": [0, 0, 0, 0, 0.25]
  },
  "Size1-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "40": [0.35001, 0.85, 0, 0, 0.45834],
    "41": [0.35001, 0.85, 0, 0, 0.45834],
    "47": [0.35001, 0.85, 0, 0, 0.57778],
    "91": [0.35001, 0.85, 0, 0, 0.41667],
    "92": [0.35001, 0.85, 0, 0, 0.57778],
    "93": [0.35001, 0.85, 0, 0, 0.41667],
    "123": [0.35001, 0.85, 0, 0, 0.58334],
    "125": [0.35001, 0.85, 0, 0, 0.58334],
    "160": [0, 0, 0, 0, 0.25],
    "710": [0, 0.72222, 0, 0, 0.55556],
    "732": [0, 0.72222, 0, 0, 0.55556],
    "770": [0, 0.72222, 0, 0, 0.55556],
    "771": [0, 0.72222, 0, 0, 0.55556],
    "8214": [-99e-5, 0.601, 0, 0, 0.77778],
    "8593": [1e-5, 0.6, 0, 0, 0.66667],
    "8595": [1e-5, 0.6, 0, 0, 0.66667],
    "8657": [1e-5, 0.6, 0, 0, 0.77778],
    "8659": [1e-5, 0.6, 0, 0, 0.77778],
    "8719": [0.25001, 0.75, 0, 0, 0.94445],
    "8720": [0.25001, 0.75, 0, 0, 0.94445],
    "8721": [0.25001, 0.75, 0, 0, 1.05556],
    "8730": [0.35001, 0.85, 0, 0, 1],
    "8739": [-599e-5, 0.606, 0, 0, 0.33333],
    "8741": [-599e-5, 0.606, 0, 0, 0.55556],
    "8747": [0.30612, 0.805, 0.19445, 0, 0.47222],
    "8748": [0.306, 0.805, 0.19445, 0, 0.47222],
    "8749": [0.306, 0.805, 0.19445, 0, 0.47222],
    "8750": [0.30612, 0.805, 0.19445, 0, 0.47222],
    "8896": [0.25001, 0.75, 0, 0, 0.83334],
    "8897": [0.25001, 0.75, 0, 0, 0.83334],
    "8898": [0.25001, 0.75, 0, 0, 0.83334],
    "8899": [0.25001, 0.75, 0, 0, 0.83334],
    "8968": [0.35001, 0.85, 0, 0, 0.47222],
    "8969": [0.35001, 0.85, 0, 0, 0.47222],
    "8970": [0.35001, 0.85, 0, 0, 0.47222],
    "8971": [0.35001, 0.85, 0, 0, 0.47222],
    "9168": [-99e-5, 0.601, 0, 0, 0.66667],
    "10216": [0.35001, 0.85, 0, 0, 0.47222],
    "10217": [0.35001, 0.85, 0, 0, 0.47222],
    "10752": [0.25001, 0.75, 0, 0, 1.11111],
    "10753": [0.25001, 0.75, 0, 0, 1.11111],
    "10754": [0.25001, 0.75, 0, 0, 1.11111],
    "10756": [0.25001, 0.75, 0, 0, 0.83334],
    "10758": [0.25001, 0.75, 0, 0, 0.83334]
  },
  "Size2-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "40": [0.65002, 1.15, 0, 0, 0.59722],
    "41": [0.65002, 1.15, 0, 0, 0.59722],
    "47": [0.65002, 1.15, 0, 0, 0.81111],
    "91": [0.65002, 1.15, 0, 0, 0.47222],
    "92": [0.65002, 1.15, 0, 0, 0.81111],
    "93": [0.65002, 1.15, 0, 0, 0.47222],
    "123": [0.65002, 1.15, 0, 0, 0.66667],
    "125": [0.65002, 1.15, 0, 0, 0.66667],
    "160": [0, 0, 0, 0, 0.25],
    "710": [0, 0.75, 0, 0, 1],
    "732": [0, 0.75, 0, 0, 1],
    "770": [0, 0.75, 0, 0, 1],
    "771": [0, 0.75, 0, 0, 1],
    "8719": [0.55001, 1.05, 0, 0, 1.27778],
    "8720": [0.55001, 1.05, 0, 0, 1.27778],
    "8721": [0.55001, 1.05, 0, 0, 1.44445],
    "8730": [0.65002, 1.15, 0, 0, 1],
    "8747": [0.86225, 1.36, 0.44445, 0, 0.55556],
    "8748": [0.862, 1.36, 0.44445, 0, 0.55556],
    "8749": [0.862, 1.36, 0.44445, 0, 0.55556],
    "8750": [0.86225, 1.36, 0.44445, 0, 0.55556],
    "8896": [0.55001, 1.05, 0, 0, 1.11111],
    "8897": [0.55001, 1.05, 0, 0, 1.11111],
    "8898": [0.55001, 1.05, 0, 0, 1.11111],
    "8899": [0.55001, 1.05, 0, 0, 1.11111],
    "8968": [0.65002, 1.15, 0, 0, 0.52778],
    "8969": [0.65002, 1.15, 0, 0, 0.52778],
    "8970": [0.65002, 1.15, 0, 0, 0.52778],
    "8971": [0.65002, 1.15, 0, 0, 0.52778],
    "10216": [0.65002, 1.15, 0, 0, 0.61111],
    "10217": [0.65002, 1.15, 0, 0, 0.61111],
    "10752": [0.55001, 1.05, 0, 0, 1.51112],
    "10753": [0.55001, 1.05, 0, 0, 1.51112],
    "10754": [0.55001, 1.05, 0, 0, 1.51112],
    "10756": [0.55001, 1.05, 0, 0, 1.11111],
    "10758": [0.55001, 1.05, 0, 0, 1.11111]
  },
  "Size3-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "40": [0.95003, 1.45, 0, 0, 0.73611],
    "41": [0.95003, 1.45, 0, 0, 0.73611],
    "47": [0.95003, 1.45, 0, 0, 1.04445],
    "91": [0.95003, 1.45, 0, 0, 0.52778],
    "92": [0.95003, 1.45, 0, 0, 1.04445],
    "93": [0.95003, 1.45, 0, 0, 0.52778],
    "123": [0.95003, 1.45, 0, 0, 0.75],
    "125": [0.95003, 1.45, 0, 0, 0.75],
    "160": [0, 0, 0, 0, 0.25],
    "710": [0, 0.75, 0, 0, 1.44445],
    "732": [0, 0.75, 0, 0, 1.44445],
    "770": [0, 0.75, 0, 0, 1.44445],
    "771": [0, 0.75, 0, 0, 1.44445],
    "8730": [0.95003, 1.45, 0, 0, 1],
    "8968": [0.95003, 1.45, 0, 0, 0.58334],
    "8969": [0.95003, 1.45, 0, 0, 0.58334],
    "8970": [0.95003, 1.45, 0, 0, 0.58334],
    "8971": [0.95003, 1.45, 0, 0, 0.58334],
    "10216": [0.95003, 1.45, 0, 0, 0.75],
    "10217": [0.95003, 1.45, 0, 0, 0.75]
  },
  "Size4-Regular": {
    "32": [0, 0, 0, 0, 0.25],
    "40": [1.25003, 1.75, 0, 0, 0.79167],
    "41": [1.25003, 1.75, 0, 0, 0.79167],
    "47": [1.25003, 1.75, 0, 0, 1.27778],
    "91": [1.25003, 1.75, 0, 0, 0.58334],
    "92": [1.25003, 1.75, 0, 0, 1.27778],
    "93": [1.25003, 1.75, 0, 0, 0.58334],
    "123": [1.25003, 1.75, 0, 0, 0.80556],
    "125": [1.25003, 1.75, 0, 0, 0.80556],
    "160": [0, 0, 0, 0, 0.25],
    "710": [0, 0.825, 0, 0, 1.8889],
    "732": [0, 0.825, 0, 0, 1.8889],
    "770": [0, 0.825, 0, 0, 1.8889],
    "771": [0, 0.825, 0, 0, 1.8889],
    "8730": [1.25003, 1.75, 0, 0, 1],
    "8968": [1.25003, 1.75, 0, 0, 0.63889],
    "8969": [1.25003, 1.75, 0, 0, 0.63889],
    "8970": [1.25003, 1.75, 0, 0, 0.63889],
    "8971": [1.25003, 1.75, 0, 0, 0.63889],
    "9115": [0.64502, 1.155, 0, 0, 0.875],
    "9116": [1e-5, 0.6, 0, 0, 0.875],
    "9117": [0.64502, 1.155, 0, 0, 0.875],
    "9118": [0.64502, 1.155, 0, 0, 0.875],
    "9119": [1e-5, 0.6, 0, 0, 0.875],
    "9120": [0.64502, 1.155, 0, 0, 0.875],
    "9121": [0.64502, 1.155, 0, 0, 0.66667],
    "9122": [-99e-5, 0.601, 0, 0, 0.66667],
    "9123": [0.64502, 1.155, 0, 0, 0.66667],
    "9124": [0.64502, 1.155, 0, 0, 0.66667],
    "9125": [-99e-5, 0.601, 0, 0, 0.66667],
    "9126": [0.64502, 1.155, 0, 0, 0.66667],
    "9127": [1e-5, 0.9, 0, 0, 0.88889],
    "9128": [0.65002, 1.15, 0, 0, 0.88889],
    "9129": [0.90001, 0, 0, 0, 0.88889],
    "9130": [0, 0.3, 0, 0, 0.88889],
    "9131": [1e-5, 0.9, 0, 0, 0.88889],
    "9132": [0.65002, 1.15, 0, 0, 0.88889],
    "9133": [0.90001, 0, 0, 0, 0.88889],
    "9143": [0.88502, 0.915, 0, 0, 1.05556],
    "10216": [1.25003, 1.75, 0, 0, 0.80556],
    "10217": [1.25003, 1.75, 0, 0, 0.80556],
    "57344": [-499e-5, 0.605, 0, 0, 1.05556],
    "57345": [-499e-5, 0.605, 0, 0, 1.05556],
    "57680": [0, 0.12, 0, 0, 0.45],
    "57681": [0, 0.12, 0, 0, 0.45],
    "57682": [0, 0.12, 0, 0, 0.45],
    "57683": [0, 0.12, 0, 0, 0.45]
  },
  "Typewriter-Regular": {
    "32": [0, 0, 0, 0, 0.525],
    "33": [0, 0.61111, 0, 0, 0.525],
    "34": [0, 0.61111, 0, 0, 0.525],
    "35": [0, 0.61111, 0, 0, 0.525],
    "36": [0.08333, 0.69444, 0, 0, 0.525],
    "37": [0.08333, 0.69444, 0, 0, 0.525],
    "38": [0, 0.61111, 0, 0, 0.525],
    "39": [0, 0.61111, 0, 0, 0.525],
    "40": [0.08333, 0.69444, 0, 0, 0.525],
    "41": [0.08333, 0.69444, 0, 0, 0.525],
    "42": [0, 0.52083, 0, 0, 0.525],
    "43": [-0.08056, 0.53055, 0, 0, 0.525],
    "44": [0.13889, 0.125, 0, 0, 0.525],
    "45": [-0.08056, 0.53055, 0, 0, 0.525],
    "46": [0, 0.125, 0, 0, 0.525],
    "47": [0.08333, 0.69444, 0, 0, 0.525],
    "48": [0, 0.61111, 0, 0, 0.525],
    "49": [0, 0.61111, 0, 0, 0.525],
    "50": [0, 0.61111, 0, 0, 0.525],
    "51": [0, 0.61111, 0, 0, 0.525],
    "52": [0, 0.61111, 0, 0, 0.525],
    "53": [0, 0.61111, 0, 0, 0.525],
    "54": [0, 0.61111, 0, 0, 0.525],
    "55": [0, 0.61111, 0, 0, 0.525],
    "56": [0, 0.61111, 0, 0, 0.525],
    "57": [0, 0.61111, 0, 0, 0.525],
    "58": [0, 0.43056, 0, 0, 0.525],
    "59": [0.13889, 0.43056, 0, 0, 0.525],
    "60": [-0.05556, 0.55556, 0, 0, 0.525],
    "61": [-0.19549, 0.41562, 0, 0, 0.525],
    "62": [-0.05556, 0.55556, 0, 0, 0.525],
    "63": [0, 0.61111, 0, 0, 0.525],
    "64": [0, 0.61111, 0, 0, 0.525],
    "65": [0, 0.61111, 0, 0, 0.525],
    "66": [0, 0.61111, 0, 0, 0.525],
    "67": [0, 0.61111, 0, 0, 0.525],
    "68": [0, 0.61111, 0, 0, 0.525],
    "69": [0, 0.61111, 0, 0, 0.525],
    "70": [0, 0.61111, 0, 0, 0.525],
    "71": [0, 0.61111, 0, 0, 0.525],
    "72": [0, 0.61111, 0, 0, 0.525],
    "73": [0, 0.61111, 0, 0, 0.525],
    "74": [0, 0.61111, 0, 0, 0.525],
    "75": [0, 0.61111, 0, 0, 0.525],
    "76": [0, 0.61111, 0, 0, 0.525],
    "77": [0, 0.61111, 0, 0, 0.525],
    "78": [0, 0.61111, 0, 0, 0.525],
    "79": [0, 0.61111, 0, 0, 0.525],
    "80": [0, 0.61111, 0, 0, 0.525],
    "81": [0.13889, 0.61111, 0, 0, 0.525],
    "82": [0, 0.61111, 0, 0, 0.525],
    "83": [0, 0.61111, 0, 0, 0.525],
    "84": [0, 0.61111, 0, 0, 0.525],
    "85": [0, 0.61111, 0, 0, 0.525],
    "86": [0, 0.61111, 0, 0, 0.525],
    "87": [0, 0.61111, 0, 0, 0.525],
    "88": [0, 0.61111, 0, 0, 0.525],
    "89": [0, 0.61111, 0, 0, 0.525],
    "90": [0, 0.61111, 0, 0, 0.525],
    "91": [0.08333, 0.69444, 0, 0, 0.525],
    "92": [0.08333, 0.69444, 0, 0, 0.525],
    "93": [0.08333, 0.69444, 0, 0, 0.525],
    "94": [0, 0.61111, 0, 0, 0.525],
    "95": [0.09514, 0, 0, 0, 0.525],
    "96": [0, 0.61111, 0, 0, 0.525],
    "97": [0, 0.43056, 0, 0, 0.525],
    "98": [0, 0.61111, 0, 0, 0.525],
    "99": [0, 0.43056, 0, 0, 0.525],
    "100": [0, 0.61111, 0, 0, 0.525],
    "101": [0, 0.43056, 0, 0, 0.525],
    "102": [0, 0.61111, 0, 0, 0.525],
    "103": [0.22222, 0.43056, 0, 0, 0.525],
    "104": [0, 0.61111, 0, 0, 0.525],
    "105": [0, 0.61111, 0, 0, 0.525],
    "106": [0.22222, 0.61111, 0, 0, 0.525],
    "107": [0, 0.61111, 0, 0, 0.525],
    "108": [0, 0.61111, 0, 0, 0.525],
    "109": [0, 0.43056, 0, 0, 0.525],
    "110": [0, 0.43056, 0, 0, 0.525],
    "111": [0, 0.43056, 0, 0, 0.525],
    "112": [0.22222, 0.43056, 0, 0, 0.525],
    "113": [0.22222, 0.43056, 0, 0, 0.525],
    "114": [0, 0.43056, 0, 0, 0.525],
    "115": [0, 0.43056, 0, 0, 0.525],
    "116": [0, 0.55358, 0, 0, 0.525],
    "117": [0, 0.43056, 0, 0, 0.525],
    "118": [0, 0.43056, 0, 0, 0.525],
    "119": [0, 0.43056, 0, 0, 0.525],
    "120": [0, 0.43056, 0, 0, 0.525],
    "121": [0.22222, 0.43056, 0, 0, 0.525],
    "122": [0, 0.43056, 0, 0, 0.525],
    "123": [0.08333, 0.69444, 0, 0, 0.525],
    "124": [0.08333, 0.69444, 0, 0, 0.525],
    "125": [0.08333, 0.69444, 0, 0, 0.525],
    "126": [0, 0.61111, 0, 0, 0.525],
    "127": [0, 0.61111, 0, 0, 0.525],
    "160": [0, 0, 0, 0, 0.525],
    "176": [0, 0.61111, 0, 0, 0.525],
    "184": [0.19445, 0, 0, 0, 0.525],
    "305": [0, 0.43056, 0, 0, 0.525],
    "567": [0.22222, 0.43056, 0, 0, 0.525],
    "711": [0, 0.56597, 0, 0, 0.525],
    "713": [0, 0.56555, 0, 0, 0.525],
    "714": [0, 0.61111, 0, 0, 0.525],
    "715": [0, 0.61111, 0, 0, 0.525],
    "728": [0, 0.61111, 0, 0, 0.525],
    "730": [0, 0.61111, 0, 0, 0.525],
    "770": [0, 0.61111, 0, 0, 0.525],
    "771": [0, 0.61111, 0, 0, 0.525],
    "776": [0, 0.61111, 0, 0, 0.525],
    "915": [0, 0.61111, 0, 0, 0.525],
    "916": [0, 0.61111, 0, 0, 0.525],
    "920": [0, 0.61111, 0, 0, 0.525],
    "923": [0, 0.61111, 0, 0, 0.525],
    "926": [0, 0.61111, 0, 0, 0.525],
    "928": [0, 0.61111, 0, 0, 0.525],
    "931": [0, 0.61111, 0, 0, 0.525],
    "933": [0, 0.61111, 0, 0, 0.525],
    "934": [0, 0.61111, 0, 0, 0.525],
    "936": [0, 0.61111, 0, 0, 0.525],
    "937": [0, 0.61111, 0, 0, 0.525],
    "8216": [0, 0.61111, 0, 0, 0.525],
    "8217": [0, 0.61111, 0, 0, 0.525],
    "8242": [0, 0.61111, 0, 0, 0.525],
    "9251": [0.11111, 0.21944, 0, 0, 0.525]
  }
};
var extraCharacterMap = {
  // Latin-1
  "Å": "A",
  "Ð": "D",
  "Þ": "o",
  "å": "a",
  "ð": "d",
  "þ": "o",
  // Cyrillic
  "А": "A",
  "Б": "B",
  "В": "B",
  "Г": "F",
  "Д": "A",
  "Е": "E",
  "Ж": "K",
  "З": "3",
  "И": "N",
  "Й": "N",
  "К": "K",
  "Л": "N",
  "М": "M",
  "Н": "H",
  "О": "O",
  "П": "N",
  "Р": "P",
  "С": "C",
  "Т": "T",
  "У": "y",
  "Ф": "O",
  "Х": "X",
  "Ц": "U",
  "Ч": "h",
  "Ш": "W",
  "Щ": "W",
  "Ъ": "B",
  "Ы": "X",
  "Ь": "B",
  "Э": "3",
  "Ю": "X",
  "Я": "R",
  "а": "a",
  "б": "b",
  "в": "a",
  "г": "r",
  "д": "y",
  "е": "e",
  "ж": "m",
  "з": "e",
  "и": "n",
  "й": "n",
  "к": "n",
  "л": "n",
  "м": "m",
  "н": "n",
  "о": "o",
  "п": "n",
  "р": "p",
  "с": "c",
  "т": "o",
  "у": "y",
  "ф": "b",
  "х": "x",
  "ц": "n",
  "ч": "n",
  "ш": "w",
  "щ": "w",
  "ъ": "a",
  "ы": "m",
  "ь": "a",
  "э": "e",
  "ю": "m",
  "я": "r"
};
function getCharacterMetrics(character, font, mode) {
  if (!fontMetricsData[font]) {
    throw new Error("Font metrics not found for font: " + font + ".");
  }
  var ch = character.charCodeAt(0);
  var metrics = fontMetricsData[font][ch];
  if (!metrics && character[0] in extraCharacterMap) {
    ch = extraCharacterMap[character[0]].charCodeAt(0);
    metrics = fontMetricsData[font][ch];
  }
  if (!metrics && mode === "text") {
    if (supportedCodepoint(ch)) {
      metrics = fontMetricsData[font][77];
    }
  }
  if (metrics) {
    return {
      depth: metrics[0],
      height: metrics[1],
      italic: metrics[2],
      skew: metrics[3],
      width: metrics[4]
    };
  }
}
var ptPerUnit = {
  // https://en.wikibooks.org/wiki/LaTeX/Lengths and
  // https://tex.stackexchange.com/a/8263
  "pt": 1,
  // TeX point
  "mm": 7227 / 2540,
  // millimeter
  "cm": 7227 / 254,
  // centimeter
  "in": 72.27,
  // inch
  "bp": 803 / 800,
  // big (PostScript) points
  "pc": 12,
  // pica
  "dd": 1238 / 1157,
  // didot
  "cc": 14856 / 1157,
  // cicero (12 didot)
  "nd": 685 / 642,
  // new didot
  "nc": 1370 / 107,
  // new cicero (12 new didot)
  "sp": 1 / 65536,
  // scaled point (TeX's internal smallest unit)
  // https://tex.stackexchange.com/a/41371
  "px": 803 / 800
  // \pdfpxdimen defaults to 1 bp in pdfTeX and LuaTeX
};
var relativeUnit = {
  "ex": true,
  "em": true,
  "mu": true
};
var validUnit = function validUnit2(unit) {
  if (typeof unit !== "string") {
    unit = unit.unit;
  }
  return unit in ptPerUnit || unit in relativeUnit || unit === "ex";
};
var calculateSize = function calculateSize2(sizeValue, options2) {
  var scale;
  if (sizeValue.unit in ptPerUnit) {
    scale = ptPerUnit[sizeValue.unit] / options2.fontMetrics().ptPerEm / options2.sizeMultiplier;
  } else if (sizeValue.unit === "mu") {
    scale = options2.fontMetrics().cssEmPerMu;
  } else {
    var unitOptions;
    if (options2.style.isTight()) {
      unitOptions = options2.havingStyle(options2.style.text());
    } else {
      unitOptions = options2;
    }
    if (sizeValue.unit === "ex") {
      scale = unitOptions.fontMetrics().xHeight;
    } else if (sizeValue.unit === "em") {
      scale = unitOptions.fontMetrics().quad;
    } else {
      throw new ParseError("Invalid unit: '" + sizeValue.unit + "'");
    }
    if (unitOptions !== options2) {
      scale *= unitOptions.sizeMultiplier / options2.sizeMultiplier;
    }
  }
  return Math.min(sizeValue.number * scale, options2.maxSize);
};
var makeEm = function makeEm2(n) {
  return +n.toFixed(4) + "em";
};
var createClass = function createClass2(classes) {
  return classes.filter((cls) => cls).join(" ");
};
var initNode = function initNode2(classes, options2, style) {
  this.classes = classes || [];
  this.attributes = {};
  this.height = 0;
  this.depth = 0;
  this.maxFontSize = 0;
  this.style = style || {};
  if (options2) {
    if (options2.style.isTight()) {
      this.classes.push("mtight");
    }
    var color = options2.getColor();
    if (color) {
      this.style.color = color;
    }
  }
};
var toNode = function toNode2(tagName) {
  var node2 = document.createElement(tagName);
  node2.className = createClass(this.classes);
  for (var style in this.style) {
    if (this.style.hasOwnProperty(style)) {
      node2.style[style] = this.style[style];
    }
  }
  for (var attr in this.attributes) {
    if (this.attributes.hasOwnProperty(attr)) {
      node2.setAttribute(attr, this.attributes[attr]);
    }
  }
  for (var i = 0; i < this.children.length; i++) {
    node2.appendChild(this.children[i].toNode());
  }
  return node2;
};
var toMarkup = function toMarkup2(tagName) {
  var markup = "<" + tagName;
  if (this.classes.length) {
    markup += ' class="' + utils.escape(createClass(this.classes)) + '"';
  }
  var styles2 = "";
  for (var style in this.style) {
    if (this.style.hasOwnProperty(style)) {
      styles2 += utils.hyphenate(style) + ":" + this.style[style] + ";";
    }
  }
  if (styles2) {
    markup += ' style="' + utils.escape(styles2) + '"';
  }
  for (var attr in this.attributes) {
    if (this.attributes.hasOwnProperty(attr)) {
      markup += " " + attr + '="' + utils.escape(this.attributes[attr]) + '"';
    }
  }
  markup += ">";
  for (var i = 0; i < this.children.length; i++) {
    markup += this.children[i].toMarkup();
  }
  markup += "</" + tagName + ">";
  return markup;
};
class Span {
  constructor(classes, children, options2, style) {
    this.children = void 0;
    this.attributes = void 0;
    this.classes = void 0;
    this.height = void 0;
    this.depth = void 0;
    this.width = void 0;
    this.maxFontSize = void 0;
    this.style = void 0;
    initNode.call(this, classes, options2, style);
    this.children = children || [];
  }
  /**
   * Sets an arbitrary attribute on the span. Warning: use this wisely. Not
   * all browsers support attributes the same, and having too many custom
   * attributes is probably bad.
   */
  setAttribute(attribute, value) {
    this.attributes[attribute] = value;
  }
  hasClass(className) {
    return utils.contains(this.classes, className);
  }
  toNode() {
    return toNode.call(this, "span");
  }
  toMarkup() {
    return toMarkup.call(this, "span");
  }
}
class Anchor {
  constructor(href, classes, children, options2) {
    this.children = void 0;
    this.attributes = void 0;
    this.classes = void 0;
    this.height = void 0;
    this.depth = void 0;
    this.maxFontSize = void 0;
    this.style = void 0;
    initNode.call(this, classes, options2);
    this.children = children || [];
    this.setAttribute("href", href);
  }
  setAttribute(attribute, value) {
    this.attributes[attribute] = value;
  }
  hasClass(className) {
    return utils.contains(this.classes, className);
  }
  toNode() {
    return toNode.call(this, "a");
  }
  toMarkup() {
    return toMarkup.call(this, "a");
  }
}
class Img {
  constructor(src, alt, style) {
    this.src = void 0;
    this.alt = void 0;
    this.classes = void 0;
    this.height = void 0;
    this.depth = void 0;
    this.maxFontSize = void 0;
    this.style = void 0;
    this.alt = alt;
    this.src = src;
    this.classes = ["mord"];
    this.style = style;
  }
  hasClass(className) {
    return utils.contains(this.classes, className);
  }
  toNode() {
    var node2 = document.createElement("img");
    node2.src = this.src;
    node2.alt = this.alt;
    node2.className = "mord";
    for (var style in this.style) {
      if (this.style.hasOwnProperty(style)) {
        node2.style[style] = this.style[style];
      }
    }
    return node2;
  }
  toMarkup() {
    var markup = '<img src="' + utils.escape(this.src) + '"' + (' alt="' + utils.escape(this.alt) + '"');
    var styles2 = "";
    for (var style in this.style) {
      if (this.style.hasOwnProperty(style)) {
        styles2 += utils.hyphenate(style) + ":" + this.style[style] + ";";
      }
    }
    if (styles2) {
      markup += ' style="' + utils.escape(styles2) + '"';
    }
    markup += "'/>";
    return markup;
  }
}
var iCombinations = {
  "î": "ı̂",
  "ï": "ı̈",
  "í": "ı́",
  // 'ī': '\u0131\u0304', // enable when we add Extended Latin
  "ì": "ı̀"
};
class SymbolNode {
  constructor(text2, height, depth, italic, skew, width, classes, style) {
    this.text = void 0;
    this.height = void 0;
    this.depth = void 0;
    this.italic = void 0;
    this.skew = void 0;
    this.width = void 0;
    this.maxFontSize = void 0;
    this.classes = void 0;
    this.style = void 0;
    this.text = text2;
    this.height = height || 0;
    this.depth = depth || 0;
    this.italic = italic || 0;
    this.skew = skew || 0;
    this.width = width || 0;
    this.classes = classes || [];
    this.style = style || {};
    this.maxFontSize = 0;
    var script = scriptFromCodepoint(this.text.charCodeAt(0));
    if (script) {
      this.classes.push(script + "_fallback");
    }
    if (/[îïíì]/.test(this.text)) {
      this.text = iCombinations[this.text];
    }
  }
  hasClass(className) {
    return utils.contains(this.classes, className);
  }
  /**
   * Creates a text node or span from a symbol node. Note that a span is only
   * created if it is needed.
   */
  toNode() {
    var node2 = document.createTextNode(this.text);
    var span = null;
    if (this.italic > 0) {
      span = document.createElement("span");
      span.style.marginRight = makeEm(this.italic);
    }
    if (this.classes.length > 0) {
      span = span || document.createElement("span");
      span.className = createClass(this.classes);
    }
    for (var style in this.style) {
      if (this.style.hasOwnProperty(style)) {
        span = span || document.createElement("span");
        span.style[style] = this.style[style];
      }
    }
    if (span) {
      span.appendChild(node2);
      return span;
    } else {
      return node2;
    }
  }
  /**
   * Creates markup for a symbol node.
   */
  toMarkup() {
    var needsSpan = false;
    var markup = "<span";
    if (this.classes.length) {
      needsSpan = true;
      markup += ' class="';
      markup += utils.escape(createClass(this.classes));
      markup += '"';
    }
    var styles2 = "";
    if (this.italic > 0) {
      styles2 += "margin-right:" + this.italic + "em;";
    }
    for (var style in this.style) {
      if (this.style.hasOwnProperty(style)) {
        styles2 += utils.hyphenate(style) + ":" + this.style[style] + ";";
      }
    }
    if (styles2) {
      needsSpan = true;
      markup += ' style="' + utils.escape(styles2) + '"';
    }
    var escaped = utils.escape(this.text);
    if (needsSpan) {
      markup += ">";
      markup += escaped;
      markup += "</span>";
      return markup;
    } else {
      return escaped;
    }
  }
}
class SvgNode {
  constructor(children, attributes) {
    this.children = void 0;
    this.attributes = void 0;
    this.children = children || [];
    this.attributes = attributes || {};
  }
  toNode() {
    var svgNS = "http://www.w3.org/2000/svg";
    var node2 = document.createElementNS(svgNS, "svg");
    for (var attr in this.attributes) {
      if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
        node2.setAttribute(attr, this.attributes[attr]);
      }
    }
    for (var i = 0; i < this.children.length; i++) {
      node2.appendChild(this.children[i].toNode());
    }
    return node2;
  }
  toMarkup() {
    var markup = '<svg xmlns="http://www.w3.org/2000/svg"';
    for (var attr in this.attributes) {
      if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
        markup += " " + attr + '="' + utils.escape(this.attributes[attr]) + '"';
      }
    }
    markup += ">";
    for (var i = 0; i < this.children.length; i++) {
      markup += this.children[i].toMarkup();
    }
    markup += "</svg>";
    return markup;
  }
}
class PathNode {
  constructor(pathName, alternate) {
    this.pathName = void 0;
    this.alternate = void 0;
    this.pathName = pathName;
    this.alternate = alternate;
  }
  toNode() {
    var svgNS = "http://www.w3.org/2000/svg";
    var node2 = document.createElementNS(svgNS, "path");
    if (this.alternate) {
      node2.setAttribute("d", this.alternate);
    } else {
      node2.setAttribute("d", path[this.pathName]);
    }
    return node2;
  }
  toMarkup() {
    if (this.alternate) {
      return '<path d="' + utils.escape(this.alternate) + '"/>';
    } else {
      return '<path d="' + utils.escape(path[this.pathName]) + '"/>';
    }
  }
}
class LineNode {
  constructor(attributes) {
    this.attributes = void 0;
    this.attributes = attributes || {};
  }
  toNode() {
    var svgNS = "http://www.w3.org/2000/svg";
    var node2 = document.createElementNS(svgNS, "line");
    for (var attr in this.attributes) {
      if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
        node2.setAttribute(attr, this.attributes[attr]);
      }
    }
    return node2;
  }
  toMarkup() {
    var markup = "<line";
    for (var attr in this.attributes) {
      if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
        markup += " " + attr + '="' + utils.escape(this.attributes[attr]) + '"';
      }
    }
    markup += "/>";
    return markup;
  }
}
function assertSymbolDomNode(group) {
  if (group instanceof SymbolNode) {
    return group;
  } else {
    throw new Error("Expected symbolNode but got " + String(group) + ".");
  }
}
function assertSpan(group) {
  if (group instanceof Span) {
    return group;
  } else {
    throw new Error("Expected span<HtmlDomNode> but got " + String(group) + ".");
  }
}
var NON_ATOMS = {
  "accent-token": 1,
  "mathord": 1,
  "op-token": 1,
  "spacing": 1,
  "textord": 1
};
var symbols = {
  "math": {},
  "text": {}
};
function defineSymbol(mode, font, group, replace, name, acceptUnicodeChar) {
  symbols[mode][name] = {
    font,
    group,
    replace
  };
  if (acceptUnicodeChar && replace) {
    symbols[mode][replace] = symbols[mode][name];
  }
}
var math = "math";
var text$2 = "text";
var main = "main";
var ams = "ams";
var accent = "accent-token";
var bin = "bin";
var close = "close";
var inner = "inner";
var mathord = "mathord";
var op = "op-token";
var open = "open";
var punct = "punct";
var rel = "rel";
var spacing = "spacing";
var textord = "textord";
defineSymbol(math, main, rel, "≡", "\\equiv", true);
defineSymbol(math, main, rel, "≺", "\\prec", true);
defineSymbol(math, main, rel, "≻", "\\succ", true);
defineSymbol(math, main, rel, "∼", "\\sim", true);
defineSymbol(math, main, rel, "⊥", "\\perp");
defineSymbol(math, main, rel, "⪯", "\\preceq", true);
defineSymbol(math, main, rel, "⪰", "\\succeq", true);
defineSymbol(math, main, rel, "≃", "\\simeq", true);
defineSymbol(math, main, rel, "∣", "\\mid", true);
defineSymbol(math, main, rel, "≪", "\\ll", true);
defineSymbol(math, main, rel, "≫", "\\gg", true);
defineSymbol(math, main, rel, "≍", "\\asymp", true);
defineSymbol(math, main, rel, "∥", "\\parallel");
defineSymbol(math, main, rel, "⋈", "\\bowtie", true);
defineSymbol(math, main, rel, "⌣", "\\smile", true);
defineSymbol(math, main, rel, "⊑", "\\sqsubseteq", true);
defineSymbol(math, main, rel, "⊒", "\\sqsupseteq", true);
defineSymbol(math, main, rel, "≐", "\\doteq", true);
defineSymbol(math, main, rel, "⌢", "\\frown", true);
defineSymbol(math, main, rel, "∋", "\\ni", true);
defineSymbol(math, main, rel, "∝", "\\propto", true);
defineSymbol(math, main, rel, "⊢", "\\vdash", true);
defineSymbol(math, main, rel, "⊣", "\\dashv", true);
defineSymbol(math, main, rel, "∋", "\\owns");
defineSymbol(math, main, punct, ".", "\\ldotp");
defineSymbol(math, main, punct, "⋅", "\\cdotp");
defineSymbol(math, main, textord, "#", "\\#");
defineSymbol(text$2, main, textord, "#", "\\#");
defineSymbol(math, main, textord, "&", "\\&");
defineSymbol(text$2, main, textord, "&", "\\&");
defineSymbol(math, main, textord, "ℵ", "\\aleph", true);
defineSymbol(math, main, textord, "∀", "\\forall", true);
defineSymbol(math, main, textord, "ℏ", "\\hbar", true);
defineSymbol(math, main, textord, "∃", "\\exists", true);
defineSymbol(math, main, textord, "∇", "\\nabla", true);
defineSymbol(math, main, textord, "♭", "\\flat", true);
defineSymbol(math, main, textord, "ℓ", "\\ell", true);
defineSymbol(math, main, textord, "♮", "\\natural", true);
defineSymbol(math, main, textord, "♣", "\\clubsuit", true);
defineSymbol(math, main, textord, "℘", "\\wp", true);
defineSymbol(math, main, textord, "♯", "\\sharp", true);
defineSymbol(math, main, textord, "♢", "\\diamondsuit", true);
defineSymbol(math, main, textord, "ℜ", "\\Re", true);
defineSymbol(math, main, textord, "♡", "\\heartsuit", true);
defineSymbol(math, main, textord, "ℑ", "\\Im", true);
defineSymbol(math, main, textord, "♠", "\\spadesuit", true);
defineSymbol(math, main, textord, "§", "\\S", true);
defineSymbol(text$2, main, textord, "§", "\\S");
defineSymbol(math, main, textord, "¶", "\\P", true);
defineSymbol(text$2, main, textord, "¶", "\\P");
defineSymbol(math, main, textord, "†", "\\dag");
defineSymbol(text$2, main, textord, "†", "\\dag");
defineSymbol(text$2, main, textord, "†", "\\textdagger");
defineSymbol(math, main, textord, "‡", "\\ddag");
defineSymbol(text$2, main, textord, "‡", "\\ddag");
defineSymbol(text$2, main, textord, "‡", "\\textdaggerdbl");
defineSymbol(math, main, close, "⎱", "\\rmoustache", true);
defineSymbol(math, main, open, "⎰", "\\lmoustache", true);
defineSymbol(math, main, close, "⟯", "\\rgroup", true);
defineSymbol(math, main, open, "⟮", "\\lgroup", true);
defineSymbol(math, main, bin, "∓", "\\mp", true);
defineSymbol(math, main, bin, "⊖", "\\ominus", true);
defineSymbol(math, main, bin, "⊎", "\\uplus", true);
defineSymbol(math, main, bin, "⊓", "\\sqcap", true);
defineSymbol(math, main, bin, "∗", "\\ast");
defineSymbol(math, main, bin, "⊔", "\\sqcup", true);
defineSymbol(math, main, bin, "◯", "\\bigcirc", true);
defineSymbol(math, main, bin, "∙", "\\bullet", true);
defineSymbol(math, main, bin, "‡", "\\ddagger");
defineSymbol(math, main, bin, "≀", "\\wr", true);
defineSymbol(math, main, bin, "⨿", "\\amalg");
defineSymbol(math, main, bin, "&", "\\And");
defineSymbol(math, main, rel, "⟵", "\\longleftarrow", true);
defineSymbol(math, main, rel, "⇐", "\\Leftarrow", true);
defineSymbol(math, main, rel, "⟸", "\\Longleftarrow", true);
defineSymbol(math, main, rel, "⟶", "\\longrightarrow", true);
defineSymbol(math, main, rel, "⇒", "\\Rightarrow", true);
defineSymbol(math, main, rel, "⟹", "\\Longrightarrow", true);
defineSymbol(math, main, rel, "↔", "\\leftrightarrow", true);
defineSymbol(math, main, rel, "⟷", "\\longleftrightarrow", true);
defineSymbol(math, main, rel, "⇔", "\\Leftrightarrow", true);
defineSymbol(math, main, rel, "⟺", "\\Longleftrightarrow", true);
defineSymbol(math, main, rel, "↦", "\\mapsto", true);
defineSymbol(math, main, rel, "⟼", "\\longmapsto", true);
defineSymbol(math, main, rel, "↗", "\\nearrow", true);
defineSymbol(math, main, rel, "↩", "\\hookleftarrow", true);
defineSymbol(math, main, rel, "↪", "\\hookrightarrow", true);
defineSymbol(math, main, rel, "↘", "\\searrow", true);
defineSymbol(math, main, rel, "↼", "\\leftharpoonup", true);
defineSymbol(math, main, rel, "⇀", "\\rightharpoonup", true);
defineSymbol(math, main, rel, "↙", "\\swarrow", true);
defineSymbol(math, main, rel, "↽", "\\leftharpoondown", true);
defineSymbol(math, main, rel, "⇁", "\\rightharpoondown", true);
defineSymbol(math, main, rel, "↖", "\\nwarrow", true);
defineSymbol(math, main, rel, "⇌", "\\rightleftharpoons", true);
defineSymbol(math, ams, rel, "≮", "\\nless", true);
defineSymbol(math, ams, rel, "", "\\@nleqslant");
defineSymbol(math, ams, rel, "", "\\@nleqq");
defineSymbol(math, ams, rel, "⪇", "\\lneq", true);
defineSymbol(math, ams, rel, "≨", "\\lneqq", true);
defineSymbol(math, ams, rel, "", "\\@lvertneqq");
defineSymbol(math, ams, rel, "⋦", "\\lnsim", true);
defineSymbol(math, ams, rel, "⪉", "\\lnapprox", true);
defineSymbol(math, ams, rel, "⊀", "\\nprec", true);
defineSymbol(math, ams, rel, "⋠", "\\npreceq", true);
defineSymbol(math, ams, rel, "⋨", "\\precnsim", true);
defineSymbol(math, ams, rel, "⪹", "\\precnapprox", true);
defineSymbol(math, ams, rel, "≁", "\\nsim", true);
defineSymbol(math, ams, rel, "", "\\@nshortmid");
defineSymbol(math, ams, rel, "∤", "\\nmid", true);
defineSymbol(math, ams, rel, "⊬", "\\nvdash", true);
defineSymbol(math, ams, rel, "⊭", "\\nvDash", true);
defineSymbol(math, ams, rel, "⋪", "\\ntriangleleft");
defineSymbol(math, ams, rel, "⋬", "\\ntrianglelefteq", true);
defineSymbol(math, ams, rel, "⊊", "\\subsetneq", true);
defineSymbol(math, ams, rel, "", "\\@varsubsetneq");
defineSymbol(math, ams, rel, "⫋", "\\subsetneqq", true);
defineSymbol(math, ams, rel, "", "\\@varsubsetneqq");
defineSymbol(math, ams, rel, "≯", "\\ngtr", true);
defineSymbol(math, ams, rel, "", "\\@ngeqslant");
defineSymbol(math, ams, rel, "", "\\@ngeqq");
defineSymbol(math, ams, rel, "⪈", "\\gneq", true);
defineSymbol(math, ams, rel, "≩", "\\gneqq", true);
defineSymbol(math, ams, rel, "", "\\@gvertneqq");
defineSymbol(math, ams, rel, "⋧", "\\gnsim", true);
defineSymbol(math, ams, rel, "⪊", "\\gnapprox", true);
defineSymbol(math, ams, rel, "⊁", "\\nsucc", true);
defineSymbol(math, ams, rel, "⋡", "\\nsucceq", true);
defineSymbol(math, ams, rel, "⋩", "\\succnsim", true);
defineSymbol(math, ams, rel, "⪺", "\\succnapprox", true);
defineSymbol(math, ams, rel, "≆", "\\ncong", true);
defineSymbol(math, ams, rel, "", "\\@nshortparallel");
defineSymbol(math, ams, rel, "∦", "\\nparallel", true);
defineSymbol(math, ams, rel, "⊯", "\\nVDash", true);
defineSymbol(math, ams, rel, "⋫", "\\ntriangleright");
defineSymbol(math, ams, rel, "⋭", "\\ntrianglerighteq", true);
defineSymbol(math, ams, rel, "", "\\@nsupseteqq");
defineSymbol(math, ams, rel, "⊋", "\\supsetneq", true);
defineSymbol(math, ams, rel, "", "\\@varsupsetneq");
defineSymbol(math, ams, rel, "⫌", "\\supsetneqq", true);
defineSymbol(math, ams, rel, "", "\\@varsupsetneqq");
defineSymbol(math, ams, rel, "⊮", "\\nVdash", true);
defineSymbol(math, ams, rel, "⪵", "\\precneqq", true);
defineSymbol(math, ams, rel, "⪶", "\\succneqq", true);
defineSymbol(math, ams, rel, "", "\\@nsubseteqq");
defineSymbol(math, ams, bin, "⊴", "\\unlhd");
defineSymbol(math, ams, bin, "⊵", "\\unrhd");
defineSymbol(math, ams, rel, "↚", "\\nleftarrow", true);
defineSymbol(math, ams, rel, "↛", "\\nrightarrow", true);
defineSymbol(math, ams, rel, "⇍", "\\nLeftarrow", true);
defineSymbol(math, ams, rel, "⇏", "\\nRightarrow", true);
defineSymbol(math, ams, rel, "↮", "\\nleftrightarrow", true);
defineSymbol(math, ams, rel, "⇎", "\\nLeftrightarrow", true);
defineSymbol(math, ams, rel, "△", "\\vartriangle");
defineSymbol(math, ams, textord, "ℏ", "\\hslash");
defineSymbol(math, ams, textord, "▽", "\\triangledown");
defineSymbol(math, ams, textord, "◊", "\\lozenge");
defineSymbol(math, ams, textord, "Ⓢ", "\\circledS");
defineSymbol(math, ams, textord, "®", "\\circledR");
defineSymbol(text$2, ams, textord, "®", "\\circledR");
defineSymbol(math, ams, textord, "∡", "\\measuredangle", true);
defineSymbol(math, ams, textord, "∄", "\\nexists");
defineSymbol(math, ams, textord, "℧", "\\mho");
defineSymbol(math, ams, textord, "Ⅎ", "\\Finv", true);
defineSymbol(math, ams, textord, "⅁", "\\Game", true);
defineSymbol(math, ams, textord, "‵", "\\backprime");
defineSymbol(math, ams, textord, "▲", "\\blacktriangle");
defineSymbol(math, ams, textord, "▼", "\\blacktriangledown");
defineSymbol(math, ams, textord, "■", "\\blacksquare");
defineSymbol(math, ams, textord, "⧫", "\\blacklozenge");
defineSymbol(math, ams, textord, "★", "\\bigstar");
defineSymbol(math, ams, textord, "∢", "\\sphericalangle", true);
defineSymbol(math, ams, textord, "∁", "\\complement", true);
defineSymbol(math, ams, textord, "ð", "\\eth", true);
defineSymbol(text$2, main, textord, "ð", "ð");
defineSymbol(math, ams, textord, "╱", "\\diagup");
defineSymbol(math, ams, textord, "╲", "\\diagdown");
defineSymbol(math, ams, textord, "□", "\\square");
defineSymbol(math, ams, textord, "□", "\\Box");
defineSymbol(math, ams, textord, "◊", "\\Diamond");
defineSymbol(math, ams, textord, "¥", "\\yen", true);
defineSymbol(text$2, ams, textord, "¥", "\\yen", true);
defineSymbol(math, ams, textord, "✓", "\\checkmark", true);
defineSymbol(text$2, ams, textord, "✓", "\\checkmark");
defineSymbol(math, ams, textord, "ℶ", "\\beth", true);
defineSymbol(math, ams, textord, "ℸ", "\\daleth", true);
defineSymbol(math, ams, textord, "ℷ", "\\gimel", true);
defineSymbol(math, ams, textord, "ϝ", "\\digamma", true);
defineSymbol(math, ams, textord, "ϰ", "\\varkappa");
defineSymbol(math, ams, open, "┌", "\\@ulcorner", true);
defineSymbol(math, ams, close, "┐", "\\@urcorner", true);
defineSymbol(math, ams, open, "└", "\\@llcorner", true);
defineSymbol(math, ams, close, "┘", "\\@lrcorner", true);
defineSymbol(math, ams, rel, "≦", "\\leqq", true);
defineSymbol(math, ams, rel, "⩽", "\\leqslant", true);
defineSymbol(math, ams, rel, "⪕", "\\eqslantless", true);
defineSymbol(math, ams, rel, "≲", "\\lesssim", true);
defineSymbol(math, ams, rel, "⪅", "\\lessapprox", true);
defineSymbol(math, ams, rel, "≊", "\\approxeq", true);
defineSymbol(math, ams, bin, "⋖", "\\lessdot");
defineSymbol(math, ams, rel, "⋘", "\\lll", true);
defineSymbol(math, ams, rel, "≶", "\\lessgtr", true);
defineSymbol(math, ams, rel, "⋚", "\\lesseqgtr", true);
defineSymbol(math, ams, rel, "⪋", "\\lesseqqgtr", true);
defineSymbol(math, ams, rel, "≑", "\\doteqdot");
defineSymbol(math, ams, rel, "≓", "\\risingdotseq", true);
defineSymbol(math, ams, rel, "≒", "\\fallingdotseq", true);
defineSymbol(math, ams, rel, "∽", "\\backsim", true);
defineSymbol(math, ams, rel, "⋍", "\\backsimeq", true);
defineSymbol(math, ams, rel, "⫅", "\\subseteqq", true);
defineSymbol(math, ams, rel, "⋐", "\\Subset", true);
defineSymbol(math, ams, rel, "⊏", "\\sqsubset", true);
defineSymbol(math, ams, rel, "≼", "\\preccurlyeq", true);
defineSymbol(math, ams, rel, "⋞", "\\curlyeqprec", true);
defineSymbol(math, ams, rel, "≾", "\\precsim", true);
defineSymbol(math, ams, rel, "⪷", "\\precapprox", true);
defineSymbol(math, ams, rel, "⊲", "\\vartriangleleft");
defineSymbol(math, ams, rel, "⊴", "\\trianglelefteq");
defineSymbol(math, ams, rel, "⊨", "\\vDash", true);
defineSymbol(math, ams, rel, "⊪", "\\Vvdash", true);
defineSymbol(math, ams, rel, "⌣", "\\smallsmile");
defineSymbol(math, ams, rel, "⌢", "\\smallfrown");
defineSymbol(math, ams, rel, "≏", "\\bumpeq", true);
defineSymbol(math, ams, rel, "≎", "\\Bumpeq", true);
defineSymbol(math, ams, rel, "≧", "\\geqq", true);
defineSymbol(math, ams, rel, "⩾", "\\geqslant", true);
defineSymbol(math, ams, rel, "⪖", "\\eqslantgtr", true);
defineSymbol(math, ams, rel, "≳", "\\gtrsim", true);
defineSymbol(math, ams, rel, "⪆", "\\gtrapprox", true);
defineSymbol(math, ams, bin, "⋗", "\\gtrdot");
defineSymbol(math, ams, rel, "⋙", "\\ggg", true);
defineSymbol(math, ams, rel, "≷", "\\gtrless", true);
defineSymbol(math, ams, rel, "⋛", "\\gtreqless", true);
defineSymbol(math, ams, rel, "⪌", "\\gtreqqless", true);
defineSymbol(math, ams, rel, "≖", "\\eqcirc", true);
defineSymbol(math, ams, rel, "≗", "\\circeq", true);
defineSymbol(math, ams, rel, "≜", "\\triangleq", true);
defineSymbol(math, ams, rel, "∼", "\\thicksim");
defineSymbol(math, ams, rel, "≈", "\\thickapprox");
defineSymbol(math, ams, rel, "⫆", "\\supseteqq", true);
defineSymbol(math, ams, rel, "⋑", "\\Supset", true);
defineSymbol(math, ams, rel, "⊐", "\\sqsupset", true);
defineSymbol(math, ams, rel, "≽", "\\succcurlyeq", true);
defineSymbol(math, ams, rel, "⋟", "\\curlyeqsucc", true);
defineSymbol(math, ams, rel, "≿", "\\succsim", true);
defineSymbol(math, ams, rel, "⪸", "\\succapprox", true);
defineSymbol(math, ams, rel, "⊳", "\\vartriangleright");
defineSymbol(math, ams, rel, "⊵", "\\trianglerighteq");
defineSymbol(math, ams, rel, "⊩", "\\Vdash", true);
defineSymbol(math, ams, rel, "∣", "\\shortmid");
defineSymbol(math, ams, rel, "∥", "\\shortparallel");
defineSymbol(math, ams, rel, "≬", "\\between", true);
defineSymbol(math, ams, rel, "⋔", "\\pitchfork", true);
defineSymbol(math, ams, rel, "∝", "\\varpropto");
defineSymbol(math, ams, rel, "◀", "\\blacktriangleleft");
defineSymbol(math, ams, rel, "∴", "\\therefore", true);
defineSymbol(math, ams, rel, "∍", "\\backepsilon");
defineSymbol(math, ams, rel, "▶", "\\blacktriangleright");
defineSymbol(math, ams, rel, "∵", "\\because", true);
defineSymbol(math, ams, rel, "⋘", "\\llless");
defineSymbol(math, ams, rel, "⋙", "\\gggtr");
defineSymbol(math, ams, bin, "⊲", "\\lhd");
defineSymbol(math, ams, bin, "⊳", "\\rhd");
defineSymbol(math, ams, rel, "≂", "\\eqsim", true);
defineSymbol(math, main, rel, "⋈", "\\Join");
defineSymbol(math, ams, rel, "≑", "\\Doteq", true);
defineSymbol(math, ams, bin, "∔", "\\dotplus", true);
defineSymbol(math, ams, bin, "∖", "\\smallsetminus");
defineSymbol(math, ams, bin, "⋒", "\\Cap", true);
defineSymbol(math, ams, bin, "⋓", "\\Cup", true);
defineSymbol(math, ams, bin, "⩞", "\\doublebarwedge", true);
defineSymbol(math, ams, bin, "⊟", "\\boxminus", true);
defineSymbol(math, ams, bin, "⊞", "\\boxplus", true);
defineSymbol(math, ams, bin, "⋇", "\\divideontimes", true);
defineSymbol(math, ams, bin, "⋉", "\\ltimes", true);
defineSymbol(math, ams, bin, "⋊", "\\rtimes", true);
defineSymbol(math, ams, bin, "⋋", "\\leftthreetimes", true);
defineSymbol(math, ams, bin, "⋌", "\\rightthreetimes", true);
defineSymbol(math, ams, bin, "⋏", "\\curlywedge", true);
defineSymbol(math, ams, bin, "⋎", "\\curlyvee", true);
defineSymbol(math, ams, bin, "⊝", "\\circleddash", true);
defineSymbol(math, ams, bin, "⊛", "\\circledast", true);
defineSymbol(math, ams, bin, "⋅", "\\centerdot");
defineSymbol(math, ams, bin, "⊺", "\\intercal", true);
defineSymbol(math, ams, bin, "⋒", "\\doublecap");
defineSymbol(math, ams, bin, "⋓", "\\doublecup");
defineSymbol(math, ams, bin, "⊠", "\\boxtimes", true);
defineSymbol(math, ams, rel, "⇢", "\\dashrightarrow", true);
defineSymbol(math, ams, rel, "⇠", "\\dashleftarrow", true);
defineSymbol(math, ams, rel, "⇇", "\\leftleftarrows", true);
defineSymbol(math, ams, rel, "⇆", "\\leftrightarrows", true);
defineSymbol(math, ams, rel, "⇚", "\\Lleftarrow", true);
defineSymbol(math, ams, rel, "↞", "\\twoheadleftarrow", true);
defineSymbol(math, ams, rel, "↢", "\\leftarrowtail", true);
defineSymbol(math, ams, rel, "↫", "\\looparrowleft", true);
defineSymbol(math, ams, rel, "⇋", "\\leftrightharpoons", true);
defineSymbol(math, ams, rel, "↶", "\\curvearrowleft", true);
defineSymbol(math, ams, rel, "↺", "\\circlearrowleft", true);
defineSymbol(math, ams, rel, "↰", "\\Lsh", true);
defineSymbol(math, ams, rel, "⇈", "\\upuparrows", true);
defineSymbol(math, ams, rel, "↿", "\\upharpoonleft", true);
defineSymbol(math, ams, rel, "⇃", "\\downharpoonleft", true);
defineSymbol(math, main, rel, "⊶", "\\origof", true);
defineSymbol(math, main, rel, "⊷", "\\imageof", true);
defineSymbol(math, ams, rel, "⊸", "\\multimap", true);
defineSymbol(math, ams, rel, "↭", "\\leftrightsquigarrow", true);
defineSymbol(math, ams, rel, "⇉", "\\rightrightarrows", true);
defineSymbol(math, ams, rel, "⇄", "\\rightleftarrows", true);
defineSymbol(math, ams, rel, "↠", "\\twoheadrightarrow", true);
defineSymbol(math, ams, rel, "↣", "\\rightarrowtail", true);
defineSymbol(math, ams, rel, "↬", "\\looparrowright", true);
defineSymbol(math, ams, rel, "↷", "\\curvearrowright", true);
defineSymbol(math, ams, rel, "↻", "\\circlearrowright", true);
defineSymbol(math, ams, rel, "↱", "\\Rsh", true);
defineSymbol(math, ams, rel, "⇊", "\\downdownarrows", true);
defineSymbol(math, ams, rel, "↾", "\\upharpoonright", true);
defineSymbol(math, ams, rel, "⇂", "\\downharpoonright", true);
defineSymbol(math, ams, rel, "⇝", "\\rightsquigarrow", true);
defineSymbol(math, ams, rel, "⇝", "\\leadsto");
defineSymbol(math, ams, rel, "⇛", "\\Rrightarrow", true);
defineSymbol(math, ams, rel, "↾", "\\restriction");
defineSymbol(math, main, textord, "‘", "`");
defineSymbol(math, main, textord, "$", "\\$");
defineSymbol(text$2, main, textord, "$", "\\$");
defineSymbol(text$2, main, textord, "$", "\\textdollar");
defineSymbol(math, main, textord, "%", "\\%");
defineSymbol(text$2, main, textord, "%", "\\%");
defineSymbol(math, main, textord, "_", "\\_");
defineSymbol(text$2, main, textord, "_", "\\_");
defineSymbol(text$2, main, textord, "_", "\\textunderscore");
defineSymbol(math, main, textord, "∠", "\\angle", true);
defineSymbol(math, main, textord, "∞", "\\infty", true);
defineSymbol(math, main, textord, "′", "\\prime");
defineSymbol(math, main, textord, "△", "\\triangle");
defineSymbol(math, main, textord, "Γ", "\\Gamma", true);
defineSymbol(math, main, textord, "Δ", "\\Delta", true);
defineSymbol(math, main, textord, "Θ", "\\Theta", true);
defineSymbol(math, main, textord, "Λ", "\\Lambda", true);
defineSymbol(math, main, textord, "Ξ", "\\Xi", true);
defineSymbol(math, main, textord, "Π", "\\Pi", true);
defineSymbol(math, main, textord, "Σ", "\\Sigma", true);
defineSymbol(math, main, textord, "Υ", "\\Upsilon", true);
defineSymbol(math, main, textord, "Φ", "\\Phi", true);
defineSymbol(math, main, textord, "Ψ", "\\Psi", true);
defineSymbol(math, main, textord, "Ω", "\\Omega", true);
defineSymbol(math, main, textord, "A", "Α");
defineSymbol(math, main, textord, "B", "Β");
defineSymbol(math, main, textord, "E", "Ε");
defineSymbol(math, main, textord, "Z", "Ζ");
defineSymbol(math, main, textord, "H", "Η");
defineSymbol(math, main, textord, "I", "Ι");
defineSymbol(math, main, textord, "K", "Κ");
defineSymbol(math, main, textord, "M", "Μ");
defineSymbol(math, main, textord, "N", "Ν");
defineSymbol(math, main, textord, "O", "Ο");
defineSymbol(math, main, textord, "P", "Ρ");
defineSymbol(math, main, textord, "T", "Τ");
defineSymbol(math, main, textord, "X", "Χ");
defineSymbol(math, main, textord, "¬", "\\neg", true);
defineSymbol(math, main, textord, "¬", "\\lnot");
defineSymbol(math, main, textord, "⊤", "\\top");
defineSymbol(math, main, textord, "⊥", "\\bot");
defineSymbol(math, main, textord, "∅", "\\emptyset");
defineSymbol(math, ams, textord, "∅", "\\varnothing");
defineSymbol(math, main, mathord, "α", "\\alpha", true);
defineSymbol(math, main, mathord, "β", "\\beta", true);
defineSymbol(math, main, mathord, "γ", "\\gamma", true);
defineSymbol(math, main, mathord, "δ", "\\delta", true);
defineSymbol(math, main, mathord, "ϵ", "\\epsilon", true);
defineSymbol(math, main, mathord, "ζ", "\\zeta", true);
defineSymbol(math, main, mathord, "η", "\\eta", true);
defineSymbol(math, main, mathord, "θ", "\\theta", true);
defineSymbol(math, main, mathord, "ι", "\\iota", true);
defineSymbol(math, main, mathord, "κ", "\\kappa", true);
defineSymbol(math, main, mathord, "λ", "\\lambda", true);
defineSymbol(math, main, mathord, "μ", "\\mu", true);
defineSymbol(math, main, mathord, "ν", "\\nu", true);
defineSymbol(math, main, mathord, "ξ", "\\xi", true);
defineSymbol(math, main, mathord, "ο", "\\omicron", true);
defineSymbol(math, main, mathord, "π", "\\pi", true);
defineSymbol(math, main, mathord, "ρ", "\\rho", true);
defineSymbol(math, main, mathord, "σ", "\\sigma", true);
defineSymbol(math, main, mathord, "τ", "\\tau", true);
defineSymbol(math, main, mathord, "υ", "\\upsilon", true);
defineSymbol(math, main, mathord, "ϕ", "\\phi", true);
defineSymbol(math, main, mathord, "χ", "\\chi", true);
defineSymbol(math, main, mathord, "ψ", "\\psi", true);
defineSymbol(math, main, mathord, "ω", "\\omega", true);
defineSymbol(math, main, mathord, "ε", "\\varepsilon", true);
defineSymbol(math, main, mathord, "ϑ", "\\vartheta", true);
defineSymbol(math, main, mathord, "ϖ", "\\varpi", true);
defineSymbol(math, main, mathord, "ϱ", "\\varrho", true);
defineSymbol(math, main, mathord, "ς", "\\varsigma", true);
defineSymbol(math, main, mathord, "φ", "\\varphi", true);
defineSymbol(math, main, bin, "∗", "*", true);
defineSymbol(math, main, bin, "+", "+");
defineSymbol(math, main, bin, "−", "-", true);
defineSymbol(math, main, bin, "⋅", "\\cdot", true);
defineSymbol(math, main, bin, "∘", "\\circ", true);
defineSymbol(math, main, bin, "÷", "\\div", true);
defineSymbol(math, main, bin, "±", "\\pm", true);
defineSymbol(math, main, bin, "×", "\\times", true);
defineSymbol(math, main, bin, "∩", "\\cap", true);
defineSymbol(math, main, bin, "∪", "\\cup", true);
defineSymbol(math, main, bin, "∖", "\\setminus", true);
defineSymbol(math, main, bin, "∧", "\\land");
defineSymbol(math, main, bin, "∨", "\\lor");
defineSymbol(math, main, bin, "∧", "\\wedge", true);
defineSymbol(math, main, bin, "∨", "\\vee", true);
defineSymbol(math, main, textord, "√", "\\surd");
defineSymbol(math, main, open, "⟨", "\\langle", true);
defineSymbol(math, main, open, "∣", "\\lvert");
defineSymbol(math, main, open, "∥", "\\lVert");
defineSymbol(math, main, close, "?", "?");
defineSymbol(math, main, close, "!", "!");
defineSymbol(math, main, close, "⟩", "\\rangle", true);
defineSymbol(math, main, close, "∣", "\\rvert");
defineSymbol(math, main, close, "∥", "\\rVert");
defineSymbol(math, main, rel, "=", "=");
defineSymbol(math, main, rel, ":", ":");
defineSymbol(math, main, rel, "≈", "\\approx", true);
defineSymbol(math, main, rel, "≅", "\\cong", true);
defineSymbol(math, main, rel, "≥", "\\ge");
defineSymbol(math, main, rel, "≥", "\\geq", true);
defineSymbol(math, main, rel, "←", "\\gets");
defineSymbol(math, main, rel, ">", "\\gt", true);
defineSymbol(math, main, rel, "∈", "\\in", true);
defineSymbol(math, main, rel, "", "\\@not");
defineSymbol(math, main, rel, "⊂", "\\subset", true);
defineSymbol(math, main, rel, "⊃", "\\supset", true);
defineSymbol(math, main, rel, "⊆", "\\subseteq", true);
defineSymbol(math, main, rel, "⊇", "\\supseteq", true);
defineSymbol(math, ams, rel, "⊈", "\\nsubseteq", true);
defineSymbol(math, ams, rel, "⊉", "\\nsupseteq", true);
defineSymbol(math, main, rel, "⊨", "\\models");
defineSymbol(math, main, rel, "←", "\\leftarrow", true);
defineSymbol(math, main, rel, "≤", "\\le");
defineSymbol(math, main, rel, "≤", "\\leq", true);
defineSymbol(math, main, rel, "<", "\\lt", true);
defineSymbol(math, main, rel, "→", "\\rightarrow", true);
defineSymbol(math, main, rel, "→", "\\to");
defineSymbol(math, ams, rel, "≱", "\\ngeq", true);
defineSymbol(math, ams, rel, "≰", "\\nleq", true);
defineSymbol(math, main, spacing, " ", "\\ ");
defineSymbol(math, main, spacing, " ", "\\space");
defineSymbol(math, main, spacing, " ", "\\nobreakspace");
defineSymbol(text$2, main, spacing, " ", "\\ ");
defineSymbol(text$2, main, spacing, " ", " ");
defineSymbol(text$2, main, spacing, " ", "\\space");
defineSymbol(text$2, main, spacing, " ", "\\nobreakspace");
defineSymbol(math, main, spacing, null, "\\nobreak");
defineSymbol(math, main, spacing, null, "\\allowbreak");
defineSymbol(math, main, punct, ",", ",");
defineSymbol(math, main, punct, ";", ";");
defineSymbol(math, ams, bin, "⊼", "\\barwedge", true);
defineSymbol(math, ams, bin, "⊻", "\\veebar", true);
defineSymbol(math, main, bin, "⊙", "\\odot", true);
defineSymbol(math, main, bin, "⊕", "\\oplus", true);
defineSymbol(math, main, bin, "⊗", "\\otimes", true);
defineSymbol(math, main, textord, "∂", "\\partial", true);
defineSymbol(math, main, bin, "⊘", "\\oslash", true);
defineSymbol(math, ams, bin, "⊚", "\\circledcirc", true);
defineSymbol(math, ams, bin, "⊡", "\\boxdot", true);
defineSymbol(math, main, bin, "△", "\\bigtriangleup");
defineSymbol(math, main, bin, "▽", "\\bigtriangledown");
defineSymbol(math, main, bin, "†", "\\dagger");
defineSymbol(math, main, bin, "⋄", "\\diamond");
defineSymbol(math, main, bin, "⋆", "\\star");
defineSymbol(math, main, bin, "◃", "\\triangleleft");
defineSymbol(math, main, bin, "▹", "\\triangleright");
defineSymbol(math, main, open, "{", "\\{");
defineSymbol(text$2, main, textord, "{", "\\{");
defineSymbol(text$2, main, textord, "{", "\\textbraceleft");
defineSymbol(math, main, close, "}", "\\}");
defineSymbol(text$2, main, textord, "}", "\\}");
defineSymbol(text$2, main, textord, "}", "\\textbraceright");
defineSymbol(math, main, open, "{", "\\lbrace");
defineSymbol(math, main, close, "}", "\\rbrace");
defineSymbol(math, main, open, "[", "\\lbrack", true);
defineSymbol(text$2, main, textord, "[", "\\lbrack", true);
defineSymbol(math, main, close, "]", "\\rbrack", true);
defineSymbol(text$2, main, textord, "]", "\\rbrack", true);
defineSymbol(math, main, open, "(", "\\lparen", true);
defineSymbol(math, main, close, ")", "\\rparen", true);
defineSymbol(text$2, main, textord, "<", "\\textless", true);
defineSymbol(text$2, main, textord, ">", "\\textgreater", true);
defineSymbol(math, main, open, "⌊", "\\lfloor", true);
defineSymbol(math, main, close, "⌋", "\\rfloor", true);
defineSymbol(math, main, open, "⌈", "\\lceil", true);
defineSymbol(math, main, close, "⌉", "\\rceil", true);
defineSymbol(math, main, textord, "\\", "\\backslash");
defineSymbol(math, main, textord, "∣", "|");
defineSymbol(math, main, textord, "∣", "\\vert");
defineSymbol(text$2, main, textord, "|", "\\textbar", true);
defineSymbol(math, main, textord, "∥", "\\|");
defineSymbol(math, main, textord, "∥", "\\Vert");
defineSymbol(text$2, main, textord, "∥", "\\textbardbl");
defineSymbol(text$2, main, textord, "~", "\\textasciitilde");
defineSymbol(text$2, main, textord, "\\", "\\textbackslash");
defineSymbol(text$2, main, textord, "^", "\\textasciicircum");
defineSymbol(math, main, rel, "↑", "\\uparrow", true);
defineSymbol(math, main, rel, "⇑", "\\Uparrow", true);
defineSymbol(math, main, rel, "↓", "\\downarrow", true);
defineSymbol(math, main, rel, "⇓", "\\Downarrow", true);
defineSymbol(math, main, rel, "↕", "\\updownarrow", true);
defineSymbol(math, main, rel, "⇕", "\\Updownarrow", true);
defineSymbol(math, main, op, "∐", "\\coprod");
defineSymbol(math, main, op, "⋁", "\\bigvee");
defineSymbol(math, main, op, "⋀", "\\bigwedge");
defineSymbol(math, main, op, "⨄", "\\biguplus");
defineSymbol(math, main, op, "⋂", "\\bigcap");
defineSymbol(math, main, op, "⋃", "\\bigcup");
defineSymbol(math, main, op, "∫", "\\int");
defineSymbol(math, main, op, "∫", "\\intop");
defineSymbol(math, main, op, "∬", "\\iint");
defineSymbol(math, main, op, "∭", "\\iiint");
defineSymbol(math, main, op, "∏", "\\prod");
defineSymbol(math, main, op, "∑", "\\sum");
defineSymbol(math, main, op, "⨂", "\\bigotimes");
defineSymbol(math, main, op, "⨁", "\\bigoplus");
defineSymbol(math, main, op, "⨀", "\\bigodot");
defineSymbol(math, main, op, "∮", "\\oint");
defineSymbol(math, main, op, "∯", "\\oiint");
defineSymbol(math, main, op, "∰", "\\oiiint");
defineSymbol(math, main, op, "⨆", "\\bigsqcup");
defineSymbol(math, main, op, "∫", "\\smallint");
defineSymbol(text$2, main, inner, "…", "\\textellipsis");
defineSymbol(math, main, inner, "…", "\\mathellipsis");
defineSymbol(text$2, main, inner, "…", "\\ldots", true);
defineSymbol(math, main, inner, "…", "\\ldots", true);
defineSymbol(math, main, inner, "⋯", "\\@cdots", true);
defineSymbol(math, main, inner, "⋱", "\\ddots", true);
defineSymbol(math, main, textord, "⋮", "\\varvdots");
defineSymbol(math, main, accent, "ˊ", "\\acute");
defineSymbol(math, main, accent, "ˋ", "\\grave");
defineSymbol(math, main, accent, "¨", "\\ddot");
defineSymbol(math, main, accent, "~", "\\tilde");
defineSymbol(math, main, accent, "ˉ", "\\bar");
defineSymbol(math, main, accent, "˘", "\\breve");
defineSymbol(math, main, accent, "ˇ", "\\check");
defineSymbol(math, main, accent, "^", "\\hat");
defineSymbol(math, main, accent, "⃗", "\\vec");
defineSymbol(math, main, accent, "˙", "\\dot");
defineSymbol(math, main, accent, "˚", "\\mathring");
defineSymbol(math, main, mathord, "", "\\@imath");
defineSymbol(math, main, mathord, "", "\\@jmath");
defineSymbol(math, main, textord, "ı", "ı");
defineSymbol(math, main, textord, "ȷ", "ȷ");
defineSymbol(text$2, main, textord, "ı", "\\i", true);
defineSymbol(text$2, main, textord, "ȷ", "\\j", true);
defineSymbol(text$2, main, textord, "ß", "\\ss", true);
defineSymbol(text$2, main, textord, "æ", "\\ae", true);
defineSymbol(text$2, main, textord, "œ", "\\oe", true);
defineSymbol(text$2, main, textord, "ø", "\\o", true);
defineSymbol(text$2, main, textord, "Æ", "\\AE", true);
defineSymbol(text$2, main, textord, "Œ", "\\OE", true);
defineSymbol(text$2, main, textord, "Ø", "\\O", true);
defineSymbol(text$2, main, accent, "ˊ", "\\'");
defineSymbol(text$2, main, accent, "ˋ", "\\`");
defineSymbol(text$2, main, accent, "ˆ", "\\^");
defineSymbol(text$2, main, accent, "˜", "\\~");
defineSymbol(text$2, main, accent, "ˉ", "\\=");
defineSymbol(text$2, main, accent, "˘", "\\u");
defineSymbol(text$2, main, accent, "˙", "\\.");
defineSymbol(text$2, main, accent, "¸", "\\c");
defineSymbol(text$2, main, accent, "˚", "\\r");
defineSymbol(text$2, main, accent, "ˇ", "\\v");
defineSymbol(text$2, main, accent, "¨", '\\"');
defineSymbol(text$2, main, accent, "˝", "\\H");
defineSymbol(text$2, main, accent, "◯", "\\textcircled");
var ligatures = {
  "--": true,
  "---": true,
  "``": true,
  "''": true
};
defineSymbol(text$2, main, textord, "–", "--", true);
defineSymbol(text$2, main, textord, "–", "\\textendash");
defineSymbol(text$2, main, textord, "—", "---", true);
defineSymbol(text$2, main, textord, "—", "\\textemdash");
defineSymbol(text$2, main, textord, "‘", "`", true);
defineSymbol(text$2, main, textord, "‘", "\\textquoteleft");
defineSymbol(text$2, main, textord, "’", "'", true);
defineSymbol(text$2, main, textord, "’", "\\textquoteright");
defineSymbol(text$2, main, textord, "“", "``", true);
defineSymbol(text$2, main, textord, "“", "\\textquotedblleft");
defineSymbol(text$2, main, textord, "”", "''", true);
defineSymbol(text$2, main, textord, "”", "\\textquotedblright");
defineSymbol(math, main, textord, "°", "\\degree", true);
defineSymbol(text$2, main, textord, "°", "\\degree");
defineSymbol(text$2, main, textord, "°", "\\textdegree", true);
defineSymbol(math, main, textord, "£", "\\pounds");
defineSymbol(math, main, textord, "£", "\\mathsterling", true);
defineSymbol(text$2, main, textord, "£", "\\pounds");
defineSymbol(text$2, main, textord, "£", "\\textsterling", true);
defineSymbol(math, ams, textord, "✠", "\\maltese");
defineSymbol(text$2, ams, textord, "✠", "\\maltese");
var mathTextSymbols = '0123456789/@."';
for (var i = 0; i < mathTextSymbols.length; i++) {
  var ch = mathTextSymbols.charAt(i);
  defineSymbol(math, main, textord, ch, ch);
}
var textSymbols = '0123456789!@*()-=+";:?/.,';
for (var _i = 0; _i < textSymbols.length; _i++) {
  var _ch = textSymbols.charAt(_i);
  defineSymbol(text$2, main, textord, _ch, _ch);
}
var letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
for (var _i2 = 0; _i2 < letters.length; _i2++) {
  var _ch2 = letters.charAt(_i2);
  defineSymbol(math, main, mathord, _ch2, _ch2);
  defineSymbol(text$2, main, textord, _ch2, _ch2);
}
defineSymbol(math, ams, textord, "C", "ℂ");
defineSymbol(text$2, ams, textord, "C", "ℂ");
defineSymbol(math, ams, textord, "H", "ℍ");
defineSymbol(text$2, ams, textord, "H", "ℍ");
defineSymbol(math, ams, textord, "N", "ℕ");
defineSymbol(text$2, ams, textord, "N", "ℕ");
defineSymbol(math, ams, textord, "P", "ℙ");
defineSymbol(text$2, ams, textord, "P", "ℙ");
defineSymbol(math, ams, textord, "Q", "ℚ");
defineSymbol(text$2, ams, textord, "Q", "ℚ");
defineSymbol(math, ams, textord, "R", "ℝ");
defineSymbol(text$2, ams, textord, "R", "ℝ");
defineSymbol(math, ams, textord, "Z", "ℤ");
defineSymbol(text$2, ams, textord, "Z", "ℤ");
defineSymbol(math, main, mathord, "h", "ℎ");
defineSymbol(text$2, main, mathord, "h", "ℎ");
var wideChar = "";
for (var _i3 = 0; _i3 < letters.length; _i3++) {
  var _ch3 = letters.charAt(_i3);
  wideChar = String.fromCharCode(55349, 56320 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  wideChar = String.fromCharCode(55349, 56372 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  wideChar = String.fromCharCode(55349, 56424 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  wideChar = String.fromCharCode(55349, 56580 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  wideChar = String.fromCharCode(55349, 56684 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  wideChar = String.fromCharCode(55349, 56736 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  wideChar = String.fromCharCode(55349, 56788 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  wideChar = String.fromCharCode(55349, 56840 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  wideChar = String.fromCharCode(55349, 56944 + _i3);
  defineSymbol(math, main, mathord, _ch3, wideChar);
  defineSymbol(text$2, main, textord, _ch3, wideChar);
  if (_i3 < 26) {
    wideChar = String.fromCharCode(55349, 56632 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56476 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
  }
}
wideChar = String.fromCharCode(55349, 56668);
defineSymbol(math, main, mathord, "k", wideChar);
defineSymbol(text$2, main, textord, "k", wideChar);
for (var _i4 = 0; _i4 < 10; _i4++) {
  var _ch4 = _i4.toString();
  wideChar = String.fromCharCode(55349, 57294 + _i4);
  defineSymbol(math, main, mathord, _ch4, wideChar);
  defineSymbol(text$2, main, textord, _ch4, wideChar);
  wideChar = String.fromCharCode(55349, 57314 + _i4);
  defineSymbol(math, main, mathord, _ch4, wideChar);
  defineSymbol(text$2, main, textord, _ch4, wideChar);
  wideChar = String.fromCharCode(55349, 57324 + _i4);
  defineSymbol(math, main, mathord, _ch4, wideChar);
  defineSymbol(text$2, main, textord, _ch4, wideChar);
  wideChar = String.fromCharCode(55349, 57334 + _i4);
  defineSymbol(math, main, mathord, _ch4, wideChar);
  defineSymbol(text$2, main, textord, _ch4, wideChar);
}
var extraLatin = "ÐÞþ";
for (var _i5 = 0; _i5 < extraLatin.length; _i5++) {
  var _ch5 = extraLatin.charAt(_i5);
  defineSymbol(math, main, mathord, _ch5, _ch5);
  defineSymbol(text$2, main, textord, _ch5, _ch5);
}
var wideLatinLetterData = [
  ["mathbf", "textbf", "Main-Bold"],
  // A-Z bold upright
  ["mathbf", "textbf", "Main-Bold"],
  // a-z bold upright
  ["mathnormal", "textit", "Math-Italic"],
  // A-Z italic
  ["mathnormal", "textit", "Math-Italic"],
  // a-z italic
  ["boldsymbol", "boldsymbol", "Main-BoldItalic"],
  // A-Z bold italic
  ["boldsymbol", "boldsymbol", "Main-BoldItalic"],
  // a-z bold italic
  // Map fancy A-Z letters to script, not calligraphic.
  // This aligns with unicode-math and math fonts (except Cambria Math).
  ["mathscr", "textscr", "Script-Regular"],
  // A-Z script
  ["", "", ""],
  // a-z script.  No font
  ["", "", ""],
  // A-Z bold script. No font
  ["", "", ""],
  // a-z bold script. No font
  ["mathfrak", "textfrak", "Fraktur-Regular"],
  // A-Z Fraktur
  ["mathfrak", "textfrak", "Fraktur-Regular"],
  // a-z Fraktur
  ["mathbb", "textbb", "AMS-Regular"],
  // A-Z double-struck
  ["mathbb", "textbb", "AMS-Regular"],
  // k double-struck
  // Note that we are using a bold font, but font metrics for regular Fraktur.
  ["mathboldfrak", "textboldfrak", "Fraktur-Regular"],
  // A-Z bold Fraktur
  ["mathboldfrak", "textboldfrak", "Fraktur-Regular"],
  // a-z bold Fraktur
  ["mathsf", "textsf", "SansSerif-Regular"],
  // A-Z sans-serif
  ["mathsf", "textsf", "SansSerif-Regular"],
  // a-z sans-serif
  ["mathboldsf", "textboldsf", "SansSerif-Bold"],
  // A-Z bold sans-serif
  ["mathboldsf", "textboldsf", "SansSerif-Bold"],
  // a-z bold sans-serif
  ["mathitsf", "textitsf", "SansSerif-Italic"],
  // A-Z italic sans-serif
  ["mathitsf", "textitsf", "SansSerif-Italic"],
  // a-z italic sans-serif
  ["", "", ""],
  // A-Z bold italic sans. No font
  ["", "", ""],
  // a-z bold italic sans. No font
  ["mathtt", "texttt", "Typewriter-Regular"],
  // A-Z monospace
  ["mathtt", "texttt", "Typewriter-Regular"]
  // a-z monospace
];
var wideNumeralData = [
  ["mathbf", "textbf", "Main-Bold"],
  // 0-9 bold
  ["", "", ""],
  // 0-9 double-struck. No KaTeX font.
  ["mathsf", "textsf", "SansSerif-Regular"],
  // 0-9 sans-serif
  ["mathboldsf", "textboldsf", "SansSerif-Bold"],
  // 0-9 bold sans-serif
  ["mathtt", "texttt", "Typewriter-Regular"]
  // 0-9 monospace
];
var wideCharacterFont = function wideCharacterFont2(wideChar2, mode) {
  var H = wideChar2.charCodeAt(0);
  var L = wideChar2.charCodeAt(1);
  var codePoint = (H - 55296) * 1024 + (L - 56320) + 65536;
  var j = mode === "math" ? 0 : 1;
  if (119808 <= codePoint && codePoint < 120484) {
    var i = Math.floor((codePoint - 119808) / 26);
    return [wideLatinLetterData[i][2], wideLatinLetterData[i][j]];
  } else if (120782 <= codePoint && codePoint <= 120831) {
    var _i = Math.floor((codePoint - 120782) / 10);
    return [wideNumeralData[_i][2], wideNumeralData[_i][j]];
  } else if (codePoint === 120485 || codePoint === 120486) {
    return [wideLatinLetterData[0][2], wideLatinLetterData[0][j]];
  } else if (120486 < codePoint && codePoint < 120782) {
    return ["", ""];
  } else {
    throw new ParseError("Unsupported character: " + wideChar2);
  }
};
var lookupSymbol = function lookupSymbol2(value, fontName, mode) {
  if (symbols[mode][value] && symbols[mode][value].replace) {
    value = symbols[mode][value].replace;
  }
  return {
    value,
    metrics: getCharacterMetrics(value, fontName, mode)
  };
};
var makeSymbol = function makeSymbol2(value, fontName, mode, options2, classes) {
  var lookup2 = lookupSymbol(value, fontName, mode);
  var metrics = lookup2.metrics;
  value = lookup2.value;
  var symbolNode;
  if (metrics) {
    var italic = metrics.italic;
    if (mode === "text" || options2 && options2.font === "mathit") {
      italic = 0;
    }
    symbolNode = new SymbolNode(value, metrics.height, metrics.depth, italic, metrics.skew, metrics.width, classes);
  } else {
    typeof console !== "undefined" && console.warn("No character metrics " + ("for '" + value + "' in style '" + fontName + "' and mode '" + mode + "'"));
    symbolNode = new SymbolNode(value, 0, 0, 0, 0, 0, classes);
  }
  if (options2) {
    symbolNode.maxFontSize = options2.sizeMultiplier;
    if (options2.style.isTight()) {
      symbolNode.classes.push("mtight");
    }
    var color = options2.getColor();
    if (color) {
      symbolNode.style.color = color;
    }
  }
  return symbolNode;
};
var mathsym = function mathsym2(value, mode, options2, classes) {
  if (classes === void 0) {
    classes = [];
  }
  if (options2.font === "boldsymbol" && lookupSymbol(value, "Main-Bold", mode).metrics) {
    return makeSymbol(value, "Main-Bold", mode, options2, classes.concat(["mathbf"]));
  } else if (value === "\\" || symbols[mode][value].font === "main") {
    return makeSymbol(value, "Main-Regular", mode, options2, classes);
  } else {
    return makeSymbol(value, "AMS-Regular", mode, options2, classes.concat(["amsrm"]));
  }
};
var boldsymbol = function boldsymbol2(value, mode, options2, classes, type) {
  if (type !== "textord" && lookupSymbol(value, "Math-BoldItalic", mode).metrics) {
    return {
      fontName: "Math-BoldItalic",
      fontClass: "boldsymbol"
    };
  } else {
    return {
      fontName: "Main-Bold",
      fontClass: "mathbf"
    };
  }
};
var makeOrd = function makeOrd2(group, options2, type) {
  var mode = group.mode;
  var text2 = group.text;
  var classes = ["mord"];
  var isFont = mode === "math" || mode === "text" && options2.font;
  var fontOrFamily = isFont ? options2.font : options2.fontFamily;
  var wideFontName = "";
  var wideFontClass = "";
  if (text2.charCodeAt(0) === 55349) {
    [wideFontName, wideFontClass] = wideCharacterFont(text2, mode);
  }
  if (wideFontName.length > 0) {
    return makeSymbol(text2, wideFontName, mode, options2, classes.concat(wideFontClass));
  } else if (fontOrFamily) {
    var fontName;
    var fontClasses;
    if (fontOrFamily === "boldsymbol") {
      var fontData = boldsymbol(text2, mode, options2, classes, type);
      fontName = fontData.fontName;
      fontClasses = [fontData.fontClass];
    } else if (isFont) {
      fontName = fontMap[fontOrFamily].fontName;
      fontClasses = [fontOrFamily];
    } else {
      fontName = retrieveTextFontName(fontOrFamily, options2.fontWeight, options2.fontShape);
      fontClasses = [fontOrFamily, options2.fontWeight, options2.fontShape];
    }
    if (lookupSymbol(text2, fontName, mode).metrics) {
      return makeSymbol(text2, fontName, mode, options2, classes.concat(fontClasses));
    } else if (ligatures.hasOwnProperty(text2) && fontName.slice(0, 10) === "Typewriter") {
      var parts = [];
      for (var i = 0; i < text2.length; i++) {
        parts.push(makeSymbol(text2[i], fontName, mode, options2, classes.concat(fontClasses)));
      }
      return makeFragment(parts);
    }
  }
  if (type === "mathord") {
    return makeSymbol(text2, "Math-Italic", mode, options2, classes.concat(["mathnormal"]));
  } else if (type === "textord") {
    var font = symbols[mode][text2] && symbols[mode][text2].font;
    if (font === "ams") {
      var _fontName = retrieveTextFontName("amsrm", options2.fontWeight, options2.fontShape);
      return makeSymbol(text2, _fontName, mode, options2, classes.concat("amsrm", options2.fontWeight, options2.fontShape));
    } else if (font === "main" || !font) {
      var _fontName2 = retrieveTextFontName("textrm", options2.fontWeight, options2.fontShape);
      return makeSymbol(text2, _fontName2, mode, options2, classes.concat(options2.fontWeight, options2.fontShape));
    } else {
      var _fontName3 = retrieveTextFontName(font, options2.fontWeight, options2.fontShape);
      return makeSymbol(text2, _fontName3, mode, options2, classes.concat(_fontName3, options2.fontWeight, options2.fontShape));
    }
  } else {
    throw new Error("unexpected type: " + type + " in makeOrd");
  }
};
var canCombine = (prev, next) => {
  if (createClass(prev.classes) !== createClass(next.classes) || prev.skew !== next.skew || prev.maxFontSize !== next.maxFontSize) {
    return false;
  }
  if (prev.classes.length === 1) {
    var cls = prev.classes[0];
    if (cls === "mbin" || cls === "mord") {
      return false;
    }
  }
  for (var style in prev.style) {
    if (prev.style.hasOwnProperty(style) && prev.style[style] !== next.style[style]) {
      return false;
    }
  }
  for (var _style in next.style) {
    if (next.style.hasOwnProperty(_style) && prev.style[_style] !== next.style[_style]) {
      return false;
    }
  }
  return true;
};
var tryCombineChars = (chars) => {
  for (var i = 0; i < chars.length - 1; i++) {
    var prev = chars[i];
    var next = chars[i + 1];
    if (prev instanceof SymbolNode && next instanceof SymbolNode && canCombine(prev, next)) {
      prev.text += next.text;
      prev.height = Math.max(prev.height, next.height);
      prev.depth = Math.max(prev.depth, next.depth);
      prev.italic = next.italic;
      chars.splice(i + 1, 1);
      i--;
    }
  }
  return chars;
};
var sizeElementFromChildren = function sizeElementFromChildren2(elem) {
  var height = 0;
  var depth = 0;
  var maxFontSize = 0;
  for (var i = 0; i < elem.children.length; i++) {
    var child = elem.children[i];
    if (child.height > height) {
      height = child.height;
    }
    if (child.depth > depth) {
      depth = child.depth;
    }
    if (child.maxFontSize > maxFontSize) {
      maxFontSize = child.maxFontSize;
    }
  }
  elem.height = height;
  elem.depth = depth;
  elem.maxFontSize = maxFontSize;
};
var makeSpan$2 = function makeSpan(classes, children, options2, style) {
  var span = new Span(classes, children, options2, style);
  sizeElementFromChildren(span);
  return span;
};
var makeSvgSpan = (classes, children, options2, style) => new Span(classes, children, options2, style);
var makeLineSpan = function makeLineSpan2(className, options2, thickness) {
  var line = makeSpan$2([className], [], options2);
  line.height = Math.max(thickness || options2.fontMetrics().defaultRuleThickness, options2.minRuleThickness);
  line.style.borderBottomWidth = makeEm(line.height);
  line.maxFontSize = 1;
  return line;
};
var makeAnchor = function makeAnchor2(href, classes, children, options2) {
  var anchor = new Anchor(href, classes, children, options2);
  sizeElementFromChildren(anchor);
  return anchor;
};
var makeFragment = function makeFragment2(children) {
  var fragment = new DocumentFragment(children);
  sizeElementFromChildren(fragment);
  return fragment;
};
var wrapFragment = function wrapFragment2(group, options2) {
  if (group instanceof DocumentFragment) {
    return makeSpan$2([], [group], options2);
  }
  return group;
};
var getVListChildrenAndDepth = function getVListChildrenAndDepth2(params) {
  if (params.positionType === "individualShift") {
    var oldChildren = params.children;
    var children = [oldChildren[0]];
    var _depth = -oldChildren[0].shift - oldChildren[0].elem.depth;
    var currPos = _depth;
    for (var i = 1; i < oldChildren.length; i++) {
      var diff = -oldChildren[i].shift - currPos - oldChildren[i].elem.depth;
      var size = diff - (oldChildren[i - 1].elem.height + oldChildren[i - 1].elem.depth);
      currPos = currPos + diff;
      children.push({
        type: "kern",
        size
      });
      children.push(oldChildren[i]);
    }
    return {
      children,
      depth: _depth
    };
  }
  var depth;
  if (params.positionType === "top") {
    var bottom = params.positionData;
    for (var _i = 0; _i < params.children.length; _i++) {
      var child = params.children[_i];
      bottom -= child.type === "kern" ? child.size : child.elem.height + child.elem.depth;
    }
    depth = bottom;
  } else if (params.positionType === "bottom") {
    depth = -params.positionData;
  } else {
    var firstChild = params.children[0];
    if (firstChild.type !== "elem") {
      throw new Error('First child must have type "elem".');
    }
    if (params.positionType === "shift") {
      depth = -firstChild.elem.depth - params.positionData;
    } else if (params.positionType === "firstBaseline") {
      depth = -firstChild.elem.depth;
    } else {
      throw new Error("Invalid positionType " + params.positionType + ".");
    }
  }
  return {
    children: params.children,
    depth
  };
};
var makeVList = function makeVList2(params, options2) {
  var {
    children,
    depth
  } = getVListChildrenAndDepth(params);
  var pstrutSize = 0;
  for (var i = 0; i < children.length; i++) {
    var child = children[i];
    if (child.type === "elem") {
      var elem = child.elem;
      pstrutSize = Math.max(pstrutSize, elem.maxFontSize, elem.height);
    }
  }
  pstrutSize += 2;
  var pstrut = makeSpan$2(["pstrut"], []);
  pstrut.style.height = makeEm(pstrutSize);
  var realChildren = [];
  var minPos = depth;
  var maxPos = depth;
  var currPos = depth;
  for (var _i2 = 0; _i2 < children.length; _i2++) {
    var _child = children[_i2];
    if (_child.type === "kern") {
      currPos += _child.size;
    } else {
      var _elem = _child.elem;
      var classes = _child.wrapperClasses || [];
      var style = _child.wrapperStyle || {};
      var childWrap = makeSpan$2(classes, [pstrut, _elem], void 0, style);
      childWrap.style.top = makeEm(-pstrutSize - currPos - _elem.depth);
      if (_child.marginLeft) {
        childWrap.style.marginLeft = _child.marginLeft;
      }
      if (_child.marginRight) {
        childWrap.style.marginRight = _child.marginRight;
      }
      realChildren.push(childWrap);
      currPos += _elem.height + _elem.depth;
    }
    minPos = Math.min(minPos, currPos);
    maxPos = Math.max(maxPos, currPos);
  }
  var vlist = makeSpan$2(["vlist"], realChildren);
  vlist.style.height = makeEm(maxPos);
  var rows;
  if (minPos < 0) {
    var emptySpan = makeSpan$2([], []);
    var depthStrut = makeSpan$2(["vlist"], [emptySpan]);
    depthStrut.style.height = makeEm(-minPos);
    var topStrut = makeSpan$2(["vlist-s"], [new SymbolNode("​")]);
    rows = [makeSpan$2(["vlist-r"], [vlist, topStrut]), makeSpan$2(["vlist-r"], [depthStrut])];
  } else {
    rows = [makeSpan$2(["vlist-r"], [vlist])];
  }
  var vtable = makeSpan$2(["vlist-t"], rows);
  if (rows.length === 2) {
    vtable.classes.push("vlist-t2");
  }
  vtable.height = maxPos;
  vtable.depth = -minPos;
  return vtable;
};
var makeGlue = (measurement, options2) => {
  var rule = makeSpan$2(["mspace"], [], options2);
  var size = calculateSize(measurement, options2);
  rule.style.marginRight = makeEm(size);
  return rule;
};
var retrieveTextFontName = function retrieveTextFontName2(fontFamily, fontWeight, fontShape) {
  var baseFontName = "";
  switch (fontFamily) {
    case "amsrm":
      baseFontName = "AMS";
      break;
    case "textrm":
      baseFontName = "Main";
      break;
    case "textsf":
      baseFontName = "SansSerif";
      break;
    case "texttt":
      baseFontName = "Typewriter";
      break;
    default:
      baseFontName = fontFamily;
  }
  var fontStylesName;
  if (fontWeight === "textbf" && fontShape === "textit") {
    fontStylesName = "BoldItalic";
  } else if (fontWeight === "textbf") {
    fontStylesName = "Bold";
  } else if (fontWeight === "textit") {
    fontStylesName = "Italic";
  } else {
    fontStylesName = "Regular";
  }
  return baseFontName + "-" + fontStylesName;
};
var fontMap = {
  // styles
  "mathbf": {
    variant: "bold",
    fontName: "Main-Bold"
  },
  "mathrm": {
    variant: "normal",
    fontName: "Main-Regular"
  },
  "textit": {
    variant: "italic",
    fontName: "Main-Italic"
  },
  "mathit": {
    variant: "italic",
    fontName: "Main-Italic"
  },
  "mathnormal": {
    variant: "italic",
    fontName: "Math-Italic"
  },
  // "boldsymbol" is missing because they require the use of multiple fonts:
  // Math-BoldItalic and Main-Bold.  This is handled by a special case in
  // makeOrd which ends up calling boldsymbol.
  // families
  "mathbb": {
    variant: "double-struck",
    fontName: "AMS-Regular"
  },
  "mathcal": {
    variant: "script",
    fontName: "Caligraphic-Regular"
  },
  "mathfrak": {
    variant: "fraktur",
    fontName: "Fraktur-Regular"
  },
  "mathscr": {
    variant: "script",
    fontName: "Script-Regular"
  },
  "mathsf": {
    variant: "sans-serif",
    fontName: "SansSerif-Regular"
  },
  "mathtt": {
    variant: "monospace",
    fontName: "Typewriter-Regular"
  }
};
var svgData = {
  //   path, width, height
  vec: ["vec", 0.471, 0.714],
  // values from the font glyph
  oiintSize1: ["oiintSize1", 0.957, 0.499],
  // oval to overlay the integrand
  oiintSize2: ["oiintSize2", 1.472, 0.659],
  oiiintSize1: ["oiiintSize1", 1.304, 0.499],
  oiiintSize2: ["oiiintSize2", 1.98, 0.659]
};
var staticSvg = function staticSvg2(value, options2) {
  var [pathName, width, height] = svgData[value];
  var path2 = new PathNode(pathName);
  var svgNode = new SvgNode([path2], {
    "width": makeEm(width),
    "height": makeEm(height),
    // Override CSS rule `.katex svg { width: 100% }`
    "style": "width:" + makeEm(width),
    "viewBox": "0 0 " + 1e3 * width + " " + 1e3 * height,
    "preserveAspectRatio": "xMinYMin"
  });
  var span = makeSvgSpan(["overlay"], [svgNode], options2);
  span.height = height;
  span.style.height = makeEm(height);
  span.style.width = makeEm(width);
  return span;
};
var buildCommon = {
  fontMap,
  makeSymbol,
  mathsym,
  makeSpan: makeSpan$2,
  makeSvgSpan,
  makeLineSpan,
  makeAnchor,
  makeFragment,
  wrapFragment,
  makeVList,
  makeOrd,
  makeGlue,
  staticSvg,
  svgData,
  tryCombineChars
};
var thinspace = {
  number: 3,
  unit: "mu"
};
var mediumspace = {
  number: 4,
  unit: "mu"
};
var thickspace = {
  number: 5,
  unit: "mu"
};
var spacings = {
  mord: {
    mop: thinspace,
    mbin: mediumspace,
    mrel: thickspace,
    minner: thinspace
  },
  mop: {
    mord: thinspace,
    mop: thinspace,
    mrel: thickspace,
    minner: thinspace
  },
  mbin: {
    mord: mediumspace,
    mop: mediumspace,
    mopen: mediumspace,
    minner: mediumspace
  },
  mrel: {
    mord: thickspace,
    mop: thickspace,
    mopen: thickspace,
    minner: thickspace
  },
  mopen: {},
  mclose: {
    mop: thinspace,
    mbin: mediumspace,
    mrel: thickspace,
    minner: thinspace
  },
  mpunct: {
    mord: thinspace,
    mop: thinspace,
    mrel: thickspace,
    mopen: thinspace,
    mclose: thinspace,
    mpunct: thinspace,
    minner: thinspace
  },
  minner: {
    mord: thinspace,
    mop: thinspace,
    mbin: mediumspace,
    mrel: thickspace,
    mopen: thinspace,
    mpunct: thinspace,
    minner: thinspace
  }
};
var tightSpacings = {
  mord: {
    mop: thinspace
  },
  mop: {
    mord: thinspace,
    mop: thinspace
  },
  mbin: {},
  mrel: {},
  mopen: {},
  mclose: {
    mop: thinspace
  },
  mpunct: {},
  minner: {
    mop: thinspace
  }
};
var _functions = {};
var _htmlGroupBuilders = {};
var _mathmlGroupBuilders = {};
function defineFunction(_ref) {
  var {
    type,
    names,
    props,
    handler,
    htmlBuilder: htmlBuilder3,
    mathmlBuilder: mathmlBuilder3
  } = _ref;
  var data = {
    type,
    numArgs: props.numArgs,
    argTypes: props.argTypes,
    allowedInArgument: !!props.allowedInArgument,
    allowedInText: !!props.allowedInText,
    allowedInMath: props.allowedInMath === void 0 ? true : props.allowedInMath,
    numOptionalArgs: props.numOptionalArgs || 0,
    infix: !!props.infix,
    primitive: !!props.primitive,
    handler
  };
  for (var i = 0; i < names.length; ++i) {
    _functions[names[i]] = data;
  }
  if (type) {
    if (htmlBuilder3) {
      _htmlGroupBuilders[type] = htmlBuilder3;
    }
    if (mathmlBuilder3) {
      _mathmlGroupBuilders[type] = mathmlBuilder3;
    }
  }
}
function defineFunctionBuilders(_ref2) {
  var {
    type,
    htmlBuilder: htmlBuilder3,
    mathmlBuilder: mathmlBuilder3
  } = _ref2;
  defineFunction({
    type,
    names: [],
    props: {
      numArgs: 0
    },
    handler() {
      throw new Error("Should never be called.");
    },
    htmlBuilder: htmlBuilder3,
    mathmlBuilder: mathmlBuilder3
  });
}
var normalizeArgument = function normalizeArgument2(arg) {
  return arg.type === "ordgroup" && arg.body.length === 1 ? arg.body[0] : arg;
};
var ordargument = function ordargument2(arg) {
  return arg.type === "ordgroup" ? arg.body : [arg];
};
var makeSpan$1 = buildCommon.makeSpan;
var binLeftCanceller = ["leftmost", "mbin", "mopen", "mrel", "mop", "mpunct"];
var binRightCanceller = ["rightmost", "mrel", "mclose", "mpunct"];
var styleMap$1 = {
  "display": Style$1.DISPLAY,
  "text": Style$1.TEXT,
  "script": Style$1.SCRIPT,
  "scriptscript": Style$1.SCRIPTSCRIPT
};
var DomEnum = {
  mord: "mord",
  mop: "mop",
  mbin: "mbin",
  mrel: "mrel",
  mopen: "mopen",
  mclose: "mclose",
  mpunct: "mpunct",
  minner: "minner"
};
var buildExpression$1 = function buildExpression(expression, options2, isRealGroup, surrounding) {
  if (surrounding === void 0) {
    surrounding = [null, null];
  }
  var groups = [];
  for (var i = 0; i < expression.length; i++) {
    var output = buildGroup$1(expression[i], options2);
    if (output instanceof DocumentFragment) {
      var children = output.children;
      groups.push(...children);
    } else {
      groups.push(output);
    }
  }
  buildCommon.tryCombineChars(groups);
  if (!isRealGroup) {
    return groups;
  }
  var glueOptions = options2;
  if (expression.length === 1) {
    var node2 = expression[0];
    if (node2.type === "sizing") {
      glueOptions = options2.havingSize(node2.size);
    } else if (node2.type === "styling") {
      glueOptions = options2.havingStyle(styleMap$1[node2.style]);
    }
  }
  var dummyPrev = makeSpan$1([surrounding[0] || "leftmost"], [], options2);
  var dummyNext = makeSpan$1([surrounding[1] || "rightmost"], [], options2);
  var isRoot = isRealGroup === "root";
  traverseNonSpaceNodes(groups, (node3, prev) => {
    var prevType = prev.classes[0];
    var type = node3.classes[0];
    if (prevType === "mbin" && utils.contains(binRightCanceller, type)) {
      prev.classes[0] = "mord";
    } else if (type === "mbin" && utils.contains(binLeftCanceller, prevType)) {
      node3.classes[0] = "mord";
    }
  }, {
    node: dummyPrev
  }, dummyNext, isRoot);
  traverseNonSpaceNodes(groups, (node3, prev) => {
    var prevType = getTypeOfDomTree(prev);
    var type = getTypeOfDomTree(node3);
    var space = prevType && type ? node3.hasClass("mtight") ? tightSpacings[prevType][type] : spacings[prevType][type] : null;
    if (space) {
      return buildCommon.makeGlue(space, glueOptions);
    }
  }, {
    node: dummyPrev
  }, dummyNext, isRoot);
  return groups;
};
var traverseNonSpaceNodes = function traverseNonSpaceNodes2(nodes, callback, prev, next, isRoot) {
  if (next) {
    nodes.push(next);
  }
  var i = 0;
  for (; i < nodes.length; i++) {
    var node2 = nodes[i];
    var partialGroup = checkPartialGroup(node2);
    if (partialGroup) {
      traverseNonSpaceNodes2(partialGroup.children, callback, prev, null, isRoot);
      continue;
    }
    var nonspace = !node2.hasClass("mspace");
    if (nonspace) {
      var result = callback(node2, prev.node);
      if (result) {
        if (prev.insertAfter) {
          prev.insertAfter(result);
        } else {
          nodes.unshift(result);
          i++;
        }
      }
    }
    if (nonspace) {
      prev.node = node2;
    } else if (isRoot && node2.hasClass("newline")) {
      prev.node = makeSpan$1(["leftmost"]);
    }
    prev.insertAfter = /* @__PURE__ */ ((index) => (n) => {
      nodes.splice(index + 1, 0, n);
      i++;
    })(i);
  }
  if (next) {
    nodes.pop();
  }
};
var checkPartialGroup = function checkPartialGroup2(node2) {
  if (node2 instanceof DocumentFragment || node2 instanceof Anchor || node2 instanceof Span && node2.hasClass("enclosing")) {
    return node2;
  }
  return null;
};
var getOutermostNode = function getOutermostNode2(node2, side) {
  var partialGroup = checkPartialGroup(node2);
  if (partialGroup) {
    var children = partialGroup.children;
    if (children.length) {
      if (side === "right") {
        return getOutermostNode2(children[children.length - 1], "right");
      } else if (side === "left") {
        return getOutermostNode2(children[0], "left");
      }
    }
  }
  return node2;
};
var getTypeOfDomTree = function getTypeOfDomTree2(node2, side) {
  if (!node2) {
    return null;
  }
  if (side) {
    node2 = getOutermostNode(node2, side);
  }
  return DomEnum[node2.classes[0]] || null;
};
var makeNullDelimiter = function makeNullDelimiter2(options2, classes) {
  var moreClasses = ["nulldelimiter"].concat(options2.baseSizingClasses());
  return makeSpan$1(classes.concat(moreClasses));
};
var buildGroup$1 = function buildGroup(group, options2, baseOptions) {
  if (!group) {
    return makeSpan$1();
  }
  if (_htmlGroupBuilders[group.type]) {
    var groupNode = _htmlGroupBuilders[group.type](group, options2);
    if (baseOptions && options2.size !== baseOptions.size) {
      groupNode = makeSpan$1(options2.sizingClasses(baseOptions), [groupNode], options2);
      var multiplier = options2.sizeMultiplier / baseOptions.sizeMultiplier;
      groupNode.height *= multiplier;
      groupNode.depth *= multiplier;
    }
    return groupNode;
  } else {
    throw new ParseError("Got group of unknown type: '" + group.type + "'");
  }
};
function newDocumentFragment(children) {
  return new DocumentFragment(children);
}
class MathNode {
  constructor(type, children, classes) {
    this.type = void 0;
    this.attributes = void 0;
    this.children = void 0;
    this.classes = void 0;
    this.type = type;
    this.attributes = {};
    this.children = children || [];
    this.classes = classes || [];
  }
  /**
   * Sets an attribute on a MathML node. MathML depends on attributes to convey a
   * semantic content, so this is used heavily.
   */
  setAttribute(name, value) {
    this.attributes[name] = value;
  }
  /**
   * Gets an attribute on a MathML node.
   */
  getAttribute(name) {
    return this.attributes[name];
  }
  /**
   * Converts the math node into a MathML-namespaced DOM element.
   */
  toNode() {
    var node2 = document.createElementNS("http://www.w3.org/1998/Math/MathML", this.type);
    for (var attr in this.attributes) {
      if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
        node2.setAttribute(attr, this.attributes[attr]);
      }
    }
    if (this.classes.length > 0) {
      node2.className = createClass(this.classes);
    }
    for (var i = 0; i < this.children.length; i++) {
      node2.appendChild(this.children[i].toNode());
    }
    return node2;
  }
  /**
   * Converts the math node into an HTML markup string.
   */
  toMarkup() {
    var markup = "<" + this.type;
    for (var attr in this.attributes) {
      if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
        markup += " " + attr + '="';
        markup += utils.escape(this.attributes[attr]);
        markup += '"';
      }
    }
    if (this.classes.length > 0) {
      markup += ' class ="' + utils.escape(createClass(this.classes)) + '"';
    }
    markup += ">";
    for (var i = 0; i < this.children.length; i++) {
      markup += this.children[i].toMarkup();
    }
    markup += "</" + this.type + ">";
    return markup;
  }
  /**
   * Converts the math node into a string, similar to innerText, but escaped.
   */
  toText() {
    return this.children.map((child) => child.toText()).join("");
  }
}
class TextNode {
  constructor(text2) {
    this.text = void 0;
    this.text = text2;
  }
  /**
   * Converts the text node into a DOM text node.
   */
  toNode() {
    return document.createTextNode(this.text);
  }
  /**
   * Converts the text node into escaped HTML markup
   * (representing the text itself).
   */
  toMarkup() {
    return utils.escape(this.toText());
  }
  /**
   * Converts the text node into a string
   * (representing the text itself).
   */
  toText() {
    return this.text;
  }
}
class SpaceNode {
  /**
   * Create a Space node with width given in CSS ems.
   */
  constructor(width) {
    this.width = void 0;
    this.character = void 0;
    this.width = width;
    if (width >= 0.05555 && width <= 0.05556) {
      this.character = " ";
    } else if (width >= 0.1666 && width <= 0.1667) {
      this.character = " ";
    } else if (width >= 0.2222 && width <= 0.2223) {
      this.character = " ";
    } else if (width >= 0.2777 && width <= 0.2778) {
      this.character = "  ";
    } else if (width >= -0.05556 && width <= -0.05555) {
      this.character = " ⁣";
    } else if (width >= -0.1667 && width <= -0.1666) {
      this.character = " ⁣";
    } else if (width >= -0.2223 && width <= -0.2222) {
      this.character = " ⁣";
    } else if (width >= -0.2778 && width <= -0.2777) {
      this.character = " ⁣";
    } else {
      this.character = null;
    }
  }
  /**
   * Converts the math node into a MathML-namespaced DOM element.
   */
  toNode() {
    if (this.character) {
      return document.createTextNode(this.character);
    } else {
      var node2 = document.createElementNS("http://www.w3.org/1998/Math/MathML", "mspace");
      node2.setAttribute("width", makeEm(this.width));
      return node2;
    }
  }
  /**
   * Converts the math node into an HTML markup string.
   */
  toMarkup() {
    if (this.character) {
      return "<mtext>" + this.character + "</mtext>";
    } else {
      return '<mspace width="' + makeEm(this.width) + '"/>';
    }
  }
  /**
   * Converts the math node into a string, similar to innerText.
   */
  toText() {
    if (this.character) {
      return this.character;
    } else {
      return " ";
    }
  }
}
var mathMLTree = {
  MathNode,
  TextNode,
  SpaceNode,
  newDocumentFragment
};
var makeText = function makeText2(text2, mode, options2) {
  if (symbols[mode][text2] && symbols[mode][text2].replace && text2.charCodeAt(0) !== 55349 && !(ligatures.hasOwnProperty(text2) && options2 && (options2.fontFamily && options2.fontFamily.slice(4, 6) === "tt" || options2.font && options2.font.slice(4, 6) === "tt"))) {
    text2 = symbols[mode][text2].replace;
  }
  return new mathMLTree.TextNode(text2);
};
var makeRow = function makeRow2(body) {
  if (body.length === 1) {
    return body[0];
  } else {
    return new mathMLTree.MathNode("mrow", body);
  }
};
var getVariant = function getVariant2(group, options2) {
  if (options2.fontFamily === "texttt") {
    return "monospace";
  } else if (options2.fontFamily === "textsf") {
    if (options2.fontShape === "textit" && options2.fontWeight === "textbf") {
      return "sans-serif-bold-italic";
    } else if (options2.fontShape === "textit") {
      return "sans-serif-italic";
    } else if (options2.fontWeight === "textbf") {
      return "bold-sans-serif";
    } else {
      return "sans-serif";
    }
  } else if (options2.fontShape === "textit" && options2.fontWeight === "textbf") {
    return "bold-italic";
  } else if (options2.fontShape === "textit") {
    return "italic";
  } else if (options2.fontWeight === "textbf") {
    return "bold";
  }
  var font = options2.font;
  if (!font || font === "mathnormal") {
    return null;
  }
  var mode = group.mode;
  if (font === "mathit") {
    return "italic";
  } else if (font === "boldsymbol") {
    return group.type === "textord" ? "bold" : "bold-italic";
  } else if (font === "mathbf") {
    return "bold";
  } else if (font === "mathbb") {
    return "double-struck";
  } else if (font === "mathfrak") {
    return "fraktur";
  } else if (font === "mathscr" || font === "mathcal") {
    return "script";
  } else if (font === "mathsf") {
    return "sans-serif";
  } else if (font === "mathtt") {
    return "monospace";
  }
  var text2 = group.text;
  if (utils.contains(["\\imath", "\\jmath"], text2)) {
    return null;
  }
  if (symbols[mode][text2] && symbols[mode][text2].replace) {
    text2 = symbols[mode][text2].replace;
  }
  var fontName = buildCommon.fontMap[font].fontName;
  if (getCharacterMetrics(text2, fontName, mode)) {
    return buildCommon.fontMap[font].variant;
  }
  return null;
};
var buildExpression2 = function buildExpression3(expression, options2, isOrdgroup) {
  if (expression.length === 1) {
    var group = buildGroup2(expression[0], options2);
    if (isOrdgroup && group instanceof MathNode && group.type === "mo") {
      group.setAttribute("lspace", "0em");
      group.setAttribute("rspace", "0em");
    }
    return [group];
  }
  var groups = [];
  var lastGroup;
  for (var i = 0; i < expression.length; i++) {
    var _group = buildGroup2(expression[i], options2);
    if (_group instanceof MathNode && lastGroup instanceof MathNode) {
      if (_group.type === "mtext" && lastGroup.type === "mtext" && _group.getAttribute("mathvariant") === lastGroup.getAttribute("mathvariant")) {
        lastGroup.children.push(..._group.children);
        continue;
      } else if (_group.type === "mn" && lastGroup.type === "mn") {
        lastGroup.children.push(..._group.children);
        continue;
      } else if (_group.type === "mi" && _group.children.length === 1 && lastGroup.type === "mn") {
        var child = _group.children[0];
        if (child instanceof TextNode && child.text === ".") {
          lastGroup.children.push(..._group.children);
          continue;
        }
      } else if (lastGroup.type === "mi" && lastGroup.children.length === 1) {
        var lastChild = lastGroup.children[0];
        if (lastChild instanceof TextNode && lastChild.text === "̸" && (_group.type === "mo" || _group.type === "mi" || _group.type === "mn")) {
          var _child = _group.children[0];
          if (_child instanceof TextNode && _child.text.length > 0) {
            _child.text = _child.text.slice(0, 1) + "̸" + _child.text.slice(1);
            groups.pop();
          }
        }
      }
    }
    groups.push(_group);
    lastGroup = _group;
  }
  return groups;
};
var buildExpressionRow = function buildExpressionRow2(expression, options2, isOrdgroup) {
  return makeRow(buildExpression2(expression, options2, isOrdgroup));
};
var buildGroup2 = function buildGroup3(group, options2) {
  if (!group) {
    return new mathMLTree.MathNode("mrow");
  }
  if (_mathmlGroupBuilders[group.type]) {
    var result = _mathmlGroupBuilders[group.type](group, options2);
    return result;
  } else {
    throw new ParseError("Got group of unknown type: '" + group.type + "'");
  }
};
var stretchyCodePoint = {
  widehat: "^",
  widecheck: "ˇ",
  widetilde: "~",
  utilde: "~",
  overleftarrow: "←",
  underleftarrow: "←",
  xleftarrow: "←",
  overrightarrow: "→",
  underrightarrow: "→",
  xrightarrow: "→",
  underbrace: "⏟",
  overbrace: "⏞",
  overgroup: "⏠",
  undergroup: "⏡",
  overleftrightarrow: "↔",
  underleftrightarrow: "↔",
  xleftrightarrow: "↔",
  Overrightarrow: "⇒",
  xRightarrow: "⇒",
  overleftharpoon: "↼",
  xleftharpoonup: "↼",
  overrightharpoon: "⇀",
  xrightharpoonup: "⇀",
  xLeftarrow: "⇐",
  xLeftrightarrow: "⇔",
  xhookleftarrow: "↩",
  xhookrightarrow: "↪",
  xmapsto: "↦",
  xrightharpoondown: "⇁",
  xleftharpoondown: "↽",
  xrightleftharpoons: "⇌",
  xleftrightharpoons: "⇋",
  xtwoheadleftarrow: "↞",
  xtwoheadrightarrow: "↠",
  xlongequal: "=",
  xtofrom: "⇄",
  xrightleftarrows: "⇄",
  xrightequilibrium: "⇌",
  // Not a perfect match.
  xleftequilibrium: "⇋",
  // None better available.
  "\\cdrightarrow": "→",
  "\\cdleftarrow": "←",
  "\\cdlongequal": "="
};
var mathMLnode = function mathMLnode2(label2) {
  var node2 = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode(stretchyCodePoint[label2.replace(/^\\/, "")])]);
  node2.setAttribute("stretchy", "true");
  return node2;
};
var katexImagesData = {
  //   path(s), minWidth, height, align
  overrightarrow: [["rightarrow"], 0.888, 522, "xMaxYMin"],
  overleftarrow: [["leftarrow"], 0.888, 522, "xMinYMin"],
  underrightarrow: [["rightarrow"], 0.888, 522, "xMaxYMin"],
  underleftarrow: [["leftarrow"], 0.888, 522, "xMinYMin"],
  xrightarrow: [["rightarrow"], 1.469, 522, "xMaxYMin"],
  "\\cdrightarrow": [["rightarrow"], 3, 522, "xMaxYMin"],
  // CD minwwidth2.5pc
  xleftarrow: [["leftarrow"], 1.469, 522, "xMinYMin"],
  "\\cdleftarrow": [["leftarrow"], 3, 522, "xMinYMin"],
  Overrightarrow: [["doublerightarrow"], 0.888, 560, "xMaxYMin"],
  xRightarrow: [["doublerightarrow"], 1.526, 560, "xMaxYMin"],
  xLeftarrow: [["doubleleftarrow"], 1.526, 560, "xMinYMin"],
  overleftharpoon: [["leftharpoon"], 0.888, 522, "xMinYMin"],
  xleftharpoonup: [["leftharpoon"], 0.888, 522, "xMinYMin"],
  xleftharpoondown: [["leftharpoondown"], 0.888, 522, "xMinYMin"],
  overrightharpoon: [["rightharpoon"], 0.888, 522, "xMaxYMin"],
  xrightharpoonup: [["rightharpoon"], 0.888, 522, "xMaxYMin"],
  xrightharpoondown: [["rightharpoondown"], 0.888, 522, "xMaxYMin"],
  xlongequal: [["longequal"], 0.888, 334, "xMinYMin"],
  "\\cdlongequal": [["longequal"], 3, 334, "xMinYMin"],
  xtwoheadleftarrow: [["twoheadleftarrow"], 0.888, 334, "xMinYMin"],
  xtwoheadrightarrow: [["twoheadrightarrow"], 0.888, 334, "xMaxYMin"],
  overleftrightarrow: [["leftarrow", "rightarrow"], 0.888, 522],
  overbrace: [["leftbrace", "midbrace", "rightbrace"], 1.6, 548],
  underbrace: [["leftbraceunder", "midbraceunder", "rightbraceunder"], 1.6, 548],
  underleftrightarrow: [["leftarrow", "rightarrow"], 0.888, 522],
  xleftrightarrow: [["leftarrow", "rightarrow"], 1.75, 522],
  xLeftrightarrow: [["doubleleftarrow", "doublerightarrow"], 1.75, 560],
  xrightleftharpoons: [["leftharpoondownplus", "rightharpoonplus"], 1.75, 716],
  xleftrightharpoons: [["leftharpoonplus", "rightharpoondownplus"], 1.75, 716],
  xhookleftarrow: [["leftarrow", "righthook"], 1.08, 522],
  xhookrightarrow: [["lefthook", "rightarrow"], 1.08, 522],
  overlinesegment: [["leftlinesegment", "rightlinesegment"], 0.888, 522],
  underlinesegment: [["leftlinesegment", "rightlinesegment"], 0.888, 522],
  overgroup: [["leftgroup", "rightgroup"], 0.888, 342],
  undergroup: [["leftgroupunder", "rightgroupunder"], 0.888, 342],
  xmapsto: [["leftmapsto", "rightarrow"], 1.5, 522],
  xtofrom: [["leftToFrom", "rightToFrom"], 1.75, 528],
  // The next three arrows are from the mhchem package.
  // In mhchem.sty, min-length is 2.0em. But these arrows might appear in the
  // document as \xrightarrow or \xrightleftharpoons. Those have
  // min-length = 1.75em, so we set min-length on these next three to match.
  xrightleftarrows: [["baraboveleftarrow", "rightarrowabovebar"], 1.75, 901],
  xrightequilibrium: [["baraboveshortleftharpoon", "rightharpoonaboveshortbar"], 1.75, 716],
  xleftequilibrium: [["shortbaraboveleftharpoon", "shortrightharpoonabovebar"], 1.75, 716]
};
var groupLength = function groupLength2(arg) {
  if (arg.type === "ordgroup") {
    return arg.body.length;
  } else {
    return 1;
  }
};
var svgSpan = function svgSpan2(group, options2) {
  function buildSvgSpan_() {
    var viewBoxWidth = 4e5;
    var label2 = group.label.slice(1);
    if (utils.contains(["widehat", "widecheck", "widetilde", "utilde"], label2)) {
      var grp = group;
      var numChars = groupLength(grp.base);
      var viewBoxHeight;
      var pathName;
      var _height;
      if (numChars > 5) {
        if (label2 === "widehat" || label2 === "widecheck") {
          viewBoxHeight = 420;
          viewBoxWidth = 2364;
          _height = 0.42;
          pathName = label2 + "4";
        } else {
          viewBoxHeight = 312;
          viewBoxWidth = 2340;
          _height = 0.34;
          pathName = "tilde4";
        }
      } else {
        var imgIndex = [1, 1, 2, 2, 3, 3][numChars];
        if (label2 === "widehat" || label2 === "widecheck") {
          viewBoxWidth = [0, 1062, 2364, 2364, 2364][imgIndex];
          viewBoxHeight = [0, 239, 300, 360, 420][imgIndex];
          _height = [0, 0.24, 0.3, 0.3, 0.36, 0.42][imgIndex];
          pathName = label2 + imgIndex;
        } else {
          viewBoxWidth = [0, 600, 1033, 2339, 2340][imgIndex];
          viewBoxHeight = [0, 260, 286, 306, 312][imgIndex];
          _height = [0, 0.26, 0.286, 0.3, 0.306, 0.34][imgIndex];
          pathName = "tilde" + imgIndex;
        }
      }
      var path2 = new PathNode(pathName);
      var svgNode = new SvgNode([path2], {
        "width": "100%",
        "height": makeEm(_height),
        "viewBox": "0 0 " + viewBoxWidth + " " + viewBoxHeight,
        "preserveAspectRatio": "none"
      });
      return {
        span: buildCommon.makeSvgSpan([], [svgNode], options2),
        minWidth: 0,
        height: _height
      };
    } else {
      var spans = [];
      var data = katexImagesData[label2];
      var [paths, _minWidth, _viewBoxHeight] = data;
      var _height2 = _viewBoxHeight / 1e3;
      var numSvgChildren = paths.length;
      var widthClasses;
      var aligns;
      if (numSvgChildren === 1) {
        var align1 = data[3];
        widthClasses = ["hide-tail"];
        aligns = [align1];
      } else if (numSvgChildren === 2) {
        widthClasses = ["halfarrow-left", "halfarrow-right"];
        aligns = ["xMinYMin", "xMaxYMin"];
      } else if (numSvgChildren === 3) {
        widthClasses = ["brace-left", "brace-center", "brace-right"];
        aligns = ["xMinYMin", "xMidYMin", "xMaxYMin"];
      } else {
        throw new Error("Correct katexImagesData or update code here to support\n                    " + numSvgChildren + " children.");
      }
      for (var i = 0; i < numSvgChildren; i++) {
        var _path = new PathNode(paths[i]);
        var _svgNode = new SvgNode([_path], {
          "width": "400em",
          "height": makeEm(_height2),
          "viewBox": "0 0 " + viewBoxWidth + " " + _viewBoxHeight,
          "preserveAspectRatio": aligns[i] + " slice"
        });
        var _span = buildCommon.makeSvgSpan([widthClasses[i]], [_svgNode], options2);
        if (numSvgChildren === 1) {
          return {
            span: _span,
            minWidth: _minWidth,
            height: _height2
          };
        } else {
          _span.style.height = makeEm(_height2);
          spans.push(_span);
        }
      }
      return {
        span: buildCommon.makeSpan(["stretchy"], spans, options2),
        minWidth: _minWidth,
        height: _height2
      };
    }
  }
  var {
    span,
    minWidth,
    height
  } = buildSvgSpan_();
  span.height = height;
  span.style.height = makeEm(height);
  if (minWidth > 0) {
    span.style.minWidth = makeEm(minWidth);
  }
  return span;
};
var encloseSpan = function encloseSpan2(inner2, label2, topPad, bottomPad, options2) {
  var img;
  var totalHeight = inner2.height + inner2.depth + topPad + bottomPad;
  if (/fbox|color|angl/.test(label2)) {
    img = buildCommon.makeSpan(["stretchy", label2], [], options2);
    if (label2 === "fbox") {
      var color = options2.color && options2.getColor();
      if (color) {
        img.style.borderColor = color;
      }
    }
  } else {
    var lines = [];
    if (/^[bx]cancel$/.test(label2)) {
      lines.push(new LineNode({
        "x1": "0",
        "y1": "0",
        "x2": "100%",
        "y2": "100%",
        "stroke-width": "0.046em"
      }));
    }
    if (/^x?cancel$/.test(label2)) {
      lines.push(new LineNode({
        "x1": "0",
        "y1": "100%",
        "x2": "100%",
        "y2": "0",
        "stroke-width": "0.046em"
      }));
    }
    var svgNode = new SvgNode(lines, {
      "width": "100%",
      "height": makeEm(totalHeight)
    });
    img = buildCommon.makeSvgSpan([], [svgNode], options2);
  }
  img.height = totalHeight;
  img.style.height = makeEm(totalHeight);
  return img;
};
var stretchy = {
  encloseSpan,
  mathMLnode,
  svgSpan
};
function assertNodeType(node2, type) {
  if (!node2 || node2.type !== type) {
    throw new Error("Expected node of type " + type + ", but got " + (node2 ? "node of type " + node2.type : String(node2)));
  }
  return node2;
}
function assertSymbolNodeType(node2) {
  var typedNode = checkSymbolNodeType(node2);
  if (!typedNode) {
    throw new Error("Expected node of symbol group type, but got " + (node2 ? "node of type " + node2.type : String(node2)));
  }
  return typedNode;
}
function checkSymbolNodeType(node2) {
  if (node2 && (node2.type === "atom" || NON_ATOMS.hasOwnProperty(node2.type))) {
    return node2;
  }
  return null;
}
var htmlBuilder$a = (grp, options2) => {
  var base;
  var group;
  var supSubGroup;
  if (grp && grp.type === "supsub") {
    group = assertNodeType(grp.base, "accent");
    base = group.base;
    grp.base = base;
    supSubGroup = assertSpan(buildGroup$1(grp, options2));
    grp.base = group;
  } else {
    group = assertNodeType(grp, "accent");
    base = group.base;
  }
  var body = buildGroup$1(base, options2.havingCrampedStyle());
  var mustShift = group.isShifty && utils.isCharacterBox(base);
  var skew = 0;
  if (mustShift) {
    var baseChar = utils.getBaseElem(base);
    var baseGroup = buildGroup$1(baseChar, options2.havingCrampedStyle());
    skew = assertSymbolDomNode(baseGroup).skew;
  }
  var accentBelow = group.label === "\\c";
  var clearance = accentBelow ? body.height + body.depth : Math.min(body.height, options2.fontMetrics().xHeight);
  var accentBody;
  if (!group.isStretchy) {
    var accent2;
    var width;
    if (group.label === "\\vec") {
      accent2 = buildCommon.staticSvg("vec", options2);
      width = buildCommon.svgData.vec[1];
    } else {
      accent2 = buildCommon.makeOrd({
        mode: group.mode,
        text: group.label
      }, options2, "textord");
      accent2 = assertSymbolDomNode(accent2);
      accent2.italic = 0;
      width = accent2.width;
      if (accentBelow) {
        clearance += accent2.depth;
      }
    }
    accentBody = buildCommon.makeSpan(["accent-body"], [accent2]);
    var accentFull = group.label === "\\textcircled";
    if (accentFull) {
      accentBody.classes.push("accent-full");
      clearance = body.height;
    }
    var left = skew;
    if (!accentFull) {
      left -= width / 2;
    }
    accentBody.style.left = makeEm(left);
    if (group.label === "\\textcircled") {
      accentBody.style.top = ".2em";
    }
    accentBody = buildCommon.makeVList({
      positionType: "firstBaseline",
      children: [{
        type: "elem",
        elem: body
      }, {
        type: "kern",
        size: -clearance
      }, {
        type: "elem",
        elem: accentBody
      }]
    }, options2);
  } else {
    accentBody = stretchy.svgSpan(group, options2);
    accentBody = buildCommon.makeVList({
      positionType: "firstBaseline",
      children: [{
        type: "elem",
        elem: body
      }, {
        type: "elem",
        elem: accentBody,
        wrapperClasses: ["svg-align"],
        wrapperStyle: skew > 0 ? {
          width: "calc(100% - " + makeEm(2 * skew) + ")",
          marginLeft: makeEm(2 * skew)
        } : void 0
      }]
    }, options2);
  }
  var accentWrap = buildCommon.makeSpan(["mord", "accent"], [accentBody], options2);
  if (supSubGroup) {
    supSubGroup.children[0] = accentWrap;
    supSubGroup.height = Math.max(accentWrap.height, supSubGroup.height);
    supSubGroup.classes[0] = "mord";
    return supSubGroup;
  } else {
    return accentWrap;
  }
};
var mathmlBuilder$9 = (group, options2) => {
  var accentNode = group.isStretchy ? stretchy.mathMLnode(group.label) : new mathMLTree.MathNode("mo", [makeText(group.label, group.mode)]);
  var node2 = new mathMLTree.MathNode("mover", [buildGroup2(group.base, options2), accentNode]);
  node2.setAttribute("accent", "true");
  return node2;
};
var NON_STRETCHY_ACCENT_REGEX = new RegExp(["\\acute", "\\grave", "\\ddot", "\\tilde", "\\bar", "\\breve", "\\check", "\\hat", "\\vec", "\\dot", "\\mathring"].map((accent2) => "\\" + accent2).join("|"));
defineFunction({
  type: "accent",
  names: ["\\acute", "\\grave", "\\ddot", "\\tilde", "\\bar", "\\breve", "\\check", "\\hat", "\\vec", "\\dot", "\\mathring", "\\widecheck", "\\widehat", "\\widetilde", "\\overrightarrow", "\\overleftarrow", "\\Overrightarrow", "\\overleftrightarrow", "\\overgroup", "\\overlinesegment", "\\overleftharpoon", "\\overrightharpoon"],
  props: {
    numArgs: 1
  },
  handler: (context, args) => {
    var base = normalizeArgument(args[0]);
    var isStretchy = !NON_STRETCHY_ACCENT_REGEX.test(context.funcName);
    var isShifty = !isStretchy || context.funcName === "\\widehat" || context.funcName === "\\widetilde" || context.funcName === "\\widecheck";
    return {
      type: "accent",
      mode: context.parser.mode,
      label: context.funcName,
      isStretchy,
      isShifty,
      base
    };
  },
  htmlBuilder: htmlBuilder$a,
  mathmlBuilder: mathmlBuilder$9
});
defineFunction({
  type: "accent",
  names: ["\\'", "\\`", "\\^", "\\~", "\\=", "\\u", "\\.", '\\"', "\\c", "\\r", "\\H", "\\v", "\\textcircled"],
  props: {
    numArgs: 1,
    allowedInText: true,
    allowedInMath: true,
    // unless in strict mode
    argTypes: ["primitive"]
  },
  handler: (context, args) => {
    var base = args[0];
    var mode = context.parser.mode;
    if (mode === "math") {
      context.parser.settings.reportNonstrict("mathVsTextAccents", "LaTeX's accent " + context.funcName + " works only in text mode");
      mode = "text";
    }
    return {
      type: "accent",
      mode,
      label: context.funcName,
      isStretchy: false,
      isShifty: true,
      base
    };
  },
  htmlBuilder: htmlBuilder$a,
  mathmlBuilder: mathmlBuilder$9
});
defineFunction({
  type: "accentUnder",
  names: ["\\underleftarrow", "\\underrightarrow", "\\underleftrightarrow", "\\undergroup", "\\underlinesegment", "\\utilde"],
  props: {
    numArgs: 1
  },
  handler: (_ref, args) => {
    var {
      parser,
      funcName
    } = _ref;
    var base = args[0];
    return {
      type: "accentUnder",
      mode: parser.mode,
      label: funcName,
      base
    };
  },
  htmlBuilder: (group, options2) => {
    var innerGroup = buildGroup$1(group.base, options2);
    var accentBody = stretchy.svgSpan(group, options2);
    var kern = group.label === "\\utilde" ? 0.12 : 0;
    var vlist = buildCommon.makeVList({
      positionType: "top",
      positionData: innerGroup.height,
      children: [{
        type: "elem",
        elem: accentBody,
        wrapperClasses: ["svg-align"]
      }, {
        type: "kern",
        size: kern
      }, {
        type: "elem",
        elem: innerGroup
      }]
    }, options2);
    return buildCommon.makeSpan(["mord", "accentunder"], [vlist], options2);
  },
  mathmlBuilder: (group, options2) => {
    var accentNode = stretchy.mathMLnode(group.label);
    var node2 = new mathMLTree.MathNode("munder", [buildGroup2(group.base, options2), accentNode]);
    node2.setAttribute("accentunder", "true");
    return node2;
  }
});
var paddedNode = (group) => {
  var node2 = new mathMLTree.MathNode("mpadded", group ? [group] : []);
  node2.setAttribute("width", "+0.6em");
  node2.setAttribute("lspace", "0.3em");
  return node2;
};
defineFunction({
  type: "xArrow",
  names: [
    "\\xleftarrow",
    "\\xrightarrow",
    "\\xLeftarrow",
    "\\xRightarrow",
    "\\xleftrightarrow",
    "\\xLeftrightarrow",
    "\\xhookleftarrow",
    "\\xhookrightarrow",
    "\\xmapsto",
    "\\xrightharpoondown",
    "\\xrightharpoonup",
    "\\xleftharpoondown",
    "\\xleftharpoonup",
    "\\xrightleftharpoons",
    "\\xleftrightharpoons",
    "\\xlongequal",
    "\\xtwoheadrightarrow",
    "\\xtwoheadleftarrow",
    "\\xtofrom",
    // The next 3 functions are here to support the mhchem extension.
    // Direct use of these functions is discouraged and may break someday.
    "\\xrightleftarrows",
    "\\xrightequilibrium",
    "\\xleftequilibrium",
    // The next 3 functions are here only to support the {CD} environment.
    "\\\\cdrightarrow",
    "\\\\cdleftarrow",
    "\\\\cdlongequal"
  ],
  props: {
    numArgs: 1,
    numOptionalArgs: 1
  },
  handler(_ref, args, optArgs) {
    var {
      parser,
      funcName
    } = _ref;
    return {
      type: "xArrow",
      mode: parser.mode,
      label: funcName,
      body: args[0],
      below: optArgs[0]
    };
  },
  // Flow is unable to correctly infer the type of `group`, even though it's
  // unambiguously determined from the passed-in `type` above.
  htmlBuilder(group, options2) {
    var style = options2.style;
    var newOptions = options2.havingStyle(style.sup());
    var upperGroup = buildCommon.wrapFragment(buildGroup$1(group.body, newOptions, options2), options2);
    var arrowPrefix = group.label.slice(0, 2) === "\\x" ? "x" : "cd";
    upperGroup.classes.push(arrowPrefix + "-arrow-pad");
    var lowerGroup;
    if (group.below) {
      newOptions = options2.havingStyle(style.sub());
      lowerGroup = buildCommon.wrapFragment(buildGroup$1(group.below, newOptions, options2), options2);
      lowerGroup.classes.push(arrowPrefix + "-arrow-pad");
    }
    var arrowBody = stretchy.svgSpan(group, options2);
    var arrowShift = -options2.fontMetrics().axisHeight + 0.5 * arrowBody.height;
    var upperShift = -options2.fontMetrics().axisHeight - 0.5 * arrowBody.height - 0.111;
    if (upperGroup.depth > 0.25 || group.label === "\\xleftequilibrium") {
      upperShift -= upperGroup.depth;
    }
    var vlist;
    if (lowerGroup) {
      var lowerShift = -options2.fontMetrics().axisHeight + lowerGroup.height + 0.5 * arrowBody.height + 0.111;
      vlist = buildCommon.makeVList({
        positionType: "individualShift",
        children: [{
          type: "elem",
          elem: upperGroup,
          shift: upperShift
        }, {
          type: "elem",
          elem: arrowBody,
          shift: arrowShift
        }, {
          type: "elem",
          elem: lowerGroup,
          shift: lowerShift
        }]
      }, options2);
    } else {
      vlist = buildCommon.makeVList({
        positionType: "individualShift",
        children: [{
          type: "elem",
          elem: upperGroup,
          shift: upperShift
        }, {
          type: "elem",
          elem: arrowBody,
          shift: arrowShift
        }]
      }, options2);
    }
    vlist.children[0].children[0].children[1].classes.push("svg-align");
    return buildCommon.makeSpan(["mrel", "x-arrow"], [vlist], options2);
  },
  mathmlBuilder(group, options2) {
    var arrowNode = stretchy.mathMLnode(group.label);
    arrowNode.setAttribute("minsize", group.label.charAt(0) === "x" ? "1.75em" : "3.0em");
    var node2;
    if (group.body) {
      var upperNode = paddedNode(buildGroup2(group.body, options2));
      if (group.below) {
        var lowerNode = paddedNode(buildGroup2(group.below, options2));
        node2 = new mathMLTree.MathNode("munderover", [arrowNode, lowerNode, upperNode]);
      } else {
        node2 = new mathMLTree.MathNode("mover", [arrowNode, upperNode]);
      }
    } else if (group.below) {
      var _lowerNode = paddedNode(buildGroup2(group.below, options2));
      node2 = new mathMLTree.MathNode("munder", [arrowNode, _lowerNode]);
    } else {
      node2 = paddedNode();
      node2 = new mathMLTree.MathNode("mover", [arrowNode, node2]);
    }
    return node2;
  }
});
var makeSpan2 = buildCommon.makeSpan;
function htmlBuilder$9(group, options2) {
  var elements = buildExpression$1(group.body, options2, true);
  return makeSpan2([group.mclass], elements, options2);
}
function mathmlBuilder$8(group, options2) {
  var node2;
  var inner2 = buildExpression2(group.body, options2);
  if (group.mclass === "minner") {
    node2 = new mathMLTree.MathNode("mpadded", inner2);
  } else if (group.mclass === "mord") {
    if (group.isCharacterBox) {
      node2 = inner2[0];
      node2.type = "mi";
    } else {
      node2 = new mathMLTree.MathNode("mi", inner2);
    }
  } else {
    if (group.isCharacterBox) {
      node2 = inner2[0];
      node2.type = "mo";
    } else {
      node2 = new mathMLTree.MathNode("mo", inner2);
    }
    if (group.mclass === "mbin") {
      node2.attributes.lspace = "0.22em";
      node2.attributes.rspace = "0.22em";
    } else if (group.mclass === "mpunct") {
      node2.attributes.lspace = "0em";
      node2.attributes.rspace = "0.17em";
    } else if (group.mclass === "mopen" || group.mclass === "mclose") {
      node2.attributes.lspace = "0em";
      node2.attributes.rspace = "0em";
    } else if (group.mclass === "minner") {
      node2.attributes.lspace = "0.0556em";
      node2.attributes.width = "+0.1111em";
    }
  }
  return node2;
}
defineFunction({
  type: "mclass",
  names: ["\\mathord", "\\mathbin", "\\mathrel", "\\mathopen", "\\mathclose", "\\mathpunct", "\\mathinner"],
  props: {
    numArgs: 1,
    primitive: true
  },
  handler(_ref, args) {
    var {
      parser,
      funcName
    } = _ref;
    var body = args[0];
    return {
      type: "mclass",
      mode: parser.mode,
      mclass: "m" + funcName.slice(5),
      // TODO(kevinb): don't prefix with 'm'
      body: ordargument(body),
      isCharacterBox: utils.isCharacterBox(body)
    };
  },
  htmlBuilder: htmlBuilder$9,
  mathmlBuilder: mathmlBuilder$8
});
var binrelClass = (arg) => {
  var atom = arg.type === "ordgroup" && arg.body.length ? arg.body[0] : arg;
  if (atom.type === "atom" && (atom.family === "bin" || atom.family === "rel")) {
    return "m" + atom.family;
  } else {
    return "mord";
  }
};
defineFunction({
  type: "mclass",
  names: ["\\@binrel"],
  props: {
    numArgs: 2
  },
  handler(_ref2, args) {
    var {
      parser
    } = _ref2;
    return {
      type: "mclass",
      mode: parser.mode,
      mclass: binrelClass(args[0]),
      body: ordargument(args[1]),
      isCharacterBox: utils.isCharacterBox(args[1])
    };
  }
});
defineFunction({
  type: "mclass",
  names: ["\\stackrel", "\\overset", "\\underset"],
  props: {
    numArgs: 2
  },
  handler(_ref3, args) {
    var {
      parser,
      funcName
    } = _ref3;
    var baseArg = args[1];
    var shiftedArg = args[0];
    var mclass;
    if (funcName !== "\\stackrel") {
      mclass = binrelClass(baseArg);
    } else {
      mclass = "mrel";
    }
    var baseOp = {
      type: "op",
      mode: baseArg.mode,
      limits: true,
      alwaysHandleSupSub: true,
      parentIsSupSub: false,
      symbol: false,
      suppressBaseShift: funcName !== "\\stackrel",
      body: ordargument(baseArg)
    };
    var supsub = {
      type: "supsub",
      mode: shiftedArg.mode,
      base: baseOp,
      sup: funcName === "\\underset" ? null : shiftedArg,
      sub: funcName === "\\underset" ? shiftedArg : null
    };
    return {
      type: "mclass",
      mode: parser.mode,
      mclass,
      body: [supsub],
      isCharacterBox: utils.isCharacterBox(supsub)
    };
  },
  htmlBuilder: htmlBuilder$9,
  mathmlBuilder: mathmlBuilder$8
});
defineFunction({
  type: "pmb",
  names: ["\\pmb"],
  props: {
    numArgs: 1,
    allowedInText: true
  },
  handler(_ref, args) {
    var {
      parser
    } = _ref;
    return {
      type: "pmb",
      mode: parser.mode,
      mclass: binrelClass(args[0]),
      body: ordargument(args[0])
    };
  },
  htmlBuilder(group, options2) {
    var elements = buildExpression$1(group.body, options2, true);
    var node2 = buildCommon.makeSpan([group.mclass], elements, options2);
    node2.style.textShadow = "0.02em 0.01em 0.04px";
    return node2;
  },
  mathmlBuilder(group, style) {
    var inner2 = buildExpression2(group.body, style);
    var node2 = new mathMLTree.MathNode("mstyle", inner2);
    node2.setAttribute("style", "text-shadow: 0.02em 0.01em 0.04px");
    return node2;
  }
});
var cdArrowFunctionName = {
  ">": "\\\\cdrightarrow",
  "<": "\\\\cdleftarrow",
  "=": "\\\\cdlongequal",
  "A": "\\uparrow",
  "V": "\\downarrow",
  "|": "\\Vert",
  ".": "no arrow"
};
var newCell = () => {
  return {
    type: "styling",
    body: [],
    mode: "math",
    style: "display"
  };
};
var isStartOfArrow = (node2) => {
  return node2.type === "textord" && node2.text === "@";
};
var isLabelEnd = (node2, endChar) => {
  return (node2.type === "mathord" || node2.type === "atom") && node2.text === endChar;
};
function cdArrow(arrowChar, labels, parser) {
  var funcName = cdArrowFunctionName[arrowChar];
  switch (funcName) {
    case "\\\\cdrightarrow":
    case "\\\\cdleftarrow":
      return parser.callFunction(funcName, [labels[0]], [labels[1]]);
    case "\\uparrow":
    case "\\downarrow": {
      var leftLabel = parser.callFunction("\\\\cdleft", [labels[0]], []);
      var bareArrow = {
        type: "atom",
        text: funcName,
        mode: "math",
        family: "rel"
      };
      var sizedArrow = parser.callFunction("\\Big", [bareArrow], []);
      var rightLabel = parser.callFunction("\\\\cdright", [labels[1]], []);
      var arrowGroup = {
        type: "ordgroup",
        mode: "math",
        body: [leftLabel, sizedArrow, rightLabel]
      };
      return parser.callFunction("\\\\cdparent", [arrowGroup], []);
    }
    case "\\\\cdlongequal":
      return parser.callFunction("\\\\cdlongequal", [], []);
    case "\\Vert": {
      var arrow = {
        type: "textord",
        text: "\\Vert",
        mode: "math"
      };
      return parser.callFunction("\\Big", [arrow], []);
    }
    default:
      return {
        type: "textord",
        text: " ",
        mode: "math"
      };
  }
}
function parseCD(parser) {
  var parsedRows = [];
  parser.gullet.beginGroup();
  parser.gullet.macros.set("\\cr", "\\\\\\relax");
  parser.gullet.beginGroup();
  while (true) {
    parsedRows.push(parser.parseExpression(false, "\\\\"));
    parser.gullet.endGroup();
    parser.gullet.beginGroup();
    var next = parser.fetch().text;
    if (next === "&" || next === "\\\\") {
      parser.consume();
    } else if (next === "\\end") {
      if (parsedRows[parsedRows.length - 1].length === 0) {
        parsedRows.pop();
      }
      break;
    } else {
      throw new ParseError("Expected \\\\ or \\cr or \\end", parser.nextToken);
    }
  }
  var row = [];
  var body = [row];
  for (var i = 0; i < parsedRows.length; i++) {
    var rowNodes = parsedRows[i];
    var cell = newCell();
    for (var j = 0; j < rowNodes.length; j++) {
      if (!isStartOfArrow(rowNodes[j])) {
        cell.body.push(rowNodes[j]);
      } else {
        row.push(cell);
        j += 1;
        var arrowChar = assertSymbolNodeType(rowNodes[j]).text;
        var labels = new Array(2);
        labels[0] = {
          type: "ordgroup",
          mode: "math",
          body: []
        };
        labels[1] = {
          type: "ordgroup",
          mode: "math",
          body: []
        };
        if ("=|.".indexOf(arrowChar) > -1)
          ;
        else if ("<>AV".indexOf(arrowChar) > -1) {
          for (var labelNum = 0; labelNum < 2; labelNum++) {
            var inLabel = true;
            for (var k = j + 1; k < rowNodes.length; k++) {
              if (isLabelEnd(rowNodes[k], arrowChar)) {
                inLabel = false;
                j = k;
                break;
              }
              if (isStartOfArrow(rowNodes[k])) {
                throw new ParseError("Missing a " + arrowChar + " character to complete a CD arrow.", rowNodes[k]);
              }
              labels[labelNum].body.push(rowNodes[k]);
            }
            if (inLabel) {
              throw new ParseError("Missing a " + arrowChar + " character to complete a CD arrow.", rowNodes[j]);
            }
          }
        } else {
          throw new ParseError('Expected one of "<>AV=|." after @', rowNodes[j]);
        }
        var arrow = cdArrow(arrowChar, labels, parser);
        var wrappedArrow = {
          type: "styling",
          body: [arrow],
          mode: "math",
          style: "display"
          // CD is always displaystyle.
        };
        row.push(wrappedArrow);
        cell = newCell();
      }
    }
    if (i % 2 === 0) {
      row.push(cell);
    } else {
      row.shift();
    }
    row = [];
    body.push(row);
  }
  parser.gullet.endGroup();
  parser.gullet.endGroup();
  var cols = new Array(body[0].length).fill({
    type: "align",
    align: "c",
    pregap: 0.25,
    // CD package sets \enskip between columns.
    postgap: 0.25
    // So pre and post each get half an \enskip, i.e. 0.25em.
  });
  return {
    type: "array",
    mode: "math",
    body,
    arraystretch: 1,
    addJot: true,
    rowGaps: [null],
    cols,
    colSeparationType: "CD",
    hLinesBeforeRow: new Array(body.length + 1).fill([])
  };
}
defineFunction({
  type: "cdlabel",
  names: ["\\\\cdleft", "\\\\cdright"],
  props: {
    numArgs: 1
  },
  handler(_ref, args) {
    var {
      parser,
      funcName
    } = _ref;
    return {
      type: "cdlabel",
      mode: parser.mode,
      side: funcName.slice(4),
      label: args[0]
    };
  },
  htmlBuilder(group, options2) {
    var newOptions = options2.havingStyle(options2.style.sup());
    var label2 = buildCommon.wrapFragment(buildGroup$1(group.label, newOptions, options2), options2);
    label2.classes.push("cd-label-" + group.side);
    label2.style.bottom = makeEm(0.8 - label2.depth);
    label2.height = 0;
    label2.depth = 0;
    return label2;
  },
  mathmlBuilder(group, options2) {
    var label2 = new mathMLTree.MathNode("mrow", [buildGroup2(group.label, options2)]);
    label2 = new mathMLTree.MathNode("mpadded", [label2]);
    label2.setAttribute("width", "0");
    if (group.side === "left") {
      label2.setAttribute("lspace", "-1width");
    }
    label2.setAttribute("voffset", "0.7em");
    label2 = new mathMLTree.MathNode("mstyle", [label2]);
    label2.setAttribute("displaystyle", "false");
    label2.setAttribute("scriptlevel", "1");
    return label2;
  }
});
defineFunction({
  type: "cdlabelparent",
  names: ["\\\\cdparent"],
  props: {
    numArgs: 1
  },
  handler(_ref2, args) {
    var {
      parser
    } = _ref2;
    return {
      type: "cdlabelparent",
      mode: parser.mode,
      fragment: args[0]
    };
  },
  htmlBuilder(group, options2) {
    var parent = buildCommon.wrapFragment(buildGroup$1(group.fragment, options2), options2);
    parent.classes.push("cd-vert-arrow");
    return parent;
  },
  mathmlBuilder(group, options2) {
    return new mathMLTree.MathNode("mrow", [buildGroup2(group.fragment, options2)]);
  }
});
defineFunction({
  type: "textord",
  names: ["\\@char"],
  props: {
    numArgs: 1,
    allowedInText: true
  },
  handler(_ref, args) {
    var {
      parser
    } = _ref;
    var arg = assertNodeType(args[0], "ordgroup");
    var group = arg.body;
    var number2 = "";
    for (var i = 0; i < group.length; i++) {
      var node2 = assertNodeType(group[i], "textord");
      number2 += node2.text;
    }
    var code2 = parseInt(number2);
    var text2;
    if (isNaN(code2)) {
      throw new ParseError("\\@char has non-numeric argument " + number2);
    } else if (code2 < 0 || code2 >= 1114111) {
      throw new ParseError("\\@char with invalid code point " + number2);
    } else if (code2 <= 65535) {
      text2 = String.fromCharCode(code2);
    } else {
      code2 -= 65536;
      text2 = String.fromCharCode((code2 >> 10) + 55296, (code2 & 1023) + 56320);
    }
    return {
      type: "textord",
      mode: parser.mode,
      text: text2
    };
  }
});
var htmlBuilder$8 = (group, options2) => {
  var elements = buildExpression$1(group.body, options2.withColor(group.color), false);
  return buildCommon.makeFragment(elements);
};
var mathmlBuilder$7 = (group, options2) => {
  var inner2 = buildExpression2(group.body, options2.withColor(group.color));
  var node2 = new mathMLTree.MathNode("mstyle", inner2);
  node2.setAttribute("mathcolor", group.color);
  return node2;
};
defineFunction({
  type: "color",
  names: ["\\textcolor"],
  props: {
    numArgs: 2,
    allowedInText: true,
    argTypes: ["color", "original"]
  },
  handler(_ref, args) {
    var {
      parser
    } = _ref;
    var color = assertNodeType(args[0], "color-token").color;
    var body = args[1];
    return {
      type: "color",
      mode: parser.mode,
      color,
      body: ordargument(body)
    };
  },
  htmlBuilder: htmlBuilder$8,
  mathmlBuilder: mathmlBuilder$7
});
defineFunction({
  type: "color",
  names: ["\\color"],
  props: {
    numArgs: 1,
    allowedInText: true,
    argTypes: ["color"]
  },
  handler(_ref2, args) {
    var {
      parser,
      breakOnTokenText
    } = _ref2;
    var color = assertNodeType(args[0], "color-token").color;
    parser.gullet.macros.set("\\current@color", color);
    var body = parser.parseExpression(true, breakOnTokenText);
    return {
      type: "color",
      mode: parser.mode,
      color,
      body
    };
  },
  htmlBuilder: htmlBuilder$8,
  mathmlBuilder: mathmlBuilder$7
});
defineFunction({
  type: "cr",
  names: ["\\\\"],
  props: {
    numArgs: 0,
    numOptionalArgs: 0,
    allowedInText: true
  },
  handler(_ref, args, optArgs) {
    var {
      parser
    } = _ref;
    var size = parser.gullet.future().text === "[" ? parser.parseSizeGroup(true) : null;
    var newLine = !parser.settings.displayMode || !parser.settings.useStrictBehavior("newLineInDisplayMode", "In LaTeX, \\\\ or \\newline does nothing in display mode");
    return {
      type: "cr",
      mode: parser.mode,
      newLine,
      size: size && assertNodeType(size, "size").value
    };
  },
  // The following builders are called only at the top level,
  // not within tabular/array environments.
  htmlBuilder(group, options2) {
    var span = buildCommon.makeSpan(["mspace"], [], options2);
    if (group.newLine) {
      span.classes.push("newline");
      if (group.size) {
        span.style.marginTop = makeEm(calculateSize(group.size, options2));
      }
    }
    return span;
  },
  mathmlBuilder(group, options2) {
    var node2 = new mathMLTree.MathNode("mspace");
    if (group.newLine) {
      node2.setAttribute("linebreak", "newline");
      if (group.size) {
        node2.setAttribute("height", makeEm(calculateSize(group.size, options2)));
      }
    }
    return node2;
  }
});
var globalMap = {
  "\\global": "\\global",
  "\\long": "\\\\globallong",
  "\\\\globallong": "\\\\globallong",
  "\\def": "\\gdef",
  "\\gdef": "\\gdef",
  "\\edef": "\\xdef",
  "\\xdef": "\\xdef",
  "\\let": "\\\\globallet",
  "\\futurelet": "\\\\globalfuture"
};
var checkControlSequence = (tok) => {
  var name = tok.text;
  if (/^(?:[\\{}$&#^_]|EOF)$/.test(name)) {
    throw new ParseError("Expected a control sequence", tok);
  }
  return name;
};
var getRHS = (parser) => {
  var tok = parser.gullet.popToken();
  if (tok.text === "=") {
    tok = parser.gullet.popToken();
    if (tok.text === " ") {
      tok = parser.gullet.popToken();
    }
  }
  return tok;
};
var letCommand = (parser, name, tok, global2) => {
  var macro = parser.gullet.macros.get(tok.text);
  if (macro == null) {
    tok.noexpand = true;
    macro = {
      tokens: [tok],
      numArgs: 0,
      // reproduce the same behavior in expansion
      unexpandable: !parser.gullet.isExpandable(tok.text)
    };
  }
  parser.gullet.macros.set(name, macro, global2);
};
defineFunction({
  type: "internal",
  names: [
    "\\global",
    "\\long",
    "\\\\globallong"
    // can’t be entered directly
  ],
  props: {
    numArgs: 0,
    allowedInText: true
  },
  handler(_ref) {
    var {
      parser,
      funcName
    } = _ref;
    parser.consumeSpaces();
    var token = parser.fetch();
    if (globalMap[token.text]) {
      if (funcName === "\\global" || funcName === "\\\\globallong") {
        token.text = globalMap[token.text];
      }
      return assertNodeType(parser.parseFunction(), "internal");
    }
    throw new ParseError("Invalid token after macro prefix", token);
  }
});
defineFunction({
  type: "internal",
  names: ["\\def", "\\gdef", "\\edef", "\\xdef"],
  props: {
    numArgs: 0,
    allowedInText: true,
    primitive: true
  },
  handler(_ref2) {
    var {
      parser,
      funcName
    } = _ref2;
    var tok = parser.gullet.popToken();
    var name = tok.text;
    if (/^(?:[\\{}$&#^_]|EOF)$/.test(name)) {
      throw new ParseError("Expected a control sequence", tok);
    }
    var numArgs = 0;
    var insert;
    var delimiters2 = [[]];
    while (parser.gullet.future().text !== "{") {
      tok = parser.gullet.popToken();
      if (tok.text === "#") {
        if (parser.gullet.future().text === "{") {
          insert = parser.gullet.future();
          delimiters2[numArgs].push("{");
          break;
        }
        tok = parser.gullet.popToken();
        if (!/^[1-9]$/.test(tok.text)) {
          throw new ParseError('Invalid argument number "' + tok.text + '"');
        }
        if (parseInt(tok.text) !== numArgs + 1) {
          throw new ParseError('Argument number "' + tok.text + '" out of order');
        }
        numArgs++;
        delimiters2.push([]);
      } else if (tok.text === "EOF") {
        throw new ParseError("Expected a macro definition");
      } else {
        delimiters2[numArgs].push(tok.text);
      }
    }
    var {
      tokens
    } = parser.gullet.consumeArg();
    if (insert) {
      tokens.unshift(insert);
    }
    if (funcName === "\\edef" || funcName === "\\xdef") {
      tokens = parser.gullet.expandTokens(tokens);
      tokens.reverse();
    }
    parser.gullet.macros.set(name, {
      tokens,
      numArgs,
      delimiters: delimiters2
    }, funcName === globalMap[funcName]);
    return {
      type: "internal",
      mode: parser.mode
    };
  }
});
defineFunction({
  type: "internal",
  names: [
    "\\let",
    "\\\\globallet"
    // can’t be entered directly
  ],
  props: {
    numArgs: 0,
    allowedInText: true,
    primitive: true
  },
  handler(_ref3) {
    var {
      parser,
      funcName
    } = _ref3;
    var name = checkControlSequence(parser.gullet.popToken());
    parser.gullet.consumeSpaces();
    var tok = getRHS(parser);
    letCommand(parser, name, tok, funcName === "\\\\globallet");
    return {
      type: "internal",
      mode: parser.mode
    };
  }
});
defineFunction({
  type: "internal",
  names: [
    "\\futurelet",
    "\\\\globalfuture"
    // can’t be entered directly
  ],
  props: {
    numArgs: 0,
    allowedInText: true,
    primitive: true
  },
  handler(_ref4) {
    var {
      parser,
      funcName
    } = _ref4;
    var name = checkControlSequence(parser.gullet.popToken());
    var middle = parser.gullet.popToken();
    var tok = parser.gullet.popToken();
    letCommand(parser, name, tok, funcName === "\\\\globalfuture");
    parser.gullet.pushToken(tok);
    parser.gullet.pushToken(middle);
    return {
      type: "internal",
      mode: parser.mode
    };
  }
});
var getMetrics = function getMetrics2(symbol, font, mode) {
  var replace = symbols.math[symbol] && symbols.math[symbol].replace;
  var metrics = getCharacterMetrics(replace || symbol, font, mode);
  if (!metrics) {
    throw new Error("Unsupported symbol " + symbol + " and font size " + font + ".");
  }
  return metrics;
};
var styleWrap = function styleWrap2(delim, toStyle, options2, classes) {
  var newOptions = options2.havingBaseStyle(toStyle);
  var span = buildCommon.makeSpan(classes.concat(newOptions.sizingClasses(options2)), [delim], options2);
  var delimSizeMultiplier = newOptions.sizeMultiplier / options2.sizeMultiplier;
  span.height *= delimSizeMultiplier;
  span.depth *= delimSizeMultiplier;
  span.maxFontSize = newOptions.sizeMultiplier;
  return span;
};
var centerSpan = function centerSpan2(span, options2, style) {
  var newOptions = options2.havingBaseStyle(style);
  var shift = (1 - options2.sizeMultiplier / newOptions.sizeMultiplier) * options2.fontMetrics().axisHeight;
  span.classes.push("delimcenter");
  span.style.top = makeEm(shift);
  span.height -= shift;
  span.depth += shift;
};
var makeSmallDelim = function makeSmallDelim2(delim, style, center, options2, mode, classes) {
  var text2 = buildCommon.makeSymbol(delim, "Main-Regular", mode, options2);
  var span = styleWrap(text2, style, options2, classes);
  if (center) {
    centerSpan(span, options2, style);
  }
  return span;
};
var mathrmSize = function mathrmSize2(value, size, mode, options2) {
  return buildCommon.makeSymbol(value, "Size" + size + "-Regular", mode, options2);
};
var makeLargeDelim = function makeLargeDelim2(delim, size, center, options2, mode, classes) {
  var inner2 = mathrmSize(delim, size, mode, options2);
  var span = styleWrap(buildCommon.makeSpan(["delimsizing", "size" + size], [inner2], options2), Style$1.TEXT, options2, classes);
  if (center) {
    centerSpan(span, options2, Style$1.TEXT);
  }
  return span;
};
var makeGlyphSpan = function makeGlyphSpan2(symbol, font, mode) {
  var sizeClass;
  if (font === "Size1-Regular") {
    sizeClass = "delim-size1";
  } else {
    sizeClass = "delim-size4";
  }
  var corner = buildCommon.makeSpan(["delimsizinginner", sizeClass], [buildCommon.makeSpan([], [buildCommon.makeSymbol(symbol, font, mode)])]);
  return {
    type: "elem",
    elem: corner
  };
};
var makeInner = function makeInner2(ch, height, options2) {
  var width = fontMetricsData["Size4-Regular"][ch.charCodeAt(0)] ? fontMetricsData["Size4-Regular"][ch.charCodeAt(0)][4] : fontMetricsData["Size1-Regular"][ch.charCodeAt(0)][4];
  var path2 = new PathNode("inner", innerPath(ch, Math.round(1e3 * height)));
  var svgNode = new SvgNode([path2], {
    "width": makeEm(width),
    "height": makeEm(height),
    // Override CSS rule `.katex svg { width: 100% }`
    "style": "width:" + makeEm(width),
    "viewBox": "0 0 " + 1e3 * width + " " + Math.round(1e3 * height),
    "preserveAspectRatio": "xMinYMin"
  });
  var span = buildCommon.makeSvgSpan([], [svgNode], options2);
  span.height = height;
  span.style.height = makeEm(height);
  span.style.width = makeEm(width);
  return {
    type: "elem",
    elem: span
  };
};
var lapInEms = 8e-3;
var lap = {
  type: "kern",
  size: -1 * lapInEms
};
var verts = ["|", "\\lvert", "\\rvert", "\\vert"];
var doubleVerts = ["\\|", "\\lVert", "\\rVert", "\\Vert"];
var makeStackedDelim = function makeStackedDelim2(delim, heightTotal, center, options2, mode, classes) {
  var top;
  var middle;
  var repeat;
  var bottom;
  var svgLabel = "";
  var viewBoxWidth = 0;
  top = repeat = bottom = delim;
  middle = null;
  var font = "Size1-Regular";
  if (delim === "\\uparrow") {
    repeat = bottom = "⏐";
  } else if (delim === "\\Uparrow") {
    repeat = bottom = "‖";
  } else if (delim === "\\downarrow") {
    top = repeat = "⏐";
  } else if (delim === "\\Downarrow") {
    top = repeat = "‖";
  } else if (delim === "\\updownarrow") {
    top = "\\uparrow";
    repeat = "⏐";
    bottom = "\\downarrow";
  } else if (delim === "\\Updownarrow") {
    top = "\\Uparrow";
    repeat = "‖";
    bottom = "\\Downarrow";
  } else if (utils.contains(verts, delim)) {
    repeat = "∣";
    svgLabel = "vert";
    viewBoxWidth = 333;
  } else if (utils.contains(doubleVerts, delim)) {
    repeat = "∥";
    svgLabel = "doublevert";
    viewBoxWidth = 556;
  } else if (delim === "[" || delim === "\\lbrack") {
    top = "⎡";
    repeat = "⎢";
    bottom = "⎣";
    font = "Size4-Regular";
    svgLabel = "lbrack";
    viewBoxWidth = 667;
  } else if (delim === "]" || delim === "\\rbrack") {
    top = "⎤";
    repeat = "⎥";
    bottom = "⎦";
    font = "Size4-Regular";
    svgLabel = "rbrack";
    viewBoxWidth = 667;
  } else if (delim === "\\lfloor" || delim === "⌊") {
    repeat = top = "⎢";
    bottom = "⎣";
    font = "Size4-Regular";
    svgLabel = "lfloor";
    viewBoxWidth = 667;
  } else if (delim === "\\lceil" || delim === "⌈") {
    top = "⎡";
    repeat = bottom = "⎢";
    font = "Size4-Regular";
    svgLabel = "lceil";
    viewBoxWidth = 667;
  } else if (delim === "\\rfloor" || delim === "⌋") {
    repeat = top = "⎥";
    bottom = "⎦";
    font = "Size4-Regular";
    svgLabel = "rfloor";
    viewBoxWidth = 667;
  } else if (delim === "\\rceil" || delim === "⌉") {
    top = "⎤";
    repeat = bottom = "⎥";
    font = "Size4-Regular";
    svgLabel = "rceil";
    viewBoxWidth = 667;
  } else if (delim === "(" || delim === "\\lparen") {
    top = "⎛";
    repeat = "⎜";
    bottom = "⎝";
    font = "Size4-Regular";
    svgLabel = "lparen";
    viewBoxWidth = 875;
  } else if (delim === ")" || delim === "\\rparen") {
    top = "⎞";
    repeat = "⎟";
    bottom = "⎠";
    font = "Size4-Regular";
    svgLabel = "rparen";
    viewBoxWidth = 875;
  } else if (delim === "\\{" || delim === "\\lbrace") {
    top = "⎧";
    middle = "⎨";
    bottom = "⎩";
    repeat = "⎪";
    font = "Size4-Regular";
  } else if (delim === "\\}" || delim === "\\rbrace") {
    top = "⎫";
    middle = "⎬";
    bottom = "⎭";
    repeat = "⎪";
    font = "Size4-Regular";
  } else if (delim === "\\lgroup" || delim === "⟮") {
    top = "⎧";
    bottom = "⎩";
    repeat = "⎪";
    font = "Size4-Regular";
  } else if (delim === "\\rgroup" || delim === "⟯") {
    top = "⎫";
    bottom = "⎭";
    repeat = "⎪";
    font = "Size4-Regular";
  } else if (delim === "\\lmoustache" || delim === "⎰") {
    top = "⎧";
    bottom = "⎭";
    repeat = "⎪";
    font = "Size4-Regular";
  } else if (delim === "\\rmoustache" || delim === "⎱") {
    top = "⎫";
    bottom = "⎩";
    repeat = "⎪";
    font = "Size4-Regular";
  }
  var topMetrics = getMetrics(top, font, mode);
  var topHeightTotal = topMetrics.height + topMetrics.depth;
  var repeatMetrics = getMetrics(repeat, font, mode);
  var repeatHeightTotal = repeatMetrics.height + repeatMetrics.depth;
  var bottomMetrics = getMetrics(bottom, font, mode);
  var bottomHeightTotal = bottomMetrics.height + bottomMetrics.depth;
  var middleHeightTotal = 0;
  var middleFactor = 1;
  if (middle !== null) {
    var middleMetrics = getMetrics(middle, font, mode);
    middleHeightTotal = middleMetrics.height + middleMetrics.depth;
    middleFactor = 2;
  }
  var minHeight = topHeightTotal + bottomHeightTotal + middleHeightTotal;
  var repeatCount = Math.max(0, Math.ceil((heightTotal - minHeight) / (middleFactor * repeatHeightTotal)));
  var realHeightTotal = minHeight + repeatCount * middleFactor * repeatHeightTotal;
  var axisHeight = options2.fontMetrics().axisHeight;
  if (center) {
    axisHeight *= options2.sizeMultiplier;
  }
  var depth = realHeightTotal / 2 - axisHeight;
  var stack = [];
  if (svgLabel.length > 0) {
    var midHeight = realHeightTotal - topHeightTotal - bottomHeightTotal;
    var viewBoxHeight = Math.round(realHeightTotal * 1e3);
    var pathStr = tallDelim(svgLabel, Math.round(midHeight * 1e3));
    var path2 = new PathNode(svgLabel, pathStr);
    var width = (viewBoxWidth / 1e3).toFixed(3) + "em";
    var height = (viewBoxHeight / 1e3).toFixed(3) + "em";
    var svg2 = new SvgNode([path2], {
      "width": width,
      "height": height,
      "viewBox": "0 0 " + viewBoxWidth + " " + viewBoxHeight
    });
    var wrapper = buildCommon.makeSvgSpan([], [svg2], options2);
    wrapper.height = viewBoxHeight / 1e3;
    wrapper.style.width = width;
    wrapper.style.height = height;
    stack.push({
      type: "elem",
      elem: wrapper
    });
  } else {
    stack.push(makeGlyphSpan(bottom, font, mode));
    stack.push(lap);
    if (middle === null) {
      var innerHeight = realHeightTotal - topHeightTotal - bottomHeightTotal + 2 * lapInEms;
      stack.push(makeInner(repeat, innerHeight, options2));
    } else {
      var _innerHeight = (realHeightTotal - topHeightTotal - bottomHeightTotal - middleHeightTotal) / 2 + 2 * lapInEms;
      stack.push(makeInner(repeat, _innerHeight, options2));
      stack.push(lap);
      stack.push(makeGlyphSpan(middle, font, mode));
      stack.push(lap);
      stack.push(makeInner(repeat, _innerHeight, options2));
    }
    stack.push(lap);
    stack.push(makeGlyphSpan(top, font, mode));
  }
  var newOptions = options2.havingBaseStyle(Style$1.TEXT);
  var inner2 = buildCommon.makeVList({
    positionType: "bottom",
    positionData: depth,
    children: stack
  }, newOptions);
  return styleWrap(buildCommon.makeSpan(["delimsizing", "mult"], [inner2], newOptions), Style$1.TEXT, options2, classes);
};
var vbPad = 80;
var emPad = 0.08;
var sqrtSvg = function sqrtSvg2(sqrtName, height, viewBoxHeight, extraVinculum, options2) {
  var path2 = sqrtPath(sqrtName, extraVinculum, viewBoxHeight);
  var pathNode = new PathNode(sqrtName, path2);
  var svg2 = new SvgNode([pathNode], {
    // Note: 1000:1 ratio of viewBox to document em width.
    "width": "400em",
    "height": makeEm(height),
    "viewBox": "0 0 400000 " + viewBoxHeight,
    "preserveAspectRatio": "xMinYMin slice"
  });
  return buildCommon.makeSvgSpan(["hide-tail"], [svg2], options2);
};
var makeSqrtImage = function makeSqrtImage2(height, options2) {
  var newOptions = options2.havingBaseSizing();
  var delim = traverseSequence("\\surd", height * newOptions.sizeMultiplier, stackLargeDelimiterSequence, newOptions);
  var sizeMultiplier = newOptions.sizeMultiplier;
  var extraVinculum = Math.max(0, options2.minRuleThickness - options2.fontMetrics().sqrtRuleThickness);
  var span;
  var spanHeight = 0;
  var texHeight = 0;
  var viewBoxHeight = 0;
  var advanceWidth;
  if (delim.type === "small") {
    viewBoxHeight = 1e3 + 1e3 * extraVinculum + vbPad;
    if (height < 1) {
      sizeMultiplier = 1;
    } else if (height < 1.4) {
      sizeMultiplier = 0.7;
    }
    spanHeight = (1 + extraVinculum + emPad) / sizeMultiplier;
    texHeight = (1 + extraVinculum) / sizeMultiplier;
    span = sqrtSvg("sqrtMain", spanHeight, viewBoxHeight, extraVinculum, options2);
    span.style.minWidth = "0.853em";
    advanceWidth = 0.833 / sizeMultiplier;
  } else if (delim.type === "large") {
    viewBoxHeight = (1e3 + vbPad) * sizeToMaxHeight[delim.size];
    texHeight = (sizeToMaxHeight[delim.size] + extraVinculum) / sizeMultiplier;
    spanHeight = (sizeToMaxHeight[delim.size] + extraVinculum + emPad) / sizeMultiplier;
    span = sqrtSvg("sqrtSize" + delim.size, spanHeight, viewBoxHeight, extraVinculum, options2);
    span.style.minWidth = "1.02em";
    advanceWidth = 1 / sizeMultiplier;
  } else {
    spanHeight = height + extraVinculum + emPad;
    texHeight = height + extraVinculum;
    viewBoxHeight = Math.floor(1e3 * height + extraVinculum) + vbPad;
    span = sqrtSvg("sqrtTall", spanHeight, viewBoxHeight, extraVinculum, options2);
    span.style.minWidth = "0.742em";
    advanceWidth = 1.056;
  }
  span.height = texHeight;
  span.style.height = makeEm(spanHeight);
  return {
    span,
    advanceWidth,
    // Calculate the actual line width.
    // This actually should depend on the chosen font -- e.g. \boldmath
    // should use the thicker surd symbols from e.g. KaTeX_Main-Bold, and
    // have thicker rules.
    ruleWidth: (options2.fontMetrics().sqrtRuleThickness + extraVinculum) * sizeMultiplier
  };
};
var stackLargeDelimiters = ["(", "\\lparen", ")", "\\rparen", "[", "\\lbrack", "]", "\\rbrack", "\\{", "\\lbrace", "\\}", "\\rbrace", "\\lfloor", "\\rfloor", "⌊", "⌋", "\\lceil", "\\rceil", "⌈", "⌉", "\\surd"];
var stackAlwaysDelimiters = ["\\uparrow", "\\downarrow", "\\updownarrow", "\\Uparrow", "\\Downarrow", "\\Updownarrow", "|", "\\|", "\\vert", "\\Vert", "\\lvert", "\\rvert", "\\lVert", "\\rVert", "\\lgroup", "\\rgroup", "⟮", "⟯", "\\lmoustache", "\\rmoustache", "⎰", "⎱"];
var stackNeverDelimiters = ["<", ">", "\\langle", "\\rangle", "/", "\\backslash", "\\lt", "\\gt"];
var sizeToMaxHeight = [0, 1.2, 1.8, 2.4, 3];
var makeSizedDelim = function makeSizedDelim2(delim, size, options2, mode, classes) {
  if (delim === "<" || delim === "\\lt" || delim === "⟨") {
    delim = "\\langle";
  } else if (delim === ">" || delim === "\\gt" || delim === "⟩") {
    delim = "\\rangle";
  }
  if (utils.contains(stackLargeDelimiters, delim) || utils.contains(stackNeverDelimiters, delim)) {
    return makeLargeDelim(delim, size, false, options2, mode, classes);
  } else if (utils.contains(stackAlwaysDelimiters, delim)) {
    return makeStackedDelim(delim, sizeToMaxHeight[size], false, options2, mode, classes);
  } else {
    throw new ParseError("Illegal delimiter: '" + delim + "'");
  }
};
var stackNeverDelimiterSequence = [{
  type: "small",
  style: Style$1.SCRIPTSCRIPT
}, {
  type: "small",
  style: Style$1.SCRIPT
}, {
  type: "small",
  style: Style$1.TEXT
}, {
  type: "large",
  size: 1
}, {
  type: "large",
  size: 2
}, {
  type: "large",
  size: 3
}, {
  type: "large",
  size: 4
}];
var stackAlwaysDelimiterSequence = [{
  type: "small",
  style: Style$1.SCRIPTSCRIPT
}, {
  type: "small",
  style: Style$1.SCRIPT
}, {
  type: "small",
  style: Style$1.TEXT
}, {
  type: "stack"
}];
var stackLargeDelimiterSequence = [{
  type: "small",
  style: Style$1.SCRIPTSCRIPT
}, {
  type: "small",
  style: Style$1.SCRIPT
}, {
  type: "small",
  style: Style$1.TEXT
}, {
  type: "large",
  size: 1
}, {
  type: "large",
  size: 2
}, {
  type: "large",
  size: 3
}, {
  type: "large",
  size: 4
}, {
  type: "stack"
}];
var delimTypeToFont = function delimTypeToFont2(type) {
  if (type.type === "small") {
    return "Main-Regular";
  } else if (type.type === "large") {
    return "Size" + type.size + "-Regular";
  } else if (type.type === "stack") {
    return "Size4-Regular";
  } else {
    throw new Error("Add support for delim type '" + type.type + "' here.");
  }
};
var traverseSequence = function traverseSequence2(delim, height, sequence, options2) {
  var start = Math.min(2, 3 - options2.style.size);
  for (var i = start; i < sequence.length; i++) {
    if (sequence[i].type === "stack") {
      break;
    }
    var metrics = getMetrics(delim, delimTypeToFont(sequence[i]), "math");
    var heightDepth = metrics.height + metrics.depth;
    if (sequence[i].type === "small") {
      var newOptions = options2.havingBaseStyle(sequence[i].style);
      heightDepth *= newOptions.sizeMultiplier;
    }
    if (heightDepth > height) {
      return sequence[i];
    }
  }
  return sequence[sequence.length - 1];
};
var makeCustomSizedDelim = function makeCustomSizedDelim2(delim, height, center, options2, mode, classes) {
  if (delim === "<" || delim === "\\lt" || delim === "⟨") {
    delim = "\\langle";
  } else if (delim === ">" || delim === "\\gt" || delim === "⟩") {
    delim = "\\rangle";
  }
  var sequence;
  if (utils.contains(stackNeverDelimiters, delim)) {
    sequence = stackNeverDelimiterSequence;
  } else if (utils.contains(stackLargeDelimiters, delim)) {
    sequence = stackLargeDelimiterSequence;
  } else {
    sequence = stackAlwaysDelimiterSequence;
  }
  var delimType = traverseSequence(delim, height, sequence, options2);
  if (delimType.type === "small") {
    return makeSmallDelim(delim, delimType.style, center, options2, mode, classes);
  } else if (delimType.type === "large") {
    return makeLargeDelim(delim, delimType.size, center, options2, mode, classes);
  } else {
    return makeStackedDelim(delim, height, center, options2, mode, classes);
  }
};
var makeLeftRightDelim = function makeLeftRightDelim2(delim, height, depth, options2, mode, classes) {
  var axisHeight = options2.fontMetrics().axisHeight * options2.sizeMultiplier;
  var delimiterFactor = 901;
  var delimiterExtend = 5 / options2.fontMetrics().ptPerEm;
  var maxDistFromAxis = Math.max(height - axisHeight, depth + axisHeight);
  var totalHeight = Math.max(
    // In real TeX, calculations are done using integral values which are
    // 65536 per pt, or 655360 per em. So, the division here truncates in
    // TeX but doesn't here, producing different results. If we wanted to
    // exactly match TeX's calculation, we could do
    //   Math.floor(655360 * maxDistFromAxis / 500) *
    //    delimiterFactor / 655360
    // (To see the difference, compare
    //    x^{x^{\left(\rule{0.1em}{0.68em}\right)}}
    // in TeX and KaTeX)
    maxDistFromAxis / 500 * delimiterFactor,
    2 * maxDistFromAxis - delimiterExtend
  );
  return makeCustomSizedDelim(delim, totalHeight, true, options2, mode, classes);
};
var delimiter = {
  sqrtImage: makeSqrtImage,
  sizedDelim: makeSizedDelim,
  sizeToMaxHeight,
  customSizedDelim: makeCustomSizedDelim,
  leftRightDelim: makeLeftRightDelim
};
var delimiterSizes = {
  "\\bigl": {
    mclass: "mopen",
    size: 1
  },
  "\\Bigl": {
    mclass: "mopen",
    size: 2
  },
  "\\biggl": {
    mclass: "mopen",
    size: 3
  },
  "\\Biggl": {
    mclass: "mopen",
    size: 4
  },
  "\\bigr": {
    mclass: "mclose",
    size: 1
  },
  "\\Bigr": {
    mclass: "mclose",
    size: 2
  },
  "\\biggr": {
    mclass: "mclose",
    size: 3
  },
  "\\Biggr": {
    mclass: "mclose",
    size: 4
  },
  "\\bigm": {
    mclass: "mrel",
    size: 1
  },
  "\\Bigm": {
    mclass: "mrel",
    size: 2
  },
  "\\biggm": {
    mclass: "mrel",
    size: 3
  },
  "\\Biggm": {
    mclass: "mrel",
    size: 4
  },
  "\\big": {
    mclass: "mord",
    size: 1
  },
  "\\Big": {
    mclass: "mord",
    size: 2
  },
  "\\bigg": {
    mclass: "mord",
    size: 3
  },
  "\\Bigg": {
    mclass: "mord",
    size: 4
  }
};
var delimiters = ["(", "\\lparen", ")", "\\rparen", "[", "\\lbrack", "]", "\\rbrack", "\\{", "\\lbrace", "\\}", "\\rbrace", "\\lfloor", "\\rfloor", "⌊", "⌋", "\\lceil", "\\rceil", "⌈", "⌉", "<", ">", "\\langle", "⟨", "\\rangle", "⟩", "\\lt", "\\gt", "\\lvert", "\\rvert", "\\lVert", "\\rVert", "\\lgroup", "\\rgroup", "⟮", "⟯", "\\lmoustache", "\\rmoustache", "⎰", "⎱", "/", "\\backslash", "|", "\\vert", "\\|", "\\Vert", "\\uparrow", "\\Uparrow", "\\downarrow", "\\Downarrow", "\\updownarrow", "\\Updownarrow", "."];
function checkDelimiter(delim, context) {
  var symDelim = checkSymbolNodeType(delim);
  if (symDelim && utils.contains(delimiters, symDelim.text)) {
    return symDelim;
  } else if (symDelim) {
    throw new ParseError("Invalid delimiter '" + symDelim.text + "' after '" + context.funcName + "'", delim);
  } else {
    throw new ParseError("Invalid delimiter type '" + delim.type + "'", delim);
  }
}
defineFunction({
  type: "delimsizing",
  names: ["\\bigl", "\\Bigl", "\\biggl", "\\Biggl", "\\bigr", "\\Bigr", "\\biggr", "\\Biggr", "\\bigm", "\\Bigm", "\\biggm", "\\Biggm", "\\big", "\\Big", "\\bigg", "\\Bigg"],
  props: {
    numArgs: 1,
    argTypes: ["primitive"]
  },
  handler: (context, args) => {
    var delim = checkDelimiter(args[0], context);
    return {
      type: "delimsizing",
      mode: context.parser.mode,
      size: delimiterSizes[context.funcName].size,
      mclass: delimiterSizes[context.funcName].mclass,
      delim: delim.text
    };
  },
  htmlBuilder: (group, options2) => {
    if (group.delim === ".") {
      return buildCommon.makeSpan([group.mclass]);
    }
    return delimiter.sizedDelim(group.delim, group.size, options2, group.mode, [group.mclass]);
  },
  mathmlBuilder: (group) => {
    var children = [];
    if (group.delim !== ".") {
      children.push(makeText(group.delim, group.mode));
    }
    var node2 = new mathMLTree.MathNode("mo", children);
    if (group.mclass === "mopen" || group.mclass === "mclose") {
      node2.setAttribute("fence", "true");
    } else {
      node2.setAttribute("fence", "false");
    }
    node2.setAttribute("stretchy", "true");
    var size = makeEm(delimiter.sizeToMaxHeight[group.size]);
    node2.setAttribute("minsize", size);
    node2.setAttribute("maxsize", size);
    return node2;
  }
});
function assertParsed(group) {
  if (!group.body) {
    throw new Error("Bug: The leftright ParseNode wasn't fully parsed.");
  }
}
defineFunction({
  type: "leftright-right",
  names: ["\\right"],
  props: {
    numArgs: 1,
    primitive: true
  },
  handler: (context, args) => {
    var color = context.parser.gullet.macros.get("\\current@color");
    if (color && typeof color !== "string") {
      throw new ParseError("\\current@color set to non-string in \\right");
    }
    return {
      type: "leftright-right",
      mode: context.parser.mode,
      delim: checkDelimiter(args[0], context).text,
      color
      // undefined if not set via \color
    };
  }
});
defineFunction({
  type: "leftright",
  names: ["\\left"],
  props: {
    numArgs: 1,
    primitive: true
  },
  handler: (context, args) => {
    var delim = checkDelimiter(args[0], context);
    var parser = context.parser;
    ++parser.leftrightDepth;
    var body = parser.parseExpression(false);
    --parser.leftrightDepth;
    parser.expect("\\right", false);
    var right = assertNodeType(parser.parseFunction(), "leftright-right");
    return {
      type: "leftright",
      mode: parser.mode,
      body,
      left: delim.text,
      right: right.delim,
      rightColor: right.color
    };
  },
  htmlBuilder: (group, options2) => {
    assertParsed(group);
    var inner2 = buildExpression$1(group.body, options2, true, ["mopen", "mclose"]);
    var innerHeight = 0;
    var innerDepth = 0;
    var hadMiddle = false;
    for (var i = 0; i < inner2.length; i++) {
      if (inner2[i].isMiddle) {
        hadMiddle = true;
      } else {
        innerHeight = Math.max(inner2[i].height, innerHeight);
        innerDepth = Math.max(inner2[i].depth, innerDepth);
      }
    }
    innerHeight *= options2.sizeMultiplier;
    innerDepth *= options2.sizeMultiplier;
    var leftDelim;
    if (group.left === ".") {
      leftDelim = makeNullDelimiter(options2, ["mopen"]);
    } else {
      leftDelim = delimiter.leftRightDelim(group.left, innerHeight, innerDepth, options2, group.mode, ["mopen"]);
    }
    inner2.unshift(leftDelim);
    if (hadMiddle) {
      for (var _i = 1; _i < inner2.length; _i++) {
        var middleDelim = inner2[_i];
        var isMiddle = middleDelim.isMiddle;
        if (isMiddle) {
          inner2[_i] = delimiter.leftRightDelim(isMiddle.delim, innerHeight, innerDepth, isMiddle.options, group.mode, []);
        }
      }
    }
    var rightDelim;
    if (group.right === ".") {
      rightDelim = makeNullDelimiter(options2, ["mclose"]);
    } else {
      var colorOptions = group.rightColor ? options2.withColor(group.rightColor) : options2;
      rightDelim = delimiter.leftRightDelim(group.right, innerHeight, innerDepth, colorOptions, group.mode, ["mclose"]);
    }
    inner2.push(rightDelim);
    return buildCommon.makeSpan(["minner"], inner2, options2);
  },
  mathmlBuilder: (group, options2) => {
    assertParsed(group);
    var inner2 = buildExpression2(group.body, options2);
    if (group.left !== ".") {
      var leftNode = new mathMLTree.MathNode("mo", [makeText(group.left, group.mode)]);
      leftNode.setAttribute("fence", "true");
      inner2.unshift(leftNode);
    }
    if (group.right !== ".") {
      var rightNode = new mathMLTree.MathNode("mo", [makeText(group.right, group.mode)]);
      rightNode.setAttribute("fence", "true");
      if (group.rightColor) {
        rightNode.setAttribute("mathcolor", group.rightColor);
      }
      inner2.push(rightNode);
    }
    return makeRow(inner2);
  }
});
defineFunction({
  type: "middle",
  names: ["\\middle"],
  props: {
    numArgs: 1,
    primitive: true
  },
  handler: (context, args) => {
    var delim = checkDelimiter(args[0], context);
    if (!context.parser.leftrightDepth) {
      throw new ParseError("\\middle without preceding \\left", delim);
    }
    return {
      type: "middle",
      mode: context.parser.mode,
      delim: delim.text
    };
  },
  htmlBuilder: (group, options2) => {
    var middleDelim;
    if (group.delim === ".") {
      middleDelim = makeNullDelimiter(options2, []);
    } else {
      middleDelim = delimiter.sizedDelim(group.delim, 1, options2, group.mode, []);
      var isMiddle = {
        delim: group.delim,
        options: options2
      };
      middleDelim.isMiddle = isMiddle;
    }
    return middleDelim;
  },
  mathmlBuilder: (group, options2) => {
    var textNode = group.delim === "\\vert" || group.delim === "|" ? makeText("|", "text") : makeText(group.delim, group.mode);
    var middleNode = new mathMLTree.MathNode("mo", [textNode]);
    middleNode.setAttribute("fence", "true");
    middleNode.setAttribute("lspace", "0.05em");
    middleNode.setAttribute("rspace", "0.05em");
    return middleNode;
  }
});
var htmlBuilder$7 = (group, options2) => {
  var inner2 = buildCommon.wrapFragment(buildGroup$1(group.body, options2), options2);
  var label2 = group.label.slice(1);
  var scale = options2.sizeMultiplier;
  var img;
  var imgShift = 0;
  var isSingleChar = utils.isCharacterBox(group.body);
  if (label2 === "sout") {
    img = buildCommon.makeSpan(["stretchy", "sout"]);
    img.height = options2.fontMetrics().defaultRuleThickness / scale;
    imgShift = -0.5 * options2.fontMetrics().xHeight;
  } else if (label2 === "phase") {
    var lineWeight = calculateSize({
      number: 0.6,
      unit: "pt"
    }, options2);
    var clearance = calculateSize({
      number: 0.35,
      unit: "ex"
    }, options2);
    var newOptions = options2.havingBaseSizing();
    scale = scale / newOptions.sizeMultiplier;
    var angleHeight = inner2.height + inner2.depth + lineWeight + clearance;
    inner2.style.paddingLeft = makeEm(angleHeight / 2 + lineWeight);
    var viewBoxHeight = Math.floor(1e3 * angleHeight * scale);
    var path2 = phasePath(viewBoxHeight);
    var svgNode = new SvgNode([new PathNode("phase", path2)], {
      "width": "400em",
      "height": makeEm(viewBoxHeight / 1e3),
      "viewBox": "0 0 400000 " + viewBoxHeight,
      "preserveAspectRatio": "xMinYMin slice"
    });
    img = buildCommon.makeSvgSpan(["hide-tail"], [svgNode], options2);
    img.style.height = makeEm(angleHeight);
    imgShift = inner2.depth + lineWeight + clearance;
  } else {
    if (/cancel/.test(label2)) {
      if (!isSingleChar) {
        inner2.classes.push("cancel-pad");
      }
    } else if (label2 === "angl") {
      inner2.classes.push("anglpad");
    } else {
      inner2.classes.push("boxpad");
    }
    var topPad = 0;
    var bottomPad = 0;
    var ruleThickness = 0;
    if (/box/.test(label2)) {
      ruleThickness = Math.max(
        options2.fontMetrics().fboxrule,
        // default
        options2.minRuleThickness
        // User override.
      );
      topPad = options2.fontMetrics().fboxsep + (label2 === "colorbox" ? 0 : ruleThickness);
      bottomPad = topPad;
    } else if (label2 === "angl") {
      ruleThickness = Math.max(options2.fontMetrics().defaultRuleThickness, options2.minRuleThickness);
      topPad = 4 * ruleThickness;
      bottomPad = Math.max(0, 0.25 - inner2.depth);
    } else {
      topPad = isSingleChar ? 0.2 : 0;
      bottomPad = topPad;
    }
    img = stretchy.encloseSpan(inner2, label2, topPad, bottomPad, options2);
    if (/fbox|boxed|fcolorbox/.test(label2)) {
      img.style.borderStyle = "solid";
      img.style.borderWidth = makeEm(ruleThickness);
    } else if (label2 === "angl" && ruleThickness !== 0.049) {
      img.style.borderTopWidth = makeEm(ruleThickness);
      img.style.borderRightWidth = makeEm(ruleThickness);
    }
    imgShift = inner2.depth + bottomPad;
    if (group.backgroundColor) {
      img.style.backgroundColor = group.backgroundColor;
      if (group.borderColor) {
        img.style.borderColor = group.borderColor;
      }
    }
  }
  var vlist;
  if (group.backgroundColor) {
    vlist = buildCommon.makeVList({
      positionType: "individualShift",
      children: [
        // Put the color background behind inner;
        {
          type: "elem",
          elem: img,
          shift: imgShift
        },
        {
          type: "elem",
          elem: inner2,
          shift: 0
        }
      ]
    }, options2);
  } else {
    var classes = /cancel|phase/.test(label2) ? ["svg-align"] : [];
    vlist = buildCommon.makeVList({
      positionType: "individualShift",
      children: [
        // Write the \cancel stroke on top of inner.
        {
          type: "elem",
          elem: inner2,
          shift: 0
        },
        {
          type: "elem",
          elem: img,
          shift: imgShift,
          wrapperClasses: classes
        }
      ]
    }, options2);
  }
  if (/cancel/.test(label2)) {
    vlist.height = inner2.height;
    vlist.depth = inner2.depth;
  }
  if (/cancel/.test(label2) && !isSingleChar) {
    return buildCommon.makeSpan(["mord", "cancel-lap"], [vlist], options2);
  } else {
    return buildCommon.makeSpan(["mord"], [vlist], options2);
  }
};
var mathmlBuilder$6 = (group, options2) => {
  var fboxsep = 0;
  var node2 = new mathMLTree.MathNode(group.label.indexOf("colorbox") > -1 ? "mpadded" : "menclose", [buildGroup2(group.body, options2)]);
  switch (group.label) {
    case "\\cancel":
      node2.setAttribute("notation", "updiagonalstrike");
      break;
    case "\\bcancel":
      node2.setAttribute("notation", "downdiagonalstrike");
      break;
    case "\\phase":
      node2.setAttribute("notation", "phasorangle");
      break;
    case "\\sout":
      node2.setAttribute("notation", "horizontalstrike");
      break;
    case "\\fbox":
      node2.setAttribute("notation", "box");
      break;
    case "\\angl":
      node2.setAttribute("notation", "actuarial");
      break;
    case "\\fcolorbox":
    case "\\colorbox":
      fboxsep = options2.fontMetrics().fboxsep * options2.fontMetrics().ptPerEm;
      node2.setAttribute("width", "+" + 2 * fboxsep + "pt");
      node2.setAttribute("height", "+" + 2 * fboxsep + "pt");
      node2.setAttribute("lspace", fboxsep + "pt");
      node2.setAttribute("voffset", fboxsep + "pt");
      if (group.label === "\\fcolorbox") {
        var thk = Math.max(
          options2.fontMetrics().fboxrule,
          // default
          options2.minRuleThickness
          // user override
        );
        node2.setAttribute("style", "border: " + thk + "em solid " + String(group.borderColor));
      }
      break;
    case "\\xcancel":
      node2.setAttribute("notation", "updiagonalstrike downdiagonalstrike");
      break;
  }
  if (group.backgroundColor) {
    node2.setAttribute("mathbackground", group.backgroundColor);
  }
  return node2;
};
defineFunction({
  type: "enclose",
  names: ["\\colorbox"],
  props: {
    numArgs: 2,
    allowedInText: true,
    argTypes: ["color", "text"]
  },
  handler(_ref, args, optArgs) {
    var {
      parser,
      funcName
    } = _ref;
    var color = assertNodeType(args[0], "color-token").color;
    var body = args[1];
    return {
      type: "enclose",
      mode: parser.mode,
      label: funcName,
      backgroundColor: color,
      body
    };
  },
  htmlBuilder: htmlBuilder$7,
  mathmlBuilder: mathmlBuilder$6
});
defineFunction({
  type: "enclose",
  names: ["\\fcolorbox"],
  props: {
    numArgs: 3,
    allowedInText: true,
    argTypes: ["color", "color", "text"]
  },
  handler(_ref2, args, optArgs) {
    var {
      parser,
      funcName
    } = _ref2;
    var borderColor = assertNodeType(args[0], "color-token").color;
    var backgroundColor = assertNodeType(args[1], "color-token").color;
    var body = args[2];
    return {
      type: "enclose",
      mode: parser.mode,
      label: funcName,
      backgroundColor,
      borderColor,
      body
    };
  },
  htmlBuilder: htmlBuilder$7,
  mathmlBuilder: mathmlBuilder$6
});
defineFunction({
  type: "enclose",
  names: ["\\fbox"],
  props: {
    numArgs: 1,
    argTypes: ["hbox"],
    allowedInText: true
  },
  handler(_ref3, args) {
    var {
      parser
    } = _ref3;
    return {
      type: "enclose",
      mode: parser.mode,
      label: "\\fbox",
      body: args[0]
    };
  }
});
defineFunction({
  type: "enclose",
  names: ["\\cancel", "\\bcancel", "\\xcancel", "\\sout", "\\phase"],
  props: {
    numArgs: 1
  },
  handler(_ref4, args) {
    var {
      parser,
      funcName
    } = _ref4;
    var body = args[0];
    return {
      type: "enclose",
      mode: parser.mode,
      label: funcName,
      body
    };
  },
  htmlBuilder: htmlBuilder$7,
  mathmlBuilder: mathmlBuilder$6
});
defineFunction({
  type: "enclose",
  names: ["\\angl"],
  props: {
    numArgs: 1,
    argTypes: ["hbox"],
    allowedInText: false
  },
  handler(_ref5, args) {
    var {
      parser
    } = _ref5;
    return {
      type: "enclose",
      mode: parser.mode,
      label: "\\angl",
      body: args[0]
    };
  }
});
var _environments = {};
function defineEnvironment(_ref) {
  var {
    type,
    names,
    props,
    handler,
    htmlBuilder: htmlBuilder3,
    mathmlBuilder: mathmlBuilder3
  } = _ref;
  var data = {
    type,
    numArgs: props.numArgs || 0,
    allowedInText: false,
    numOptionalArgs: 0,
    handler
  };
  for (var i = 0; i < names.length; ++i) {
    _environments[names[i]] = data;
  }
  if (htmlBuilder3) {
    _htmlGroupBuilders[type] = htmlBuilder3;
  }
  if (mathmlBuilder3) {
    _mathmlGroupBuilders[type] = mathmlBuilder3;
  }
}
var _macros = {};
function defineMacro(name, body) {
  _macros[name] = body;
}
function getHLines(parser) {
  var hlineInfo = [];
  parser.consumeSpaces();
  var nxt = parser.fetch().text;
  if (nxt === "\\relax") {
    parser.consume();
    parser.consumeSpaces();
    nxt = parser.fetch().text;
  }
  while (nxt === "\\hline" || nxt === "\\hdashline") {
    parser.consume();
    hlineInfo.push(nxt === "\\hdashline");
    parser.consumeSpaces();
    nxt = parser.fetch().text;
  }
  return hlineInfo;
}
var validateAmsEnvironmentContext = (context) => {
  var settings = context.parser.settings;
  if (!settings.displayMode) {
    throw new ParseError("{" + context.envName + "} can be used only in display mode.");
  }
};
function getAutoTag(name) {
  if (name.indexOf("ed") === -1) {
    return name.indexOf("*") === -1;
  }
}
function parseArray(parser, _ref, style) {
  var {
    hskipBeforeAndAfter,
    addJot,
    cols,
    arraystretch,
    colSeparationType,
    autoTag,
    singleRow,
    emptySingleRow,
    maxNumCols,
    leqno
  } = _ref;
  parser.gullet.beginGroup();
  if (!singleRow) {
    parser.gullet.macros.set("\\cr", "\\\\\\relax");
  }
  if (!arraystretch) {
    var stretch = parser.gullet.expandMacroAsText("\\arraystretch");
    if (stretch == null) {
      arraystretch = 1;
    } else {
      arraystretch = parseFloat(stretch);
      if (!arraystretch || arraystretch < 0) {
        throw new ParseError("Invalid \\arraystretch: " + stretch);
      }
    }
  }
  parser.gullet.beginGroup();
  var row = [];
  var body = [row];
  var rowGaps = [];
  var hLinesBeforeRow = [];
  var tags = autoTag != null ? [] : void 0;
  function beginRow() {
    if (autoTag) {
      parser.gullet.macros.set("\\@eqnsw", "1", true);
    }
  }
  function endRow() {
    if (tags) {
      if (parser.gullet.macros.get("\\df@tag")) {
        tags.push(parser.subparse([new Token("\\df@tag")]));
        parser.gullet.macros.set("\\df@tag", void 0, true);
      } else {
        tags.push(Boolean(autoTag) && parser.gullet.macros.get("\\@eqnsw") === "1");
      }
    }
  }
  beginRow();
  hLinesBeforeRow.push(getHLines(parser));
  while (true) {
    var cell = parser.parseExpression(false, singleRow ? "\\end" : "\\\\");
    parser.gullet.endGroup();
    parser.gullet.beginGroup();
    cell = {
      type: "ordgroup",
      mode: parser.mode,
      body: cell
    };
    if (style) {
      cell = {
        type: "styling",
        mode: parser.mode,
        style,
        body: [cell]
      };
    }
    row.push(cell);
    var next = parser.fetch().text;
    if (next === "&") {
      if (maxNumCols && row.length === maxNumCols) {
        if (singleRow || colSeparationType) {
          throw new ParseError("Too many tab characters: &", parser.nextToken);
        } else {
          parser.settings.reportNonstrict("textEnv", "Too few columns specified in the {array} column argument.");
        }
      }
      parser.consume();
    } else if (next === "\\end") {
      endRow();
      if (row.length === 1 && cell.type === "styling" && cell.body[0].body.length === 0 && (body.length > 1 || !emptySingleRow)) {
        body.pop();
      }
      if (hLinesBeforeRow.length < body.length + 1) {
        hLinesBeforeRow.push([]);
      }
      break;
    } else if (next === "\\\\") {
      parser.consume();
      var size = void 0;
      if (parser.gullet.future().text !== " ") {
        size = parser.parseSizeGroup(true);
      }
      rowGaps.push(size ? size.value : null);
      endRow();
      hLinesBeforeRow.push(getHLines(parser));
      row = [];
      body.push(row);
      beginRow();
    } else {
      throw new ParseError("Expected & or \\\\ or \\cr or \\end", parser.nextToken);
    }
  }
  parser.gullet.endGroup();
  parser.gullet.endGroup();
  return {
    type: "array",
    mode: parser.mode,
    addJot,
    arraystretch,
    body,
    cols,
    rowGaps,
    hskipBeforeAndAfter,
    hLinesBeforeRow,
    colSeparationType,
    tags,
    leqno
  };
}
function dCellStyle(envName) {
  if (envName.slice(0, 1) === "d") {
    return "display";
  } else {
    return "text";
  }
}
var htmlBuilder$6 = function htmlBuilder(group, options2) {
  var r;
  var c;
  var nr = group.body.length;
  var hLinesBeforeRow = group.hLinesBeforeRow;
  var nc = 0;
  var body = new Array(nr);
  var hlines = [];
  var ruleThickness = Math.max(
    // From LaTeX \showthe\arrayrulewidth. Equals 0.04 em.
    options2.fontMetrics().arrayRuleWidth,
    options2.minRuleThickness
    // User override.
  );
  var pt2 = 1 / options2.fontMetrics().ptPerEm;
  var arraycolsep = 5 * pt2;
  if (group.colSeparationType && group.colSeparationType === "small") {
    var localMultiplier = options2.havingStyle(Style$1.SCRIPT).sizeMultiplier;
    arraycolsep = 0.2778 * (localMultiplier / options2.sizeMultiplier);
  }
  var baselineskip = group.colSeparationType === "CD" ? calculateSize({
    number: 3,
    unit: "ex"
  }, options2) : 12 * pt2;
  var jot = 3 * pt2;
  var arrayskip = group.arraystretch * baselineskip;
  var arstrutHeight = 0.7 * arrayskip;
  var arstrutDepth = 0.3 * arrayskip;
  var totalHeight = 0;
  function setHLinePos(hlinesInGap) {
    for (var i = 0; i < hlinesInGap.length; ++i) {
      if (i > 0) {
        totalHeight += 0.25;
      }
      hlines.push({
        pos: totalHeight,
        isDashed: hlinesInGap[i]
      });
    }
  }
  setHLinePos(hLinesBeforeRow[0]);
  for (r = 0; r < group.body.length; ++r) {
    var inrow = group.body[r];
    var height = arstrutHeight;
    var depth = arstrutDepth;
    if (nc < inrow.length) {
      nc = inrow.length;
    }
    var outrow = new Array(inrow.length);
    for (c = 0; c < inrow.length; ++c) {
      var elt = buildGroup$1(inrow[c], options2);
      if (depth < elt.depth) {
        depth = elt.depth;
      }
      if (height < elt.height) {
        height = elt.height;
      }
      outrow[c] = elt;
    }
    var rowGap = group.rowGaps[r];
    var gap = 0;
    if (rowGap) {
      gap = calculateSize(rowGap, options2);
      if (gap > 0) {
        gap += arstrutDepth;
        if (depth < gap) {
          depth = gap;
        }
        gap = 0;
      }
    }
    if (group.addJot) {
      depth += jot;
    }
    outrow.height = height;
    outrow.depth = depth;
    totalHeight += height;
    outrow.pos = totalHeight;
    totalHeight += depth + gap;
    body[r] = outrow;
    setHLinePos(hLinesBeforeRow[r + 1]);
  }
  var offset = totalHeight / 2 + options2.fontMetrics().axisHeight;
  var colDescriptions = group.cols || [];
  var cols = [];
  var colSep;
  var colDescrNum;
  var tagSpans = [];
  if (group.tags && group.tags.some((tag3) => tag3)) {
    for (r = 0; r < nr; ++r) {
      var rw = body[r];
      var shift = rw.pos - offset;
      var tag2 = group.tags[r];
      var tagSpan = void 0;
      if (tag2 === true) {
        tagSpan = buildCommon.makeSpan(["eqn-num"], [], options2);
      } else if (tag2 === false) {
        tagSpan = buildCommon.makeSpan([], [], options2);
      } else {
        tagSpan = buildCommon.makeSpan([], buildExpression$1(tag2, options2, true), options2);
      }
      tagSpan.depth = rw.depth;
      tagSpan.height = rw.height;
      tagSpans.push({
        type: "elem",
        elem: tagSpan,
        shift
      });
    }
  }
  for (
    c = 0, colDescrNum = 0;
    // Continue while either there are more columns or more column
    // descriptions, so trailing separators don't get lost.
    c < nc || colDescrNum < colDescriptions.length;
    ++c, ++colDescrNum
  ) {
    var colDescr = colDescriptions[colDescrNum] || {};
    var firstSeparator = true;
    while (colDescr.type === "separator") {
      if (!firstSeparator) {
        colSep = buildCommon.makeSpan(["arraycolsep"], []);
        colSep.style.width = makeEm(options2.fontMetrics().doubleRuleSep);
        cols.push(colSep);
      }
      if (colDescr.separator === "|" || colDescr.separator === ":") {
        var lineType = colDescr.separator === "|" ? "solid" : "dashed";
        var separator = buildCommon.makeSpan(["vertical-separator"], [], options2);
        separator.style.height = makeEm(totalHeight);
        separator.style.borderRightWidth = makeEm(ruleThickness);
        separator.style.borderRightStyle = lineType;
        separator.style.margin = "0 " + makeEm(-ruleThickness / 2);
        var _shift = totalHeight - offset;
        if (_shift) {
          separator.style.verticalAlign = makeEm(-_shift);
        }
        cols.push(separator);
      } else {
        throw new ParseError("Invalid separator type: " + colDescr.separator);
      }
      colDescrNum++;
      colDescr = colDescriptions[colDescrNum] || {};
      firstSeparator = false;
    }
    if (c >= nc) {
      continue;
    }
    var sepwidth = void 0;
    if (c > 0 || group.hskipBeforeAndAfter) {
      sepwidth = utils.deflt(colDescr.pregap, arraycolsep);
      if (sepwidth !== 0) {
        colSep = buildCommon.makeSpan(["arraycolsep"], []);
        colSep.style.width = makeEm(sepwidth);
        cols.push(colSep);
      }
    }
    var col = [];
    for (r = 0; r < nr; ++r) {
      var row = body[r];
      var elem = row[c];
      if (!elem) {
        continue;
      }
      var _shift2 = row.pos - offset;
      elem.depth = row.depth;
      elem.height = row.height;
      col.push({
        type: "elem",
        elem,
        shift: _shift2
      });
    }
    col = buildCommon.makeVList({
      positionType: "individualShift",
      children: col
    }, options2);
    col = buildCommon.makeSpan(["col-align-" + (colDescr.align || "c")], [col]);
    cols.push(col);
    if (c < nc - 1 || group.hskipBeforeAndAfter) {
      sepwidth = utils.deflt(colDescr.postgap, arraycolsep);
      if (sepwidth !== 0) {
        colSep = buildCommon.makeSpan(["arraycolsep"], []);
        colSep.style.width = makeEm(sepwidth);
        cols.push(colSep);
      }
    }
  }
  body = buildCommon.makeSpan(["mtable"], cols);
  if (hlines.length > 0) {
    var line = buildCommon.makeLineSpan("hline", options2, ruleThickness);
    var dashes = buildCommon.makeLineSpan("hdashline", options2, ruleThickness);
    var vListElems = [{
      type: "elem",
      elem: body,
      shift: 0
    }];
    while (hlines.length > 0) {
      var hline = hlines.pop();
      var lineShift = hline.pos - offset;
      if (hline.isDashed) {
        vListElems.push({
          type: "elem",
          elem: dashes,
          shift: lineShift
        });
      } else {
        vListElems.push({
          type: "elem",
          elem: line,
          shift: lineShift
        });
      }
    }
    body = buildCommon.makeVList({
      positionType: "individualShift",
      children: vListElems
    }, options2);
  }
  if (tagSpans.length === 0) {
    return buildCommon.makeSpan(["mord"], [body], options2);
  } else {
    var eqnNumCol = buildCommon.makeVList({
      positionType: "individualShift",
      children: tagSpans
    }, options2);
    eqnNumCol = buildCommon.makeSpan(["tag"], [eqnNumCol], options2);
    return buildCommon.makeFragment([body, eqnNumCol]);
  }
};
var alignMap = {
  c: "center ",
  l: "left ",
  r: "right "
};
var mathmlBuilder$5 = function mathmlBuilder(group, options2) {
  var tbl = [];
  var glue = new mathMLTree.MathNode("mtd", [], ["mtr-glue"]);
  var tag2 = new mathMLTree.MathNode("mtd", [], ["mml-eqn-num"]);
  for (var i = 0; i < group.body.length; i++) {
    var rw = group.body[i];
    var row = [];
    for (var j = 0; j < rw.length; j++) {
      row.push(new mathMLTree.MathNode("mtd", [buildGroup2(rw[j], options2)]));
    }
    if (group.tags && group.tags[i]) {
      row.unshift(glue);
      row.push(glue);
      if (group.leqno) {
        row.unshift(tag2);
      } else {
        row.push(tag2);
      }
    }
    tbl.push(new mathMLTree.MathNode("mtr", row));
  }
  var table = new mathMLTree.MathNode("mtable", tbl);
  var gap = group.arraystretch === 0.5 ? 0.1 : 0.16 + group.arraystretch - 1 + (group.addJot ? 0.09 : 0);
  table.setAttribute("rowspacing", makeEm(gap));
  var menclose = "";
  var align = "";
  if (group.cols && group.cols.length > 0) {
    var cols = group.cols;
    var columnLines = "";
    var prevTypeWasAlign = false;
    var iStart = 0;
    var iEnd = cols.length;
    if (cols[0].type === "separator") {
      menclose += "top ";
      iStart = 1;
    }
    if (cols[cols.length - 1].type === "separator") {
      menclose += "bottom ";
      iEnd -= 1;
    }
    for (var _i = iStart; _i < iEnd; _i++) {
      if (cols[_i].type === "align") {
        align += alignMap[cols[_i].align];
        if (prevTypeWasAlign) {
          columnLines += "none ";
        }
        prevTypeWasAlign = true;
      } else if (cols[_i].type === "separator") {
        if (prevTypeWasAlign) {
          columnLines += cols[_i].separator === "|" ? "solid " : "dashed ";
          prevTypeWasAlign = false;
        }
      }
    }
    table.setAttribute("columnalign", align.trim());
    if (/[sd]/.test(columnLines)) {
      table.setAttribute("columnlines", columnLines.trim());
    }
  }
  if (group.colSeparationType === "align") {
    var _cols = group.cols || [];
    var spacing2 = "";
    for (var _i2 = 1; _i2 < _cols.length; _i2++) {
      spacing2 += _i2 % 2 ? "0em " : "1em ";
    }
    table.setAttribute("columnspacing", spacing2.trim());
  } else if (group.colSeparationType === "alignat" || group.colSeparationType === "gather") {
    table.setAttribute("columnspacing", "0em");
  } else if (group.colSeparationType === "small") {
    table.setAttribute("columnspacing", "0.2778em");
  } else if (group.colSeparationType === "CD") {
    table.setAttribute("columnspacing", "0.5em");
  } else {
    table.setAttribute("columnspacing", "1em");
  }
  var rowLines = "";
  var hlines = group.hLinesBeforeRow;
  menclose += hlines[0].length > 0 ? "left " : "";
  menclose += hlines[hlines.length - 1].length > 0 ? "right " : "";
  for (var _i3 = 1; _i3 < hlines.length - 1; _i3++) {
    rowLines += hlines[_i3].length === 0 ? "none " : hlines[_i3][0] ? "dashed " : "solid ";
  }
  if (/[sd]/.test(rowLines)) {
    table.setAttribute("rowlines", rowLines.trim());
  }
  if (menclose !== "") {
    table = new mathMLTree.MathNode("menclose", [table]);
    table.setAttribute("notation", menclose.trim());
  }
  if (group.arraystretch && group.arraystretch < 1) {
    table = new mathMLTree.MathNode("mstyle", [table]);
    table.setAttribute("scriptlevel", "1");
  }
  return table;
};
var alignedHandler = function alignedHandler2(context, args) {
  if (context.envName.indexOf("ed") === -1) {
    validateAmsEnvironmentContext(context);
  }
  var cols = [];
  var separationType = context.envName.indexOf("at") > -1 ? "alignat" : "align";
  var isSplit = context.envName === "split";
  var res = parseArray(context.parser, {
    cols,
    addJot: true,
    autoTag: isSplit ? void 0 : getAutoTag(context.envName),
    emptySingleRow: true,
    colSeparationType: separationType,
    maxNumCols: isSplit ? 2 : void 0,
    leqno: context.parser.settings.leqno
  }, "display");
  var numMaths;
  var numCols = 0;
  var emptyGroup = {
    type: "ordgroup",
    mode: context.mode,
    body: []
  };
  if (args[0] && args[0].type === "ordgroup") {
    var arg0 = "";
    for (var i = 0; i < args[0].body.length; i++) {
      var textord2 = assertNodeType(args[0].body[i], "textord");
      arg0 += textord2.text;
    }
    numMaths = Number(arg0);
    numCols = numMaths * 2;
  }
  var isAligned = !numCols;
  res.body.forEach(function(row) {
    for (var _i4 = 1; _i4 < row.length; _i4 += 2) {
      var styling = assertNodeType(row[_i4], "styling");
      var ordgroup = assertNodeType(styling.body[0], "ordgroup");
      ordgroup.body.unshift(emptyGroup);
    }
    if (!isAligned) {
      var curMaths = row.length / 2;
      if (numMaths < curMaths) {
        throw new ParseError("Too many math in a row: " + ("expected " + numMaths + ", but got " + curMaths), row[0]);
      }
    } else if (numCols < row.length) {
      numCols = row.length;
    }
  });
  for (var _i5 = 0; _i5 < numCols; ++_i5) {
    var align = "r";
    var pregap = 0;
    if (_i5 % 2 === 1) {
      align = "l";
    } else if (_i5 > 0 && isAligned) {
      pregap = 1;
    }
    cols[_i5] = {
      type: "align",
      align,
      pregap,
      postgap: 0
    };
  }
  res.colSeparationType = isAligned ? "align" : "alignat";
  return res;
};
defineEnvironment({
  type: "array",
  names: ["array", "darray"],
  props: {
    numArgs: 1
  },
  handler(context, args) {
    var symNode = checkSymbolNodeType(args[0]);
    var colalign = symNode ? [args[0]] : assertNodeType(args[0], "ordgroup").body;
    var cols = colalign.map(function(nde) {
      var node2 = assertSymbolNodeType(nde);
      var ca2 = node2.text;
      if ("lcr".indexOf(ca2) !== -1) {
        return {
          type: "align",
          align: ca2
        };
      } else if (ca2 === "|") {
        return {
          type: "separator",
          separator: "|"
        };
      } else if (ca2 === ":") {
        return {
          type: "separator",
          separator: ":"
        };
      }
      throw new ParseError("Unknown column alignment: " + ca2, nde);
    });
    var res = {
      cols,
      hskipBeforeAndAfter: true,
      // \@preamble in lttab.dtx
      maxNumCols: cols.length
    };
    return parseArray(context.parser, res, dCellStyle(context.envName));
  },
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["matrix", "pmatrix", "bmatrix", "Bmatrix", "vmatrix", "Vmatrix", "matrix*", "pmatrix*", "bmatrix*", "Bmatrix*", "vmatrix*", "Vmatrix*"],
  props: {
    numArgs: 0
  },
  handler(context) {
    var delimiters2 = {
      "matrix": null,
      "pmatrix": ["(", ")"],
      "bmatrix": ["[", "]"],
      "Bmatrix": ["\\{", "\\}"],
      "vmatrix": ["|", "|"],
      "Vmatrix": ["\\Vert", "\\Vert"]
    }[context.envName.replace("*", "")];
    var colAlign = "c";
    var payload = {
      hskipBeforeAndAfter: false,
      cols: [{
        type: "align",
        align: colAlign
      }]
    };
    if (context.envName.charAt(context.envName.length - 1) === "*") {
      var parser = context.parser;
      parser.consumeSpaces();
      if (parser.fetch().text === "[") {
        parser.consume();
        parser.consumeSpaces();
        colAlign = parser.fetch().text;
        if ("lcr".indexOf(colAlign) === -1) {
          throw new ParseError("Expected l or c or r", parser.nextToken);
        }
        parser.consume();
        parser.consumeSpaces();
        parser.expect("]");
        parser.consume();
        payload.cols = [{
          type: "align",
          align: colAlign
        }];
      }
    }
    var res = parseArray(context.parser, payload, dCellStyle(context.envName));
    var numCols = Math.max(0, ...res.body.map((row) => row.length));
    res.cols = new Array(numCols).fill({
      type: "align",
      align: colAlign
    });
    return delimiters2 ? {
      type: "leftright",
      mode: context.mode,
      body: [res],
      left: delimiters2[0],
      right: delimiters2[1],
      rightColor: void 0
      // \right uninfluenced by \color in array
    } : res;
  },
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["smallmatrix"],
  props: {
    numArgs: 0
  },
  handler(context) {
    var payload = {
      arraystretch: 0.5
    };
    var res = parseArray(context.parser, payload, "script");
    res.colSeparationType = "small";
    return res;
  },
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["subarray"],
  props: {
    numArgs: 1
  },
  handler(context, args) {
    var symNode = checkSymbolNodeType(args[0]);
    var colalign = symNode ? [args[0]] : assertNodeType(args[0], "ordgroup").body;
    var cols = colalign.map(function(nde) {
      var node2 = assertSymbolNodeType(nde);
      var ca2 = node2.text;
      if ("lc".indexOf(ca2) !== -1) {
        return {
          type: "align",
          align: ca2
        };
      }
      throw new ParseError("Unknown column alignment: " + ca2, nde);
    });
    if (cols.length > 1) {
      throw new ParseError("{subarray} can contain only one column");
    }
    var res = {
      cols,
      hskipBeforeAndAfter: false,
      arraystretch: 0.5
    };
    res = parseArray(context.parser, res, "script");
    if (res.body.length > 0 && res.body[0].length > 1) {
      throw new ParseError("{subarray} can contain only one column");
    }
    return res;
  },
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["cases", "dcases", "rcases", "drcases"],
  props: {
    numArgs: 0
  },
  handler(context) {
    var payload = {
      arraystretch: 1.2,
      cols: [{
        type: "align",
        align: "l",
        pregap: 0,
        // TODO(kevinb) get the current style.
        // For now we use the metrics for TEXT style which is what we were
        // doing before.  Before attempting to get the current style we
        // should look at TeX's behavior especially for \over and matrices.
        postgap: 1
        /* 1em quad */
      }, {
        type: "align",
        align: "l",
        pregap: 0,
        postgap: 0
      }]
    };
    var res = parseArray(context.parser, payload, dCellStyle(context.envName));
    return {
      type: "leftright",
      mode: context.mode,
      body: [res],
      left: context.envName.indexOf("r") > -1 ? "." : "\\{",
      right: context.envName.indexOf("r") > -1 ? "\\}" : ".",
      rightColor: void 0
    };
  },
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["align", "align*", "aligned", "split"],
  props: {
    numArgs: 0
  },
  handler: alignedHandler,
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["gathered", "gather", "gather*"],
  props: {
    numArgs: 0
  },
  handler(context) {
    if (utils.contains(["gather", "gather*"], context.envName)) {
      validateAmsEnvironmentContext(context);
    }
    var res = {
      cols: [{
        type: "align",
        align: "c"
      }],
      addJot: true,
      colSeparationType: "gather",
      autoTag: getAutoTag(context.envName),
      emptySingleRow: true,
      leqno: context.parser.settings.leqno
    };
    return parseArray(context.parser, res, "display");
  },
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["alignat", "alignat*", "alignedat"],
  props: {
    numArgs: 1
  },
  handler: alignedHandler,
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["equation", "equation*"],
  props: {
    numArgs: 0
  },
  handler(context) {
    validateAmsEnvironmentContext(context);
    var res = {
      autoTag: getAutoTag(context.envName),
      emptySingleRow: true,
      singleRow: true,
      maxNumCols: 1,
      leqno: context.parser.settings.leqno
    };
    return parseArray(context.parser, res, "display");
  },
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineEnvironment({
  type: "array",
  names: ["CD"],
  props: {
    numArgs: 0
  },
  handler(context) {
    validateAmsEnvironmentContext(context);
    return parseCD(context.parser);
  },
  htmlBuilder: htmlBuilder$6,
  mathmlBuilder: mathmlBuilder$5
});
defineMacro("\\nonumber", "\\gdef\\@eqnsw{0}");
defineMacro("\\notag", "\\nonumber");
defineFunction({
  type: "text",
  // Doesn't matter what this is.
  names: ["\\hline", "\\hdashline"],
  props: {
    numArgs: 0,
    allowedInText: true,
    allowedInMath: true
  },
  handler(context, args) {
    throw new ParseError(context.funcName + " valid only within array environment");
  }
});
var environments = _environments;
defineFunction({
  type: "environment",
  names: ["\\begin", "\\end"],
  props: {
    numArgs: 1,
    argTypes: ["text"]
  },
  handler(_ref, args) {
    var {
      parser,
      funcName
    } = _ref;
    var nameGroup = args[0];
    if (nameGroup.type !== "ordgroup") {
      throw new ParseError("Invalid environment name", nameGroup);
    }
    var envName = "";
    for (var i = 0; i < nameGroup.body.length; ++i) {
      envName += assertNodeType(nameGroup.body[i], "textord").text;
    }
    if (funcName === "\\begin") {
      if (!environments.hasOwnProperty(envName)) {
        throw new ParseError("No such environment: " + envName, nameGroup);
      }
      var env = environments[envName];
      var {
        args: _args,
        optArgs
      } = parser.parseArguments("\\begin{" + envName + "}", env);
      var context = {
        mode: parser.mode,
        envName,
        parser
      };
      var result = env.handler(context, _args, optArgs);
      parser.expect("\\end", false);
      var endNameToken = parser.nextToken;
      var end = assertNodeType(parser.parseFunction(), "environment");
      if (end.name !== envName) {
        throw new ParseError("Mismatch: \\begin{" + envName + "} matched by \\end{" + end.name + "}", endNameToken);
      }
      return result;
    }
    return {
      type: "environment",
      mode: parser.mode,
      name: envName,
      nameGroup
    };
  }
});
var htmlBuilder$5 = (group, options2) => {
  var font = group.font;
  var newOptions = options2.withFont(font);
  return buildGroup$1(group.body, newOptions);
};
var mathmlBuilder$4 = (group, options2) => {
  var font = group.font;
  var newOptions = options2.withFont(font);
  return buildGroup2(group.body, newOptions);
};
var fontAliases = {
  "\\Bbb": "\\mathbb",
  "\\bold": "\\mathbf",
  "\\frak": "\\mathfrak",
  "\\bm": "\\boldsymbol"
};
defineFunction({
  type: "font",
  names: [
    // styles, except \boldsymbol defined below
    "\\mathrm",
    "\\mathit",
    "\\mathbf",
    "\\mathnormal",
    // families
    "\\mathbb",
    "\\mathcal",
    "\\mathfrak",
    "\\mathscr",
    "\\mathsf",
    "\\mathtt",
    // aliases, except \bm defined below
    "\\Bbb",
    "\\bold",
    "\\frak"
  ],
  props: {
    numArgs: 1,
    allowedInArgument: true
  },
  handler: (_ref, args) => {
    var {
      parser,
      funcName
    } = _ref;
    var body = normalizeArgument(args[0]);
    var func = funcName;
    if (func in fontAliases) {
      func = fontAliases[func];
    }
    return {
      type: "font",
      mode: parser.mode,
      font: func.slice(1),
      body
    };
  },
  htmlBuilder: htmlBuilder$5,
  mathmlBuilder: mathmlBuilder$4
});
defineFunction({
  type: "mclass",
  names: ["\\boldsymbol", "\\bm"],
  props: {
    numArgs: 1
  },
  handler: (_ref2, args) => {
    var {
      parser
    } = _ref2;
    var body = args[0];
    var isCharacterBox3 = utils.isCharacterBox(body);
    return {
      type: "mclass",
      mode: parser.mode,
      mclass: binrelClass(body),
      body: [{
        type: "font",
        mode: parser.mode,
        font: "boldsymbol",
        body
      }],
      isCharacterBox: isCharacterBox3
    };
  }
});
defineFunction({
  type: "font",
  names: ["\\rm", "\\sf", "\\tt", "\\bf", "\\it", "\\cal"],
  props: {
    numArgs: 0,
    allowedInText: true
  },
  handler: (_ref3, args) => {
    var {
      parser,
      funcName,
      breakOnTokenText
    } = _ref3;
    var {
      mode
    } = parser;
    var body = parser.parseExpression(true, breakOnTokenText);
    var style = "math" + funcName.slice(1);
    return {
      type: "font",
      mode,
      font: style,
      body: {
        type: "ordgroup",
        mode: parser.mode,
        body
      }
    };
  },
  htmlBuilder: htmlBuilder$5,
  mathmlBuilder: mathmlBuilder$4
});
var adjustStyle = (size, originalStyle) => {
  var style = originalStyle;
  if (size === "display") {
    style = style.id >= Style$1.SCRIPT.id ? style.text() : Style$1.DISPLAY;
  } else if (size === "text" && style.size === Style$1.DISPLAY.size) {
    style = Style$1.TEXT;
  } else if (size === "script") {
    style = Style$1.SCRIPT;
  } else if (size === "scriptscript") {
    style = Style$1.SCRIPTSCRIPT;
  }
  return style;
};
var htmlBuilder$4 = (group, options2) => {
  var style = adjustStyle(group.size, options2.style);
  var nstyle = style.fracNum();
  var dstyle = style.fracDen();
  var newOptions;
  newOptions = options2.havingStyle(nstyle);
  var numerm = buildGroup$1(group.numer, newOptions, options2);
  if (group.continued) {
    var hStrut = 8.5 / options2.fontMetrics().ptPerEm;
    var dStrut = 3.5 / options2.fontMetrics().ptPerEm;
    numerm.height = numerm.height < hStrut ? hStrut : numerm.height;
    numerm.depth = numerm.depth < dStrut ? dStrut : numerm.depth;
  }
  newOptions = options2.havingStyle(dstyle);
  var denomm = buildGroup$1(group.denom, newOptions, options2);
  var rule;
  var ruleWidth;
  var ruleSpacing;
  if (group.hasBarLine) {
    if (group.barSize) {
      ruleWidth = calculateSize(group.barSize, options2);
      rule = buildCommon.makeLineSpan("frac-line", options2, ruleWidth);
    } else {
      rule = buildCommon.makeLineSpan("frac-line", options2);
    }
    ruleWidth = rule.height;
    ruleSpacing = rule.height;
  } else {
    rule = null;
    ruleWidth = 0;
    ruleSpacing = options2.fontMetrics().defaultRuleThickness;
  }
  var numShift;
  var clearance;
  var denomShift;
  if (style.size === Style$1.DISPLAY.size || group.size === "display") {
    numShift = options2.fontMetrics().num1;
    if (ruleWidth > 0) {
      clearance = 3 * ruleSpacing;
    } else {
      clearance = 7 * ruleSpacing;
    }
    denomShift = options2.fontMetrics().denom1;
  } else {
    if (ruleWidth > 0) {
      numShift = options2.fontMetrics().num2;
      clearance = ruleSpacing;
    } else {
      numShift = options2.fontMetrics().num3;
      clearance = 3 * ruleSpacing;
    }
    denomShift = options2.fontMetrics().denom2;
  }
  var frac;
  if (!rule) {
    var candidateClearance = numShift - numerm.depth - (denomm.height - denomShift);
    if (candidateClearance < clearance) {
      numShift += 0.5 * (clearance - candidateClearance);
      denomShift += 0.5 * (clearance - candidateClearance);
    }
    frac = buildCommon.makeVList({
      positionType: "individualShift",
      children: [{
        type: "elem",
        elem: denomm,
        shift: denomShift
      }, {
        type: "elem",
        elem: numerm,
        shift: -numShift
      }]
    }, options2);
  } else {
    var axisHeight = options2.fontMetrics().axisHeight;
    if (numShift - numerm.depth - (axisHeight + 0.5 * ruleWidth) < clearance) {
      numShift += clearance - (numShift - numerm.depth - (axisHeight + 0.5 * ruleWidth));
    }
    if (axisHeight - 0.5 * ruleWidth - (denomm.height - denomShift) < clearance) {
      denomShift += clearance - (axisHeight - 0.5 * ruleWidth - (denomm.height - denomShift));
    }
    var midShift = -(axisHeight - 0.5 * ruleWidth);
    frac = buildCommon.makeVList({
      positionType: "individualShift",
      children: [{
        type: "elem",
        elem: denomm,
        shift: denomShift
      }, {
        type: "elem",
        elem: rule,
        shift: midShift
      }, {
        type: "elem",
        elem: numerm,
        shift: -numShift
      }]
    }, options2);
  }
  newOptions = options2.havingStyle(style);
  frac.height *= newOptions.sizeMultiplier / options2.sizeMultiplier;
  frac.depth *= newOptions.sizeMultiplier / options2.sizeMultiplier;
  var delimSize;
  if (style.size === Style$1.DISPLAY.size) {
    delimSize = options2.fontMetrics().delim1;
  } else if (style.size === Style$1.SCRIPTSCRIPT.size) {
    delimSize = options2.havingStyle(Style$1.SCRIPT).fontMetrics().delim2;
  } else {
    delimSize = options2.fontMetrics().delim2;
  }
  var leftDelim;
  var rightDelim;
  if (group.leftDelim == null) {
    leftDelim = makeNullDelimiter(options2, ["mopen"]);
  } else {
    leftDelim = delimiter.customSizedDelim(group.leftDelim, delimSize, true, options2.havingStyle(style), group.mode, ["mopen"]);
  }
  if (group.continued) {
    rightDelim = buildCommon.makeSpan([]);
  } else if (group.rightDelim == null) {
    rightDelim = makeNullDelimiter(options2, ["mclose"]);
  } else {
    rightDelim = delimiter.customSizedDelim(group.rightDelim, delimSize, true, options2.havingStyle(style), group.mode, ["mclose"]);
  }
  return buildCommon.makeSpan(["mord"].concat(newOptions.sizingClasses(options2)), [leftDelim, buildCommon.makeSpan(["mfrac"], [frac]), rightDelim], options2);
};
var mathmlBuilder$3 = (group, options2) => {
  var node2 = new mathMLTree.MathNode("mfrac", [buildGroup2(group.numer, options2), buildGroup2(group.denom, options2)]);
  if (!group.hasBarLine) {
    node2.setAttribute("linethickness", "0px");
  } else if (group.barSize) {
    var ruleWidth = calculateSize(group.barSize, options2);
    node2.setAttribute("linethickness", makeEm(ruleWidth));
  }
  var style = adjustStyle(group.size, options2.style);
  if (style.size !== options2.style.size) {
    node2 = new mathMLTree.MathNode("mstyle", [node2]);
    var isDisplay = style.size === Style$1.DISPLAY.size ? "true" : "false";
    node2.setAttribute("displaystyle", isDisplay);
    node2.setAttribute("scriptlevel", "0");
  }
  if (group.leftDelim != null || group.rightDelim != null) {
    var withDelims = [];
    if (group.leftDelim != null) {
      var leftOp = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode(group.leftDelim.replace("\\", ""))]);
      leftOp.setAttribute("fence", "true");
      withDelims.push(leftOp);
    }
    withDelims.push(node2);
    if (group.rightDelim != null) {
      var rightOp = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode(group.rightDelim.replace("\\", ""))]);
      rightOp.setAttribute("fence", "true");
      withDelims.push(rightOp);
    }
    return makeRow(withDelims);
  }
  return node2;
};
defineFunction({
  type: "genfrac",
  names: [
    "\\dfrac",
    "\\frac",
    "\\tfrac",
    "\\dbinom",
    "\\binom",
    "\\tbinom",
    "\\\\atopfrac",
    // can’t be entered directly
    "\\\\bracefrac",
    "\\\\brackfrac"
    // ditto
  ],
  props: {
    numArgs: 2,
    allowedInArgument: true
  },
  handler: (_ref, args) => {
    var {
      parser,
      funcName
    } = _ref;
    var numer = args[0];
    var denom = args[1];
    var hasBarLine;
    var leftDelim = null;
    var rightDelim = null;
    var size = "auto";
    switch (funcName) {
      case "\\dfrac":
      case "\\frac":
      case "\\tfrac":
        hasBarLine = true;
        break;
      case "\\\\atopfrac":
        hasBarLine = false;
        break;
      case "\\dbinom":
      case "\\binom":
      case "\\tbinom":
        hasBarLine = false;
        leftDelim = "(";
        rightDelim = ")";
        break;
      case "\\\\bracefrac":
        hasBarLine = false;
        leftDelim = "\\{";
        rightDelim = "\\}";
        break;
      case "\\\\brackfrac":
        hasBarLine = false;
        leftDelim = "[";
        rightDelim = "]";
        break;
      default:
        throw new Error("Unrecognized genfrac command");
    }
    switch (funcName) {
      case "\\dfrac":
      case "\\dbinom":
        size = "display";
        break;
      case "\\tfrac":
      case "\\tbinom":
        size = "text";
        break;
    }
    return {
      type: "genfrac",
      mode: parser.mode,
      continued: false,
      numer,
      denom,
      hasBarLine,
      leftDelim,
      rightDelim,
      size,
      barSize: null
    };
  },
  htmlBuilder: htmlBuilder$4,
  mathmlBuilder: mathmlBuilder$3
});
defineFunction({
  type: "genfrac",
  names: ["\\cfrac"],
  props: {
    numArgs: 2
  },
  handler: (_ref2, args) => {
    var {
      parser,
      funcName
    } = _ref2;
    var numer = args[0];
    var denom = args[1];
    return {
      type: "genfrac",
      mode: parser.mode,
      continued: true,
      numer,
      denom,
      hasBarLine: true,
      leftDelim: null,
      rightDelim: null,
      size: "display",
      barSize: null
    };
  }
});
defineFunction({
  type: "infix",
  names: ["\\over", "\\choose", "\\atop", "\\brace", "\\brack"],
  props: {
    numArgs: 0,
    infix: true
  },
  handler(_ref3) {
    var {
      parser,
      funcName,
      token
    } = _ref3;
    var replaceWith;
    switch (funcName) {
      case "\\over":
        replaceWith = "\\frac";
        break;
      case "\\choose":
        replaceWith = "\\binom";
        break;
      case "\\atop":
        replaceWith = "\\\\atopfrac";
        break;
      case "\\brace":
        replaceWith = "\\\\bracefrac";
        break;
      case "\\brack":
        replaceWith = "\\\\brackfrac";
        break;
      default:
        throw new Error("Unrecognized infix genfrac command");
    }
    return {
      type: "infix",
      mode: parser.mode,
      replaceWith,
      token
    };
  }
});
var stylArray = ["display", "text", "script", "scriptscript"];
var delimFromValue = function delimFromValue2(delimString) {
  var delim = null;
  if (delimString.length > 0) {
    delim = delimString;
    delim = delim === "." ? null : delim;
  }
  return delim;
};
defineFunction({
  type: "genfrac",
  names: ["\\genfrac"],
  props: {
    numArgs: 6,
    allowedInArgument: true,
    argTypes: ["math", "math", "size", "text", "math", "math"]
  },
  handler(_ref4, args) {
    var {
      parser
    } = _ref4;
    var numer = args[4];
    var denom = args[5];
    var leftNode = normalizeArgument(args[0]);
    var leftDelim = leftNode.type === "atom" && leftNode.family === "open" ? delimFromValue(leftNode.text) : null;
    var rightNode = normalizeArgument(args[1]);
    var rightDelim = rightNode.type === "atom" && rightNode.family === "close" ? delimFromValue(rightNode.text) : null;
    var barNode = assertNodeType(args[2], "size");
    var hasBarLine;
    var barSize = null;
    if (barNode.isBlank) {
      hasBarLine = true;
    } else {
      barSize = barNode.value;
      hasBarLine = barSize.number > 0;
    }
    var size = "auto";
    var styl = args[3];
    if (styl.type === "ordgroup") {
      if (styl.body.length > 0) {
        var textOrd = assertNodeType(styl.body[0], "textord");
        size = stylArray[Number(textOrd.text)];
      }
    } else {
      styl = assertNodeType(styl, "textord");
      size = stylArray[Number(styl.text)];
    }
    return {
      type: "genfrac",
      mode: parser.mode,
      numer,
      denom,
      continued: false,
      hasBarLine,
      barSize,
      leftDelim,
      rightDelim,
      size
    };
  },
  htmlBuilder: htmlBuilder$4,
  mathmlBuilder: mathmlBuilder$3
});
defineFunction({
  type: "infix",
  names: ["\\above"],
  props: {
    numArgs: 1,
    argTypes: ["size"],
    infix: true
  },
  handler(_ref5, args) {
    var {
      parser,
      funcName,
      token
    } = _ref5;
    return {
      type: "infix",
      mode: parser.mode,
      replaceWith: "\\\\abovefrac",
      size: assertNodeType(args[0], "size").value,
      token
    };
  }
});
defineFunction({
  type: "genfrac",
  names: ["\\\\abovefrac"],
  props: {
    numArgs: 3,
    argTypes: ["math", "size", "math"]
  },
  handler: (_ref6, args) => {
    var {
      parser,
      funcName
    } = _ref6;
    var numer = args[0];
    var barSize = assert(assertNodeType(args[1], "infix").size);
    var denom = args[2];
    var hasBarLine = barSize.number > 0;
    return {
      type: "genfrac",
      mode: parser.mode,
      numer,
      denom,
      continued: false,
      hasBarLine,
      barSize,
      leftDelim: null,
      rightDelim: null,
      size: "auto"
    };
  },
  htmlBuilder: htmlBuilder$4,
  mathmlBuilder: mathmlBuilder$3
});
var htmlBuilder$3 = (grp, options2) => {
  var style = options2.style;
  var supSubGroup;
  var group;
  if (grp.type === "supsub") {
    supSubGroup = grp.sup ? buildGroup$1(grp.sup, options2.havingStyle(style.sup()), options2) : buildGroup$1(grp.sub, options2.havingStyle(style.sub()), options2);
    group = assertNodeType(grp.base, "horizBrace");
  } else {
    group = assertNodeType(grp, "horizBrace");
  }
  var body = buildGroup$1(group.base, options2.havingBaseStyle(Style$1.DISPLAY));
  var braceBody = stretchy.svgSpan(group, options2);
  var vlist;
  if (group.isOver) {
    vlist = buildCommon.makeVList({
      positionType: "firstBaseline",
      children: [{
        type: "elem",
        elem: body
      }, {
        type: "kern",
        size: 0.1
      }, {
        type: "elem",
        elem: braceBody
      }]
    }, options2);
    vlist.children[0].children[0].children[1].classes.push("svg-align");
  } else {
    vlist = buildCommon.makeVList({
      positionType: "bottom",
      positionData: body.depth + 0.1 + braceBody.height,
      children: [{
        type: "elem",
        elem: braceBody
      }, {
        type: "kern",
        size: 0.1
      }, {
        type: "elem",
        elem: body
      }]
    }, options2);
    vlist.children[0].children[0].children[0].classes.push("svg-align");
  }
  if (supSubGroup) {
    var vSpan = buildCommon.makeSpan(["mord", group.isOver ? "mover" : "munder"], [vlist], options2);
    if (group.isOver) {
      vlist = buildCommon.makeVList({
        positionType: "firstBaseline",
        children: [{
          type: "elem",
          elem: vSpan
        }, {
          type: "kern",
          size: 0.2
        }, {
          type: "elem",
          elem: supSubGroup
        }]
      }, options2);
    } else {
      vlist = buildCommon.makeVList({
        positionType: "bottom",
        positionData: vSpan.depth + 0.2 + supSubGroup.height + supSubGroup.depth,
        children: [{
          type: "elem",
          elem: supSubGroup
        }, {
          type: "kern",
          size: 0.2
        }, {
          type: "elem",
          elem: vSpan
        }]
      }, options2);
    }
  }
  return buildCommon.makeSpan(["mord", group.isOver ? "mover" : "munder"], [vlist], options2);
};
var mathmlBuilder$2 = (group, options2) => {
  var accentNode = stretchy.mathMLnode(group.label);
  return new mathMLTree.MathNode(group.isOver ? "mover" : "munder", [buildGroup2(group.base, options2), accentNode]);
};
defineFunction({
  type: "horizBrace",
  names: ["\\overbrace", "\\underbrace"],
  props: {
    numArgs: 1
  },
  handler(_ref, args) {
    var {
      parser,
      funcName
    } = _ref;
    return {
      type: "horizBrace",
      mode: parser.mode,
      label: funcName,
      isOver: /^\\over/.test(funcName),
      base: args[0]
    };
  },
  htmlBuilder: htmlBuilder$3,
  mathmlBuilder: mathmlBuilder$2
});
defineFunction({
  type: "href",
  names: ["\\href"],
  props: {
    numArgs: 2,
    argTypes: ["url", "original"],
    allowedInText: true
  },
  handler: (_ref, args) => {
    var {
      parser
    } = _ref;
    var body = args[1];
    var href = assertNodeType(args[0], "url").url;
    if (!parser.settings.isTrusted({
      command: "\\href",
      url: href
    })) {
      return parser.formatUnsupportedCmd("\\href");
    }
    return {
      type: "href",
      mode: parser.mode,
      href,
      body: ordargument(body)
    };
  },
  htmlBuilder: (group, options2) => {
    var elements = buildExpression$1(group.body, options2, false);
    return buildCommon.makeAnchor(group.href, [], elements, options2);
  },
  mathmlBuilder: (group, options2) => {
    var math2 = buildExpressionRow(group.body, options2);
    if (!(math2 instanceof MathNode)) {
      math2 = new MathNode("mrow", [math2]);
    }
    math2.setAttribute("href", group.href);
    return math2;
  }
});
defineFunction({
  type: "href",
  names: ["\\url"],
  props: {
    numArgs: 1,
    argTypes: ["url"],
    allowedInText: true
  },
  handler: (_ref2, args) => {
    var {
      parser
    } = _ref2;
    var href = assertNodeType(args[0], "url").url;
    if (!parser.settings.isTrusted({
      command: "\\url",
      url: href
    })) {
      return parser.formatUnsupportedCmd("\\url");
    }
    var chars = [];
    for (var i = 0; i < href.length; i++) {
      var c = href[i];
      if (c === "~") {
        c = "\\textasciitilde";
      }
      chars.push({
        type: "textord",
        mode: "text",
        text: c
      });
    }
    var body = {
      type: "text",
      mode: parser.mode,
      font: "\\texttt",
      body: chars
    };
    return {
      type: "href",
      mode: parser.mode,
      href,
      body: ordargument(body)
    };
  }
});
defineFunction({
  type: "hbox",
  names: ["\\hbox"],
  props: {
    numArgs: 1,
    argTypes: ["text"],
    allowedInText: true,
    primitive: true
  },
  handler(_ref, args) {
    var {
      parser
    } = _ref;
    return {
      type: "hbox",
      mode: parser.mode,
      body: ordargument(args[0])
    };
  },
  htmlBuilder(group, options2) {
    var elements = buildExpression$1(group.body, options2, false);
    return buildCommon.makeFragment(elements);
  },
  mathmlBuilder(group, options2) {
    return new mathMLTree.MathNode("mrow", buildExpression2(group.body, options2));
  }
});
defineFunction({
  type: "html",
  names: ["\\htmlClass", "\\htmlId", "\\htmlStyle", "\\htmlData"],
  props: {
    numArgs: 2,
    argTypes: ["raw", "original"],
    allowedInText: true
  },
  handler: (_ref, args) => {
    var {
      parser,
      funcName,
      token
    } = _ref;
    var value = assertNodeType(args[0], "raw").string;
    var body = args[1];
    if (parser.settings.strict) {
      parser.settings.reportNonstrict("htmlExtension", "HTML extension is disabled on strict mode");
    }
    var trustContext;
    var attributes = {};
    switch (funcName) {
      case "\\htmlClass":
        attributes.class = value;
        trustContext = {
          command: "\\htmlClass",
          class: value
        };
        break;
      case "\\htmlId":
        attributes.id = value;
        trustContext = {
          command: "\\htmlId",
          id: value
        };
        break;
      case "\\htmlStyle":
        attributes.style = value;
        trustContext = {
          command: "\\htmlStyle",
          style: value
        };
        break;
      case "\\htmlData": {
        var data = value.split(",");
        for (var i = 0; i < data.length; i++) {
          var keyVal = data[i].split("=");
          if (keyVal.length !== 2) {
            throw new ParseError("Error parsing key-value for \\htmlData");
          }
          attributes["data-" + keyVal[0].trim()] = keyVal[1].trim();
        }
        trustContext = {
          command: "\\htmlData",
          attributes
        };
        break;
      }
      default:
        throw new Error("Unrecognized html command");
    }
    if (!parser.settings.isTrusted(trustContext)) {
      return parser.formatUnsupportedCmd(funcName);
    }
    return {
      type: "html",
      mode: parser.mode,
      attributes,
      body: ordargument(body)
    };
  },
  htmlBuilder: (group, options2) => {
    var elements = buildExpression$1(group.body, options2, false);
    var classes = ["enclosing"];
    if (group.attributes.class) {
      classes.push(...group.attributes.class.trim().split(/\s+/));
    }
    var span = buildCommon.makeSpan(classes, elements, options2);
    for (var attr in group.attributes) {
      if (attr !== "class" && group.attributes.hasOwnProperty(attr)) {
        span.setAttribute(attr, group.attributes[attr]);
      }
    }
    return span;
  },
  mathmlBuilder: (group, options2) => {
    return buildExpressionRow(group.body, options2);
  }
});
defineFunction({
  type: "htmlmathml",
  names: ["\\html@mathml"],
  props: {
    numArgs: 2,
    allowedInText: true
  },
  handler: (_ref, args) => {
    var {
      parser
    } = _ref;
    return {
      type: "htmlmathml",
      mode: parser.mode,
      html: ordargument(args[0]),
      mathml: ordargument(args[1])
    };
  },
  htmlBuilder: (group, options2) => {
    var elements = buildExpression$1(group.html, options2, false);
    return buildCommon.makeFragment(elements);
  },
  mathmlBuilder: (group, options2) => {
    return buildExpressionRow(group.mathml, options2);
  }
});
var sizeData = function sizeData2(str) {
  if (/^[-+]? *(\d+(\.\d*)?|\.\d+)$/.test(str)) {
    return {
      number: +str,
      unit: "bp"
    };
  } else {
    var match = /([-+]?) *(\d+(?:\.\d*)?|\.\d+) *([a-z]{2})/.exec(str);
    if (!match) {
      throw new ParseError("Invalid size: '" + str + "' in \\includegraphics");
    }
    var data = {
      number: +(match[1] + match[2]),
      // sign + magnitude, cast to number
      unit: match[3]
    };
    if (!validUnit(data)) {
      throw new ParseError("Invalid unit: '" + data.unit + "' in \\includegraphics.");
    }
    return data;
  }
};
defineFunction({
  type: "includegraphics",
  names: ["\\includegraphics"],
  props: {
    numArgs: 1,
    numOptionalArgs: 1,
    argTypes: ["raw", "url"],
    allowedInText: false
  },
  handler: (_ref, args, optArgs) => {
    var {
      parser
    } = _ref;
    var width = {
      number: 0,
      unit: "em"
    };
    var height = {
      number: 0.9,
      unit: "em"
    };
    var totalheight = {
      number: 0,
      unit: "em"
    };
    var alt = "";
    if (optArgs[0]) {
      var attributeStr = assertNodeType(optArgs[0], "raw").string;
      var attributes = attributeStr.split(",");
      for (var i = 0; i < attributes.length; i++) {
        var keyVal = attributes[i].split("=");
        if (keyVal.length === 2) {
          var str = keyVal[1].trim();
          switch (keyVal[0].trim()) {
            case "alt":
              alt = str;
              break;
            case "width":
              width = sizeData(str);
              break;
            case "height":
              height = sizeData(str);
              break;
            case "totalheight":
              totalheight = sizeData(str);
              break;
            default:
              throw new ParseError("Invalid key: '" + keyVal[0] + "' in \\includegraphics.");
          }
        }
      }
    }
    var src = assertNodeType(args[0], "url").url;
    if (alt === "") {
      alt = src;
      alt = alt.replace(/^.*[\\/]/, "");
      alt = alt.substring(0, alt.lastIndexOf("."));
    }
    if (!parser.settings.isTrusted({
      command: "\\includegraphics",
      url: src
    })) {
      return parser.formatUnsupportedCmd("\\includegraphics");
    }
    return {
      type: "includegraphics",
      mode: parser.mode,
      alt,
      width,
      height,
      totalheight,
      src
    };
  },
  htmlBuilder: (group, options2) => {
    var height = calculateSize(group.height, options2);
    var depth = 0;
    if (group.totalheight.number > 0) {
      depth = calculateSize(group.totalheight, options2) - height;
    }
    var width = 0;
    if (group.width.number > 0) {
      width = calculateSize(group.width, options2);
    }
    var style = {
      height: makeEm(height + depth)
    };
    if (width > 0) {
      style.width = makeEm(width);
    }
    if (depth > 0) {
      style.verticalAlign = makeEm(-depth);
    }
    var node2 = new Img(group.src, group.alt, style);
    node2.height = height;
    node2.depth = depth;
    return node2;
  },
  mathmlBuilder: (group, options2) => {
    var node2 = new mathMLTree.MathNode("mglyph", []);
    node2.setAttribute("alt", group.alt);
    var height = calculateSize(group.height, options2);
    var depth = 0;
    if (group.totalheight.number > 0) {
      depth = calculateSize(group.totalheight, options2) - height;
      node2.setAttribute("valign", makeEm(-depth));
    }
    node2.setAttribute("height", makeEm(height + depth));
    if (group.width.number > 0) {
      var width = calculateSize(group.width, options2);
      node2.setAttribute("width", makeEm(width));
    }
    node2.setAttribute("src", group.src);
    return node2;
  }
});
defineFunction({
  type: "kern",
  names: ["\\kern", "\\mkern", "\\hskip", "\\mskip"],
  props: {
    numArgs: 1,
    argTypes: ["size"],
    primitive: true,
    allowedInText: true
  },
  handler(_ref, args) {
    var {
      parser,
      funcName
    } = _ref;
    var size = assertNodeType(args[0], "size");
    if (parser.settings.strict) {
      var mathFunction = funcName[1] === "m";
      var muUnit = size.value.unit === "mu";
      if (mathFunction) {
        if (!muUnit) {
          parser.settings.reportNonstrict("mathVsTextUnits", "LaTeX's " + funcName + " supports only mu units, " + ("not " + size.value.unit + " units"));
        }
        if (parser.mode !== "math") {
          parser.settings.reportNonstrict("mathVsTextUnits", "LaTeX's " + funcName + " works only in math mode");
        }
      } else {
        if (muUnit) {
          parser.settings.reportNonstrict("mathVsTextUnits", "LaTeX's " + funcName + " doesn't support mu units");
        }
      }
    }
    return {
      type: "kern",
      mode: parser.mode,
      dimension: size.value
    };
  },
  htmlBuilder(group, options2) {
    return buildCommon.makeGlue(group.dimension, options2);
  },
  mathmlBuilder(group, options2) {
    var dimension = calculateSize(group.dimension, options2);
    return new mathMLTree.SpaceNode(dimension);
  }
});
defineFunction({
  type: "lap",
  names: ["\\mathllap", "\\mathrlap", "\\mathclap"],
  props: {
    numArgs: 1,
    allowedInText: true
  },
  handler: (_ref, args) => {
    var {
      parser,
      funcName
    } = _ref;
    var body = args[0];
    return {
      type: "lap",
      mode: parser.mode,
      alignment: funcName.slice(5),
      body
    };
  },
  htmlBuilder: (group, options2) => {
    var inner2;
    if (group.alignment === "clap") {
      inner2 = buildCommon.makeSpan([], [buildGroup$1(group.body, options2)]);
      inner2 = buildCommon.makeSpan(["inner"], [inner2], options2);
    } else {
      inner2 = buildCommon.makeSpan(["inner"], [buildGroup$1(group.body, options2)]);
    }
    var fix = buildCommon.makeSpan(["fix"], []);
    var node2 = buildCommon.makeSpan([group.alignment], [inner2, fix], options2);
    var strut = buildCommon.makeSpan(["strut"]);
    strut.style.height = makeEm(node2.height + node2.depth);
    if (node2.depth) {
      strut.style.verticalAlign = makeEm(-node2.depth);
    }
    node2.children.unshift(strut);
    node2 = buildCommon.makeSpan(["thinbox"], [node2], options2);
    return buildCommon.makeSpan(["mord", "vbox"], [node2], options2);
  },
  mathmlBuilder: (group, options2) => {
    var node2 = new mathMLTree.MathNode("mpadded", [buildGroup2(group.body, options2)]);
    if (group.alignment !== "rlap") {
      var offset = group.alignment === "llap" ? "-1" : "-0.5";
      node2.setAttribute("lspace", offset + "width");
    }
    node2.setAttribute("width", "0px");
    return node2;
  }
});
defineFunction({
  type: "styling",
  names: ["\\(", "$"],
  props: {
    numArgs: 0,
    allowedInText: true,
    allowedInMath: false
  },
  handler(_ref, args) {
    var {
      funcName,
      parser
    } = _ref;
    var outerMode = parser.mode;
    parser.switchMode("math");
    var close2 = funcName === "\\(" ? "\\)" : "$";
    var body = parser.parseExpression(false, close2);
    parser.expect(close2);
    parser.switchMode(outerMode);
    return {
      type: "styling",
      mode: parser.mode,
      style: "text",
      body
    };
  }
});
defineFunction({
  type: "text",
  // Doesn't matter what this is.
  names: ["\\)", "\\]"],
  props: {
    numArgs: 0,
    allowedInText: true,
    allowedInMath: false
  },
  handler(context, args) {
    throw new ParseError("Mismatched " + context.funcName);
  }
});
var chooseMathStyle = (group, options2) => {
  switch (options2.style.size) {
    case Style$1.DISPLAY.size:
      return group.display;
    case Style$1.TEXT.size:
      return group.text;
    case Style$1.SCRIPT.size:
      return group.script;
    case Style$1.SCRIPTSCRIPT.size:
      return group.scriptscript;
    default:
      return group.text;
  }
};
defineFunction({
  type: "mathchoice",
  names: ["\\mathchoice"],
  props: {
    numArgs: 4,
    primitive: true
  },
  handler: (_ref, args) => {
    var {
      parser
    } = _ref;
    return {
      type: "mathchoice",
      mode: parser.mode,
      display: ordargument(args[0]),
      text: ordargument(args[1]),
      script: ordargument(args[2]),
      scriptscript: ordargument(args[3])
    };
  },
  htmlBuilder: (group, options2) => {
    var body = chooseMathStyle(group, options2);
    var elements = buildExpression$1(body, options2, false);
    return buildCommon.makeFragment(elements);
  },
  mathmlBuilder: (group, options2) => {
    var body = chooseMathStyle(group, options2);
    return buildExpressionRow(body, options2);
  }
});
var assembleSupSub = (base, supGroup, subGroup, options2, style, slant, baseShift) => {
  base = buildCommon.makeSpan([], [base]);
  var subIsSingleCharacter = subGroup && utils.isCharacterBox(subGroup);
  var sub2;
  var sup2;
  if (supGroup) {
    var elem = buildGroup$1(supGroup, options2.havingStyle(style.sup()), options2);
    sup2 = {
      elem,
      kern: Math.max(options2.fontMetrics().bigOpSpacing1, options2.fontMetrics().bigOpSpacing3 - elem.depth)
    };
  }
  if (subGroup) {
    var _elem = buildGroup$1(subGroup, options2.havingStyle(style.sub()), options2);
    sub2 = {
      elem: _elem,
      kern: Math.max(options2.fontMetrics().bigOpSpacing2, options2.fontMetrics().bigOpSpacing4 - _elem.height)
    };
  }
  var finalGroup;
  if (sup2 && sub2) {
    var bottom = options2.fontMetrics().bigOpSpacing5 + sub2.elem.height + sub2.elem.depth + sub2.kern + base.depth + baseShift;
    finalGroup = buildCommon.makeVList({
      positionType: "bottom",
      positionData: bottom,
      children: [{
        type: "kern",
        size: options2.fontMetrics().bigOpSpacing5
      }, {
        type: "elem",
        elem: sub2.elem,
        marginLeft: makeEm(-slant)
      }, {
        type: "kern",
        size: sub2.kern
      }, {
        type: "elem",
        elem: base
      }, {
        type: "kern",
        size: sup2.kern
      }, {
        type: "elem",
        elem: sup2.elem,
        marginLeft: makeEm(slant)
      }, {
        type: "kern",
        size: options2.fontMetrics().bigOpSpacing5
      }]
    }, options2);
  } else if (sub2) {
    var top = base.height - baseShift;
    finalGroup = buildCommon.makeVList({
      positionType: "top",
      positionData: top,
      children: [{
        type: "kern",
        size: options2.fontMetrics().bigOpSpacing5
      }, {
        type: "elem",
        elem: sub2.elem,
        marginLeft: makeEm(-slant)
      }, {
        type: "kern",
        size: sub2.kern
      }, {
        type: "elem",
        elem: base
      }]
    }, options2);
  } else if (sup2) {
    var _bottom = base.depth + baseShift;
    finalGroup = buildCommon.makeVList({
      positionType: "bottom",
      positionData: _bottom,
      children: [{
        type: "elem",
        elem: base
      }, {
        type: "kern",
        size: sup2.kern
      }, {
        type: "elem",
        elem: sup2.elem,
        marginLeft: makeEm(slant)
      }, {
        type: "kern",
        size: options2.fontMetrics().bigOpSpacing5
      }]
    }, options2);
  } else {
    return base;
  }
  var parts = [finalGroup];
  if (sub2 && slant !== 0 && !subIsSingleCharacter) {
    var spacer = buildCommon.makeSpan(["mspace"], [], options2);
    spacer.style.marginRight = makeEm(slant);
    parts.unshift(spacer);
  }
  return buildCommon.makeSpan(["mop", "op-limits"], parts, options2);
};
var noSuccessor = ["\\smallint"];
var htmlBuilder$2 = (grp, options2) => {
  var supGroup;
  var subGroup;
  var hasLimits = false;
  var group;
  if (grp.type === "supsub") {
    supGroup = grp.sup;
    subGroup = grp.sub;
    group = assertNodeType(grp.base, "op");
    hasLimits = true;
  } else {
    group = assertNodeType(grp, "op");
  }
  var style = options2.style;
  var large = false;
  if (style.size === Style$1.DISPLAY.size && group.symbol && !utils.contains(noSuccessor, group.name)) {
    large = true;
  }
  var base;
  if (group.symbol) {
    var fontName = large ? "Size2-Regular" : "Size1-Regular";
    var stash = "";
    if (group.name === "\\oiint" || group.name === "\\oiiint") {
      stash = group.name.slice(1);
      group.name = stash === "oiint" ? "\\iint" : "\\iiint";
    }
    base = buildCommon.makeSymbol(group.name, fontName, "math", options2, ["mop", "op-symbol", large ? "large-op" : "small-op"]);
    if (stash.length > 0) {
      var italic = base.italic;
      var oval = buildCommon.staticSvg(stash + "Size" + (large ? "2" : "1"), options2);
      base = buildCommon.makeVList({
        positionType: "individualShift",
        children: [{
          type: "elem",
          elem: base,
          shift: 0
        }, {
          type: "elem",
          elem: oval,
          shift: large ? 0.08 : 0
        }]
      }, options2);
      group.name = "\\" + stash;
      base.classes.unshift("mop");
      base.italic = italic;
    }
  } else if (group.body) {
    var inner2 = buildExpression$1(group.body, options2, true);
    if (inner2.length === 1 && inner2[0] instanceof SymbolNode) {
      base = inner2[0];
      base.classes[0] = "mop";
    } else {
      base = buildCommon.makeSpan(["mop"], inner2, options2);
    }
  } else {
    var output = [];
    for (var i = 1; i < group.name.length; i++) {
      output.push(buildCommon.mathsym(group.name[i], group.mode, options2));
    }
    base = buildCommon.makeSpan(["mop"], output, options2);
  }
  var baseShift = 0;
  var slant = 0;
  if ((base instanceof SymbolNode || group.name === "\\oiint" || group.name === "\\oiiint") && !group.suppressBaseShift) {
    baseShift = (base.height - base.depth) / 2 - options2.fontMetrics().axisHeight;
    slant = base.italic;
  }
  if (hasLimits) {
    return assembleSupSub(base, supGroup, subGroup, options2, style, slant, baseShift);
  } else {
    if (baseShift) {
      base.style.position = "relative";
      base.style.top = makeEm(baseShift);
    }
    return base;
  }
};
var mathmlBuilder$1 = (group, options2) => {
  var node2;
  if (group.symbol) {
    node2 = new MathNode("mo", [makeText(group.name, group.mode)]);
    if (utils.contains(noSuccessor, group.name)) {
      node2.setAttribute("largeop", "false");
    }
  } else if (group.body) {
    node2 = new MathNode("mo", buildExpression2(group.body, options2));
  } else {
    node2 = new MathNode("mi", [new TextNode(group.name.slice(1))]);
    var operator = new MathNode("mo", [makeText("⁡", "text")]);
    if (group.parentIsSupSub) {
      node2 = new MathNode("mrow", [node2, operator]);
    } else {
      node2 = newDocumentFragment([node2, operator]);
    }
  }
  return node2;
};
var singleCharBigOps = {
  "∏": "\\prod",
  "∐": "\\coprod",
  "∑": "\\sum",
  "⋀": "\\bigwedge",
  "⋁": "\\bigvee",
  "⋂": "\\bigcap",
  "⋃": "\\bigcup",
  "⨀": "\\bigodot",
  "⨁": "\\bigoplus",
  "⨂": "\\bigotimes",
  "⨄": "\\biguplus",
  "⨆": "\\bigsqcup"
};
defineFunction({
  type: "op",
  names: ["\\coprod", "\\bigvee", "\\bigwedge", "\\biguplus", "\\bigcap", "\\bigcup", "\\intop", "\\prod", "\\sum", "\\bigotimes", "\\bigoplus", "\\bigodot", "\\bigsqcup", "\\smallint", "∏", "∐", "∑", "⋀", "⋁", "⋂", "⋃", "⨀", "⨁", "⨂", "⨄", "⨆"],
  props: {
    numArgs: 0
  },
  handler: (_ref, args) => {
    var {
      parser,
      funcName
    } = _ref;
    var fName = funcName;
    if (fName.length === 1) {
      fName = singleCharBigOps[fName];
    }
    return {
      type: "op",
      mode: parser.mode,
      limits: true,
      parentIsSupSub: false,
      symbol: true,
      name: fName
    };
  },
  htmlBuilder: htmlBuilder$2,
  mathmlBuilder: mathmlBuilder$1
});
defineFunction({
  type: "op",
  names: ["\\mathop"],
  props: {
    numArgs: 1,
    primitive: true
  },
  handler: (_ref2, args) => {
    var {
      parser
    } = _ref2;
    var body = args[0];
    return {
      type: "op",
      mode: parser.mode,
      limits: false,
      parentIsSupSub: false,
      symbol: false,
      body: ordargument(body)
    };
  },
  htmlBuilder: htmlBuilder$2,
  mathmlBuilder: mathmlBuilder$1
});
var singleCharIntegrals = {
  "∫": "\\int",
  "∬": "\\iint",
  "∭": "\\iiint",
  "∮": "\\oint",
  "∯": "\\oiint",
  "∰": "\\oiiint"
};
defineFunction({
  type: "op",
  names: ["\\arcsin", "\\arccos", "\\arctan", "\\arctg", "\\arcctg", "\\arg", "\\ch", "\\cos", "\\cosec", "\\cosh", "\\cot", "\\cotg", "\\coth", "\\csc", "\\ctg", "\\cth", "\\deg", "\\dim", "\\exp", "\\hom", "\\ker", "\\lg", "\\ln", "\\log", "\\sec", "\\sin", "\\sinh", "\\sh", "\\tan", "\\tanh", "\\tg", "\\th"],
  props: {
    numArgs: 0
  },
  handler(_ref3) {
    var {
      parser,
      funcName
    } = _ref3;
    return {
      type: "op",
      mode: parser.mode,
      limits: false,
      parentIsSupSub: false,
      symbol: false,
      name: funcName
    };
  },
  htmlBuilder: htmlBuilder$2,
  mathmlBuilder: mathmlBuilder$1
});
defineFunction({
  type: "op",
  names: ["\\det", "\\gcd", "\\inf", "\\lim", "\\max", "\\min", "\\Pr", "\\sup"],
  props: {
    numArgs: 0
  },
  handler(_ref4) {
    var {
      parser,
      funcName
    } = _ref4;
    return {
      type: "op",
      mode: parser.mode,
      limits: true,
      parentIsSupSub: false,
      symbol: false,
      name: funcName
    };
  },
  htmlBuilder: htmlBuilder$2,
  mathmlBuilder: mathmlBuilder$1
});
defineFunction({
  type: "op",
  names: ["\\int", "\\iint", "\\iiint", "\\oint", "\\oiint", "\\oiiint", "∫", "∬", "∭", "∮", "∯", "∰"],
  props: {
    numArgs: 0
  },
  handler(_ref5) {
    var {
      parser,
      funcName
    } = _ref5;
    var fName = funcName;
    if (fName.length === 1) {
      fName = singleCharIntegrals[fName];
    }
    return {
      type: "op",
      mode: parser.mode,
      limits: false,
      parentIsSupSub: false,
      symbol: true,
      name: fName
    };
  },
  htmlBuilder: htmlBuilder$2,
  mathmlBuilder: mathmlBuilder$1
});
var htmlBuilder$1 = (grp, options2) => {
  var supGroup;
  var subGroup;
  var hasLimits = false;
  var group;
  if (grp.type === "supsub") {
    supGroup = grp.sup;
    subGroup = grp.sub;
    group = assertNodeType(grp.base, "operatorname");
    hasLimits = true;
  } else {
    group = assertNodeType(grp, "operatorname");
  }
  var base;
  if (group.body.length > 0) {
    var body = group.body.map((child2) => {
      var childText = child2.text;
      if (typeof childText === "string") {
        return {
          type: "textord",
          mode: child2.mode,
          text: childText
        };
      } else {
        return child2;
      }
    });
    var expression = buildExpression$1(body, options2.withFont("mathrm"), true);
    for (var i = 0; i < expression.length; i++) {
      var child = expression[i];
      if (child instanceof SymbolNode) {
        child.text = child.text.replace(/\u2212/, "-").replace(/\u2217/, "*");
      }
    }
    base = buildCommon.makeSpan(["mop"], expression, options2);
  } else {
    base = buildCommon.makeSpan(["mop"], [], options2);
  }
  if (hasLimits) {
    return assembleSupSub(base, supGroup, subGroup, options2, options2.style, 0, 0);
  } else {
    return base;
  }
};
var mathmlBuilder2 = (group, options2) => {
  var expression = buildExpression2(group.body, options2.withFont("mathrm"));
  var isAllString = true;
  for (var i = 0; i < expression.length; i++) {
    var node2 = expression[i];
    if (node2 instanceof mathMLTree.SpaceNode)
      ;
    else if (node2 instanceof mathMLTree.MathNode) {
      switch (node2.type) {
        case "mi":
        case "mn":
        case "ms":
        case "mspace":
        case "mtext":
          break;
        case "mo": {
          var child = node2.children[0];
          if (node2.children.length === 1 && child instanceof mathMLTree.TextNode) {
            child.text = child.text.replace(/\u2212/, "-").replace(/\u2217/, "*");
          } else {
            isAllString = false;
          }
          break;
        }
        default:
          isAllString = false;
      }
    } else {
      isAllString = false;
    }
  }
  if (isAllString) {
    var word = expression.map((node3) => node3.toText()).join("");
    expression = [new mathMLTree.TextNode(word)];
  }
  var identifier = new mathMLTree.MathNode("mi", expression);
  identifier.setAttribute("mathvariant", "normal");
  var operator = new mathMLTree.MathNode("mo", [makeText("⁡", "text")]);
  if (group.parentIsSupSub) {
    return new mathMLTree.MathNode("mrow", [identifier, operator]);
  } else {
    return mathMLTree.newDocumentFragment([identifier, operator]);
  }
};
defineFunction({
  type: "operatorname",
  names: ["\\operatorname@", "\\operatornamewithlimits"],
  props: {
    numArgs: 1
  },
  handler: (_ref, args) => {
    var {
      parser,
      funcName
    } = _ref;
    var body = args[0];
    return {
      type: "operatorname",
      mode: parser.mode,
      body: ordargument(body),
      alwaysHandleSupSub: funcName === "\\operatornamewithlimits",
      limits: false,
      parentIsSupSub: false
    };
  },
  htmlBuilder: htmlBuilder$1,
  mathmlBuilder: mathmlBuilder2
});
defineMacro("\\operatorname", "\\@ifstar\\operatornamewithlimits\\operatorname@");
defineFunctionBuilders({
  type: "ordgroup",
  htmlBuilder(group, options2) {
    if (group.semisimple) {
      return buildCommon.makeFragment(buildExpression$1(group.body, options2, false));
    }
    return buildCommon.makeSpan(["mord"], buildExpression$1(group.body, options2, true), options2);
  },
  mathmlBuilder(group, options2) {
    return buildExpressionRow(group.body, options2, true);
  }
});
defineFunction({
  type: "overline",
  names: ["\\overline"],
  props: {
    numArgs: 1
  },
  handler(_ref, args) {
    var {
      parser
    } = _ref;
    var body = args[0];
    return {
      type: "overline",
      mode: parser.mode,
      body
    };
  },
  htmlBuilder(group, options2) {
    var innerGroup = buildGroup$1(group.body, options2.havingCrampedStyle());
    var line = buildCommon.makeLineSpan("overline-line", options2);
    var defaultRuleThickness = options2.fontMetrics().defaultRuleThickness;
    var vlist = buildCommon.makeVList({
      positionType: "firstBaseline",
      children: [{
        type: "elem",
        elem: innerGroup
      }, {
        type: "kern",
        size: 3 * defaultRuleThickness
      }, {
        type: "elem",
        elem: line
      }, {
        type: "kern",
        size: defaultRuleThickness
      }]
    }, options2);
    return buildCommon.makeSpan(["mord", "overline"], [vlist], options2);
  },
  mathmlBuilder(group, options2) {
    var operator = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode("‾")]);
    operator.setAttribute("stretchy", "true");
    var node2 = new mathMLTree.MathNode("mover", [buildGroup2(group.body, options2), operator]);
    node2.setAttribute("accent", "true");
    return node2;
  }
});
defineFunction({
  type: "phantom",
  names: ["\\phantom"],
  props: {
    numArgs: 1,
    allowedInText: true
  },
  handler: (_ref, args) => {
    var {
      parser
    } = _ref;
    var body = args[0];
    return {
      type: "phantom",
      mode: parser.mode,
      body: ordargument(body)
    };
  },
  htmlBuilder: (group, options2) => {
    var elements = buildExpression$1(group.body, options2.withPhantom(), false);
    return buildCommon.makeFragment(elements);
  },
  mathmlBuilder: (group, options2) => {
    var inner2 = buildExpression2(group.body, options2);
    return new mathMLTree.MathNode("mphantom", inner2);
  }
});
defineFunction({
  type: "hphantom",
  names: ["\\hphantom"],
  props: {
    numArgs: 1,
    allowedInText: true
  },
  handler: (_ref2, args) => {
    var {
      parser
    } = _ref2;
    var body = args[0];
    return {
      type: "hphantom",
      mode: parser.mode,
      body
    };
  },
  htmlBuilder: (group, options2) => {
    var node2 = buildCommon.makeSpan([], [buildGroup$1(group.body, options2.withPhantom())]);
    node2.height = 0;
    node2.depth = 0;
    if (node2.children) {
      for (var i = 0; i < node2.children.length; i++) {
        node2.children[i].height = 0;
        node2.children[i].depth = 0;
      }
    }
    node2 = buildCommon.makeVList({
      positionType: "firstBaseline",
      children: [{
        type: "elem",
        elem: node2
      }]
    }, options2);
    return buildCommon.makeSpan(["mord"], [node2], options2);
  },
  mathmlBuilder: (group, options2) => {
    var inner2 = buildExpression2(ordargument(group.body), options2);
    var phantom = new mathMLTree.MathNode("mphantom", inner2);
    var node2 = new mathMLTree.MathNode("mpadded", [phantom]);
    node2.setAttribute("height", "0px");
    node2.setAttribute("depth", "0px");
    return node2;
  }
});
defineFunction({
  type: "vphantom",
  names: ["\\vphantom"],
  props: {
    numArgs: 1,
    allowedInText: true
  },
  handler: (_ref3, args) => {
    var {
      parser
    } = _ref3;
    var body = args[0];
    return {
      type: "vphantom",
      mode: parser.mode,
      body
    };
  },
  htmlBuilder: (group, options2) => {
    var inner2 = buildCommon.makeSpan(["inner"], [buildGroup$1(group.body, options2.withPhantom())]);
    var fix = buildCommon.makeSpan(["fix"], []);
    return buildCommon.makeSpan(["mord", "rlap"], [inner2, fix], options2);
  },
  mathmlBuilder: (group, options2) => {
    var inner2 = buildExpression2(ordargument(group.body), options2);
    var phantom = new mathMLTree.MathNode("mphantom", inner2);
    var node2 = new mathMLTree.MathNode("mpadded", [phantom]);
    node2.setAttribute("width", "0px");
    return node2;
  }
});
defineFunction({
  type: "raisebox",
  names: ["\\raisebox"],
  props: {
    numArgs: 2,
    argTypes: ["size", "hbox"],
    allowedInText: true
  },
  handler(_ref, args) {
    var {
      parser
    } = _ref;
    var amount = assertNodeType(args[0], "size").value;
    var body = args[1];
    return {
      type: "raisebox",
      mode: parser.mode,
      dy: amount,
      body
    };
  },
  htmlBuilder(group, options2) {
    var body = buildGroup$1(group.body, options2);
    var dy = calculateSize(group.dy, options2);
    return buildCommon.makeVList({
      positionType: "shift",
      positionData: -dy,
      children: [{
        type: "elem",
        elem: body
      }]
    }, options2);
  },
  mathmlBuilder(group, options2) {
    var node2 = new mathMLTree.MathNode("mpadded", [buildGroup2(group.body, options2)]);
    var dy = group.dy.number + group.dy.unit;
    node2.setAttribute("voffset", dy);
    return node2;
  }
});
defineFunction({
  type: "internal",
  names: ["\\relax"],
  props: {
    numArgs: 0,
    allowedInText: true
  },
  handler(_ref) {
    var {
      parser
    } = _ref;
    return {
      type: "internal",
      mode: parser.mode
    };
  }
});
defineFunction({
  type: "rule",
  names: ["\\rule"],
  props: {
    numArgs: 2,
    numOptionalArgs: 1,
    argTypes: ["size", "size", "size"]
  },
  handler(_ref, args, optArgs) {
    var {
      parser
    } = _ref;
    var shift = optArgs[0];
    var width = assertNodeType(args[0], "size");
    var height = assertNodeType(args[1], "size");
    return {
      type: "rule",
      mode: parser.mode,
      shift: shift && assertNodeType(shift, "size").value,
      width: width.value,
      height: height.value
    };
  },
  htmlBuilder(group, options2) {
    var rule = buildCommon.makeSpan(["mord", "rule"], [], options2);
    var width = calculateSize(group.width, options2);
    var height = calculateSize(group.height, options2);
    var shift = group.shift ? calculateSize(group.shift, options2) : 0;
    rule.style.borderRightWidth = makeEm(width);
    rule.style.borderTopWidth = makeEm(height);
    rule.style.bottom = makeEm(shift);
    rule.width = width;
    rule.height = height + shift;
    rule.depth = -shift;
    rule.maxFontSize = height * 1.125 * options2.sizeMultiplier;
    return rule;
  },
  mathmlBuilder(group, options2) {
    var width = calculateSize(group.width, options2);
    var height = calculateSize(group.height, options2);
    var shift = group.shift ? calculateSize(group.shift, options2) : 0;
    var color = options2.color && options2.getColor() || "black";
    var rule = new mathMLTree.MathNode("mspace");
    rule.setAttribute("mathbackground", color);
    rule.setAttribute("width", makeEm(width));
    rule.setAttribute("height", makeEm(height));
    var wrapper = new mathMLTree.MathNode("mpadded", [rule]);
    if (shift >= 0) {
      wrapper.setAttribute("height", makeEm(shift));
    } else {
      wrapper.setAttribute("height", makeEm(shift));
      wrapper.setAttribute("depth", makeEm(-shift));
    }
    wrapper.setAttribute("voffset", makeEm(shift));
    return wrapper;
  }
});
function sizingGroup(value, options2, baseOptions) {
  var inner2 = buildExpression$1(value, options2, false);
  var multiplier = options2.sizeMultiplier / baseOptions.sizeMultiplier;
  for (var i = 0; i < inner2.length; i++) {
    var pos = inner2[i].classes.indexOf("sizing");
    if (pos < 0) {
      Array.prototype.push.apply(inner2[i].classes, options2.sizingClasses(baseOptions));
    } else if (inner2[i].classes[pos + 1] === "reset-size" + options2.size) {
      inner2[i].classes[pos + 1] = "reset-size" + baseOptions.size;
    }
    inner2[i].height *= multiplier;
    inner2[i].depth *= multiplier;
  }
  return buildCommon.makeFragment(inner2);
}
var sizeFuncs = ["\\tiny", "\\sixptsize", "\\scriptsize", "\\footnotesize", "\\small", "\\normalsize", "\\large", "\\Large", "\\LARGE", "\\huge", "\\Huge"];
var htmlBuilder2 = (group, options2) => {
  var newOptions = options2.havingSize(group.size);
  return sizingGroup(group.body, newOptions, options2);
};
defineFunction({
  type: "sizing",
  names: sizeFuncs,
  props: {
    numArgs: 0,
    allowedInText: true
  },
  handler: (_ref, args) => {
    var {
      breakOnTokenText,
      funcName,
      parser
    } = _ref;
    var body = parser.parseExpression(false, breakOnTokenText);
    return {
      type: "sizing",
      mode: parser.mode,
      // Figure out what size to use based on the list of functions above
      size: sizeFuncs.indexOf(funcName) + 1,
      body
    };
  },
  htmlBuilder: htmlBuilder2,
  mathmlBuilder: (group, options2) => {
    var newOptions = options2.havingSize(group.size);
    var inner2 = buildExpression2(group.body, newOptions);
    var node2 = new mathMLTree.MathNode("mstyle", inner2);
    node2.setAttribute("mathsize", makeEm(newOptions.sizeMultiplier));
    return node2;
  }
});
defineFunction({
  type: "smash",
  names: ["\\smash"],
  props: {
    numArgs: 1,
    numOptionalArgs: 1,
    allowedInText: true
  },
  handler: (_ref, args, optArgs) => {
    var {
      parser
    } = _ref;
    var smashHeight = false;
    var smashDepth = false;
    var tbArg = optArgs[0] && assertNodeType(optArgs[0], "ordgroup");
    if (tbArg) {
      var letter = "";
      for (var i = 0; i < tbArg.body.length; ++i) {
        var node2 = tbArg.body[i];
        letter = node2.text;
        if (letter === "t") {
          smashHeight = true;
        } else if (letter === "b") {
          smashDepth = true;
        } else {
          smashHeight = false;
          smashDepth = false;
          break;
        }
      }
    } else {
      smashHeight = true;
      smashDepth = true;
    }
    var body = args[0];
    return {
      type: "smash",
      mode: parser.mode,
      body,
      smashHeight,
      smashDepth
    };
  },
  htmlBuilder: (group, options2) => {
    var node2 = buildCommon.makeSpan([], [buildGroup$1(group.body, options2)]);
    if (!group.smashHeight && !group.smashDepth) {
      return node2;
    }
    if (group.smashHeight) {
      node2.height = 0;
      if (node2.children) {
        for (var i = 0; i < node2.children.length; i++) {
          node2.children[i].height = 0;
        }
      }
    }
    if (group.smashDepth) {
      node2.depth = 0;
      if (node2.children) {
        for (var _i = 0; _i < node2.children.length; _i++) {
          node2.children[_i].depth = 0;
        }
      }
    }
    var smashedNode = buildCommon.makeVList({
      positionType: "firstBaseline",
      children: [{
        type: "elem",
        elem: node2
      }]
    }, options2);
    return buildCommon.makeSpan(["mord"], [smashedNode], options2);
  },
  mathmlBuilder: (group, options2) => {
    var node2 = new mathMLTree.MathNode("mpadded", [buildGroup2(group.body, options2)]);
    if (group.smashHeight) {
      node2.setAttribute("height", "0px");
    }
    if (group.smashDepth) {
      node2.setAttribute("depth", "0px");
    }
    return node2;
  }
});
defineFunction({
  type: "sqrt",
  names: ["\\sqrt"],
  props: {
    numArgs: 1,
    numOptionalArgs: 1
  },
  handler(_ref, args, optArgs) {
    var {
      parser
    } = _ref;
    var index = optArgs[0];
    var body = args[0];
    return {
      type: "sqrt",
      mode: parser.mode,
      body,
      index
    };
  },
  htmlBuilder(group, options2) {
    var inner2 = buildGroup$1(group.body, options2.havingCrampedStyle());
    if (inner2.height === 0) {
      inner2.height = options2.fontMetrics().xHeight;
    }
    inner2 = buildCommon.wrapFragment(inner2, options2);
    var metrics = options2.fontMetrics();
    var theta = metrics.defaultRuleThickness;
    var phi = theta;
    if (options2.style.id < Style$1.TEXT.id) {
      phi = options2.fontMetrics().xHeight;
    }
    var lineClearance = theta + phi / 4;
    var minDelimiterHeight = inner2.height + inner2.depth + lineClearance + theta;
    var {
      span: img,
      ruleWidth,
      advanceWidth
    } = delimiter.sqrtImage(minDelimiterHeight, options2);
    var delimDepth = img.height - ruleWidth;
    if (delimDepth > inner2.height + inner2.depth + lineClearance) {
      lineClearance = (lineClearance + delimDepth - inner2.height - inner2.depth) / 2;
    }
    var imgShift = img.height - inner2.height - lineClearance - ruleWidth;
    inner2.style.paddingLeft = makeEm(advanceWidth);
    var body = buildCommon.makeVList({
      positionType: "firstBaseline",
      children: [{
        type: "elem",
        elem: inner2,
        wrapperClasses: ["svg-align"]
      }, {
        type: "kern",
        size: -(inner2.height + imgShift)
      }, {
        type: "elem",
        elem: img
      }, {
        type: "kern",
        size: ruleWidth
      }]
    }, options2);
    if (!group.index) {
      return buildCommon.makeSpan(["mord", "sqrt"], [body], options2);
    } else {
      var newOptions = options2.havingStyle(Style$1.SCRIPTSCRIPT);
      var rootm = buildGroup$1(group.index, newOptions, options2);
      var toShift = 0.6 * (body.height - body.depth);
      var rootVList = buildCommon.makeVList({
        positionType: "shift",
        positionData: -toShift,
        children: [{
          type: "elem",
          elem: rootm
        }]
      }, options2);
      var rootVListWrap = buildCommon.makeSpan(["root"], [rootVList]);
      return buildCommon.makeSpan(["mord", "sqrt"], [rootVListWrap, body], options2);
    }
  },
  mathmlBuilder(group, options2) {
    var {
      body,
      index
    } = group;
    return index ? new mathMLTree.MathNode("mroot", [buildGroup2(body, options2), buildGroup2(index, options2)]) : new mathMLTree.MathNode("msqrt", [buildGroup2(body, options2)]);
  }
});
var styleMap = {
  "display": Style$1.DISPLAY,
  "text": Style$1.TEXT,
  "script": Style$1.SCRIPT,
  "scriptscript": Style$1.SCRIPTSCRIPT
};
defineFunction({
  type: "styling",
  names: ["\\displaystyle", "\\textstyle", "\\scriptstyle", "\\scriptscriptstyle"],
  props: {
    numArgs: 0,
    allowedInText: true,
    primitive: true
  },
  handler(_ref, args) {
    var {
      breakOnTokenText,
      funcName,
      parser
    } = _ref;
    var body = parser.parseExpression(true, breakOnTokenText);
    var style = funcName.slice(1, funcName.length - 5);
    return {
      type: "styling",
      mode: parser.mode,
      // Figure out what style to use by pulling out the style from
      // the function name
      style,
      body
    };
  },
  htmlBuilder(group, options2) {
    var newStyle = styleMap[group.style];
    var newOptions = options2.havingStyle(newStyle).withFont("");
    return sizingGroup(group.body, newOptions, options2);
  },
  mathmlBuilder(group, options2) {
    var newStyle = styleMap[group.style];
    var newOptions = options2.havingStyle(newStyle);
    var inner2 = buildExpression2(group.body, newOptions);
    var node2 = new mathMLTree.MathNode("mstyle", inner2);
    var styleAttributes = {
      "display": ["0", "true"],
      "text": ["0", "false"],
      "script": ["1", "false"],
      "scriptscript": ["2", "false"]
    };
    var attr = styleAttributes[group.style];
    node2.setAttribute("scriptlevel", attr[0]);
    node2.setAttribute("displaystyle", attr[1]);
    return node2;
  }
});
var htmlBuilderDelegate = function htmlBuilderDelegate2(group, options2) {
  var base = group.base;
  if (!base) {
    return null;
  } else if (base.type === "op") {
    var delegate = base.limits && (options2.style.size === Style$1.DISPLAY.size || base.alwaysHandleSupSub);
    return delegate ? htmlBuilder$2 : null;
  } else if (base.type === "operatorname") {
    var _delegate = base.alwaysHandleSupSub && (options2.style.size === Style$1.DISPLAY.size || base.limits);
    return _delegate ? htmlBuilder$1 : null;
  } else if (base.type === "accent") {
    return utils.isCharacterBox(base.base) ? htmlBuilder$a : null;
  } else if (base.type === "horizBrace") {
    var isSup = !group.sub;
    return isSup === base.isOver ? htmlBuilder$3 : null;
  } else {
    return null;
  }
};
defineFunctionBuilders({
  type: "supsub",
  htmlBuilder(group, options2) {
    var builderDelegate = htmlBuilderDelegate(group, options2);
    if (builderDelegate) {
      return builderDelegate(group, options2);
    }
    var {
      base: valueBase,
      sup: valueSup,
      sub: valueSub
    } = group;
    var base = buildGroup$1(valueBase, options2);
    var supm;
    var subm;
    var metrics = options2.fontMetrics();
    var supShift = 0;
    var subShift = 0;
    var isCharacterBox3 = valueBase && utils.isCharacterBox(valueBase);
    if (valueSup) {
      var newOptions = options2.havingStyle(options2.style.sup());
      supm = buildGroup$1(valueSup, newOptions, options2);
      if (!isCharacterBox3) {
        supShift = base.height - newOptions.fontMetrics().supDrop * newOptions.sizeMultiplier / options2.sizeMultiplier;
      }
    }
    if (valueSub) {
      var _newOptions = options2.havingStyle(options2.style.sub());
      subm = buildGroup$1(valueSub, _newOptions, options2);
      if (!isCharacterBox3) {
        subShift = base.depth + _newOptions.fontMetrics().subDrop * _newOptions.sizeMultiplier / options2.sizeMultiplier;
      }
    }
    var minSupShift;
    if (options2.style === Style$1.DISPLAY) {
      minSupShift = metrics.sup1;
    } else if (options2.style.cramped) {
      minSupShift = metrics.sup3;
    } else {
      minSupShift = metrics.sup2;
    }
    var multiplier = options2.sizeMultiplier;
    var marginRight = makeEm(0.5 / metrics.ptPerEm / multiplier);
    var marginLeft = null;
    if (subm) {
      var isOiint = group.base && group.base.type === "op" && group.base.name && (group.base.name === "\\oiint" || group.base.name === "\\oiiint");
      if (base instanceof SymbolNode || isOiint) {
        marginLeft = makeEm(-base.italic);
      }
    }
    var supsub;
    if (supm && subm) {
      supShift = Math.max(supShift, minSupShift, supm.depth + 0.25 * metrics.xHeight);
      subShift = Math.max(subShift, metrics.sub2);
      var ruleWidth = metrics.defaultRuleThickness;
      var maxWidth = 4 * ruleWidth;
      if (supShift - supm.depth - (subm.height - subShift) < maxWidth) {
        subShift = maxWidth - (supShift - supm.depth) + subm.height;
        var psi = 0.8 * metrics.xHeight - (supShift - supm.depth);
        if (psi > 0) {
          supShift += psi;
          subShift -= psi;
        }
      }
      var vlistElem = [{
        type: "elem",
        elem: subm,
        shift: subShift,
        marginRight,
        marginLeft
      }, {
        type: "elem",
        elem: supm,
        shift: -supShift,
        marginRight
      }];
      supsub = buildCommon.makeVList({
        positionType: "individualShift",
        children: vlistElem
      }, options2);
    } else if (subm) {
      subShift = Math.max(subShift, metrics.sub1, subm.height - 0.8 * metrics.xHeight);
      var _vlistElem = [{
        type: "elem",
        elem: subm,
        marginLeft,
        marginRight
      }];
      supsub = buildCommon.makeVList({
        positionType: "shift",
        positionData: subShift,
        children: _vlistElem
      }, options2);
    } else if (supm) {
      supShift = Math.max(supShift, minSupShift, supm.depth + 0.25 * metrics.xHeight);
      supsub = buildCommon.makeVList({
        positionType: "shift",
        positionData: -supShift,
        children: [{
          type: "elem",
          elem: supm,
          marginRight
        }]
      }, options2);
    } else {
      throw new Error("supsub must have either sup or sub.");
    }
    var mclass = getTypeOfDomTree(base, "right") || "mord";
    return buildCommon.makeSpan([mclass], [base, buildCommon.makeSpan(["msupsub"], [supsub])], options2);
  },
  mathmlBuilder(group, options2) {
    var isBrace = false;
    var isOver;
    var isSup;
    if (group.base && group.base.type === "horizBrace") {
      isSup = !!group.sup;
      if (isSup === group.base.isOver) {
        isBrace = true;
        isOver = group.base.isOver;
      }
    }
    if (group.base && (group.base.type === "op" || group.base.type === "operatorname")) {
      group.base.parentIsSupSub = true;
    }
    var children = [buildGroup2(group.base, options2)];
    if (group.sub) {
      children.push(buildGroup2(group.sub, options2));
    }
    if (group.sup) {
      children.push(buildGroup2(group.sup, options2));
    }
    var nodeType;
    if (isBrace) {
      nodeType = isOver ? "mover" : "munder";
    } else if (!group.sub) {
      var base = group.base;
      if (base && base.type === "op" && base.limits && (options2.style === Style$1.DISPLAY || base.alwaysHandleSupSub)) {
        nodeType = "mover";
      } else if (base && base.type === "operatorname" && base.alwaysHandleSupSub && (base.limits || options2.style === Style$1.DISPLAY)) {
        nodeType = "mover";
      } else {
        nodeType = "msup";
      }
    } else if (!group.sup) {
      var _base = group.base;
      if (_base && _base.type === "op" && _base.limits && (options2.style === Style$1.DISPLAY || _base.alwaysHandleSupSub)) {
        nodeType = "munder";
      } else if (_base && _base.type === "operatorname" && _base.alwaysHandleSupSub && (_base.limits || options2.style === Style$1.DISPLAY)) {
        nodeType = "munder";
      } else {
        nodeType = "msub";
      }
    } else {
      var _base2 = group.base;
      if (_base2 && _base2.type === "op" && _base2.limits && options2.style === Style$1.DISPLAY) {
        nodeType = "munderover";
      } else if (_base2 && _base2.type === "operatorname" && _base2.alwaysHandleSupSub && (options2.style === Style$1.DISPLAY || _base2.limits)) {
        nodeType = "munderover";
      } else {
        nodeType = "msubsup";
      }
    }
    return new mathMLTree.MathNode(nodeType, children);
  }
});
defineFunctionBuilders({
  type: "atom",
  htmlBuilder(group, options2) {
    return buildCommon.mathsym(group.text, group.mode, options2, ["m" + group.family]);
  },
  mathmlBuilder(group, options2) {
    var node2 = new mathMLTree.MathNode("mo", [makeText(group.text, group.mode)]);
    if (group.family === "bin") {
      var variant = getVariant(group, options2);
      if (variant === "bold-italic") {
        node2.setAttribute("mathvariant", variant);
      }
    } else if (group.family === "punct") {
      node2.setAttribute("separator", "true");
    } else if (group.family === "open" || group.family === "close") {
      node2.setAttribute("stretchy", "false");
    }
    return node2;
  }
});
var defaultVariant = {
  "mi": "italic",
  "mn": "normal",
  "mtext": "normal"
};
defineFunctionBuilders({
  type: "mathord",
  htmlBuilder(group, options2) {
    return buildCommon.makeOrd(group, options2, "mathord");
  },
  mathmlBuilder(group, options2) {
    var node2 = new mathMLTree.MathNode("mi", [makeText(group.text, group.mode, options2)]);
    var variant = getVariant(group, options2) || "italic";
    if (variant !== defaultVariant[node2.type]) {
      node2.setAttribute("mathvariant", variant);
    }
    return node2;
  }
});
defineFunctionBuilders({
  type: "textord",
  htmlBuilder(group, options2) {
    return buildCommon.makeOrd(group, options2, "textord");
  },
  mathmlBuilder(group, options2) {
    var text2 = makeText(group.text, group.mode, options2);
    var variant = getVariant(group, options2) || "normal";
    var node2;
    if (group.mode === "text") {
      node2 = new mathMLTree.MathNode("mtext", [text2]);
    } else if (/[0-9]/.test(group.text)) {
      node2 = new mathMLTree.MathNode("mn", [text2]);
    } else if (group.text === "\\prime") {
      node2 = new mathMLTree.MathNode("mo", [text2]);
    } else {
      node2 = new mathMLTree.MathNode("mi", [text2]);
    }
    if (variant !== defaultVariant[node2.type]) {
      node2.setAttribute("mathvariant", variant);
    }
    return node2;
  }
});
var cssSpace = {
  "\\nobreak": "nobreak",
  "\\allowbreak": "allowbreak"
};
var regularSpace = {
  " ": {},
  "\\ ": {},
  "~": {
    className: "nobreak"
  },
  "\\space": {},
  "\\nobreakspace": {
    className: "nobreak"
  }
};
defineFunctionBuilders({
  type: "spacing",
  htmlBuilder(group, options2) {
    if (regularSpace.hasOwnProperty(group.text)) {
      var className = regularSpace[group.text].className || "";
      if (group.mode === "text") {
        var ord = buildCommon.makeOrd(group, options2, "textord");
        ord.classes.push(className);
        return ord;
      } else {
        return buildCommon.makeSpan(["mspace", className], [buildCommon.mathsym(group.text, group.mode, options2)], options2);
      }
    } else if (cssSpace.hasOwnProperty(group.text)) {
      return buildCommon.makeSpan(["mspace", cssSpace[group.text]], [], options2);
    } else {
      throw new ParseError('Unknown type of space "' + group.text + '"');
    }
  },
  mathmlBuilder(group, options2) {
    var node2;
    if (regularSpace.hasOwnProperty(group.text)) {
      node2 = new mathMLTree.MathNode("mtext", [new mathMLTree.TextNode(" ")]);
    } else if (cssSpace.hasOwnProperty(group.text)) {
      return new mathMLTree.MathNode("mspace");
    } else {
      throw new ParseError('Unknown type of space "' + group.text + '"');
    }
    return node2;
  }
});
var pad = () => {
  var padNode = new mathMLTree.MathNode("mtd", []);
  padNode.setAttribute("width", "50%");
  return padNode;
};
defineFunctionBuilders({
  type: "tag",
  mathmlBuilder(group, options2) {
    var table = new mathMLTree.MathNode("mtable", [new mathMLTree.MathNode("mtr", [pad(), new mathMLTree.MathNode("mtd", [buildExpressionRow(group.body, options2)]), pad(), new mathMLTree.MathNode("mtd", [buildExpressionRow(group.tag, options2)])])]);
    table.setAttribute("width", "100%");
    return table;
  }
});
var textFontFamilies = {
  "\\text": void 0,
  "\\textrm": "textrm",
  "\\textsf": "textsf",
  "\\texttt": "texttt",
  "\\textnormal": "textrm"
};
var textFontWeights = {
  "\\textbf": "textbf",
  "\\textmd": "textmd"
};
var textFontShapes = {
  "\\textit": "textit",
  "\\textup": "textup"
};
var optionsWithFont = (group, options2) => {
  var font = group.font;
  if (!font) {
    return options2;
  } else if (textFontFamilies[font]) {
    return options2.withTextFontFamily(textFontFamilies[font]);
  } else if (textFontWeights[font]) {
    return options2.withTextFontWeight(textFontWeights[font]);
  } else {
    return options2.withTextFontShape(textFontShapes[font]);
  }
};
defineFunction({
  type: "text",
  names: [
    // Font families
    "\\text",
    "\\textrm",
    "\\textsf",
    "\\texttt",
    "\\textnormal",
    // Font weights
    "\\textbf",
    "\\textmd",
    // Font Shapes
    "\\textit",
    "\\textup"
  ],
  props: {
    numArgs: 1,
    argTypes: ["text"],
    allowedInArgument: true,
    allowedInText: true
  },
  handler(_ref, args) {
    var {
      parser,
      funcName
    } = _ref;
    var body = args[0];
    return {
      type: "text",
      mode: parser.mode,
      body: ordargument(body),
      font: funcName
    };
  },
  htmlBuilder(group, options2) {
    var newOptions = optionsWithFont(group, options2);
    var inner2 = buildExpression$1(group.body, newOptions, true);
    return buildCommon.makeSpan(["mord", "text"], inner2, newOptions);
  },
  mathmlBuilder(group, options2) {
    var newOptions = optionsWithFont(group, options2);
    return buildExpressionRow(group.body, newOptions);
  }
});
defineFunction({
  type: "underline",
  names: ["\\underline"],
  props: {
    numArgs: 1,
    allowedInText: true
  },
  handler(_ref, args) {
    var {
      parser
    } = _ref;
    return {
      type: "underline",
      mode: parser.mode,
      body: args[0]
    };
  },
  htmlBuilder(group, options2) {
    var innerGroup = buildGroup$1(group.body, options2);
    var line = buildCommon.makeLineSpan("underline-line", options2);
    var defaultRuleThickness = options2.fontMetrics().defaultRuleThickness;
    var vlist = buildCommon.makeVList({
      positionType: "top",
      positionData: innerGroup.height,
      children: [{
        type: "kern",
        size: defaultRuleThickness
      }, {
        type: "elem",
        elem: line
      }, {
        type: "kern",
        size: 3 * defaultRuleThickness
      }, {
        type: "elem",
        elem: innerGroup
      }]
    }, options2);
    return buildCommon.makeSpan(["mord", "underline"], [vlist], options2);
  },
  mathmlBuilder(group, options2) {
    var operator = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode("‾")]);
    operator.setAttribute("stretchy", "true");
    var node2 = new mathMLTree.MathNode("munder", [buildGroup2(group.body, options2), operator]);
    node2.setAttribute("accentunder", "true");
    return node2;
  }
});
defineFunction({
  type: "vcenter",
  names: ["\\vcenter"],
  props: {
    numArgs: 1,
    argTypes: ["original"],
    // In LaTeX, \vcenter can act only on a box.
    allowedInText: false
  },
  handler(_ref, args) {
    var {
      parser
    } = _ref;
    return {
      type: "vcenter",
      mode: parser.mode,
      body: args[0]
    };
  },
  htmlBuilder(group, options2) {
    var body = buildGroup$1(group.body, options2);
    var axisHeight = options2.fontMetrics().axisHeight;
    var dy = 0.5 * (body.height - axisHeight - (body.depth + axisHeight));
    return buildCommon.makeVList({
      positionType: "shift",
      positionData: dy,
      children: [{
        type: "elem",
        elem: body
      }]
    }, options2);
  },
  mathmlBuilder(group, options2) {
    return new mathMLTree.MathNode("mpadded", [buildGroup2(group.body, options2)], ["vcenter"]);
  }
});
defineFunction({
  type: "verb",
  names: ["\\verb"],
  props: {
    numArgs: 0,
    allowedInText: true
  },
  handler(context, args, optArgs) {
    throw new ParseError("\\verb ended by end of line instead of matching delimiter");
  },
  htmlBuilder(group, options2) {
    var text2 = makeVerb(group);
    var body = [];
    var newOptions = options2.havingStyle(options2.style.text());
    for (var i = 0; i < text2.length; i++) {
      var c = text2[i];
      if (c === "~") {
        c = "\\textasciitilde";
      }
      body.push(buildCommon.makeSymbol(c, "Typewriter-Regular", group.mode, newOptions, ["mord", "texttt"]));
    }
    return buildCommon.makeSpan(["mord", "text"].concat(newOptions.sizingClasses(options2)), buildCommon.tryCombineChars(body), newOptions);
  },
  mathmlBuilder(group, options2) {
    var text2 = new mathMLTree.TextNode(makeVerb(group));
    var node2 = new mathMLTree.MathNode("mtext", [text2]);
    node2.setAttribute("mathvariant", "monospace");
    return node2;
  }
});
var makeVerb = (group) => group.body.replace(/ /g, group.star ? "␣" : " ");
var functions = _functions;
defineMacro("\\noexpand", function(context) {
  var t = context.popToken();
  if (context.isExpandable(t.text)) {
    t.noexpand = true;
    t.treatAsRelax = true;
  }
  return {
    tokens: [t],
    numArgs: 0
  };
});
defineMacro("\\expandafter", function(context) {
  var t = context.popToken();
  context.expandOnce(true);
  return {
    tokens: [t],
    numArgs: 0
  };
});
defineMacro("\\@firstoftwo", function(context) {
  var args = context.consumeArgs(2);
  return {
    tokens: args[0],
    numArgs: 0
  };
});
defineMacro("\\@secondoftwo", function(context) {
  var args = context.consumeArgs(2);
  return {
    tokens: args[1],
    numArgs: 0
  };
});
defineMacro("\\@ifnextchar", function(context) {
  var args = context.consumeArgs(3);
  context.consumeSpaces();
  var nextToken = context.future();
  if (args[0].length === 1 && args[0][0].text === nextToken.text) {
    return {
      tokens: args[1],
      numArgs: 0
    };
  } else {
    return {
      tokens: args[2],
      numArgs: 0
    };
  }
});
defineMacro("\\@ifstar", "\\@ifnextchar *{\\@firstoftwo{#1}}");
defineMacro("\\TextOrMath", function(context) {
  var args = context.consumeArgs(2);
  if (context.mode === "text") {
    return {
      tokens: args[0],
      numArgs: 0
    };
  } else {
    return {
      tokens: args[1],
      numArgs: 0
    };
  }
});
var digitToNumber = {
  "0": 0,
  "1": 1,
  "2": 2,
  "3": 3,
  "4": 4,
  "5": 5,
  "6": 6,
  "7": 7,
  "8": 8,
  "9": 9,
  "a": 10,
  "A": 10,
  "b": 11,
  "B": 11,
  "c": 12,
  "C": 12,
  "d": 13,
  "D": 13,
  "e": 14,
  "E": 14,
  "f": 15,
  "F": 15
};
defineMacro("\\char", function(context) {
  var token = context.popToken();
  var base;
  var number2 = "";
  if (token.text === "'") {
    base = 8;
    token = context.popToken();
  } else if (token.text === '"') {
    base = 16;
    token = context.popToken();
  } else if (token.text === "`") {
    token = context.popToken();
    if (token.text[0] === "\\") {
      number2 = token.text.charCodeAt(1);
    } else if (token.text === "EOF") {
      throw new ParseError("\\char` missing argument");
    } else {
      number2 = token.text.charCodeAt(0);
    }
  } else {
    base = 10;
  }
  if (base) {
    number2 = digitToNumber[token.text];
    if (number2 == null || number2 >= base) {
      throw new ParseError("Invalid base-" + base + " digit " + token.text);
    }
    var digit;
    while ((digit = digitToNumber[context.future().text]) != null && digit < base) {
      number2 *= base;
      number2 += digit;
      context.popToken();
    }
  }
  return "\\@char{" + number2 + "}";
});
var newcommand = (context, existsOK, nonexistsOK) => {
  var arg = context.consumeArg().tokens;
  if (arg.length !== 1) {
    throw new ParseError("\\newcommand's first argument must be a macro name");
  }
  var name = arg[0].text;
  var exists = context.isDefined(name);
  if (exists && !existsOK) {
    throw new ParseError("\\newcommand{" + name + "} attempting to redefine " + (name + "; use \\renewcommand"));
  }
  if (!exists && !nonexistsOK) {
    throw new ParseError("\\renewcommand{" + name + "} when command " + name + " does not yet exist; use \\newcommand");
  }
  var numArgs = 0;
  arg = context.consumeArg().tokens;
  if (arg.length === 1 && arg[0].text === "[") {
    var argText = "";
    var token = context.expandNextToken();
    while (token.text !== "]" && token.text !== "EOF") {
      argText += token.text;
      token = context.expandNextToken();
    }
    if (!argText.match(/^\s*[0-9]+\s*$/)) {
      throw new ParseError("Invalid number of arguments: " + argText);
    }
    numArgs = parseInt(argText);
    arg = context.consumeArg().tokens;
  }
  context.macros.set(name, {
    tokens: arg,
    numArgs
  });
  return "";
};
defineMacro("\\newcommand", (context) => newcommand(context, false, true));
defineMacro("\\renewcommand", (context) => newcommand(context, true, false));
defineMacro("\\providecommand", (context) => newcommand(context, true, true));
defineMacro("\\message", (context) => {
  var arg = context.consumeArgs(1)[0];
  console.log(arg.reverse().map((token) => token.text).join(""));
  return "";
});
defineMacro("\\errmessage", (context) => {
  var arg = context.consumeArgs(1)[0];
  console.error(arg.reverse().map((token) => token.text).join(""));
  return "";
});
defineMacro("\\show", (context) => {
  var tok = context.popToken();
  var name = tok.text;
  console.log(tok, context.macros.get(name), functions[name], symbols.math[name], symbols.text[name]);
  return "";
});
defineMacro("\\bgroup", "{");
defineMacro("\\egroup", "}");
defineMacro("~", "\\nobreakspace");
defineMacro("\\lq", "`");
defineMacro("\\rq", "'");
defineMacro("\\aa", "\\r a");
defineMacro("\\AA", "\\r A");
defineMacro("\\textcopyright", "\\html@mathml{\\textcircled{c}}{\\char`©}");
defineMacro("\\copyright", "\\TextOrMath{\\textcopyright}{\\text{\\textcopyright}}");
defineMacro("\\textregistered", "\\html@mathml{\\textcircled{\\scriptsize R}}{\\char`®}");
defineMacro("ℬ", "\\mathscr{B}");
defineMacro("ℰ", "\\mathscr{E}");
defineMacro("ℱ", "\\mathscr{F}");
defineMacro("ℋ", "\\mathscr{H}");
defineMacro("ℐ", "\\mathscr{I}");
defineMacro("ℒ", "\\mathscr{L}");
defineMacro("ℳ", "\\mathscr{M}");
defineMacro("ℛ", "\\mathscr{R}");
defineMacro("ℭ", "\\mathfrak{C}");
defineMacro("ℌ", "\\mathfrak{H}");
defineMacro("ℨ", "\\mathfrak{Z}");
defineMacro("\\Bbbk", "\\Bbb{k}");
defineMacro("·", "\\cdotp");
defineMacro("\\llap", "\\mathllap{\\textrm{#1}}");
defineMacro("\\rlap", "\\mathrlap{\\textrm{#1}}");
defineMacro("\\clap", "\\mathclap{\\textrm{#1}}");
defineMacro("\\mathstrut", "\\vphantom{(}");
defineMacro("\\underbar", "\\underline{\\text{#1}}");
defineMacro("\\not", '\\html@mathml{\\mathrel{\\mathrlap\\@not}}{\\char"338}');
defineMacro("\\neq", "\\html@mathml{\\mathrel{\\not=}}{\\mathrel{\\char`≠}}");
defineMacro("\\ne", "\\neq");
defineMacro("≠", "\\neq");
defineMacro("\\notin", "\\html@mathml{\\mathrel{{\\in}\\mathllap{/\\mskip1mu}}}{\\mathrel{\\char`∉}}");
defineMacro("∉", "\\notin");
defineMacro("≘", "\\html@mathml{\\mathrel{=\\kern{-1em}\\raisebox{0.4em}{$\\scriptsize\\frown$}}}{\\mathrel{\\char`≘}}");
defineMacro("≙", "\\html@mathml{\\stackrel{\\tiny\\wedge}{=}}{\\mathrel{\\char`≘}}");
defineMacro("≚", "\\html@mathml{\\stackrel{\\tiny\\vee}{=}}{\\mathrel{\\char`≚}}");
defineMacro("≛", "\\html@mathml{\\stackrel{\\scriptsize\\star}{=}}{\\mathrel{\\char`≛}}");
defineMacro("≝", "\\html@mathml{\\stackrel{\\tiny\\mathrm{def}}{=}}{\\mathrel{\\char`≝}}");
defineMacro("≞", "\\html@mathml{\\stackrel{\\tiny\\mathrm{m}}{=}}{\\mathrel{\\char`≞}}");
defineMacro("≟", "\\html@mathml{\\stackrel{\\tiny?}{=}}{\\mathrel{\\char`≟}}");
defineMacro("⟂", "\\perp");
defineMacro("‼", "\\mathclose{!\\mkern-0.8mu!}");
defineMacro("∌", "\\notni");
defineMacro("⌜", "\\ulcorner");
defineMacro("⌝", "\\urcorner");
defineMacro("⌞", "\\llcorner");
defineMacro("⌟", "\\lrcorner");
defineMacro("©", "\\copyright");
defineMacro("®", "\\textregistered");
defineMacro("️", "\\textregistered");
defineMacro("\\ulcorner", '\\html@mathml{\\@ulcorner}{\\mathop{\\char"231c}}');
defineMacro("\\urcorner", '\\html@mathml{\\@urcorner}{\\mathop{\\char"231d}}');
defineMacro("\\llcorner", '\\html@mathml{\\@llcorner}{\\mathop{\\char"231e}}');
defineMacro("\\lrcorner", '\\html@mathml{\\@lrcorner}{\\mathop{\\char"231f}}');
defineMacro("\\vdots", "\\mathord{\\varvdots\\rule{0pt}{15pt}}");
defineMacro("⋮", "\\vdots");
defineMacro("\\varGamma", "\\mathit{\\Gamma}");
defineMacro("\\varDelta", "\\mathit{\\Delta}");
defineMacro("\\varTheta", "\\mathit{\\Theta}");
defineMacro("\\varLambda", "\\mathit{\\Lambda}");
defineMacro("\\varXi", "\\mathit{\\Xi}");
defineMacro("\\varPi", "\\mathit{\\Pi}");
defineMacro("\\varSigma", "\\mathit{\\Sigma}");
defineMacro("\\varUpsilon", "\\mathit{\\Upsilon}");
defineMacro("\\varPhi", "\\mathit{\\Phi}");
defineMacro("\\varPsi", "\\mathit{\\Psi}");
defineMacro("\\varOmega", "\\mathit{\\Omega}");
defineMacro("\\substack", "\\begin{subarray}{c}#1\\end{subarray}");
defineMacro("\\colon", "\\nobreak\\mskip2mu\\mathpunct{}\\mathchoice{\\mkern-3mu}{\\mkern-3mu}{}{}{:}\\mskip6mu\\relax");
defineMacro("\\boxed", "\\fbox{$\\displaystyle{#1}$}");
defineMacro("\\iff", "\\DOTSB\\;\\Longleftrightarrow\\;");
defineMacro("\\implies", "\\DOTSB\\;\\Longrightarrow\\;");
defineMacro("\\impliedby", "\\DOTSB\\;\\Longleftarrow\\;");
var dotsByToken = {
  ",": "\\dotsc",
  "\\not": "\\dotsb",
  // \keybin@ checks for the following:
  "+": "\\dotsb",
  "=": "\\dotsb",
  "<": "\\dotsb",
  ">": "\\dotsb",
  "-": "\\dotsb",
  "*": "\\dotsb",
  ":": "\\dotsb",
  // Symbols whose definition starts with \DOTSB:
  "\\DOTSB": "\\dotsb",
  "\\coprod": "\\dotsb",
  "\\bigvee": "\\dotsb",
  "\\bigwedge": "\\dotsb",
  "\\biguplus": "\\dotsb",
  "\\bigcap": "\\dotsb",
  "\\bigcup": "\\dotsb",
  "\\prod": "\\dotsb",
  "\\sum": "\\dotsb",
  "\\bigotimes": "\\dotsb",
  "\\bigoplus": "\\dotsb",
  "\\bigodot": "\\dotsb",
  "\\bigsqcup": "\\dotsb",
  "\\And": "\\dotsb",
  "\\longrightarrow": "\\dotsb",
  "\\Longrightarrow": "\\dotsb",
  "\\longleftarrow": "\\dotsb",
  "\\Longleftarrow": "\\dotsb",
  "\\longleftrightarrow": "\\dotsb",
  "\\Longleftrightarrow": "\\dotsb",
  "\\mapsto": "\\dotsb",
  "\\longmapsto": "\\dotsb",
  "\\hookrightarrow": "\\dotsb",
  "\\doteq": "\\dotsb",
  // Symbols whose definition starts with \mathbin:
  "\\mathbin": "\\dotsb",
  // Symbols whose definition starts with \mathrel:
  "\\mathrel": "\\dotsb",
  "\\relbar": "\\dotsb",
  "\\Relbar": "\\dotsb",
  "\\xrightarrow": "\\dotsb",
  "\\xleftarrow": "\\dotsb",
  // Symbols whose definition starts with \DOTSI:
  "\\DOTSI": "\\dotsi",
  "\\int": "\\dotsi",
  "\\oint": "\\dotsi",
  "\\iint": "\\dotsi",
  "\\iiint": "\\dotsi",
  "\\iiiint": "\\dotsi",
  "\\idotsint": "\\dotsi",
  // Symbols whose definition starts with \DOTSX:
  "\\DOTSX": "\\dotsx"
};
defineMacro("\\dots", function(context) {
  var thedots = "\\dotso";
  var next = context.expandAfterFuture().text;
  if (next in dotsByToken) {
    thedots = dotsByToken[next];
  } else if (next.slice(0, 4) === "\\not") {
    thedots = "\\dotsb";
  } else if (next in symbols.math) {
    if (utils.contains(["bin", "rel"], symbols.math[next].group)) {
      thedots = "\\dotsb";
    }
  }
  return thedots;
});
var spaceAfterDots = {
  // \rightdelim@ checks for the following:
  ")": true,
  "]": true,
  "\\rbrack": true,
  "\\}": true,
  "\\rbrace": true,
  "\\rangle": true,
  "\\rceil": true,
  "\\rfloor": true,
  "\\rgroup": true,
  "\\rmoustache": true,
  "\\right": true,
  "\\bigr": true,
  "\\biggr": true,
  "\\Bigr": true,
  "\\Biggr": true,
  // \extra@ also tests for the following:
  "$": true,
  // \extrap@ checks for the following:
  ";": true,
  ".": true,
  ",": true
};
defineMacro("\\dotso", function(context) {
  var next = context.future().text;
  if (next in spaceAfterDots) {
    return "\\ldots\\,";
  } else {
    return "\\ldots";
  }
});
defineMacro("\\dotsc", function(context) {
  var next = context.future().text;
  if (next in spaceAfterDots && next !== ",") {
    return "\\ldots\\,";
  } else {
    return "\\ldots";
  }
});
defineMacro("\\cdots", function(context) {
  var next = context.future().text;
  if (next in spaceAfterDots) {
    return "\\@cdots\\,";
  } else {
    return "\\@cdots";
  }
});
defineMacro("\\dotsb", "\\cdots");
defineMacro("\\dotsm", "\\cdots");
defineMacro("\\dotsi", "\\!\\cdots");
defineMacro("\\dotsx", "\\ldots\\,");
defineMacro("\\DOTSI", "\\relax");
defineMacro("\\DOTSB", "\\relax");
defineMacro("\\DOTSX", "\\relax");
defineMacro("\\tmspace", "\\TextOrMath{\\kern#1#3}{\\mskip#1#2}\\relax");
defineMacro("\\,", "\\tmspace+{3mu}{.1667em}");
defineMacro("\\thinspace", "\\,");
defineMacro("\\>", "\\mskip{4mu}");
defineMacro("\\:", "\\tmspace+{4mu}{.2222em}");
defineMacro("\\medspace", "\\:");
defineMacro("\\;", "\\tmspace+{5mu}{.2777em}");
defineMacro("\\thickspace", "\\;");
defineMacro("\\!", "\\tmspace-{3mu}{.1667em}");
defineMacro("\\negthinspace", "\\!");
defineMacro("\\negmedspace", "\\tmspace-{4mu}{.2222em}");
defineMacro("\\negthickspace", "\\tmspace-{5mu}{.277em}");
defineMacro("\\enspace", "\\kern.5em ");
defineMacro("\\enskip", "\\hskip.5em\\relax");
defineMacro("\\quad", "\\hskip1em\\relax");
defineMacro("\\qquad", "\\hskip2em\\relax");
defineMacro("\\tag", "\\@ifstar\\tag@literal\\tag@paren");
defineMacro("\\tag@paren", "\\tag@literal{({#1})}");
defineMacro("\\tag@literal", (context) => {
  if (context.macros.get("\\df@tag")) {
    throw new ParseError("Multiple \\tag");
  }
  return "\\gdef\\df@tag{\\text{#1}}";
});
defineMacro("\\bmod", "\\mathchoice{\\mskip1mu}{\\mskip1mu}{\\mskip5mu}{\\mskip5mu}\\mathbin{\\rm mod}\\mathchoice{\\mskip1mu}{\\mskip1mu}{\\mskip5mu}{\\mskip5mu}");
defineMacro("\\pod", "\\allowbreak\\mathchoice{\\mkern18mu}{\\mkern8mu}{\\mkern8mu}{\\mkern8mu}(#1)");
defineMacro("\\pmod", "\\pod{{\\rm mod}\\mkern6mu#1}");
defineMacro("\\mod", "\\allowbreak\\mathchoice{\\mkern18mu}{\\mkern12mu}{\\mkern12mu}{\\mkern12mu}{\\rm mod}\\,\\,#1");
defineMacro("\\newline", "\\\\\\relax");
defineMacro("\\TeX", "\\textrm{\\html@mathml{T\\kern-.1667em\\raisebox{-.5ex}{E}\\kern-.125emX}{TeX}}");
var latexRaiseA = makeEm(fontMetricsData["Main-Regular"]["T".charCodeAt(0)][1] - 0.7 * fontMetricsData["Main-Regular"]["A".charCodeAt(0)][1]);
defineMacro("\\LaTeX", "\\textrm{\\html@mathml{" + ("L\\kern-.36em\\raisebox{" + latexRaiseA + "}{\\scriptstyle A}") + "\\kern-.15em\\TeX}{LaTeX}}");
defineMacro("\\KaTeX", "\\textrm{\\html@mathml{" + ("K\\kern-.17em\\raisebox{" + latexRaiseA + "}{\\scriptstyle A}") + "\\kern-.15em\\TeX}{KaTeX}}");
defineMacro("\\hspace", "\\@ifstar\\@hspacer\\@hspace");
defineMacro("\\@hspace", "\\hskip #1\\relax");
defineMacro("\\@hspacer", "\\rule{0pt}{0pt}\\hskip #1\\relax");
defineMacro("\\ordinarycolon", ":");
defineMacro("\\vcentcolon", "\\mathrel{\\mathop\\ordinarycolon}");
defineMacro("\\dblcolon", '\\html@mathml{\\mathrel{\\vcentcolon\\mathrel{\\mkern-.9mu}\\vcentcolon}}{\\mathop{\\char"2237}}');
defineMacro("\\coloneqq", '\\html@mathml{\\mathrel{\\vcentcolon\\mathrel{\\mkern-1.2mu}=}}{\\mathop{\\char"2254}}');
defineMacro("\\Coloneqq", '\\html@mathml{\\mathrel{\\dblcolon\\mathrel{\\mkern-1.2mu}=}}{\\mathop{\\char"2237\\char"3d}}');
defineMacro("\\coloneq", '\\html@mathml{\\mathrel{\\vc